/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleEdgecontainerNodePoolConfig extends cdktf.TerraformMetaArguments {
    /**
    * The name of the target Distributed Cloud Edge Cluster.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_edgecontainer_node_pool#cluster GoogleEdgecontainerNodePool#cluster}
    */
    readonly cluster: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_edgecontainer_node_pool#id GoogleEdgecontainerNodePool#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Labels associated with this resource.
    *
    * **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
    * Please refer to the field 'effective_labels' for all of the labels present on the resource.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_edgecontainer_node_pool#labels GoogleEdgecontainerNodePool#labels}
    */
    readonly labels?: {
        [key: string]: string;
    };
    /**
    * The location of the resource.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_edgecontainer_node_pool#location GoogleEdgecontainerNodePool#location}
    */
    readonly location: string;
    /**
    * Only machines matching this filter will be allowed to join the node pool.
    * The filtering language accepts strings like "name=<name>", and is
    * documented in more detail in [AIP-160](https://google.aip.dev/160).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_edgecontainer_node_pool#machine_filter GoogleEdgecontainerNodePool#machine_filter}
    */
    readonly machineFilter?: string;
    /**
    * The resource name of the node pool.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_edgecontainer_node_pool#name GoogleEdgecontainerNodePool#name}
    */
    readonly name: string;
    /**
    * The number of nodes in the pool.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_edgecontainer_node_pool#node_count GoogleEdgecontainerNodePool#node_count}
    */
    readonly nodeCount: number;
    /**
    * Name of the Google Distributed Cloud Edge zone where this node pool will be created. For example: 'us-central1-edge-customer-a'.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_edgecontainer_node_pool#node_location GoogleEdgecontainerNodePool#node_location}
    */
    readonly nodeLocation: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_edgecontainer_node_pool#project GoogleEdgecontainerNodePool#project}
    */
    readonly project?: string;
    /**
    * local_disk_encryption block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_edgecontainer_node_pool#local_disk_encryption GoogleEdgecontainerNodePool#local_disk_encryption}
    */
    readonly localDiskEncryption?: GoogleEdgecontainerNodePoolLocalDiskEncryption;
    /**
    * node_config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_edgecontainer_node_pool#node_config GoogleEdgecontainerNodePool#node_config}
    */
    readonly nodeConfig?: GoogleEdgecontainerNodePoolNodeConfig;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_edgecontainer_node_pool#timeouts GoogleEdgecontainerNodePool#timeouts}
    */
    readonly timeouts?: GoogleEdgecontainerNodePoolTimeouts;
}
export interface GoogleEdgecontainerNodePoolLocalDiskEncryption {
    /**
    * The Cloud KMS CryptoKey e.g. projects/{project}/locations/{location}/keyRings/{keyRing}/cryptoKeys/{cryptoKey} to use for protecting node local disks.
    * If not specified, a Google-managed key will be used instead.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_edgecontainer_node_pool#kms_key GoogleEdgecontainerNodePool#kms_key}
    */
    readonly kmsKey?: string;
}
export declare function googleEdgecontainerNodePoolLocalDiskEncryptionToTerraform(struct?: GoogleEdgecontainerNodePoolLocalDiskEncryptionOutputReference | GoogleEdgecontainerNodePoolLocalDiskEncryption): any;
export declare function googleEdgecontainerNodePoolLocalDiskEncryptionToHclTerraform(struct?: GoogleEdgecontainerNodePoolLocalDiskEncryptionOutputReference | GoogleEdgecontainerNodePoolLocalDiskEncryption): any;
export declare class GoogleEdgecontainerNodePoolLocalDiskEncryptionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleEdgecontainerNodePoolLocalDiskEncryption | undefined;
    set internalValue(value: GoogleEdgecontainerNodePoolLocalDiskEncryption | undefined);
    private _kmsKey?;
    get kmsKey(): string;
    set kmsKey(value: string);
    resetKmsKey(): void;
    get kmsKeyInput(): string | undefined;
    get kmsKeyActiveVersion(): string;
    get kmsKeyState(): string;
}
export interface GoogleEdgecontainerNodePoolNodeConfig {
    /**
    * "The Kubernetes node labels"
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_edgecontainer_node_pool#labels GoogleEdgecontainerNodePool#labels}
    */
    readonly labels?: {
        [key: string]: string;
    };
}
export declare function googleEdgecontainerNodePoolNodeConfigToTerraform(struct?: GoogleEdgecontainerNodePoolNodeConfigOutputReference | GoogleEdgecontainerNodePoolNodeConfig): any;
export declare function googleEdgecontainerNodePoolNodeConfigToHclTerraform(struct?: GoogleEdgecontainerNodePoolNodeConfigOutputReference | GoogleEdgecontainerNodePoolNodeConfig): any;
export declare class GoogleEdgecontainerNodePoolNodeConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleEdgecontainerNodePoolNodeConfig | undefined;
    set internalValue(value: GoogleEdgecontainerNodePoolNodeConfig | undefined);
    private _labels?;
    get labels(): {
        [key: string]: string;
    };
    set labels(value: {
        [key: string]: string;
    });
    resetLabels(): void;
    get labelsInput(): {
        [key: string]: string;
    } | undefined;
}
export interface GoogleEdgecontainerNodePoolTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_edgecontainer_node_pool#create GoogleEdgecontainerNodePool#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_edgecontainer_node_pool#delete GoogleEdgecontainerNodePool#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_edgecontainer_node_pool#update GoogleEdgecontainerNodePool#update}
    */
    readonly update?: string;
}
export declare function googleEdgecontainerNodePoolTimeoutsToTerraform(struct?: GoogleEdgecontainerNodePoolTimeouts | cdktf.IResolvable): any;
export declare function googleEdgecontainerNodePoolTimeoutsToHclTerraform(struct?: GoogleEdgecontainerNodePoolTimeouts | cdktf.IResolvable): any;
export declare class GoogleEdgecontainerNodePoolTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleEdgecontainerNodePoolTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleEdgecontainerNodePoolTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_edgecontainer_node_pool google_edgecontainer_node_pool}
*/
export declare class GoogleEdgecontainerNodePool extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_edgecontainer_node_pool";
    /**
    * Generates CDKTF code for importing a GoogleEdgecontainerNodePool resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the GoogleEdgecontainerNodePool to import
    * @param importFromId The id of the existing GoogleEdgecontainerNodePool that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_edgecontainer_node_pool#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the GoogleEdgecontainerNodePool to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_edgecontainer_node_pool google_edgecontainer_node_pool} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleEdgecontainerNodePoolConfig
    */
    constructor(scope: Construct, id: string, config: GoogleEdgecontainerNodePoolConfig);
    private _cluster?;
    get cluster(): string;
    set cluster(value: string);
    get clusterInput(): string | undefined;
    get createTime(): string;
    private _effectiveLabels;
    get effectiveLabels(): cdktf.StringMap;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _labels?;
    get labels(): {
        [key: string]: string;
    };
    set labels(value: {
        [key: string]: string;
    });
    resetLabels(): void;
    get labelsInput(): {
        [key: string]: string;
    } | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _machineFilter?;
    get machineFilter(): string;
    set machineFilter(value: string);
    resetMachineFilter(): void;
    get machineFilterInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _nodeCount?;
    get nodeCount(): number;
    set nodeCount(value: number);
    get nodeCountInput(): number | undefined;
    private _nodeLocation?;
    get nodeLocation(): string;
    set nodeLocation(value: string);
    get nodeLocationInput(): string | undefined;
    get nodeVersion(): string;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _terraformLabels;
    get terraformLabels(): cdktf.StringMap;
    get updateTime(): string;
    private _localDiskEncryption;
    get localDiskEncryption(): GoogleEdgecontainerNodePoolLocalDiskEncryptionOutputReference;
    putLocalDiskEncryption(value: GoogleEdgecontainerNodePoolLocalDiskEncryption): void;
    resetLocalDiskEncryption(): void;
    get localDiskEncryptionInput(): GoogleEdgecontainerNodePoolLocalDiskEncryption | undefined;
    private _nodeConfig;
    get nodeConfig(): GoogleEdgecontainerNodePoolNodeConfigOutputReference;
    putNodeConfig(value: GoogleEdgecontainerNodePoolNodeConfig): void;
    resetNodeConfig(): void;
    get nodeConfigInput(): GoogleEdgecontainerNodePoolNodeConfig | undefined;
    private _timeouts;
    get timeouts(): GoogleEdgecontainerNodePoolTimeoutsOutputReference;
    putTimeouts(value: GoogleEdgecontainerNodePoolTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleEdgecontainerNodePoolTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
