/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleEdgecontainerVpnConnectionConfig extends cdktf.TerraformMetaArguments {
    /**
    * The canonical Cluster name to connect to. It is in the form of projects/{project}/locations/{location}/clusters/{cluster}.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_edgecontainer_vpn_connection#cluster GoogleEdgecontainerVpnConnection#cluster}
    */
    readonly cluster: string;
    /**
    * Whether this VPN connection has HA enabled on cluster side. If enabled, when creating VPN connection we will attempt to use 2 ANG floating IPs.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_edgecontainer_vpn_connection#enable_high_availability GoogleEdgecontainerVpnConnection#enable_high_availability}
    */
    readonly enableHighAvailability?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_edgecontainer_vpn_connection#id GoogleEdgecontainerVpnConnection#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Labels associated with this resource.
    *
    * **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
    * Please refer to the field 'effective_labels' for all of the labels present on the resource.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_edgecontainer_vpn_connection#labels GoogleEdgecontainerVpnConnection#labels}
    */
    readonly labels?: {
        [key: string]: string;
    };
    /**
    * Google Cloud Platform location.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_edgecontainer_vpn_connection#location GoogleEdgecontainerVpnConnection#location}
    */
    readonly location: string;
    /**
    * The resource name of VPN connection
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_edgecontainer_vpn_connection#name GoogleEdgecontainerVpnConnection#name}
    */
    readonly name: string;
    /**
    * NAT gateway IP, or WAN IP address. If a customer has multiple NAT IPs, the customer needs to configure NAT such that only one external IP maps to the GMEC Anthos cluster.
    * This is empty if NAT is not used.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_edgecontainer_vpn_connection#nat_gateway_ip GoogleEdgecontainerVpnConnection#nat_gateway_ip}
    */
    readonly natGatewayIp?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_edgecontainer_vpn_connection#project GoogleEdgecontainerVpnConnection#project}
    */
    readonly project?: string;
    /**
    * The VPN connection Cloud Router name.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_edgecontainer_vpn_connection#router GoogleEdgecontainerVpnConnection#router}
    */
    readonly router?: string;
    /**
    * The network ID of VPC to connect to.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_edgecontainer_vpn_connection#vpc GoogleEdgecontainerVpnConnection#vpc}
    */
    readonly vpc?: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_edgecontainer_vpn_connection#timeouts GoogleEdgecontainerVpnConnection#timeouts}
    */
    readonly timeouts?: GoogleEdgecontainerVpnConnectionTimeouts;
    /**
    * vpc_project block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_edgecontainer_vpn_connection#vpc_project GoogleEdgecontainerVpnConnection#vpc_project}
    */
    readonly vpcProject?: GoogleEdgecontainerVpnConnectionVpcProject;
}
export interface GoogleEdgecontainerVpnConnectionDetailsCloudRouter {
}
export declare function googleEdgecontainerVpnConnectionDetailsCloudRouterToTerraform(struct?: GoogleEdgecontainerVpnConnectionDetailsCloudRouter): any;
export declare function googleEdgecontainerVpnConnectionDetailsCloudRouterToHclTerraform(struct?: GoogleEdgecontainerVpnConnectionDetailsCloudRouter): any;
export declare class GoogleEdgecontainerVpnConnectionDetailsCloudRouterOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleEdgecontainerVpnConnectionDetailsCloudRouter | undefined;
    set internalValue(value: GoogleEdgecontainerVpnConnectionDetailsCloudRouter | undefined);
    get name(): string;
}
export declare class GoogleEdgecontainerVpnConnectionDetailsCloudRouterList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleEdgecontainerVpnConnectionDetailsCloudRouterOutputReference;
}
export interface GoogleEdgecontainerVpnConnectionDetailsCloudVpns {
}
export declare function googleEdgecontainerVpnConnectionDetailsCloudVpnsToTerraform(struct?: GoogleEdgecontainerVpnConnectionDetailsCloudVpns): any;
export declare function googleEdgecontainerVpnConnectionDetailsCloudVpnsToHclTerraform(struct?: GoogleEdgecontainerVpnConnectionDetailsCloudVpns): any;
export declare class GoogleEdgecontainerVpnConnectionDetailsCloudVpnsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleEdgecontainerVpnConnectionDetailsCloudVpns | undefined;
    set internalValue(value: GoogleEdgecontainerVpnConnectionDetailsCloudVpns | undefined);
    get gateway(): string;
}
export declare class GoogleEdgecontainerVpnConnectionDetailsCloudVpnsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleEdgecontainerVpnConnectionDetailsCloudVpnsOutputReference;
}
export interface GoogleEdgecontainerVpnConnectionDetails {
}
export declare function googleEdgecontainerVpnConnectionDetailsToTerraform(struct?: GoogleEdgecontainerVpnConnectionDetails): any;
export declare function googleEdgecontainerVpnConnectionDetailsToHclTerraform(struct?: GoogleEdgecontainerVpnConnectionDetails): any;
export declare class GoogleEdgecontainerVpnConnectionDetailsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleEdgecontainerVpnConnectionDetails | undefined;
    set internalValue(value: GoogleEdgecontainerVpnConnectionDetails | undefined);
    private _cloudRouter;
    get cloudRouter(): GoogleEdgecontainerVpnConnectionDetailsCloudRouterList;
    private _cloudVpns;
    get cloudVpns(): GoogleEdgecontainerVpnConnectionDetailsCloudVpnsList;
    get error(): string;
    get state(): string;
}
export declare class GoogleEdgecontainerVpnConnectionDetailsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleEdgecontainerVpnConnectionDetailsOutputReference;
}
export interface GoogleEdgecontainerVpnConnectionTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_edgecontainer_vpn_connection#create GoogleEdgecontainerVpnConnection#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_edgecontainer_vpn_connection#delete GoogleEdgecontainerVpnConnection#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_edgecontainer_vpn_connection#update GoogleEdgecontainerVpnConnection#update}
    */
    readonly update?: string;
}
export declare function googleEdgecontainerVpnConnectionTimeoutsToTerraform(struct?: GoogleEdgecontainerVpnConnectionTimeouts | cdktf.IResolvable): any;
export declare function googleEdgecontainerVpnConnectionTimeoutsToHclTerraform(struct?: GoogleEdgecontainerVpnConnectionTimeouts | cdktf.IResolvable): any;
export declare class GoogleEdgecontainerVpnConnectionTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleEdgecontainerVpnConnectionTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleEdgecontainerVpnConnectionTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
export interface GoogleEdgecontainerVpnConnectionVpcProject {
    /**
    * The project of the VPC to connect to. If not specified, it is the same as the cluster project.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_edgecontainer_vpn_connection#project_id GoogleEdgecontainerVpnConnection#project_id}
    */
    readonly projectId?: string;
}
export declare function googleEdgecontainerVpnConnectionVpcProjectToTerraform(struct?: GoogleEdgecontainerVpnConnectionVpcProjectOutputReference | GoogleEdgecontainerVpnConnectionVpcProject): any;
export declare function googleEdgecontainerVpnConnectionVpcProjectToHclTerraform(struct?: GoogleEdgecontainerVpnConnectionVpcProjectOutputReference | GoogleEdgecontainerVpnConnectionVpcProject): any;
export declare class GoogleEdgecontainerVpnConnectionVpcProjectOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleEdgecontainerVpnConnectionVpcProject | undefined;
    set internalValue(value: GoogleEdgecontainerVpnConnectionVpcProject | undefined);
    private _projectId?;
    get projectId(): string;
    set projectId(value: string);
    resetProjectId(): void;
    get projectIdInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_edgecontainer_vpn_connection google_edgecontainer_vpn_connection}
*/
export declare class GoogleEdgecontainerVpnConnection extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_edgecontainer_vpn_connection";
    /**
    * Generates CDKTF code for importing a GoogleEdgecontainerVpnConnection resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the GoogleEdgecontainerVpnConnection to import
    * @param importFromId The id of the existing GoogleEdgecontainerVpnConnection that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_edgecontainer_vpn_connection#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the GoogleEdgecontainerVpnConnection to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_edgecontainer_vpn_connection google_edgecontainer_vpn_connection} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleEdgecontainerVpnConnectionConfig
    */
    constructor(scope: Construct, id: string, config: GoogleEdgecontainerVpnConnectionConfig);
    private _cluster?;
    get cluster(): string;
    set cluster(value: string);
    get clusterInput(): string | undefined;
    get createTime(): string;
    private _details;
    get details(): GoogleEdgecontainerVpnConnectionDetailsList;
    private _effectiveLabels;
    get effectiveLabels(): cdktf.StringMap;
    private _enableHighAvailability?;
    get enableHighAvailability(): boolean | cdktf.IResolvable;
    set enableHighAvailability(value: boolean | cdktf.IResolvable);
    resetEnableHighAvailability(): void;
    get enableHighAvailabilityInput(): boolean | cdktf.IResolvable | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _labels?;
    get labels(): {
        [key: string]: string;
    };
    set labels(value: {
        [key: string]: string;
    });
    resetLabels(): void;
    get labelsInput(): {
        [key: string]: string;
    } | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _natGatewayIp?;
    get natGatewayIp(): string;
    set natGatewayIp(value: string);
    resetNatGatewayIp(): void;
    get natGatewayIpInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _router?;
    get router(): string;
    set router(value: string);
    resetRouter(): void;
    get routerInput(): string | undefined;
    private _terraformLabels;
    get terraformLabels(): cdktf.StringMap;
    get updateTime(): string;
    private _vpc?;
    get vpc(): string;
    set vpc(value: string);
    resetVpc(): void;
    get vpcInput(): string | undefined;
    private _timeouts;
    get timeouts(): GoogleEdgecontainerVpnConnectionTimeoutsOutputReference;
    putTimeouts(value: GoogleEdgecontainerVpnConnectionTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleEdgecontainerVpnConnectionTimeouts | undefined;
    private _vpcProject;
    get vpcProject(): GoogleEdgecontainerVpnConnectionVpcProjectOutputReference;
    putVpcProject(value: GoogleEdgecontainerVpnConnectionVpcProject): void;
    resetVpcProject(): void;
    get vpcProjectInput(): GoogleEdgecontainerVpnConnectionVpcProject | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
