/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleEdgenetworkNetworkConfig extends cdktf.TerraformMetaArguments {
    /**
    * A free-text description of the resource. Max length 1024 characters.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_edgenetwork_network#description GoogleEdgenetworkNetwork#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_edgenetwork_network#id GoogleEdgenetworkNetwork#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Labels associated with this resource.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_edgenetwork_network#labels GoogleEdgenetworkNetwork#labels}
    */
    readonly labels?: {
        [key: string]: string;
    };
    /**
    * The Google Cloud region to which the target Distributed Cloud Edge zone belongs.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_edgenetwork_network#location GoogleEdgenetworkNetwork#location}
    */
    readonly location: string;
    /**
    * IP (L3) MTU value of the network. Default value is '1500'. Possible values are: '1500', '9000'.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_edgenetwork_network#mtu GoogleEdgenetworkNetwork#mtu}
    */
    readonly mtu?: number;
    /**
    * A unique ID that identifies this network.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_edgenetwork_network#network_id GoogleEdgenetworkNetwork#network_id}
    */
    readonly networkId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_edgenetwork_network#project GoogleEdgenetworkNetwork#project}
    */
    readonly project?: string;
    /**
    * The name of the target Distributed Cloud Edge zone.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_edgenetwork_network#zone GoogleEdgenetworkNetwork#zone}
    */
    readonly zone: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_edgenetwork_network#timeouts GoogleEdgenetworkNetwork#timeouts}
    */
    readonly timeouts?: GoogleEdgenetworkNetworkTimeouts;
}
export interface GoogleEdgenetworkNetworkTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_edgenetwork_network#create GoogleEdgenetworkNetwork#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_edgenetwork_network#delete GoogleEdgenetworkNetwork#delete}
    */
    readonly delete?: string;
}
export declare function googleEdgenetworkNetworkTimeoutsToTerraform(struct?: GoogleEdgenetworkNetworkTimeouts | cdktf.IResolvable): any;
export declare function googleEdgenetworkNetworkTimeoutsToHclTerraform(struct?: GoogleEdgenetworkNetworkTimeouts | cdktf.IResolvable): any;
export declare class GoogleEdgenetworkNetworkTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleEdgenetworkNetworkTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleEdgenetworkNetworkTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_edgenetwork_network google_edgenetwork_network}
*/
export declare class GoogleEdgenetworkNetwork extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_edgenetwork_network";
    /**
    * Generates CDKTF code for importing a GoogleEdgenetworkNetwork resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the GoogleEdgenetworkNetwork to import
    * @param importFromId The id of the existing GoogleEdgenetworkNetwork that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_edgenetwork_network#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the GoogleEdgenetworkNetwork to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_edgenetwork_network google_edgenetwork_network} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleEdgenetworkNetworkConfig
    */
    constructor(scope: Construct, id: string, config: GoogleEdgenetworkNetworkConfig);
    get createTime(): string;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _labels?;
    get labels(): {
        [key: string]: string;
    };
    set labels(value: {
        [key: string]: string;
    });
    resetLabels(): void;
    get labelsInput(): {
        [key: string]: string;
    } | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _mtu?;
    get mtu(): number;
    set mtu(value: number);
    resetMtu(): void;
    get mtuInput(): number | undefined;
    get name(): string;
    private _networkId?;
    get networkId(): string;
    set networkId(value: string);
    get networkIdInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    get updateTime(): string;
    private _zone?;
    get zone(): string;
    set zone(value: string);
    get zoneInput(): string | undefined;
    private _timeouts;
    get timeouts(): GoogleEdgenetworkNetworkTimeoutsOutputReference;
    putTimeouts(value: GoogleEdgenetworkNetworkTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleEdgenetworkNetworkTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
