/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleEdgenetworkSubnetConfig extends cdktf.TerraformMetaArguments {
    /**
    * A free-text description of the resource. Max length 1024 characters.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_edgenetwork_subnet#description GoogleEdgenetworkSubnet#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_edgenetwork_subnet#id GoogleEdgenetworkSubnet#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The ranges of ipv4 addresses that are owned by this subnetwork, in CIDR format.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_edgenetwork_subnet#ipv4_cidr GoogleEdgenetworkSubnet#ipv4_cidr}
    */
    readonly ipv4Cidr?: string[];
    /**
    * The ranges of ipv6 addresses that are owned by this subnetwork, in CIDR format.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_edgenetwork_subnet#ipv6_cidr GoogleEdgenetworkSubnet#ipv6_cidr}
    */
    readonly ipv6Cidr?: string[];
    /**
    * Labels associated with this resource.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_edgenetwork_subnet#labels GoogleEdgenetworkSubnet#labels}
    */
    readonly labels?: {
        [key: string]: string;
    };
    /**
    * The Google Cloud region to which the target Distributed Cloud Edge zone belongs.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_edgenetwork_subnet#location GoogleEdgenetworkSubnet#location}
    */
    readonly location: string;
    /**
    * The ID of the network to which this router belongs.
    * Must be of the form: 'projects/{{project}}/locations/{{location}}/zones/{{zone}}/networks/{{network_id}}'
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_edgenetwork_subnet#network GoogleEdgenetworkSubnet#network}
    */
    readonly network: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_edgenetwork_subnet#project GoogleEdgenetworkSubnet#project}
    */
    readonly project?: string;
    /**
    * A unique ID that identifies this subnet.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_edgenetwork_subnet#subnet_id GoogleEdgenetworkSubnet#subnet_id}
    */
    readonly subnetId: string;
    /**
    * VLAN ID for this subnetwork. If not specified, one is assigned automatically.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_edgenetwork_subnet#vlan_id GoogleEdgenetworkSubnet#vlan_id}
    */
    readonly vlanId?: number;
    /**
    * The name of the target Distributed Cloud Edge zone.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_edgenetwork_subnet#zone GoogleEdgenetworkSubnet#zone}
    */
    readonly zone: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_edgenetwork_subnet#timeouts GoogleEdgenetworkSubnet#timeouts}
    */
    readonly timeouts?: GoogleEdgenetworkSubnetTimeouts;
}
export interface GoogleEdgenetworkSubnetTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_edgenetwork_subnet#create GoogleEdgenetworkSubnet#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_edgenetwork_subnet#delete GoogleEdgenetworkSubnet#delete}
    */
    readonly delete?: string;
}
export declare function googleEdgenetworkSubnetTimeoutsToTerraform(struct?: GoogleEdgenetworkSubnetTimeouts | cdktf.IResolvable): any;
export declare function googleEdgenetworkSubnetTimeoutsToHclTerraform(struct?: GoogleEdgenetworkSubnetTimeouts | cdktf.IResolvable): any;
export declare class GoogleEdgenetworkSubnetTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleEdgenetworkSubnetTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleEdgenetworkSubnetTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_edgenetwork_subnet google_edgenetwork_subnet}
*/
export declare class GoogleEdgenetworkSubnet extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_edgenetwork_subnet";
    /**
    * Generates CDKTF code for importing a GoogleEdgenetworkSubnet resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the GoogleEdgenetworkSubnet to import
    * @param importFromId The id of the existing GoogleEdgenetworkSubnet that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_edgenetwork_subnet#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the GoogleEdgenetworkSubnet to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_edgenetwork_subnet google_edgenetwork_subnet} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleEdgenetworkSubnetConfig
    */
    constructor(scope: Construct, id: string, config: GoogleEdgenetworkSubnetConfig);
    get createTime(): string;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _ipv4Cidr?;
    get ipv4Cidr(): string[];
    set ipv4Cidr(value: string[]);
    resetIpv4Cidr(): void;
    get ipv4CidrInput(): string[] | undefined;
    private _ipv6Cidr?;
    get ipv6Cidr(): string[];
    set ipv6Cidr(value: string[]);
    resetIpv6Cidr(): void;
    get ipv6CidrInput(): string[] | undefined;
    private _labels?;
    get labels(): {
        [key: string]: string;
    };
    set labels(value: {
        [key: string]: string;
    });
    resetLabels(): void;
    get labelsInput(): {
        [key: string]: string;
    } | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    get name(): string;
    private _network?;
    get network(): string;
    set network(value: string);
    get networkInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    get state(): string;
    private _subnetId?;
    get subnetId(): string;
    set subnetId(value: string);
    get subnetIdInput(): string | undefined;
    get updateTime(): string;
    private _vlanId?;
    get vlanId(): number;
    set vlanId(value: number);
    resetVlanId(): void;
    get vlanIdInput(): number | undefined;
    private _zone?;
    get zone(): string;
    set zone(value: string);
    get zoneInput(): string | undefined;
    private _timeouts;
    get timeouts(): GoogleEdgenetworkSubnetTimeoutsOutputReference;
    putTimeouts(value: GoogleEdgenetworkSubnetTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleEdgenetworkSubnetTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
