/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleEndpointsServiceConfig extends cdktf.TerraformMetaArguments {
    /**
    * The full text of the Service Config YAML file (Example located here). If provided, must also provide protoc_output_base64. open_api config must not be provided.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_endpoints_service#grpc_config GoogleEndpointsService#grpc_config}
    */
    readonly grpcConfig?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_endpoints_service#id GoogleEndpointsService#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The full text of the OpenAPI YAML configuration as described here. Either this, or both of grpc_config and protoc_output_base64 must be specified.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_endpoints_service#openapi_config GoogleEndpointsService#openapi_config}
    */
    readonly openapiConfig?: string;
    /**
    * The project ID that the service belongs to. If not provided, provider project is used.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_endpoints_service#project GoogleEndpointsService#project}
    */
    readonly project?: string;
    /**
    * The full contents of the Service Descriptor File generated by protoc. This should be a compiled .pb file, base64-encoded.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_endpoints_service#protoc_output_base64 GoogleEndpointsService#protoc_output_base64}
    */
    readonly protocOutputBase64?: string;
    /**
    * The name of the service. Usually of the form $apiname.endpoints.$projectid.cloud.goog.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_endpoints_service#service_name GoogleEndpointsService#service_name}
    */
    readonly serviceName: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_endpoints_service#timeouts GoogleEndpointsService#timeouts}
    */
    readonly timeouts?: GoogleEndpointsServiceTimeouts;
}
export interface GoogleEndpointsServiceApisMethods {
}
export declare function googleEndpointsServiceApisMethodsToTerraform(struct?: GoogleEndpointsServiceApisMethods): any;
export declare function googleEndpointsServiceApisMethodsToHclTerraform(struct?: GoogleEndpointsServiceApisMethods): any;
export declare class GoogleEndpointsServiceApisMethodsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleEndpointsServiceApisMethods | undefined;
    set internalValue(value: GoogleEndpointsServiceApisMethods | undefined);
    get name(): string;
    get requestType(): string;
    get responseType(): string;
    get syntax(): string;
}
export declare class GoogleEndpointsServiceApisMethodsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleEndpointsServiceApisMethodsOutputReference;
}
export interface GoogleEndpointsServiceApis {
}
export declare function googleEndpointsServiceApisToTerraform(struct?: GoogleEndpointsServiceApis): any;
export declare function googleEndpointsServiceApisToHclTerraform(struct?: GoogleEndpointsServiceApis): any;
export declare class GoogleEndpointsServiceApisOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleEndpointsServiceApis | undefined;
    set internalValue(value: GoogleEndpointsServiceApis | undefined);
    private _methods;
    get methods(): GoogleEndpointsServiceApisMethodsList;
    get name(): string;
    get syntax(): string;
    get version(): string;
}
export declare class GoogleEndpointsServiceApisList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleEndpointsServiceApisOutputReference;
}
export interface GoogleEndpointsServiceEndpoints {
}
export declare function googleEndpointsServiceEndpointsToTerraform(struct?: GoogleEndpointsServiceEndpoints): any;
export declare function googleEndpointsServiceEndpointsToHclTerraform(struct?: GoogleEndpointsServiceEndpoints): any;
export declare class GoogleEndpointsServiceEndpointsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleEndpointsServiceEndpoints | undefined;
    set internalValue(value: GoogleEndpointsServiceEndpoints | undefined);
    get address(): string;
    get name(): string;
}
export declare class GoogleEndpointsServiceEndpointsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleEndpointsServiceEndpointsOutputReference;
}
export interface GoogleEndpointsServiceTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_endpoints_service#create GoogleEndpointsService#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_endpoints_service#delete GoogleEndpointsService#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_endpoints_service#update GoogleEndpointsService#update}
    */
    readonly update?: string;
}
export declare function googleEndpointsServiceTimeoutsToTerraform(struct?: GoogleEndpointsServiceTimeouts | cdktf.IResolvable): any;
export declare function googleEndpointsServiceTimeoutsToHclTerraform(struct?: GoogleEndpointsServiceTimeouts | cdktf.IResolvable): any;
export declare class GoogleEndpointsServiceTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleEndpointsServiceTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleEndpointsServiceTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_endpoints_service google_endpoints_service}
*/
export declare class GoogleEndpointsService extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_endpoints_service";
    /**
    * Generates CDKTF code for importing a GoogleEndpointsService resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the GoogleEndpointsService to import
    * @param importFromId The id of the existing GoogleEndpointsService that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_endpoints_service#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the GoogleEndpointsService to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_endpoints_service google_endpoints_service} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleEndpointsServiceConfig
    */
    constructor(scope: Construct, id: string, config: GoogleEndpointsServiceConfig);
    private _apis;
    get apis(): GoogleEndpointsServiceApisList;
    get configId(): string;
    get dnsAddress(): string;
    private _endpoints;
    get endpoints(): GoogleEndpointsServiceEndpointsList;
    private _grpcConfig?;
    get grpcConfig(): string;
    set grpcConfig(value: string);
    resetGrpcConfig(): void;
    get grpcConfigInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _openapiConfig?;
    get openapiConfig(): string;
    set openapiConfig(value: string);
    resetOpenapiConfig(): void;
    get openapiConfigInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _protocOutputBase64?;
    get protocOutputBase64(): string;
    set protocOutputBase64(value: string);
    resetProtocOutputBase64(): void;
    get protocOutputBase64Input(): string | undefined;
    private _serviceName?;
    get serviceName(): string;
    set serviceName(value: string);
    get serviceNameInput(): string | undefined;
    private _timeouts;
    get timeouts(): GoogleEndpointsServiceTimeoutsOutputReference;
    putTimeouts(value: GoogleEndpointsServiceTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleEndpointsServiceTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
