/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleEssentialContactsContactConfig extends cdktf.TerraformMetaArguments {
    /**
    * The email address to send notifications to. This does not need to be a Google account.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_essential_contacts_contact#email GoogleEssentialContactsContact#email}
    */
    readonly email: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_essential_contacts_contact#id GoogleEssentialContactsContact#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The preferred language for notifications, as a ISO 639-1 language code. See Supported languages for a list of supported languages.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_essential_contacts_contact#language_tag GoogleEssentialContactsContact#language_tag}
    */
    readonly languageTag: string;
    /**
    * The categories of notifications that the contact will receive communications for.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_essential_contacts_contact#notification_category_subscriptions GoogleEssentialContactsContact#notification_category_subscriptions}
    */
    readonly notificationCategorySubscriptions: string[];
    /**
    * The resource to save this contact for. Format: organizations/{organization_id}, folders/{folder_id} or projects/{project_id}
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_essential_contacts_contact#parent GoogleEssentialContactsContact#parent}
    */
    readonly parent: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_essential_contacts_contact#timeouts GoogleEssentialContactsContact#timeouts}
    */
    readonly timeouts?: GoogleEssentialContactsContactTimeouts;
}
export interface GoogleEssentialContactsContactTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_essential_contacts_contact#create GoogleEssentialContactsContact#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_essential_contacts_contact#delete GoogleEssentialContactsContact#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_essential_contacts_contact#update GoogleEssentialContactsContact#update}
    */
    readonly update?: string;
}
export declare function googleEssentialContactsContactTimeoutsToTerraform(struct?: GoogleEssentialContactsContactTimeouts | cdktf.IResolvable): any;
export declare function googleEssentialContactsContactTimeoutsToHclTerraform(struct?: GoogleEssentialContactsContactTimeouts | cdktf.IResolvable): any;
export declare class GoogleEssentialContactsContactTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleEssentialContactsContactTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleEssentialContactsContactTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_essential_contacts_contact google_essential_contacts_contact}
*/
export declare class GoogleEssentialContactsContact extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_essential_contacts_contact";
    /**
    * Generates CDKTF code for importing a GoogleEssentialContactsContact resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the GoogleEssentialContactsContact to import
    * @param importFromId The id of the existing GoogleEssentialContactsContact that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_essential_contacts_contact#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the GoogleEssentialContactsContact to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_essential_contacts_contact google_essential_contacts_contact} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleEssentialContactsContactConfig
    */
    constructor(scope: Construct, id: string, config: GoogleEssentialContactsContactConfig);
    private _email?;
    get email(): string;
    set email(value: string);
    get emailInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _languageTag?;
    get languageTag(): string;
    set languageTag(value: string);
    get languageTagInput(): string | undefined;
    get name(): string;
    private _notificationCategorySubscriptions?;
    get notificationCategorySubscriptions(): string[];
    set notificationCategorySubscriptions(value: string[]);
    get notificationCategorySubscriptionsInput(): string[] | undefined;
    private _parent?;
    get parent(): string;
    set parent(value: string);
    get parentInput(): string | undefined;
    private _timeouts;
    get timeouts(): GoogleEssentialContactsContactTimeoutsOutputReference;
    putTimeouts(value: GoogleEssentialContactsContactTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleEssentialContactsContactTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
