/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleEventarcChannelConfig extends cdktf.TerraformMetaArguments {
    /**
    * Optional. Resource name of a KMS crypto key (managed by the user) used to encrypt/decrypt their event data. It must match the pattern `projects/* /locations/* /keyRings/* /cryptoKeys/*`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_eventarc_channel#crypto_key_name GoogleEventarcChannel#crypto_key_name}
     *
    * Note: The above comment contained a comment block ending sequence (* followed by /). We have introduced a space between to prevent syntax errors. Please ignore the space.
    */
    readonly cryptoKeyName?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_eventarc_channel#id GoogleEventarcChannel#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The location for the resource
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_eventarc_channel#location GoogleEventarcChannel#location}
    */
    readonly location: string;
    /**
    * Required. The resource name of the channel. Must be unique within the location on the project.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_eventarc_channel#name GoogleEventarcChannel#name}
    */
    readonly name: string;
    /**
    * The project for the resource
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_eventarc_channel#project GoogleEventarcChannel#project}
    */
    readonly project?: string;
    /**
    * The name of the event provider (e.g. Eventarc SaaS partner) associated with the channel. This provider will be granted permissions to publish events to the channel. Format: `projects/{project}/locations/{location}/providers/{provider_id}`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_eventarc_channel#third_party_provider GoogleEventarcChannel#third_party_provider}
    */
    readonly thirdPartyProvider?: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_eventarc_channel#timeouts GoogleEventarcChannel#timeouts}
    */
    readonly timeouts?: GoogleEventarcChannelTimeouts;
}
export interface GoogleEventarcChannelTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_eventarc_channel#create GoogleEventarcChannel#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_eventarc_channel#delete GoogleEventarcChannel#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_eventarc_channel#update GoogleEventarcChannel#update}
    */
    readonly update?: string;
}
export declare function googleEventarcChannelTimeoutsToTerraform(struct?: GoogleEventarcChannelTimeouts | cdktf.IResolvable): any;
export declare function googleEventarcChannelTimeoutsToHclTerraform(struct?: GoogleEventarcChannelTimeouts | cdktf.IResolvable): any;
export declare class GoogleEventarcChannelTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleEventarcChannelTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleEventarcChannelTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_eventarc_channel google_eventarc_channel}
*/
export declare class GoogleEventarcChannel extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_eventarc_channel";
    /**
    * Generates CDKTF code for importing a GoogleEventarcChannel resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the GoogleEventarcChannel to import
    * @param importFromId The id of the existing GoogleEventarcChannel that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_eventarc_channel#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the GoogleEventarcChannel to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_eventarc_channel google_eventarc_channel} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleEventarcChannelConfig
    */
    constructor(scope: Construct, id: string, config: GoogleEventarcChannelConfig);
    get activationToken(): string;
    get createTime(): string;
    private _cryptoKeyName?;
    get cryptoKeyName(): string;
    set cryptoKeyName(value: string);
    resetCryptoKeyName(): void;
    get cryptoKeyNameInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    get pubsubTopic(): string;
    get state(): string;
    private _thirdPartyProvider?;
    get thirdPartyProvider(): string;
    set thirdPartyProvider(value: string);
    resetThirdPartyProvider(): void;
    get thirdPartyProviderInput(): string | undefined;
    get uid(): string;
    get updateTime(): string;
    private _timeouts;
    get timeouts(): GoogleEventarcChannelTimeoutsOutputReference;
    putTimeouts(value: GoogleEventarcChannelTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleEventarcChannelTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
