/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleEventarcTriggerConfig extends cdktf.TerraformMetaArguments {
    /**
    * Optional. The name of the channel associated with the trigger in `projects/{project}/locations/{location}/channels/{channel}` format. You must provide a channel to receive events from Eventarc SaaS partners.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_eventarc_trigger#channel GoogleEventarcTrigger#channel}
    */
    readonly channel?: string;
    /**
    * Optional. EventDataContentType specifies the type of payload in MIME format that is expected from the CloudEvent data field. This is set to `application/json` if the value is not defined.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_eventarc_trigger#event_data_content_type GoogleEventarcTrigger#event_data_content_type}
    */
    readonly eventDataContentType?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_eventarc_trigger#id GoogleEventarcTrigger#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Optional. User labels attached to the triggers that can be used to group resources.
    *
    * **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
    * Please refer to the field `effective_labels` for all of the labels present on the resource.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_eventarc_trigger#labels GoogleEventarcTrigger#labels}
    */
    readonly labels?: {
        [key: string]: string;
    };
    /**
    * The location for the resource
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_eventarc_trigger#location GoogleEventarcTrigger#location}
    */
    readonly location: string;
    /**
    * Required. The resource name of the trigger. Must be unique within the location on the project.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_eventarc_trigger#name GoogleEventarcTrigger#name}
    */
    readonly name: string;
    /**
    * The project for the resource
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_eventarc_trigger#project GoogleEventarcTrigger#project}
    */
    readonly project?: string;
    /**
    * Optional. The IAM service account email associated with the trigger. The service account represents the identity of the trigger. The principal who calls this API must have `iam.serviceAccounts.actAs` permission in the service account. See https://cloud.google.com/iam/docs/understanding-service-accounts#sa_common for more information. For Cloud Run destinations, this service account is used to generate identity tokens when invoking the service. See https://cloud.google.com/run/docs/triggering/pubsub-push#create-service-account for information on how to invoke authenticated Cloud Run services. In order to create Audit Log triggers, the service account should also have `roles/eventarc.eventReceiver` IAM role.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_eventarc_trigger#service_account GoogleEventarcTrigger#service_account}
    */
    readonly serviceAccount?: string;
    /**
    * destination block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_eventarc_trigger#destination GoogleEventarcTrigger#destination}
    */
    readonly destination: GoogleEventarcTriggerDestination;
    /**
    * matching_criteria block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_eventarc_trigger#matching_criteria GoogleEventarcTrigger#matching_criteria}
    */
    readonly matchingCriteria: GoogleEventarcTriggerMatchingCriteria[] | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_eventarc_trigger#timeouts GoogleEventarcTrigger#timeouts}
    */
    readonly timeouts?: GoogleEventarcTriggerTimeouts;
    /**
    * transport block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_eventarc_trigger#transport GoogleEventarcTrigger#transport}
    */
    readonly transport?: GoogleEventarcTriggerTransport;
}
export interface GoogleEventarcTriggerDestinationCloudRunService {
    /**
    * Optional. The relative path on the Cloud Run service the events should be sent to. The value must conform to the definition of URI path segment (section 3.3 of RFC2396). Examples: "/route", "route", "route/subroute".
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_eventarc_trigger#path GoogleEventarcTrigger#path}
    */
    readonly path?: string;
    /**
    * Required. The region the Cloud Run service is deployed in.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_eventarc_trigger#region GoogleEventarcTrigger#region}
    */
    readonly region?: string;
    /**
    * Required. The name of the Cloud Run service being addressed. See https://cloud.google.com/run/docs/reference/rest/v1/namespaces.services. Only services located in the same project of the trigger object can be addressed.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_eventarc_trigger#service GoogleEventarcTrigger#service}
    */
    readonly service: string;
}
export declare function googleEventarcTriggerDestinationCloudRunServiceToTerraform(struct?: GoogleEventarcTriggerDestinationCloudRunServiceOutputReference | GoogleEventarcTriggerDestinationCloudRunService): any;
export declare function googleEventarcTriggerDestinationCloudRunServiceToHclTerraform(struct?: GoogleEventarcTriggerDestinationCloudRunServiceOutputReference | GoogleEventarcTriggerDestinationCloudRunService): any;
export declare class GoogleEventarcTriggerDestinationCloudRunServiceOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleEventarcTriggerDestinationCloudRunService | undefined;
    set internalValue(value: GoogleEventarcTriggerDestinationCloudRunService | undefined);
    private _path?;
    get path(): string;
    set path(value: string);
    resetPath(): void;
    get pathInput(): string | undefined;
    private _region?;
    get region(): string;
    set region(value: string);
    resetRegion(): void;
    get regionInput(): string | undefined;
    private _service?;
    get service(): string;
    set service(value: string);
    get serviceInput(): string | undefined;
}
export interface GoogleEventarcTriggerDestinationGke {
    /**
    * Required. The name of the cluster the GKE service is running in. The cluster must be running in the same project as the trigger being created.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_eventarc_trigger#cluster GoogleEventarcTrigger#cluster}
    */
    readonly cluster: string;
    /**
    * Required. The name of the Google Compute Engine in which the cluster resides, which can either be compute zone (for example, us-central1-a) for the zonal clusters or region (for example, us-central1) for regional clusters.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_eventarc_trigger#location GoogleEventarcTrigger#location}
    */
    readonly location: string;
    /**
    * Required. The namespace the GKE service is running in.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_eventarc_trigger#namespace GoogleEventarcTrigger#namespace}
    */
    readonly namespace: string;
    /**
    * Optional. The relative path on the GKE service the events should be sent to. The value must conform to the definition of a URI path segment (section 3.3 of RFC2396). Examples: "/route", "route", "route/subroute".
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_eventarc_trigger#path GoogleEventarcTrigger#path}
    */
    readonly path?: string;
    /**
    * Required. Name of the GKE service.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_eventarc_trigger#service GoogleEventarcTrigger#service}
    */
    readonly service: string;
}
export declare function googleEventarcTriggerDestinationGkeToTerraform(struct?: GoogleEventarcTriggerDestinationGkeOutputReference | GoogleEventarcTriggerDestinationGke): any;
export declare function googleEventarcTriggerDestinationGkeToHclTerraform(struct?: GoogleEventarcTriggerDestinationGkeOutputReference | GoogleEventarcTriggerDestinationGke): any;
export declare class GoogleEventarcTriggerDestinationGkeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleEventarcTriggerDestinationGke | undefined;
    set internalValue(value: GoogleEventarcTriggerDestinationGke | undefined);
    private _cluster?;
    get cluster(): string;
    set cluster(value: string);
    get clusterInput(): string | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _namespace?;
    get namespace(): string;
    set namespace(value: string);
    get namespaceInput(): string | undefined;
    private _path?;
    get path(): string;
    set path(value: string);
    resetPath(): void;
    get pathInput(): string | undefined;
    private _service?;
    get service(): string;
    set service(value: string);
    get serviceInput(): string | undefined;
}
export interface GoogleEventarcTriggerDestinationHttpEndpoint {
    /**
    * Required. The URI of the HTTP enpdoint. The value must be a RFC2396 URI string. Examples: `http://10.10.10.8:80/route`, `http://svc.us-central1.p.local:8080/`. Only HTTP and HTTPS protocols are supported. The host can be either a static IP addressable from the VPC specified by the network config, or an internal DNS hostname of the service resolvable via Cloud DNS.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_eventarc_trigger#uri GoogleEventarcTrigger#uri}
    */
    readonly uri: string;
}
export declare function googleEventarcTriggerDestinationHttpEndpointToTerraform(struct?: GoogleEventarcTriggerDestinationHttpEndpointOutputReference | GoogleEventarcTriggerDestinationHttpEndpoint): any;
export declare function googleEventarcTriggerDestinationHttpEndpointToHclTerraform(struct?: GoogleEventarcTriggerDestinationHttpEndpointOutputReference | GoogleEventarcTriggerDestinationHttpEndpoint): any;
export declare class GoogleEventarcTriggerDestinationHttpEndpointOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleEventarcTriggerDestinationHttpEndpoint | undefined;
    set internalValue(value: GoogleEventarcTriggerDestinationHttpEndpoint | undefined);
    private _uri?;
    get uri(): string;
    set uri(value: string);
    get uriInput(): string | undefined;
}
export interface GoogleEventarcTriggerDestinationNetworkConfig {
    /**
    * Required. Name of the NetworkAttachment that allows access to the destination VPC. Format: `projects/{PROJECT_ID}/regions/{REGION}/networkAttachments/{NETWORK_ATTACHMENT_NAME}`
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_eventarc_trigger#network_attachment GoogleEventarcTrigger#network_attachment}
    */
    readonly networkAttachment: string;
}
export declare function googleEventarcTriggerDestinationNetworkConfigToTerraform(struct?: GoogleEventarcTriggerDestinationNetworkConfigOutputReference | GoogleEventarcTriggerDestinationNetworkConfig): any;
export declare function googleEventarcTriggerDestinationNetworkConfigToHclTerraform(struct?: GoogleEventarcTriggerDestinationNetworkConfigOutputReference | GoogleEventarcTriggerDestinationNetworkConfig): any;
export declare class GoogleEventarcTriggerDestinationNetworkConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleEventarcTriggerDestinationNetworkConfig | undefined;
    set internalValue(value: GoogleEventarcTriggerDestinationNetworkConfig | undefined);
    private _networkAttachment?;
    get networkAttachment(): string;
    set networkAttachment(value: string);
    get networkAttachmentInput(): string | undefined;
}
export interface GoogleEventarcTriggerDestination {
    /**
    * The resource name of the Workflow whose Executions are triggered by the events. The Workflow resource should be deployed in the same project as the trigger. Format: `projects/{project}/locations/{location}/workflows/{workflow}`
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_eventarc_trigger#workflow GoogleEventarcTrigger#workflow}
    */
    readonly workflow?: string;
    /**
    * cloud_run_service block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_eventarc_trigger#cloud_run_service GoogleEventarcTrigger#cloud_run_service}
    */
    readonly cloudRunService?: GoogleEventarcTriggerDestinationCloudRunService;
    /**
    * gke block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_eventarc_trigger#gke GoogleEventarcTrigger#gke}
    */
    readonly gke?: GoogleEventarcTriggerDestinationGke;
    /**
    * http_endpoint block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_eventarc_trigger#http_endpoint GoogleEventarcTrigger#http_endpoint}
    */
    readonly httpEndpoint?: GoogleEventarcTriggerDestinationHttpEndpoint;
    /**
    * network_config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_eventarc_trigger#network_config GoogleEventarcTrigger#network_config}
    */
    readonly networkConfig?: GoogleEventarcTriggerDestinationNetworkConfig;
}
export declare function googleEventarcTriggerDestinationToTerraform(struct?: GoogleEventarcTriggerDestinationOutputReference | GoogleEventarcTriggerDestination): any;
export declare function googleEventarcTriggerDestinationToHclTerraform(struct?: GoogleEventarcTriggerDestinationOutputReference | GoogleEventarcTriggerDestination): any;
export declare class GoogleEventarcTriggerDestinationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleEventarcTriggerDestination | undefined;
    set internalValue(value: GoogleEventarcTriggerDestination | undefined);
    get cloudFunction(): string;
    private _workflow?;
    get workflow(): string;
    set workflow(value: string);
    resetWorkflow(): void;
    get workflowInput(): string | undefined;
    private _cloudRunService;
    get cloudRunService(): GoogleEventarcTriggerDestinationCloudRunServiceOutputReference;
    putCloudRunService(value: GoogleEventarcTriggerDestinationCloudRunService): void;
    resetCloudRunService(): void;
    get cloudRunServiceInput(): GoogleEventarcTriggerDestinationCloudRunService | undefined;
    private _gke;
    get gke(): GoogleEventarcTriggerDestinationGkeOutputReference;
    putGke(value: GoogleEventarcTriggerDestinationGke): void;
    resetGke(): void;
    get gkeInput(): GoogleEventarcTriggerDestinationGke | undefined;
    private _httpEndpoint;
    get httpEndpoint(): GoogleEventarcTriggerDestinationHttpEndpointOutputReference;
    putHttpEndpoint(value: GoogleEventarcTriggerDestinationHttpEndpoint): void;
    resetHttpEndpoint(): void;
    get httpEndpointInput(): GoogleEventarcTriggerDestinationHttpEndpoint | undefined;
    private _networkConfig;
    get networkConfig(): GoogleEventarcTriggerDestinationNetworkConfigOutputReference;
    putNetworkConfig(value: GoogleEventarcTriggerDestinationNetworkConfig): void;
    resetNetworkConfig(): void;
    get networkConfigInput(): GoogleEventarcTriggerDestinationNetworkConfig | undefined;
}
export interface GoogleEventarcTriggerMatchingCriteria {
    /**
    * Required. The name of a CloudEvents attribute. Currently, only a subset of attributes are supported for filtering. All triggers MUST provide a filter for the 'type' attribute.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_eventarc_trigger#attribute GoogleEventarcTrigger#attribute}
    */
    readonly attribute: string;
    /**
    * Optional. The operator used for matching the events with the value of the filter. If not specified, only events that have an exact key-value pair specified in the filter are matched. The only allowed value is `match-path-pattern`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_eventarc_trigger#operator GoogleEventarcTrigger#operator}
    */
    readonly operator?: string;
    /**
    * Required. The value for the attribute. See https://cloud.google.com/eventarc/docs/creating-triggers#trigger-gcloud for available values.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_eventarc_trigger#value GoogleEventarcTrigger#value}
    */
    readonly value: string;
}
export declare function googleEventarcTriggerMatchingCriteriaToTerraform(struct?: GoogleEventarcTriggerMatchingCriteria | cdktf.IResolvable): any;
export declare function googleEventarcTriggerMatchingCriteriaToHclTerraform(struct?: GoogleEventarcTriggerMatchingCriteria | cdktf.IResolvable): any;
export declare class GoogleEventarcTriggerMatchingCriteriaOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleEventarcTriggerMatchingCriteria | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleEventarcTriggerMatchingCriteria | cdktf.IResolvable | undefined);
    private _attribute?;
    get attribute(): string;
    set attribute(value: string);
    get attributeInput(): string | undefined;
    private _operator?;
    get operator(): string;
    set operator(value: string);
    resetOperator(): void;
    get operatorInput(): string | undefined;
    private _value?;
    get value(): string;
    set value(value: string);
    get valueInput(): string | undefined;
}
export declare class GoogleEventarcTriggerMatchingCriteriaList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleEventarcTriggerMatchingCriteria[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleEventarcTriggerMatchingCriteriaOutputReference;
}
export interface GoogleEventarcTriggerTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_eventarc_trigger#create GoogleEventarcTrigger#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_eventarc_trigger#delete GoogleEventarcTrigger#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_eventarc_trigger#update GoogleEventarcTrigger#update}
    */
    readonly update?: string;
}
export declare function googleEventarcTriggerTimeoutsToTerraform(struct?: GoogleEventarcTriggerTimeouts | cdktf.IResolvable): any;
export declare function googleEventarcTriggerTimeoutsToHclTerraform(struct?: GoogleEventarcTriggerTimeouts | cdktf.IResolvable): any;
export declare class GoogleEventarcTriggerTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleEventarcTriggerTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleEventarcTriggerTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
export interface GoogleEventarcTriggerTransportPubsub {
    /**
    * Optional. The name of the Pub/Sub topic created and managed by Eventarc system as a transport for the event delivery. Format: `projects/{PROJECT_ID}/topics/{TOPIC_NAME}. You may set an existing topic for triggers of the type google.cloud.pubsub.topic.v1.messagePublished` only. The topic you provide here will not be deleted by Eventarc at trigger deletion.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_eventarc_trigger#topic GoogleEventarcTrigger#topic}
    */
    readonly topic?: string;
}
export declare function googleEventarcTriggerTransportPubsubToTerraform(struct?: GoogleEventarcTriggerTransportPubsubOutputReference | GoogleEventarcTriggerTransportPubsub): any;
export declare function googleEventarcTriggerTransportPubsubToHclTerraform(struct?: GoogleEventarcTriggerTransportPubsubOutputReference | GoogleEventarcTriggerTransportPubsub): any;
export declare class GoogleEventarcTriggerTransportPubsubOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleEventarcTriggerTransportPubsub | undefined;
    set internalValue(value: GoogleEventarcTriggerTransportPubsub | undefined);
    get subscription(): string;
    private _topic?;
    get topic(): string;
    set topic(value: string);
    resetTopic(): void;
    get topicInput(): string | undefined;
}
export interface GoogleEventarcTriggerTransport {
    /**
    * pubsub block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_eventarc_trigger#pubsub GoogleEventarcTrigger#pubsub}
    */
    readonly pubsub?: GoogleEventarcTriggerTransportPubsub;
}
export declare function googleEventarcTriggerTransportToTerraform(struct?: GoogleEventarcTriggerTransportOutputReference | GoogleEventarcTriggerTransport): any;
export declare function googleEventarcTriggerTransportToHclTerraform(struct?: GoogleEventarcTriggerTransportOutputReference | GoogleEventarcTriggerTransport): any;
export declare class GoogleEventarcTriggerTransportOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleEventarcTriggerTransport | undefined;
    set internalValue(value: GoogleEventarcTriggerTransport | undefined);
    private _pubsub;
    get pubsub(): GoogleEventarcTriggerTransportPubsubOutputReference;
    putPubsub(value: GoogleEventarcTriggerTransportPubsub): void;
    resetPubsub(): void;
    get pubsubInput(): GoogleEventarcTriggerTransportPubsub | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_eventarc_trigger google_eventarc_trigger}
*/
export declare class GoogleEventarcTrigger extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_eventarc_trigger";
    /**
    * Generates CDKTF code for importing a GoogleEventarcTrigger resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the GoogleEventarcTrigger to import
    * @param importFromId The id of the existing GoogleEventarcTrigger that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_eventarc_trigger#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the GoogleEventarcTrigger to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_eventarc_trigger google_eventarc_trigger} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleEventarcTriggerConfig
    */
    constructor(scope: Construct, id: string, config: GoogleEventarcTriggerConfig);
    private _channel?;
    get channel(): string;
    set channel(value: string);
    resetChannel(): void;
    get channelInput(): string | undefined;
    private _conditions;
    get conditions(): cdktf.StringMap;
    get createTime(): string;
    private _effectiveLabels;
    get effectiveLabels(): cdktf.StringMap;
    get etag(): string;
    private _eventDataContentType?;
    get eventDataContentType(): string;
    set eventDataContentType(value: string);
    resetEventDataContentType(): void;
    get eventDataContentTypeInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _labels?;
    get labels(): {
        [key: string]: string;
    };
    set labels(value: {
        [key: string]: string;
    });
    resetLabels(): void;
    get labelsInput(): {
        [key: string]: string;
    } | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _serviceAccount?;
    get serviceAccount(): string;
    set serviceAccount(value: string);
    resetServiceAccount(): void;
    get serviceAccountInput(): string | undefined;
    private _terraformLabels;
    get terraformLabels(): cdktf.StringMap;
    get uid(): string;
    get updateTime(): string;
    private _destination;
    get destination(): GoogleEventarcTriggerDestinationOutputReference;
    putDestination(value: GoogleEventarcTriggerDestination): void;
    get destinationInput(): GoogleEventarcTriggerDestination | undefined;
    private _matchingCriteria;
    get matchingCriteria(): GoogleEventarcTriggerMatchingCriteriaList;
    putMatchingCriteria(value: GoogleEventarcTriggerMatchingCriteria[] | cdktf.IResolvable): void;
    get matchingCriteriaInput(): cdktf.IResolvable | GoogleEventarcTriggerMatchingCriteria[] | undefined;
    private _timeouts;
    get timeouts(): GoogleEventarcTriggerTimeoutsOutputReference;
    putTimeouts(value: GoogleEventarcTriggerTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleEventarcTriggerTimeouts | undefined;
    private _transport;
    get transport(): GoogleEventarcTriggerTransportOutputReference;
    putTransport(value: GoogleEventarcTriggerTransport): void;
    resetTransport(): void;
    get transportInput(): GoogleEventarcTriggerTransport | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
