/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleFirebaseAppCheckAppAttestConfigConfig extends cdktf.TerraformMetaArguments {
    /**
    * The ID of an
    * [Apple App](https://firebase.google.com/docs/reference/firebase-management/rest/v1beta1/projects.iosApps#IosApp.FIELDS.app_id).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_firebase_app_check_app_attest_config#app_id GoogleFirebaseAppCheckAppAttestConfig#app_id}
    */
    readonly appId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_firebase_app_check_app_attest_config#id GoogleFirebaseAppCheckAppAttestConfig#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_firebase_app_check_app_attest_config#project GoogleFirebaseAppCheckAppAttestConfig#project}
    */
    readonly project?: string;
    /**
    * Specifies the duration for which App Check tokens exchanged from App Attest artifacts will be valid.
    * If unset, a default value of 1 hour is assumed. Must be between 30 minutes and 7 days, inclusive.
    *
    * A duration in seconds with up to nine fractional digits, ending with 's'. Example: "3.5s".
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_firebase_app_check_app_attest_config#token_ttl GoogleFirebaseAppCheckAppAttestConfig#token_ttl}
    */
    readonly tokenTtl?: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_firebase_app_check_app_attest_config#timeouts GoogleFirebaseAppCheckAppAttestConfig#timeouts}
    */
    readonly timeouts?: GoogleFirebaseAppCheckAppAttestConfigTimeouts;
}
export interface GoogleFirebaseAppCheckAppAttestConfigTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_firebase_app_check_app_attest_config#create GoogleFirebaseAppCheckAppAttestConfig#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_firebase_app_check_app_attest_config#delete GoogleFirebaseAppCheckAppAttestConfig#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_firebase_app_check_app_attest_config#update GoogleFirebaseAppCheckAppAttestConfig#update}
    */
    readonly update?: string;
}
export declare function googleFirebaseAppCheckAppAttestConfigTimeoutsToTerraform(struct?: GoogleFirebaseAppCheckAppAttestConfigTimeouts | cdktf.IResolvable): any;
export declare function googleFirebaseAppCheckAppAttestConfigTimeoutsToHclTerraform(struct?: GoogleFirebaseAppCheckAppAttestConfigTimeouts | cdktf.IResolvable): any;
export declare class GoogleFirebaseAppCheckAppAttestConfigTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleFirebaseAppCheckAppAttestConfigTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleFirebaseAppCheckAppAttestConfigTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_firebase_app_check_app_attest_config google_firebase_app_check_app_attest_config}
*/
export declare class GoogleFirebaseAppCheckAppAttestConfig extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_firebase_app_check_app_attest_config";
    /**
    * Generates CDKTF code for importing a GoogleFirebaseAppCheckAppAttestConfig resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the GoogleFirebaseAppCheckAppAttestConfig to import
    * @param importFromId The id of the existing GoogleFirebaseAppCheckAppAttestConfig that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_firebase_app_check_app_attest_config#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the GoogleFirebaseAppCheckAppAttestConfig to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_firebase_app_check_app_attest_config google_firebase_app_check_app_attest_config} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleFirebaseAppCheckAppAttestConfigConfig
    */
    constructor(scope: Construct, id: string, config: GoogleFirebaseAppCheckAppAttestConfigConfig);
    private _appId?;
    get appId(): string;
    set appId(value: string);
    get appIdInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get name(): string;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _tokenTtl?;
    get tokenTtl(): string;
    set tokenTtl(value: string);
    resetTokenTtl(): void;
    get tokenTtlInput(): string | undefined;
    private _timeouts;
    get timeouts(): GoogleFirebaseAppCheckAppAttestConfigTimeoutsOutputReference;
    putTimeouts(value: GoogleFirebaseAppCheckAppAttestConfigTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleFirebaseAppCheckAppAttestConfigTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
