/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleFirebaseAppCheckPlayIntegrityConfigConfig extends cdktf.TerraformMetaArguments {
    /**
    * The ID of an
    * [Android App](https://firebase.google.com/docs/reference/firebase-management/rest/v1beta1/projects.androidApps#AndroidApp.FIELDS.app_id).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_firebase_app_check_play_integrity_config#app_id GoogleFirebaseAppCheckPlayIntegrityConfig#app_id}
    */
    readonly appId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_firebase_app_check_play_integrity_config#id GoogleFirebaseAppCheckPlayIntegrityConfig#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_firebase_app_check_play_integrity_config#project GoogleFirebaseAppCheckPlayIntegrityConfig#project}
    */
    readonly project?: string;
    /**
    * Specifies the duration for which App Check tokens exchanged from Play Integrity artifacts will be valid.
    * If unset, a default value of 1 hour is assumed. Must be between 30 minutes and 7 days, inclusive.
    *
    * A duration in seconds with up to nine fractional digits, ending with 's'. Example: "3.5s".
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_firebase_app_check_play_integrity_config#token_ttl GoogleFirebaseAppCheckPlayIntegrityConfig#token_ttl}
    */
    readonly tokenTtl?: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_firebase_app_check_play_integrity_config#timeouts GoogleFirebaseAppCheckPlayIntegrityConfig#timeouts}
    */
    readonly timeouts?: GoogleFirebaseAppCheckPlayIntegrityConfigTimeouts;
}
export interface GoogleFirebaseAppCheckPlayIntegrityConfigTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_firebase_app_check_play_integrity_config#create GoogleFirebaseAppCheckPlayIntegrityConfig#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_firebase_app_check_play_integrity_config#delete GoogleFirebaseAppCheckPlayIntegrityConfig#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_firebase_app_check_play_integrity_config#update GoogleFirebaseAppCheckPlayIntegrityConfig#update}
    */
    readonly update?: string;
}
export declare function googleFirebaseAppCheckPlayIntegrityConfigTimeoutsToTerraform(struct?: GoogleFirebaseAppCheckPlayIntegrityConfigTimeouts | cdktf.IResolvable): any;
export declare function googleFirebaseAppCheckPlayIntegrityConfigTimeoutsToHclTerraform(struct?: GoogleFirebaseAppCheckPlayIntegrityConfigTimeouts | cdktf.IResolvable): any;
export declare class GoogleFirebaseAppCheckPlayIntegrityConfigTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleFirebaseAppCheckPlayIntegrityConfigTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleFirebaseAppCheckPlayIntegrityConfigTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_firebase_app_check_play_integrity_config google_firebase_app_check_play_integrity_config}
*/
export declare class GoogleFirebaseAppCheckPlayIntegrityConfig extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_firebase_app_check_play_integrity_config";
    /**
    * Generates CDKTF code for importing a GoogleFirebaseAppCheckPlayIntegrityConfig resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the GoogleFirebaseAppCheckPlayIntegrityConfig to import
    * @param importFromId The id of the existing GoogleFirebaseAppCheckPlayIntegrityConfig that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_firebase_app_check_play_integrity_config#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the GoogleFirebaseAppCheckPlayIntegrityConfig to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_firebase_app_check_play_integrity_config google_firebase_app_check_play_integrity_config} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleFirebaseAppCheckPlayIntegrityConfigConfig
    */
    constructor(scope: Construct, id: string, config: GoogleFirebaseAppCheckPlayIntegrityConfigConfig);
    private _appId?;
    get appId(): string;
    set appId(value: string);
    get appIdInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get name(): string;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _tokenTtl?;
    get tokenTtl(): string;
    set tokenTtl(value: string);
    resetTokenTtl(): void;
    get tokenTtlInput(): string | undefined;
    private _timeouts;
    get timeouts(): GoogleFirebaseAppCheckPlayIntegrityConfigTimeoutsOutputReference;
    putTimeouts(value: GoogleFirebaseAppCheckPlayIntegrityConfigTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleFirebaseAppCheckPlayIntegrityConfigTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
