/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleFirebaseAppCheckRecaptchaV3ConfigConfig extends cdktf.TerraformMetaArguments {
    /**
    * The ID of an
    * [Web App](https://firebase.google.com/docs/reference/firebase-management/rest/v1beta1/projects.webApps#WebApp.FIELDS.app_id).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_firebase_app_check_recaptcha_v3_config#app_id GoogleFirebaseAppCheckRecaptchaV3Config#app_id}
    */
    readonly appId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_firebase_app_check_recaptcha_v3_config#id GoogleFirebaseAppCheckRecaptchaV3Config#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_firebase_app_check_recaptcha_v3_config#project GoogleFirebaseAppCheckRecaptchaV3Config#project}
    */
    readonly project?: string;
    /**
    * The site secret used to identify your service for reCAPTCHA v3 verification.
    * For security reasons, this field will never be populated in any response.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_firebase_app_check_recaptcha_v3_config#site_secret GoogleFirebaseAppCheckRecaptchaV3Config#site_secret}
    */
    readonly siteSecret: string;
    /**
    * Specifies the duration for which App Check tokens exchanged from reCAPTCHA V3 artifacts will be valid.
    * If unset, a default value of 1 hour is assumed. Must be between 30 minutes and 7 days, inclusive.
    *
    * A duration in seconds with up to nine fractional digits, ending with 's'. Example: "3.5s".
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_firebase_app_check_recaptcha_v3_config#token_ttl GoogleFirebaseAppCheckRecaptchaV3Config#token_ttl}
    */
    readonly tokenTtl?: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_firebase_app_check_recaptcha_v3_config#timeouts GoogleFirebaseAppCheckRecaptchaV3Config#timeouts}
    */
    readonly timeouts?: GoogleFirebaseAppCheckRecaptchaV3ConfigTimeouts;
}
export interface GoogleFirebaseAppCheckRecaptchaV3ConfigTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_firebase_app_check_recaptcha_v3_config#create GoogleFirebaseAppCheckRecaptchaV3Config#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_firebase_app_check_recaptcha_v3_config#delete GoogleFirebaseAppCheckRecaptchaV3Config#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_firebase_app_check_recaptcha_v3_config#update GoogleFirebaseAppCheckRecaptchaV3Config#update}
    */
    readonly update?: string;
}
export declare function googleFirebaseAppCheckRecaptchaV3ConfigTimeoutsToTerraform(struct?: GoogleFirebaseAppCheckRecaptchaV3ConfigTimeouts | cdktf.IResolvable): any;
export declare function googleFirebaseAppCheckRecaptchaV3ConfigTimeoutsToHclTerraform(struct?: GoogleFirebaseAppCheckRecaptchaV3ConfigTimeouts | cdktf.IResolvable): any;
export declare class GoogleFirebaseAppCheckRecaptchaV3ConfigTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleFirebaseAppCheckRecaptchaV3ConfigTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleFirebaseAppCheckRecaptchaV3ConfigTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_firebase_app_check_recaptcha_v3_config google_firebase_app_check_recaptcha_v3_config}
*/
export declare class GoogleFirebaseAppCheckRecaptchaV3Config extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_firebase_app_check_recaptcha_v3_config";
    /**
    * Generates CDKTF code for importing a GoogleFirebaseAppCheckRecaptchaV3Config resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the GoogleFirebaseAppCheckRecaptchaV3Config to import
    * @param importFromId The id of the existing GoogleFirebaseAppCheckRecaptchaV3Config that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_firebase_app_check_recaptcha_v3_config#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the GoogleFirebaseAppCheckRecaptchaV3Config to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_firebase_app_check_recaptcha_v3_config google_firebase_app_check_recaptcha_v3_config} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleFirebaseAppCheckRecaptchaV3ConfigConfig
    */
    constructor(scope: Construct, id: string, config: GoogleFirebaseAppCheckRecaptchaV3ConfigConfig);
    private _appId?;
    get appId(): string;
    set appId(value: string);
    get appIdInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get name(): string;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _siteSecret?;
    get siteSecret(): string;
    set siteSecret(value: string);
    get siteSecretInput(): string | undefined;
    get siteSecretSet(): cdktf.IResolvable;
    private _tokenTtl?;
    get tokenTtl(): string;
    set tokenTtl(value: string);
    resetTokenTtl(): void;
    get tokenTtlInput(): string | undefined;
    private _timeouts;
    get timeouts(): GoogleFirebaseAppCheckRecaptchaV3ConfigTimeoutsOutputReference;
    putTimeouts(value: GoogleFirebaseAppCheckRecaptchaV3ConfigTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleFirebaseAppCheckRecaptchaV3ConfigTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
