/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleFirebaseAppCheckServiceConfigConfig extends cdktf.TerraformMetaArguments {
    /**
    * The App Check enforcement mode for a service supported by App Check. Valid values are
    *
    * (Unset)
    * Firebase App Check is not enforced for the service, nor are App Check metrics collected.
    * Though the service is not protected by App Check in this mode, other applicable protections,
    * such as user authorization, are still enforced. An unconfigured service is in this mode by default.
    * This is equivalent to OFF in the REST API. Deleting the Terraform resource will also switch the
    * enforcement to OFF for this service.
    *
    * UNENFORCED
    * Firebase App Check is not enforced for the service. App Check metrics are collected to help you
    * decide when to turn on enforcement for the service. Though the service is not protected by App Check
    * in this mode, other applicable protections, such as user authorization, are still enforced.
    *
    * ENFORCED
    * Firebase App Check is enforced for the service. The service will reject any request that attempts to
    * access your project's resources if it does not have valid App Check token attached, with some exceptions
    * depending on the service; for example, some services will still allow requests bearing the developer's
    * privileged service account credentials without an App Check token. App Check metrics continue to be
    * collected to help you detect issues with your App Check integration and monitor the composition of your
    * callers. While the service is protected by App Check, other applicable protections, such as user
    * authorization, continue to be enforced at the same time.
    *
    * Use caution when choosing to enforce App Check on a Firebase service. If your users have not updated
    * to an App Check capable version of your app, their apps will no longer be able to use your Firebase
    * services that are enforcing App Check. App Check metrics can help you decide whether to enforce App
    * Check on your Firebase services.
    *
    * If your app has not launched yet, you should enable enforcement immediately, since there are no outdated
    * clients in use. Possible values: ["UNENFORCED", "ENFORCED"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_firebase_app_check_service_config#enforcement_mode GoogleFirebaseAppCheckServiceConfig#enforcement_mode}
    */
    readonly enforcementMode?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_firebase_app_check_service_config#id GoogleFirebaseAppCheckServiceConfig#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_firebase_app_check_service_config#project GoogleFirebaseAppCheckServiceConfig#project}
    */
    readonly project?: string;
    /**
    * The identifier of the service to configure enforcement. Currently, the following service IDs are supported:
    *   firebasestorage.googleapis.com (Cloud Storage for Firebase)
    *   firebasedatabase.googleapis.com (Firebase Realtime Database)
    *   firestore.googleapis.com (Cloud Firestore)
    *   identitytoolkit.googleapis.com (Authentication)
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_firebase_app_check_service_config#service_id GoogleFirebaseAppCheckServiceConfig#service_id}
    */
    readonly serviceId: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_firebase_app_check_service_config#timeouts GoogleFirebaseAppCheckServiceConfig#timeouts}
    */
    readonly timeouts?: GoogleFirebaseAppCheckServiceConfigTimeouts;
}
export interface GoogleFirebaseAppCheckServiceConfigTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_firebase_app_check_service_config#create GoogleFirebaseAppCheckServiceConfig#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_firebase_app_check_service_config#delete GoogleFirebaseAppCheckServiceConfig#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_firebase_app_check_service_config#update GoogleFirebaseAppCheckServiceConfig#update}
    */
    readonly update?: string;
}
export declare function googleFirebaseAppCheckServiceConfigTimeoutsToTerraform(struct?: GoogleFirebaseAppCheckServiceConfigTimeouts | cdktf.IResolvable): any;
export declare function googleFirebaseAppCheckServiceConfigTimeoutsToHclTerraform(struct?: GoogleFirebaseAppCheckServiceConfigTimeouts | cdktf.IResolvable): any;
export declare class GoogleFirebaseAppCheckServiceConfigTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleFirebaseAppCheckServiceConfigTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleFirebaseAppCheckServiceConfigTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_firebase_app_check_service_config google_firebase_app_check_service_config}
*/
export declare class GoogleFirebaseAppCheckServiceConfig extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_firebase_app_check_service_config";
    /**
    * Generates CDKTF code for importing a GoogleFirebaseAppCheckServiceConfig resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the GoogleFirebaseAppCheckServiceConfig to import
    * @param importFromId The id of the existing GoogleFirebaseAppCheckServiceConfig that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_firebase_app_check_service_config#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the GoogleFirebaseAppCheckServiceConfig to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_firebase_app_check_service_config google_firebase_app_check_service_config} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleFirebaseAppCheckServiceConfigConfig
    */
    constructor(scope: Construct, id: string, config: GoogleFirebaseAppCheckServiceConfigConfig);
    private _enforcementMode?;
    get enforcementMode(): string;
    set enforcementMode(value: string);
    resetEnforcementMode(): void;
    get enforcementModeInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get name(): string;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _serviceId?;
    get serviceId(): string;
    set serviceId(value: string);
    get serviceIdInput(): string | undefined;
    private _timeouts;
    get timeouts(): GoogleFirebaseAppCheckServiceConfigTimeoutsOutputReference;
    putTimeouts(value: GoogleFirebaseAppCheckServiceConfigTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleFirebaseAppCheckServiceConfigTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
