/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleFirebaseExtensionsInstanceConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_firebase_extensions_instance#id GoogleFirebaseExtensionsInstance#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The ID to use for the Extension Instance, which will become the final
    * component of the instance's name.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_firebase_extensions_instance#instance_id GoogleFirebaseExtensionsInstance#instance_id}
    */
    readonly instanceId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_firebase_extensions_instance#project GoogleFirebaseExtensionsInstance#project}
    */
    readonly project?: string;
    /**
    * config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_firebase_extensions_instance#config GoogleFirebaseExtensionsInstance#config}
    */
    readonly config: GoogleFirebaseExtensionsInstanceConfigA;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_firebase_extensions_instance#timeouts GoogleFirebaseExtensionsInstance#timeouts}
    */
    readonly timeouts?: GoogleFirebaseExtensionsInstanceTimeouts;
}
export interface GoogleFirebaseExtensionsInstanceErrorStatus {
}
export declare function googleFirebaseExtensionsInstanceErrorStatusToTerraform(struct?: GoogleFirebaseExtensionsInstanceErrorStatus): any;
export declare function googleFirebaseExtensionsInstanceErrorStatusToHclTerraform(struct?: GoogleFirebaseExtensionsInstanceErrorStatus): any;
export declare class GoogleFirebaseExtensionsInstanceErrorStatusOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleFirebaseExtensionsInstanceErrorStatus | undefined;
    set internalValue(value: GoogleFirebaseExtensionsInstanceErrorStatus | undefined);
    get code(): number;
    private _details;
    get details(): cdktf.StringMapList;
    get message(): string;
}
export declare class GoogleFirebaseExtensionsInstanceErrorStatusList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleFirebaseExtensionsInstanceErrorStatusOutputReference;
}
export interface GoogleFirebaseExtensionsInstanceRuntimeDataFatalError {
}
export declare function googleFirebaseExtensionsInstanceRuntimeDataFatalErrorToTerraform(struct?: GoogleFirebaseExtensionsInstanceRuntimeDataFatalError): any;
export declare function googleFirebaseExtensionsInstanceRuntimeDataFatalErrorToHclTerraform(struct?: GoogleFirebaseExtensionsInstanceRuntimeDataFatalError): any;
export declare class GoogleFirebaseExtensionsInstanceRuntimeDataFatalErrorOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleFirebaseExtensionsInstanceRuntimeDataFatalError | undefined;
    set internalValue(value: GoogleFirebaseExtensionsInstanceRuntimeDataFatalError | undefined);
    get errorMessage(): string;
}
export declare class GoogleFirebaseExtensionsInstanceRuntimeDataFatalErrorList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleFirebaseExtensionsInstanceRuntimeDataFatalErrorOutputReference;
}
export interface GoogleFirebaseExtensionsInstanceRuntimeDataProcessingState {
}
export declare function googleFirebaseExtensionsInstanceRuntimeDataProcessingStateToTerraform(struct?: GoogleFirebaseExtensionsInstanceRuntimeDataProcessingState): any;
export declare function googleFirebaseExtensionsInstanceRuntimeDataProcessingStateToHclTerraform(struct?: GoogleFirebaseExtensionsInstanceRuntimeDataProcessingState): any;
export declare class GoogleFirebaseExtensionsInstanceRuntimeDataProcessingStateOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleFirebaseExtensionsInstanceRuntimeDataProcessingState | undefined;
    set internalValue(value: GoogleFirebaseExtensionsInstanceRuntimeDataProcessingState | undefined);
    get detailMessage(): string;
    get state(): string;
}
export declare class GoogleFirebaseExtensionsInstanceRuntimeDataProcessingStateList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleFirebaseExtensionsInstanceRuntimeDataProcessingStateOutputReference;
}
export interface GoogleFirebaseExtensionsInstanceRuntimeData {
}
export declare function googleFirebaseExtensionsInstanceRuntimeDataToTerraform(struct?: GoogleFirebaseExtensionsInstanceRuntimeData): any;
export declare function googleFirebaseExtensionsInstanceRuntimeDataToHclTerraform(struct?: GoogleFirebaseExtensionsInstanceRuntimeData): any;
export declare class GoogleFirebaseExtensionsInstanceRuntimeDataOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleFirebaseExtensionsInstanceRuntimeData | undefined;
    set internalValue(value: GoogleFirebaseExtensionsInstanceRuntimeData | undefined);
    private _fatalError;
    get fatalError(): GoogleFirebaseExtensionsInstanceRuntimeDataFatalErrorList;
    private _processingState;
    get processingState(): GoogleFirebaseExtensionsInstanceRuntimeDataProcessingStateList;
    get stateUpdateTime(): string;
}
export declare class GoogleFirebaseExtensionsInstanceRuntimeDataList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleFirebaseExtensionsInstanceRuntimeDataOutputReference;
}
export interface GoogleFirebaseExtensionsInstanceConfigA {
    /**
    * List of extension events selected by consumer that extension is allowed to
    * emit, identified by their types.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_firebase_extensions_instance#allowed_event_types GoogleFirebaseExtensionsInstance#allowed_event_types}
    */
    readonly allowedEventTypes?: string[];
    /**
    * Fully qualified Eventarc resource name that consumers should use for event triggers.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_firebase_extensions_instance#eventarc_channel GoogleFirebaseExtensionsInstance#eventarc_channel}
    */
    readonly eventarcChannel?: string;
    /**
    * The ref of the Extension from the Registry (e.g. publisher-id/awesome-extension)
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_firebase_extensions_instance#extension_ref GoogleFirebaseExtensionsInstance#extension_ref}
    */
    readonly extensionRef: string;
    /**
    * The version of the Extension from the Registry (e.g. 1.0.3). If left blank, latest is assumed.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_firebase_extensions_instance#extension_version GoogleFirebaseExtensionsInstance#extension_version}
    */
    readonly extensionVersion?: string;
    /**
    * Environment variables that may be configured for the Extension
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_firebase_extensions_instance#params GoogleFirebaseExtensionsInstance#params}
    */
    readonly params: {
        [key: string]: string;
    };
    /**
    * Params whose values are only available at deployment time.
    * Unlike other params, these will not be set as environment variables on
    * functions. See a full list of system parameters at
    * https://firebase.google.com/docs/extensions/publishers/parameters#system_parameters
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_firebase_extensions_instance#system_params GoogleFirebaseExtensionsInstance#system_params}
    */
    readonly systemParams?: {
        [key: string]: string;
    };
}
export declare function googleFirebaseExtensionsInstanceConfigAToTerraform(struct?: GoogleFirebaseExtensionsInstanceConfigAOutputReference | GoogleFirebaseExtensionsInstanceConfigA): any;
export declare function googleFirebaseExtensionsInstanceConfigAToHclTerraform(struct?: GoogleFirebaseExtensionsInstanceConfigAOutputReference | GoogleFirebaseExtensionsInstanceConfigA): any;
export declare class GoogleFirebaseExtensionsInstanceConfigAOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleFirebaseExtensionsInstanceConfigA | undefined;
    set internalValue(value: GoogleFirebaseExtensionsInstanceConfigA | undefined);
    private _allowedEventTypes?;
    get allowedEventTypes(): string[];
    set allowedEventTypes(value: string[]);
    resetAllowedEventTypes(): void;
    get allowedEventTypesInput(): string[] | undefined;
    get createTime(): string;
    private _eventarcChannel?;
    get eventarcChannel(): string;
    set eventarcChannel(value: string);
    resetEventarcChannel(): void;
    get eventarcChannelInput(): string | undefined;
    private _extensionRef?;
    get extensionRef(): string;
    set extensionRef(value: string);
    get extensionRefInput(): string | undefined;
    private _extensionVersion?;
    get extensionVersion(): string;
    set extensionVersion(value: string);
    resetExtensionVersion(): void;
    get extensionVersionInput(): string | undefined;
    get name(): string;
    private _params?;
    get params(): {
        [key: string]: string;
    };
    set params(value: {
        [key: string]: string;
    });
    get paramsInput(): {
        [key: string]: string;
    } | undefined;
    get populatedPostinstallContent(): string;
    private _systemParams?;
    get systemParams(): {
        [key: string]: string;
    };
    set systemParams(value: {
        [key: string]: string;
    });
    resetSystemParams(): void;
    get systemParamsInput(): {
        [key: string]: string;
    } | undefined;
}
export interface GoogleFirebaseExtensionsInstanceTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_firebase_extensions_instance#create GoogleFirebaseExtensionsInstance#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_firebase_extensions_instance#delete GoogleFirebaseExtensionsInstance#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_firebase_extensions_instance#update GoogleFirebaseExtensionsInstance#update}
    */
    readonly update?: string;
}
export declare function googleFirebaseExtensionsInstanceTimeoutsToTerraform(struct?: GoogleFirebaseExtensionsInstanceTimeouts | cdktf.IResolvable): any;
export declare function googleFirebaseExtensionsInstanceTimeoutsToHclTerraform(struct?: GoogleFirebaseExtensionsInstanceTimeouts | cdktf.IResolvable): any;
export declare class GoogleFirebaseExtensionsInstanceTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleFirebaseExtensionsInstanceTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleFirebaseExtensionsInstanceTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_firebase_extensions_instance google_firebase_extensions_instance}
*/
export declare class GoogleFirebaseExtensionsInstance extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_firebase_extensions_instance";
    /**
    * Generates CDKTF code for importing a GoogleFirebaseExtensionsInstance resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the GoogleFirebaseExtensionsInstance to import
    * @param importFromId The id of the existing GoogleFirebaseExtensionsInstance that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_firebase_extensions_instance#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the GoogleFirebaseExtensionsInstance to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_firebase_extensions_instance google_firebase_extensions_instance} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleFirebaseExtensionsInstanceConfig
    */
    constructor(scope: Construct, id: string, config: GoogleFirebaseExtensionsInstanceConfig);
    get createTime(): string;
    private _errorStatus;
    get errorStatus(): GoogleFirebaseExtensionsInstanceErrorStatusList;
    get etag(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _instanceId?;
    get instanceId(): string;
    set instanceId(value: string);
    get instanceIdInput(): string | undefined;
    get lastOperationName(): string;
    get lastOperationType(): string;
    get name(): string;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _runtimeData;
    get runtimeData(): GoogleFirebaseExtensionsInstanceRuntimeDataList;
    get serviceAccountEmail(): string;
    get state(): string;
    get updateTime(): string;
    private _config;
    get config(): GoogleFirebaseExtensionsInstanceConfigAOutputReference;
    putConfig(value: GoogleFirebaseExtensionsInstanceConfigA): void;
    get configInput(): GoogleFirebaseExtensionsInstanceConfigA | undefined;
    private _timeouts;
    get timeouts(): GoogleFirebaseExtensionsInstanceTimeoutsOutputReference;
    putTimeouts(value: GoogleFirebaseExtensionsInstanceTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleFirebaseExtensionsInstanceTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
