/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleFirebaseHostingChannelConfig extends cdktf.TerraformMetaArguments {
    /**
    * Required. Immutable. A unique ID within the site that identifies the channel.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_firebase_hosting_channel#channel_id GoogleFirebaseHostingChannel#channel_id}
    */
    readonly channelId: string;
    /**
    * The time at which the channel will be automatically deleted. If null, the channel
    * will not be automatically deleted. This field is present in the output whether it's
    * set directly or via the 'ttl' field.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_firebase_hosting_channel#expire_time GoogleFirebaseHostingChannel#expire_time}
    */
    readonly expireTime?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_firebase_hosting_channel#id GoogleFirebaseHostingChannel#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Text labels used for extra metadata and/or filtering
    *
    * **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
    * Please refer to the field 'effective_labels' for all of the labels present on the resource.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_firebase_hosting_channel#labels GoogleFirebaseHostingChannel#labels}
    */
    readonly labels?: {
        [key: string]: string;
    };
    /**
    * The number of previous releases to retain on the channel for rollback or other
    * purposes. Must be a number between 1-100. Defaults to 10 for new channels.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_firebase_hosting_channel#retained_release_count GoogleFirebaseHostingChannel#retained_release_count}
    */
    readonly retainedReleaseCount?: number;
    /**
    * Required. The ID of the site in which to create this channel.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_firebase_hosting_channel#site_id GoogleFirebaseHostingChannel#site_id}
    */
    readonly siteId: string;
    /**
    * Input only. A time-to-live for this channel. Sets 'expire_time' to the provided
    * duration past the time of the request. A duration in seconds with up to nine fractional
    * digits, terminated by 's'. Example: "86400s" (one day).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_firebase_hosting_channel#ttl GoogleFirebaseHostingChannel#ttl}
    */
    readonly ttl?: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_firebase_hosting_channel#timeouts GoogleFirebaseHostingChannel#timeouts}
    */
    readonly timeouts?: GoogleFirebaseHostingChannelTimeouts;
}
export interface GoogleFirebaseHostingChannelTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_firebase_hosting_channel#create GoogleFirebaseHostingChannel#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_firebase_hosting_channel#delete GoogleFirebaseHostingChannel#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_firebase_hosting_channel#update GoogleFirebaseHostingChannel#update}
    */
    readonly update?: string;
}
export declare function googleFirebaseHostingChannelTimeoutsToTerraform(struct?: GoogleFirebaseHostingChannelTimeouts | cdktf.IResolvable): any;
export declare function googleFirebaseHostingChannelTimeoutsToHclTerraform(struct?: GoogleFirebaseHostingChannelTimeouts | cdktf.IResolvable): any;
export declare class GoogleFirebaseHostingChannelTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleFirebaseHostingChannelTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleFirebaseHostingChannelTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_firebase_hosting_channel google_firebase_hosting_channel}
*/
export declare class GoogleFirebaseHostingChannel extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_firebase_hosting_channel";
    /**
    * Generates CDKTF code for importing a GoogleFirebaseHostingChannel resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the GoogleFirebaseHostingChannel to import
    * @param importFromId The id of the existing GoogleFirebaseHostingChannel that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_firebase_hosting_channel#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the GoogleFirebaseHostingChannel to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_firebase_hosting_channel google_firebase_hosting_channel} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleFirebaseHostingChannelConfig
    */
    constructor(scope: Construct, id: string, config: GoogleFirebaseHostingChannelConfig);
    private _channelId?;
    get channelId(): string;
    set channelId(value: string);
    get channelIdInput(): string | undefined;
    private _effectiveLabels;
    get effectiveLabels(): cdktf.StringMap;
    private _expireTime?;
    get expireTime(): string;
    set expireTime(value: string);
    resetExpireTime(): void;
    get expireTimeInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _labels?;
    get labels(): {
        [key: string]: string;
    };
    set labels(value: {
        [key: string]: string;
    });
    resetLabels(): void;
    get labelsInput(): {
        [key: string]: string;
    } | undefined;
    get name(): string;
    private _retainedReleaseCount?;
    get retainedReleaseCount(): number;
    set retainedReleaseCount(value: number);
    resetRetainedReleaseCount(): void;
    get retainedReleaseCountInput(): number | undefined;
    private _siteId?;
    get siteId(): string;
    set siteId(value: string);
    get siteIdInput(): string | undefined;
    private _terraformLabels;
    get terraformLabels(): cdktf.StringMap;
    private _ttl?;
    get ttl(): string;
    set ttl(value: string);
    resetTtl(): void;
    get ttlInput(): string | undefined;
    private _timeouts;
    get timeouts(): GoogleFirebaseHostingChannelTimeoutsOutputReference;
    putTimeouts(value: GoogleFirebaseHostingChannelTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleFirebaseHostingChannelTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
