/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleFirebaseHostingCustomDomainConfig extends cdktf.TerraformMetaArguments {
    /**
    * A field that lets you specify which SSL certificate type Hosting creates
    * for your domain name. Spark plan 'CustomDomain's only have access to the
    * 'GROUPED' cert type, while Blaze plan can select any option. Possible values: ["GROUPED", "PROJECT_GROUPED", "DEDICATED"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_firebase_hosting_custom_domain#cert_preference GoogleFirebaseHostingCustomDomain#cert_preference}
    */
    readonly certPreference?: string;
    /**
    * The ID of the 'CustomDomain', which is the domain name you'd like to use with Firebase Hosting.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_firebase_hosting_custom_domain#custom_domain GoogleFirebaseHostingCustomDomain#custom_domain}
    */
    readonly customDomain: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_firebase_hosting_custom_domain#id GoogleFirebaseHostingCustomDomain#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_firebase_hosting_custom_domain#project GoogleFirebaseHostingCustomDomain#project}
    */
    readonly project?: string;
    /**
    * A domain name that this CustomDomain should direct traffic towards. If
    * specified, Hosting will respond to requests against this CustomDomain
    * with an HTTP 301 code, and route traffic to the specified 'redirect_target'
    * instead.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_firebase_hosting_custom_domain#redirect_target GoogleFirebaseHostingCustomDomain#redirect_target}
    */
    readonly redirectTarget?: string;
    /**
    * The ID of the site in which to create this custom domain association.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_firebase_hosting_custom_domain#site_id GoogleFirebaseHostingCustomDomain#site_id}
    */
    readonly siteId: string;
    /**
    * If true, Terraform will wait for DNS records to be fully resolved on the 'CustomDomain'.
    * If false, Terraform will not wait for DNS records on the 'CustomDomain'. Any issues in
    * the 'CustomDomain' will be returned and stored in the Terraform state.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_firebase_hosting_custom_domain#wait_dns_verification GoogleFirebaseHostingCustomDomain#wait_dns_verification}
    */
    readonly waitDnsVerification?: boolean | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_firebase_hosting_custom_domain#timeouts GoogleFirebaseHostingCustomDomain#timeouts}
    */
    readonly timeouts?: GoogleFirebaseHostingCustomDomainTimeouts;
}
export interface GoogleFirebaseHostingCustomDomainCertVerificationDnsDesiredRecords {
}
export declare function googleFirebaseHostingCustomDomainCertVerificationDnsDesiredRecordsToTerraform(struct?: GoogleFirebaseHostingCustomDomainCertVerificationDnsDesiredRecords): any;
export declare function googleFirebaseHostingCustomDomainCertVerificationDnsDesiredRecordsToHclTerraform(struct?: GoogleFirebaseHostingCustomDomainCertVerificationDnsDesiredRecords): any;
export declare class GoogleFirebaseHostingCustomDomainCertVerificationDnsDesiredRecordsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleFirebaseHostingCustomDomainCertVerificationDnsDesiredRecords | undefined;
    set internalValue(value: GoogleFirebaseHostingCustomDomainCertVerificationDnsDesiredRecords | undefined);
    get domainName(): string;
    get rdata(): string;
    get requiredAction(): string;
    get type(): string;
}
export declare class GoogleFirebaseHostingCustomDomainCertVerificationDnsDesiredRecordsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleFirebaseHostingCustomDomainCertVerificationDnsDesiredRecordsOutputReference;
}
export interface GoogleFirebaseHostingCustomDomainCertVerificationDnsDesired {
}
export declare function googleFirebaseHostingCustomDomainCertVerificationDnsDesiredToTerraform(struct?: GoogleFirebaseHostingCustomDomainCertVerificationDnsDesired): any;
export declare function googleFirebaseHostingCustomDomainCertVerificationDnsDesiredToHclTerraform(struct?: GoogleFirebaseHostingCustomDomainCertVerificationDnsDesired): any;
export declare class GoogleFirebaseHostingCustomDomainCertVerificationDnsDesiredOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleFirebaseHostingCustomDomainCertVerificationDnsDesired | undefined;
    set internalValue(value: GoogleFirebaseHostingCustomDomainCertVerificationDnsDesired | undefined);
    get domainName(): string;
    private _records;
    get records(): GoogleFirebaseHostingCustomDomainCertVerificationDnsDesiredRecordsList;
}
export declare class GoogleFirebaseHostingCustomDomainCertVerificationDnsDesiredList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleFirebaseHostingCustomDomainCertVerificationDnsDesiredOutputReference;
}
export interface GoogleFirebaseHostingCustomDomainCertVerificationDnsDiscoveredRecords {
}
export declare function googleFirebaseHostingCustomDomainCertVerificationDnsDiscoveredRecordsToTerraform(struct?: GoogleFirebaseHostingCustomDomainCertVerificationDnsDiscoveredRecords): any;
export declare function googleFirebaseHostingCustomDomainCertVerificationDnsDiscoveredRecordsToHclTerraform(struct?: GoogleFirebaseHostingCustomDomainCertVerificationDnsDiscoveredRecords): any;
export declare class GoogleFirebaseHostingCustomDomainCertVerificationDnsDiscoveredRecordsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleFirebaseHostingCustomDomainCertVerificationDnsDiscoveredRecords | undefined;
    set internalValue(value: GoogleFirebaseHostingCustomDomainCertVerificationDnsDiscoveredRecords | undefined);
    get domainName(): string;
    get rdata(): string;
    get requiredAction(): string;
    get type(): string;
}
export declare class GoogleFirebaseHostingCustomDomainCertVerificationDnsDiscoveredRecordsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleFirebaseHostingCustomDomainCertVerificationDnsDiscoveredRecordsOutputReference;
}
export interface GoogleFirebaseHostingCustomDomainCertVerificationDnsDiscovered {
}
export declare function googleFirebaseHostingCustomDomainCertVerificationDnsDiscoveredToTerraform(struct?: GoogleFirebaseHostingCustomDomainCertVerificationDnsDiscovered): any;
export declare function googleFirebaseHostingCustomDomainCertVerificationDnsDiscoveredToHclTerraform(struct?: GoogleFirebaseHostingCustomDomainCertVerificationDnsDiscovered): any;
export declare class GoogleFirebaseHostingCustomDomainCertVerificationDnsDiscoveredOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleFirebaseHostingCustomDomainCertVerificationDnsDiscovered | undefined;
    set internalValue(value: GoogleFirebaseHostingCustomDomainCertVerificationDnsDiscovered | undefined);
    get domainName(): string;
    private _records;
    get records(): GoogleFirebaseHostingCustomDomainCertVerificationDnsDiscoveredRecordsList;
}
export declare class GoogleFirebaseHostingCustomDomainCertVerificationDnsDiscoveredList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleFirebaseHostingCustomDomainCertVerificationDnsDiscoveredOutputReference;
}
export interface GoogleFirebaseHostingCustomDomainCertVerificationDns {
}
export declare function googleFirebaseHostingCustomDomainCertVerificationDnsToTerraform(struct?: GoogleFirebaseHostingCustomDomainCertVerificationDns): any;
export declare function googleFirebaseHostingCustomDomainCertVerificationDnsToHclTerraform(struct?: GoogleFirebaseHostingCustomDomainCertVerificationDns): any;
export declare class GoogleFirebaseHostingCustomDomainCertVerificationDnsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleFirebaseHostingCustomDomainCertVerificationDns | undefined;
    set internalValue(value: GoogleFirebaseHostingCustomDomainCertVerificationDns | undefined);
    get checkTime(): string;
    private _desired;
    get desired(): GoogleFirebaseHostingCustomDomainCertVerificationDnsDesiredList;
    private _discovered;
    get discovered(): GoogleFirebaseHostingCustomDomainCertVerificationDnsDiscoveredList;
}
export declare class GoogleFirebaseHostingCustomDomainCertVerificationDnsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleFirebaseHostingCustomDomainCertVerificationDnsOutputReference;
}
export interface GoogleFirebaseHostingCustomDomainCertVerificationHttp {
}
export declare function googleFirebaseHostingCustomDomainCertVerificationHttpToTerraform(struct?: GoogleFirebaseHostingCustomDomainCertVerificationHttp): any;
export declare function googleFirebaseHostingCustomDomainCertVerificationHttpToHclTerraform(struct?: GoogleFirebaseHostingCustomDomainCertVerificationHttp): any;
export declare class GoogleFirebaseHostingCustomDomainCertVerificationHttpOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleFirebaseHostingCustomDomainCertVerificationHttp | undefined;
    set internalValue(value: GoogleFirebaseHostingCustomDomainCertVerificationHttp | undefined);
    get desired(): string;
    get discovered(): string;
    get lastCheckTime(): string;
    get path(): string;
}
export declare class GoogleFirebaseHostingCustomDomainCertVerificationHttpList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleFirebaseHostingCustomDomainCertVerificationHttpOutputReference;
}
export interface GoogleFirebaseHostingCustomDomainCertVerification {
}
export declare function googleFirebaseHostingCustomDomainCertVerificationToTerraform(struct?: GoogleFirebaseHostingCustomDomainCertVerification): any;
export declare function googleFirebaseHostingCustomDomainCertVerificationToHclTerraform(struct?: GoogleFirebaseHostingCustomDomainCertVerification): any;
export declare class GoogleFirebaseHostingCustomDomainCertVerificationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleFirebaseHostingCustomDomainCertVerification | undefined;
    set internalValue(value: GoogleFirebaseHostingCustomDomainCertVerification | undefined);
    private _dns;
    get dns(): GoogleFirebaseHostingCustomDomainCertVerificationDnsList;
    private _http;
    get http(): GoogleFirebaseHostingCustomDomainCertVerificationHttpList;
}
export declare class GoogleFirebaseHostingCustomDomainCertVerificationList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleFirebaseHostingCustomDomainCertVerificationOutputReference;
}
export interface GoogleFirebaseHostingCustomDomainCert {
}
export declare function googleFirebaseHostingCustomDomainCertToTerraform(struct?: GoogleFirebaseHostingCustomDomainCert): any;
export declare function googleFirebaseHostingCustomDomainCertToHclTerraform(struct?: GoogleFirebaseHostingCustomDomainCert): any;
export declare class GoogleFirebaseHostingCustomDomainCertOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleFirebaseHostingCustomDomainCert | undefined;
    set internalValue(value: GoogleFirebaseHostingCustomDomainCert | undefined);
    get state(): string;
    get type(): string;
    private _verification;
    get verification(): GoogleFirebaseHostingCustomDomainCertVerificationList;
}
export declare class GoogleFirebaseHostingCustomDomainCertList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleFirebaseHostingCustomDomainCertOutputReference;
}
export interface GoogleFirebaseHostingCustomDomainIssues {
}
export declare function googleFirebaseHostingCustomDomainIssuesToTerraform(struct?: GoogleFirebaseHostingCustomDomainIssues): any;
export declare function googleFirebaseHostingCustomDomainIssuesToHclTerraform(struct?: GoogleFirebaseHostingCustomDomainIssues): any;
export declare class GoogleFirebaseHostingCustomDomainIssuesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleFirebaseHostingCustomDomainIssues | undefined;
    set internalValue(value: GoogleFirebaseHostingCustomDomainIssues | undefined);
    get code(): number;
    get details(): string;
    get message(): string;
}
export declare class GoogleFirebaseHostingCustomDomainIssuesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleFirebaseHostingCustomDomainIssuesOutputReference;
}
export interface GoogleFirebaseHostingCustomDomainRequiredDnsUpdatesDesiredRecords {
}
export declare function googleFirebaseHostingCustomDomainRequiredDnsUpdatesDesiredRecordsToTerraform(struct?: GoogleFirebaseHostingCustomDomainRequiredDnsUpdatesDesiredRecords): any;
export declare function googleFirebaseHostingCustomDomainRequiredDnsUpdatesDesiredRecordsToHclTerraform(struct?: GoogleFirebaseHostingCustomDomainRequiredDnsUpdatesDesiredRecords): any;
export declare class GoogleFirebaseHostingCustomDomainRequiredDnsUpdatesDesiredRecordsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleFirebaseHostingCustomDomainRequiredDnsUpdatesDesiredRecords | undefined;
    set internalValue(value: GoogleFirebaseHostingCustomDomainRequiredDnsUpdatesDesiredRecords | undefined);
    get domainName(): string;
    get rdata(): string;
    get requiredAction(): string;
    get type(): string;
}
export declare class GoogleFirebaseHostingCustomDomainRequiredDnsUpdatesDesiredRecordsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleFirebaseHostingCustomDomainRequiredDnsUpdatesDesiredRecordsOutputReference;
}
export interface GoogleFirebaseHostingCustomDomainRequiredDnsUpdatesDesired {
}
export declare function googleFirebaseHostingCustomDomainRequiredDnsUpdatesDesiredToTerraform(struct?: GoogleFirebaseHostingCustomDomainRequiredDnsUpdatesDesired): any;
export declare function googleFirebaseHostingCustomDomainRequiredDnsUpdatesDesiredToHclTerraform(struct?: GoogleFirebaseHostingCustomDomainRequiredDnsUpdatesDesired): any;
export declare class GoogleFirebaseHostingCustomDomainRequiredDnsUpdatesDesiredOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleFirebaseHostingCustomDomainRequiredDnsUpdatesDesired | undefined;
    set internalValue(value: GoogleFirebaseHostingCustomDomainRequiredDnsUpdatesDesired | undefined);
    get domainName(): string;
    private _records;
    get records(): GoogleFirebaseHostingCustomDomainRequiredDnsUpdatesDesiredRecordsList;
}
export declare class GoogleFirebaseHostingCustomDomainRequiredDnsUpdatesDesiredList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleFirebaseHostingCustomDomainRequiredDnsUpdatesDesiredOutputReference;
}
export interface GoogleFirebaseHostingCustomDomainRequiredDnsUpdatesDiscoveredRecords {
}
export declare function googleFirebaseHostingCustomDomainRequiredDnsUpdatesDiscoveredRecordsToTerraform(struct?: GoogleFirebaseHostingCustomDomainRequiredDnsUpdatesDiscoveredRecords): any;
export declare function googleFirebaseHostingCustomDomainRequiredDnsUpdatesDiscoveredRecordsToHclTerraform(struct?: GoogleFirebaseHostingCustomDomainRequiredDnsUpdatesDiscoveredRecords): any;
export declare class GoogleFirebaseHostingCustomDomainRequiredDnsUpdatesDiscoveredRecordsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleFirebaseHostingCustomDomainRequiredDnsUpdatesDiscoveredRecords | undefined;
    set internalValue(value: GoogleFirebaseHostingCustomDomainRequiredDnsUpdatesDiscoveredRecords | undefined);
    get domainName(): string;
    get rdata(): string;
    get requiredAction(): string;
    get type(): string;
}
export declare class GoogleFirebaseHostingCustomDomainRequiredDnsUpdatesDiscoveredRecordsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleFirebaseHostingCustomDomainRequiredDnsUpdatesDiscoveredRecordsOutputReference;
}
export interface GoogleFirebaseHostingCustomDomainRequiredDnsUpdatesDiscovered {
}
export declare function googleFirebaseHostingCustomDomainRequiredDnsUpdatesDiscoveredToTerraform(struct?: GoogleFirebaseHostingCustomDomainRequiredDnsUpdatesDiscovered): any;
export declare function googleFirebaseHostingCustomDomainRequiredDnsUpdatesDiscoveredToHclTerraform(struct?: GoogleFirebaseHostingCustomDomainRequiredDnsUpdatesDiscovered): any;
export declare class GoogleFirebaseHostingCustomDomainRequiredDnsUpdatesDiscoveredOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleFirebaseHostingCustomDomainRequiredDnsUpdatesDiscovered | undefined;
    set internalValue(value: GoogleFirebaseHostingCustomDomainRequiredDnsUpdatesDiscovered | undefined);
    get domainName(): string;
    private _records;
    get records(): GoogleFirebaseHostingCustomDomainRequiredDnsUpdatesDiscoveredRecordsList;
}
export declare class GoogleFirebaseHostingCustomDomainRequiredDnsUpdatesDiscoveredList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleFirebaseHostingCustomDomainRequiredDnsUpdatesDiscoveredOutputReference;
}
export interface GoogleFirebaseHostingCustomDomainRequiredDnsUpdates {
}
export declare function googleFirebaseHostingCustomDomainRequiredDnsUpdatesToTerraform(struct?: GoogleFirebaseHostingCustomDomainRequiredDnsUpdates): any;
export declare function googleFirebaseHostingCustomDomainRequiredDnsUpdatesToHclTerraform(struct?: GoogleFirebaseHostingCustomDomainRequiredDnsUpdates): any;
export declare class GoogleFirebaseHostingCustomDomainRequiredDnsUpdatesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleFirebaseHostingCustomDomainRequiredDnsUpdates | undefined;
    set internalValue(value: GoogleFirebaseHostingCustomDomainRequiredDnsUpdates | undefined);
    get checkTime(): string;
    private _desired;
    get desired(): GoogleFirebaseHostingCustomDomainRequiredDnsUpdatesDesiredList;
    private _discovered;
    get discovered(): GoogleFirebaseHostingCustomDomainRequiredDnsUpdatesDiscoveredList;
}
export declare class GoogleFirebaseHostingCustomDomainRequiredDnsUpdatesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleFirebaseHostingCustomDomainRequiredDnsUpdatesOutputReference;
}
export interface GoogleFirebaseHostingCustomDomainTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_firebase_hosting_custom_domain#create GoogleFirebaseHostingCustomDomain#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_firebase_hosting_custom_domain#delete GoogleFirebaseHostingCustomDomain#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_firebase_hosting_custom_domain#update GoogleFirebaseHostingCustomDomain#update}
    */
    readonly update?: string;
}
export declare function googleFirebaseHostingCustomDomainTimeoutsToTerraform(struct?: GoogleFirebaseHostingCustomDomainTimeouts | cdktf.IResolvable): any;
export declare function googleFirebaseHostingCustomDomainTimeoutsToHclTerraform(struct?: GoogleFirebaseHostingCustomDomainTimeouts | cdktf.IResolvable): any;
export declare class GoogleFirebaseHostingCustomDomainTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleFirebaseHostingCustomDomainTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleFirebaseHostingCustomDomainTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_firebase_hosting_custom_domain google_firebase_hosting_custom_domain}
*/
export declare class GoogleFirebaseHostingCustomDomain extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_firebase_hosting_custom_domain";
    /**
    * Generates CDKTF code for importing a GoogleFirebaseHostingCustomDomain resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the GoogleFirebaseHostingCustomDomain to import
    * @param importFromId The id of the existing GoogleFirebaseHostingCustomDomain that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_firebase_hosting_custom_domain#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the GoogleFirebaseHostingCustomDomain to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_firebase_hosting_custom_domain google_firebase_hosting_custom_domain} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleFirebaseHostingCustomDomainConfig
    */
    constructor(scope: Construct, id: string, config: GoogleFirebaseHostingCustomDomainConfig);
    private _cert;
    get cert(): GoogleFirebaseHostingCustomDomainCertList;
    private _certPreference?;
    get certPreference(): string;
    set certPreference(value: string);
    resetCertPreference(): void;
    get certPreferenceInput(): string | undefined;
    get createTime(): string;
    private _customDomain?;
    get customDomain(): string;
    set customDomain(value: string);
    get customDomainInput(): string | undefined;
    get deleteTime(): string;
    get etag(): string;
    get expireTime(): string;
    get hostState(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _issues;
    get issues(): GoogleFirebaseHostingCustomDomainIssuesList;
    get name(): string;
    get ownershipState(): string;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    get reconciling(): cdktf.IResolvable;
    private _redirectTarget?;
    get redirectTarget(): string;
    set redirectTarget(value: string);
    resetRedirectTarget(): void;
    get redirectTargetInput(): string | undefined;
    private _requiredDnsUpdates;
    get requiredDnsUpdates(): GoogleFirebaseHostingCustomDomainRequiredDnsUpdatesList;
    private _siteId?;
    get siteId(): string;
    set siteId(value: string);
    get siteIdInput(): string | undefined;
    get updateTime(): string;
    private _waitDnsVerification?;
    get waitDnsVerification(): boolean | cdktf.IResolvable;
    set waitDnsVerification(value: boolean | cdktf.IResolvable);
    resetWaitDnsVerification(): void;
    get waitDnsVerificationInput(): boolean | cdktf.IResolvable | undefined;
    private _timeouts;
    get timeouts(): GoogleFirebaseHostingCustomDomainTimeoutsOutputReference;
    putTimeouts(value: GoogleFirebaseHostingCustomDomainTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleFirebaseHostingCustomDomainTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
