/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleFirebaseStorageBucketConfig extends cdktf.TerraformMetaArguments {
    /**
    * Required. Immutable. The ID of the underlying Google Cloud Storage bucket
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_firebase_storage_bucket#bucket_id GoogleFirebaseStorageBucket#bucket_id}
    */
    readonly bucketId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_firebase_storage_bucket#id GoogleFirebaseStorageBucket#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_firebase_storage_bucket#project GoogleFirebaseStorageBucket#project}
    */
    readonly project?: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_firebase_storage_bucket#timeouts GoogleFirebaseStorageBucket#timeouts}
    */
    readonly timeouts?: GoogleFirebaseStorageBucketTimeouts;
}
export interface GoogleFirebaseStorageBucketTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_firebase_storage_bucket#create GoogleFirebaseStorageBucket#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_firebase_storage_bucket#delete GoogleFirebaseStorageBucket#delete}
    */
    readonly delete?: string;
}
export declare function googleFirebaseStorageBucketTimeoutsToTerraform(struct?: GoogleFirebaseStorageBucketTimeouts | cdktf.IResolvable): any;
export declare function googleFirebaseStorageBucketTimeoutsToHclTerraform(struct?: GoogleFirebaseStorageBucketTimeouts | cdktf.IResolvable): any;
export declare class GoogleFirebaseStorageBucketTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleFirebaseStorageBucketTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleFirebaseStorageBucketTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_firebase_storage_bucket google_firebase_storage_bucket}
*/
export declare class GoogleFirebaseStorageBucket extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_firebase_storage_bucket";
    /**
    * Generates CDKTF code for importing a GoogleFirebaseStorageBucket resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the GoogleFirebaseStorageBucket to import
    * @param importFromId The id of the existing GoogleFirebaseStorageBucket that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_firebase_storage_bucket#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the GoogleFirebaseStorageBucket to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_firebase_storage_bucket google_firebase_storage_bucket} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleFirebaseStorageBucketConfig = {}
    */
    constructor(scope: Construct, id: string, config?: GoogleFirebaseStorageBucketConfig);
    private _bucketId?;
    get bucketId(): string;
    set bucketId(value: string);
    resetBucketId(): void;
    get bucketIdInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get name(): string;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _timeouts;
    get timeouts(): GoogleFirebaseStorageBucketTimeoutsOutputReference;
    putTimeouts(value: GoogleFirebaseStorageBucketTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleFirebaseStorageBucketTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
