/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleFirebaseWebAppConfig extends cdktf.TerraformMetaArguments {
    /**
    * The globally unique, Google-assigned identifier (UID) for the Firebase API key associated with the WebApp.
    * If apiKeyId is not set during creation, then Firebase automatically associates an apiKeyId with the WebApp.
    * This auto-associated key may be an existing valid key or, if no valid key exists, a new one will be provisioned.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_firebase_web_app#api_key_id GoogleFirebaseWebApp#api_key_id}
    */
    readonly apiKeyId?: string;
    /**
    * Set to 'ABANDON' to allow the WebApp to be untracked from terraform state
    * rather than deleted upon 'terraform destroy'. This is useful becaue the WebApp may be
    * serving traffic. Set to 'DELETE' to delete the WebApp. Default to 'DELETE'
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_firebase_web_app#deletion_policy GoogleFirebaseWebApp#deletion_policy}
    */
    readonly deletionPolicy?: string;
    /**
    * The user-assigned display name of the App.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_firebase_web_app#display_name GoogleFirebaseWebApp#display_name}
    */
    readonly displayName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_firebase_web_app#id GoogleFirebaseWebApp#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_firebase_web_app#project GoogleFirebaseWebApp#project}
    */
    readonly project?: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_firebase_web_app#timeouts GoogleFirebaseWebApp#timeouts}
    */
    readonly timeouts?: GoogleFirebaseWebAppTimeouts;
}
export interface GoogleFirebaseWebAppTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_firebase_web_app#create GoogleFirebaseWebApp#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_firebase_web_app#delete GoogleFirebaseWebApp#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_firebase_web_app#update GoogleFirebaseWebApp#update}
    */
    readonly update?: string;
}
export declare function googleFirebaseWebAppTimeoutsToTerraform(struct?: GoogleFirebaseWebAppTimeouts | cdktf.IResolvable): any;
export declare function googleFirebaseWebAppTimeoutsToHclTerraform(struct?: GoogleFirebaseWebAppTimeouts | cdktf.IResolvable): any;
export declare class GoogleFirebaseWebAppTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleFirebaseWebAppTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleFirebaseWebAppTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_firebase_web_app google_firebase_web_app}
*/
export declare class GoogleFirebaseWebApp extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_firebase_web_app";
    /**
    * Generates CDKTF code for importing a GoogleFirebaseWebApp resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the GoogleFirebaseWebApp to import
    * @param importFromId The id of the existing GoogleFirebaseWebApp that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_firebase_web_app#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the GoogleFirebaseWebApp to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_firebase_web_app google_firebase_web_app} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleFirebaseWebAppConfig
    */
    constructor(scope: Construct, id: string, config: GoogleFirebaseWebAppConfig);
    private _apiKeyId?;
    get apiKeyId(): string;
    set apiKeyId(value: string);
    resetApiKeyId(): void;
    get apiKeyIdInput(): string | undefined;
    get appId(): string;
    get appUrls(): string[];
    private _deletionPolicy?;
    get deletionPolicy(): string;
    set deletionPolicy(value: string);
    resetDeletionPolicy(): void;
    get deletionPolicyInput(): string | undefined;
    private _displayName?;
    get displayName(): string;
    set displayName(value: string);
    get displayNameInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get name(): string;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _timeouts;
    get timeouts(): GoogleFirebaseWebAppTimeoutsOutputReference;
    putTimeouts(value: GoogleFirebaseWebAppTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleFirebaseWebAppTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
