/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleFirebaserulesRulesetConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_firebaserules_ruleset#id GoogleFirebaserulesRuleset#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The project for the resource
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_firebaserules_ruleset#project GoogleFirebaserulesRuleset#project}
    */
    readonly project?: string;
    /**
    * source block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_firebaserules_ruleset#source GoogleFirebaserulesRuleset#source}
    */
    readonly source: GoogleFirebaserulesRulesetSource;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_firebaserules_ruleset#timeouts GoogleFirebaserulesRuleset#timeouts}
    */
    readonly timeouts?: GoogleFirebaserulesRulesetTimeouts;
}
export interface GoogleFirebaserulesRulesetMetadata {
}
export declare function googleFirebaserulesRulesetMetadataToTerraform(struct?: GoogleFirebaserulesRulesetMetadata): any;
export declare function googleFirebaserulesRulesetMetadataToHclTerraform(struct?: GoogleFirebaserulesRulesetMetadata): any;
export declare class GoogleFirebaserulesRulesetMetadataOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleFirebaserulesRulesetMetadata | undefined;
    set internalValue(value: GoogleFirebaserulesRulesetMetadata | undefined);
    get services(): string[];
}
export declare class GoogleFirebaserulesRulesetMetadataList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleFirebaserulesRulesetMetadataOutputReference;
}
export interface GoogleFirebaserulesRulesetSourceFiles {
    /**
    * Textual Content.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_firebaserules_ruleset#content GoogleFirebaserulesRuleset#content}
    */
    readonly content: string;
    /**
    * Fingerprint (e.g. github sha) associated with the `File`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_firebaserules_ruleset#fingerprint GoogleFirebaserulesRuleset#fingerprint}
    */
    readonly fingerprint?: string;
    /**
    * File name.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_firebaserules_ruleset#name GoogleFirebaserulesRuleset#name}
    */
    readonly name: string;
}
export declare function googleFirebaserulesRulesetSourceFilesToTerraform(struct?: GoogleFirebaserulesRulesetSourceFiles | cdktf.IResolvable): any;
export declare function googleFirebaserulesRulesetSourceFilesToHclTerraform(struct?: GoogleFirebaserulesRulesetSourceFiles | cdktf.IResolvable): any;
export declare class GoogleFirebaserulesRulesetSourceFilesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleFirebaserulesRulesetSourceFiles | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleFirebaserulesRulesetSourceFiles | cdktf.IResolvable | undefined);
    private _content?;
    get content(): string;
    set content(value: string);
    get contentInput(): string | undefined;
    private _fingerprint?;
    get fingerprint(): string;
    set fingerprint(value: string);
    resetFingerprint(): void;
    get fingerprintInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
}
export declare class GoogleFirebaserulesRulesetSourceFilesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleFirebaserulesRulesetSourceFiles[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleFirebaserulesRulesetSourceFilesOutputReference;
}
export interface GoogleFirebaserulesRulesetSource {
    /**
    * `Language` of the `Source` bundle. If unspecified, the language will default to `FIREBASE_RULES`. Possible values: LANGUAGE_UNSPECIFIED, FIREBASE_RULES, EVENT_FLOW_TRIGGERS
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_firebaserules_ruleset#language GoogleFirebaserulesRuleset#language}
    */
    readonly language?: string;
    /**
    * files block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_firebaserules_ruleset#files GoogleFirebaserulesRuleset#files}
    */
    readonly files: GoogleFirebaserulesRulesetSourceFiles[] | cdktf.IResolvable;
}
export declare function googleFirebaserulesRulesetSourceToTerraform(struct?: GoogleFirebaserulesRulesetSourceOutputReference | GoogleFirebaserulesRulesetSource): any;
export declare function googleFirebaserulesRulesetSourceToHclTerraform(struct?: GoogleFirebaserulesRulesetSourceOutputReference | GoogleFirebaserulesRulesetSource): any;
export declare class GoogleFirebaserulesRulesetSourceOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleFirebaserulesRulesetSource | undefined;
    set internalValue(value: GoogleFirebaserulesRulesetSource | undefined);
    private _language?;
    get language(): string;
    set language(value: string);
    resetLanguage(): void;
    get languageInput(): string | undefined;
    private _files;
    get files(): GoogleFirebaserulesRulesetSourceFilesList;
    putFiles(value: GoogleFirebaserulesRulesetSourceFiles[] | cdktf.IResolvable): void;
    get filesInput(): cdktf.IResolvable | GoogleFirebaserulesRulesetSourceFiles[] | undefined;
}
export interface GoogleFirebaserulesRulesetTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_firebaserules_ruleset#create GoogleFirebaserulesRuleset#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_firebaserules_ruleset#delete GoogleFirebaserulesRuleset#delete}
    */
    readonly delete?: string;
}
export declare function googleFirebaserulesRulesetTimeoutsToTerraform(struct?: GoogleFirebaserulesRulesetTimeouts | cdktf.IResolvable): any;
export declare function googleFirebaserulesRulesetTimeoutsToHclTerraform(struct?: GoogleFirebaserulesRulesetTimeouts | cdktf.IResolvable): any;
export declare class GoogleFirebaserulesRulesetTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleFirebaserulesRulesetTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleFirebaserulesRulesetTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_firebaserules_ruleset google_firebaserules_ruleset}
*/
export declare class GoogleFirebaserulesRuleset extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_firebaserules_ruleset";
    /**
    * Generates CDKTF code for importing a GoogleFirebaserulesRuleset resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the GoogleFirebaserulesRuleset to import
    * @param importFromId The id of the existing GoogleFirebaserulesRuleset that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_firebaserules_ruleset#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the GoogleFirebaserulesRuleset to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_firebaserules_ruleset google_firebaserules_ruleset} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleFirebaserulesRulesetConfig
    */
    constructor(scope: Construct, id: string, config: GoogleFirebaserulesRulesetConfig);
    get createTime(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _metadata;
    get metadata(): GoogleFirebaserulesRulesetMetadataList;
    get name(): string;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _source;
    get source(): GoogleFirebaserulesRulesetSourceOutputReference;
    putSource(value: GoogleFirebaserulesRulesetSource): void;
    get sourceInput(): GoogleFirebaserulesRulesetSource | undefined;
    private _timeouts;
    get timeouts(): GoogleFirebaserulesRulesetTimeoutsOutputReference;
    putTimeouts(value: GoogleFirebaserulesRulesetTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleFirebaserulesRulesetTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
