/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleFirestoreBackupScheduleConfig extends cdktf.TerraformMetaArguments {
    /**
    * The Firestore database id. Defaults to '"(default)"'.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_firestore_backup_schedule#database GoogleFirestoreBackupSchedule#database}
    */
    readonly database?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_firestore_backup_schedule#id GoogleFirestoreBackupSchedule#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_firestore_backup_schedule#project GoogleFirestoreBackupSchedule#project}
    */
    readonly project?: string;
    /**
    * At what relative time in the future, compared to its creation time, the backup should be deleted, e.g. keep backups for 7 days.
    * A duration in seconds with up to nine fractional digits, ending with 's'. Example: "3.5s".
    *
    * For a daily backup recurrence, set this to a value up to 7 days. If you set a weekly backup recurrence, set this to a value up to 14 weeks.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_firestore_backup_schedule#retention GoogleFirestoreBackupSchedule#retention}
    */
    readonly retention: string;
    /**
    * daily_recurrence block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_firestore_backup_schedule#daily_recurrence GoogleFirestoreBackupSchedule#daily_recurrence}
    */
    readonly dailyRecurrence?: GoogleFirestoreBackupScheduleDailyRecurrence;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_firestore_backup_schedule#timeouts GoogleFirestoreBackupSchedule#timeouts}
    */
    readonly timeouts?: GoogleFirestoreBackupScheduleTimeouts;
    /**
    * weekly_recurrence block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_firestore_backup_schedule#weekly_recurrence GoogleFirestoreBackupSchedule#weekly_recurrence}
    */
    readonly weeklyRecurrence?: GoogleFirestoreBackupScheduleWeeklyRecurrence;
}
export interface GoogleFirestoreBackupScheduleDailyRecurrence {
}
export declare function googleFirestoreBackupScheduleDailyRecurrenceToTerraform(struct?: GoogleFirestoreBackupScheduleDailyRecurrenceOutputReference | GoogleFirestoreBackupScheduleDailyRecurrence): any;
export declare function googleFirestoreBackupScheduleDailyRecurrenceToHclTerraform(struct?: GoogleFirestoreBackupScheduleDailyRecurrenceOutputReference | GoogleFirestoreBackupScheduleDailyRecurrence): any;
export declare class GoogleFirestoreBackupScheduleDailyRecurrenceOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleFirestoreBackupScheduleDailyRecurrence | undefined;
    set internalValue(value: GoogleFirestoreBackupScheduleDailyRecurrence | undefined);
}
export interface GoogleFirestoreBackupScheduleTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_firestore_backup_schedule#create GoogleFirestoreBackupSchedule#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_firestore_backup_schedule#delete GoogleFirestoreBackupSchedule#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_firestore_backup_schedule#update GoogleFirestoreBackupSchedule#update}
    */
    readonly update?: string;
}
export declare function googleFirestoreBackupScheduleTimeoutsToTerraform(struct?: GoogleFirestoreBackupScheduleTimeouts | cdktf.IResolvable): any;
export declare function googleFirestoreBackupScheduleTimeoutsToHclTerraform(struct?: GoogleFirestoreBackupScheduleTimeouts | cdktf.IResolvable): any;
export declare class GoogleFirestoreBackupScheduleTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleFirestoreBackupScheduleTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleFirestoreBackupScheduleTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
export interface GoogleFirestoreBackupScheduleWeeklyRecurrence {
    /**
    * The day of week to run. Possible values: ["DAY_OF_WEEK_UNSPECIFIED", "MONDAY", "TUESDAY", "WEDNESDAY", "THURSDAY", "FRIDAY", "SATURDAY", "SUNDAY"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_firestore_backup_schedule#day GoogleFirestoreBackupSchedule#day}
    */
    readonly day?: string;
}
export declare function googleFirestoreBackupScheduleWeeklyRecurrenceToTerraform(struct?: GoogleFirestoreBackupScheduleWeeklyRecurrenceOutputReference | GoogleFirestoreBackupScheduleWeeklyRecurrence): any;
export declare function googleFirestoreBackupScheduleWeeklyRecurrenceToHclTerraform(struct?: GoogleFirestoreBackupScheduleWeeklyRecurrenceOutputReference | GoogleFirestoreBackupScheduleWeeklyRecurrence): any;
export declare class GoogleFirestoreBackupScheduleWeeklyRecurrenceOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleFirestoreBackupScheduleWeeklyRecurrence | undefined;
    set internalValue(value: GoogleFirestoreBackupScheduleWeeklyRecurrence | undefined);
    private _day?;
    get day(): string;
    set day(value: string);
    resetDay(): void;
    get dayInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_firestore_backup_schedule google_firestore_backup_schedule}
*/
export declare class GoogleFirestoreBackupSchedule extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_firestore_backup_schedule";
    /**
    * Generates CDKTF code for importing a GoogleFirestoreBackupSchedule resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the GoogleFirestoreBackupSchedule to import
    * @param importFromId The id of the existing GoogleFirestoreBackupSchedule that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_firestore_backup_schedule#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the GoogleFirestoreBackupSchedule to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_firestore_backup_schedule google_firestore_backup_schedule} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleFirestoreBackupScheduleConfig
    */
    constructor(scope: Construct, id: string, config: GoogleFirestoreBackupScheduleConfig);
    private _database?;
    get database(): string;
    set database(value: string);
    resetDatabase(): void;
    get databaseInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get name(): string;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _retention?;
    get retention(): string;
    set retention(value: string);
    get retentionInput(): string | undefined;
    private _dailyRecurrence;
    get dailyRecurrence(): GoogleFirestoreBackupScheduleDailyRecurrenceOutputReference;
    putDailyRecurrence(value: GoogleFirestoreBackupScheduleDailyRecurrence): void;
    resetDailyRecurrence(): void;
    get dailyRecurrenceInput(): GoogleFirestoreBackupScheduleDailyRecurrence | undefined;
    private _timeouts;
    get timeouts(): GoogleFirestoreBackupScheduleTimeoutsOutputReference;
    putTimeouts(value: GoogleFirestoreBackupScheduleTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleFirestoreBackupScheduleTimeouts | undefined;
    private _weeklyRecurrence;
    get weeklyRecurrence(): GoogleFirestoreBackupScheduleWeeklyRecurrenceOutputReference;
    putWeeklyRecurrence(value: GoogleFirestoreBackupScheduleWeeklyRecurrence): void;
    resetWeeklyRecurrence(): void;
    get weeklyRecurrenceInput(): GoogleFirestoreBackupScheduleWeeklyRecurrence | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
