/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleFirestoreDatabaseConfig extends cdktf.TerraformMetaArguments {
    /**
    * The App Engine integration mode to use for this database. Possible values: ["ENABLED", "DISABLED"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_firestore_database#app_engine_integration_mode GoogleFirestoreDatabase#app_engine_integration_mode}
    */
    readonly appEngineIntegrationMode?: string;
    /**
    * The concurrency control mode to use for this database. Possible values: ["OPTIMISTIC", "PESSIMISTIC", "OPTIMISTIC_WITH_ENTITY_GROUPS"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_firestore_database#concurrency_mode GoogleFirestoreDatabase#concurrency_mode}
    */
    readonly concurrencyMode?: string;
    /**
    * State of delete protection for the database.
    * When delete protection is enabled, this database cannot be deleted.
    * The default value is 'DELETE_PROTECTION_STATE_UNSPECIFIED', which is currently equivalent to 'DELETE_PROTECTION_DISABLED'.
    * **Note:** Additionally, to delete this database using 'terraform destroy', 'deletion_policy' must be set to 'DELETE'. Possible values: ["DELETE_PROTECTION_STATE_UNSPECIFIED", "DELETE_PROTECTION_ENABLED", "DELETE_PROTECTION_DISABLED"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_firestore_database#delete_protection_state GoogleFirestoreDatabase#delete_protection_state}
    */
    readonly deleteProtectionState?: string;
    /**
    * Deletion behavior for this database.
    * If the deletion policy is 'ABANDON', the database will be removed from Terraform state but not deleted from Google Cloud upon destruction.
    * If the deletion policy is 'DELETE', the database will both be removed from Terraform state and deleted from Google Cloud upon destruction.
    * The default value is 'ABANDON'.
    * See also 'delete_protection'.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_firestore_database#deletion_policy GoogleFirestoreDatabase#deletion_policy}
    */
    readonly deletionPolicy?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_firestore_database#id GoogleFirestoreDatabase#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The location of the database. Available locations are listed at
    * https://cloud.google.com/firestore/docs/locations.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_firestore_database#location_id GoogleFirestoreDatabase#location_id}
    */
    readonly locationId: string;
    /**
    * The ID to use for the database, which will become the final
    * component of the database's resource name. This value should be 4-63
    * characters. Valid characters are /[a-z][0-9]-/ with first character
    * a letter and the last a letter or a number. Must not be
    * UUID-like /[0-9a-f]{8}(-[0-9a-f]{4}){3}-[0-9a-f]{12}/.
    * "(default)" database id is also valid.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_firestore_database#name GoogleFirestoreDatabase#name}
    */
    readonly name: string;
    /**
    * Whether to enable the PITR feature on this database.
    * If 'POINT_IN_TIME_RECOVERY_ENABLED' is selected, reads are supported on selected versions of the data from within the past 7 days.
    * versionRetentionPeriod and earliestVersionTime can be used to determine the supported versions. These include reads against any timestamp within the past hour
    * and reads against 1-minute snapshots beyond 1 hour and within 7 days.
    * If 'POINT_IN_TIME_RECOVERY_DISABLED' is selected, reads are supported on any version of the data from within the past 1 hour. Default value: "POINT_IN_TIME_RECOVERY_DISABLED" Possible values: ["POINT_IN_TIME_RECOVERY_ENABLED", "POINT_IN_TIME_RECOVERY_DISABLED"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_firestore_database#point_in_time_recovery_enablement GoogleFirestoreDatabase#point_in_time_recovery_enablement}
    */
    readonly pointInTimeRecoveryEnablement?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_firestore_database#project GoogleFirestoreDatabase#project}
    */
    readonly project?: string;
    /**
    * The type of the database.
    * See https://cloud.google.com/datastore/docs/firestore-or-datastore
    * for information about how to choose. Possible values: ["FIRESTORE_NATIVE", "DATASTORE_MODE"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_firestore_database#type GoogleFirestoreDatabase#type}
    */
    readonly type: string;
    /**
    * cmek_config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_firestore_database#cmek_config GoogleFirestoreDatabase#cmek_config}
    */
    readonly cmekConfig?: GoogleFirestoreDatabaseCmekConfig;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_firestore_database#timeouts GoogleFirestoreDatabase#timeouts}
    */
    readonly timeouts?: GoogleFirestoreDatabaseTimeouts;
}
export interface GoogleFirestoreDatabaseCmekConfig {
    /**
    * The resource ID of a Cloud KMS key. If set, the database created will
    * be a Customer-managed Encryption Key (CMEK) database encrypted with
    * this key. This feature is allowlist only in initial launch.
    *
    * Only keys in the same location as this database are allowed to be used
    * for encryption. For Firestore's nam5 multi-region, this corresponds to Cloud KMS
    * multi-region us. For Firestore's eur3 multi-region, this corresponds to
    * Cloud KMS multi-region europe. See https://cloud.google.com/kms/docs/locations.
    *
    * This value should be the KMS key resource ID in the format of
    * 'projects/{project_id}/locations/{kms_location}/keyRings/{key_ring}/cryptoKeys/{crypto_key}'.
    * How to retrive this resource ID is listed at
    * https://cloud.google.com/kms/docs/getting-resource-ids#getting_the_id_for_a_key_and_version.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_firestore_database#kms_key_name GoogleFirestoreDatabase#kms_key_name}
    */
    readonly kmsKeyName: string;
}
export declare function googleFirestoreDatabaseCmekConfigToTerraform(struct?: GoogleFirestoreDatabaseCmekConfigOutputReference | GoogleFirestoreDatabaseCmekConfig): any;
export declare function googleFirestoreDatabaseCmekConfigToHclTerraform(struct?: GoogleFirestoreDatabaseCmekConfigOutputReference | GoogleFirestoreDatabaseCmekConfig): any;
export declare class GoogleFirestoreDatabaseCmekConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleFirestoreDatabaseCmekConfig | undefined;
    set internalValue(value: GoogleFirestoreDatabaseCmekConfig | undefined);
    get activeKeyVersion(): string[];
    private _kmsKeyName?;
    get kmsKeyName(): string;
    set kmsKeyName(value: string);
    get kmsKeyNameInput(): string | undefined;
}
export interface GoogleFirestoreDatabaseTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_firestore_database#create GoogleFirestoreDatabase#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_firestore_database#delete GoogleFirestoreDatabase#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_firestore_database#update GoogleFirestoreDatabase#update}
    */
    readonly update?: string;
}
export declare function googleFirestoreDatabaseTimeoutsToTerraform(struct?: GoogleFirestoreDatabaseTimeouts | cdktf.IResolvable): any;
export declare function googleFirestoreDatabaseTimeoutsToHclTerraform(struct?: GoogleFirestoreDatabaseTimeouts | cdktf.IResolvable): any;
export declare class GoogleFirestoreDatabaseTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleFirestoreDatabaseTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleFirestoreDatabaseTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_firestore_database google_firestore_database}
*/
export declare class GoogleFirestoreDatabase extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_firestore_database";
    /**
    * Generates CDKTF code for importing a GoogleFirestoreDatabase resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the GoogleFirestoreDatabase to import
    * @param importFromId The id of the existing GoogleFirestoreDatabase that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_firestore_database#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the GoogleFirestoreDatabase to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_firestore_database google_firestore_database} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleFirestoreDatabaseConfig
    */
    constructor(scope: Construct, id: string, config: GoogleFirestoreDatabaseConfig);
    private _appEngineIntegrationMode?;
    get appEngineIntegrationMode(): string;
    set appEngineIntegrationMode(value: string);
    resetAppEngineIntegrationMode(): void;
    get appEngineIntegrationModeInput(): string | undefined;
    private _concurrencyMode?;
    get concurrencyMode(): string;
    set concurrencyMode(value: string);
    resetConcurrencyMode(): void;
    get concurrencyModeInput(): string | undefined;
    get createTime(): string;
    private _deleteProtectionState?;
    get deleteProtectionState(): string;
    set deleteProtectionState(value: string);
    resetDeleteProtectionState(): void;
    get deleteProtectionStateInput(): string | undefined;
    private _deletionPolicy?;
    get deletionPolicy(): string;
    set deletionPolicy(value: string);
    resetDeletionPolicy(): void;
    get deletionPolicyInput(): string | undefined;
    get earliestVersionTime(): string;
    get etag(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get keyPrefix(): string;
    private _locationId?;
    get locationId(): string;
    set locationId(value: string);
    get locationIdInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _pointInTimeRecoveryEnablement?;
    get pointInTimeRecoveryEnablement(): string;
    set pointInTimeRecoveryEnablement(value: string);
    resetPointInTimeRecoveryEnablement(): void;
    get pointInTimeRecoveryEnablementInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
    get uid(): string;
    get updateTime(): string;
    get versionRetentionPeriod(): string;
    private _cmekConfig;
    get cmekConfig(): GoogleFirestoreDatabaseCmekConfigOutputReference;
    putCmekConfig(value: GoogleFirestoreDatabaseCmekConfig): void;
    resetCmekConfig(): void;
    get cmekConfigInput(): GoogleFirestoreDatabaseCmekConfig | undefined;
    private _timeouts;
    get timeouts(): GoogleFirestoreDatabaseTimeoutsOutputReference;
    putTimeouts(value: GoogleFirestoreDatabaseTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleFirestoreDatabaseTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
