/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleFirestoreFieldConfig extends cdktf.TerraformMetaArguments {
    /**
    * The id of the collection group to configure.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_firestore_field#collection GoogleFirestoreField#collection}
    */
    readonly collection: string;
    /**
    * The Firestore database id. Defaults to '"(default)"'.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_firestore_field#database GoogleFirestoreField#database}
    */
    readonly database?: string;
    /**
    * The id of the field to configure.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_firestore_field#field GoogleFirestoreField#field}
    */
    readonly field: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_firestore_field#id GoogleFirestoreField#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_firestore_field#project GoogleFirestoreField#project}
    */
    readonly project?: string;
    /**
    * index_config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_firestore_field#index_config GoogleFirestoreField#index_config}
    */
    readonly indexConfig?: GoogleFirestoreFieldIndexConfig;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_firestore_field#timeouts GoogleFirestoreField#timeouts}
    */
    readonly timeouts?: GoogleFirestoreFieldTimeouts;
    /**
    * ttl_config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_firestore_field#ttl_config GoogleFirestoreField#ttl_config}
    */
    readonly ttlConfig?: GoogleFirestoreFieldTtlConfig;
}
export interface GoogleFirestoreFieldIndexConfigIndexes {
    /**
    * Indicates that this field supports operations on arrayValues. Only one of 'order' and 'arrayConfig' can
    * be specified. Possible values: ["CONTAINS"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_firestore_field#array_config GoogleFirestoreField#array_config}
    */
    readonly arrayConfig?: string;
    /**
    * Indicates that this field supports ordering by the specified order or comparing using =, <, <=, >, >=, !=.
    * Only one of 'order' and 'arrayConfig' can be specified. Possible values: ["ASCENDING", "DESCENDING"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_firestore_field#order GoogleFirestoreField#order}
    */
    readonly order?: string;
    /**
    * The scope at which a query is run. Collection scoped queries require you specify
    * the collection at query time. Collection group scope allows queries across all
    * collections with the same id. Default value: "COLLECTION" Possible values: ["COLLECTION", "COLLECTION_GROUP"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_firestore_field#query_scope GoogleFirestoreField#query_scope}
    */
    readonly queryScope?: string;
}
export declare function googleFirestoreFieldIndexConfigIndexesToTerraform(struct?: GoogleFirestoreFieldIndexConfigIndexes | cdktf.IResolvable): any;
export declare function googleFirestoreFieldIndexConfigIndexesToHclTerraform(struct?: GoogleFirestoreFieldIndexConfigIndexes | cdktf.IResolvable): any;
export declare class GoogleFirestoreFieldIndexConfigIndexesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleFirestoreFieldIndexConfigIndexes | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleFirestoreFieldIndexConfigIndexes | cdktf.IResolvable | undefined);
    private _arrayConfig?;
    get arrayConfig(): string;
    set arrayConfig(value: string);
    resetArrayConfig(): void;
    get arrayConfigInput(): string | undefined;
    private _order?;
    get order(): string;
    set order(value: string);
    resetOrder(): void;
    get orderInput(): string | undefined;
    private _queryScope?;
    get queryScope(): string;
    set queryScope(value: string);
    resetQueryScope(): void;
    get queryScopeInput(): string | undefined;
}
export declare class GoogleFirestoreFieldIndexConfigIndexesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleFirestoreFieldIndexConfigIndexes[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleFirestoreFieldIndexConfigIndexesOutputReference;
}
export interface GoogleFirestoreFieldIndexConfig {
    /**
    * indexes block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_firestore_field#indexes GoogleFirestoreField#indexes}
    */
    readonly indexes?: GoogleFirestoreFieldIndexConfigIndexes[] | cdktf.IResolvable;
}
export declare function googleFirestoreFieldIndexConfigToTerraform(struct?: GoogleFirestoreFieldIndexConfigOutputReference | GoogleFirestoreFieldIndexConfig): any;
export declare function googleFirestoreFieldIndexConfigToHclTerraform(struct?: GoogleFirestoreFieldIndexConfigOutputReference | GoogleFirestoreFieldIndexConfig): any;
export declare class GoogleFirestoreFieldIndexConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleFirestoreFieldIndexConfig | undefined;
    set internalValue(value: GoogleFirestoreFieldIndexConfig | undefined);
    private _indexes;
    get indexes(): GoogleFirestoreFieldIndexConfigIndexesList;
    putIndexes(value: GoogleFirestoreFieldIndexConfigIndexes[] | cdktf.IResolvable): void;
    resetIndexes(): void;
    get indexesInput(): cdktf.IResolvable | GoogleFirestoreFieldIndexConfigIndexes[] | undefined;
}
export interface GoogleFirestoreFieldTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_firestore_field#create GoogleFirestoreField#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_firestore_field#delete GoogleFirestoreField#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_firestore_field#update GoogleFirestoreField#update}
    */
    readonly update?: string;
}
export declare function googleFirestoreFieldTimeoutsToTerraform(struct?: GoogleFirestoreFieldTimeouts | cdktf.IResolvable): any;
export declare function googleFirestoreFieldTimeoutsToHclTerraform(struct?: GoogleFirestoreFieldTimeouts | cdktf.IResolvable): any;
export declare class GoogleFirestoreFieldTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleFirestoreFieldTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleFirestoreFieldTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
export interface GoogleFirestoreFieldTtlConfig {
}
export declare function googleFirestoreFieldTtlConfigToTerraform(struct?: GoogleFirestoreFieldTtlConfigOutputReference | GoogleFirestoreFieldTtlConfig): any;
export declare function googleFirestoreFieldTtlConfigToHclTerraform(struct?: GoogleFirestoreFieldTtlConfigOutputReference | GoogleFirestoreFieldTtlConfig): any;
export declare class GoogleFirestoreFieldTtlConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleFirestoreFieldTtlConfig | undefined;
    set internalValue(value: GoogleFirestoreFieldTtlConfig | undefined);
    get state(): string;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_firestore_field google_firestore_field}
*/
export declare class GoogleFirestoreField extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_firestore_field";
    /**
    * Generates CDKTF code for importing a GoogleFirestoreField resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the GoogleFirestoreField to import
    * @param importFromId The id of the existing GoogleFirestoreField that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_firestore_field#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the GoogleFirestoreField to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_firestore_field google_firestore_field} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleFirestoreFieldConfig
    */
    constructor(scope: Construct, id: string, config: GoogleFirestoreFieldConfig);
    private _collection?;
    get collection(): string;
    set collection(value: string);
    get collectionInput(): string | undefined;
    private _database?;
    get database(): string;
    set database(value: string);
    resetDatabase(): void;
    get databaseInput(): string | undefined;
    private _field?;
    get field(): string;
    set field(value: string);
    get fieldInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get name(): string;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _indexConfig;
    get indexConfig(): GoogleFirestoreFieldIndexConfigOutputReference;
    putIndexConfig(value: GoogleFirestoreFieldIndexConfig): void;
    resetIndexConfig(): void;
    get indexConfigInput(): GoogleFirestoreFieldIndexConfig | undefined;
    private _timeouts;
    get timeouts(): GoogleFirestoreFieldTimeoutsOutputReference;
    putTimeouts(value: GoogleFirestoreFieldTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleFirestoreFieldTimeouts | undefined;
    private _ttlConfig;
    get ttlConfig(): GoogleFirestoreFieldTtlConfigOutputReference;
    putTtlConfig(value: GoogleFirestoreFieldTtlConfig): void;
    resetTtlConfig(): void;
    get ttlConfigInput(): GoogleFirestoreFieldTtlConfig | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
