/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleGkeBackupRestorePlanConfig extends cdktf.TerraformMetaArguments {
    /**
    * A reference to the BackupPlan from which Backups may be used
    * as the source for Restores created via this RestorePlan.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gke_backup_restore_plan#backup_plan GoogleGkeBackupRestorePlan#backup_plan}
    */
    readonly backupPlan: string;
    /**
    * The source cluster from which Restores will be created via this RestorePlan.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gke_backup_restore_plan#cluster GoogleGkeBackupRestorePlan#cluster}
    */
    readonly cluster: string;
    /**
    * User specified descriptive string for this RestorePlan.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gke_backup_restore_plan#description GoogleGkeBackupRestorePlan#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gke_backup_restore_plan#id GoogleGkeBackupRestorePlan#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Description: A set of custom labels supplied by the user.
    * A list of key->value pairs.
    * Example: { "name": "wrench", "mass": "1.3kg", "count": "3" }.
    *
    *
    * **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
    * Please refer to the field 'effective_labels' for all of the labels present on the resource.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gke_backup_restore_plan#labels GoogleGkeBackupRestorePlan#labels}
    */
    readonly labels?: {
        [key: string]: string;
    };
    /**
    * The region of the Restore Plan.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gke_backup_restore_plan#location GoogleGkeBackupRestorePlan#location}
    */
    readonly location: string;
    /**
    * The full name of the BackupPlan Resource.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gke_backup_restore_plan#name GoogleGkeBackupRestorePlan#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gke_backup_restore_plan#project GoogleGkeBackupRestorePlan#project}
    */
    readonly project?: string;
    /**
    * restore_config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gke_backup_restore_plan#restore_config GoogleGkeBackupRestorePlan#restore_config}
    */
    readonly restoreConfig: GoogleGkeBackupRestorePlanRestoreConfig;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gke_backup_restore_plan#timeouts GoogleGkeBackupRestorePlan#timeouts}
    */
    readonly timeouts?: GoogleGkeBackupRestorePlanTimeouts;
}
export interface GoogleGkeBackupRestorePlanRestoreConfigClusterResourceRestoreScopeExcludedGroupKinds {
    /**
    * API Group string of a Kubernetes resource, e.g.
    * "apiextensions.k8s.io", "storage.k8s.io", etc.
    * Use empty string for core group.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gke_backup_restore_plan#resource_group GoogleGkeBackupRestorePlan#resource_group}
    */
    readonly resourceGroup?: string;
    /**
    * Kind of a Kubernetes resource, e.g.
    * "CustomResourceDefinition", "StorageClass", etc.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gke_backup_restore_plan#resource_kind GoogleGkeBackupRestorePlan#resource_kind}
    */
    readonly resourceKind?: string;
}
export declare function googleGkeBackupRestorePlanRestoreConfigClusterResourceRestoreScopeExcludedGroupKindsToTerraform(struct?: GoogleGkeBackupRestorePlanRestoreConfigClusterResourceRestoreScopeExcludedGroupKinds | cdktf.IResolvable): any;
export declare function googleGkeBackupRestorePlanRestoreConfigClusterResourceRestoreScopeExcludedGroupKindsToHclTerraform(struct?: GoogleGkeBackupRestorePlanRestoreConfigClusterResourceRestoreScopeExcludedGroupKinds | cdktf.IResolvable): any;
export declare class GoogleGkeBackupRestorePlanRestoreConfigClusterResourceRestoreScopeExcludedGroupKindsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleGkeBackupRestorePlanRestoreConfigClusterResourceRestoreScopeExcludedGroupKinds | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleGkeBackupRestorePlanRestoreConfigClusterResourceRestoreScopeExcludedGroupKinds | cdktf.IResolvable | undefined);
    private _resourceGroup?;
    get resourceGroup(): string;
    set resourceGroup(value: string);
    resetResourceGroup(): void;
    get resourceGroupInput(): string | undefined;
    private _resourceKind?;
    get resourceKind(): string;
    set resourceKind(value: string);
    resetResourceKind(): void;
    get resourceKindInput(): string | undefined;
}
export declare class GoogleGkeBackupRestorePlanRestoreConfigClusterResourceRestoreScopeExcludedGroupKindsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleGkeBackupRestorePlanRestoreConfigClusterResourceRestoreScopeExcludedGroupKinds[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleGkeBackupRestorePlanRestoreConfigClusterResourceRestoreScopeExcludedGroupKindsOutputReference;
}
export interface GoogleGkeBackupRestorePlanRestoreConfigClusterResourceRestoreScopeSelectedGroupKinds {
    /**
    * API Group string of a Kubernetes resource, e.g.
    * "apiextensions.k8s.io", "storage.k8s.io", etc.
    * Use empty string for core group.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gke_backup_restore_plan#resource_group GoogleGkeBackupRestorePlan#resource_group}
    */
    readonly resourceGroup?: string;
    /**
    * Kind of a Kubernetes resource, e.g.
    * "CustomResourceDefinition", "StorageClass", etc.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gke_backup_restore_plan#resource_kind GoogleGkeBackupRestorePlan#resource_kind}
    */
    readonly resourceKind?: string;
}
export declare function googleGkeBackupRestorePlanRestoreConfigClusterResourceRestoreScopeSelectedGroupKindsToTerraform(struct?: GoogleGkeBackupRestorePlanRestoreConfigClusterResourceRestoreScopeSelectedGroupKinds | cdktf.IResolvable): any;
export declare function googleGkeBackupRestorePlanRestoreConfigClusterResourceRestoreScopeSelectedGroupKindsToHclTerraform(struct?: GoogleGkeBackupRestorePlanRestoreConfigClusterResourceRestoreScopeSelectedGroupKinds | cdktf.IResolvable): any;
export declare class GoogleGkeBackupRestorePlanRestoreConfigClusterResourceRestoreScopeSelectedGroupKindsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleGkeBackupRestorePlanRestoreConfigClusterResourceRestoreScopeSelectedGroupKinds | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleGkeBackupRestorePlanRestoreConfigClusterResourceRestoreScopeSelectedGroupKinds | cdktf.IResolvable | undefined);
    private _resourceGroup?;
    get resourceGroup(): string;
    set resourceGroup(value: string);
    resetResourceGroup(): void;
    get resourceGroupInput(): string | undefined;
    private _resourceKind?;
    get resourceKind(): string;
    set resourceKind(value: string);
    resetResourceKind(): void;
    get resourceKindInput(): string | undefined;
}
export declare class GoogleGkeBackupRestorePlanRestoreConfigClusterResourceRestoreScopeSelectedGroupKindsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleGkeBackupRestorePlanRestoreConfigClusterResourceRestoreScopeSelectedGroupKinds[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleGkeBackupRestorePlanRestoreConfigClusterResourceRestoreScopeSelectedGroupKindsOutputReference;
}
export interface GoogleGkeBackupRestorePlanRestoreConfigClusterResourceRestoreScope {
    /**
    * If True, all valid cluster-scoped resources will be restored.
    * Mutually exclusive to any other field in 'clusterResourceRestoreScope'.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gke_backup_restore_plan#all_group_kinds GoogleGkeBackupRestorePlan#all_group_kinds}
    */
    readonly allGroupKinds?: boolean | cdktf.IResolvable;
    /**
    * If True, no cluster-scoped resources will be restored.
    * Mutually exclusive to any other field in 'clusterResourceRestoreScope'.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gke_backup_restore_plan#no_group_kinds GoogleGkeBackupRestorePlan#no_group_kinds}
    */
    readonly noGroupKinds?: boolean | cdktf.IResolvable;
    /**
    * excluded_group_kinds block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gke_backup_restore_plan#excluded_group_kinds GoogleGkeBackupRestorePlan#excluded_group_kinds}
    */
    readonly excludedGroupKinds?: GoogleGkeBackupRestorePlanRestoreConfigClusterResourceRestoreScopeExcludedGroupKinds[] | cdktf.IResolvable;
    /**
    * selected_group_kinds block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gke_backup_restore_plan#selected_group_kinds GoogleGkeBackupRestorePlan#selected_group_kinds}
    */
    readonly selectedGroupKinds?: GoogleGkeBackupRestorePlanRestoreConfigClusterResourceRestoreScopeSelectedGroupKinds[] | cdktf.IResolvable;
}
export declare function googleGkeBackupRestorePlanRestoreConfigClusterResourceRestoreScopeToTerraform(struct?: GoogleGkeBackupRestorePlanRestoreConfigClusterResourceRestoreScopeOutputReference | GoogleGkeBackupRestorePlanRestoreConfigClusterResourceRestoreScope): any;
export declare function googleGkeBackupRestorePlanRestoreConfigClusterResourceRestoreScopeToHclTerraform(struct?: GoogleGkeBackupRestorePlanRestoreConfigClusterResourceRestoreScopeOutputReference | GoogleGkeBackupRestorePlanRestoreConfigClusterResourceRestoreScope): any;
export declare class GoogleGkeBackupRestorePlanRestoreConfigClusterResourceRestoreScopeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleGkeBackupRestorePlanRestoreConfigClusterResourceRestoreScope | undefined;
    set internalValue(value: GoogleGkeBackupRestorePlanRestoreConfigClusterResourceRestoreScope | undefined);
    private _allGroupKinds?;
    get allGroupKinds(): boolean | cdktf.IResolvable;
    set allGroupKinds(value: boolean | cdktf.IResolvable);
    resetAllGroupKinds(): void;
    get allGroupKindsInput(): boolean | cdktf.IResolvable | undefined;
    private _noGroupKinds?;
    get noGroupKinds(): boolean | cdktf.IResolvable;
    set noGroupKinds(value: boolean | cdktf.IResolvable);
    resetNoGroupKinds(): void;
    get noGroupKindsInput(): boolean | cdktf.IResolvable | undefined;
    private _excludedGroupKinds;
    get excludedGroupKinds(): GoogleGkeBackupRestorePlanRestoreConfigClusterResourceRestoreScopeExcludedGroupKindsList;
    putExcludedGroupKinds(value: GoogleGkeBackupRestorePlanRestoreConfigClusterResourceRestoreScopeExcludedGroupKinds[] | cdktf.IResolvable): void;
    resetExcludedGroupKinds(): void;
    get excludedGroupKindsInput(): cdktf.IResolvable | GoogleGkeBackupRestorePlanRestoreConfigClusterResourceRestoreScopeExcludedGroupKinds[] | undefined;
    private _selectedGroupKinds;
    get selectedGroupKinds(): GoogleGkeBackupRestorePlanRestoreConfigClusterResourceRestoreScopeSelectedGroupKindsList;
    putSelectedGroupKinds(value: GoogleGkeBackupRestorePlanRestoreConfigClusterResourceRestoreScopeSelectedGroupKinds[] | cdktf.IResolvable): void;
    resetSelectedGroupKinds(): void;
    get selectedGroupKindsInput(): cdktf.IResolvable | GoogleGkeBackupRestorePlanRestoreConfigClusterResourceRestoreScopeSelectedGroupKinds[] | undefined;
}
export interface GoogleGkeBackupRestorePlanRestoreConfigExcludedNamespaces {
    /**
    * A list of Kubernetes Namespaces.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gke_backup_restore_plan#namespaces GoogleGkeBackupRestorePlan#namespaces}
    */
    readonly namespaces: string[];
}
export declare function googleGkeBackupRestorePlanRestoreConfigExcludedNamespacesToTerraform(struct?: GoogleGkeBackupRestorePlanRestoreConfigExcludedNamespacesOutputReference | GoogleGkeBackupRestorePlanRestoreConfigExcludedNamespaces): any;
export declare function googleGkeBackupRestorePlanRestoreConfigExcludedNamespacesToHclTerraform(struct?: GoogleGkeBackupRestorePlanRestoreConfigExcludedNamespacesOutputReference | GoogleGkeBackupRestorePlanRestoreConfigExcludedNamespaces): any;
export declare class GoogleGkeBackupRestorePlanRestoreConfigExcludedNamespacesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleGkeBackupRestorePlanRestoreConfigExcludedNamespaces | undefined;
    set internalValue(value: GoogleGkeBackupRestorePlanRestoreConfigExcludedNamespaces | undefined);
    private _namespaces?;
    get namespaces(): string[];
    set namespaces(value: string[]);
    get namespacesInput(): string[] | undefined;
}
export interface GoogleGkeBackupRestorePlanRestoreConfigSelectedApplicationsNamespacedNames {
    /**
    * The name of a Kubernetes Resource.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gke_backup_restore_plan#name GoogleGkeBackupRestorePlan#name}
    */
    readonly name: string;
    /**
    * The namespace of a Kubernetes Resource.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gke_backup_restore_plan#namespace GoogleGkeBackupRestorePlan#namespace}
    */
    readonly namespace: string;
}
export declare function googleGkeBackupRestorePlanRestoreConfigSelectedApplicationsNamespacedNamesToTerraform(struct?: GoogleGkeBackupRestorePlanRestoreConfigSelectedApplicationsNamespacedNames | cdktf.IResolvable): any;
export declare function googleGkeBackupRestorePlanRestoreConfigSelectedApplicationsNamespacedNamesToHclTerraform(struct?: GoogleGkeBackupRestorePlanRestoreConfigSelectedApplicationsNamespacedNames | cdktf.IResolvable): any;
export declare class GoogleGkeBackupRestorePlanRestoreConfigSelectedApplicationsNamespacedNamesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleGkeBackupRestorePlanRestoreConfigSelectedApplicationsNamespacedNames | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleGkeBackupRestorePlanRestoreConfigSelectedApplicationsNamespacedNames | cdktf.IResolvable | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _namespace?;
    get namespace(): string;
    set namespace(value: string);
    get namespaceInput(): string | undefined;
}
export declare class GoogleGkeBackupRestorePlanRestoreConfigSelectedApplicationsNamespacedNamesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleGkeBackupRestorePlanRestoreConfigSelectedApplicationsNamespacedNames[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleGkeBackupRestorePlanRestoreConfigSelectedApplicationsNamespacedNamesOutputReference;
}
export interface GoogleGkeBackupRestorePlanRestoreConfigSelectedApplications {
    /**
    * namespaced_names block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gke_backup_restore_plan#namespaced_names GoogleGkeBackupRestorePlan#namespaced_names}
    */
    readonly namespacedNames: GoogleGkeBackupRestorePlanRestoreConfigSelectedApplicationsNamespacedNames[] | cdktf.IResolvable;
}
export declare function googleGkeBackupRestorePlanRestoreConfigSelectedApplicationsToTerraform(struct?: GoogleGkeBackupRestorePlanRestoreConfigSelectedApplicationsOutputReference | GoogleGkeBackupRestorePlanRestoreConfigSelectedApplications): any;
export declare function googleGkeBackupRestorePlanRestoreConfigSelectedApplicationsToHclTerraform(struct?: GoogleGkeBackupRestorePlanRestoreConfigSelectedApplicationsOutputReference | GoogleGkeBackupRestorePlanRestoreConfigSelectedApplications): any;
export declare class GoogleGkeBackupRestorePlanRestoreConfigSelectedApplicationsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleGkeBackupRestorePlanRestoreConfigSelectedApplications | undefined;
    set internalValue(value: GoogleGkeBackupRestorePlanRestoreConfigSelectedApplications | undefined);
    private _namespacedNames;
    get namespacedNames(): GoogleGkeBackupRestorePlanRestoreConfigSelectedApplicationsNamespacedNamesList;
    putNamespacedNames(value: GoogleGkeBackupRestorePlanRestoreConfigSelectedApplicationsNamespacedNames[] | cdktf.IResolvable): void;
    get namespacedNamesInput(): cdktf.IResolvable | GoogleGkeBackupRestorePlanRestoreConfigSelectedApplicationsNamespacedNames[] | undefined;
}
export interface GoogleGkeBackupRestorePlanRestoreConfigSelectedNamespaces {
    /**
    * A list of Kubernetes Namespaces.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gke_backup_restore_plan#namespaces GoogleGkeBackupRestorePlan#namespaces}
    */
    readonly namespaces: string[];
}
export declare function googleGkeBackupRestorePlanRestoreConfigSelectedNamespacesToTerraform(struct?: GoogleGkeBackupRestorePlanRestoreConfigSelectedNamespacesOutputReference | GoogleGkeBackupRestorePlanRestoreConfigSelectedNamespaces): any;
export declare function googleGkeBackupRestorePlanRestoreConfigSelectedNamespacesToHclTerraform(struct?: GoogleGkeBackupRestorePlanRestoreConfigSelectedNamespacesOutputReference | GoogleGkeBackupRestorePlanRestoreConfigSelectedNamespaces): any;
export declare class GoogleGkeBackupRestorePlanRestoreConfigSelectedNamespacesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleGkeBackupRestorePlanRestoreConfigSelectedNamespaces | undefined;
    set internalValue(value: GoogleGkeBackupRestorePlanRestoreConfigSelectedNamespaces | undefined);
    private _namespaces?;
    get namespaces(): string[];
    set namespaces(value: string[]);
    get namespacesInput(): string[] | undefined;
}
export interface GoogleGkeBackupRestorePlanRestoreConfigTransformationRulesFieldActions {
    /**
    * A string containing a JSON Pointer value that references the
    * location in the target document to move the value from.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gke_backup_restore_plan#from_path GoogleGkeBackupRestorePlan#from_path}
    */
    readonly fromPath?: string;
    /**
    * Specifies the operation to perform. Possible values: ["REMOVE", "MOVE", "COPY", "ADD", "TEST", "REPLACE"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gke_backup_restore_plan#op GoogleGkeBackupRestorePlan#op}
    */
    readonly op: string;
    /**
    * A string containing a JSON-Pointer value that references a
    * location within the target document where the operation is performed.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gke_backup_restore_plan#path GoogleGkeBackupRestorePlan#path}
    */
    readonly path?: string;
    /**
    * A string that specifies the desired value in string format
    * to use for transformation.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gke_backup_restore_plan#value GoogleGkeBackupRestorePlan#value}
    */
    readonly value?: string;
}
export declare function googleGkeBackupRestorePlanRestoreConfigTransformationRulesFieldActionsToTerraform(struct?: GoogleGkeBackupRestorePlanRestoreConfigTransformationRulesFieldActions | cdktf.IResolvable): any;
export declare function googleGkeBackupRestorePlanRestoreConfigTransformationRulesFieldActionsToHclTerraform(struct?: GoogleGkeBackupRestorePlanRestoreConfigTransformationRulesFieldActions | cdktf.IResolvable): any;
export declare class GoogleGkeBackupRestorePlanRestoreConfigTransformationRulesFieldActionsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleGkeBackupRestorePlanRestoreConfigTransformationRulesFieldActions | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleGkeBackupRestorePlanRestoreConfigTransformationRulesFieldActions | cdktf.IResolvable | undefined);
    private _fromPath?;
    get fromPath(): string;
    set fromPath(value: string);
    resetFromPath(): void;
    get fromPathInput(): string | undefined;
    private _op?;
    get op(): string;
    set op(value: string);
    get opInput(): string | undefined;
    private _path?;
    get path(): string;
    set path(value: string);
    resetPath(): void;
    get pathInput(): string | undefined;
    private _value?;
    get value(): string;
    set value(value: string);
    resetValue(): void;
    get valueInput(): string | undefined;
}
export declare class GoogleGkeBackupRestorePlanRestoreConfigTransformationRulesFieldActionsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleGkeBackupRestorePlanRestoreConfigTransformationRulesFieldActions[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleGkeBackupRestorePlanRestoreConfigTransformationRulesFieldActionsOutputReference;
}
export interface GoogleGkeBackupRestorePlanRestoreConfigTransformationRulesResourceFilterGroupKinds {
    /**
    * API Group string of a Kubernetes resource, e.g.
    * "apiextensions.k8s.io", "storage.k8s.io", etc.
    * Use empty string for core group.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gke_backup_restore_plan#resource_group GoogleGkeBackupRestorePlan#resource_group}
    */
    readonly resourceGroup?: string;
    /**
    * Kind of a Kubernetes resource, e.g.
    * "CustomResourceDefinition", "StorageClass", etc.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gke_backup_restore_plan#resource_kind GoogleGkeBackupRestorePlan#resource_kind}
    */
    readonly resourceKind?: string;
}
export declare function googleGkeBackupRestorePlanRestoreConfigTransformationRulesResourceFilterGroupKindsToTerraform(struct?: GoogleGkeBackupRestorePlanRestoreConfigTransformationRulesResourceFilterGroupKinds | cdktf.IResolvable): any;
export declare function googleGkeBackupRestorePlanRestoreConfigTransformationRulesResourceFilterGroupKindsToHclTerraform(struct?: GoogleGkeBackupRestorePlanRestoreConfigTransformationRulesResourceFilterGroupKinds | cdktf.IResolvable): any;
export declare class GoogleGkeBackupRestorePlanRestoreConfigTransformationRulesResourceFilterGroupKindsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleGkeBackupRestorePlanRestoreConfigTransformationRulesResourceFilterGroupKinds | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleGkeBackupRestorePlanRestoreConfigTransformationRulesResourceFilterGroupKinds | cdktf.IResolvable | undefined);
    private _resourceGroup?;
    get resourceGroup(): string;
    set resourceGroup(value: string);
    resetResourceGroup(): void;
    get resourceGroupInput(): string | undefined;
    private _resourceKind?;
    get resourceKind(): string;
    set resourceKind(value: string);
    resetResourceKind(): void;
    get resourceKindInput(): string | undefined;
}
export declare class GoogleGkeBackupRestorePlanRestoreConfigTransformationRulesResourceFilterGroupKindsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleGkeBackupRestorePlanRestoreConfigTransformationRulesResourceFilterGroupKinds[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleGkeBackupRestorePlanRestoreConfigTransformationRulesResourceFilterGroupKindsOutputReference;
}
export interface GoogleGkeBackupRestorePlanRestoreConfigTransformationRulesResourceFilter {
    /**
    * This is a JSONPath expression that matches specific fields of
    * candidate resources and it operates as a filtering parameter
    * (resources that are not matched with this expression will not
    * be candidates for transformation).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gke_backup_restore_plan#json_path GoogleGkeBackupRestorePlan#json_path}
    */
    readonly jsonPath?: string;
    /**
    * (Filtering parameter) Any resource subject to transformation must
    * be contained within one of the listed Kubernetes Namespace in the
    * Backup. If this field is not provided, no namespace filtering will
    * be performed (all resources in all Namespaces, including all
    * cluster-scoped resources, will be candidates for transformation).
    * To mix cluster-scoped and namespaced resources in the same rule,
    * use an empty string ("") as one of the target namespaces.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gke_backup_restore_plan#namespaces GoogleGkeBackupRestorePlan#namespaces}
    */
    readonly namespaces?: string[];
    /**
    * group_kinds block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gke_backup_restore_plan#group_kinds GoogleGkeBackupRestorePlan#group_kinds}
    */
    readonly groupKinds?: GoogleGkeBackupRestorePlanRestoreConfigTransformationRulesResourceFilterGroupKinds[] | cdktf.IResolvable;
}
export declare function googleGkeBackupRestorePlanRestoreConfigTransformationRulesResourceFilterToTerraform(struct?: GoogleGkeBackupRestorePlanRestoreConfigTransformationRulesResourceFilterOutputReference | GoogleGkeBackupRestorePlanRestoreConfigTransformationRulesResourceFilter): any;
export declare function googleGkeBackupRestorePlanRestoreConfigTransformationRulesResourceFilterToHclTerraform(struct?: GoogleGkeBackupRestorePlanRestoreConfigTransformationRulesResourceFilterOutputReference | GoogleGkeBackupRestorePlanRestoreConfigTransformationRulesResourceFilter): any;
export declare class GoogleGkeBackupRestorePlanRestoreConfigTransformationRulesResourceFilterOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleGkeBackupRestorePlanRestoreConfigTransformationRulesResourceFilter | undefined;
    set internalValue(value: GoogleGkeBackupRestorePlanRestoreConfigTransformationRulesResourceFilter | undefined);
    private _jsonPath?;
    get jsonPath(): string;
    set jsonPath(value: string);
    resetJsonPath(): void;
    get jsonPathInput(): string | undefined;
    private _namespaces?;
    get namespaces(): string[];
    set namespaces(value: string[]);
    resetNamespaces(): void;
    get namespacesInput(): string[] | undefined;
    private _groupKinds;
    get groupKinds(): GoogleGkeBackupRestorePlanRestoreConfigTransformationRulesResourceFilterGroupKindsList;
    putGroupKinds(value: GoogleGkeBackupRestorePlanRestoreConfigTransformationRulesResourceFilterGroupKinds[] | cdktf.IResolvable): void;
    resetGroupKinds(): void;
    get groupKindsInput(): cdktf.IResolvable | GoogleGkeBackupRestorePlanRestoreConfigTransformationRulesResourceFilterGroupKinds[] | undefined;
}
export interface GoogleGkeBackupRestorePlanRestoreConfigTransformationRules {
    /**
    * The description is a user specified string description
    * of the transformation rule.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gke_backup_restore_plan#description GoogleGkeBackupRestorePlan#description}
    */
    readonly description?: string;
    /**
    * field_actions block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gke_backup_restore_plan#field_actions GoogleGkeBackupRestorePlan#field_actions}
    */
    readonly fieldActions: GoogleGkeBackupRestorePlanRestoreConfigTransformationRulesFieldActions[] | cdktf.IResolvable;
    /**
    * resource_filter block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gke_backup_restore_plan#resource_filter GoogleGkeBackupRestorePlan#resource_filter}
    */
    readonly resourceFilter?: GoogleGkeBackupRestorePlanRestoreConfigTransformationRulesResourceFilter;
}
export declare function googleGkeBackupRestorePlanRestoreConfigTransformationRulesToTerraform(struct?: GoogleGkeBackupRestorePlanRestoreConfigTransformationRules | cdktf.IResolvable): any;
export declare function googleGkeBackupRestorePlanRestoreConfigTransformationRulesToHclTerraform(struct?: GoogleGkeBackupRestorePlanRestoreConfigTransformationRules | cdktf.IResolvable): any;
export declare class GoogleGkeBackupRestorePlanRestoreConfigTransformationRulesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleGkeBackupRestorePlanRestoreConfigTransformationRules | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleGkeBackupRestorePlanRestoreConfigTransformationRules | cdktf.IResolvable | undefined);
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _fieldActions;
    get fieldActions(): GoogleGkeBackupRestorePlanRestoreConfigTransformationRulesFieldActionsList;
    putFieldActions(value: GoogleGkeBackupRestorePlanRestoreConfigTransformationRulesFieldActions[] | cdktf.IResolvable): void;
    get fieldActionsInput(): cdktf.IResolvable | GoogleGkeBackupRestorePlanRestoreConfigTransformationRulesFieldActions[] | undefined;
    private _resourceFilter;
    get resourceFilter(): GoogleGkeBackupRestorePlanRestoreConfigTransformationRulesResourceFilterOutputReference;
    putResourceFilter(value: GoogleGkeBackupRestorePlanRestoreConfigTransformationRulesResourceFilter): void;
    resetResourceFilter(): void;
    get resourceFilterInput(): GoogleGkeBackupRestorePlanRestoreConfigTransformationRulesResourceFilter | undefined;
}
export declare class GoogleGkeBackupRestorePlanRestoreConfigTransformationRulesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleGkeBackupRestorePlanRestoreConfigTransformationRules[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleGkeBackupRestorePlanRestoreConfigTransformationRulesOutputReference;
}
export interface GoogleGkeBackupRestorePlanRestoreConfig {
    /**
    * If True, restore all namespaced resources in the Backup.
    * Setting this field to False will result in an error.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gke_backup_restore_plan#all_namespaces GoogleGkeBackupRestorePlan#all_namespaces}
    */
    readonly allNamespaces?: boolean | cdktf.IResolvable;
    /**
    * Defines the behavior for handling the situation where cluster-scoped resources
    * being restored already exist in the target cluster.
    * This MUST be set to a value other than 'CLUSTER_RESOURCE_CONFLICT_POLICY_UNSPECIFIED'
    * if 'clusterResourceRestoreScope' is anyting other than 'noGroupKinds'.
    * See https://cloud.google.com/kubernetes-engine/docs/add-on/backup-for-gke/reference/rest/v1/RestoreConfig#clusterresourceconflictpolicy
    * for more information on each policy option. Possible values: ["USE_EXISTING_VERSION", "USE_BACKUP_VERSION"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gke_backup_restore_plan#cluster_resource_conflict_policy GoogleGkeBackupRestorePlan#cluster_resource_conflict_policy}
    */
    readonly clusterResourceConflictPolicy?: string;
    /**
    * Defines the behavior for handling the situation where sets of namespaced resources
    * being restored already exist in the target cluster.
    * This MUST be set to a value other than 'NAMESPACED_RESOURCE_RESTORE_MODE_UNSPECIFIED'
    * if the 'namespacedResourceRestoreScope' is anything other than 'noNamespaces'.
    * See https://cloud.google.com/kubernetes-engine/docs/add-on/backup-for-gke/reference/rest/v1/RestoreConfig#namespacedresourcerestoremode
    * for more information on each mode. Possible values: ["DELETE_AND_RESTORE", "FAIL_ON_CONFLICT"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gke_backup_restore_plan#namespaced_resource_restore_mode GoogleGkeBackupRestorePlan#namespaced_resource_restore_mode}
    */
    readonly namespacedResourceRestoreMode?: string;
    /**
    * Do not restore any namespaced resources if set to "True".
    * Specifying this field to "False" is not allowed.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gke_backup_restore_plan#no_namespaces GoogleGkeBackupRestorePlan#no_namespaces}
    */
    readonly noNamespaces?: boolean | cdktf.IResolvable;
    /**
    * Specifies the mechanism to be used to restore volume data.
    * This should be set to a value other than 'NAMESPACED_RESOURCE_RESTORE_MODE_UNSPECIFIED'
    * if the 'namespacedResourceRestoreScope' is anything other than 'noNamespaces'.
    * If not specified, it will be treated as 'NO_VOLUME_DATA_RESTORATION'.
    * See https://cloud.google.com/kubernetes-engine/docs/add-on/backup-for-gke/reference/rest/v1/RestoreConfig#VolumeDataRestorePolicy
    * for more information on each policy option. Possible values: ["RESTORE_VOLUME_DATA_FROM_BACKUP", "REUSE_VOLUME_HANDLE_FROM_BACKUP", "NO_VOLUME_DATA_RESTORATION"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gke_backup_restore_plan#volume_data_restore_policy GoogleGkeBackupRestorePlan#volume_data_restore_policy}
    */
    readonly volumeDataRestorePolicy?: string;
    /**
    * cluster_resource_restore_scope block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gke_backup_restore_plan#cluster_resource_restore_scope GoogleGkeBackupRestorePlan#cluster_resource_restore_scope}
    */
    readonly clusterResourceRestoreScope?: GoogleGkeBackupRestorePlanRestoreConfigClusterResourceRestoreScope;
    /**
    * excluded_namespaces block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gke_backup_restore_plan#excluded_namespaces GoogleGkeBackupRestorePlan#excluded_namespaces}
    */
    readonly excludedNamespaces?: GoogleGkeBackupRestorePlanRestoreConfigExcludedNamespaces;
    /**
    * selected_applications block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gke_backup_restore_plan#selected_applications GoogleGkeBackupRestorePlan#selected_applications}
    */
    readonly selectedApplications?: GoogleGkeBackupRestorePlanRestoreConfigSelectedApplications;
    /**
    * selected_namespaces block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gke_backup_restore_plan#selected_namespaces GoogleGkeBackupRestorePlan#selected_namespaces}
    */
    readonly selectedNamespaces?: GoogleGkeBackupRestorePlanRestoreConfigSelectedNamespaces;
    /**
    * transformation_rules block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gke_backup_restore_plan#transformation_rules GoogleGkeBackupRestorePlan#transformation_rules}
    */
    readonly transformationRules?: GoogleGkeBackupRestorePlanRestoreConfigTransformationRules[] | cdktf.IResolvable;
}
export declare function googleGkeBackupRestorePlanRestoreConfigToTerraform(struct?: GoogleGkeBackupRestorePlanRestoreConfigOutputReference | GoogleGkeBackupRestorePlanRestoreConfig): any;
export declare function googleGkeBackupRestorePlanRestoreConfigToHclTerraform(struct?: GoogleGkeBackupRestorePlanRestoreConfigOutputReference | GoogleGkeBackupRestorePlanRestoreConfig): any;
export declare class GoogleGkeBackupRestorePlanRestoreConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleGkeBackupRestorePlanRestoreConfig | undefined;
    set internalValue(value: GoogleGkeBackupRestorePlanRestoreConfig | undefined);
    private _allNamespaces?;
    get allNamespaces(): boolean | cdktf.IResolvable;
    set allNamespaces(value: boolean | cdktf.IResolvable);
    resetAllNamespaces(): void;
    get allNamespacesInput(): boolean | cdktf.IResolvable | undefined;
    private _clusterResourceConflictPolicy?;
    get clusterResourceConflictPolicy(): string;
    set clusterResourceConflictPolicy(value: string);
    resetClusterResourceConflictPolicy(): void;
    get clusterResourceConflictPolicyInput(): string | undefined;
    private _namespacedResourceRestoreMode?;
    get namespacedResourceRestoreMode(): string;
    set namespacedResourceRestoreMode(value: string);
    resetNamespacedResourceRestoreMode(): void;
    get namespacedResourceRestoreModeInput(): string | undefined;
    private _noNamespaces?;
    get noNamespaces(): boolean | cdktf.IResolvable;
    set noNamespaces(value: boolean | cdktf.IResolvable);
    resetNoNamespaces(): void;
    get noNamespacesInput(): boolean | cdktf.IResolvable | undefined;
    private _volumeDataRestorePolicy?;
    get volumeDataRestorePolicy(): string;
    set volumeDataRestorePolicy(value: string);
    resetVolumeDataRestorePolicy(): void;
    get volumeDataRestorePolicyInput(): string | undefined;
    private _clusterResourceRestoreScope;
    get clusterResourceRestoreScope(): GoogleGkeBackupRestorePlanRestoreConfigClusterResourceRestoreScopeOutputReference;
    putClusterResourceRestoreScope(value: GoogleGkeBackupRestorePlanRestoreConfigClusterResourceRestoreScope): void;
    resetClusterResourceRestoreScope(): void;
    get clusterResourceRestoreScopeInput(): GoogleGkeBackupRestorePlanRestoreConfigClusterResourceRestoreScope | undefined;
    private _excludedNamespaces;
    get excludedNamespaces(): GoogleGkeBackupRestorePlanRestoreConfigExcludedNamespacesOutputReference;
    putExcludedNamespaces(value: GoogleGkeBackupRestorePlanRestoreConfigExcludedNamespaces): void;
    resetExcludedNamespaces(): void;
    get excludedNamespacesInput(): GoogleGkeBackupRestorePlanRestoreConfigExcludedNamespaces | undefined;
    private _selectedApplications;
    get selectedApplications(): GoogleGkeBackupRestorePlanRestoreConfigSelectedApplicationsOutputReference;
    putSelectedApplications(value: GoogleGkeBackupRestorePlanRestoreConfigSelectedApplications): void;
    resetSelectedApplications(): void;
    get selectedApplicationsInput(): GoogleGkeBackupRestorePlanRestoreConfigSelectedApplications | undefined;
    private _selectedNamespaces;
    get selectedNamespaces(): GoogleGkeBackupRestorePlanRestoreConfigSelectedNamespacesOutputReference;
    putSelectedNamespaces(value: GoogleGkeBackupRestorePlanRestoreConfigSelectedNamespaces): void;
    resetSelectedNamespaces(): void;
    get selectedNamespacesInput(): GoogleGkeBackupRestorePlanRestoreConfigSelectedNamespaces | undefined;
    private _transformationRules;
    get transformationRules(): GoogleGkeBackupRestorePlanRestoreConfigTransformationRulesList;
    putTransformationRules(value: GoogleGkeBackupRestorePlanRestoreConfigTransformationRules[] | cdktf.IResolvable): void;
    resetTransformationRules(): void;
    get transformationRulesInput(): cdktf.IResolvable | GoogleGkeBackupRestorePlanRestoreConfigTransformationRules[] | undefined;
}
export interface GoogleGkeBackupRestorePlanTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gke_backup_restore_plan#create GoogleGkeBackupRestorePlan#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gke_backup_restore_plan#delete GoogleGkeBackupRestorePlan#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gke_backup_restore_plan#update GoogleGkeBackupRestorePlan#update}
    */
    readonly update?: string;
}
export declare function googleGkeBackupRestorePlanTimeoutsToTerraform(struct?: GoogleGkeBackupRestorePlanTimeouts | cdktf.IResolvable): any;
export declare function googleGkeBackupRestorePlanTimeoutsToHclTerraform(struct?: GoogleGkeBackupRestorePlanTimeouts | cdktf.IResolvable): any;
export declare class GoogleGkeBackupRestorePlanTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleGkeBackupRestorePlanTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleGkeBackupRestorePlanTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gke_backup_restore_plan google_gke_backup_restore_plan}
*/
export declare class GoogleGkeBackupRestorePlan extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_gke_backup_restore_plan";
    /**
    * Generates CDKTF code for importing a GoogleGkeBackupRestorePlan resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the GoogleGkeBackupRestorePlan to import
    * @param importFromId The id of the existing GoogleGkeBackupRestorePlan that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gke_backup_restore_plan#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the GoogleGkeBackupRestorePlan to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gke_backup_restore_plan google_gke_backup_restore_plan} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleGkeBackupRestorePlanConfig
    */
    constructor(scope: Construct, id: string, config: GoogleGkeBackupRestorePlanConfig);
    private _backupPlan?;
    get backupPlan(): string;
    set backupPlan(value: string);
    get backupPlanInput(): string | undefined;
    private _cluster?;
    get cluster(): string;
    set cluster(value: string);
    get clusterInput(): string | undefined;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _effectiveLabels;
    get effectiveLabels(): cdktf.StringMap;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _labels?;
    get labels(): {
        [key: string]: string;
    };
    set labels(value: {
        [key: string]: string;
    });
    resetLabels(): void;
    get labelsInput(): {
        [key: string]: string;
    } | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    get state(): string;
    get stateReason(): string;
    private _terraformLabels;
    get terraformLabels(): cdktf.StringMap;
    get uid(): string;
    private _restoreConfig;
    get restoreConfig(): GoogleGkeBackupRestorePlanRestoreConfigOutputReference;
    putRestoreConfig(value: GoogleGkeBackupRestorePlanRestoreConfig): void;
    get restoreConfigInput(): GoogleGkeBackupRestorePlanRestoreConfig | undefined;
    private _timeouts;
    get timeouts(): GoogleGkeBackupRestorePlanTimeoutsOutputReference;
    putTimeouts(value: GoogleGkeBackupRestorePlanTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleGkeBackupRestorePlanTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
