/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleGkeHubFeatureMembershipConfig extends cdktf.TerraformMetaArguments {
    /**
    * The name of the feature
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gke_hub_feature_membership#feature GoogleGkeHubFeatureMembership#feature}
    */
    readonly feature: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gke_hub_feature_membership#id GoogleGkeHubFeatureMembership#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The location of the feature
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gke_hub_feature_membership#location GoogleGkeHubFeatureMembership#location}
    */
    readonly location: string;
    /**
    * The name of the membership
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gke_hub_feature_membership#membership GoogleGkeHubFeatureMembership#membership}
    */
    readonly membership: string;
    /**
    * The location of the membership
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gke_hub_feature_membership#membership_location GoogleGkeHubFeatureMembership#membership_location}
    */
    readonly membershipLocation?: string;
    /**
    * The project of the feature
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gke_hub_feature_membership#project GoogleGkeHubFeatureMembership#project}
    */
    readonly project?: string;
    /**
    * configmanagement block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gke_hub_feature_membership#configmanagement GoogleGkeHubFeatureMembership#configmanagement}
    */
    readonly configmanagement?: GoogleGkeHubFeatureMembershipConfigmanagement;
    /**
    * mesh block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gke_hub_feature_membership#mesh GoogleGkeHubFeatureMembership#mesh}
    */
    readonly mesh?: GoogleGkeHubFeatureMembershipMesh;
    /**
    * policycontroller block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gke_hub_feature_membership#policycontroller GoogleGkeHubFeatureMembership#policycontroller}
    */
    readonly policycontroller?: GoogleGkeHubFeatureMembershipPolicycontroller;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gke_hub_feature_membership#timeouts GoogleGkeHubFeatureMembership#timeouts}
    */
    readonly timeouts?: GoogleGkeHubFeatureMembershipTimeouts;
}
export interface GoogleGkeHubFeatureMembershipConfigmanagementBinauthz {
    /**
    * Whether binauthz is enabled in this cluster.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gke_hub_feature_membership#enabled GoogleGkeHubFeatureMembership#enabled}
    */
    readonly enabled?: boolean | cdktf.IResolvable;
}
export declare function googleGkeHubFeatureMembershipConfigmanagementBinauthzToTerraform(struct?: GoogleGkeHubFeatureMembershipConfigmanagementBinauthzOutputReference | GoogleGkeHubFeatureMembershipConfigmanagementBinauthz): any;
export declare function googleGkeHubFeatureMembershipConfigmanagementBinauthzToHclTerraform(struct?: GoogleGkeHubFeatureMembershipConfigmanagementBinauthzOutputReference | GoogleGkeHubFeatureMembershipConfigmanagementBinauthz): any;
export declare class GoogleGkeHubFeatureMembershipConfigmanagementBinauthzOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleGkeHubFeatureMembershipConfigmanagementBinauthz | undefined;
    set internalValue(value: GoogleGkeHubFeatureMembershipConfigmanagementBinauthz | undefined);
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    resetEnabled(): void;
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
}
export interface GoogleGkeHubFeatureMembershipConfigmanagementConfigSyncGit {
    /**
    * The GCP Service Account Email used for auth when secretType is gcpServiceAccount.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gke_hub_feature_membership#gcp_service_account_email GoogleGkeHubFeatureMembership#gcp_service_account_email}
    */
    readonly gcpServiceAccountEmail?: string;
    /**
    * URL for the HTTPS proxy to be used when communicating with the Git repo.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gke_hub_feature_membership#https_proxy GoogleGkeHubFeatureMembership#https_proxy}
    */
    readonly httpsProxy?: string;
    /**
    * The path within the Git repository that represents the top level of the repo to sync. Default: the root directory of the repository.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gke_hub_feature_membership#policy_dir GoogleGkeHubFeatureMembership#policy_dir}
    */
    readonly policyDir?: string;
    /**
    * Type of secret configured for access to the Git repo. Must be one of ssh, cookiefile, gcenode, token, gcpserviceaccount or none. The validation of this is case-sensitive.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gke_hub_feature_membership#secret_type GoogleGkeHubFeatureMembership#secret_type}
    */
    readonly secretType?: string;
    /**
    * The branch of the repository to sync from. Default: master.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gke_hub_feature_membership#sync_branch GoogleGkeHubFeatureMembership#sync_branch}
    */
    readonly syncBranch?: string;
    /**
    * The URL of the Git repository to use as the source of truth.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gke_hub_feature_membership#sync_repo GoogleGkeHubFeatureMembership#sync_repo}
    */
    readonly syncRepo?: string;
    /**
    * Git revision (tag or hash) to check out. Default HEAD.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gke_hub_feature_membership#sync_rev GoogleGkeHubFeatureMembership#sync_rev}
    */
    readonly syncRev?: string;
    /**
    * Period in seconds between consecutive syncs. Default: 15.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gke_hub_feature_membership#sync_wait_secs GoogleGkeHubFeatureMembership#sync_wait_secs}
    */
    readonly syncWaitSecs?: string;
}
export declare function googleGkeHubFeatureMembershipConfigmanagementConfigSyncGitToTerraform(struct?: GoogleGkeHubFeatureMembershipConfigmanagementConfigSyncGitOutputReference | GoogleGkeHubFeatureMembershipConfigmanagementConfigSyncGit): any;
export declare function googleGkeHubFeatureMembershipConfigmanagementConfigSyncGitToHclTerraform(struct?: GoogleGkeHubFeatureMembershipConfigmanagementConfigSyncGitOutputReference | GoogleGkeHubFeatureMembershipConfigmanagementConfigSyncGit): any;
export declare class GoogleGkeHubFeatureMembershipConfigmanagementConfigSyncGitOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleGkeHubFeatureMembershipConfigmanagementConfigSyncGit | undefined;
    set internalValue(value: GoogleGkeHubFeatureMembershipConfigmanagementConfigSyncGit | undefined);
    private _gcpServiceAccountEmail?;
    get gcpServiceAccountEmail(): string;
    set gcpServiceAccountEmail(value: string);
    resetGcpServiceAccountEmail(): void;
    get gcpServiceAccountEmailInput(): string | undefined;
    private _httpsProxy?;
    get httpsProxy(): string;
    set httpsProxy(value: string);
    resetHttpsProxy(): void;
    get httpsProxyInput(): string | undefined;
    private _policyDir?;
    get policyDir(): string;
    set policyDir(value: string);
    resetPolicyDir(): void;
    get policyDirInput(): string | undefined;
    private _secretType?;
    get secretType(): string;
    set secretType(value: string);
    resetSecretType(): void;
    get secretTypeInput(): string | undefined;
    private _syncBranch?;
    get syncBranch(): string;
    set syncBranch(value: string);
    resetSyncBranch(): void;
    get syncBranchInput(): string | undefined;
    private _syncRepo?;
    get syncRepo(): string;
    set syncRepo(value: string);
    resetSyncRepo(): void;
    get syncRepoInput(): string | undefined;
    private _syncRev?;
    get syncRev(): string;
    set syncRev(value: string);
    resetSyncRev(): void;
    get syncRevInput(): string | undefined;
    private _syncWaitSecs?;
    get syncWaitSecs(): string;
    set syncWaitSecs(value: string);
    resetSyncWaitSecs(): void;
    get syncWaitSecsInput(): string | undefined;
}
export interface GoogleGkeHubFeatureMembershipConfigmanagementConfigSyncOci {
    /**
    * The GCP Service Account Email used for auth when secret_type is gcpserviceaccount.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gke_hub_feature_membership#gcp_service_account_email GoogleGkeHubFeatureMembership#gcp_service_account_email}
    */
    readonly gcpServiceAccountEmail?: string;
    /**
    * The absolute path of the directory that contains the local resources. Default: the root directory of the image.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gke_hub_feature_membership#policy_dir GoogleGkeHubFeatureMembership#policy_dir}
    */
    readonly policyDir?: string;
    /**
    * Type of secret configured for access to the OCI Image. Must be one of gcenode, gcpserviceaccount or none. The validation of this is case-sensitive.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gke_hub_feature_membership#secret_type GoogleGkeHubFeatureMembership#secret_type}
    */
    readonly secretType?: string;
    /**
    * The OCI image repository URL for the package to sync from. e.g. LOCATION-docker.pkg.dev/PROJECT_ID/REPOSITORY_NAME/PACKAGE_NAME.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gke_hub_feature_membership#sync_repo GoogleGkeHubFeatureMembership#sync_repo}
    */
    readonly syncRepo?: string;
    /**
    * Period in seconds(int64 format) between consecutive syncs. Default: 15.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gke_hub_feature_membership#sync_wait_secs GoogleGkeHubFeatureMembership#sync_wait_secs}
    */
    readonly syncWaitSecs?: string;
}
export declare function googleGkeHubFeatureMembershipConfigmanagementConfigSyncOciToTerraform(struct?: GoogleGkeHubFeatureMembershipConfigmanagementConfigSyncOciOutputReference | GoogleGkeHubFeatureMembershipConfigmanagementConfigSyncOci): any;
export declare function googleGkeHubFeatureMembershipConfigmanagementConfigSyncOciToHclTerraform(struct?: GoogleGkeHubFeatureMembershipConfigmanagementConfigSyncOciOutputReference | GoogleGkeHubFeatureMembershipConfigmanagementConfigSyncOci): any;
export declare class GoogleGkeHubFeatureMembershipConfigmanagementConfigSyncOciOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleGkeHubFeatureMembershipConfigmanagementConfigSyncOci | undefined;
    set internalValue(value: GoogleGkeHubFeatureMembershipConfigmanagementConfigSyncOci | undefined);
    private _gcpServiceAccountEmail?;
    get gcpServiceAccountEmail(): string;
    set gcpServiceAccountEmail(value: string);
    resetGcpServiceAccountEmail(): void;
    get gcpServiceAccountEmailInput(): string | undefined;
    private _policyDir?;
    get policyDir(): string;
    set policyDir(value: string);
    resetPolicyDir(): void;
    get policyDirInput(): string | undefined;
    private _secretType?;
    get secretType(): string;
    set secretType(value: string);
    resetSecretType(): void;
    get secretTypeInput(): string | undefined;
    private _syncRepo?;
    get syncRepo(): string;
    set syncRepo(value: string);
    resetSyncRepo(): void;
    get syncRepoInput(): string | undefined;
    private _syncWaitSecs?;
    get syncWaitSecs(): string;
    set syncWaitSecs(value: string);
    resetSyncWaitSecs(): void;
    get syncWaitSecsInput(): string | undefined;
}
export interface GoogleGkeHubFeatureMembershipConfigmanagementConfigSync {
    /**
    * The Email of the Google Cloud Service Account (GSA) used for exporting Config Sync metrics to Cloud Monitoring. The GSA should have the Monitoring Metric Writer(roles/monitoring.metricWriter) IAM role. The Kubernetes ServiceAccount `default` in the namespace `config-management-monitoring` should be bound to the GSA.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gke_hub_feature_membership#metrics_gcp_service_account_email GoogleGkeHubFeatureMembership#metrics_gcp_service_account_email}
    */
    readonly metricsGcpServiceAccountEmail?: string;
    /**
    * Set to true to enable the Config Sync admission webhook to prevent drifts. If set to `false`, disables the Config Sync admission webhook and does not prevent drifts.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gke_hub_feature_membership#prevent_drift GoogleGkeHubFeatureMembership#prevent_drift}
    */
    readonly preventDrift?: boolean | cdktf.IResolvable;
    /**
    * Specifies whether the Config Sync Repo is in "hierarchical" or "unstructured" mode.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gke_hub_feature_membership#source_format GoogleGkeHubFeatureMembership#source_format}
    */
    readonly sourceFormat?: string;
    /**
    * git block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gke_hub_feature_membership#git GoogleGkeHubFeatureMembership#git}
    */
    readonly git?: GoogleGkeHubFeatureMembershipConfigmanagementConfigSyncGit;
    /**
    * oci block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gke_hub_feature_membership#oci GoogleGkeHubFeatureMembership#oci}
    */
    readonly oci?: GoogleGkeHubFeatureMembershipConfigmanagementConfigSyncOci;
}
export declare function googleGkeHubFeatureMembershipConfigmanagementConfigSyncToTerraform(struct?: GoogleGkeHubFeatureMembershipConfigmanagementConfigSyncOutputReference | GoogleGkeHubFeatureMembershipConfigmanagementConfigSync): any;
export declare function googleGkeHubFeatureMembershipConfigmanagementConfigSyncToHclTerraform(struct?: GoogleGkeHubFeatureMembershipConfigmanagementConfigSyncOutputReference | GoogleGkeHubFeatureMembershipConfigmanagementConfigSync): any;
export declare class GoogleGkeHubFeatureMembershipConfigmanagementConfigSyncOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleGkeHubFeatureMembershipConfigmanagementConfigSync | undefined;
    set internalValue(value: GoogleGkeHubFeatureMembershipConfigmanagementConfigSync | undefined);
    private _metricsGcpServiceAccountEmail?;
    get metricsGcpServiceAccountEmail(): string;
    set metricsGcpServiceAccountEmail(value: string);
    resetMetricsGcpServiceAccountEmail(): void;
    get metricsGcpServiceAccountEmailInput(): string | undefined;
    private _preventDrift?;
    get preventDrift(): boolean | cdktf.IResolvable;
    set preventDrift(value: boolean | cdktf.IResolvable);
    resetPreventDrift(): void;
    get preventDriftInput(): boolean | cdktf.IResolvable | undefined;
    private _sourceFormat?;
    get sourceFormat(): string;
    set sourceFormat(value: string);
    resetSourceFormat(): void;
    get sourceFormatInput(): string | undefined;
    private _git;
    get git(): GoogleGkeHubFeatureMembershipConfigmanagementConfigSyncGitOutputReference;
    putGit(value: GoogleGkeHubFeatureMembershipConfigmanagementConfigSyncGit): void;
    resetGit(): void;
    get gitInput(): GoogleGkeHubFeatureMembershipConfigmanagementConfigSyncGit | undefined;
    private _oci;
    get oci(): GoogleGkeHubFeatureMembershipConfigmanagementConfigSyncOciOutputReference;
    putOci(value: GoogleGkeHubFeatureMembershipConfigmanagementConfigSyncOci): void;
    resetOci(): void;
    get ociInput(): GoogleGkeHubFeatureMembershipConfigmanagementConfigSyncOci | undefined;
}
export interface GoogleGkeHubFeatureMembershipConfigmanagementHierarchyController {
    /**
    * Whether hierarchical resource quota is enabled in this cluster.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gke_hub_feature_membership#enable_hierarchical_resource_quota GoogleGkeHubFeatureMembership#enable_hierarchical_resource_quota}
    */
    readonly enableHierarchicalResourceQuota?: boolean | cdktf.IResolvable;
    /**
    * Whether pod tree labels are enabled in this cluster.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gke_hub_feature_membership#enable_pod_tree_labels GoogleGkeHubFeatureMembership#enable_pod_tree_labels}
    */
    readonly enablePodTreeLabels?: boolean | cdktf.IResolvable;
    /**
    * Whether Hierarchy Controller is enabled in this cluster.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gke_hub_feature_membership#enabled GoogleGkeHubFeatureMembership#enabled}
    */
    readonly enabled?: boolean | cdktf.IResolvable;
}
export declare function googleGkeHubFeatureMembershipConfigmanagementHierarchyControllerToTerraform(struct?: GoogleGkeHubFeatureMembershipConfigmanagementHierarchyControllerOutputReference | GoogleGkeHubFeatureMembershipConfigmanagementHierarchyController): any;
export declare function googleGkeHubFeatureMembershipConfigmanagementHierarchyControllerToHclTerraform(struct?: GoogleGkeHubFeatureMembershipConfigmanagementHierarchyControllerOutputReference | GoogleGkeHubFeatureMembershipConfigmanagementHierarchyController): any;
export declare class GoogleGkeHubFeatureMembershipConfigmanagementHierarchyControllerOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleGkeHubFeatureMembershipConfigmanagementHierarchyController | undefined;
    set internalValue(value: GoogleGkeHubFeatureMembershipConfigmanagementHierarchyController | undefined);
    private _enableHierarchicalResourceQuota?;
    get enableHierarchicalResourceQuota(): boolean | cdktf.IResolvable;
    set enableHierarchicalResourceQuota(value: boolean | cdktf.IResolvable);
    resetEnableHierarchicalResourceQuota(): void;
    get enableHierarchicalResourceQuotaInput(): boolean | cdktf.IResolvable | undefined;
    private _enablePodTreeLabels?;
    get enablePodTreeLabels(): boolean | cdktf.IResolvable;
    set enablePodTreeLabels(value: boolean | cdktf.IResolvable);
    resetEnablePodTreeLabels(): void;
    get enablePodTreeLabelsInput(): boolean | cdktf.IResolvable | undefined;
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    resetEnabled(): void;
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
}
export interface GoogleGkeHubFeatureMembershipConfigmanagementPolicyControllerMonitoring {
    /**
    *  Specifies the list of backends Policy Controller will export to. Specifying an empty value `[]` disables metrics export.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gke_hub_feature_membership#backends GoogleGkeHubFeatureMembership#backends}
    */
    readonly backends?: string[];
}
export declare function googleGkeHubFeatureMembershipConfigmanagementPolicyControllerMonitoringToTerraform(struct?: GoogleGkeHubFeatureMembershipConfigmanagementPolicyControllerMonitoringOutputReference | GoogleGkeHubFeatureMembershipConfigmanagementPolicyControllerMonitoring): any;
export declare function googleGkeHubFeatureMembershipConfigmanagementPolicyControllerMonitoringToHclTerraform(struct?: GoogleGkeHubFeatureMembershipConfigmanagementPolicyControllerMonitoringOutputReference | GoogleGkeHubFeatureMembershipConfigmanagementPolicyControllerMonitoring): any;
export declare class GoogleGkeHubFeatureMembershipConfigmanagementPolicyControllerMonitoringOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleGkeHubFeatureMembershipConfigmanagementPolicyControllerMonitoring | undefined;
    set internalValue(value: GoogleGkeHubFeatureMembershipConfigmanagementPolicyControllerMonitoring | undefined);
    private _backends?;
    get backends(): string[];
    set backends(value: string[]);
    resetBackends(): void;
    get backendsInput(): string[] | undefined;
}
export interface GoogleGkeHubFeatureMembershipConfigmanagementPolicyController {
    /**
    * Sets the interval for Policy Controller Audit Scans (in seconds). When set to 0, this disables audit functionality altogether.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gke_hub_feature_membership#audit_interval_seconds GoogleGkeHubFeatureMembership#audit_interval_seconds}
    */
    readonly auditIntervalSeconds?: string;
    /**
    * Enables the installation of Policy Controller. If false, the rest of PolicyController fields take no effect.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gke_hub_feature_membership#enabled GoogleGkeHubFeatureMembership#enabled}
    */
    readonly enabled?: boolean | cdktf.IResolvable;
    /**
    * The set of namespaces that are excluded from Policy Controller checks. Namespaces do not need to currently exist on the cluster.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gke_hub_feature_membership#exemptable_namespaces GoogleGkeHubFeatureMembership#exemptable_namespaces}
    */
    readonly exemptableNamespaces?: string[];
    /**
    * Logs all denies and dry run failures.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gke_hub_feature_membership#log_denies_enabled GoogleGkeHubFeatureMembership#log_denies_enabled}
    */
    readonly logDeniesEnabled?: boolean | cdktf.IResolvable;
    /**
    * Enable or disable mutation in policy controller. If true, mutation CRDs, webhook and controller deployment will be deployed to the cluster.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gke_hub_feature_membership#mutation_enabled GoogleGkeHubFeatureMembership#mutation_enabled}
    */
    readonly mutationEnabled?: boolean | cdktf.IResolvable;
    /**
    * Enables the ability to use Constraint Templates that reference to objects other than the object currently being evaluated.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gke_hub_feature_membership#referential_rules_enabled GoogleGkeHubFeatureMembership#referential_rules_enabled}
    */
    readonly referentialRulesEnabled?: boolean | cdktf.IResolvable;
    /**
    * Installs the default template library along with Policy Controller.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gke_hub_feature_membership#template_library_installed GoogleGkeHubFeatureMembership#template_library_installed}
    */
    readonly templateLibraryInstalled?: boolean | cdktf.IResolvable;
    /**
    * monitoring block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gke_hub_feature_membership#monitoring GoogleGkeHubFeatureMembership#monitoring}
    */
    readonly monitoring?: GoogleGkeHubFeatureMembershipConfigmanagementPolicyControllerMonitoring;
}
export declare function googleGkeHubFeatureMembershipConfigmanagementPolicyControllerToTerraform(struct?: GoogleGkeHubFeatureMembershipConfigmanagementPolicyControllerOutputReference | GoogleGkeHubFeatureMembershipConfigmanagementPolicyController): any;
export declare function googleGkeHubFeatureMembershipConfigmanagementPolicyControllerToHclTerraform(struct?: GoogleGkeHubFeatureMembershipConfigmanagementPolicyControllerOutputReference | GoogleGkeHubFeatureMembershipConfigmanagementPolicyController): any;
export declare class GoogleGkeHubFeatureMembershipConfigmanagementPolicyControllerOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleGkeHubFeatureMembershipConfigmanagementPolicyController | undefined;
    set internalValue(value: GoogleGkeHubFeatureMembershipConfigmanagementPolicyController | undefined);
    private _auditIntervalSeconds?;
    get auditIntervalSeconds(): string;
    set auditIntervalSeconds(value: string);
    resetAuditIntervalSeconds(): void;
    get auditIntervalSecondsInput(): string | undefined;
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    resetEnabled(): void;
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
    private _exemptableNamespaces?;
    get exemptableNamespaces(): string[];
    set exemptableNamespaces(value: string[]);
    resetExemptableNamespaces(): void;
    get exemptableNamespacesInput(): string[] | undefined;
    private _logDeniesEnabled?;
    get logDeniesEnabled(): boolean | cdktf.IResolvable;
    set logDeniesEnabled(value: boolean | cdktf.IResolvable);
    resetLogDeniesEnabled(): void;
    get logDeniesEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _mutationEnabled?;
    get mutationEnabled(): boolean | cdktf.IResolvable;
    set mutationEnabled(value: boolean | cdktf.IResolvable);
    resetMutationEnabled(): void;
    get mutationEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _referentialRulesEnabled?;
    get referentialRulesEnabled(): boolean | cdktf.IResolvable;
    set referentialRulesEnabled(value: boolean | cdktf.IResolvable);
    resetReferentialRulesEnabled(): void;
    get referentialRulesEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _templateLibraryInstalled?;
    get templateLibraryInstalled(): boolean | cdktf.IResolvable;
    set templateLibraryInstalled(value: boolean | cdktf.IResolvable);
    resetTemplateLibraryInstalled(): void;
    get templateLibraryInstalledInput(): boolean | cdktf.IResolvable | undefined;
    private _monitoring;
    get monitoring(): GoogleGkeHubFeatureMembershipConfigmanagementPolicyControllerMonitoringOutputReference;
    putMonitoring(value: GoogleGkeHubFeatureMembershipConfigmanagementPolicyControllerMonitoring): void;
    resetMonitoring(): void;
    get monitoringInput(): GoogleGkeHubFeatureMembershipConfigmanagementPolicyControllerMonitoring | undefined;
}
export interface GoogleGkeHubFeatureMembershipConfigmanagement {
    /**
    * Optional. Version of ACM to install. Defaults to the latest version.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gke_hub_feature_membership#version GoogleGkeHubFeatureMembership#version}
    */
    readonly version?: string;
    /**
    * binauthz block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gke_hub_feature_membership#binauthz GoogleGkeHubFeatureMembership#binauthz}
    */
    readonly binauthz?: GoogleGkeHubFeatureMembershipConfigmanagementBinauthz;
    /**
    * config_sync block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gke_hub_feature_membership#config_sync GoogleGkeHubFeatureMembership#config_sync}
    */
    readonly configSync?: GoogleGkeHubFeatureMembershipConfigmanagementConfigSync;
    /**
    * hierarchy_controller block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gke_hub_feature_membership#hierarchy_controller GoogleGkeHubFeatureMembership#hierarchy_controller}
    */
    readonly hierarchyController?: GoogleGkeHubFeatureMembershipConfigmanagementHierarchyController;
    /**
    * policy_controller block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gke_hub_feature_membership#policy_controller GoogleGkeHubFeatureMembership#policy_controller}
    */
    readonly policyController?: GoogleGkeHubFeatureMembershipConfigmanagementPolicyController;
}
export declare function googleGkeHubFeatureMembershipConfigmanagementToTerraform(struct?: GoogleGkeHubFeatureMembershipConfigmanagementOutputReference | GoogleGkeHubFeatureMembershipConfigmanagement): any;
export declare function googleGkeHubFeatureMembershipConfigmanagementToHclTerraform(struct?: GoogleGkeHubFeatureMembershipConfigmanagementOutputReference | GoogleGkeHubFeatureMembershipConfigmanagement): any;
export declare class GoogleGkeHubFeatureMembershipConfigmanagementOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleGkeHubFeatureMembershipConfigmanagement | undefined;
    set internalValue(value: GoogleGkeHubFeatureMembershipConfigmanagement | undefined);
    private _version?;
    get version(): string;
    set version(value: string);
    resetVersion(): void;
    get versionInput(): string | undefined;
    private _binauthz;
    get binauthz(): GoogleGkeHubFeatureMembershipConfigmanagementBinauthzOutputReference;
    putBinauthz(value: GoogleGkeHubFeatureMembershipConfigmanagementBinauthz): void;
    resetBinauthz(): void;
    get binauthzInput(): GoogleGkeHubFeatureMembershipConfigmanagementBinauthz | undefined;
    private _configSync;
    get configSync(): GoogleGkeHubFeatureMembershipConfigmanagementConfigSyncOutputReference;
    putConfigSync(value: GoogleGkeHubFeatureMembershipConfigmanagementConfigSync): void;
    resetConfigSync(): void;
    get configSyncInput(): GoogleGkeHubFeatureMembershipConfigmanagementConfigSync | undefined;
    private _hierarchyController;
    get hierarchyController(): GoogleGkeHubFeatureMembershipConfigmanagementHierarchyControllerOutputReference;
    putHierarchyController(value: GoogleGkeHubFeatureMembershipConfigmanagementHierarchyController): void;
    resetHierarchyController(): void;
    get hierarchyControllerInput(): GoogleGkeHubFeatureMembershipConfigmanagementHierarchyController | undefined;
    private _policyController;
    get policyController(): GoogleGkeHubFeatureMembershipConfigmanagementPolicyControllerOutputReference;
    putPolicyController(value: GoogleGkeHubFeatureMembershipConfigmanagementPolicyController): void;
    resetPolicyController(): void;
    get policyControllerInput(): GoogleGkeHubFeatureMembershipConfigmanagementPolicyController | undefined;
}
export interface GoogleGkeHubFeatureMembershipMesh {
    /**
    * **DEPRECATED** Whether to automatically manage Service Mesh control planes. Possible values: CONTROL_PLANE_MANAGEMENT_UNSPECIFIED, AUTOMATIC, MANUAL
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gke_hub_feature_membership#control_plane GoogleGkeHubFeatureMembership#control_plane}
    */
    readonly controlPlane?: string;
    /**
    * Whether to automatically manage Service Mesh. Possible values: MANAGEMENT_UNSPECIFIED, MANAGEMENT_AUTOMATIC, MANAGEMENT_MANUAL
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gke_hub_feature_membership#management GoogleGkeHubFeatureMembership#management}
    */
    readonly management?: string;
}
export declare function googleGkeHubFeatureMembershipMeshToTerraform(struct?: GoogleGkeHubFeatureMembershipMeshOutputReference | GoogleGkeHubFeatureMembershipMesh): any;
export declare function googleGkeHubFeatureMembershipMeshToHclTerraform(struct?: GoogleGkeHubFeatureMembershipMeshOutputReference | GoogleGkeHubFeatureMembershipMesh): any;
export declare class GoogleGkeHubFeatureMembershipMeshOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleGkeHubFeatureMembershipMesh | undefined;
    set internalValue(value: GoogleGkeHubFeatureMembershipMesh | undefined);
    private _controlPlane?;
    get controlPlane(): string;
    set controlPlane(value: string);
    resetControlPlane(): void;
    get controlPlaneInput(): string | undefined;
    private _management?;
    get management(): string;
    set management(value: string);
    resetManagement(): void;
    get managementInput(): string | undefined;
}
export interface GoogleGkeHubFeatureMembershipPolicycontrollerPolicyControllerHubConfigDeploymentConfigsContainerResourcesLimits {
    /**
    * CPU requirement expressed in Kubernetes resource units.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gke_hub_feature_membership#cpu GoogleGkeHubFeatureMembership#cpu}
    */
    readonly cpu?: string;
    /**
    * Memory requirement expressed in Kubernetes resource units.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gke_hub_feature_membership#memory GoogleGkeHubFeatureMembership#memory}
    */
    readonly memory?: string;
}
export declare function googleGkeHubFeatureMembershipPolicycontrollerPolicyControllerHubConfigDeploymentConfigsContainerResourcesLimitsToTerraform(struct?: GoogleGkeHubFeatureMembershipPolicycontrollerPolicyControllerHubConfigDeploymentConfigsContainerResourcesLimitsOutputReference | GoogleGkeHubFeatureMembershipPolicycontrollerPolicyControllerHubConfigDeploymentConfigsContainerResourcesLimits): any;
export declare function googleGkeHubFeatureMembershipPolicycontrollerPolicyControllerHubConfigDeploymentConfigsContainerResourcesLimitsToHclTerraform(struct?: GoogleGkeHubFeatureMembershipPolicycontrollerPolicyControllerHubConfigDeploymentConfigsContainerResourcesLimitsOutputReference | GoogleGkeHubFeatureMembershipPolicycontrollerPolicyControllerHubConfigDeploymentConfigsContainerResourcesLimits): any;
export declare class GoogleGkeHubFeatureMembershipPolicycontrollerPolicyControllerHubConfigDeploymentConfigsContainerResourcesLimitsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleGkeHubFeatureMembershipPolicycontrollerPolicyControllerHubConfigDeploymentConfigsContainerResourcesLimits | undefined;
    set internalValue(value: GoogleGkeHubFeatureMembershipPolicycontrollerPolicyControllerHubConfigDeploymentConfigsContainerResourcesLimits | undefined);
    private _cpu?;
    get cpu(): string;
    set cpu(value: string);
    resetCpu(): void;
    get cpuInput(): string | undefined;
    private _memory?;
    get memory(): string;
    set memory(value: string);
    resetMemory(): void;
    get memoryInput(): string | undefined;
}
export interface GoogleGkeHubFeatureMembershipPolicycontrollerPolicyControllerHubConfigDeploymentConfigsContainerResourcesRequests {
    /**
    * CPU requirement expressed in Kubernetes resource units.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gke_hub_feature_membership#cpu GoogleGkeHubFeatureMembership#cpu}
    */
    readonly cpu?: string;
    /**
    * Memory requirement expressed in Kubernetes resource units.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gke_hub_feature_membership#memory GoogleGkeHubFeatureMembership#memory}
    */
    readonly memory?: string;
}
export declare function googleGkeHubFeatureMembershipPolicycontrollerPolicyControllerHubConfigDeploymentConfigsContainerResourcesRequestsToTerraform(struct?: GoogleGkeHubFeatureMembershipPolicycontrollerPolicyControllerHubConfigDeploymentConfigsContainerResourcesRequestsOutputReference | GoogleGkeHubFeatureMembershipPolicycontrollerPolicyControllerHubConfigDeploymentConfigsContainerResourcesRequests): any;
export declare function googleGkeHubFeatureMembershipPolicycontrollerPolicyControllerHubConfigDeploymentConfigsContainerResourcesRequestsToHclTerraform(struct?: GoogleGkeHubFeatureMembershipPolicycontrollerPolicyControllerHubConfigDeploymentConfigsContainerResourcesRequestsOutputReference | GoogleGkeHubFeatureMembershipPolicycontrollerPolicyControllerHubConfigDeploymentConfigsContainerResourcesRequests): any;
export declare class GoogleGkeHubFeatureMembershipPolicycontrollerPolicyControllerHubConfigDeploymentConfigsContainerResourcesRequestsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleGkeHubFeatureMembershipPolicycontrollerPolicyControllerHubConfigDeploymentConfigsContainerResourcesRequests | undefined;
    set internalValue(value: GoogleGkeHubFeatureMembershipPolicycontrollerPolicyControllerHubConfigDeploymentConfigsContainerResourcesRequests | undefined);
    private _cpu?;
    get cpu(): string;
    set cpu(value: string);
    resetCpu(): void;
    get cpuInput(): string | undefined;
    private _memory?;
    get memory(): string;
    set memory(value: string);
    resetMemory(): void;
    get memoryInput(): string | undefined;
}
export interface GoogleGkeHubFeatureMembershipPolicycontrollerPolicyControllerHubConfigDeploymentConfigsContainerResources {
    /**
    * limits block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gke_hub_feature_membership#limits GoogleGkeHubFeatureMembership#limits}
    */
    readonly limits?: GoogleGkeHubFeatureMembershipPolicycontrollerPolicyControllerHubConfigDeploymentConfigsContainerResourcesLimits;
    /**
    * requests block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gke_hub_feature_membership#requests GoogleGkeHubFeatureMembership#requests}
    */
    readonly requests?: GoogleGkeHubFeatureMembershipPolicycontrollerPolicyControllerHubConfigDeploymentConfigsContainerResourcesRequests;
}
export declare function googleGkeHubFeatureMembershipPolicycontrollerPolicyControllerHubConfigDeploymentConfigsContainerResourcesToTerraform(struct?: GoogleGkeHubFeatureMembershipPolicycontrollerPolicyControllerHubConfigDeploymentConfigsContainerResourcesOutputReference | GoogleGkeHubFeatureMembershipPolicycontrollerPolicyControllerHubConfigDeploymentConfigsContainerResources): any;
export declare function googleGkeHubFeatureMembershipPolicycontrollerPolicyControllerHubConfigDeploymentConfigsContainerResourcesToHclTerraform(struct?: GoogleGkeHubFeatureMembershipPolicycontrollerPolicyControllerHubConfigDeploymentConfigsContainerResourcesOutputReference | GoogleGkeHubFeatureMembershipPolicycontrollerPolicyControllerHubConfigDeploymentConfigsContainerResources): any;
export declare class GoogleGkeHubFeatureMembershipPolicycontrollerPolicyControllerHubConfigDeploymentConfigsContainerResourcesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleGkeHubFeatureMembershipPolicycontrollerPolicyControllerHubConfigDeploymentConfigsContainerResources | undefined;
    set internalValue(value: GoogleGkeHubFeatureMembershipPolicycontrollerPolicyControllerHubConfigDeploymentConfigsContainerResources | undefined);
    private _limits;
    get limits(): GoogleGkeHubFeatureMembershipPolicycontrollerPolicyControllerHubConfigDeploymentConfigsContainerResourcesLimitsOutputReference;
    putLimits(value: GoogleGkeHubFeatureMembershipPolicycontrollerPolicyControllerHubConfigDeploymentConfigsContainerResourcesLimits): void;
    resetLimits(): void;
    get limitsInput(): GoogleGkeHubFeatureMembershipPolicycontrollerPolicyControllerHubConfigDeploymentConfigsContainerResourcesLimits | undefined;
    private _requests;
    get requests(): GoogleGkeHubFeatureMembershipPolicycontrollerPolicyControllerHubConfigDeploymentConfigsContainerResourcesRequestsOutputReference;
    putRequests(value: GoogleGkeHubFeatureMembershipPolicycontrollerPolicyControllerHubConfigDeploymentConfigsContainerResourcesRequests): void;
    resetRequests(): void;
    get requestsInput(): GoogleGkeHubFeatureMembershipPolicycontrollerPolicyControllerHubConfigDeploymentConfigsContainerResourcesRequests | undefined;
}
export interface GoogleGkeHubFeatureMembershipPolicycontrollerPolicyControllerHubConfigDeploymentConfigsPodTolerations {
    /**
    * Matches a taint effect.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gke_hub_feature_membership#effect GoogleGkeHubFeatureMembership#effect}
    */
    readonly effect?: string;
    /**
    * Matches a taint key (not necessarily unique).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gke_hub_feature_membership#key GoogleGkeHubFeatureMembership#key}
    */
    readonly key?: string;
    /**
    * Matches a taint operator.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gke_hub_feature_membership#operator GoogleGkeHubFeatureMembership#operator}
    */
    readonly operator?: string;
    /**
    * Matches a taint value.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gke_hub_feature_membership#value GoogleGkeHubFeatureMembership#value}
    */
    readonly value?: string;
}
export declare function googleGkeHubFeatureMembershipPolicycontrollerPolicyControllerHubConfigDeploymentConfigsPodTolerationsToTerraform(struct?: GoogleGkeHubFeatureMembershipPolicycontrollerPolicyControllerHubConfigDeploymentConfigsPodTolerations | cdktf.IResolvable): any;
export declare function googleGkeHubFeatureMembershipPolicycontrollerPolicyControllerHubConfigDeploymentConfigsPodTolerationsToHclTerraform(struct?: GoogleGkeHubFeatureMembershipPolicycontrollerPolicyControllerHubConfigDeploymentConfigsPodTolerations | cdktf.IResolvable): any;
export declare class GoogleGkeHubFeatureMembershipPolicycontrollerPolicyControllerHubConfigDeploymentConfigsPodTolerationsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleGkeHubFeatureMembershipPolicycontrollerPolicyControllerHubConfigDeploymentConfigsPodTolerations | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleGkeHubFeatureMembershipPolicycontrollerPolicyControllerHubConfigDeploymentConfigsPodTolerations | cdktf.IResolvable | undefined);
    private _effect?;
    get effect(): string;
    set effect(value: string);
    resetEffect(): void;
    get effectInput(): string | undefined;
    private _key?;
    get key(): string;
    set key(value: string);
    resetKey(): void;
    get keyInput(): string | undefined;
    private _operator?;
    get operator(): string;
    set operator(value: string);
    resetOperator(): void;
    get operatorInput(): string | undefined;
    private _value?;
    get value(): string;
    set value(value: string);
    resetValue(): void;
    get valueInput(): string | undefined;
}
export declare class GoogleGkeHubFeatureMembershipPolicycontrollerPolicyControllerHubConfigDeploymentConfigsPodTolerationsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleGkeHubFeatureMembershipPolicycontrollerPolicyControllerHubConfigDeploymentConfigsPodTolerations[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleGkeHubFeatureMembershipPolicycontrollerPolicyControllerHubConfigDeploymentConfigsPodTolerationsOutputReference;
}
export interface GoogleGkeHubFeatureMembershipPolicycontrollerPolicyControllerHubConfigDeploymentConfigs {
    /**
    * The name for the key in the map for which this object is mapped to in the API
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gke_hub_feature_membership#component_name GoogleGkeHubFeatureMembership#component_name}
    */
    readonly componentName: string;
    /**
    * Pod affinity configuration. Possible values: AFFINITY_UNSPECIFIED, NO_AFFINITY, ANTI_AFFINITY
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gke_hub_feature_membership#pod_affinity GoogleGkeHubFeatureMembership#pod_affinity}
    */
    readonly podAffinity?: string;
    /**
    * Pod replica count.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gke_hub_feature_membership#replica_count GoogleGkeHubFeatureMembership#replica_count}
    */
    readonly replicaCount?: number;
    /**
    * container_resources block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gke_hub_feature_membership#container_resources GoogleGkeHubFeatureMembership#container_resources}
    */
    readonly containerResources?: GoogleGkeHubFeatureMembershipPolicycontrollerPolicyControllerHubConfigDeploymentConfigsContainerResources;
    /**
    * pod_tolerations block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gke_hub_feature_membership#pod_tolerations GoogleGkeHubFeatureMembership#pod_tolerations}
    */
    readonly podTolerations?: GoogleGkeHubFeatureMembershipPolicycontrollerPolicyControllerHubConfigDeploymentConfigsPodTolerations[] | cdktf.IResolvable;
}
export declare function googleGkeHubFeatureMembershipPolicycontrollerPolicyControllerHubConfigDeploymentConfigsToTerraform(struct?: GoogleGkeHubFeatureMembershipPolicycontrollerPolicyControllerHubConfigDeploymentConfigs | cdktf.IResolvable): any;
export declare function googleGkeHubFeatureMembershipPolicycontrollerPolicyControllerHubConfigDeploymentConfigsToHclTerraform(struct?: GoogleGkeHubFeatureMembershipPolicycontrollerPolicyControllerHubConfigDeploymentConfigs | cdktf.IResolvable): any;
export declare class GoogleGkeHubFeatureMembershipPolicycontrollerPolicyControllerHubConfigDeploymentConfigsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleGkeHubFeatureMembershipPolicycontrollerPolicyControllerHubConfigDeploymentConfigs | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleGkeHubFeatureMembershipPolicycontrollerPolicyControllerHubConfigDeploymentConfigs | cdktf.IResolvable | undefined);
    private _componentName?;
    get componentName(): string;
    set componentName(value: string);
    get componentNameInput(): string | undefined;
    private _podAffinity?;
    get podAffinity(): string;
    set podAffinity(value: string);
    resetPodAffinity(): void;
    get podAffinityInput(): string | undefined;
    private _replicaCount?;
    get replicaCount(): number;
    set replicaCount(value: number);
    resetReplicaCount(): void;
    get replicaCountInput(): number | undefined;
    private _containerResources;
    get containerResources(): GoogleGkeHubFeatureMembershipPolicycontrollerPolicyControllerHubConfigDeploymentConfigsContainerResourcesOutputReference;
    putContainerResources(value: GoogleGkeHubFeatureMembershipPolicycontrollerPolicyControllerHubConfigDeploymentConfigsContainerResources): void;
    resetContainerResources(): void;
    get containerResourcesInput(): GoogleGkeHubFeatureMembershipPolicycontrollerPolicyControllerHubConfigDeploymentConfigsContainerResources | undefined;
    private _podTolerations;
    get podTolerations(): GoogleGkeHubFeatureMembershipPolicycontrollerPolicyControllerHubConfigDeploymentConfigsPodTolerationsList;
    putPodTolerations(value: GoogleGkeHubFeatureMembershipPolicycontrollerPolicyControllerHubConfigDeploymentConfigsPodTolerations[] | cdktf.IResolvable): void;
    resetPodTolerations(): void;
    get podTolerationsInput(): cdktf.IResolvable | GoogleGkeHubFeatureMembershipPolicycontrollerPolicyControllerHubConfigDeploymentConfigsPodTolerations[] | undefined;
}
export declare class GoogleGkeHubFeatureMembershipPolicycontrollerPolicyControllerHubConfigDeploymentConfigsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleGkeHubFeatureMembershipPolicycontrollerPolicyControllerHubConfigDeploymentConfigs[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleGkeHubFeatureMembershipPolicycontrollerPolicyControllerHubConfigDeploymentConfigsOutputReference;
}
export interface GoogleGkeHubFeatureMembershipPolicycontrollerPolicyControllerHubConfigMonitoring {
    /**
    *  Specifies the list of backends Policy Controller will export to. Specifying an empty value `[]` disables metrics export.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gke_hub_feature_membership#backends GoogleGkeHubFeatureMembership#backends}
    */
    readonly backends?: string[];
}
export declare function googleGkeHubFeatureMembershipPolicycontrollerPolicyControllerHubConfigMonitoringToTerraform(struct?: GoogleGkeHubFeatureMembershipPolicycontrollerPolicyControllerHubConfigMonitoringOutputReference | GoogleGkeHubFeatureMembershipPolicycontrollerPolicyControllerHubConfigMonitoring): any;
export declare function googleGkeHubFeatureMembershipPolicycontrollerPolicyControllerHubConfigMonitoringToHclTerraform(struct?: GoogleGkeHubFeatureMembershipPolicycontrollerPolicyControllerHubConfigMonitoringOutputReference | GoogleGkeHubFeatureMembershipPolicycontrollerPolicyControllerHubConfigMonitoring): any;
export declare class GoogleGkeHubFeatureMembershipPolicycontrollerPolicyControllerHubConfigMonitoringOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleGkeHubFeatureMembershipPolicycontrollerPolicyControllerHubConfigMonitoring | undefined;
    set internalValue(value: GoogleGkeHubFeatureMembershipPolicycontrollerPolicyControllerHubConfigMonitoring | undefined);
    private _backends?;
    get backends(): string[];
    set backends(value: string[]);
    resetBackends(): void;
    get backendsInput(): string[] | undefined;
}
export interface GoogleGkeHubFeatureMembershipPolicycontrollerPolicyControllerHubConfigPolicyContentBundles {
    /**
    * The name for the key in the map for which this object is mapped to in the API
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gke_hub_feature_membership#bundle_name GoogleGkeHubFeatureMembership#bundle_name}
    */
    readonly bundleName: string;
    /**
    * The set of namespaces to be exempted from the bundle.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gke_hub_feature_membership#exempted_namespaces GoogleGkeHubFeatureMembership#exempted_namespaces}
    */
    readonly exemptedNamespaces?: string[];
}
export declare function googleGkeHubFeatureMembershipPolicycontrollerPolicyControllerHubConfigPolicyContentBundlesToTerraform(struct?: GoogleGkeHubFeatureMembershipPolicycontrollerPolicyControllerHubConfigPolicyContentBundles | cdktf.IResolvable): any;
export declare function googleGkeHubFeatureMembershipPolicycontrollerPolicyControllerHubConfigPolicyContentBundlesToHclTerraform(struct?: GoogleGkeHubFeatureMembershipPolicycontrollerPolicyControllerHubConfigPolicyContentBundles | cdktf.IResolvable): any;
export declare class GoogleGkeHubFeatureMembershipPolicycontrollerPolicyControllerHubConfigPolicyContentBundlesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleGkeHubFeatureMembershipPolicycontrollerPolicyControllerHubConfigPolicyContentBundles | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleGkeHubFeatureMembershipPolicycontrollerPolicyControllerHubConfigPolicyContentBundles | cdktf.IResolvable | undefined);
    private _bundleName?;
    get bundleName(): string;
    set bundleName(value: string);
    get bundleNameInput(): string | undefined;
    private _exemptedNamespaces?;
    get exemptedNamespaces(): string[];
    set exemptedNamespaces(value: string[]);
    resetExemptedNamespaces(): void;
    get exemptedNamespacesInput(): string[] | undefined;
}
export declare class GoogleGkeHubFeatureMembershipPolicycontrollerPolicyControllerHubConfigPolicyContentBundlesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleGkeHubFeatureMembershipPolicycontrollerPolicyControllerHubConfigPolicyContentBundles[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleGkeHubFeatureMembershipPolicycontrollerPolicyControllerHubConfigPolicyContentBundlesOutputReference;
}
export interface GoogleGkeHubFeatureMembershipPolicycontrollerPolicyControllerHubConfigPolicyContentTemplateLibrary {
    /**
    * Configures the manner in which the template library is installed on the cluster. Possible values: INSTALLATION_UNSPECIFIED, NOT_INSTALLED, ALL
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gke_hub_feature_membership#installation GoogleGkeHubFeatureMembership#installation}
    */
    readonly installation?: string;
}
export declare function googleGkeHubFeatureMembershipPolicycontrollerPolicyControllerHubConfigPolicyContentTemplateLibraryToTerraform(struct?: GoogleGkeHubFeatureMembershipPolicycontrollerPolicyControllerHubConfigPolicyContentTemplateLibraryOutputReference | GoogleGkeHubFeatureMembershipPolicycontrollerPolicyControllerHubConfigPolicyContentTemplateLibrary): any;
export declare function googleGkeHubFeatureMembershipPolicycontrollerPolicyControllerHubConfigPolicyContentTemplateLibraryToHclTerraform(struct?: GoogleGkeHubFeatureMembershipPolicycontrollerPolicyControllerHubConfigPolicyContentTemplateLibraryOutputReference | GoogleGkeHubFeatureMembershipPolicycontrollerPolicyControllerHubConfigPolicyContentTemplateLibrary): any;
export declare class GoogleGkeHubFeatureMembershipPolicycontrollerPolicyControllerHubConfigPolicyContentTemplateLibraryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleGkeHubFeatureMembershipPolicycontrollerPolicyControllerHubConfigPolicyContentTemplateLibrary | undefined;
    set internalValue(value: GoogleGkeHubFeatureMembershipPolicycontrollerPolicyControllerHubConfigPolicyContentTemplateLibrary | undefined);
    private _installation?;
    get installation(): string;
    set installation(value: string);
    resetInstallation(): void;
    get installationInput(): string | undefined;
}
export interface GoogleGkeHubFeatureMembershipPolicycontrollerPolicyControllerHubConfigPolicyContent {
    /**
    * bundles block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gke_hub_feature_membership#bundles GoogleGkeHubFeatureMembership#bundles}
    */
    readonly bundles?: GoogleGkeHubFeatureMembershipPolicycontrollerPolicyControllerHubConfigPolicyContentBundles[] | cdktf.IResolvable;
    /**
    * template_library block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gke_hub_feature_membership#template_library GoogleGkeHubFeatureMembership#template_library}
    */
    readonly templateLibrary?: GoogleGkeHubFeatureMembershipPolicycontrollerPolicyControllerHubConfigPolicyContentTemplateLibrary;
}
export declare function googleGkeHubFeatureMembershipPolicycontrollerPolicyControllerHubConfigPolicyContentToTerraform(struct?: GoogleGkeHubFeatureMembershipPolicycontrollerPolicyControllerHubConfigPolicyContentOutputReference | GoogleGkeHubFeatureMembershipPolicycontrollerPolicyControllerHubConfigPolicyContent): any;
export declare function googleGkeHubFeatureMembershipPolicycontrollerPolicyControllerHubConfigPolicyContentToHclTerraform(struct?: GoogleGkeHubFeatureMembershipPolicycontrollerPolicyControllerHubConfigPolicyContentOutputReference | GoogleGkeHubFeatureMembershipPolicycontrollerPolicyControllerHubConfigPolicyContent): any;
export declare class GoogleGkeHubFeatureMembershipPolicycontrollerPolicyControllerHubConfigPolicyContentOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleGkeHubFeatureMembershipPolicycontrollerPolicyControllerHubConfigPolicyContent | undefined;
    set internalValue(value: GoogleGkeHubFeatureMembershipPolicycontrollerPolicyControllerHubConfigPolicyContent | undefined);
    private _bundles;
    get bundles(): GoogleGkeHubFeatureMembershipPolicycontrollerPolicyControllerHubConfigPolicyContentBundlesList;
    putBundles(value: GoogleGkeHubFeatureMembershipPolicycontrollerPolicyControllerHubConfigPolicyContentBundles[] | cdktf.IResolvable): void;
    resetBundles(): void;
    get bundlesInput(): cdktf.IResolvable | GoogleGkeHubFeatureMembershipPolicycontrollerPolicyControllerHubConfigPolicyContentBundles[] | undefined;
    private _templateLibrary;
    get templateLibrary(): GoogleGkeHubFeatureMembershipPolicycontrollerPolicyControllerHubConfigPolicyContentTemplateLibraryOutputReference;
    putTemplateLibrary(value: GoogleGkeHubFeatureMembershipPolicycontrollerPolicyControllerHubConfigPolicyContentTemplateLibrary): void;
    resetTemplateLibrary(): void;
    get templateLibraryInput(): GoogleGkeHubFeatureMembershipPolicycontrollerPolicyControllerHubConfigPolicyContentTemplateLibrary | undefined;
}
export interface GoogleGkeHubFeatureMembershipPolicycontrollerPolicyControllerHubConfig {
    /**
    * Sets the interval for Policy Controller Audit Scans (in seconds). When set to 0, this disables audit functionality altogether.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gke_hub_feature_membership#audit_interval_seconds GoogleGkeHubFeatureMembership#audit_interval_seconds}
    */
    readonly auditIntervalSeconds?: number;
    /**
    * The maximum number of audit violations to be stored in a constraint. If not set, the internal default of 20 will be used.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gke_hub_feature_membership#constraint_violation_limit GoogleGkeHubFeatureMembership#constraint_violation_limit}
    */
    readonly constraintViolationLimit?: number;
    /**
    * The set of namespaces that are excluded from Policy Controller checks. Namespaces do not need to currently exist on the cluster.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gke_hub_feature_membership#exemptable_namespaces GoogleGkeHubFeatureMembership#exemptable_namespaces}
    */
    readonly exemptableNamespaces?: string[];
    /**
    * Configures the mode of the Policy Controller installation. Possible values: INSTALL_SPEC_UNSPECIFIED, INSTALL_SPEC_NOT_INSTALLED, INSTALL_SPEC_ENABLED, INSTALL_SPEC_SUSPENDED, INSTALL_SPEC_DETACHED
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gke_hub_feature_membership#install_spec GoogleGkeHubFeatureMembership#install_spec}
    */
    readonly installSpec?: string;
    /**
    * Logs all denies and dry run failures.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gke_hub_feature_membership#log_denies_enabled GoogleGkeHubFeatureMembership#log_denies_enabled}
    */
    readonly logDeniesEnabled?: boolean | cdktf.IResolvable;
    /**
    * Enables the ability to mutate resources using Policy Controller.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gke_hub_feature_membership#mutation_enabled GoogleGkeHubFeatureMembership#mutation_enabled}
    */
    readonly mutationEnabled?: boolean | cdktf.IResolvable;
    /**
    * Enables the ability to use Constraint Templates that reference to objects other than the object currently being evaluated.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gke_hub_feature_membership#referential_rules_enabled GoogleGkeHubFeatureMembership#referential_rules_enabled}
    */
    readonly referentialRulesEnabled?: boolean | cdktf.IResolvable;
    /**
    * deployment_configs block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gke_hub_feature_membership#deployment_configs GoogleGkeHubFeatureMembership#deployment_configs}
    */
    readonly deploymentConfigs?: GoogleGkeHubFeatureMembershipPolicycontrollerPolicyControllerHubConfigDeploymentConfigs[] | cdktf.IResolvable;
    /**
    * monitoring block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gke_hub_feature_membership#monitoring GoogleGkeHubFeatureMembership#monitoring}
    */
    readonly monitoring?: GoogleGkeHubFeatureMembershipPolicycontrollerPolicyControllerHubConfigMonitoring;
    /**
    * policy_content block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gke_hub_feature_membership#policy_content GoogleGkeHubFeatureMembership#policy_content}
    */
    readonly policyContent?: GoogleGkeHubFeatureMembershipPolicycontrollerPolicyControllerHubConfigPolicyContent;
}
export declare function googleGkeHubFeatureMembershipPolicycontrollerPolicyControllerHubConfigToTerraform(struct?: GoogleGkeHubFeatureMembershipPolicycontrollerPolicyControllerHubConfigOutputReference | GoogleGkeHubFeatureMembershipPolicycontrollerPolicyControllerHubConfig): any;
export declare function googleGkeHubFeatureMembershipPolicycontrollerPolicyControllerHubConfigToHclTerraform(struct?: GoogleGkeHubFeatureMembershipPolicycontrollerPolicyControllerHubConfigOutputReference | GoogleGkeHubFeatureMembershipPolicycontrollerPolicyControllerHubConfig): any;
export declare class GoogleGkeHubFeatureMembershipPolicycontrollerPolicyControllerHubConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleGkeHubFeatureMembershipPolicycontrollerPolicyControllerHubConfig | undefined;
    set internalValue(value: GoogleGkeHubFeatureMembershipPolicycontrollerPolicyControllerHubConfig | undefined);
    private _auditIntervalSeconds?;
    get auditIntervalSeconds(): number;
    set auditIntervalSeconds(value: number);
    resetAuditIntervalSeconds(): void;
    get auditIntervalSecondsInput(): number | undefined;
    private _constraintViolationLimit?;
    get constraintViolationLimit(): number;
    set constraintViolationLimit(value: number);
    resetConstraintViolationLimit(): void;
    get constraintViolationLimitInput(): number | undefined;
    private _exemptableNamespaces?;
    get exemptableNamespaces(): string[];
    set exemptableNamespaces(value: string[]);
    resetExemptableNamespaces(): void;
    get exemptableNamespacesInput(): string[] | undefined;
    private _installSpec?;
    get installSpec(): string;
    set installSpec(value: string);
    resetInstallSpec(): void;
    get installSpecInput(): string | undefined;
    private _logDeniesEnabled?;
    get logDeniesEnabled(): boolean | cdktf.IResolvable;
    set logDeniesEnabled(value: boolean | cdktf.IResolvable);
    resetLogDeniesEnabled(): void;
    get logDeniesEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _mutationEnabled?;
    get mutationEnabled(): boolean | cdktf.IResolvable;
    set mutationEnabled(value: boolean | cdktf.IResolvable);
    resetMutationEnabled(): void;
    get mutationEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _referentialRulesEnabled?;
    get referentialRulesEnabled(): boolean | cdktf.IResolvable;
    set referentialRulesEnabled(value: boolean | cdktf.IResolvable);
    resetReferentialRulesEnabled(): void;
    get referentialRulesEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _deploymentConfigs;
    get deploymentConfigs(): GoogleGkeHubFeatureMembershipPolicycontrollerPolicyControllerHubConfigDeploymentConfigsList;
    putDeploymentConfigs(value: GoogleGkeHubFeatureMembershipPolicycontrollerPolicyControllerHubConfigDeploymentConfigs[] | cdktf.IResolvable): void;
    resetDeploymentConfigs(): void;
    get deploymentConfigsInput(): cdktf.IResolvable | GoogleGkeHubFeatureMembershipPolicycontrollerPolicyControllerHubConfigDeploymentConfigs[] | undefined;
    private _monitoring;
    get monitoring(): GoogleGkeHubFeatureMembershipPolicycontrollerPolicyControllerHubConfigMonitoringOutputReference;
    putMonitoring(value: GoogleGkeHubFeatureMembershipPolicycontrollerPolicyControllerHubConfigMonitoring): void;
    resetMonitoring(): void;
    get monitoringInput(): GoogleGkeHubFeatureMembershipPolicycontrollerPolicyControllerHubConfigMonitoring | undefined;
    private _policyContent;
    get policyContent(): GoogleGkeHubFeatureMembershipPolicycontrollerPolicyControllerHubConfigPolicyContentOutputReference;
    putPolicyContent(value: GoogleGkeHubFeatureMembershipPolicycontrollerPolicyControllerHubConfigPolicyContent): void;
    resetPolicyContent(): void;
    get policyContentInput(): GoogleGkeHubFeatureMembershipPolicycontrollerPolicyControllerHubConfigPolicyContent | undefined;
}
export interface GoogleGkeHubFeatureMembershipPolicycontroller {
    /**
    * Optional. Version of Policy Controller to install. Defaults to the latest version.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gke_hub_feature_membership#version GoogleGkeHubFeatureMembership#version}
    */
    readonly version?: string;
    /**
    * policy_controller_hub_config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gke_hub_feature_membership#policy_controller_hub_config GoogleGkeHubFeatureMembership#policy_controller_hub_config}
    */
    readonly policyControllerHubConfig: GoogleGkeHubFeatureMembershipPolicycontrollerPolicyControllerHubConfig;
}
export declare function googleGkeHubFeatureMembershipPolicycontrollerToTerraform(struct?: GoogleGkeHubFeatureMembershipPolicycontrollerOutputReference | GoogleGkeHubFeatureMembershipPolicycontroller): any;
export declare function googleGkeHubFeatureMembershipPolicycontrollerToHclTerraform(struct?: GoogleGkeHubFeatureMembershipPolicycontrollerOutputReference | GoogleGkeHubFeatureMembershipPolicycontroller): any;
export declare class GoogleGkeHubFeatureMembershipPolicycontrollerOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleGkeHubFeatureMembershipPolicycontroller | undefined;
    set internalValue(value: GoogleGkeHubFeatureMembershipPolicycontroller | undefined);
    private _version?;
    get version(): string;
    set version(value: string);
    resetVersion(): void;
    get versionInput(): string | undefined;
    private _policyControllerHubConfig;
    get policyControllerHubConfig(): GoogleGkeHubFeatureMembershipPolicycontrollerPolicyControllerHubConfigOutputReference;
    putPolicyControllerHubConfig(value: GoogleGkeHubFeatureMembershipPolicycontrollerPolicyControllerHubConfig): void;
    get policyControllerHubConfigInput(): GoogleGkeHubFeatureMembershipPolicycontrollerPolicyControllerHubConfig | undefined;
}
export interface GoogleGkeHubFeatureMembershipTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gke_hub_feature_membership#create GoogleGkeHubFeatureMembership#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gke_hub_feature_membership#delete GoogleGkeHubFeatureMembership#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gke_hub_feature_membership#update GoogleGkeHubFeatureMembership#update}
    */
    readonly update?: string;
}
export declare function googleGkeHubFeatureMembershipTimeoutsToTerraform(struct?: GoogleGkeHubFeatureMembershipTimeouts | cdktf.IResolvable): any;
export declare function googleGkeHubFeatureMembershipTimeoutsToHclTerraform(struct?: GoogleGkeHubFeatureMembershipTimeouts | cdktf.IResolvable): any;
export declare class GoogleGkeHubFeatureMembershipTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleGkeHubFeatureMembershipTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleGkeHubFeatureMembershipTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gke_hub_feature_membership google_gke_hub_feature_membership}
*/
export declare class GoogleGkeHubFeatureMembership extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_gke_hub_feature_membership";
    /**
    * Generates CDKTF code for importing a GoogleGkeHubFeatureMembership resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the GoogleGkeHubFeatureMembership to import
    * @param importFromId The id of the existing GoogleGkeHubFeatureMembership that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gke_hub_feature_membership#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the GoogleGkeHubFeatureMembership to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gke_hub_feature_membership google_gke_hub_feature_membership} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleGkeHubFeatureMembershipConfig
    */
    constructor(scope: Construct, id: string, config: GoogleGkeHubFeatureMembershipConfig);
    private _feature?;
    get feature(): string;
    set feature(value: string);
    get featureInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _membership?;
    get membership(): string;
    set membership(value: string);
    get membershipInput(): string | undefined;
    private _membershipLocation?;
    get membershipLocation(): string;
    set membershipLocation(value: string);
    resetMembershipLocation(): void;
    get membershipLocationInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _configmanagement;
    get configmanagement(): GoogleGkeHubFeatureMembershipConfigmanagementOutputReference;
    putConfigmanagement(value: GoogleGkeHubFeatureMembershipConfigmanagement): void;
    resetConfigmanagement(): void;
    get configmanagementInput(): GoogleGkeHubFeatureMembershipConfigmanagement | undefined;
    private _mesh;
    get mesh(): GoogleGkeHubFeatureMembershipMeshOutputReference;
    putMesh(value: GoogleGkeHubFeatureMembershipMesh): void;
    resetMesh(): void;
    get meshInput(): GoogleGkeHubFeatureMembershipMesh | undefined;
    private _policycontroller;
    get policycontroller(): GoogleGkeHubFeatureMembershipPolicycontrollerOutputReference;
    putPolicycontroller(value: GoogleGkeHubFeatureMembershipPolicycontroller): void;
    resetPolicycontroller(): void;
    get policycontrollerInput(): GoogleGkeHubFeatureMembershipPolicycontroller | undefined;
    private _timeouts;
    get timeouts(): GoogleGkeHubFeatureMembershipTimeoutsOutputReference;
    putTimeouts(value: GoogleGkeHubFeatureMembershipTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleGkeHubFeatureMembershipTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
