/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleGkeHubFeatureConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gke_hub_feature#id GoogleGkeHubFeature#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * GCP labels for this Feature.
    *
    * **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
    * Please refer to the field 'effective_labels' for all of the labels present on the resource.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gke_hub_feature#labels GoogleGkeHubFeature#labels}
    */
    readonly labels?: {
        [key: string]: string;
    };
    /**
    * The location for the resource
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gke_hub_feature#location GoogleGkeHubFeature#location}
    */
    readonly location: string;
    /**
    * The full, unique name of this Feature resource
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gke_hub_feature#name GoogleGkeHubFeature#name}
    */
    readonly name?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gke_hub_feature#project GoogleGkeHubFeature#project}
    */
    readonly project?: string;
    /**
    * fleet_default_member_config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gke_hub_feature#fleet_default_member_config GoogleGkeHubFeature#fleet_default_member_config}
    */
    readonly fleetDefaultMemberConfig?: GoogleGkeHubFeatureFleetDefaultMemberConfig;
    /**
    * spec block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gke_hub_feature#spec GoogleGkeHubFeature#spec}
    */
    readonly spec?: GoogleGkeHubFeatureSpec;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gke_hub_feature#timeouts GoogleGkeHubFeature#timeouts}
    */
    readonly timeouts?: GoogleGkeHubFeatureTimeouts;
}
export interface GoogleGkeHubFeatureResourceState {
}
export declare function googleGkeHubFeatureResourceStateToTerraform(struct?: GoogleGkeHubFeatureResourceState): any;
export declare function googleGkeHubFeatureResourceStateToHclTerraform(struct?: GoogleGkeHubFeatureResourceState): any;
export declare class GoogleGkeHubFeatureResourceStateOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleGkeHubFeatureResourceState | undefined;
    set internalValue(value: GoogleGkeHubFeatureResourceState | undefined);
    get hasResources(): cdktf.IResolvable;
    get state(): string;
}
export declare class GoogleGkeHubFeatureResourceStateList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleGkeHubFeatureResourceStateOutputReference;
}
export interface GoogleGkeHubFeatureStateState {
}
export declare function googleGkeHubFeatureStateStateToTerraform(struct?: GoogleGkeHubFeatureStateState): any;
export declare function googleGkeHubFeatureStateStateToHclTerraform(struct?: GoogleGkeHubFeatureStateState): any;
export declare class GoogleGkeHubFeatureStateStateOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleGkeHubFeatureStateState | undefined;
    set internalValue(value: GoogleGkeHubFeatureStateState | undefined);
    get code(): string;
    get description(): string;
    get updateTime(): string;
}
export declare class GoogleGkeHubFeatureStateStateList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleGkeHubFeatureStateStateOutputReference;
}
export interface GoogleGkeHubFeatureState {
}
export declare function googleGkeHubFeatureStateToTerraform(struct?: GoogleGkeHubFeatureState): any;
export declare function googleGkeHubFeatureStateToHclTerraform(struct?: GoogleGkeHubFeatureState): any;
export declare class GoogleGkeHubFeatureStateOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleGkeHubFeatureState | undefined;
    set internalValue(value: GoogleGkeHubFeatureState | undefined);
    private _state;
    get state(): GoogleGkeHubFeatureStateStateList;
}
export declare class GoogleGkeHubFeatureStateList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleGkeHubFeatureStateOutputReference;
}
export interface GoogleGkeHubFeatureFleetDefaultMemberConfigConfigmanagementConfigSyncGit {
    /**
    * The Google Cloud Service Account Email used for auth when secretType is gcpServiceAccount
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gke_hub_feature#gcp_service_account_email GoogleGkeHubFeature#gcp_service_account_email}
    */
    readonly gcpServiceAccountEmail?: string;
    /**
    * URL for the HTTPS Proxy to be used when communicating with the Git repo
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gke_hub_feature#https_proxy GoogleGkeHubFeature#https_proxy}
    */
    readonly httpsProxy?: string;
    /**
    * The path within the Git repository that represents the top level of the repo to sync
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gke_hub_feature#policy_dir GoogleGkeHubFeature#policy_dir}
    */
    readonly policyDir?: string;
    /**
    * Type of secret configured for access to the Git repo
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gke_hub_feature#secret_type GoogleGkeHubFeature#secret_type}
    */
    readonly secretType: string;
    /**
    * The branch of the repository to sync from. Default: master
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gke_hub_feature#sync_branch GoogleGkeHubFeature#sync_branch}
    */
    readonly syncBranch?: string;
    /**
    * The URL of the Git repository to use as the source of truth
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gke_hub_feature#sync_repo GoogleGkeHubFeature#sync_repo}
    */
    readonly syncRepo?: string;
    /**
    * Git revision (tag or hash) to check out. Default HEAD
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gke_hub_feature#sync_rev GoogleGkeHubFeature#sync_rev}
    */
    readonly syncRev?: string;
    /**
    * Period in seconds between consecutive syncs. Default: 15
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gke_hub_feature#sync_wait_secs GoogleGkeHubFeature#sync_wait_secs}
    */
    readonly syncWaitSecs?: string;
}
export declare function googleGkeHubFeatureFleetDefaultMemberConfigConfigmanagementConfigSyncGitToTerraform(struct?: GoogleGkeHubFeatureFleetDefaultMemberConfigConfigmanagementConfigSyncGitOutputReference | GoogleGkeHubFeatureFleetDefaultMemberConfigConfigmanagementConfigSyncGit): any;
export declare function googleGkeHubFeatureFleetDefaultMemberConfigConfigmanagementConfigSyncGitToHclTerraform(struct?: GoogleGkeHubFeatureFleetDefaultMemberConfigConfigmanagementConfigSyncGitOutputReference | GoogleGkeHubFeatureFleetDefaultMemberConfigConfigmanagementConfigSyncGit): any;
export declare class GoogleGkeHubFeatureFleetDefaultMemberConfigConfigmanagementConfigSyncGitOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleGkeHubFeatureFleetDefaultMemberConfigConfigmanagementConfigSyncGit | undefined;
    set internalValue(value: GoogleGkeHubFeatureFleetDefaultMemberConfigConfigmanagementConfigSyncGit | undefined);
    private _gcpServiceAccountEmail?;
    get gcpServiceAccountEmail(): string;
    set gcpServiceAccountEmail(value: string);
    resetGcpServiceAccountEmail(): void;
    get gcpServiceAccountEmailInput(): string | undefined;
    private _httpsProxy?;
    get httpsProxy(): string;
    set httpsProxy(value: string);
    resetHttpsProxy(): void;
    get httpsProxyInput(): string | undefined;
    private _policyDir?;
    get policyDir(): string;
    set policyDir(value: string);
    resetPolicyDir(): void;
    get policyDirInput(): string | undefined;
    private _secretType?;
    get secretType(): string;
    set secretType(value: string);
    get secretTypeInput(): string | undefined;
    private _syncBranch?;
    get syncBranch(): string;
    set syncBranch(value: string);
    resetSyncBranch(): void;
    get syncBranchInput(): string | undefined;
    private _syncRepo?;
    get syncRepo(): string;
    set syncRepo(value: string);
    resetSyncRepo(): void;
    get syncRepoInput(): string | undefined;
    private _syncRev?;
    get syncRev(): string;
    set syncRev(value: string);
    resetSyncRev(): void;
    get syncRevInput(): string | undefined;
    private _syncWaitSecs?;
    get syncWaitSecs(): string;
    set syncWaitSecs(value: string);
    resetSyncWaitSecs(): void;
    get syncWaitSecsInput(): string | undefined;
}
export interface GoogleGkeHubFeatureFleetDefaultMemberConfigConfigmanagementConfigSyncOci {
    /**
    * The Google Cloud Service Account Email used for auth when secretType is gcpServiceAccount
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gke_hub_feature#gcp_service_account_email GoogleGkeHubFeature#gcp_service_account_email}
    */
    readonly gcpServiceAccountEmail?: string;
    /**
    * The absolute path of the directory that contains the local resources. Default: the root directory of the image
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gke_hub_feature#policy_dir GoogleGkeHubFeature#policy_dir}
    */
    readonly policyDir?: string;
    /**
    * Type of secret configured for access to the Git repo
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gke_hub_feature#secret_type GoogleGkeHubFeature#secret_type}
    */
    readonly secretType: string;
    /**
    * The OCI image repository URL for the package to sync from
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gke_hub_feature#sync_repo GoogleGkeHubFeature#sync_repo}
    */
    readonly syncRepo?: string;
    /**
    * Period in seconds between consecutive syncs. Default: 15
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gke_hub_feature#sync_wait_secs GoogleGkeHubFeature#sync_wait_secs}
    */
    readonly syncWaitSecs?: string;
    /**
    * Version of ACM installed
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gke_hub_feature#version GoogleGkeHubFeature#version}
    */
    readonly version?: string;
}
export declare function googleGkeHubFeatureFleetDefaultMemberConfigConfigmanagementConfigSyncOciToTerraform(struct?: GoogleGkeHubFeatureFleetDefaultMemberConfigConfigmanagementConfigSyncOciOutputReference | GoogleGkeHubFeatureFleetDefaultMemberConfigConfigmanagementConfigSyncOci): any;
export declare function googleGkeHubFeatureFleetDefaultMemberConfigConfigmanagementConfigSyncOciToHclTerraform(struct?: GoogleGkeHubFeatureFleetDefaultMemberConfigConfigmanagementConfigSyncOciOutputReference | GoogleGkeHubFeatureFleetDefaultMemberConfigConfigmanagementConfigSyncOci): any;
export declare class GoogleGkeHubFeatureFleetDefaultMemberConfigConfigmanagementConfigSyncOciOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleGkeHubFeatureFleetDefaultMemberConfigConfigmanagementConfigSyncOci | undefined;
    set internalValue(value: GoogleGkeHubFeatureFleetDefaultMemberConfigConfigmanagementConfigSyncOci | undefined);
    private _gcpServiceAccountEmail?;
    get gcpServiceAccountEmail(): string;
    set gcpServiceAccountEmail(value: string);
    resetGcpServiceAccountEmail(): void;
    get gcpServiceAccountEmailInput(): string | undefined;
    private _policyDir?;
    get policyDir(): string;
    set policyDir(value: string);
    resetPolicyDir(): void;
    get policyDirInput(): string | undefined;
    private _secretType?;
    get secretType(): string;
    set secretType(value: string);
    get secretTypeInput(): string | undefined;
    private _syncRepo?;
    get syncRepo(): string;
    set syncRepo(value: string);
    resetSyncRepo(): void;
    get syncRepoInput(): string | undefined;
    private _syncWaitSecs?;
    get syncWaitSecs(): string;
    set syncWaitSecs(value: string);
    resetSyncWaitSecs(): void;
    get syncWaitSecsInput(): string | undefined;
    private _version?;
    get version(): string;
    set version(value: string);
    resetVersion(): void;
    get versionInput(): string | undefined;
}
export interface GoogleGkeHubFeatureFleetDefaultMemberConfigConfigmanagementConfigSync {
    /**
    * Specifies whether the Config Sync Repo is in hierarchical or unstructured mode
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gke_hub_feature#source_format GoogleGkeHubFeature#source_format}
    */
    readonly sourceFormat?: string;
    /**
    * git block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gke_hub_feature#git GoogleGkeHubFeature#git}
    */
    readonly git?: GoogleGkeHubFeatureFleetDefaultMemberConfigConfigmanagementConfigSyncGit;
    /**
    * oci block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gke_hub_feature#oci GoogleGkeHubFeature#oci}
    */
    readonly oci?: GoogleGkeHubFeatureFleetDefaultMemberConfigConfigmanagementConfigSyncOci;
}
export declare function googleGkeHubFeatureFleetDefaultMemberConfigConfigmanagementConfigSyncToTerraform(struct?: GoogleGkeHubFeatureFleetDefaultMemberConfigConfigmanagementConfigSyncOutputReference | GoogleGkeHubFeatureFleetDefaultMemberConfigConfigmanagementConfigSync): any;
export declare function googleGkeHubFeatureFleetDefaultMemberConfigConfigmanagementConfigSyncToHclTerraform(struct?: GoogleGkeHubFeatureFleetDefaultMemberConfigConfigmanagementConfigSyncOutputReference | GoogleGkeHubFeatureFleetDefaultMemberConfigConfigmanagementConfigSync): any;
export declare class GoogleGkeHubFeatureFleetDefaultMemberConfigConfigmanagementConfigSyncOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleGkeHubFeatureFleetDefaultMemberConfigConfigmanagementConfigSync | undefined;
    set internalValue(value: GoogleGkeHubFeatureFleetDefaultMemberConfigConfigmanagementConfigSync | undefined);
    private _sourceFormat?;
    get sourceFormat(): string;
    set sourceFormat(value: string);
    resetSourceFormat(): void;
    get sourceFormatInput(): string | undefined;
    private _git;
    get git(): GoogleGkeHubFeatureFleetDefaultMemberConfigConfigmanagementConfigSyncGitOutputReference;
    putGit(value: GoogleGkeHubFeatureFleetDefaultMemberConfigConfigmanagementConfigSyncGit): void;
    resetGit(): void;
    get gitInput(): GoogleGkeHubFeatureFleetDefaultMemberConfigConfigmanagementConfigSyncGit | undefined;
    private _oci;
    get oci(): GoogleGkeHubFeatureFleetDefaultMemberConfigConfigmanagementConfigSyncOciOutputReference;
    putOci(value: GoogleGkeHubFeatureFleetDefaultMemberConfigConfigmanagementConfigSyncOci): void;
    resetOci(): void;
    get ociInput(): GoogleGkeHubFeatureFleetDefaultMemberConfigConfigmanagementConfigSyncOci | undefined;
}
export interface GoogleGkeHubFeatureFleetDefaultMemberConfigConfigmanagement {
    /**
    * Version of ACM installed
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gke_hub_feature#version GoogleGkeHubFeature#version}
    */
    readonly version?: string;
    /**
    * config_sync block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gke_hub_feature#config_sync GoogleGkeHubFeature#config_sync}
    */
    readonly configSync?: GoogleGkeHubFeatureFleetDefaultMemberConfigConfigmanagementConfigSync;
}
export declare function googleGkeHubFeatureFleetDefaultMemberConfigConfigmanagementToTerraform(struct?: GoogleGkeHubFeatureFleetDefaultMemberConfigConfigmanagementOutputReference | GoogleGkeHubFeatureFleetDefaultMemberConfigConfigmanagement): any;
export declare function googleGkeHubFeatureFleetDefaultMemberConfigConfigmanagementToHclTerraform(struct?: GoogleGkeHubFeatureFleetDefaultMemberConfigConfigmanagementOutputReference | GoogleGkeHubFeatureFleetDefaultMemberConfigConfigmanagement): any;
export declare class GoogleGkeHubFeatureFleetDefaultMemberConfigConfigmanagementOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleGkeHubFeatureFleetDefaultMemberConfigConfigmanagement | undefined;
    set internalValue(value: GoogleGkeHubFeatureFleetDefaultMemberConfigConfigmanagement | undefined);
    private _version?;
    get version(): string;
    set version(value: string);
    resetVersion(): void;
    get versionInput(): string | undefined;
    private _configSync;
    get configSync(): GoogleGkeHubFeatureFleetDefaultMemberConfigConfigmanagementConfigSyncOutputReference;
    putConfigSync(value: GoogleGkeHubFeatureFleetDefaultMemberConfigConfigmanagementConfigSync): void;
    resetConfigSync(): void;
    get configSyncInput(): GoogleGkeHubFeatureFleetDefaultMemberConfigConfigmanagementConfigSync | undefined;
}
export interface GoogleGkeHubFeatureFleetDefaultMemberConfigMesh {
    /**
    * Whether to automatically manage Service Mesh Possible values: ["MANAGEMENT_UNSPECIFIED", "MANAGEMENT_AUTOMATIC", "MANAGEMENT_MANUAL"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gke_hub_feature#management GoogleGkeHubFeature#management}
    */
    readonly management: string;
}
export declare function googleGkeHubFeatureFleetDefaultMemberConfigMeshToTerraform(struct?: GoogleGkeHubFeatureFleetDefaultMemberConfigMeshOutputReference | GoogleGkeHubFeatureFleetDefaultMemberConfigMesh): any;
export declare function googleGkeHubFeatureFleetDefaultMemberConfigMeshToHclTerraform(struct?: GoogleGkeHubFeatureFleetDefaultMemberConfigMeshOutputReference | GoogleGkeHubFeatureFleetDefaultMemberConfigMesh): any;
export declare class GoogleGkeHubFeatureFleetDefaultMemberConfigMeshOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleGkeHubFeatureFleetDefaultMemberConfigMesh | undefined;
    set internalValue(value: GoogleGkeHubFeatureFleetDefaultMemberConfigMesh | undefined);
    private _management?;
    get management(): string;
    set management(value: string);
    get managementInput(): string | undefined;
}
export interface GoogleGkeHubFeatureFleetDefaultMemberConfigPolicycontrollerPolicyControllerHubConfigDeploymentConfigsContainerResourcesLimits {
    /**
    * CPU requirement expressed in Kubernetes resource units.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gke_hub_feature#cpu GoogleGkeHubFeature#cpu}
    */
    readonly cpu?: string;
    /**
    * Memory requirement expressed in Kubernetes resource units.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gke_hub_feature#memory GoogleGkeHubFeature#memory}
    */
    readonly memory?: string;
}
export declare function googleGkeHubFeatureFleetDefaultMemberConfigPolicycontrollerPolicyControllerHubConfigDeploymentConfigsContainerResourcesLimitsToTerraform(struct?: GoogleGkeHubFeatureFleetDefaultMemberConfigPolicycontrollerPolicyControllerHubConfigDeploymentConfigsContainerResourcesLimitsOutputReference | GoogleGkeHubFeatureFleetDefaultMemberConfigPolicycontrollerPolicyControllerHubConfigDeploymentConfigsContainerResourcesLimits): any;
export declare function googleGkeHubFeatureFleetDefaultMemberConfigPolicycontrollerPolicyControllerHubConfigDeploymentConfigsContainerResourcesLimitsToHclTerraform(struct?: GoogleGkeHubFeatureFleetDefaultMemberConfigPolicycontrollerPolicyControllerHubConfigDeploymentConfigsContainerResourcesLimitsOutputReference | GoogleGkeHubFeatureFleetDefaultMemberConfigPolicycontrollerPolicyControllerHubConfigDeploymentConfigsContainerResourcesLimits): any;
export declare class GoogleGkeHubFeatureFleetDefaultMemberConfigPolicycontrollerPolicyControllerHubConfigDeploymentConfigsContainerResourcesLimitsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleGkeHubFeatureFleetDefaultMemberConfigPolicycontrollerPolicyControllerHubConfigDeploymentConfigsContainerResourcesLimits | undefined;
    set internalValue(value: GoogleGkeHubFeatureFleetDefaultMemberConfigPolicycontrollerPolicyControllerHubConfigDeploymentConfigsContainerResourcesLimits | undefined);
    private _cpu?;
    get cpu(): string;
    set cpu(value: string);
    resetCpu(): void;
    get cpuInput(): string | undefined;
    private _memory?;
    get memory(): string;
    set memory(value: string);
    resetMemory(): void;
    get memoryInput(): string | undefined;
}
export interface GoogleGkeHubFeatureFleetDefaultMemberConfigPolicycontrollerPolicyControllerHubConfigDeploymentConfigsContainerResourcesRequests {
    /**
    * CPU requirement expressed in Kubernetes resource units.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gke_hub_feature#cpu GoogleGkeHubFeature#cpu}
    */
    readonly cpu?: string;
    /**
    * Memory requirement expressed in Kubernetes resource units.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gke_hub_feature#memory GoogleGkeHubFeature#memory}
    */
    readonly memory?: string;
}
export declare function googleGkeHubFeatureFleetDefaultMemberConfigPolicycontrollerPolicyControllerHubConfigDeploymentConfigsContainerResourcesRequestsToTerraform(struct?: GoogleGkeHubFeatureFleetDefaultMemberConfigPolicycontrollerPolicyControllerHubConfigDeploymentConfigsContainerResourcesRequestsOutputReference | GoogleGkeHubFeatureFleetDefaultMemberConfigPolicycontrollerPolicyControllerHubConfigDeploymentConfigsContainerResourcesRequests): any;
export declare function googleGkeHubFeatureFleetDefaultMemberConfigPolicycontrollerPolicyControllerHubConfigDeploymentConfigsContainerResourcesRequestsToHclTerraform(struct?: GoogleGkeHubFeatureFleetDefaultMemberConfigPolicycontrollerPolicyControllerHubConfigDeploymentConfigsContainerResourcesRequestsOutputReference | GoogleGkeHubFeatureFleetDefaultMemberConfigPolicycontrollerPolicyControllerHubConfigDeploymentConfigsContainerResourcesRequests): any;
export declare class GoogleGkeHubFeatureFleetDefaultMemberConfigPolicycontrollerPolicyControllerHubConfigDeploymentConfigsContainerResourcesRequestsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleGkeHubFeatureFleetDefaultMemberConfigPolicycontrollerPolicyControllerHubConfigDeploymentConfigsContainerResourcesRequests | undefined;
    set internalValue(value: GoogleGkeHubFeatureFleetDefaultMemberConfigPolicycontrollerPolicyControllerHubConfigDeploymentConfigsContainerResourcesRequests | undefined);
    private _cpu?;
    get cpu(): string;
    set cpu(value: string);
    resetCpu(): void;
    get cpuInput(): string | undefined;
    private _memory?;
    get memory(): string;
    set memory(value: string);
    resetMemory(): void;
    get memoryInput(): string | undefined;
}
export interface GoogleGkeHubFeatureFleetDefaultMemberConfigPolicycontrollerPolicyControllerHubConfigDeploymentConfigsContainerResources {
    /**
    * limits block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gke_hub_feature#limits GoogleGkeHubFeature#limits}
    */
    readonly limits?: GoogleGkeHubFeatureFleetDefaultMemberConfigPolicycontrollerPolicyControllerHubConfigDeploymentConfigsContainerResourcesLimits;
    /**
    * requests block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gke_hub_feature#requests GoogleGkeHubFeature#requests}
    */
    readonly requests?: GoogleGkeHubFeatureFleetDefaultMemberConfigPolicycontrollerPolicyControllerHubConfigDeploymentConfigsContainerResourcesRequests;
}
export declare function googleGkeHubFeatureFleetDefaultMemberConfigPolicycontrollerPolicyControllerHubConfigDeploymentConfigsContainerResourcesToTerraform(struct?: GoogleGkeHubFeatureFleetDefaultMemberConfigPolicycontrollerPolicyControllerHubConfigDeploymentConfigsContainerResourcesOutputReference | GoogleGkeHubFeatureFleetDefaultMemberConfigPolicycontrollerPolicyControllerHubConfigDeploymentConfigsContainerResources): any;
export declare function googleGkeHubFeatureFleetDefaultMemberConfigPolicycontrollerPolicyControllerHubConfigDeploymentConfigsContainerResourcesToHclTerraform(struct?: GoogleGkeHubFeatureFleetDefaultMemberConfigPolicycontrollerPolicyControllerHubConfigDeploymentConfigsContainerResourcesOutputReference | GoogleGkeHubFeatureFleetDefaultMemberConfigPolicycontrollerPolicyControllerHubConfigDeploymentConfigsContainerResources): any;
export declare class GoogleGkeHubFeatureFleetDefaultMemberConfigPolicycontrollerPolicyControllerHubConfigDeploymentConfigsContainerResourcesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleGkeHubFeatureFleetDefaultMemberConfigPolicycontrollerPolicyControllerHubConfigDeploymentConfigsContainerResources | undefined;
    set internalValue(value: GoogleGkeHubFeatureFleetDefaultMemberConfigPolicycontrollerPolicyControllerHubConfigDeploymentConfigsContainerResources | undefined);
    private _limits;
    get limits(): GoogleGkeHubFeatureFleetDefaultMemberConfigPolicycontrollerPolicyControllerHubConfigDeploymentConfigsContainerResourcesLimitsOutputReference;
    putLimits(value: GoogleGkeHubFeatureFleetDefaultMemberConfigPolicycontrollerPolicyControllerHubConfigDeploymentConfigsContainerResourcesLimits): void;
    resetLimits(): void;
    get limitsInput(): GoogleGkeHubFeatureFleetDefaultMemberConfigPolicycontrollerPolicyControllerHubConfigDeploymentConfigsContainerResourcesLimits | undefined;
    private _requests;
    get requests(): GoogleGkeHubFeatureFleetDefaultMemberConfigPolicycontrollerPolicyControllerHubConfigDeploymentConfigsContainerResourcesRequestsOutputReference;
    putRequests(value: GoogleGkeHubFeatureFleetDefaultMemberConfigPolicycontrollerPolicyControllerHubConfigDeploymentConfigsContainerResourcesRequests): void;
    resetRequests(): void;
    get requestsInput(): GoogleGkeHubFeatureFleetDefaultMemberConfigPolicycontrollerPolicyControllerHubConfigDeploymentConfigsContainerResourcesRequests | undefined;
}
export interface GoogleGkeHubFeatureFleetDefaultMemberConfigPolicycontrollerPolicyControllerHubConfigDeploymentConfigsPodToleration {
    /**
    * Matches a taint effect.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gke_hub_feature#effect GoogleGkeHubFeature#effect}
    */
    readonly effect?: string;
    /**
    * Matches a taint key (not necessarily unique).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gke_hub_feature#key GoogleGkeHubFeature#key}
    */
    readonly key?: string;
    /**
    * Matches a taint operator.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gke_hub_feature#operator GoogleGkeHubFeature#operator}
    */
    readonly operator?: string;
    /**
    * Matches a taint value.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gke_hub_feature#value GoogleGkeHubFeature#value}
    */
    readonly value?: string;
}
export declare function googleGkeHubFeatureFleetDefaultMemberConfigPolicycontrollerPolicyControllerHubConfigDeploymentConfigsPodTolerationToTerraform(struct?: GoogleGkeHubFeatureFleetDefaultMemberConfigPolicycontrollerPolicyControllerHubConfigDeploymentConfigsPodToleration | cdktf.IResolvable): any;
export declare function googleGkeHubFeatureFleetDefaultMemberConfigPolicycontrollerPolicyControllerHubConfigDeploymentConfigsPodTolerationToHclTerraform(struct?: GoogleGkeHubFeatureFleetDefaultMemberConfigPolicycontrollerPolicyControllerHubConfigDeploymentConfigsPodToleration | cdktf.IResolvable): any;
export declare class GoogleGkeHubFeatureFleetDefaultMemberConfigPolicycontrollerPolicyControllerHubConfigDeploymentConfigsPodTolerationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleGkeHubFeatureFleetDefaultMemberConfigPolicycontrollerPolicyControllerHubConfigDeploymentConfigsPodToleration | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleGkeHubFeatureFleetDefaultMemberConfigPolicycontrollerPolicyControllerHubConfigDeploymentConfigsPodToleration | cdktf.IResolvable | undefined);
    private _effect?;
    get effect(): string;
    set effect(value: string);
    resetEffect(): void;
    get effectInput(): string | undefined;
    private _key?;
    get key(): string;
    set key(value: string);
    resetKey(): void;
    get keyInput(): string | undefined;
    private _operator?;
    get operator(): string;
    set operator(value: string);
    resetOperator(): void;
    get operatorInput(): string | undefined;
    private _value?;
    get value(): string;
    set value(value: string);
    resetValue(): void;
    get valueInput(): string | undefined;
}
export declare class GoogleGkeHubFeatureFleetDefaultMemberConfigPolicycontrollerPolicyControllerHubConfigDeploymentConfigsPodTolerationList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleGkeHubFeatureFleetDefaultMemberConfigPolicycontrollerPolicyControllerHubConfigDeploymentConfigsPodToleration[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleGkeHubFeatureFleetDefaultMemberConfigPolicycontrollerPolicyControllerHubConfigDeploymentConfigsPodTolerationOutputReference;
}
export interface GoogleGkeHubFeatureFleetDefaultMemberConfigPolicycontrollerPolicyControllerHubConfigDeploymentConfigs {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gke_hub_feature#component GoogleGkeHubFeature#component}
    */
    readonly component: string;
    /**
    * Pod affinity configuration. Possible values: ["AFFINITY_UNSPECIFIED", "NO_AFFINITY", "ANTI_AFFINITY"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gke_hub_feature#pod_affinity GoogleGkeHubFeature#pod_affinity}
    */
    readonly podAffinity?: string;
    /**
    * Pod replica count.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gke_hub_feature#replica_count GoogleGkeHubFeature#replica_count}
    */
    readonly replicaCount?: number;
    /**
    * container_resources block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gke_hub_feature#container_resources GoogleGkeHubFeature#container_resources}
    */
    readonly containerResources?: GoogleGkeHubFeatureFleetDefaultMemberConfigPolicycontrollerPolicyControllerHubConfigDeploymentConfigsContainerResources;
    /**
    * pod_toleration block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gke_hub_feature#pod_toleration GoogleGkeHubFeature#pod_toleration}
    */
    readonly podToleration?: GoogleGkeHubFeatureFleetDefaultMemberConfigPolicycontrollerPolicyControllerHubConfigDeploymentConfigsPodToleration[] | cdktf.IResolvable;
}
export declare function googleGkeHubFeatureFleetDefaultMemberConfigPolicycontrollerPolicyControllerHubConfigDeploymentConfigsToTerraform(struct?: GoogleGkeHubFeatureFleetDefaultMemberConfigPolicycontrollerPolicyControllerHubConfigDeploymentConfigs | cdktf.IResolvable): any;
export declare function googleGkeHubFeatureFleetDefaultMemberConfigPolicycontrollerPolicyControllerHubConfigDeploymentConfigsToHclTerraform(struct?: GoogleGkeHubFeatureFleetDefaultMemberConfigPolicycontrollerPolicyControllerHubConfigDeploymentConfigs | cdktf.IResolvable): any;
export declare class GoogleGkeHubFeatureFleetDefaultMemberConfigPolicycontrollerPolicyControllerHubConfigDeploymentConfigsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleGkeHubFeatureFleetDefaultMemberConfigPolicycontrollerPolicyControllerHubConfigDeploymentConfigs | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleGkeHubFeatureFleetDefaultMemberConfigPolicycontrollerPolicyControllerHubConfigDeploymentConfigs | cdktf.IResolvable | undefined);
    private _component?;
    get component(): string;
    set component(value: string);
    get componentInput(): string | undefined;
    private _podAffinity?;
    get podAffinity(): string;
    set podAffinity(value: string);
    resetPodAffinity(): void;
    get podAffinityInput(): string | undefined;
    private _replicaCount?;
    get replicaCount(): number;
    set replicaCount(value: number);
    resetReplicaCount(): void;
    get replicaCountInput(): number | undefined;
    private _containerResources;
    get containerResources(): GoogleGkeHubFeatureFleetDefaultMemberConfigPolicycontrollerPolicyControllerHubConfigDeploymentConfigsContainerResourcesOutputReference;
    putContainerResources(value: GoogleGkeHubFeatureFleetDefaultMemberConfigPolicycontrollerPolicyControllerHubConfigDeploymentConfigsContainerResources): void;
    resetContainerResources(): void;
    get containerResourcesInput(): GoogleGkeHubFeatureFleetDefaultMemberConfigPolicycontrollerPolicyControllerHubConfigDeploymentConfigsContainerResources | undefined;
    private _podToleration;
    get podToleration(): GoogleGkeHubFeatureFleetDefaultMemberConfigPolicycontrollerPolicyControllerHubConfigDeploymentConfigsPodTolerationList;
    putPodToleration(value: GoogleGkeHubFeatureFleetDefaultMemberConfigPolicycontrollerPolicyControllerHubConfigDeploymentConfigsPodToleration[] | cdktf.IResolvable): void;
    resetPodToleration(): void;
    get podTolerationInput(): cdktf.IResolvable | GoogleGkeHubFeatureFleetDefaultMemberConfigPolicycontrollerPolicyControllerHubConfigDeploymentConfigsPodToleration[] | undefined;
}
export declare class GoogleGkeHubFeatureFleetDefaultMemberConfigPolicycontrollerPolicyControllerHubConfigDeploymentConfigsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleGkeHubFeatureFleetDefaultMemberConfigPolicycontrollerPolicyControllerHubConfigDeploymentConfigs[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleGkeHubFeatureFleetDefaultMemberConfigPolicycontrollerPolicyControllerHubConfigDeploymentConfigsOutputReference;
}
export interface GoogleGkeHubFeatureFleetDefaultMemberConfigPolicycontrollerPolicyControllerHubConfigMonitoring {
    /**
    * Specifies the list of backends Policy Controller will export to. An empty list would effectively disable metrics export. Possible values: ["MONITORING_BACKEND_UNSPECIFIED", "PROMETHEUS", "CLOUD_MONITORING"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gke_hub_feature#backends GoogleGkeHubFeature#backends}
    */
    readonly backends?: string[];
}
export declare function googleGkeHubFeatureFleetDefaultMemberConfigPolicycontrollerPolicyControllerHubConfigMonitoringToTerraform(struct?: GoogleGkeHubFeatureFleetDefaultMemberConfigPolicycontrollerPolicyControllerHubConfigMonitoringOutputReference | GoogleGkeHubFeatureFleetDefaultMemberConfigPolicycontrollerPolicyControllerHubConfigMonitoring): any;
export declare function googleGkeHubFeatureFleetDefaultMemberConfigPolicycontrollerPolicyControllerHubConfigMonitoringToHclTerraform(struct?: GoogleGkeHubFeatureFleetDefaultMemberConfigPolicycontrollerPolicyControllerHubConfigMonitoringOutputReference | GoogleGkeHubFeatureFleetDefaultMemberConfigPolicycontrollerPolicyControllerHubConfigMonitoring): any;
export declare class GoogleGkeHubFeatureFleetDefaultMemberConfigPolicycontrollerPolicyControllerHubConfigMonitoringOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleGkeHubFeatureFleetDefaultMemberConfigPolicycontrollerPolicyControllerHubConfigMonitoring | undefined;
    set internalValue(value: GoogleGkeHubFeatureFleetDefaultMemberConfigPolicycontrollerPolicyControllerHubConfigMonitoring | undefined);
    private _backends?;
    get backends(): string[];
    set backends(value: string[]);
    resetBackends(): void;
    get backendsInput(): string[] | undefined;
}
export interface GoogleGkeHubFeatureFleetDefaultMemberConfigPolicycontrollerPolicyControllerHubConfigPolicyContentBundles {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gke_hub_feature#bundle GoogleGkeHubFeature#bundle}
    */
    readonly bundle: string;
    /**
    * The set of namespaces to be exempted from the bundle.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gke_hub_feature#exempted_namespaces GoogleGkeHubFeature#exempted_namespaces}
    */
    readonly exemptedNamespaces?: string[];
}
export declare function googleGkeHubFeatureFleetDefaultMemberConfigPolicycontrollerPolicyControllerHubConfigPolicyContentBundlesToTerraform(struct?: GoogleGkeHubFeatureFleetDefaultMemberConfigPolicycontrollerPolicyControllerHubConfigPolicyContentBundles | cdktf.IResolvable): any;
export declare function googleGkeHubFeatureFleetDefaultMemberConfigPolicycontrollerPolicyControllerHubConfigPolicyContentBundlesToHclTerraform(struct?: GoogleGkeHubFeatureFleetDefaultMemberConfigPolicycontrollerPolicyControllerHubConfigPolicyContentBundles | cdktf.IResolvable): any;
export declare class GoogleGkeHubFeatureFleetDefaultMemberConfigPolicycontrollerPolicyControllerHubConfigPolicyContentBundlesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleGkeHubFeatureFleetDefaultMemberConfigPolicycontrollerPolicyControllerHubConfigPolicyContentBundles | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleGkeHubFeatureFleetDefaultMemberConfigPolicycontrollerPolicyControllerHubConfigPolicyContentBundles | cdktf.IResolvable | undefined);
    private _bundle?;
    get bundle(): string;
    set bundle(value: string);
    get bundleInput(): string | undefined;
    private _exemptedNamespaces?;
    get exemptedNamespaces(): string[];
    set exemptedNamespaces(value: string[]);
    resetExemptedNamespaces(): void;
    get exemptedNamespacesInput(): string[] | undefined;
}
export declare class GoogleGkeHubFeatureFleetDefaultMemberConfigPolicycontrollerPolicyControllerHubConfigPolicyContentBundlesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleGkeHubFeatureFleetDefaultMemberConfigPolicycontrollerPolicyControllerHubConfigPolicyContentBundles[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleGkeHubFeatureFleetDefaultMemberConfigPolicycontrollerPolicyControllerHubConfigPolicyContentBundlesOutputReference;
}
export interface GoogleGkeHubFeatureFleetDefaultMemberConfigPolicycontrollerPolicyControllerHubConfigPolicyContentTemplateLibrary {
    /**
    * Configures the manner in which the template library is installed on the cluster. Possible values: ["INSTALATION_UNSPECIFIED", "NOT_INSTALLED", "ALL"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gke_hub_feature#installation GoogleGkeHubFeature#installation}
    */
    readonly installation?: string;
}
export declare function googleGkeHubFeatureFleetDefaultMemberConfigPolicycontrollerPolicyControllerHubConfigPolicyContentTemplateLibraryToTerraform(struct?: GoogleGkeHubFeatureFleetDefaultMemberConfigPolicycontrollerPolicyControllerHubConfigPolicyContentTemplateLibraryOutputReference | GoogleGkeHubFeatureFleetDefaultMemberConfigPolicycontrollerPolicyControllerHubConfigPolicyContentTemplateLibrary): any;
export declare function googleGkeHubFeatureFleetDefaultMemberConfigPolicycontrollerPolicyControllerHubConfigPolicyContentTemplateLibraryToHclTerraform(struct?: GoogleGkeHubFeatureFleetDefaultMemberConfigPolicycontrollerPolicyControllerHubConfigPolicyContentTemplateLibraryOutputReference | GoogleGkeHubFeatureFleetDefaultMemberConfigPolicycontrollerPolicyControllerHubConfigPolicyContentTemplateLibrary): any;
export declare class GoogleGkeHubFeatureFleetDefaultMemberConfigPolicycontrollerPolicyControllerHubConfigPolicyContentTemplateLibraryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleGkeHubFeatureFleetDefaultMemberConfigPolicycontrollerPolicyControllerHubConfigPolicyContentTemplateLibrary | undefined;
    set internalValue(value: GoogleGkeHubFeatureFleetDefaultMemberConfigPolicycontrollerPolicyControllerHubConfigPolicyContentTemplateLibrary | undefined);
    private _installation?;
    get installation(): string;
    set installation(value: string);
    resetInstallation(): void;
    get installationInput(): string | undefined;
}
export interface GoogleGkeHubFeatureFleetDefaultMemberConfigPolicycontrollerPolicyControllerHubConfigPolicyContent {
    /**
    * bundles block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gke_hub_feature#bundles GoogleGkeHubFeature#bundles}
    */
    readonly bundles?: GoogleGkeHubFeatureFleetDefaultMemberConfigPolicycontrollerPolicyControllerHubConfigPolicyContentBundles[] | cdktf.IResolvable;
    /**
    * template_library block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gke_hub_feature#template_library GoogleGkeHubFeature#template_library}
    */
    readonly templateLibrary?: GoogleGkeHubFeatureFleetDefaultMemberConfigPolicycontrollerPolicyControllerHubConfigPolicyContentTemplateLibrary;
}
export declare function googleGkeHubFeatureFleetDefaultMemberConfigPolicycontrollerPolicyControllerHubConfigPolicyContentToTerraform(struct?: GoogleGkeHubFeatureFleetDefaultMemberConfigPolicycontrollerPolicyControllerHubConfigPolicyContentOutputReference | GoogleGkeHubFeatureFleetDefaultMemberConfigPolicycontrollerPolicyControllerHubConfigPolicyContent): any;
export declare function googleGkeHubFeatureFleetDefaultMemberConfigPolicycontrollerPolicyControllerHubConfigPolicyContentToHclTerraform(struct?: GoogleGkeHubFeatureFleetDefaultMemberConfigPolicycontrollerPolicyControllerHubConfigPolicyContentOutputReference | GoogleGkeHubFeatureFleetDefaultMemberConfigPolicycontrollerPolicyControllerHubConfigPolicyContent): any;
export declare class GoogleGkeHubFeatureFleetDefaultMemberConfigPolicycontrollerPolicyControllerHubConfigPolicyContentOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleGkeHubFeatureFleetDefaultMemberConfigPolicycontrollerPolicyControllerHubConfigPolicyContent | undefined;
    set internalValue(value: GoogleGkeHubFeatureFleetDefaultMemberConfigPolicycontrollerPolicyControllerHubConfigPolicyContent | undefined);
    private _bundles;
    get bundles(): GoogleGkeHubFeatureFleetDefaultMemberConfigPolicycontrollerPolicyControllerHubConfigPolicyContentBundlesList;
    putBundles(value: GoogleGkeHubFeatureFleetDefaultMemberConfigPolicycontrollerPolicyControllerHubConfigPolicyContentBundles[] | cdktf.IResolvable): void;
    resetBundles(): void;
    get bundlesInput(): cdktf.IResolvable | GoogleGkeHubFeatureFleetDefaultMemberConfigPolicycontrollerPolicyControllerHubConfigPolicyContentBundles[] | undefined;
    private _templateLibrary;
    get templateLibrary(): GoogleGkeHubFeatureFleetDefaultMemberConfigPolicycontrollerPolicyControllerHubConfigPolicyContentTemplateLibraryOutputReference;
    putTemplateLibrary(value: GoogleGkeHubFeatureFleetDefaultMemberConfigPolicycontrollerPolicyControllerHubConfigPolicyContentTemplateLibrary): void;
    resetTemplateLibrary(): void;
    get templateLibraryInput(): GoogleGkeHubFeatureFleetDefaultMemberConfigPolicycontrollerPolicyControllerHubConfigPolicyContentTemplateLibrary | undefined;
}
export interface GoogleGkeHubFeatureFleetDefaultMemberConfigPolicycontrollerPolicyControllerHubConfig {
    /**
    * Interval for Policy Controller Audit scans (in seconds). When set to 0, this disables audit functionality altogether.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gke_hub_feature#audit_interval_seconds GoogleGkeHubFeature#audit_interval_seconds}
    */
    readonly auditIntervalSeconds?: number;
    /**
    * The maximum number of audit violations to be stored in a constraint. If not set, the internal default of 20 will be used.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gke_hub_feature#constraint_violation_limit GoogleGkeHubFeature#constraint_violation_limit}
    */
    readonly constraintViolationLimit?: number;
    /**
    * The set of namespaces that are excluded from Policy Controller checks. Namespaces do not need to currently exist on the cluster.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gke_hub_feature#exemptable_namespaces GoogleGkeHubFeature#exemptable_namespaces}
    */
    readonly exemptableNamespaces?: string[];
    /**
    * Configures the mode of the Policy Controller installation Possible values: ["INSTALL_SPEC_UNSPECIFIED", "INSTALL_SPEC_NOT_INSTALLED", "INSTALL_SPEC_ENABLED", "INSTALL_SPEC_SUSPENDED", "INSTALL_SPEC_DETACHED"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gke_hub_feature#install_spec GoogleGkeHubFeature#install_spec}
    */
    readonly installSpec: string;
    /**
    * Logs all denies and dry run failures.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gke_hub_feature#log_denies_enabled GoogleGkeHubFeature#log_denies_enabled}
    */
    readonly logDeniesEnabled?: boolean | cdktf.IResolvable;
    /**
    * Enables the ability to mutate resources using Policy Controller.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gke_hub_feature#mutation_enabled GoogleGkeHubFeature#mutation_enabled}
    */
    readonly mutationEnabled?: boolean | cdktf.IResolvable;
    /**
    * Enables the ability to use Constraint Templates that reference to objects other than the object currently being evaluated.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gke_hub_feature#referential_rules_enabled GoogleGkeHubFeature#referential_rules_enabled}
    */
    readonly referentialRulesEnabled?: boolean | cdktf.IResolvable;
    /**
    * deployment_configs block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gke_hub_feature#deployment_configs GoogleGkeHubFeature#deployment_configs}
    */
    readonly deploymentConfigs?: GoogleGkeHubFeatureFleetDefaultMemberConfigPolicycontrollerPolicyControllerHubConfigDeploymentConfigs[] | cdktf.IResolvable;
    /**
    * monitoring block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gke_hub_feature#monitoring GoogleGkeHubFeature#monitoring}
    */
    readonly monitoring?: GoogleGkeHubFeatureFleetDefaultMemberConfigPolicycontrollerPolicyControllerHubConfigMonitoring;
    /**
    * policy_content block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gke_hub_feature#policy_content GoogleGkeHubFeature#policy_content}
    */
    readonly policyContent?: GoogleGkeHubFeatureFleetDefaultMemberConfigPolicycontrollerPolicyControllerHubConfigPolicyContent;
}
export declare function googleGkeHubFeatureFleetDefaultMemberConfigPolicycontrollerPolicyControllerHubConfigToTerraform(struct?: GoogleGkeHubFeatureFleetDefaultMemberConfigPolicycontrollerPolicyControllerHubConfigOutputReference | GoogleGkeHubFeatureFleetDefaultMemberConfigPolicycontrollerPolicyControllerHubConfig): any;
export declare function googleGkeHubFeatureFleetDefaultMemberConfigPolicycontrollerPolicyControllerHubConfigToHclTerraform(struct?: GoogleGkeHubFeatureFleetDefaultMemberConfigPolicycontrollerPolicyControllerHubConfigOutputReference | GoogleGkeHubFeatureFleetDefaultMemberConfigPolicycontrollerPolicyControllerHubConfig): any;
export declare class GoogleGkeHubFeatureFleetDefaultMemberConfigPolicycontrollerPolicyControllerHubConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleGkeHubFeatureFleetDefaultMemberConfigPolicycontrollerPolicyControllerHubConfig | undefined;
    set internalValue(value: GoogleGkeHubFeatureFleetDefaultMemberConfigPolicycontrollerPolicyControllerHubConfig | undefined);
    private _auditIntervalSeconds?;
    get auditIntervalSeconds(): number;
    set auditIntervalSeconds(value: number);
    resetAuditIntervalSeconds(): void;
    get auditIntervalSecondsInput(): number | undefined;
    private _constraintViolationLimit?;
    get constraintViolationLimit(): number;
    set constraintViolationLimit(value: number);
    resetConstraintViolationLimit(): void;
    get constraintViolationLimitInput(): number | undefined;
    private _exemptableNamespaces?;
    get exemptableNamespaces(): string[];
    set exemptableNamespaces(value: string[]);
    resetExemptableNamespaces(): void;
    get exemptableNamespacesInput(): string[] | undefined;
    private _installSpec?;
    get installSpec(): string;
    set installSpec(value: string);
    get installSpecInput(): string | undefined;
    private _logDeniesEnabled?;
    get logDeniesEnabled(): boolean | cdktf.IResolvable;
    set logDeniesEnabled(value: boolean | cdktf.IResolvable);
    resetLogDeniesEnabled(): void;
    get logDeniesEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _mutationEnabled?;
    get mutationEnabled(): boolean | cdktf.IResolvable;
    set mutationEnabled(value: boolean | cdktf.IResolvable);
    resetMutationEnabled(): void;
    get mutationEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _referentialRulesEnabled?;
    get referentialRulesEnabled(): boolean | cdktf.IResolvable;
    set referentialRulesEnabled(value: boolean | cdktf.IResolvable);
    resetReferentialRulesEnabled(): void;
    get referentialRulesEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _deploymentConfigs;
    get deploymentConfigs(): GoogleGkeHubFeatureFleetDefaultMemberConfigPolicycontrollerPolicyControllerHubConfigDeploymentConfigsList;
    putDeploymentConfigs(value: GoogleGkeHubFeatureFleetDefaultMemberConfigPolicycontrollerPolicyControllerHubConfigDeploymentConfigs[] | cdktf.IResolvable): void;
    resetDeploymentConfigs(): void;
    get deploymentConfigsInput(): cdktf.IResolvable | GoogleGkeHubFeatureFleetDefaultMemberConfigPolicycontrollerPolicyControllerHubConfigDeploymentConfigs[] | undefined;
    private _monitoring;
    get monitoring(): GoogleGkeHubFeatureFleetDefaultMemberConfigPolicycontrollerPolicyControllerHubConfigMonitoringOutputReference;
    putMonitoring(value: GoogleGkeHubFeatureFleetDefaultMemberConfigPolicycontrollerPolicyControllerHubConfigMonitoring): void;
    resetMonitoring(): void;
    get monitoringInput(): GoogleGkeHubFeatureFleetDefaultMemberConfigPolicycontrollerPolicyControllerHubConfigMonitoring | undefined;
    private _policyContent;
    get policyContent(): GoogleGkeHubFeatureFleetDefaultMemberConfigPolicycontrollerPolicyControllerHubConfigPolicyContentOutputReference;
    putPolicyContent(value: GoogleGkeHubFeatureFleetDefaultMemberConfigPolicycontrollerPolicyControllerHubConfigPolicyContent): void;
    resetPolicyContent(): void;
    get policyContentInput(): GoogleGkeHubFeatureFleetDefaultMemberConfigPolicycontrollerPolicyControllerHubConfigPolicyContent | undefined;
}
export interface GoogleGkeHubFeatureFleetDefaultMemberConfigPolicycontroller {
    /**
    * Configures the version of Policy Controller
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gke_hub_feature#version GoogleGkeHubFeature#version}
    */
    readonly version?: string;
    /**
    * policy_controller_hub_config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gke_hub_feature#policy_controller_hub_config GoogleGkeHubFeature#policy_controller_hub_config}
    */
    readonly policyControllerHubConfig: GoogleGkeHubFeatureFleetDefaultMemberConfigPolicycontrollerPolicyControllerHubConfig;
}
export declare function googleGkeHubFeatureFleetDefaultMemberConfigPolicycontrollerToTerraform(struct?: GoogleGkeHubFeatureFleetDefaultMemberConfigPolicycontrollerOutputReference | GoogleGkeHubFeatureFleetDefaultMemberConfigPolicycontroller): any;
export declare function googleGkeHubFeatureFleetDefaultMemberConfigPolicycontrollerToHclTerraform(struct?: GoogleGkeHubFeatureFleetDefaultMemberConfigPolicycontrollerOutputReference | GoogleGkeHubFeatureFleetDefaultMemberConfigPolicycontroller): any;
export declare class GoogleGkeHubFeatureFleetDefaultMemberConfigPolicycontrollerOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleGkeHubFeatureFleetDefaultMemberConfigPolicycontroller | undefined;
    set internalValue(value: GoogleGkeHubFeatureFleetDefaultMemberConfigPolicycontroller | undefined);
    private _version?;
    get version(): string;
    set version(value: string);
    resetVersion(): void;
    get versionInput(): string | undefined;
    private _policyControllerHubConfig;
    get policyControllerHubConfig(): GoogleGkeHubFeatureFleetDefaultMemberConfigPolicycontrollerPolicyControllerHubConfigOutputReference;
    putPolicyControllerHubConfig(value: GoogleGkeHubFeatureFleetDefaultMemberConfigPolicycontrollerPolicyControllerHubConfig): void;
    get policyControllerHubConfigInput(): GoogleGkeHubFeatureFleetDefaultMemberConfigPolicycontrollerPolicyControllerHubConfig | undefined;
}
export interface GoogleGkeHubFeatureFleetDefaultMemberConfig {
    /**
    * configmanagement block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gke_hub_feature#configmanagement GoogleGkeHubFeature#configmanagement}
    */
    readonly configmanagement?: GoogleGkeHubFeatureFleetDefaultMemberConfigConfigmanagement;
    /**
    * mesh block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gke_hub_feature#mesh GoogleGkeHubFeature#mesh}
    */
    readonly mesh?: GoogleGkeHubFeatureFleetDefaultMemberConfigMesh;
    /**
    * policycontroller block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gke_hub_feature#policycontroller GoogleGkeHubFeature#policycontroller}
    */
    readonly policycontroller?: GoogleGkeHubFeatureFleetDefaultMemberConfigPolicycontroller;
}
export declare function googleGkeHubFeatureFleetDefaultMemberConfigToTerraform(struct?: GoogleGkeHubFeatureFleetDefaultMemberConfigOutputReference | GoogleGkeHubFeatureFleetDefaultMemberConfig): any;
export declare function googleGkeHubFeatureFleetDefaultMemberConfigToHclTerraform(struct?: GoogleGkeHubFeatureFleetDefaultMemberConfigOutputReference | GoogleGkeHubFeatureFleetDefaultMemberConfig): any;
export declare class GoogleGkeHubFeatureFleetDefaultMemberConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleGkeHubFeatureFleetDefaultMemberConfig | undefined;
    set internalValue(value: GoogleGkeHubFeatureFleetDefaultMemberConfig | undefined);
    private _configmanagement;
    get configmanagement(): GoogleGkeHubFeatureFleetDefaultMemberConfigConfigmanagementOutputReference;
    putConfigmanagement(value: GoogleGkeHubFeatureFleetDefaultMemberConfigConfigmanagement): void;
    resetConfigmanagement(): void;
    get configmanagementInput(): GoogleGkeHubFeatureFleetDefaultMemberConfigConfigmanagement | undefined;
    private _mesh;
    get mesh(): GoogleGkeHubFeatureFleetDefaultMemberConfigMeshOutputReference;
    putMesh(value: GoogleGkeHubFeatureFleetDefaultMemberConfigMesh): void;
    resetMesh(): void;
    get meshInput(): GoogleGkeHubFeatureFleetDefaultMemberConfigMesh | undefined;
    private _policycontroller;
    get policycontroller(): GoogleGkeHubFeatureFleetDefaultMemberConfigPolicycontrollerOutputReference;
    putPolicycontroller(value: GoogleGkeHubFeatureFleetDefaultMemberConfigPolicycontroller): void;
    resetPolicycontroller(): void;
    get policycontrollerInput(): GoogleGkeHubFeatureFleetDefaultMemberConfigPolicycontroller | undefined;
}
export interface GoogleGkeHubFeatureSpecClusterupgradeGkeUpgradeOverridesPostConditions {
    /**
    * Amount of time to "soak" after a rollout has been finished before marking it COMPLETE. Cannot exceed 30 days.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gke_hub_feature#soaking GoogleGkeHubFeature#soaking}
    */
    readonly soaking: string;
}
export declare function googleGkeHubFeatureSpecClusterupgradeGkeUpgradeOverridesPostConditionsToTerraform(struct?: GoogleGkeHubFeatureSpecClusterupgradeGkeUpgradeOverridesPostConditionsOutputReference | GoogleGkeHubFeatureSpecClusterupgradeGkeUpgradeOverridesPostConditions): any;
export declare function googleGkeHubFeatureSpecClusterupgradeGkeUpgradeOverridesPostConditionsToHclTerraform(struct?: GoogleGkeHubFeatureSpecClusterupgradeGkeUpgradeOverridesPostConditionsOutputReference | GoogleGkeHubFeatureSpecClusterupgradeGkeUpgradeOverridesPostConditions): any;
export declare class GoogleGkeHubFeatureSpecClusterupgradeGkeUpgradeOverridesPostConditionsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleGkeHubFeatureSpecClusterupgradeGkeUpgradeOverridesPostConditions | undefined;
    set internalValue(value: GoogleGkeHubFeatureSpecClusterupgradeGkeUpgradeOverridesPostConditions | undefined);
    private _soaking?;
    get soaking(): string;
    set soaking(value: string);
    get soakingInput(): string | undefined;
}
export interface GoogleGkeHubFeatureSpecClusterupgradeGkeUpgradeOverridesUpgrade {
    /**
    * Name of the upgrade, e.g., "k8s_control_plane". It should be a valid upgrade name. It must not exceet 99 characters.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gke_hub_feature#name GoogleGkeHubFeature#name}
    */
    readonly name: string;
    /**
    * Version of the upgrade, e.g., "1.22.1-gke.100". It should be a valid version. It must not exceet 99 characters.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gke_hub_feature#version GoogleGkeHubFeature#version}
    */
    readonly version: string;
}
export declare function googleGkeHubFeatureSpecClusterupgradeGkeUpgradeOverridesUpgradeToTerraform(struct?: GoogleGkeHubFeatureSpecClusterupgradeGkeUpgradeOverridesUpgradeOutputReference | GoogleGkeHubFeatureSpecClusterupgradeGkeUpgradeOverridesUpgrade): any;
export declare function googleGkeHubFeatureSpecClusterupgradeGkeUpgradeOverridesUpgradeToHclTerraform(struct?: GoogleGkeHubFeatureSpecClusterupgradeGkeUpgradeOverridesUpgradeOutputReference | GoogleGkeHubFeatureSpecClusterupgradeGkeUpgradeOverridesUpgrade): any;
export declare class GoogleGkeHubFeatureSpecClusterupgradeGkeUpgradeOverridesUpgradeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleGkeHubFeatureSpecClusterupgradeGkeUpgradeOverridesUpgrade | undefined;
    set internalValue(value: GoogleGkeHubFeatureSpecClusterupgradeGkeUpgradeOverridesUpgrade | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _version?;
    get version(): string;
    set version(value: string);
    get versionInput(): string | undefined;
}
export interface GoogleGkeHubFeatureSpecClusterupgradeGkeUpgradeOverrides {
    /**
    * post_conditions block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gke_hub_feature#post_conditions GoogleGkeHubFeature#post_conditions}
    */
    readonly postConditions: GoogleGkeHubFeatureSpecClusterupgradeGkeUpgradeOverridesPostConditions;
    /**
    * upgrade block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gke_hub_feature#upgrade GoogleGkeHubFeature#upgrade}
    */
    readonly upgrade: GoogleGkeHubFeatureSpecClusterupgradeGkeUpgradeOverridesUpgrade;
}
export declare function googleGkeHubFeatureSpecClusterupgradeGkeUpgradeOverridesToTerraform(struct?: GoogleGkeHubFeatureSpecClusterupgradeGkeUpgradeOverrides | cdktf.IResolvable): any;
export declare function googleGkeHubFeatureSpecClusterupgradeGkeUpgradeOverridesToHclTerraform(struct?: GoogleGkeHubFeatureSpecClusterupgradeGkeUpgradeOverrides | cdktf.IResolvable): any;
export declare class GoogleGkeHubFeatureSpecClusterupgradeGkeUpgradeOverridesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleGkeHubFeatureSpecClusterupgradeGkeUpgradeOverrides | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleGkeHubFeatureSpecClusterupgradeGkeUpgradeOverrides | cdktf.IResolvable | undefined);
    private _postConditions;
    get postConditions(): GoogleGkeHubFeatureSpecClusterupgradeGkeUpgradeOverridesPostConditionsOutputReference;
    putPostConditions(value: GoogleGkeHubFeatureSpecClusterupgradeGkeUpgradeOverridesPostConditions): void;
    get postConditionsInput(): GoogleGkeHubFeatureSpecClusterupgradeGkeUpgradeOverridesPostConditions | undefined;
    private _upgrade;
    get upgrade(): GoogleGkeHubFeatureSpecClusterupgradeGkeUpgradeOverridesUpgradeOutputReference;
    putUpgrade(value: GoogleGkeHubFeatureSpecClusterupgradeGkeUpgradeOverridesUpgrade): void;
    get upgradeInput(): GoogleGkeHubFeatureSpecClusterupgradeGkeUpgradeOverridesUpgrade | undefined;
}
export declare class GoogleGkeHubFeatureSpecClusterupgradeGkeUpgradeOverridesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleGkeHubFeatureSpecClusterupgradeGkeUpgradeOverrides[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleGkeHubFeatureSpecClusterupgradeGkeUpgradeOverridesOutputReference;
}
export interface GoogleGkeHubFeatureSpecClusterupgradePostConditions {
    /**
    * Amount of time to "soak" after a rollout has been finished before marking it COMPLETE. Cannot exceed 30 days.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gke_hub_feature#soaking GoogleGkeHubFeature#soaking}
    */
    readonly soaking: string;
}
export declare function googleGkeHubFeatureSpecClusterupgradePostConditionsToTerraform(struct?: GoogleGkeHubFeatureSpecClusterupgradePostConditionsOutputReference | GoogleGkeHubFeatureSpecClusterupgradePostConditions): any;
export declare function googleGkeHubFeatureSpecClusterupgradePostConditionsToHclTerraform(struct?: GoogleGkeHubFeatureSpecClusterupgradePostConditionsOutputReference | GoogleGkeHubFeatureSpecClusterupgradePostConditions): any;
export declare class GoogleGkeHubFeatureSpecClusterupgradePostConditionsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleGkeHubFeatureSpecClusterupgradePostConditions | undefined;
    set internalValue(value: GoogleGkeHubFeatureSpecClusterupgradePostConditions | undefined);
    private _soaking?;
    get soaking(): string;
    set soaking(value: string);
    get soakingInput(): string | undefined;
}
export interface GoogleGkeHubFeatureSpecClusterupgrade {
    /**
    * Specified if other fleet should be considered as a source of upgrades. Currently, at most one upstream fleet is allowed. The fleet name should be either fleet project number or id.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gke_hub_feature#upstream_fleets GoogleGkeHubFeature#upstream_fleets}
    */
    readonly upstreamFleets: string[];
    /**
    * gke_upgrade_overrides block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gke_hub_feature#gke_upgrade_overrides GoogleGkeHubFeature#gke_upgrade_overrides}
    */
    readonly gkeUpgradeOverrides?: GoogleGkeHubFeatureSpecClusterupgradeGkeUpgradeOverrides[] | cdktf.IResolvable;
    /**
    * post_conditions block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gke_hub_feature#post_conditions GoogleGkeHubFeature#post_conditions}
    */
    readonly postConditions?: GoogleGkeHubFeatureSpecClusterupgradePostConditions;
}
export declare function googleGkeHubFeatureSpecClusterupgradeToTerraform(struct?: GoogleGkeHubFeatureSpecClusterupgradeOutputReference | GoogleGkeHubFeatureSpecClusterupgrade): any;
export declare function googleGkeHubFeatureSpecClusterupgradeToHclTerraform(struct?: GoogleGkeHubFeatureSpecClusterupgradeOutputReference | GoogleGkeHubFeatureSpecClusterupgrade): any;
export declare class GoogleGkeHubFeatureSpecClusterupgradeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleGkeHubFeatureSpecClusterupgrade | undefined;
    set internalValue(value: GoogleGkeHubFeatureSpecClusterupgrade | undefined);
    private _upstreamFleets?;
    get upstreamFleets(): string[];
    set upstreamFleets(value: string[]);
    get upstreamFleetsInput(): string[] | undefined;
    private _gkeUpgradeOverrides;
    get gkeUpgradeOverrides(): GoogleGkeHubFeatureSpecClusterupgradeGkeUpgradeOverridesList;
    putGkeUpgradeOverrides(value: GoogleGkeHubFeatureSpecClusterupgradeGkeUpgradeOverrides[] | cdktf.IResolvable): void;
    resetGkeUpgradeOverrides(): void;
    get gkeUpgradeOverridesInput(): cdktf.IResolvable | GoogleGkeHubFeatureSpecClusterupgradeGkeUpgradeOverrides[] | undefined;
    private _postConditions;
    get postConditions(): GoogleGkeHubFeatureSpecClusterupgradePostConditionsOutputReference;
    putPostConditions(value: GoogleGkeHubFeatureSpecClusterupgradePostConditions): void;
    resetPostConditions(): void;
    get postConditionsInput(): GoogleGkeHubFeatureSpecClusterupgradePostConditions | undefined;
}
export interface GoogleGkeHubFeatureSpecFleetobservabilityLoggingConfigDefaultConfig {
    /**
    * Specified if fleet logging feature is enabled. Possible values: ["MODE_UNSPECIFIED", "COPY", "MOVE"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gke_hub_feature#mode GoogleGkeHubFeature#mode}
    */
    readonly mode?: string;
}
export declare function googleGkeHubFeatureSpecFleetobservabilityLoggingConfigDefaultConfigToTerraform(struct?: GoogleGkeHubFeatureSpecFleetobservabilityLoggingConfigDefaultConfigOutputReference | GoogleGkeHubFeatureSpecFleetobservabilityLoggingConfigDefaultConfig): any;
export declare function googleGkeHubFeatureSpecFleetobservabilityLoggingConfigDefaultConfigToHclTerraform(struct?: GoogleGkeHubFeatureSpecFleetobservabilityLoggingConfigDefaultConfigOutputReference | GoogleGkeHubFeatureSpecFleetobservabilityLoggingConfigDefaultConfig): any;
export declare class GoogleGkeHubFeatureSpecFleetobservabilityLoggingConfigDefaultConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleGkeHubFeatureSpecFleetobservabilityLoggingConfigDefaultConfig | undefined;
    set internalValue(value: GoogleGkeHubFeatureSpecFleetobservabilityLoggingConfigDefaultConfig | undefined);
    private _mode?;
    get mode(): string;
    set mode(value: string);
    resetMode(): void;
    get modeInput(): string | undefined;
}
export interface GoogleGkeHubFeatureSpecFleetobservabilityLoggingConfigFleetScopeLogsConfig {
    /**
    * Specified if fleet logging feature is enabled. Possible values: ["MODE_UNSPECIFIED", "COPY", "MOVE"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gke_hub_feature#mode GoogleGkeHubFeature#mode}
    */
    readonly mode?: string;
}
export declare function googleGkeHubFeatureSpecFleetobservabilityLoggingConfigFleetScopeLogsConfigToTerraform(struct?: GoogleGkeHubFeatureSpecFleetobservabilityLoggingConfigFleetScopeLogsConfigOutputReference | GoogleGkeHubFeatureSpecFleetobservabilityLoggingConfigFleetScopeLogsConfig): any;
export declare function googleGkeHubFeatureSpecFleetobservabilityLoggingConfigFleetScopeLogsConfigToHclTerraform(struct?: GoogleGkeHubFeatureSpecFleetobservabilityLoggingConfigFleetScopeLogsConfigOutputReference | GoogleGkeHubFeatureSpecFleetobservabilityLoggingConfigFleetScopeLogsConfig): any;
export declare class GoogleGkeHubFeatureSpecFleetobservabilityLoggingConfigFleetScopeLogsConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleGkeHubFeatureSpecFleetobservabilityLoggingConfigFleetScopeLogsConfig | undefined;
    set internalValue(value: GoogleGkeHubFeatureSpecFleetobservabilityLoggingConfigFleetScopeLogsConfig | undefined);
    private _mode?;
    get mode(): string;
    set mode(value: string);
    resetMode(): void;
    get modeInput(): string | undefined;
}
export interface GoogleGkeHubFeatureSpecFleetobservabilityLoggingConfig {
    /**
    * default_config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gke_hub_feature#default_config GoogleGkeHubFeature#default_config}
    */
    readonly defaultConfig?: GoogleGkeHubFeatureSpecFleetobservabilityLoggingConfigDefaultConfig;
    /**
    * fleet_scope_logs_config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gke_hub_feature#fleet_scope_logs_config GoogleGkeHubFeature#fleet_scope_logs_config}
    */
    readonly fleetScopeLogsConfig?: GoogleGkeHubFeatureSpecFleetobservabilityLoggingConfigFleetScopeLogsConfig;
}
export declare function googleGkeHubFeatureSpecFleetobservabilityLoggingConfigToTerraform(struct?: GoogleGkeHubFeatureSpecFleetobservabilityLoggingConfigOutputReference | GoogleGkeHubFeatureSpecFleetobservabilityLoggingConfig): any;
export declare function googleGkeHubFeatureSpecFleetobservabilityLoggingConfigToHclTerraform(struct?: GoogleGkeHubFeatureSpecFleetobservabilityLoggingConfigOutputReference | GoogleGkeHubFeatureSpecFleetobservabilityLoggingConfig): any;
export declare class GoogleGkeHubFeatureSpecFleetobservabilityLoggingConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleGkeHubFeatureSpecFleetobservabilityLoggingConfig | undefined;
    set internalValue(value: GoogleGkeHubFeatureSpecFleetobservabilityLoggingConfig | undefined);
    private _defaultConfig;
    get defaultConfig(): GoogleGkeHubFeatureSpecFleetobservabilityLoggingConfigDefaultConfigOutputReference;
    putDefaultConfig(value: GoogleGkeHubFeatureSpecFleetobservabilityLoggingConfigDefaultConfig): void;
    resetDefaultConfig(): void;
    get defaultConfigInput(): GoogleGkeHubFeatureSpecFleetobservabilityLoggingConfigDefaultConfig | undefined;
    private _fleetScopeLogsConfig;
    get fleetScopeLogsConfig(): GoogleGkeHubFeatureSpecFleetobservabilityLoggingConfigFleetScopeLogsConfigOutputReference;
    putFleetScopeLogsConfig(value: GoogleGkeHubFeatureSpecFleetobservabilityLoggingConfigFleetScopeLogsConfig): void;
    resetFleetScopeLogsConfig(): void;
    get fleetScopeLogsConfigInput(): GoogleGkeHubFeatureSpecFleetobservabilityLoggingConfigFleetScopeLogsConfig | undefined;
}
export interface GoogleGkeHubFeatureSpecFleetobservability {
    /**
    * logging_config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gke_hub_feature#logging_config GoogleGkeHubFeature#logging_config}
    */
    readonly loggingConfig?: GoogleGkeHubFeatureSpecFleetobservabilityLoggingConfig;
}
export declare function googleGkeHubFeatureSpecFleetobservabilityToTerraform(struct?: GoogleGkeHubFeatureSpecFleetobservabilityOutputReference | GoogleGkeHubFeatureSpecFleetobservability): any;
export declare function googleGkeHubFeatureSpecFleetobservabilityToHclTerraform(struct?: GoogleGkeHubFeatureSpecFleetobservabilityOutputReference | GoogleGkeHubFeatureSpecFleetobservability): any;
export declare class GoogleGkeHubFeatureSpecFleetobservabilityOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleGkeHubFeatureSpecFleetobservability | undefined;
    set internalValue(value: GoogleGkeHubFeatureSpecFleetobservability | undefined);
    private _loggingConfig;
    get loggingConfig(): GoogleGkeHubFeatureSpecFleetobservabilityLoggingConfigOutputReference;
    putLoggingConfig(value: GoogleGkeHubFeatureSpecFleetobservabilityLoggingConfig): void;
    resetLoggingConfig(): void;
    get loggingConfigInput(): GoogleGkeHubFeatureSpecFleetobservabilityLoggingConfig | undefined;
}
export interface GoogleGkeHubFeatureSpecMulticlusteringress {
    /**
    * Fully-qualified Membership name which hosts the MultiClusterIngress CRD. Example: 'projects/foo-proj/locations/global/memberships/bar'
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gke_hub_feature#config_membership GoogleGkeHubFeature#config_membership}
    */
    readonly configMembership: string;
}
export declare function googleGkeHubFeatureSpecMulticlusteringressToTerraform(struct?: GoogleGkeHubFeatureSpecMulticlusteringressOutputReference | GoogleGkeHubFeatureSpecMulticlusteringress): any;
export declare function googleGkeHubFeatureSpecMulticlusteringressToHclTerraform(struct?: GoogleGkeHubFeatureSpecMulticlusteringressOutputReference | GoogleGkeHubFeatureSpecMulticlusteringress): any;
export declare class GoogleGkeHubFeatureSpecMulticlusteringressOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleGkeHubFeatureSpecMulticlusteringress | undefined;
    set internalValue(value: GoogleGkeHubFeatureSpecMulticlusteringress | undefined);
    private _configMembership?;
    get configMembership(): string;
    set configMembership(value: string);
    get configMembershipInput(): string | undefined;
}
export interface GoogleGkeHubFeatureSpec {
    /**
    * clusterupgrade block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gke_hub_feature#clusterupgrade GoogleGkeHubFeature#clusterupgrade}
    */
    readonly clusterupgrade?: GoogleGkeHubFeatureSpecClusterupgrade;
    /**
    * fleetobservability block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gke_hub_feature#fleetobservability GoogleGkeHubFeature#fleetobservability}
    */
    readonly fleetobservability?: GoogleGkeHubFeatureSpecFleetobservability;
    /**
    * multiclusteringress block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gke_hub_feature#multiclusteringress GoogleGkeHubFeature#multiclusteringress}
    */
    readonly multiclusteringress?: GoogleGkeHubFeatureSpecMulticlusteringress;
}
export declare function googleGkeHubFeatureSpecToTerraform(struct?: GoogleGkeHubFeatureSpecOutputReference | GoogleGkeHubFeatureSpec): any;
export declare function googleGkeHubFeatureSpecToHclTerraform(struct?: GoogleGkeHubFeatureSpecOutputReference | GoogleGkeHubFeatureSpec): any;
export declare class GoogleGkeHubFeatureSpecOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleGkeHubFeatureSpec | undefined;
    set internalValue(value: GoogleGkeHubFeatureSpec | undefined);
    private _clusterupgrade;
    get clusterupgrade(): GoogleGkeHubFeatureSpecClusterupgradeOutputReference;
    putClusterupgrade(value: GoogleGkeHubFeatureSpecClusterupgrade): void;
    resetClusterupgrade(): void;
    get clusterupgradeInput(): GoogleGkeHubFeatureSpecClusterupgrade | undefined;
    private _fleetobservability;
    get fleetobservability(): GoogleGkeHubFeatureSpecFleetobservabilityOutputReference;
    putFleetobservability(value: GoogleGkeHubFeatureSpecFleetobservability): void;
    resetFleetobservability(): void;
    get fleetobservabilityInput(): GoogleGkeHubFeatureSpecFleetobservability | undefined;
    private _multiclusteringress;
    get multiclusteringress(): GoogleGkeHubFeatureSpecMulticlusteringressOutputReference;
    putMulticlusteringress(value: GoogleGkeHubFeatureSpecMulticlusteringress): void;
    resetMulticlusteringress(): void;
    get multiclusteringressInput(): GoogleGkeHubFeatureSpecMulticlusteringress | undefined;
}
export interface GoogleGkeHubFeatureTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gke_hub_feature#create GoogleGkeHubFeature#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gke_hub_feature#delete GoogleGkeHubFeature#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gke_hub_feature#update GoogleGkeHubFeature#update}
    */
    readonly update?: string;
}
export declare function googleGkeHubFeatureTimeoutsToTerraform(struct?: GoogleGkeHubFeatureTimeouts | cdktf.IResolvable): any;
export declare function googleGkeHubFeatureTimeoutsToHclTerraform(struct?: GoogleGkeHubFeatureTimeouts | cdktf.IResolvable): any;
export declare class GoogleGkeHubFeatureTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleGkeHubFeatureTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleGkeHubFeatureTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gke_hub_feature google_gke_hub_feature}
*/
export declare class GoogleGkeHubFeature extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_gke_hub_feature";
    /**
    * Generates CDKTF code for importing a GoogleGkeHubFeature resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the GoogleGkeHubFeature to import
    * @param importFromId The id of the existing GoogleGkeHubFeature that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gke_hub_feature#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the GoogleGkeHubFeature to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gke_hub_feature google_gke_hub_feature} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleGkeHubFeatureConfig
    */
    constructor(scope: Construct, id: string, config: GoogleGkeHubFeatureConfig);
    get createTime(): string;
    get deleteTime(): string;
    private _effectiveLabels;
    get effectiveLabels(): cdktf.StringMap;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _labels?;
    get labels(): {
        [key: string]: string;
    };
    set labels(value: {
        [key: string]: string;
    });
    resetLabels(): void;
    get labelsInput(): {
        [key: string]: string;
    } | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _resourceState;
    get resourceState(): GoogleGkeHubFeatureResourceStateList;
    private _state;
    get state(): GoogleGkeHubFeatureStateList;
    private _terraformLabels;
    get terraformLabels(): cdktf.StringMap;
    get updateTime(): string;
    private _fleetDefaultMemberConfig;
    get fleetDefaultMemberConfig(): GoogleGkeHubFeatureFleetDefaultMemberConfigOutputReference;
    putFleetDefaultMemberConfig(value: GoogleGkeHubFeatureFleetDefaultMemberConfig): void;
    resetFleetDefaultMemberConfig(): void;
    get fleetDefaultMemberConfigInput(): GoogleGkeHubFeatureFleetDefaultMemberConfig | undefined;
    private _spec;
    get spec(): GoogleGkeHubFeatureSpecOutputReference;
    putSpec(value: GoogleGkeHubFeatureSpec): void;
    resetSpec(): void;
    get specInput(): GoogleGkeHubFeatureSpec | undefined;
    private _timeouts;
    get timeouts(): GoogleGkeHubFeatureTimeoutsOutputReference;
    putTimeouts(value: GoogleGkeHubFeatureTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleGkeHubFeatureTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
