/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleGkeHubFleetConfig extends cdktf.TerraformMetaArguments {
    /**
    * A user-assigned display name of the Fleet. When present, it must be between 4 to 30 characters.
    * Allowed characters are: lowercase and uppercase letters, numbers, hyphen, single-quote, double-quote, space, and exclamation point.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gke_hub_fleet#display_name GoogleGkeHubFleet#display_name}
    */
    readonly displayName?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gke_hub_fleet#id GoogleGkeHubFleet#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gke_hub_fleet#project GoogleGkeHubFleet#project}
    */
    readonly project?: string;
    /**
    * default_cluster_config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gke_hub_fleet#default_cluster_config GoogleGkeHubFleet#default_cluster_config}
    */
    readonly defaultClusterConfig?: GoogleGkeHubFleetDefaultClusterConfig;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gke_hub_fleet#timeouts GoogleGkeHubFleet#timeouts}
    */
    readonly timeouts?: GoogleGkeHubFleetTimeouts;
}
export interface GoogleGkeHubFleetState {
}
export declare function googleGkeHubFleetStateToTerraform(struct?: GoogleGkeHubFleetState): any;
export declare function googleGkeHubFleetStateToHclTerraform(struct?: GoogleGkeHubFleetState): any;
export declare class GoogleGkeHubFleetStateOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleGkeHubFleetState | undefined;
    set internalValue(value: GoogleGkeHubFleetState | undefined);
    get code(): string;
}
export declare class GoogleGkeHubFleetStateList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleGkeHubFleetStateOutputReference;
}
export interface GoogleGkeHubFleetDefaultClusterConfigBinaryAuthorizationConfigPolicyBindings {
    /**
    * The relative resource name of the binauthz platform policy to audit. GKE
    * platform policies have the following format:
    * 'projects/{project_number}/platforms/gke/policies/{policy_id}'.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gke_hub_fleet#name GoogleGkeHubFleet#name}
    */
    readonly name?: string;
}
export declare function googleGkeHubFleetDefaultClusterConfigBinaryAuthorizationConfigPolicyBindingsToTerraform(struct?: GoogleGkeHubFleetDefaultClusterConfigBinaryAuthorizationConfigPolicyBindings | cdktf.IResolvable): any;
export declare function googleGkeHubFleetDefaultClusterConfigBinaryAuthorizationConfigPolicyBindingsToHclTerraform(struct?: GoogleGkeHubFleetDefaultClusterConfigBinaryAuthorizationConfigPolicyBindings | cdktf.IResolvable): any;
export declare class GoogleGkeHubFleetDefaultClusterConfigBinaryAuthorizationConfigPolicyBindingsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleGkeHubFleetDefaultClusterConfigBinaryAuthorizationConfigPolicyBindings | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleGkeHubFleetDefaultClusterConfigBinaryAuthorizationConfigPolicyBindings | cdktf.IResolvable | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
}
export declare class GoogleGkeHubFleetDefaultClusterConfigBinaryAuthorizationConfigPolicyBindingsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleGkeHubFleetDefaultClusterConfigBinaryAuthorizationConfigPolicyBindings[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleGkeHubFleetDefaultClusterConfigBinaryAuthorizationConfigPolicyBindingsOutputReference;
}
export interface GoogleGkeHubFleetDefaultClusterConfigBinaryAuthorizationConfig {
    /**
    * Mode of operation for binauthz policy evaluation. Possible values: ["DISABLED", "POLICY_BINDINGS"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gke_hub_fleet#evaluation_mode GoogleGkeHubFleet#evaluation_mode}
    */
    readonly evaluationMode?: string;
    /**
    * policy_bindings block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gke_hub_fleet#policy_bindings GoogleGkeHubFleet#policy_bindings}
    */
    readonly policyBindings?: GoogleGkeHubFleetDefaultClusterConfigBinaryAuthorizationConfigPolicyBindings[] | cdktf.IResolvable;
}
export declare function googleGkeHubFleetDefaultClusterConfigBinaryAuthorizationConfigToTerraform(struct?: GoogleGkeHubFleetDefaultClusterConfigBinaryAuthorizationConfigOutputReference | GoogleGkeHubFleetDefaultClusterConfigBinaryAuthorizationConfig): any;
export declare function googleGkeHubFleetDefaultClusterConfigBinaryAuthorizationConfigToHclTerraform(struct?: GoogleGkeHubFleetDefaultClusterConfigBinaryAuthorizationConfigOutputReference | GoogleGkeHubFleetDefaultClusterConfigBinaryAuthorizationConfig): any;
export declare class GoogleGkeHubFleetDefaultClusterConfigBinaryAuthorizationConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleGkeHubFleetDefaultClusterConfigBinaryAuthorizationConfig | undefined;
    set internalValue(value: GoogleGkeHubFleetDefaultClusterConfigBinaryAuthorizationConfig | undefined);
    private _evaluationMode?;
    get evaluationMode(): string;
    set evaluationMode(value: string);
    resetEvaluationMode(): void;
    get evaluationModeInput(): string | undefined;
    private _policyBindings;
    get policyBindings(): GoogleGkeHubFleetDefaultClusterConfigBinaryAuthorizationConfigPolicyBindingsList;
    putPolicyBindings(value: GoogleGkeHubFleetDefaultClusterConfigBinaryAuthorizationConfigPolicyBindings[] | cdktf.IResolvable): void;
    resetPolicyBindings(): void;
    get policyBindingsInput(): cdktf.IResolvable | GoogleGkeHubFleetDefaultClusterConfigBinaryAuthorizationConfigPolicyBindings[] | undefined;
}
export interface GoogleGkeHubFleetDefaultClusterConfigSecurityPostureConfig {
    /**
    * Sets which mode to use for Security Posture features. Possible values: ["DISABLED", "BASIC"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gke_hub_fleet#mode GoogleGkeHubFleet#mode}
    */
    readonly mode?: string;
    /**
    * Sets which mode to use for vulnerability scanning. Possible values: ["VULNERABILITY_DISABLED", "VULNERABILITY_BASIC", "VULNERABILITY_ENTERPRISE"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gke_hub_fleet#vulnerability_mode GoogleGkeHubFleet#vulnerability_mode}
    */
    readonly vulnerabilityMode?: string;
}
export declare function googleGkeHubFleetDefaultClusterConfigSecurityPostureConfigToTerraform(struct?: GoogleGkeHubFleetDefaultClusterConfigSecurityPostureConfigOutputReference | GoogleGkeHubFleetDefaultClusterConfigSecurityPostureConfig): any;
export declare function googleGkeHubFleetDefaultClusterConfigSecurityPostureConfigToHclTerraform(struct?: GoogleGkeHubFleetDefaultClusterConfigSecurityPostureConfigOutputReference | GoogleGkeHubFleetDefaultClusterConfigSecurityPostureConfig): any;
export declare class GoogleGkeHubFleetDefaultClusterConfigSecurityPostureConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleGkeHubFleetDefaultClusterConfigSecurityPostureConfig | undefined;
    set internalValue(value: GoogleGkeHubFleetDefaultClusterConfigSecurityPostureConfig | undefined);
    private _mode?;
    get mode(): string;
    set mode(value: string);
    resetMode(): void;
    get modeInput(): string | undefined;
    private _vulnerabilityMode?;
    get vulnerabilityMode(): string;
    set vulnerabilityMode(value: string);
    resetVulnerabilityMode(): void;
    get vulnerabilityModeInput(): string | undefined;
}
export interface GoogleGkeHubFleetDefaultClusterConfig {
    /**
    * binary_authorization_config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gke_hub_fleet#binary_authorization_config GoogleGkeHubFleet#binary_authorization_config}
    */
    readonly binaryAuthorizationConfig?: GoogleGkeHubFleetDefaultClusterConfigBinaryAuthorizationConfig;
    /**
    * security_posture_config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gke_hub_fleet#security_posture_config GoogleGkeHubFleet#security_posture_config}
    */
    readonly securityPostureConfig?: GoogleGkeHubFleetDefaultClusterConfigSecurityPostureConfig;
}
export declare function googleGkeHubFleetDefaultClusterConfigToTerraform(struct?: GoogleGkeHubFleetDefaultClusterConfigOutputReference | GoogleGkeHubFleetDefaultClusterConfig): any;
export declare function googleGkeHubFleetDefaultClusterConfigToHclTerraform(struct?: GoogleGkeHubFleetDefaultClusterConfigOutputReference | GoogleGkeHubFleetDefaultClusterConfig): any;
export declare class GoogleGkeHubFleetDefaultClusterConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleGkeHubFleetDefaultClusterConfig | undefined;
    set internalValue(value: GoogleGkeHubFleetDefaultClusterConfig | undefined);
    private _binaryAuthorizationConfig;
    get binaryAuthorizationConfig(): GoogleGkeHubFleetDefaultClusterConfigBinaryAuthorizationConfigOutputReference;
    putBinaryAuthorizationConfig(value: GoogleGkeHubFleetDefaultClusterConfigBinaryAuthorizationConfig): void;
    resetBinaryAuthorizationConfig(): void;
    get binaryAuthorizationConfigInput(): GoogleGkeHubFleetDefaultClusterConfigBinaryAuthorizationConfig | undefined;
    private _securityPostureConfig;
    get securityPostureConfig(): GoogleGkeHubFleetDefaultClusterConfigSecurityPostureConfigOutputReference;
    putSecurityPostureConfig(value: GoogleGkeHubFleetDefaultClusterConfigSecurityPostureConfig): void;
    resetSecurityPostureConfig(): void;
    get securityPostureConfigInput(): GoogleGkeHubFleetDefaultClusterConfigSecurityPostureConfig | undefined;
}
export interface GoogleGkeHubFleetTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gke_hub_fleet#create GoogleGkeHubFleet#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gke_hub_fleet#delete GoogleGkeHubFleet#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gke_hub_fleet#update GoogleGkeHubFleet#update}
    */
    readonly update?: string;
}
export declare function googleGkeHubFleetTimeoutsToTerraform(struct?: GoogleGkeHubFleetTimeouts | cdktf.IResolvable): any;
export declare function googleGkeHubFleetTimeoutsToHclTerraform(struct?: GoogleGkeHubFleetTimeouts | cdktf.IResolvable): any;
export declare class GoogleGkeHubFleetTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleGkeHubFleetTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleGkeHubFleetTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gke_hub_fleet google_gke_hub_fleet}
*/
export declare class GoogleGkeHubFleet extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_gke_hub_fleet";
    /**
    * Generates CDKTF code for importing a GoogleGkeHubFleet resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the GoogleGkeHubFleet to import
    * @param importFromId The id of the existing GoogleGkeHubFleet that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gke_hub_fleet#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the GoogleGkeHubFleet to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gke_hub_fleet google_gke_hub_fleet} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleGkeHubFleetConfig = {}
    */
    constructor(scope: Construct, id: string, config?: GoogleGkeHubFleetConfig);
    get createTime(): string;
    get deleteTime(): string;
    private _displayName?;
    get displayName(): string;
    set displayName(value: string);
    resetDisplayName(): void;
    get displayNameInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _state;
    get state(): GoogleGkeHubFleetStateList;
    get uid(): string;
    get updateTime(): string;
    private _defaultClusterConfig;
    get defaultClusterConfig(): GoogleGkeHubFleetDefaultClusterConfigOutputReference;
    putDefaultClusterConfig(value: GoogleGkeHubFleetDefaultClusterConfig): void;
    resetDefaultClusterConfig(): void;
    get defaultClusterConfigInput(): GoogleGkeHubFleetDefaultClusterConfig | undefined;
    private _timeouts;
    get timeouts(): GoogleGkeHubFleetTimeoutsOutputReference;
    putTimeouts(value: GoogleGkeHubFleetTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleGkeHubFleetTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
