/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleGkeHubMembershipRbacRoleBindingConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gke_hub_membership_rbac_role_binding#id GoogleGkeHubMembershipRbacRoleBinding#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Location of the Membership
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gke_hub_membership_rbac_role_binding#location GoogleGkeHubMembershipRbacRoleBinding#location}
    */
    readonly location: string;
    /**
    * Id of the membership
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gke_hub_membership_rbac_role_binding#membership_id GoogleGkeHubMembershipRbacRoleBinding#membership_id}
    */
    readonly membershipId: string;
    /**
    * The client-provided identifier of the RBAC Role Binding.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gke_hub_membership_rbac_role_binding#membership_rbac_role_binding_id GoogleGkeHubMembershipRbacRoleBinding#membership_rbac_role_binding_id}
    */
    readonly membershipRbacRoleBindingId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gke_hub_membership_rbac_role_binding#project GoogleGkeHubMembershipRbacRoleBinding#project}
    */
    readonly project?: string;
    /**
    * Principal that is be authorized in the cluster (at least of one the oneof
    * is required). Updating one will unset the other automatically.
    * user is the name of the user as seen by the kubernetes cluster, example
    * "alice" or "alice@domain.tld"
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gke_hub_membership_rbac_role_binding#user GoogleGkeHubMembershipRbacRoleBinding#user}
    */
    readonly user: string;
    /**
    * role block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gke_hub_membership_rbac_role_binding#role GoogleGkeHubMembershipRbacRoleBinding#role}
    */
    readonly role: GoogleGkeHubMembershipRbacRoleBindingRole;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gke_hub_membership_rbac_role_binding#timeouts GoogleGkeHubMembershipRbacRoleBinding#timeouts}
    */
    readonly timeouts?: GoogleGkeHubMembershipRbacRoleBindingTimeouts;
}
export interface GoogleGkeHubMembershipRbacRoleBindingState {
}
export declare function googleGkeHubMembershipRbacRoleBindingStateToTerraform(struct?: GoogleGkeHubMembershipRbacRoleBindingState): any;
export declare function googleGkeHubMembershipRbacRoleBindingStateToHclTerraform(struct?: GoogleGkeHubMembershipRbacRoleBindingState): any;
export declare class GoogleGkeHubMembershipRbacRoleBindingStateOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleGkeHubMembershipRbacRoleBindingState | undefined;
    set internalValue(value: GoogleGkeHubMembershipRbacRoleBindingState | undefined);
    get code(): string;
}
export declare class GoogleGkeHubMembershipRbacRoleBindingStateList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleGkeHubMembershipRbacRoleBindingStateOutputReference;
}
export interface GoogleGkeHubMembershipRbacRoleBindingRole {
    /**
    * PredefinedRole is an ENUM representation of the default Kubernetes Roles Possible values: ["UNKNOWN", "ADMIN", "EDIT", "VIEW", "ANTHOS_SUPPORT"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gke_hub_membership_rbac_role_binding#predefined_role GoogleGkeHubMembershipRbacRoleBinding#predefined_role}
    */
    readonly predefinedRole: string;
}
export declare function googleGkeHubMembershipRbacRoleBindingRoleToTerraform(struct?: GoogleGkeHubMembershipRbacRoleBindingRoleOutputReference | GoogleGkeHubMembershipRbacRoleBindingRole): any;
export declare function googleGkeHubMembershipRbacRoleBindingRoleToHclTerraform(struct?: GoogleGkeHubMembershipRbacRoleBindingRoleOutputReference | GoogleGkeHubMembershipRbacRoleBindingRole): any;
export declare class GoogleGkeHubMembershipRbacRoleBindingRoleOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleGkeHubMembershipRbacRoleBindingRole | undefined;
    set internalValue(value: GoogleGkeHubMembershipRbacRoleBindingRole | undefined);
    private _predefinedRole?;
    get predefinedRole(): string;
    set predefinedRole(value: string);
    get predefinedRoleInput(): string | undefined;
}
export interface GoogleGkeHubMembershipRbacRoleBindingTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gke_hub_membership_rbac_role_binding#create GoogleGkeHubMembershipRbacRoleBinding#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gke_hub_membership_rbac_role_binding#delete GoogleGkeHubMembershipRbacRoleBinding#delete}
    */
    readonly delete?: string;
}
export declare function googleGkeHubMembershipRbacRoleBindingTimeoutsToTerraform(struct?: GoogleGkeHubMembershipRbacRoleBindingTimeouts | cdktf.IResolvable): any;
export declare function googleGkeHubMembershipRbacRoleBindingTimeoutsToHclTerraform(struct?: GoogleGkeHubMembershipRbacRoleBindingTimeouts | cdktf.IResolvable): any;
export declare class GoogleGkeHubMembershipRbacRoleBindingTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleGkeHubMembershipRbacRoleBindingTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleGkeHubMembershipRbacRoleBindingTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gke_hub_membership_rbac_role_binding google_gke_hub_membership_rbac_role_binding}
*/
export declare class GoogleGkeHubMembershipRbacRoleBinding extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_gke_hub_membership_rbac_role_binding";
    /**
    * Generates CDKTF code for importing a GoogleGkeHubMembershipRbacRoleBinding resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the GoogleGkeHubMembershipRbacRoleBinding to import
    * @param importFromId The id of the existing GoogleGkeHubMembershipRbacRoleBinding that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gke_hub_membership_rbac_role_binding#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the GoogleGkeHubMembershipRbacRoleBinding to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gke_hub_membership_rbac_role_binding google_gke_hub_membership_rbac_role_binding} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleGkeHubMembershipRbacRoleBindingConfig
    */
    constructor(scope: Construct, id: string, config: GoogleGkeHubMembershipRbacRoleBindingConfig);
    get createTime(): string;
    get deleteTime(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _membershipId?;
    get membershipId(): string;
    set membershipId(value: string);
    get membershipIdInput(): string | undefined;
    private _membershipRbacRoleBindingId?;
    get membershipRbacRoleBindingId(): string;
    set membershipRbacRoleBindingId(value: string);
    get membershipRbacRoleBindingIdInput(): string | undefined;
    get name(): string;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _state;
    get state(): GoogleGkeHubMembershipRbacRoleBindingStateList;
    get uid(): string;
    get updateTime(): string;
    private _user?;
    get user(): string;
    set user(value: string);
    get userInput(): string | undefined;
    private _role;
    get role(): GoogleGkeHubMembershipRbacRoleBindingRoleOutputReference;
    putRole(value: GoogleGkeHubMembershipRbacRoleBindingRole): void;
    get roleInput(): GoogleGkeHubMembershipRbacRoleBindingRole | undefined;
    private _timeouts;
    get timeouts(): GoogleGkeHubMembershipRbacRoleBindingTimeoutsOutputReference;
    putTimeouts(value: GoogleGkeHubMembershipRbacRoleBindingTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleGkeHubMembershipRbacRoleBindingTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
