/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleGkeHubScopeRbacRoleBindingConfig extends cdktf.TerraformMetaArguments {
    /**
    * Principal that is be authorized in the cluster (at least of one the oneof
    * is required). Updating one will unset the other automatically.
    * group is the group, as seen by the kubernetes cluster.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gke_hub_scope_rbac_role_binding#group GoogleGkeHubScopeRbacRoleBinding#group}
    */
    readonly group?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gke_hub_scope_rbac_role_binding#id GoogleGkeHubScopeRbacRoleBinding#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Labels for this ScopeRBACRoleBinding.
    *
    *
    * **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
    * Please refer to the field 'effective_labels' for all of the labels present on the resource.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gke_hub_scope_rbac_role_binding#labels GoogleGkeHubScopeRbacRoleBinding#labels}
    */
    readonly labels?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gke_hub_scope_rbac_role_binding#project GoogleGkeHubScopeRbacRoleBinding#project}
    */
    readonly project?: string;
    /**
    * Id of the scope
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gke_hub_scope_rbac_role_binding#scope_id GoogleGkeHubScopeRbacRoleBinding#scope_id}
    */
    readonly scopeId: string;
    /**
    * The client-provided identifier of the RBAC Role Binding.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gke_hub_scope_rbac_role_binding#scope_rbac_role_binding_id GoogleGkeHubScopeRbacRoleBinding#scope_rbac_role_binding_id}
    */
    readonly scopeRbacRoleBindingId: string;
    /**
    * Principal that is be authorized in the cluster (at least of one the oneof
    * is required). Updating one will unset the other automatically.
    * user is the name of the user as seen by the kubernetes cluster, example
    * "alice" or "alice@domain.tld"
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gke_hub_scope_rbac_role_binding#user GoogleGkeHubScopeRbacRoleBinding#user}
    */
    readonly user?: string;
    /**
    * role block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gke_hub_scope_rbac_role_binding#role GoogleGkeHubScopeRbacRoleBinding#role}
    */
    readonly role: GoogleGkeHubScopeRbacRoleBindingRole;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gke_hub_scope_rbac_role_binding#timeouts GoogleGkeHubScopeRbacRoleBinding#timeouts}
    */
    readonly timeouts?: GoogleGkeHubScopeRbacRoleBindingTimeouts;
}
export interface GoogleGkeHubScopeRbacRoleBindingState {
}
export declare function googleGkeHubScopeRbacRoleBindingStateToTerraform(struct?: GoogleGkeHubScopeRbacRoleBindingState): any;
export declare function googleGkeHubScopeRbacRoleBindingStateToHclTerraform(struct?: GoogleGkeHubScopeRbacRoleBindingState): any;
export declare class GoogleGkeHubScopeRbacRoleBindingStateOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleGkeHubScopeRbacRoleBindingState | undefined;
    set internalValue(value: GoogleGkeHubScopeRbacRoleBindingState | undefined);
    get code(): string;
}
export declare class GoogleGkeHubScopeRbacRoleBindingStateList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleGkeHubScopeRbacRoleBindingStateOutputReference;
}
export interface GoogleGkeHubScopeRbacRoleBindingRole {
    /**
    * PredefinedRole is an ENUM representation of the default Kubernetes Roles Possible values: ["UNKNOWN", "ADMIN", "EDIT", "VIEW"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gke_hub_scope_rbac_role_binding#predefined_role GoogleGkeHubScopeRbacRoleBinding#predefined_role}
    */
    readonly predefinedRole?: string;
}
export declare function googleGkeHubScopeRbacRoleBindingRoleToTerraform(struct?: GoogleGkeHubScopeRbacRoleBindingRoleOutputReference | GoogleGkeHubScopeRbacRoleBindingRole): any;
export declare function googleGkeHubScopeRbacRoleBindingRoleToHclTerraform(struct?: GoogleGkeHubScopeRbacRoleBindingRoleOutputReference | GoogleGkeHubScopeRbacRoleBindingRole): any;
export declare class GoogleGkeHubScopeRbacRoleBindingRoleOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleGkeHubScopeRbacRoleBindingRole | undefined;
    set internalValue(value: GoogleGkeHubScopeRbacRoleBindingRole | undefined);
    private _predefinedRole?;
    get predefinedRole(): string;
    set predefinedRole(value: string);
    resetPredefinedRole(): void;
    get predefinedRoleInput(): string | undefined;
}
export interface GoogleGkeHubScopeRbacRoleBindingTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gke_hub_scope_rbac_role_binding#create GoogleGkeHubScopeRbacRoleBinding#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gke_hub_scope_rbac_role_binding#delete GoogleGkeHubScopeRbacRoleBinding#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gke_hub_scope_rbac_role_binding#update GoogleGkeHubScopeRbacRoleBinding#update}
    */
    readonly update?: string;
}
export declare function googleGkeHubScopeRbacRoleBindingTimeoutsToTerraform(struct?: GoogleGkeHubScopeRbacRoleBindingTimeouts | cdktf.IResolvable): any;
export declare function googleGkeHubScopeRbacRoleBindingTimeoutsToHclTerraform(struct?: GoogleGkeHubScopeRbacRoleBindingTimeouts | cdktf.IResolvable): any;
export declare class GoogleGkeHubScopeRbacRoleBindingTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleGkeHubScopeRbacRoleBindingTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleGkeHubScopeRbacRoleBindingTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gke_hub_scope_rbac_role_binding google_gke_hub_scope_rbac_role_binding}
*/
export declare class GoogleGkeHubScopeRbacRoleBinding extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_gke_hub_scope_rbac_role_binding";
    /**
    * Generates CDKTF code for importing a GoogleGkeHubScopeRbacRoleBinding resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the GoogleGkeHubScopeRbacRoleBinding to import
    * @param importFromId The id of the existing GoogleGkeHubScopeRbacRoleBinding that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gke_hub_scope_rbac_role_binding#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the GoogleGkeHubScopeRbacRoleBinding to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gke_hub_scope_rbac_role_binding google_gke_hub_scope_rbac_role_binding} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleGkeHubScopeRbacRoleBindingConfig
    */
    constructor(scope: Construct, id: string, config: GoogleGkeHubScopeRbacRoleBindingConfig);
    get createTime(): string;
    get deleteTime(): string;
    private _effectiveLabels;
    get effectiveLabels(): cdktf.StringMap;
    private _group?;
    get group(): string;
    set group(value: string);
    resetGroup(): void;
    get groupInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _labels?;
    get labels(): {
        [key: string]: string;
    };
    set labels(value: {
        [key: string]: string;
    });
    resetLabels(): void;
    get labelsInput(): {
        [key: string]: string;
    } | undefined;
    get name(): string;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _scopeId?;
    get scopeId(): string;
    set scopeId(value: string);
    get scopeIdInput(): string | undefined;
    private _scopeRbacRoleBindingId?;
    get scopeRbacRoleBindingId(): string;
    set scopeRbacRoleBindingId(value: string);
    get scopeRbacRoleBindingIdInput(): string | undefined;
    private _state;
    get state(): GoogleGkeHubScopeRbacRoleBindingStateList;
    private _terraformLabels;
    get terraformLabels(): cdktf.StringMap;
    get uid(): string;
    get updateTime(): string;
    private _user?;
    get user(): string;
    set user(value: string);
    resetUser(): void;
    get userInput(): string | undefined;
    private _role;
    get role(): GoogleGkeHubScopeRbacRoleBindingRoleOutputReference;
    putRole(value: GoogleGkeHubScopeRbacRoleBindingRole): void;
    get roleInput(): GoogleGkeHubScopeRbacRoleBindingRole | undefined;
    private _timeouts;
    get timeouts(): GoogleGkeHubScopeRbacRoleBindingTimeoutsOutputReference;
    putTimeouts(value: GoogleGkeHubScopeRbacRoleBindingTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleGkeHubScopeRbacRoleBindingTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
