/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleGkeonpremBareMetalAdminClusterConfig extends cdktf.TerraformMetaArguments {
    /**
    * Annotations on the Bare Metal Admin Cluster.
    * This field has the same restrictions as Kubernetes annotations.
    * The total size of all keys and values combined is limited to 256k.
    * Key can have 2 segments: prefix (optional) and name (required),
    * separated by a slash (/).
    * Prefix must be a DNS subdomain.
    * Name must be 63 characters or less, begin and end with alphanumerics,
    * with dashes (-), underscores (_), dots (.), and alphanumerics between.
    *
    *
    * **Note**: This field is non-authoritative, and will only manage the annotations present in your configuration.
    * Please refer to the field 'effective_annotations' for all of the annotations present on the resource.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gkeonprem_bare_metal_admin_cluster#annotations GoogleGkeonpremBareMetalAdminCluster#annotations}
    */
    readonly annotations?: {
        [key: string]: string;
    };
    /**
    * A human readable description of this Bare Metal Admin Cluster.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gkeonprem_bare_metal_admin_cluster#bare_metal_version GoogleGkeonpremBareMetalAdminCluster#bare_metal_version}
    */
    readonly bareMetalVersion?: string;
    /**
    * A human readable description of this Bare Metal Admin Cluster.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gkeonprem_bare_metal_admin_cluster#description GoogleGkeonpremBareMetalAdminCluster#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gkeonprem_bare_metal_admin_cluster#id GoogleGkeonpremBareMetalAdminCluster#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The location of the resource.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gkeonprem_bare_metal_admin_cluster#location GoogleGkeonpremBareMetalAdminCluster#location}
    */
    readonly location: string;
    /**
    * The bare metal admin cluster name.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gkeonprem_bare_metal_admin_cluster#name GoogleGkeonpremBareMetalAdminCluster#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gkeonprem_bare_metal_admin_cluster#project GoogleGkeonpremBareMetalAdminCluster#project}
    */
    readonly project?: string;
    /**
    * cluster_operations block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gkeonprem_bare_metal_admin_cluster#cluster_operations GoogleGkeonpremBareMetalAdminCluster#cluster_operations}
    */
    readonly clusterOperations?: GoogleGkeonpremBareMetalAdminClusterClusterOperations;
    /**
    * control_plane block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gkeonprem_bare_metal_admin_cluster#control_plane GoogleGkeonpremBareMetalAdminCluster#control_plane}
    */
    readonly controlPlane?: GoogleGkeonpremBareMetalAdminClusterControlPlane;
    /**
    * load_balancer block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gkeonprem_bare_metal_admin_cluster#load_balancer GoogleGkeonpremBareMetalAdminCluster#load_balancer}
    */
    readonly loadBalancer?: GoogleGkeonpremBareMetalAdminClusterLoadBalancer;
    /**
    * maintenance_config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gkeonprem_bare_metal_admin_cluster#maintenance_config GoogleGkeonpremBareMetalAdminCluster#maintenance_config}
    */
    readonly maintenanceConfig?: GoogleGkeonpremBareMetalAdminClusterMaintenanceConfig;
    /**
    * network_config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gkeonprem_bare_metal_admin_cluster#network_config GoogleGkeonpremBareMetalAdminCluster#network_config}
    */
    readonly networkConfig?: GoogleGkeonpremBareMetalAdminClusterNetworkConfig;
    /**
    * node_access_config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gkeonprem_bare_metal_admin_cluster#node_access_config GoogleGkeonpremBareMetalAdminCluster#node_access_config}
    */
    readonly nodeAccessConfig?: GoogleGkeonpremBareMetalAdminClusterNodeAccessConfig;
    /**
    * node_config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gkeonprem_bare_metal_admin_cluster#node_config GoogleGkeonpremBareMetalAdminCluster#node_config}
    */
    readonly nodeConfig?: GoogleGkeonpremBareMetalAdminClusterNodeConfig;
    /**
    * proxy block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gkeonprem_bare_metal_admin_cluster#proxy GoogleGkeonpremBareMetalAdminCluster#proxy}
    */
    readonly proxy?: GoogleGkeonpremBareMetalAdminClusterProxy;
    /**
    * security_config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gkeonprem_bare_metal_admin_cluster#security_config GoogleGkeonpremBareMetalAdminCluster#security_config}
    */
    readonly securityConfig?: GoogleGkeonpremBareMetalAdminClusterSecurityConfig;
    /**
    * storage block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gkeonprem_bare_metal_admin_cluster#storage GoogleGkeonpremBareMetalAdminCluster#storage}
    */
    readonly storage?: GoogleGkeonpremBareMetalAdminClusterStorage;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gkeonprem_bare_metal_admin_cluster#timeouts GoogleGkeonpremBareMetalAdminCluster#timeouts}
    */
    readonly timeouts?: GoogleGkeonpremBareMetalAdminClusterTimeouts;
}
export interface GoogleGkeonpremBareMetalAdminClusterFleet {
}
export declare function googleGkeonpremBareMetalAdminClusterFleetToTerraform(struct?: GoogleGkeonpremBareMetalAdminClusterFleet): any;
export declare function googleGkeonpremBareMetalAdminClusterFleetToHclTerraform(struct?: GoogleGkeonpremBareMetalAdminClusterFleet): any;
export declare class GoogleGkeonpremBareMetalAdminClusterFleetOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleGkeonpremBareMetalAdminClusterFleet | undefined;
    set internalValue(value: GoogleGkeonpremBareMetalAdminClusterFleet | undefined);
    get membership(): string;
}
export declare class GoogleGkeonpremBareMetalAdminClusterFleetList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleGkeonpremBareMetalAdminClusterFleetOutputReference;
}
export interface GoogleGkeonpremBareMetalAdminClusterStatusConditions {
}
export declare function googleGkeonpremBareMetalAdminClusterStatusConditionsToTerraform(struct?: GoogleGkeonpremBareMetalAdminClusterStatusConditions): any;
export declare function googleGkeonpremBareMetalAdminClusterStatusConditionsToHclTerraform(struct?: GoogleGkeonpremBareMetalAdminClusterStatusConditions): any;
export declare class GoogleGkeonpremBareMetalAdminClusterStatusConditionsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleGkeonpremBareMetalAdminClusterStatusConditions | undefined;
    set internalValue(value: GoogleGkeonpremBareMetalAdminClusterStatusConditions | undefined);
    get lastTransitionTime(): string;
    get message(): string;
    get reason(): string;
    get state(): string;
    get type(): string;
}
export declare class GoogleGkeonpremBareMetalAdminClusterStatusConditionsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleGkeonpremBareMetalAdminClusterStatusConditionsOutputReference;
}
export interface GoogleGkeonpremBareMetalAdminClusterStatus {
}
export declare function googleGkeonpremBareMetalAdminClusterStatusToTerraform(struct?: GoogleGkeonpremBareMetalAdminClusterStatus): any;
export declare function googleGkeonpremBareMetalAdminClusterStatusToHclTerraform(struct?: GoogleGkeonpremBareMetalAdminClusterStatus): any;
export declare class GoogleGkeonpremBareMetalAdminClusterStatusOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleGkeonpremBareMetalAdminClusterStatus | undefined;
    set internalValue(value: GoogleGkeonpremBareMetalAdminClusterStatus | undefined);
    private _conditions;
    get conditions(): GoogleGkeonpremBareMetalAdminClusterStatusConditionsList;
    get errorMessage(): string;
}
export declare class GoogleGkeonpremBareMetalAdminClusterStatusList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleGkeonpremBareMetalAdminClusterStatusOutputReference;
}
export interface GoogleGkeonpremBareMetalAdminClusterValidationCheckStatusResult {
}
export declare function googleGkeonpremBareMetalAdminClusterValidationCheckStatusResultToTerraform(struct?: GoogleGkeonpremBareMetalAdminClusterValidationCheckStatusResult): any;
export declare function googleGkeonpremBareMetalAdminClusterValidationCheckStatusResultToHclTerraform(struct?: GoogleGkeonpremBareMetalAdminClusterValidationCheckStatusResult): any;
export declare class GoogleGkeonpremBareMetalAdminClusterValidationCheckStatusResultOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleGkeonpremBareMetalAdminClusterValidationCheckStatusResult | undefined;
    set internalValue(value: GoogleGkeonpremBareMetalAdminClusterValidationCheckStatusResult | undefined);
    get category(): string;
    get description(): string;
    get details(): string;
    get options(): string;
    get reason(): string;
}
export declare class GoogleGkeonpremBareMetalAdminClusterValidationCheckStatusResultList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleGkeonpremBareMetalAdminClusterValidationCheckStatusResultOutputReference;
}
export interface GoogleGkeonpremBareMetalAdminClusterValidationCheckStatus {
}
export declare function googleGkeonpremBareMetalAdminClusterValidationCheckStatusToTerraform(struct?: GoogleGkeonpremBareMetalAdminClusterValidationCheckStatus): any;
export declare function googleGkeonpremBareMetalAdminClusterValidationCheckStatusToHclTerraform(struct?: GoogleGkeonpremBareMetalAdminClusterValidationCheckStatus): any;
export declare class GoogleGkeonpremBareMetalAdminClusterValidationCheckStatusOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleGkeonpremBareMetalAdminClusterValidationCheckStatus | undefined;
    set internalValue(value: GoogleGkeonpremBareMetalAdminClusterValidationCheckStatus | undefined);
    private _result;
    get result(): GoogleGkeonpremBareMetalAdminClusterValidationCheckStatusResultList;
}
export declare class GoogleGkeonpremBareMetalAdminClusterValidationCheckStatusList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleGkeonpremBareMetalAdminClusterValidationCheckStatusOutputReference;
}
export interface GoogleGkeonpremBareMetalAdminClusterValidationCheck {
}
export declare function googleGkeonpremBareMetalAdminClusterValidationCheckToTerraform(struct?: GoogleGkeonpremBareMetalAdminClusterValidationCheck): any;
export declare function googleGkeonpremBareMetalAdminClusterValidationCheckToHclTerraform(struct?: GoogleGkeonpremBareMetalAdminClusterValidationCheck): any;
export declare class GoogleGkeonpremBareMetalAdminClusterValidationCheckOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleGkeonpremBareMetalAdminClusterValidationCheck | undefined;
    set internalValue(value: GoogleGkeonpremBareMetalAdminClusterValidationCheck | undefined);
    get options(): string;
    get scenario(): string;
    private _status;
    get status(): GoogleGkeonpremBareMetalAdminClusterValidationCheckStatusList;
}
export declare class GoogleGkeonpremBareMetalAdminClusterValidationCheckList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleGkeonpremBareMetalAdminClusterValidationCheckOutputReference;
}
export interface GoogleGkeonpremBareMetalAdminClusterClusterOperations {
    /**
    * Whether collection of application logs/metrics should be enabled (in addition to system logs/metrics).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gkeonprem_bare_metal_admin_cluster#enable_application_logs GoogleGkeonpremBareMetalAdminCluster#enable_application_logs}
    */
    readonly enableApplicationLogs?: boolean | cdktf.IResolvable;
}
export declare function googleGkeonpremBareMetalAdminClusterClusterOperationsToTerraform(struct?: GoogleGkeonpremBareMetalAdminClusterClusterOperationsOutputReference | GoogleGkeonpremBareMetalAdminClusterClusterOperations): any;
export declare function googleGkeonpremBareMetalAdminClusterClusterOperationsToHclTerraform(struct?: GoogleGkeonpremBareMetalAdminClusterClusterOperationsOutputReference | GoogleGkeonpremBareMetalAdminClusterClusterOperations): any;
export declare class GoogleGkeonpremBareMetalAdminClusterClusterOperationsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleGkeonpremBareMetalAdminClusterClusterOperations | undefined;
    set internalValue(value: GoogleGkeonpremBareMetalAdminClusterClusterOperations | undefined);
    private _enableApplicationLogs?;
    get enableApplicationLogs(): boolean | cdktf.IResolvable;
    set enableApplicationLogs(value: boolean | cdktf.IResolvable);
    resetEnableApplicationLogs(): void;
    get enableApplicationLogsInput(): boolean | cdktf.IResolvable | undefined;
}
export interface GoogleGkeonpremBareMetalAdminClusterControlPlaneApiServerArgs {
    /**
    * The argument name as it appears on the API Server command line please make sure to remove the leading dashes.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gkeonprem_bare_metal_admin_cluster#argument GoogleGkeonpremBareMetalAdminCluster#argument}
    */
    readonly argument: string;
    /**
    * The value of the arg as it will be passed to the API Server command line.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gkeonprem_bare_metal_admin_cluster#value GoogleGkeonpremBareMetalAdminCluster#value}
    */
    readonly value: string;
}
export declare function googleGkeonpremBareMetalAdminClusterControlPlaneApiServerArgsToTerraform(struct?: GoogleGkeonpremBareMetalAdminClusterControlPlaneApiServerArgs | cdktf.IResolvable): any;
export declare function googleGkeonpremBareMetalAdminClusterControlPlaneApiServerArgsToHclTerraform(struct?: GoogleGkeonpremBareMetalAdminClusterControlPlaneApiServerArgs | cdktf.IResolvable): any;
export declare class GoogleGkeonpremBareMetalAdminClusterControlPlaneApiServerArgsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleGkeonpremBareMetalAdminClusterControlPlaneApiServerArgs | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleGkeonpremBareMetalAdminClusterControlPlaneApiServerArgs | cdktf.IResolvable | undefined);
    private _argument?;
    get argument(): string;
    set argument(value: string);
    get argumentInput(): string | undefined;
    private _value?;
    get value(): string;
    set value(value: string);
    get valueInput(): string | undefined;
}
export declare class GoogleGkeonpremBareMetalAdminClusterControlPlaneApiServerArgsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleGkeonpremBareMetalAdminClusterControlPlaneApiServerArgs[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleGkeonpremBareMetalAdminClusterControlPlaneApiServerArgsOutputReference;
}
export interface GoogleGkeonpremBareMetalAdminClusterControlPlaneControlPlaneNodePoolConfigNodePoolConfigNodeConfigs {
    /**
    * The map of Kubernetes labels (key/value pairs) to be applied to
    * each node. These will added in addition to any default label(s)
    * that Kubernetes may apply to the node. In case of conflict in
    * label keys, the applied set may differ depending on the Kubernetes
    * version -- it's best to assume the behavior is undefined and
    * conflicts should be avoided. For more information, including usage
    * and the valid values, see:
    *   http://kubernetes.io/v1.1/docs/user-guide/labels.html
    * An object containing a list of "key": value pairs.
    * Example: { "name": "wrench", "mass": "1.3kg", "count": "3" }.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gkeonprem_bare_metal_admin_cluster#labels GoogleGkeonpremBareMetalAdminCluster#labels}
    */
    readonly labels?: {
        [key: string]: string;
    };
    /**
    * The default IPv4 address for SSH access and Kubernetes node.
    * Example: 192.168.0.1
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gkeonprem_bare_metal_admin_cluster#node_ip GoogleGkeonpremBareMetalAdminCluster#node_ip}
    */
    readonly nodeIp?: string;
}
export declare function googleGkeonpremBareMetalAdminClusterControlPlaneControlPlaneNodePoolConfigNodePoolConfigNodeConfigsToTerraform(struct?: GoogleGkeonpremBareMetalAdminClusterControlPlaneControlPlaneNodePoolConfigNodePoolConfigNodeConfigs | cdktf.IResolvable): any;
export declare function googleGkeonpremBareMetalAdminClusterControlPlaneControlPlaneNodePoolConfigNodePoolConfigNodeConfigsToHclTerraform(struct?: GoogleGkeonpremBareMetalAdminClusterControlPlaneControlPlaneNodePoolConfigNodePoolConfigNodeConfigs | cdktf.IResolvable): any;
export declare class GoogleGkeonpremBareMetalAdminClusterControlPlaneControlPlaneNodePoolConfigNodePoolConfigNodeConfigsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleGkeonpremBareMetalAdminClusterControlPlaneControlPlaneNodePoolConfigNodePoolConfigNodeConfigs | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleGkeonpremBareMetalAdminClusterControlPlaneControlPlaneNodePoolConfigNodePoolConfigNodeConfigs | cdktf.IResolvable | undefined);
    private _labels?;
    get labels(): {
        [key: string]: string;
    };
    set labels(value: {
        [key: string]: string;
    });
    resetLabels(): void;
    get labelsInput(): {
        [key: string]: string;
    } | undefined;
    private _nodeIp?;
    get nodeIp(): string;
    set nodeIp(value: string);
    resetNodeIp(): void;
    get nodeIpInput(): string | undefined;
}
export declare class GoogleGkeonpremBareMetalAdminClusterControlPlaneControlPlaneNodePoolConfigNodePoolConfigNodeConfigsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleGkeonpremBareMetalAdminClusterControlPlaneControlPlaneNodePoolConfigNodePoolConfigNodeConfigs[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleGkeonpremBareMetalAdminClusterControlPlaneControlPlaneNodePoolConfigNodePoolConfigNodeConfigsOutputReference;
}
export interface GoogleGkeonpremBareMetalAdminClusterControlPlaneControlPlaneNodePoolConfigNodePoolConfigTaints {
    /**
    * Specifies the nodes operating system (default: LINUX). Possible values: ["EFFECT_UNSPECIFIED", "PREFER_NO_SCHEDULE", "NO_EXECUTE"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gkeonprem_bare_metal_admin_cluster#effect GoogleGkeonpremBareMetalAdminCluster#effect}
    */
    readonly effect?: string;
    /**
    * Key associated with the effect.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gkeonprem_bare_metal_admin_cluster#key GoogleGkeonpremBareMetalAdminCluster#key}
    */
    readonly key?: string;
    /**
    * Value associated with the effect.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gkeonprem_bare_metal_admin_cluster#value GoogleGkeonpremBareMetalAdminCluster#value}
    */
    readonly value?: string;
}
export declare function googleGkeonpremBareMetalAdminClusterControlPlaneControlPlaneNodePoolConfigNodePoolConfigTaintsToTerraform(struct?: GoogleGkeonpremBareMetalAdminClusterControlPlaneControlPlaneNodePoolConfigNodePoolConfigTaints | cdktf.IResolvable): any;
export declare function googleGkeonpremBareMetalAdminClusterControlPlaneControlPlaneNodePoolConfigNodePoolConfigTaintsToHclTerraform(struct?: GoogleGkeonpremBareMetalAdminClusterControlPlaneControlPlaneNodePoolConfigNodePoolConfigTaints | cdktf.IResolvable): any;
export declare class GoogleGkeonpremBareMetalAdminClusterControlPlaneControlPlaneNodePoolConfigNodePoolConfigTaintsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleGkeonpremBareMetalAdminClusterControlPlaneControlPlaneNodePoolConfigNodePoolConfigTaints | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleGkeonpremBareMetalAdminClusterControlPlaneControlPlaneNodePoolConfigNodePoolConfigTaints | cdktf.IResolvable | undefined);
    private _effect?;
    get effect(): string;
    set effect(value: string);
    resetEffect(): void;
    get effectInput(): string | undefined;
    private _key?;
    get key(): string;
    set key(value: string);
    resetKey(): void;
    get keyInput(): string | undefined;
    private _value?;
    get value(): string;
    set value(value: string);
    resetValue(): void;
    get valueInput(): string | undefined;
}
export declare class GoogleGkeonpremBareMetalAdminClusterControlPlaneControlPlaneNodePoolConfigNodePoolConfigTaintsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleGkeonpremBareMetalAdminClusterControlPlaneControlPlaneNodePoolConfigNodePoolConfigTaints[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleGkeonpremBareMetalAdminClusterControlPlaneControlPlaneNodePoolConfigNodePoolConfigTaintsOutputReference;
}
export interface GoogleGkeonpremBareMetalAdminClusterControlPlaneControlPlaneNodePoolConfigNodePoolConfig {
    /**
    * The map of Kubernetes labels (key/value pairs) to be applied to
    * each node. These will added in addition to any default label(s)
    * that Kubernetes may apply to the node. In case of conflict in
    * label keys, the applied set may differ depending on the Kubernetes
    * version -- it's best to assume the behavior is undefined and
    * conflicts should be avoided. For more information, including usage
    * and the valid values, see:
    *   http://kubernetes.io/v1.1/docs/user-guide/labels.html
    * An object containing a list of "key": value pairs.
    * Example: { "name": "wrench", "mass": "1.3kg", "count": "3" }.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gkeonprem_bare_metal_admin_cluster#labels GoogleGkeonpremBareMetalAdminCluster#labels}
    */
    readonly labels?: {
        [key: string]: string;
    };
    /**
    * Specifies the nodes operating system (default: LINUX).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gkeonprem_bare_metal_admin_cluster#operating_system GoogleGkeonpremBareMetalAdminCluster#operating_system}
    */
    readonly operatingSystem?: string;
    /**
    * node_configs block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gkeonprem_bare_metal_admin_cluster#node_configs GoogleGkeonpremBareMetalAdminCluster#node_configs}
    */
    readonly nodeConfigs?: GoogleGkeonpremBareMetalAdminClusterControlPlaneControlPlaneNodePoolConfigNodePoolConfigNodeConfigs[] | cdktf.IResolvable;
    /**
    * taints block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gkeonprem_bare_metal_admin_cluster#taints GoogleGkeonpremBareMetalAdminCluster#taints}
    */
    readonly taints?: GoogleGkeonpremBareMetalAdminClusterControlPlaneControlPlaneNodePoolConfigNodePoolConfigTaints[] | cdktf.IResolvable;
}
export declare function googleGkeonpremBareMetalAdminClusterControlPlaneControlPlaneNodePoolConfigNodePoolConfigToTerraform(struct?: GoogleGkeonpremBareMetalAdminClusterControlPlaneControlPlaneNodePoolConfigNodePoolConfigOutputReference | GoogleGkeonpremBareMetalAdminClusterControlPlaneControlPlaneNodePoolConfigNodePoolConfig): any;
export declare function googleGkeonpremBareMetalAdminClusterControlPlaneControlPlaneNodePoolConfigNodePoolConfigToHclTerraform(struct?: GoogleGkeonpremBareMetalAdminClusterControlPlaneControlPlaneNodePoolConfigNodePoolConfigOutputReference | GoogleGkeonpremBareMetalAdminClusterControlPlaneControlPlaneNodePoolConfigNodePoolConfig): any;
export declare class GoogleGkeonpremBareMetalAdminClusterControlPlaneControlPlaneNodePoolConfigNodePoolConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleGkeonpremBareMetalAdminClusterControlPlaneControlPlaneNodePoolConfigNodePoolConfig | undefined;
    set internalValue(value: GoogleGkeonpremBareMetalAdminClusterControlPlaneControlPlaneNodePoolConfigNodePoolConfig | undefined);
    private _labels?;
    get labels(): {
        [key: string]: string;
    };
    set labels(value: {
        [key: string]: string;
    });
    resetLabels(): void;
    get labelsInput(): {
        [key: string]: string;
    } | undefined;
    private _operatingSystem?;
    get operatingSystem(): string;
    set operatingSystem(value: string);
    resetOperatingSystem(): void;
    get operatingSystemInput(): string | undefined;
    private _nodeConfigs;
    get nodeConfigs(): GoogleGkeonpremBareMetalAdminClusterControlPlaneControlPlaneNodePoolConfigNodePoolConfigNodeConfigsList;
    putNodeConfigs(value: GoogleGkeonpremBareMetalAdminClusterControlPlaneControlPlaneNodePoolConfigNodePoolConfigNodeConfigs[] | cdktf.IResolvable): void;
    resetNodeConfigs(): void;
    get nodeConfigsInput(): cdktf.IResolvable | GoogleGkeonpremBareMetalAdminClusterControlPlaneControlPlaneNodePoolConfigNodePoolConfigNodeConfigs[] | undefined;
    private _taints;
    get taints(): GoogleGkeonpremBareMetalAdminClusterControlPlaneControlPlaneNodePoolConfigNodePoolConfigTaintsList;
    putTaints(value: GoogleGkeonpremBareMetalAdminClusterControlPlaneControlPlaneNodePoolConfigNodePoolConfigTaints[] | cdktf.IResolvable): void;
    resetTaints(): void;
    get taintsInput(): cdktf.IResolvable | GoogleGkeonpremBareMetalAdminClusterControlPlaneControlPlaneNodePoolConfigNodePoolConfigTaints[] | undefined;
}
export interface GoogleGkeonpremBareMetalAdminClusterControlPlaneControlPlaneNodePoolConfig {
    /**
    * node_pool_config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gkeonprem_bare_metal_admin_cluster#node_pool_config GoogleGkeonpremBareMetalAdminCluster#node_pool_config}
    */
    readonly nodePoolConfig: GoogleGkeonpremBareMetalAdminClusterControlPlaneControlPlaneNodePoolConfigNodePoolConfig;
}
export declare function googleGkeonpremBareMetalAdminClusterControlPlaneControlPlaneNodePoolConfigToTerraform(struct?: GoogleGkeonpremBareMetalAdminClusterControlPlaneControlPlaneNodePoolConfigOutputReference | GoogleGkeonpremBareMetalAdminClusterControlPlaneControlPlaneNodePoolConfig): any;
export declare function googleGkeonpremBareMetalAdminClusterControlPlaneControlPlaneNodePoolConfigToHclTerraform(struct?: GoogleGkeonpremBareMetalAdminClusterControlPlaneControlPlaneNodePoolConfigOutputReference | GoogleGkeonpremBareMetalAdminClusterControlPlaneControlPlaneNodePoolConfig): any;
export declare class GoogleGkeonpremBareMetalAdminClusterControlPlaneControlPlaneNodePoolConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleGkeonpremBareMetalAdminClusterControlPlaneControlPlaneNodePoolConfig | undefined;
    set internalValue(value: GoogleGkeonpremBareMetalAdminClusterControlPlaneControlPlaneNodePoolConfig | undefined);
    private _nodePoolConfig;
    get nodePoolConfig(): GoogleGkeonpremBareMetalAdminClusterControlPlaneControlPlaneNodePoolConfigNodePoolConfigOutputReference;
    putNodePoolConfig(value: GoogleGkeonpremBareMetalAdminClusterControlPlaneControlPlaneNodePoolConfigNodePoolConfig): void;
    get nodePoolConfigInput(): GoogleGkeonpremBareMetalAdminClusterControlPlaneControlPlaneNodePoolConfigNodePoolConfig | undefined;
}
export interface GoogleGkeonpremBareMetalAdminClusterControlPlane {
    /**
    * api_server_args block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gkeonprem_bare_metal_admin_cluster#api_server_args GoogleGkeonpremBareMetalAdminCluster#api_server_args}
    */
    readonly apiServerArgs?: GoogleGkeonpremBareMetalAdminClusterControlPlaneApiServerArgs[] | cdktf.IResolvable;
    /**
    * control_plane_node_pool_config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gkeonprem_bare_metal_admin_cluster#control_plane_node_pool_config GoogleGkeonpremBareMetalAdminCluster#control_plane_node_pool_config}
    */
    readonly controlPlaneNodePoolConfig: GoogleGkeonpremBareMetalAdminClusterControlPlaneControlPlaneNodePoolConfig;
}
export declare function googleGkeonpremBareMetalAdminClusterControlPlaneToTerraform(struct?: GoogleGkeonpremBareMetalAdminClusterControlPlaneOutputReference | GoogleGkeonpremBareMetalAdminClusterControlPlane): any;
export declare function googleGkeonpremBareMetalAdminClusterControlPlaneToHclTerraform(struct?: GoogleGkeonpremBareMetalAdminClusterControlPlaneOutputReference | GoogleGkeonpremBareMetalAdminClusterControlPlane): any;
export declare class GoogleGkeonpremBareMetalAdminClusterControlPlaneOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleGkeonpremBareMetalAdminClusterControlPlane | undefined;
    set internalValue(value: GoogleGkeonpremBareMetalAdminClusterControlPlane | undefined);
    private _apiServerArgs;
    get apiServerArgs(): GoogleGkeonpremBareMetalAdminClusterControlPlaneApiServerArgsList;
    putApiServerArgs(value: GoogleGkeonpremBareMetalAdminClusterControlPlaneApiServerArgs[] | cdktf.IResolvable): void;
    resetApiServerArgs(): void;
    get apiServerArgsInput(): cdktf.IResolvable | GoogleGkeonpremBareMetalAdminClusterControlPlaneApiServerArgs[] | undefined;
    private _controlPlaneNodePoolConfig;
    get controlPlaneNodePoolConfig(): GoogleGkeonpremBareMetalAdminClusterControlPlaneControlPlaneNodePoolConfigOutputReference;
    putControlPlaneNodePoolConfig(value: GoogleGkeonpremBareMetalAdminClusterControlPlaneControlPlaneNodePoolConfig): void;
    get controlPlaneNodePoolConfigInput(): GoogleGkeonpremBareMetalAdminClusterControlPlaneControlPlaneNodePoolConfig | undefined;
}
export interface GoogleGkeonpremBareMetalAdminClusterLoadBalancerManualLbConfig {
    /**
    * Whether manual load balancing is enabled.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gkeonprem_bare_metal_admin_cluster#enabled GoogleGkeonpremBareMetalAdminCluster#enabled}
    */
    readonly enabled: boolean | cdktf.IResolvable;
}
export declare function googleGkeonpremBareMetalAdminClusterLoadBalancerManualLbConfigToTerraform(struct?: GoogleGkeonpremBareMetalAdminClusterLoadBalancerManualLbConfigOutputReference | GoogleGkeonpremBareMetalAdminClusterLoadBalancerManualLbConfig): any;
export declare function googleGkeonpremBareMetalAdminClusterLoadBalancerManualLbConfigToHclTerraform(struct?: GoogleGkeonpremBareMetalAdminClusterLoadBalancerManualLbConfigOutputReference | GoogleGkeonpremBareMetalAdminClusterLoadBalancerManualLbConfig): any;
export declare class GoogleGkeonpremBareMetalAdminClusterLoadBalancerManualLbConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleGkeonpremBareMetalAdminClusterLoadBalancerManualLbConfig | undefined;
    set internalValue(value: GoogleGkeonpremBareMetalAdminClusterLoadBalancerManualLbConfig | undefined);
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
}
export interface GoogleGkeonpremBareMetalAdminClusterLoadBalancerPortConfig {
    /**
    * The port that control plane hosted load balancers will listen on.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gkeonprem_bare_metal_admin_cluster#control_plane_load_balancer_port GoogleGkeonpremBareMetalAdminCluster#control_plane_load_balancer_port}
    */
    readonly controlPlaneLoadBalancerPort: number;
}
export declare function googleGkeonpremBareMetalAdminClusterLoadBalancerPortConfigToTerraform(struct?: GoogleGkeonpremBareMetalAdminClusterLoadBalancerPortConfigOutputReference | GoogleGkeonpremBareMetalAdminClusterLoadBalancerPortConfig): any;
export declare function googleGkeonpremBareMetalAdminClusterLoadBalancerPortConfigToHclTerraform(struct?: GoogleGkeonpremBareMetalAdminClusterLoadBalancerPortConfigOutputReference | GoogleGkeonpremBareMetalAdminClusterLoadBalancerPortConfig): any;
export declare class GoogleGkeonpremBareMetalAdminClusterLoadBalancerPortConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleGkeonpremBareMetalAdminClusterLoadBalancerPortConfig | undefined;
    set internalValue(value: GoogleGkeonpremBareMetalAdminClusterLoadBalancerPortConfig | undefined);
    private _controlPlaneLoadBalancerPort?;
    get controlPlaneLoadBalancerPort(): number;
    set controlPlaneLoadBalancerPort(value: number);
    get controlPlaneLoadBalancerPortInput(): number | undefined;
}
export interface GoogleGkeonpremBareMetalAdminClusterLoadBalancerVipConfig {
    /**
    * The VIP which you previously set aside for the Kubernetes API of this Bare Metal Admin Cluster.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gkeonprem_bare_metal_admin_cluster#control_plane_vip GoogleGkeonpremBareMetalAdminCluster#control_plane_vip}
    */
    readonly controlPlaneVip: string;
}
export declare function googleGkeonpremBareMetalAdminClusterLoadBalancerVipConfigToTerraform(struct?: GoogleGkeonpremBareMetalAdminClusterLoadBalancerVipConfigOutputReference | GoogleGkeonpremBareMetalAdminClusterLoadBalancerVipConfig): any;
export declare function googleGkeonpremBareMetalAdminClusterLoadBalancerVipConfigToHclTerraform(struct?: GoogleGkeonpremBareMetalAdminClusterLoadBalancerVipConfigOutputReference | GoogleGkeonpremBareMetalAdminClusterLoadBalancerVipConfig): any;
export declare class GoogleGkeonpremBareMetalAdminClusterLoadBalancerVipConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleGkeonpremBareMetalAdminClusterLoadBalancerVipConfig | undefined;
    set internalValue(value: GoogleGkeonpremBareMetalAdminClusterLoadBalancerVipConfig | undefined);
    private _controlPlaneVip?;
    get controlPlaneVip(): string;
    set controlPlaneVip(value: string);
    get controlPlaneVipInput(): string | undefined;
}
export interface GoogleGkeonpremBareMetalAdminClusterLoadBalancer {
    /**
    * manual_lb_config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gkeonprem_bare_metal_admin_cluster#manual_lb_config GoogleGkeonpremBareMetalAdminCluster#manual_lb_config}
    */
    readonly manualLbConfig?: GoogleGkeonpremBareMetalAdminClusterLoadBalancerManualLbConfig;
    /**
    * port_config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gkeonprem_bare_metal_admin_cluster#port_config GoogleGkeonpremBareMetalAdminCluster#port_config}
    */
    readonly portConfig: GoogleGkeonpremBareMetalAdminClusterLoadBalancerPortConfig;
    /**
    * vip_config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gkeonprem_bare_metal_admin_cluster#vip_config GoogleGkeonpremBareMetalAdminCluster#vip_config}
    */
    readonly vipConfig: GoogleGkeonpremBareMetalAdminClusterLoadBalancerVipConfig;
}
export declare function googleGkeonpremBareMetalAdminClusterLoadBalancerToTerraform(struct?: GoogleGkeonpremBareMetalAdminClusterLoadBalancerOutputReference | GoogleGkeonpremBareMetalAdminClusterLoadBalancer): any;
export declare function googleGkeonpremBareMetalAdminClusterLoadBalancerToHclTerraform(struct?: GoogleGkeonpremBareMetalAdminClusterLoadBalancerOutputReference | GoogleGkeonpremBareMetalAdminClusterLoadBalancer): any;
export declare class GoogleGkeonpremBareMetalAdminClusterLoadBalancerOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleGkeonpremBareMetalAdminClusterLoadBalancer | undefined;
    set internalValue(value: GoogleGkeonpremBareMetalAdminClusterLoadBalancer | undefined);
    private _manualLbConfig;
    get manualLbConfig(): GoogleGkeonpremBareMetalAdminClusterLoadBalancerManualLbConfigOutputReference;
    putManualLbConfig(value: GoogleGkeonpremBareMetalAdminClusterLoadBalancerManualLbConfig): void;
    resetManualLbConfig(): void;
    get manualLbConfigInput(): GoogleGkeonpremBareMetalAdminClusterLoadBalancerManualLbConfig | undefined;
    private _portConfig;
    get portConfig(): GoogleGkeonpremBareMetalAdminClusterLoadBalancerPortConfigOutputReference;
    putPortConfig(value: GoogleGkeonpremBareMetalAdminClusterLoadBalancerPortConfig): void;
    get portConfigInput(): GoogleGkeonpremBareMetalAdminClusterLoadBalancerPortConfig | undefined;
    private _vipConfig;
    get vipConfig(): GoogleGkeonpremBareMetalAdminClusterLoadBalancerVipConfigOutputReference;
    putVipConfig(value: GoogleGkeonpremBareMetalAdminClusterLoadBalancerVipConfig): void;
    get vipConfigInput(): GoogleGkeonpremBareMetalAdminClusterLoadBalancerVipConfig | undefined;
}
export interface GoogleGkeonpremBareMetalAdminClusterMaintenanceConfig {
    /**
    * All IPv4 address from these ranges will be placed into maintenance mode.
    * Nodes in maintenance mode will be cordoned and drained. When both of these
    * are true, the "baremetal.cluster.gke.io/maintenance" annotation will be set
    * on the node resource.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gkeonprem_bare_metal_admin_cluster#maintenance_address_cidr_blocks GoogleGkeonpremBareMetalAdminCluster#maintenance_address_cidr_blocks}
    */
    readonly maintenanceAddressCidrBlocks: string[];
}
export declare function googleGkeonpremBareMetalAdminClusterMaintenanceConfigToTerraform(struct?: GoogleGkeonpremBareMetalAdminClusterMaintenanceConfigOutputReference | GoogleGkeonpremBareMetalAdminClusterMaintenanceConfig): any;
export declare function googleGkeonpremBareMetalAdminClusterMaintenanceConfigToHclTerraform(struct?: GoogleGkeonpremBareMetalAdminClusterMaintenanceConfigOutputReference | GoogleGkeonpremBareMetalAdminClusterMaintenanceConfig): any;
export declare class GoogleGkeonpremBareMetalAdminClusterMaintenanceConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleGkeonpremBareMetalAdminClusterMaintenanceConfig | undefined;
    set internalValue(value: GoogleGkeonpremBareMetalAdminClusterMaintenanceConfig | undefined);
    private _maintenanceAddressCidrBlocks?;
    get maintenanceAddressCidrBlocks(): string[];
    set maintenanceAddressCidrBlocks(value: string[]);
    get maintenanceAddressCidrBlocksInput(): string[] | undefined;
}
export interface GoogleGkeonpremBareMetalAdminClusterNetworkConfigIslandModeCidr {
    /**
    * All pods in the cluster are assigned an RFC1918 IPv4 address from these ranges. This field cannot be changed after creation.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gkeonprem_bare_metal_admin_cluster#pod_address_cidr_blocks GoogleGkeonpremBareMetalAdminCluster#pod_address_cidr_blocks}
    */
    readonly podAddressCidrBlocks: string[];
    /**
    * All services in the cluster are assigned an RFC1918 IPv4 address from these ranges. This field cannot be changed after creation.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gkeonprem_bare_metal_admin_cluster#service_address_cidr_blocks GoogleGkeonpremBareMetalAdminCluster#service_address_cidr_blocks}
    */
    readonly serviceAddressCidrBlocks: string[];
}
export declare function googleGkeonpremBareMetalAdminClusterNetworkConfigIslandModeCidrToTerraform(struct?: GoogleGkeonpremBareMetalAdminClusterNetworkConfigIslandModeCidrOutputReference | GoogleGkeonpremBareMetalAdminClusterNetworkConfigIslandModeCidr): any;
export declare function googleGkeonpremBareMetalAdminClusterNetworkConfigIslandModeCidrToHclTerraform(struct?: GoogleGkeonpremBareMetalAdminClusterNetworkConfigIslandModeCidrOutputReference | GoogleGkeonpremBareMetalAdminClusterNetworkConfigIslandModeCidr): any;
export declare class GoogleGkeonpremBareMetalAdminClusterNetworkConfigIslandModeCidrOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleGkeonpremBareMetalAdminClusterNetworkConfigIslandModeCidr | undefined;
    set internalValue(value: GoogleGkeonpremBareMetalAdminClusterNetworkConfigIslandModeCidr | undefined);
    private _podAddressCidrBlocks?;
    get podAddressCidrBlocks(): string[];
    set podAddressCidrBlocks(value: string[]);
    get podAddressCidrBlocksInput(): string[] | undefined;
    private _serviceAddressCidrBlocks?;
    get serviceAddressCidrBlocks(): string[];
    set serviceAddressCidrBlocks(value: string[]);
    get serviceAddressCidrBlocksInput(): string[] | undefined;
}
export interface GoogleGkeonpremBareMetalAdminClusterNetworkConfig {
    /**
    * island_mode_cidr block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gkeonprem_bare_metal_admin_cluster#island_mode_cidr GoogleGkeonpremBareMetalAdminCluster#island_mode_cidr}
    */
    readonly islandModeCidr?: GoogleGkeonpremBareMetalAdminClusterNetworkConfigIslandModeCidr;
}
export declare function googleGkeonpremBareMetalAdminClusterNetworkConfigToTerraform(struct?: GoogleGkeonpremBareMetalAdminClusterNetworkConfigOutputReference | GoogleGkeonpremBareMetalAdminClusterNetworkConfig): any;
export declare function googleGkeonpremBareMetalAdminClusterNetworkConfigToHclTerraform(struct?: GoogleGkeonpremBareMetalAdminClusterNetworkConfigOutputReference | GoogleGkeonpremBareMetalAdminClusterNetworkConfig): any;
export declare class GoogleGkeonpremBareMetalAdminClusterNetworkConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleGkeonpremBareMetalAdminClusterNetworkConfig | undefined;
    set internalValue(value: GoogleGkeonpremBareMetalAdminClusterNetworkConfig | undefined);
    private _islandModeCidr;
    get islandModeCidr(): GoogleGkeonpremBareMetalAdminClusterNetworkConfigIslandModeCidrOutputReference;
    putIslandModeCidr(value: GoogleGkeonpremBareMetalAdminClusterNetworkConfigIslandModeCidr): void;
    resetIslandModeCidr(): void;
    get islandModeCidrInput(): GoogleGkeonpremBareMetalAdminClusterNetworkConfigIslandModeCidr | undefined;
}
export interface GoogleGkeonpremBareMetalAdminClusterNodeAccessConfig {
    /**
    * LoginUser is the user name used to access node machines.
    * It defaults to "root" if not set.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gkeonprem_bare_metal_admin_cluster#login_user GoogleGkeonpremBareMetalAdminCluster#login_user}
    */
    readonly loginUser?: string;
}
export declare function googleGkeonpremBareMetalAdminClusterNodeAccessConfigToTerraform(struct?: GoogleGkeonpremBareMetalAdminClusterNodeAccessConfigOutputReference | GoogleGkeonpremBareMetalAdminClusterNodeAccessConfig): any;
export declare function googleGkeonpremBareMetalAdminClusterNodeAccessConfigToHclTerraform(struct?: GoogleGkeonpremBareMetalAdminClusterNodeAccessConfigOutputReference | GoogleGkeonpremBareMetalAdminClusterNodeAccessConfig): any;
export declare class GoogleGkeonpremBareMetalAdminClusterNodeAccessConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleGkeonpremBareMetalAdminClusterNodeAccessConfig | undefined;
    set internalValue(value: GoogleGkeonpremBareMetalAdminClusterNodeAccessConfig | undefined);
    private _loginUser?;
    get loginUser(): string;
    set loginUser(value: string);
    resetLoginUser(): void;
    get loginUserInput(): string | undefined;
}
export interface GoogleGkeonpremBareMetalAdminClusterNodeConfig {
    /**
    * The maximum number of pods a node can run. The size of the CIDR range
    * assigned to the node will be derived from this parameter.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gkeonprem_bare_metal_admin_cluster#max_pods_per_node GoogleGkeonpremBareMetalAdminCluster#max_pods_per_node}
    */
    readonly maxPodsPerNode?: number;
}
export declare function googleGkeonpremBareMetalAdminClusterNodeConfigToTerraform(struct?: GoogleGkeonpremBareMetalAdminClusterNodeConfigOutputReference | GoogleGkeonpremBareMetalAdminClusterNodeConfig): any;
export declare function googleGkeonpremBareMetalAdminClusterNodeConfigToHclTerraform(struct?: GoogleGkeonpremBareMetalAdminClusterNodeConfigOutputReference | GoogleGkeonpremBareMetalAdminClusterNodeConfig): any;
export declare class GoogleGkeonpremBareMetalAdminClusterNodeConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleGkeonpremBareMetalAdminClusterNodeConfig | undefined;
    set internalValue(value: GoogleGkeonpremBareMetalAdminClusterNodeConfig | undefined);
    private _maxPodsPerNode?;
    get maxPodsPerNode(): number;
    set maxPodsPerNode(value: number);
    resetMaxPodsPerNode(): void;
    get maxPodsPerNodeInput(): number | undefined;
}
export interface GoogleGkeonpremBareMetalAdminClusterProxy {
    /**
    * A list of IPs, hostnames, and domains that should skip the proxy.
    * Examples: ["127.0.0.1", "example.com", ".corp", "localhost"].
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gkeonprem_bare_metal_admin_cluster#no_proxy GoogleGkeonpremBareMetalAdminCluster#no_proxy}
    */
    readonly noProxy?: string[];
    /**
    * Specifies the address of your proxy server.
    * Examples: http://domain
    * WARNING: Do not provide credentials in the format
    * http://(username:password@)domain these will be rejected by the server.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gkeonprem_bare_metal_admin_cluster#uri GoogleGkeonpremBareMetalAdminCluster#uri}
    */
    readonly uri: string;
}
export declare function googleGkeonpremBareMetalAdminClusterProxyToTerraform(struct?: GoogleGkeonpremBareMetalAdminClusterProxyOutputReference | GoogleGkeonpremBareMetalAdminClusterProxy): any;
export declare function googleGkeonpremBareMetalAdminClusterProxyToHclTerraform(struct?: GoogleGkeonpremBareMetalAdminClusterProxyOutputReference | GoogleGkeonpremBareMetalAdminClusterProxy): any;
export declare class GoogleGkeonpremBareMetalAdminClusterProxyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleGkeonpremBareMetalAdminClusterProxy | undefined;
    set internalValue(value: GoogleGkeonpremBareMetalAdminClusterProxy | undefined);
    private _noProxy?;
    get noProxy(): string[];
    set noProxy(value: string[]);
    resetNoProxy(): void;
    get noProxyInput(): string[] | undefined;
    private _uri?;
    get uri(): string;
    set uri(value: string);
    get uriInput(): string | undefined;
}
export interface GoogleGkeonpremBareMetalAdminClusterSecurityConfigAuthorizationAdminUsers {
    /**
    * The name of the user, e.g. 'my-gcp-id@gmail.com'.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gkeonprem_bare_metal_admin_cluster#username GoogleGkeonpremBareMetalAdminCluster#username}
    */
    readonly username: string;
}
export declare function googleGkeonpremBareMetalAdminClusterSecurityConfigAuthorizationAdminUsersToTerraform(struct?: GoogleGkeonpremBareMetalAdminClusterSecurityConfigAuthorizationAdminUsers | cdktf.IResolvable): any;
export declare function googleGkeonpremBareMetalAdminClusterSecurityConfigAuthorizationAdminUsersToHclTerraform(struct?: GoogleGkeonpremBareMetalAdminClusterSecurityConfigAuthorizationAdminUsers | cdktf.IResolvable): any;
export declare class GoogleGkeonpremBareMetalAdminClusterSecurityConfigAuthorizationAdminUsersOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleGkeonpremBareMetalAdminClusterSecurityConfigAuthorizationAdminUsers | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleGkeonpremBareMetalAdminClusterSecurityConfigAuthorizationAdminUsers | cdktf.IResolvable | undefined);
    private _username?;
    get username(): string;
    set username(value: string);
    get usernameInput(): string | undefined;
}
export declare class GoogleGkeonpremBareMetalAdminClusterSecurityConfigAuthorizationAdminUsersList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleGkeonpremBareMetalAdminClusterSecurityConfigAuthorizationAdminUsers[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleGkeonpremBareMetalAdminClusterSecurityConfigAuthorizationAdminUsersOutputReference;
}
export interface GoogleGkeonpremBareMetalAdminClusterSecurityConfigAuthorization {
    /**
    * admin_users block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gkeonprem_bare_metal_admin_cluster#admin_users GoogleGkeonpremBareMetalAdminCluster#admin_users}
    */
    readonly adminUsers: GoogleGkeonpremBareMetalAdminClusterSecurityConfigAuthorizationAdminUsers[] | cdktf.IResolvable;
}
export declare function googleGkeonpremBareMetalAdminClusterSecurityConfigAuthorizationToTerraform(struct?: GoogleGkeonpremBareMetalAdminClusterSecurityConfigAuthorizationOutputReference | GoogleGkeonpremBareMetalAdminClusterSecurityConfigAuthorization): any;
export declare function googleGkeonpremBareMetalAdminClusterSecurityConfigAuthorizationToHclTerraform(struct?: GoogleGkeonpremBareMetalAdminClusterSecurityConfigAuthorizationOutputReference | GoogleGkeonpremBareMetalAdminClusterSecurityConfigAuthorization): any;
export declare class GoogleGkeonpremBareMetalAdminClusterSecurityConfigAuthorizationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleGkeonpremBareMetalAdminClusterSecurityConfigAuthorization | undefined;
    set internalValue(value: GoogleGkeonpremBareMetalAdminClusterSecurityConfigAuthorization | undefined);
    private _adminUsers;
    get adminUsers(): GoogleGkeonpremBareMetalAdminClusterSecurityConfigAuthorizationAdminUsersList;
    putAdminUsers(value: GoogleGkeonpremBareMetalAdminClusterSecurityConfigAuthorizationAdminUsers[] | cdktf.IResolvable): void;
    get adminUsersInput(): cdktf.IResolvable | GoogleGkeonpremBareMetalAdminClusterSecurityConfigAuthorizationAdminUsers[] | undefined;
}
export interface GoogleGkeonpremBareMetalAdminClusterSecurityConfig {
    /**
    * authorization block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gkeonprem_bare_metal_admin_cluster#authorization GoogleGkeonpremBareMetalAdminCluster#authorization}
    */
    readonly authorization?: GoogleGkeonpremBareMetalAdminClusterSecurityConfigAuthorization;
}
export declare function googleGkeonpremBareMetalAdminClusterSecurityConfigToTerraform(struct?: GoogleGkeonpremBareMetalAdminClusterSecurityConfigOutputReference | GoogleGkeonpremBareMetalAdminClusterSecurityConfig): any;
export declare function googleGkeonpremBareMetalAdminClusterSecurityConfigToHclTerraform(struct?: GoogleGkeonpremBareMetalAdminClusterSecurityConfigOutputReference | GoogleGkeonpremBareMetalAdminClusterSecurityConfig): any;
export declare class GoogleGkeonpremBareMetalAdminClusterSecurityConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleGkeonpremBareMetalAdminClusterSecurityConfig | undefined;
    set internalValue(value: GoogleGkeonpremBareMetalAdminClusterSecurityConfig | undefined);
    private _authorization;
    get authorization(): GoogleGkeonpremBareMetalAdminClusterSecurityConfigAuthorizationOutputReference;
    putAuthorization(value: GoogleGkeonpremBareMetalAdminClusterSecurityConfigAuthorization): void;
    resetAuthorization(): void;
    get authorizationInput(): GoogleGkeonpremBareMetalAdminClusterSecurityConfigAuthorization | undefined;
}
export interface GoogleGkeonpremBareMetalAdminClusterStorageLvpNodeMountsConfig {
    /**
    * The host machine path.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gkeonprem_bare_metal_admin_cluster#path GoogleGkeonpremBareMetalAdminCluster#path}
    */
    readonly path: string;
    /**
    * The StorageClass name that PVs will be created with.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gkeonprem_bare_metal_admin_cluster#storage_class GoogleGkeonpremBareMetalAdminCluster#storage_class}
    */
    readonly storageClass: string;
}
export declare function googleGkeonpremBareMetalAdminClusterStorageLvpNodeMountsConfigToTerraform(struct?: GoogleGkeonpremBareMetalAdminClusterStorageLvpNodeMountsConfigOutputReference | GoogleGkeonpremBareMetalAdminClusterStorageLvpNodeMountsConfig): any;
export declare function googleGkeonpremBareMetalAdminClusterStorageLvpNodeMountsConfigToHclTerraform(struct?: GoogleGkeonpremBareMetalAdminClusterStorageLvpNodeMountsConfigOutputReference | GoogleGkeonpremBareMetalAdminClusterStorageLvpNodeMountsConfig): any;
export declare class GoogleGkeonpremBareMetalAdminClusterStorageLvpNodeMountsConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleGkeonpremBareMetalAdminClusterStorageLvpNodeMountsConfig | undefined;
    set internalValue(value: GoogleGkeonpremBareMetalAdminClusterStorageLvpNodeMountsConfig | undefined);
    private _path?;
    get path(): string;
    set path(value: string);
    get pathInput(): string | undefined;
    private _storageClass?;
    get storageClass(): string;
    set storageClass(value: string);
    get storageClassInput(): string | undefined;
}
export interface GoogleGkeonpremBareMetalAdminClusterStorageLvpShareConfigLvpConfig {
    /**
    * The host machine path.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gkeonprem_bare_metal_admin_cluster#path GoogleGkeonpremBareMetalAdminCluster#path}
    */
    readonly path: string;
    /**
    * The StorageClass name that PVs will be created with.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gkeonprem_bare_metal_admin_cluster#storage_class GoogleGkeonpremBareMetalAdminCluster#storage_class}
    */
    readonly storageClass: string;
}
export declare function googleGkeonpremBareMetalAdminClusterStorageLvpShareConfigLvpConfigToTerraform(struct?: GoogleGkeonpremBareMetalAdminClusterStorageLvpShareConfigLvpConfigOutputReference | GoogleGkeonpremBareMetalAdminClusterStorageLvpShareConfigLvpConfig): any;
export declare function googleGkeonpremBareMetalAdminClusterStorageLvpShareConfigLvpConfigToHclTerraform(struct?: GoogleGkeonpremBareMetalAdminClusterStorageLvpShareConfigLvpConfigOutputReference | GoogleGkeonpremBareMetalAdminClusterStorageLvpShareConfigLvpConfig): any;
export declare class GoogleGkeonpremBareMetalAdminClusterStorageLvpShareConfigLvpConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleGkeonpremBareMetalAdminClusterStorageLvpShareConfigLvpConfig | undefined;
    set internalValue(value: GoogleGkeonpremBareMetalAdminClusterStorageLvpShareConfigLvpConfig | undefined);
    private _path?;
    get path(): string;
    set path(value: string);
    get pathInput(): string | undefined;
    private _storageClass?;
    get storageClass(): string;
    set storageClass(value: string);
    get storageClassInput(): string | undefined;
}
export interface GoogleGkeonpremBareMetalAdminClusterStorageLvpShareConfig {
    /**
    * The number of subdirectories to create under path.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gkeonprem_bare_metal_admin_cluster#shared_path_pv_count GoogleGkeonpremBareMetalAdminCluster#shared_path_pv_count}
    */
    readonly sharedPathPvCount?: number;
    /**
    * lvp_config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gkeonprem_bare_metal_admin_cluster#lvp_config GoogleGkeonpremBareMetalAdminCluster#lvp_config}
    */
    readonly lvpConfig: GoogleGkeonpremBareMetalAdminClusterStorageLvpShareConfigLvpConfig;
}
export declare function googleGkeonpremBareMetalAdminClusterStorageLvpShareConfigToTerraform(struct?: GoogleGkeonpremBareMetalAdminClusterStorageLvpShareConfigOutputReference | GoogleGkeonpremBareMetalAdminClusterStorageLvpShareConfig): any;
export declare function googleGkeonpremBareMetalAdminClusterStorageLvpShareConfigToHclTerraform(struct?: GoogleGkeonpremBareMetalAdminClusterStorageLvpShareConfigOutputReference | GoogleGkeonpremBareMetalAdminClusterStorageLvpShareConfig): any;
export declare class GoogleGkeonpremBareMetalAdminClusterStorageLvpShareConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleGkeonpremBareMetalAdminClusterStorageLvpShareConfig | undefined;
    set internalValue(value: GoogleGkeonpremBareMetalAdminClusterStorageLvpShareConfig | undefined);
    private _sharedPathPvCount?;
    get sharedPathPvCount(): number;
    set sharedPathPvCount(value: number);
    resetSharedPathPvCount(): void;
    get sharedPathPvCountInput(): number | undefined;
    private _lvpConfig;
    get lvpConfig(): GoogleGkeonpremBareMetalAdminClusterStorageLvpShareConfigLvpConfigOutputReference;
    putLvpConfig(value: GoogleGkeonpremBareMetalAdminClusterStorageLvpShareConfigLvpConfig): void;
    get lvpConfigInput(): GoogleGkeonpremBareMetalAdminClusterStorageLvpShareConfigLvpConfig | undefined;
}
export interface GoogleGkeonpremBareMetalAdminClusterStorage {
    /**
    * lvp_node_mounts_config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gkeonprem_bare_metal_admin_cluster#lvp_node_mounts_config GoogleGkeonpremBareMetalAdminCluster#lvp_node_mounts_config}
    */
    readonly lvpNodeMountsConfig: GoogleGkeonpremBareMetalAdminClusterStorageLvpNodeMountsConfig;
    /**
    * lvp_share_config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gkeonprem_bare_metal_admin_cluster#lvp_share_config GoogleGkeonpremBareMetalAdminCluster#lvp_share_config}
    */
    readonly lvpShareConfig: GoogleGkeonpremBareMetalAdminClusterStorageLvpShareConfig;
}
export declare function googleGkeonpremBareMetalAdminClusterStorageToTerraform(struct?: GoogleGkeonpremBareMetalAdminClusterStorageOutputReference | GoogleGkeonpremBareMetalAdminClusterStorage): any;
export declare function googleGkeonpremBareMetalAdminClusterStorageToHclTerraform(struct?: GoogleGkeonpremBareMetalAdminClusterStorageOutputReference | GoogleGkeonpremBareMetalAdminClusterStorage): any;
export declare class GoogleGkeonpremBareMetalAdminClusterStorageOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleGkeonpremBareMetalAdminClusterStorage | undefined;
    set internalValue(value: GoogleGkeonpremBareMetalAdminClusterStorage | undefined);
    private _lvpNodeMountsConfig;
    get lvpNodeMountsConfig(): GoogleGkeonpremBareMetalAdminClusterStorageLvpNodeMountsConfigOutputReference;
    putLvpNodeMountsConfig(value: GoogleGkeonpremBareMetalAdminClusterStorageLvpNodeMountsConfig): void;
    get lvpNodeMountsConfigInput(): GoogleGkeonpremBareMetalAdminClusterStorageLvpNodeMountsConfig | undefined;
    private _lvpShareConfig;
    get lvpShareConfig(): GoogleGkeonpremBareMetalAdminClusterStorageLvpShareConfigOutputReference;
    putLvpShareConfig(value: GoogleGkeonpremBareMetalAdminClusterStorageLvpShareConfig): void;
    get lvpShareConfigInput(): GoogleGkeonpremBareMetalAdminClusterStorageLvpShareConfig | undefined;
}
export interface GoogleGkeonpremBareMetalAdminClusterTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gkeonprem_bare_metal_admin_cluster#create GoogleGkeonpremBareMetalAdminCluster#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gkeonprem_bare_metal_admin_cluster#delete GoogleGkeonpremBareMetalAdminCluster#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gkeonprem_bare_metal_admin_cluster#update GoogleGkeonpremBareMetalAdminCluster#update}
    */
    readonly update?: string;
}
export declare function googleGkeonpremBareMetalAdminClusterTimeoutsToTerraform(struct?: GoogleGkeonpremBareMetalAdminClusterTimeouts | cdktf.IResolvable): any;
export declare function googleGkeonpremBareMetalAdminClusterTimeoutsToHclTerraform(struct?: GoogleGkeonpremBareMetalAdminClusterTimeouts | cdktf.IResolvable): any;
export declare class GoogleGkeonpremBareMetalAdminClusterTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleGkeonpremBareMetalAdminClusterTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleGkeonpremBareMetalAdminClusterTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gkeonprem_bare_metal_admin_cluster google_gkeonprem_bare_metal_admin_cluster}
*/
export declare class GoogleGkeonpremBareMetalAdminCluster extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_gkeonprem_bare_metal_admin_cluster";
    /**
    * Generates CDKTF code for importing a GoogleGkeonpremBareMetalAdminCluster resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the GoogleGkeonpremBareMetalAdminCluster to import
    * @param importFromId The id of the existing GoogleGkeonpremBareMetalAdminCluster that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gkeonprem_bare_metal_admin_cluster#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the GoogleGkeonpremBareMetalAdminCluster to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gkeonprem_bare_metal_admin_cluster google_gkeonprem_bare_metal_admin_cluster} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleGkeonpremBareMetalAdminClusterConfig
    */
    constructor(scope: Construct, id: string, config: GoogleGkeonpremBareMetalAdminClusterConfig);
    private _annotations?;
    get annotations(): {
        [key: string]: string;
    };
    set annotations(value: {
        [key: string]: string;
    });
    resetAnnotations(): void;
    get annotationsInput(): {
        [key: string]: string;
    } | undefined;
    private _bareMetalVersion?;
    get bareMetalVersion(): string;
    set bareMetalVersion(value: string);
    resetBareMetalVersion(): void;
    get bareMetalVersionInput(): string | undefined;
    get createTime(): string;
    get deleteTime(): string;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _effectiveAnnotations;
    get effectiveAnnotations(): cdktf.StringMap;
    get endpoint(): string;
    get etag(): string;
    private _fleet;
    get fleet(): GoogleGkeonpremBareMetalAdminClusterFleetList;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get localName(): string;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    get reconciling(): cdktf.IResolvable;
    get state(): string;
    private _status;
    get status(): GoogleGkeonpremBareMetalAdminClusterStatusList;
    get uid(): string;
    get updateTime(): string;
    private _validationCheck;
    get validationCheck(): GoogleGkeonpremBareMetalAdminClusterValidationCheckList;
    private _clusterOperations;
    get clusterOperations(): GoogleGkeonpremBareMetalAdminClusterClusterOperationsOutputReference;
    putClusterOperations(value: GoogleGkeonpremBareMetalAdminClusterClusterOperations): void;
    resetClusterOperations(): void;
    get clusterOperationsInput(): GoogleGkeonpremBareMetalAdminClusterClusterOperations | undefined;
    private _controlPlane;
    get controlPlane(): GoogleGkeonpremBareMetalAdminClusterControlPlaneOutputReference;
    putControlPlane(value: GoogleGkeonpremBareMetalAdminClusterControlPlane): void;
    resetControlPlane(): void;
    get controlPlaneInput(): GoogleGkeonpremBareMetalAdminClusterControlPlane | undefined;
    private _loadBalancer;
    get loadBalancer(): GoogleGkeonpremBareMetalAdminClusterLoadBalancerOutputReference;
    putLoadBalancer(value: GoogleGkeonpremBareMetalAdminClusterLoadBalancer): void;
    resetLoadBalancer(): void;
    get loadBalancerInput(): GoogleGkeonpremBareMetalAdminClusterLoadBalancer | undefined;
    private _maintenanceConfig;
    get maintenanceConfig(): GoogleGkeonpremBareMetalAdminClusterMaintenanceConfigOutputReference;
    putMaintenanceConfig(value: GoogleGkeonpremBareMetalAdminClusterMaintenanceConfig): void;
    resetMaintenanceConfig(): void;
    get maintenanceConfigInput(): GoogleGkeonpremBareMetalAdminClusterMaintenanceConfig | undefined;
    private _networkConfig;
    get networkConfig(): GoogleGkeonpremBareMetalAdminClusterNetworkConfigOutputReference;
    putNetworkConfig(value: GoogleGkeonpremBareMetalAdminClusterNetworkConfig): void;
    resetNetworkConfig(): void;
    get networkConfigInput(): GoogleGkeonpremBareMetalAdminClusterNetworkConfig | undefined;
    private _nodeAccessConfig;
    get nodeAccessConfig(): GoogleGkeonpremBareMetalAdminClusterNodeAccessConfigOutputReference;
    putNodeAccessConfig(value: GoogleGkeonpremBareMetalAdminClusterNodeAccessConfig): void;
    resetNodeAccessConfig(): void;
    get nodeAccessConfigInput(): GoogleGkeonpremBareMetalAdminClusterNodeAccessConfig | undefined;
    private _nodeConfig;
    get nodeConfig(): GoogleGkeonpremBareMetalAdminClusterNodeConfigOutputReference;
    putNodeConfig(value: GoogleGkeonpremBareMetalAdminClusterNodeConfig): void;
    resetNodeConfig(): void;
    get nodeConfigInput(): GoogleGkeonpremBareMetalAdminClusterNodeConfig | undefined;
    private _proxy;
    get proxy(): GoogleGkeonpremBareMetalAdminClusterProxyOutputReference;
    putProxy(value: GoogleGkeonpremBareMetalAdminClusterProxy): void;
    resetProxy(): void;
    get proxyInput(): GoogleGkeonpremBareMetalAdminClusterProxy | undefined;
    private _securityConfig;
    get securityConfig(): GoogleGkeonpremBareMetalAdminClusterSecurityConfigOutputReference;
    putSecurityConfig(value: GoogleGkeonpremBareMetalAdminClusterSecurityConfig): void;
    resetSecurityConfig(): void;
    get securityConfigInput(): GoogleGkeonpremBareMetalAdminClusterSecurityConfig | undefined;
    private _storage;
    get storage(): GoogleGkeonpremBareMetalAdminClusterStorageOutputReference;
    putStorage(value: GoogleGkeonpremBareMetalAdminClusterStorage): void;
    resetStorage(): void;
    get storageInput(): GoogleGkeonpremBareMetalAdminClusterStorage | undefined;
    private _timeouts;
    get timeouts(): GoogleGkeonpremBareMetalAdminClusterTimeoutsOutputReference;
    putTimeouts(value: GoogleGkeonpremBareMetalAdminClusterTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleGkeonpremBareMetalAdminClusterTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
