/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleGkeonpremBareMetalClusterConfig extends cdktf.TerraformMetaArguments {
    /**
    * The Admin Cluster this Bare Metal User Cluster belongs to.
    * This is the full resource name of the Admin Cluster's hub membership.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gkeonprem_bare_metal_cluster#admin_cluster_membership GoogleGkeonpremBareMetalCluster#admin_cluster_membership}
    */
    readonly adminClusterMembership: string;
    /**
    * Annotations on the Bare Metal User Cluster.
    * This field has the same restrictions as Kubernetes annotations.
    * The total size of all keys and values combined is limited to 256k.
    * Key can have 2 segments: prefix (optional) and name (required),
    * separated by a slash (/).
    * Prefix must be a DNS subdomain.
    * Name must be 63 characters or less, begin and end with alphanumerics,
    * with dashes (-), underscores (_), dots (.), and alphanumerics between.
    *
    *
    * **Note**: This field is non-authoritative, and will only manage the annotations present in your configuration.
    * Please refer to the field 'effective_annotations' for all of the annotations present on the resource.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gkeonprem_bare_metal_cluster#annotations GoogleGkeonpremBareMetalCluster#annotations}
    */
    readonly annotations?: {
        [key: string]: string;
    };
    /**
    * A human readable description of this Bare Metal User Cluster.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gkeonprem_bare_metal_cluster#bare_metal_version GoogleGkeonpremBareMetalCluster#bare_metal_version}
    */
    readonly bareMetalVersion: string;
    /**
    * A human readable description of this Bare Metal User Cluster.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gkeonprem_bare_metal_cluster#description GoogleGkeonpremBareMetalCluster#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gkeonprem_bare_metal_cluster#id GoogleGkeonpremBareMetalCluster#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The location of the resource.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gkeonprem_bare_metal_cluster#location GoogleGkeonpremBareMetalCluster#location}
    */
    readonly location: string;
    /**
    * The bare metal cluster name.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gkeonprem_bare_metal_cluster#name GoogleGkeonpremBareMetalCluster#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gkeonprem_bare_metal_cluster#project GoogleGkeonpremBareMetalCluster#project}
    */
    readonly project?: string;
    /**
    * binary_authorization block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gkeonprem_bare_metal_cluster#binary_authorization GoogleGkeonpremBareMetalCluster#binary_authorization}
    */
    readonly binaryAuthorization?: GoogleGkeonpremBareMetalClusterBinaryAuthorization;
    /**
    * cluster_operations block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gkeonprem_bare_metal_cluster#cluster_operations GoogleGkeonpremBareMetalCluster#cluster_operations}
    */
    readonly clusterOperations?: GoogleGkeonpremBareMetalClusterClusterOperations;
    /**
    * control_plane block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gkeonprem_bare_metal_cluster#control_plane GoogleGkeonpremBareMetalCluster#control_plane}
    */
    readonly controlPlane: GoogleGkeonpremBareMetalClusterControlPlane;
    /**
    * load_balancer block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gkeonprem_bare_metal_cluster#load_balancer GoogleGkeonpremBareMetalCluster#load_balancer}
    */
    readonly loadBalancer: GoogleGkeonpremBareMetalClusterLoadBalancer;
    /**
    * maintenance_config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gkeonprem_bare_metal_cluster#maintenance_config GoogleGkeonpremBareMetalCluster#maintenance_config}
    */
    readonly maintenanceConfig?: GoogleGkeonpremBareMetalClusterMaintenanceConfig;
    /**
    * network_config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gkeonprem_bare_metal_cluster#network_config GoogleGkeonpremBareMetalCluster#network_config}
    */
    readonly networkConfig: GoogleGkeonpremBareMetalClusterNetworkConfig;
    /**
    * node_access_config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gkeonprem_bare_metal_cluster#node_access_config GoogleGkeonpremBareMetalCluster#node_access_config}
    */
    readonly nodeAccessConfig?: GoogleGkeonpremBareMetalClusterNodeAccessConfig;
    /**
    * node_config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gkeonprem_bare_metal_cluster#node_config GoogleGkeonpremBareMetalCluster#node_config}
    */
    readonly nodeConfig?: GoogleGkeonpremBareMetalClusterNodeConfig;
    /**
    * os_environment_config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gkeonprem_bare_metal_cluster#os_environment_config GoogleGkeonpremBareMetalCluster#os_environment_config}
    */
    readonly osEnvironmentConfig?: GoogleGkeonpremBareMetalClusterOsEnvironmentConfig;
    /**
    * proxy block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gkeonprem_bare_metal_cluster#proxy GoogleGkeonpremBareMetalCluster#proxy}
    */
    readonly proxy?: GoogleGkeonpremBareMetalClusterProxy;
    /**
    * security_config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gkeonprem_bare_metal_cluster#security_config GoogleGkeonpremBareMetalCluster#security_config}
    */
    readonly securityConfig?: GoogleGkeonpremBareMetalClusterSecurityConfig;
    /**
    * storage block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gkeonprem_bare_metal_cluster#storage GoogleGkeonpremBareMetalCluster#storage}
    */
    readonly storage: GoogleGkeonpremBareMetalClusterStorage;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gkeonprem_bare_metal_cluster#timeouts GoogleGkeonpremBareMetalCluster#timeouts}
    */
    readonly timeouts?: GoogleGkeonpremBareMetalClusterTimeouts;
    /**
    * upgrade_policy block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gkeonprem_bare_metal_cluster#upgrade_policy GoogleGkeonpremBareMetalCluster#upgrade_policy}
    */
    readonly upgradePolicy?: GoogleGkeonpremBareMetalClusterUpgradePolicy;
}
export interface GoogleGkeonpremBareMetalClusterFleet {
}
export declare function googleGkeonpremBareMetalClusterFleetToTerraform(struct?: GoogleGkeonpremBareMetalClusterFleet): any;
export declare function googleGkeonpremBareMetalClusterFleetToHclTerraform(struct?: GoogleGkeonpremBareMetalClusterFleet): any;
export declare class GoogleGkeonpremBareMetalClusterFleetOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleGkeonpremBareMetalClusterFleet | undefined;
    set internalValue(value: GoogleGkeonpremBareMetalClusterFleet | undefined);
    get membership(): string;
}
export declare class GoogleGkeonpremBareMetalClusterFleetList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleGkeonpremBareMetalClusterFleetOutputReference;
}
export interface GoogleGkeonpremBareMetalClusterStatusConditions {
}
export declare function googleGkeonpremBareMetalClusterStatusConditionsToTerraform(struct?: GoogleGkeonpremBareMetalClusterStatusConditions): any;
export declare function googleGkeonpremBareMetalClusterStatusConditionsToHclTerraform(struct?: GoogleGkeonpremBareMetalClusterStatusConditions): any;
export declare class GoogleGkeonpremBareMetalClusterStatusConditionsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleGkeonpremBareMetalClusterStatusConditions | undefined;
    set internalValue(value: GoogleGkeonpremBareMetalClusterStatusConditions | undefined);
    get lastTransitionTime(): string;
    get message(): string;
    get reason(): string;
    get state(): string;
    get type(): string;
}
export declare class GoogleGkeonpremBareMetalClusterStatusConditionsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleGkeonpremBareMetalClusterStatusConditionsOutputReference;
}
export interface GoogleGkeonpremBareMetalClusterStatus {
}
export declare function googleGkeonpremBareMetalClusterStatusToTerraform(struct?: GoogleGkeonpremBareMetalClusterStatus): any;
export declare function googleGkeonpremBareMetalClusterStatusToHclTerraform(struct?: GoogleGkeonpremBareMetalClusterStatus): any;
export declare class GoogleGkeonpremBareMetalClusterStatusOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleGkeonpremBareMetalClusterStatus | undefined;
    set internalValue(value: GoogleGkeonpremBareMetalClusterStatus | undefined);
    private _conditions;
    get conditions(): GoogleGkeonpremBareMetalClusterStatusConditionsList;
    get errorMessage(): string;
}
export declare class GoogleGkeonpremBareMetalClusterStatusList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleGkeonpremBareMetalClusterStatusOutputReference;
}
export interface GoogleGkeonpremBareMetalClusterValidationCheckStatusResult {
}
export declare function googleGkeonpremBareMetalClusterValidationCheckStatusResultToTerraform(struct?: GoogleGkeonpremBareMetalClusterValidationCheckStatusResult): any;
export declare function googleGkeonpremBareMetalClusterValidationCheckStatusResultToHclTerraform(struct?: GoogleGkeonpremBareMetalClusterValidationCheckStatusResult): any;
export declare class GoogleGkeonpremBareMetalClusterValidationCheckStatusResultOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleGkeonpremBareMetalClusterValidationCheckStatusResult | undefined;
    set internalValue(value: GoogleGkeonpremBareMetalClusterValidationCheckStatusResult | undefined);
    get category(): string;
    get description(): string;
    get details(): string;
    get options(): string;
    get reason(): string;
}
export declare class GoogleGkeonpremBareMetalClusterValidationCheckStatusResultList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleGkeonpremBareMetalClusterValidationCheckStatusResultOutputReference;
}
export interface GoogleGkeonpremBareMetalClusterValidationCheckStatus {
}
export declare function googleGkeonpremBareMetalClusterValidationCheckStatusToTerraform(struct?: GoogleGkeonpremBareMetalClusterValidationCheckStatus): any;
export declare function googleGkeonpremBareMetalClusterValidationCheckStatusToHclTerraform(struct?: GoogleGkeonpremBareMetalClusterValidationCheckStatus): any;
export declare class GoogleGkeonpremBareMetalClusterValidationCheckStatusOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleGkeonpremBareMetalClusterValidationCheckStatus | undefined;
    set internalValue(value: GoogleGkeonpremBareMetalClusterValidationCheckStatus | undefined);
    private _result;
    get result(): GoogleGkeonpremBareMetalClusterValidationCheckStatusResultList;
}
export declare class GoogleGkeonpremBareMetalClusterValidationCheckStatusList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleGkeonpremBareMetalClusterValidationCheckStatusOutputReference;
}
export interface GoogleGkeonpremBareMetalClusterValidationCheck {
}
export declare function googleGkeonpremBareMetalClusterValidationCheckToTerraform(struct?: GoogleGkeonpremBareMetalClusterValidationCheck): any;
export declare function googleGkeonpremBareMetalClusterValidationCheckToHclTerraform(struct?: GoogleGkeonpremBareMetalClusterValidationCheck): any;
export declare class GoogleGkeonpremBareMetalClusterValidationCheckOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleGkeonpremBareMetalClusterValidationCheck | undefined;
    set internalValue(value: GoogleGkeonpremBareMetalClusterValidationCheck | undefined);
    get options(): string;
    get scenario(): string;
    private _status;
    get status(): GoogleGkeonpremBareMetalClusterValidationCheckStatusList;
}
export declare class GoogleGkeonpremBareMetalClusterValidationCheckList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleGkeonpremBareMetalClusterValidationCheckOutputReference;
}
export interface GoogleGkeonpremBareMetalClusterBinaryAuthorization {
    /**
    * Mode of operation for binauthz policy evaluation. If unspecified,
    * defaults to DISABLED. Possible values: ["DISABLED", "PROJECT_SINGLETON_POLICY_ENFORCE"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gkeonprem_bare_metal_cluster#evaluation_mode GoogleGkeonpremBareMetalCluster#evaluation_mode}
    */
    readonly evaluationMode?: string;
}
export declare function googleGkeonpremBareMetalClusterBinaryAuthorizationToTerraform(struct?: GoogleGkeonpremBareMetalClusterBinaryAuthorizationOutputReference | GoogleGkeonpremBareMetalClusterBinaryAuthorization): any;
export declare function googleGkeonpremBareMetalClusterBinaryAuthorizationToHclTerraform(struct?: GoogleGkeonpremBareMetalClusterBinaryAuthorizationOutputReference | GoogleGkeonpremBareMetalClusterBinaryAuthorization): any;
export declare class GoogleGkeonpremBareMetalClusterBinaryAuthorizationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleGkeonpremBareMetalClusterBinaryAuthorization | undefined;
    set internalValue(value: GoogleGkeonpremBareMetalClusterBinaryAuthorization | undefined);
    private _evaluationMode?;
    get evaluationMode(): string;
    set evaluationMode(value: string);
    resetEvaluationMode(): void;
    get evaluationModeInput(): string | undefined;
}
export interface GoogleGkeonpremBareMetalClusterClusterOperations {
    /**
    * Whether collection of application logs/metrics should be enabled (in addition to system logs/metrics).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gkeonprem_bare_metal_cluster#enable_application_logs GoogleGkeonpremBareMetalCluster#enable_application_logs}
    */
    readonly enableApplicationLogs?: boolean | cdktf.IResolvable;
}
export declare function googleGkeonpremBareMetalClusterClusterOperationsToTerraform(struct?: GoogleGkeonpremBareMetalClusterClusterOperationsOutputReference | GoogleGkeonpremBareMetalClusterClusterOperations): any;
export declare function googleGkeonpremBareMetalClusterClusterOperationsToHclTerraform(struct?: GoogleGkeonpremBareMetalClusterClusterOperationsOutputReference | GoogleGkeonpremBareMetalClusterClusterOperations): any;
export declare class GoogleGkeonpremBareMetalClusterClusterOperationsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleGkeonpremBareMetalClusterClusterOperations | undefined;
    set internalValue(value: GoogleGkeonpremBareMetalClusterClusterOperations | undefined);
    private _enableApplicationLogs?;
    get enableApplicationLogs(): boolean | cdktf.IResolvable;
    set enableApplicationLogs(value: boolean | cdktf.IResolvable);
    resetEnableApplicationLogs(): void;
    get enableApplicationLogsInput(): boolean | cdktf.IResolvable | undefined;
}
export interface GoogleGkeonpremBareMetalClusterControlPlaneApiServerArgs {
    /**
    * The argument name as it appears on the API Server command line please make sure to remove the leading dashes.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gkeonprem_bare_metal_cluster#argument GoogleGkeonpremBareMetalCluster#argument}
    */
    readonly argument: string;
    /**
    * The value of the arg as it will be passed to the API Server command line.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gkeonprem_bare_metal_cluster#value GoogleGkeonpremBareMetalCluster#value}
    */
    readonly value: string;
}
export declare function googleGkeonpremBareMetalClusterControlPlaneApiServerArgsToTerraform(struct?: GoogleGkeonpremBareMetalClusterControlPlaneApiServerArgs | cdktf.IResolvable): any;
export declare function googleGkeonpremBareMetalClusterControlPlaneApiServerArgsToHclTerraform(struct?: GoogleGkeonpremBareMetalClusterControlPlaneApiServerArgs | cdktf.IResolvable): any;
export declare class GoogleGkeonpremBareMetalClusterControlPlaneApiServerArgsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleGkeonpremBareMetalClusterControlPlaneApiServerArgs | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleGkeonpremBareMetalClusterControlPlaneApiServerArgs | cdktf.IResolvable | undefined);
    private _argument?;
    get argument(): string;
    set argument(value: string);
    get argumentInput(): string | undefined;
    private _value?;
    get value(): string;
    set value(value: string);
    get valueInput(): string | undefined;
}
export declare class GoogleGkeonpremBareMetalClusterControlPlaneApiServerArgsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleGkeonpremBareMetalClusterControlPlaneApiServerArgs[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleGkeonpremBareMetalClusterControlPlaneApiServerArgsOutputReference;
}
export interface GoogleGkeonpremBareMetalClusterControlPlaneControlPlaneNodePoolConfigNodePoolConfigNodeConfigs {
    /**
    * The map of Kubernetes labels (key/value pairs) to be applied to
    * each node. These will added in addition to any default label(s)
    * that Kubernetes may apply to the node. In case of conflict in
    * label keys, the applied set may differ depending on the Kubernetes
    * version -- it's best to assume the behavior is undefined and
    * conflicts should be avoided. For more information, including usage
    * and the valid values, see:
    *   http://kubernetes.io/v1.1/docs/user-guide/labels.html
    * An object containing a list of "key": value pairs.
    * Example: { "name": "wrench", "mass": "1.3kg", "count": "3" }.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gkeonprem_bare_metal_cluster#labels GoogleGkeonpremBareMetalCluster#labels}
    */
    readonly labels?: {
        [key: string]: string;
    };
    /**
    * The default IPv4 address for SSH access and Kubernetes node.
    * Example: 192.168.0.1
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gkeonprem_bare_metal_cluster#node_ip GoogleGkeonpremBareMetalCluster#node_ip}
    */
    readonly nodeIp?: string;
}
export declare function googleGkeonpremBareMetalClusterControlPlaneControlPlaneNodePoolConfigNodePoolConfigNodeConfigsToTerraform(struct?: GoogleGkeonpremBareMetalClusterControlPlaneControlPlaneNodePoolConfigNodePoolConfigNodeConfigs | cdktf.IResolvable): any;
export declare function googleGkeonpremBareMetalClusterControlPlaneControlPlaneNodePoolConfigNodePoolConfigNodeConfigsToHclTerraform(struct?: GoogleGkeonpremBareMetalClusterControlPlaneControlPlaneNodePoolConfigNodePoolConfigNodeConfigs | cdktf.IResolvable): any;
export declare class GoogleGkeonpremBareMetalClusterControlPlaneControlPlaneNodePoolConfigNodePoolConfigNodeConfigsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleGkeonpremBareMetalClusterControlPlaneControlPlaneNodePoolConfigNodePoolConfigNodeConfigs | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleGkeonpremBareMetalClusterControlPlaneControlPlaneNodePoolConfigNodePoolConfigNodeConfigs | cdktf.IResolvable | undefined);
    private _labels?;
    get labels(): {
        [key: string]: string;
    };
    set labels(value: {
        [key: string]: string;
    });
    resetLabels(): void;
    get labelsInput(): {
        [key: string]: string;
    } | undefined;
    private _nodeIp?;
    get nodeIp(): string;
    set nodeIp(value: string);
    resetNodeIp(): void;
    get nodeIpInput(): string | undefined;
}
export declare class GoogleGkeonpremBareMetalClusterControlPlaneControlPlaneNodePoolConfigNodePoolConfigNodeConfigsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleGkeonpremBareMetalClusterControlPlaneControlPlaneNodePoolConfigNodePoolConfigNodeConfigs[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleGkeonpremBareMetalClusterControlPlaneControlPlaneNodePoolConfigNodePoolConfigNodeConfigsOutputReference;
}
export interface GoogleGkeonpremBareMetalClusterControlPlaneControlPlaneNodePoolConfigNodePoolConfigTaints {
    /**
    * Specifies the nodes operating system (default: LINUX). Possible values: ["EFFECT_UNSPECIFIED", "PREFER_NO_SCHEDULE", "NO_EXECUTE"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gkeonprem_bare_metal_cluster#effect GoogleGkeonpremBareMetalCluster#effect}
    */
    readonly effect?: string;
    /**
    * Key associated with the effect.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gkeonprem_bare_metal_cluster#key GoogleGkeonpremBareMetalCluster#key}
    */
    readonly key?: string;
    /**
    * Value associated with the effect.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gkeonprem_bare_metal_cluster#value GoogleGkeonpremBareMetalCluster#value}
    */
    readonly value?: string;
}
export declare function googleGkeonpremBareMetalClusterControlPlaneControlPlaneNodePoolConfigNodePoolConfigTaintsToTerraform(struct?: GoogleGkeonpremBareMetalClusterControlPlaneControlPlaneNodePoolConfigNodePoolConfigTaints | cdktf.IResolvable): any;
export declare function googleGkeonpremBareMetalClusterControlPlaneControlPlaneNodePoolConfigNodePoolConfigTaintsToHclTerraform(struct?: GoogleGkeonpremBareMetalClusterControlPlaneControlPlaneNodePoolConfigNodePoolConfigTaints | cdktf.IResolvable): any;
export declare class GoogleGkeonpremBareMetalClusterControlPlaneControlPlaneNodePoolConfigNodePoolConfigTaintsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleGkeonpremBareMetalClusterControlPlaneControlPlaneNodePoolConfigNodePoolConfigTaints | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleGkeonpremBareMetalClusterControlPlaneControlPlaneNodePoolConfigNodePoolConfigTaints | cdktf.IResolvable | undefined);
    private _effect?;
    get effect(): string;
    set effect(value: string);
    resetEffect(): void;
    get effectInput(): string | undefined;
    private _key?;
    get key(): string;
    set key(value: string);
    resetKey(): void;
    get keyInput(): string | undefined;
    private _value?;
    get value(): string;
    set value(value: string);
    resetValue(): void;
    get valueInput(): string | undefined;
}
export declare class GoogleGkeonpremBareMetalClusterControlPlaneControlPlaneNodePoolConfigNodePoolConfigTaintsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleGkeonpremBareMetalClusterControlPlaneControlPlaneNodePoolConfigNodePoolConfigTaints[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleGkeonpremBareMetalClusterControlPlaneControlPlaneNodePoolConfigNodePoolConfigTaintsOutputReference;
}
export interface GoogleGkeonpremBareMetalClusterControlPlaneControlPlaneNodePoolConfigNodePoolConfig {
    /**
    * The map of Kubernetes labels (key/value pairs) to be applied to
    * each node. These will added in addition to any default label(s)
    * that Kubernetes may apply to the node. In case of conflict in
    * label keys, the applied set may differ depending on the Kubernetes
    * version -- it's best to assume the behavior is undefined and
    * conflicts should be avoided. For more information, including usage
    * and the valid values, see:
    *   http://kubernetes.io/v1.1/docs/user-guide/labels.html
    * An object containing a list of "key": value pairs.
    * Example: { "name": "wrench", "mass": "1.3kg", "count": "3" }.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gkeonprem_bare_metal_cluster#labels GoogleGkeonpremBareMetalCluster#labels}
    */
    readonly labels?: {
        [key: string]: string;
    };
    /**
    * Specifies the nodes operating system (default: LINUX).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gkeonprem_bare_metal_cluster#operating_system GoogleGkeonpremBareMetalCluster#operating_system}
    */
    readonly operatingSystem?: string;
    /**
    * node_configs block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gkeonprem_bare_metal_cluster#node_configs GoogleGkeonpremBareMetalCluster#node_configs}
    */
    readonly nodeConfigs?: GoogleGkeonpremBareMetalClusterControlPlaneControlPlaneNodePoolConfigNodePoolConfigNodeConfigs[] | cdktf.IResolvable;
    /**
    * taints block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gkeonprem_bare_metal_cluster#taints GoogleGkeonpremBareMetalCluster#taints}
    */
    readonly taints?: GoogleGkeonpremBareMetalClusterControlPlaneControlPlaneNodePoolConfigNodePoolConfigTaints[] | cdktf.IResolvable;
}
export declare function googleGkeonpremBareMetalClusterControlPlaneControlPlaneNodePoolConfigNodePoolConfigToTerraform(struct?: GoogleGkeonpremBareMetalClusterControlPlaneControlPlaneNodePoolConfigNodePoolConfigOutputReference | GoogleGkeonpremBareMetalClusterControlPlaneControlPlaneNodePoolConfigNodePoolConfig): any;
export declare function googleGkeonpremBareMetalClusterControlPlaneControlPlaneNodePoolConfigNodePoolConfigToHclTerraform(struct?: GoogleGkeonpremBareMetalClusterControlPlaneControlPlaneNodePoolConfigNodePoolConfigOutputReference | GoogleGkeonpremBareMetalClusterControlPlaneControlPlaneNodePoolConfigNodePoolConfig): any;
export declare class GoogleGkeonpremBareMetalClusterControlPlaneControlPlaneNodePoolConfigNodePoolConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleGkeonpremBareMetalClusterControlPlaneControlPlaneNodePoolConfigNodePoolConfig | undefined;
    set internalValue(value: GoogleGkeonpremBareMetalClusterControlPlaneControlPlaneNodePoolConfigNodePoolConfig | undefined);
    private _labels?;
    get labels(): {
        [key: string]: string;
    };
    set labels(value: {
        [key: string]: string;
    });
    resetLabels(): void;
    get labelsInput(): {
        [key: string]: string;
    } | undefined;
    private _operatingSystem?;
    get operatingSystem(): string;
    set operatingSystem(value: string);
    resetOperatingSystem(): void;
    get operatingSystemInput(): string | undefined;
    private _nodeConfigs;
    get nodeConfigs(): GoogleGkeonpremBareMetalClusterControlPlaneControlPlaneNodePoolConfigNodePoolConfigNodeConfigsList;
    putNodeConfigs(value: GoogleGkeonpremBareMetalClusterControlPlaneControlPlaneNodePoolConfigNodePoolConfigNodeConfigs[] | cdktf.IResolvable): void;
    resetNodeConfigs(): void;
    get nodeConfigsInput(): cdktf.IResolvable | GoogleGkeonpremBareMetalClusterControlPlaneControlPlaneNodePoolConfigNodePoolConfigNodeConfigs[] | undefined;
    private _taints;
    get taints(): GoogleGkeonpremBareMetalClusterControlPlaneControlPlaneNodePoolConfigNodePoolConfigTaintsList;
    putTaints(value: GoogleGkeonpremBareMetalClusterControlPlaneControlPlaneNodePoolConfigNodePoolConfigTaints[] | cdktf.IResolvable): void;
    resetTaints(): void;
    get taintsInput(): cdktf.IResolvable | GoogleGkeonpremBareMetalClusterControlPlaneControlPlaneNodePoolConfigNodePoolConfigTaints[] | undefined;
}
export interface GoogleGkeonpremBareMetalClusterControlPlaneControlPlaneNodePoolConfig {
    /**
    * node_pool_config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gkeonprem_bare_metal_cluster#node_pool_config GoogleGkeonpremBareMetalCluster#node_pool_config}
    */
    readonly nodePoolConfig: GoogleGkeonpremBareMetalClusterControlPlaneControlPlaneNodePoolConfigNodePoolConfig;
}
export declare function googleGkeonpremBareMetalClusterControlPlaneControlPlaneNodePoolConfigToTerraform(struct?: GoogleGkeonpremBareMetalClusterControlPlaneControlPlaneNodePoolConfigOutputReference | GoogleGkeonpremBareMetalClusterControlPlaneControlPlaneNodePoolConfig): any;
export declare function googleGkeonpremBareMetalClusterControlPlaneControlPlaneNodePoolConfigToHclTerraform(struct?: GoogleGkeonpremBareMetalClusterControlPlaneControlPlaneNodePoolConfigOutputReference | GoogleGkeonpremBareMetalClusterControlPlaneControlPlaneNodePoolConfig): any;
export declare class GoogleGkeonpremBareMetalClusterControlPlaneControlPlaneNodePoolConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleGkeonpremBareMetalClusterControlPlaneControlPlaneNodePoolConfig | undefined;
    set internalValue(value: GoogleGkeonpremBareMetalClusterControlPlaneControlPlaneNodePoolConfig | undefined);
    private _nodePoolConfig;
    get nodePoolConfig(): GoogleGkeonpremBareMetalClusterControlPlaneControlPlaneNodePoolConfigNodePoolConfigOutputReference;
    putNodePoolConfig(value: GoogleGkeonpremBareMetalClusterControlPlaneControlPlaneNodePoolConfigNodePoolConfig): void;
    get nodePoolConfigInput(): GoogleGkeonpremBareMetalClusterControlPlaneControlPlaneNodePoolConfigNodePoolConfig | undefined;
}
export interface GoogleGkeonpremBareMetalClusterControlPlane {
    /**
    * api_server_args block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gkeonprem_bare_metal_cluster#api_server_args GoogleGkeonpremBareMetalCluster#api_server_args}
    */
    readonly apiServerArgs?: GoogleGkeonpremBareMetalClusterControlPlaneApiServerArgs[] | cdktf.IResolvable;
    /**
    * control_plane_node_pool_config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gkeonprem_bare_metal_cluster#control_plane_node_pool_config GoogleGkeonpremBareMetalCluster#control_plane_node_pool_config}
    */
    readonly controlPlaneNodePoolConfig: GoogleGkeonpremBareMetalClusterControlPlaneControlPlaneNodePoolConfig;
}
export declare function googleGkeonpremBareMetalClusterControlPlaneToTerraform(struct?: GoogleGkeonpremBareMetalClusterControlPlaneOutputReference | GoogleGkeonpremBareMetalClusterControlPlane): any;
export declare function googleGkeonpremBareMetalClusterControlPlaneToHclTerraform(struct?: GoogleGkeonpremBareMetalClusterControlPlaneOutputReference | GoogleGkeonpremBareMetalClusterControlPlane): any;
export declare class GoogleGkeonpremBareMetalClusterControlPlaneOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleGkeonpremBareMetalClusterControlPlane | undefined;
    set internalValue(value: GoogleGkeonpremBareMetalClusterControlPlane | undefined);
    private _apiServerArgs;
    get apiServerArgs(): GoogleGkeonpremBareMetalClusterControlPlaneApiServerArgsList;
    putApiServerArgs(value: GoogleGkeonpremBareMetalClusterControlPlaneApiServerArgs[] | cdktf.IResolvable): void;
    resetApiServerArgs(): void;
    get apiServerArgsInput(): cdktf.IResolvable | GoogleGkeonpremBareMetalClusterControlPlaneApiServerArgs[] | undefined;
    private _controlPlaneNodePoolConfig;
    get controlPlaneNodePoolConfig(): GoogleGkeonpremBareMetalClusterControlPlaneControlPlaneNodePoolConfigOutputReference;
    putControlPlaneNodePoolConfig(value: GoogleGkeonpremBareMetalClusterControlPlaneControlPlaneNodePoolConfig): void;
    get controlPlaneNodePoolConfigInput(): GoogleGkeonpremBareMetalClusterControlPlaneControlPlaneNodePoolConfig | undefined;
}
export interface GoogleGkeonpremBareMetalClusterLoadBalancerBgpLbConfigAddressPools {
    /**
    * The addresses that are part of this pool. Each address must be either in the CIDR form (1.2.3.0/24) or range form (1.2.3.1-1.2.3.5).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gkeonprem_bare_metal_cluster#addresses GoogleGkeonpremBareMetalCluster#addresses}
    */
    readonly addresses: string[];
    /**
    * If true, avoid using IPs ending in .0 or .255.
    * This avoids buggy consumer devices mistakenly dropping IPv4 traffic for those special IP addresses.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gkeonprem_bare_metal_cluster#avoid_buggy_ips GoogleGkeonpremBareMetalCluster#avoid_buggy_ips}
    */
    readonly avoidBuggyIps?: boolean | cdktf.IResolvable;
    /**
    * If true, prevent IP addresses from being automatically assigned.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gkeonprem_bare_metal_cluster#manual_assign GoogleGkeonpremBareMetalCluster#manual_assign}
    */
    readonly manualAssign?: string;
    /**
    * The name of the address pool.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gkeonprem_bare_metal_cluster#pool GoogleGkeonpremBareMetalCluster#pool}
    */
    readonly pool: string;
}
export declare function googleGkeonpremBareMetalClusterLoadBalancerBgpLbConfigAddressPoolsToTerraform(struct?: GoogleGkeonpremBareMetalClusterLoadBalancerBgpLbConfigAddressPools | cdktf.IResolvable): any;
export declare function googleGkeonpremBareMetalClusterLoadBalancerBgpLbConfigAddressPoolsToHclTerraform(struct?: GoogleGkeonpremBareMetalClusterLoadBalancerBgpLbConfigAddressPools | cdktf.IResolvable): any;
export declare class GoogleGkeonpremBareMetalClusterLoadBalancerBgpLbConfigAddressPoolsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleGkeonpremBareMetalClusterLoadBalancerBgpLbConfigAddressPools | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleGkeonpremBareMetalClusterLoadBalancerBgpLbConfigAddressPools | cdktf.IResolvable | undefined);
    private _addresses?;
    get addresses(): string[];
    set addresses(value: string[]);
    get addressesInput(): string[] | undefined;
    private _avoidBuggyIps?;
    get avoidBuggyIps(): boolean | cdktf.IResolvable;
    set avoidBuggyIps(value: boolean | cdktf.IResolvable);
    resetAvoidBuggyIps(): void;
    get avoidBuggyIpsInput(): boolean | cdktf.IResolvable | undefined;
    private _manualAssign?;
    get manualAssign(): string;
    set manualAssign(value: string);
    resetManualAssign(): void;
    get manualAssignInput(): string | undefined;
    private _pool?;
    get pool(): string;
    set pool(value: string);
    get poolInput(): string | undefined;
}
export declare class GoogleGkeonpremBareMetalClusterLoadBalancerBgpLbConfigAddressPoolsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleGkeonpremBareMetalClusterLoadBalancerBgpLbConfigAddressPools[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleGkeonpremBareMetalClusterLoadBalancerBgpLbConfigAddressPoolsOutputReference;
}
export interface GoogleGkeonpremBareMetalClusterLoadBalancerBgpLbConfigBgpPeerConfigs {
    /**
    * BGP autonomous system number (ASN) for the network that contains the
    * external peer device.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gkeonprem_bare_metal_cluster#asn GoogleGkeonpremBareMetalCluster#asn}
    */
    readonly asn: number;
    /**
    * The IP address of the control plane node that connects to the external
    * peer.
    * If you don't specify any control plane nodes, all control plane nodes
    * can connect to the external peer. If you specify one or more IP addresses,
    * only the nodes specified participate in peering sessions.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gkeonprem_bare_metal_cluster#control_plane_nodes GoogleGkeonpremBareMetalCluster#control_plane_nodes}
    */
    readonly controlPlaneNodes?: string[];
    /**
    * The IP address of the external peer device.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gkeonprem_bare_metal_cluster#ip_address GoogleGkeonpremBareMetalCluster#ip_address}
    */
    readonly ipAddress: string;
}
export declare function googleGkeonpremBareMetalClusterLoadBalancerBgpLbConfigBgpPeerConfigsToTerraform(struct?: GoogleGkeonpremBareMetalClusterLoadBalancerBgpLbConfigBgpPeerConfigs | cdktf.IResolvable): any;
export declare function googleGkeonpremBareMetalClusterLoadBalancerBgpLbConfigBgpPeerConfigsToHclTerraform(struct?: GoogleGkeonpremBareMetalClusterLoadBalancerBgpLbConfigBgpPeerConfigs | cdktf.IResolvable): any;
export declare class GoogleGkeonpremBareMetalClusterLoadBalancerBgpLbConfigBgpPeerConfigsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleGkeonpremBareMetalClusterLoadBalancerBgpLbConfigBgpPeerConfigs | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleGkeonpremBareMetalClusterLoadBalancerBgpLbConfigBgpPeerConfigs | cdktf.IResolvable | undefined);
    private _asn?;
    get asn(): number;
    set asn(value: number);
    get asnInput(): number | undefined;
    private _controlPlaneNodes?;
    get controlPlaneNodes(): string[];
    set controlPlaneNodes(value: string[]);
    resetControlPlaneNodes(): void;
    get controlPlaneNodesInput(): string[] | undefined;
    private _ipAddress?;
    get ipAddress(): string;
    set ipAddress(value: string);
    get ipAddressInput(): string | undefined;
}
export declare class GoogleGkeonpremBareMetalClusterLoadBalancerBgpLbConfigBgpPeerConfigsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleGkeonpremBareMetalClusterLoadBalancerBgpLbConfigBgpPeerConfigs[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleGkeonpremBareMetalClusterLoadBalancerBgpLbConfigBgpPeerConfigsOutputReference;
}
export interface GoogleGkeonpremBareMetalClusterLoadBalancerBgpLbConfigLoadBalancerNodePoolConfigNodePoolConfigKubeletConfig {
    /**
    * The maximum size of bursty pulls, temporarily allows pulls to burst to this
    * number, while still not exceeding registry_pull_qps.
    * The value must not be a negative number.
    * Updating this field may impact scalability by changing the amount of
    * traffic produced by image pulls.
    * Defaults to 10.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gkeonprem_bare_metal_cluster#registry_burst GoogleGkeonpremBareMetalCluster#registry_burst}
    */
    readonly registryBurst?: number;
    /**
    * The limit of registry pulls per second.
    * Setting this value to 0 means no limit.
    * Updating this field may impact scalability by changing the amount of
    * traffic produced by image pulls.
    * Defaults to 5.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gkeonprem_bare_metal_cluster#registry_pull_qps GoogleGkeonpremBareMetalCluster#registry_pull_qps}
    */
    readonly registryPullQps?: number;
    /**
    * Prevents the Kubelet from pulling multiple images at a time.
    * We recommend *not* changing the default value on nodes that run docker
    * daemon with version  < 1.9 or an Another Union File System (Aufs) storage
    * backend. Issue https://github.com/kubernetes/kubernetes/issues/10959 has
    * more details.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gkeonprem_bare_metal_cluster#serialize_image_pulls_disabled GoogleGkeonpremBareMetalCluster#serialize_image_pulls_disabled}
    */
    readonly serializeImagePullsDisabled?: boolean | cdktf.IResolvable;
}
export declare function googleGkeonpremBareMetalClusterLoadBalancerBgpLbConfigLoadBalancerNodePoolConfigNodePoolConfigKubeletConfigToTerraform(struct?: GoogleGkeonpremBareMetalClusterLoadBalancerBgpLbConfigLoadBalancerNodePoolConfigNodePoolConfigKubeletConfigOutputReference | GoogleGkeonpremBareMetalClusterLoadBalancerBgpLbConfigLoadBalancerNodePoolConfigNodePoolConfigKubeletConfig): any;
export declare function googleGkeonpremBareMetalClusterLoadBalancerBgpLbConfigLoadBalancerNodePoolConfigNodePoolConfigKubeletConfigToHclTerraform(struct?: GoogleGkeonpremBareMetalClusterLoadBalancerBgpLbConfigLoadBalancerNodePoolConfigNodePoolConfigKubeletConfigOutputReference | GoogleGkeonpremBareMetalClusterLoadBalancerBgpLbConfigLoadBalancerNodePoolConfigNodePoolConfigKubeletConfig): any;
export declare class GoogleGkeonpremBareMetalClusterLoadBalancerBgpLbConfigLoadBalancerNodePoolConfigNodePoolConfigKubeletConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleGkeonpremBareMetalClusterLoadBalancerBgpLbConfigLoadBalancerNodePoolConfigNodePoolConfigKubeletConfig | undefined;
    set internalValue(value: GoogleGkeonpremBareMetalClusterLoadBalancerBgpLbConfigLoadBalancerNodePoolConfigNodePoolConfigKubeletConfig | undefined);
    private _registryBurst?;
    get registryBurst(): number;
    set registryBurst(value: number);
    resetRegistryBurst(): void;
    get registryBurstInput(): number | undefined;
    private _registryPullQps?;
    get registryPullQps(): number;
    set registryPullQps(value: number);
    resetRegistryPullQps(): void;
    get registryPullQpsInput(): number | undefined;
    private _serializeImagePullsDisabled?;
    get serializeImagePullsDisabled(): boolean | cdktf.IResolvable;
    set serializeImagePullsDisabled(value: boolean | cdktf.IResolvable);
    resetSerializeImagePullsDisabled(): void;
    get serializeImagePullsDisabledInput(): boolean | cdktf.IResolvable | undefined;
}
export interface GoogleGkeonpremBareMetalClusterLoadBalancerBgpLbConfigLoadBalancerNodePoolConfigNodePoolConfigNodeConfigs {
    /**
    * The map of Kubernetes labels (key/value pairs) to be applied to
    * each node. These will added in addition to any default label(s)
    * that Kubernetes may apply to the node. In case of conflict in
    * label keys, the applied set may differ depending on the Kubernetes
    * version -- it's best to assume the behavior is undefined and
    * conflicts should be avoided. For more information, including usage
    * and the valid values, see:
    *   http://kubernetes.io/v1.1/docs/user-guide/labels.html
    * An object containing a list of "key": value pairs.
    * Example: { "name": "wrench", "mass": "1.3kg", "count": "3" }.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gkeonprem_bare_metal_cluster#labels GoogleGkeonpremBareMetalCluster#labels}
    */
    readonly labels?: {
        [key: string]: string;
    };
    /**
    * The default IPv4 address for SSH access and Kubernetes node.
    * Example: 192.168.0.1
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gkeonprem_bare_metal_cluster#node_ip GoogleGkeonpremBareMetalCluster#node_ip}
    */
    readonly nodeIp?: string;
}
export declare function googleGkeonpremBareMetalClusterLoadBalancerBgpLbConfigLoadBalancerNodePoolConfigNodePoolConfigNodeConfigsToTerraform(struct?: GoogleGkeonpremBareMetalClusterLoadBalancerBgpLbConfigLoadBalancerNodePoolConfigNodePoolConfigNodeConfigs | cdktf.IResolvable): any;
export declare function googleGkeonpremBareMetalClusterLoadBalancerBgpLbConfigLoadBalancerNodePoolConfigNodePoolConfigNodeConfigsToHclTerraform(struct?: GoogleGkeonpremBareMetalClusterLoadBalancerBgpLbConfigLoadBalancerNodePoolConfigNodePoolConfigNodeConfigs | cdktf.IResolvable): any;
export declare class GoogleGkeonpremBareMetalClusterLoadBalancerBgpLbConfigLoadBalancerNodePoolConfigNodePoolConfigNodeConfigsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleGkeonpremBareMetalClusterLoadBalancerBgpLbConfigLoadBalancerNodePoolConfigNodePoolConfigNodeConfigs | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleGkeonpremBareMetalClusterLoadBalancerBgpLbConfigLoadBalancerNodePoolConfigNodePoolConfigNodeConfigs | cdktf.IResolvable | undefined);
    private _labels?;
    get labels(): {
        [key: string]: string;
    };
    set labels(value: {
        [key: string]: string;
    });
    resetLabels(): void;
    get labelsInput(): {
        [key: string]: string;
    } | undefined;
    private _nodeIp?;
    get nodeIp(): string;
    set nodeIp(value: string);
    resetNodeIp(): void;
    get nodeIpInput(): string | undefined;
}
export declare class GoogleGkeonpremBareMetalClusterLoadBalancerBgpLbConfigLoadBalancerNodePoolConfigNodePoolConfigNodeConfigsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleGkeonpremBareMetalClusterLoadBalancerBgpLbConfigLoadBalancerNodePoolConfigNodePoolConfigNodeConfigs[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleGkeonpremBareMetalClusterLoadBalancerBgpLbConfigLoadBalancerNodePoolConfigNodePoolConfigNodeConfigsOutputReference;
}
export interface GoogleGkeonpremBareMetalClusterLoadBalancerBgpLbConfigLoadBalancerNodePoolConfigNodePoolConfigTaints {
    /**
    * Specifies the nodes operating system (default: LINUX). Possible values: ["EFFECT_UNSPECIFIED", "PREFER_NO_SCHEDULE", "NO_EXECUTE"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gkeonprem_bare_metal_cluster#effect GoogleGkeonpremBareMetalCluster#effect}
    */
    readonly effect?: string;
    /**
    * Key associated with the effect.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gkeonprem_bare_metal_cluster#key GoogleGkeonpremBareMetalCluster#key}
    */
    readonly key?: string;
    /**
    * Value associated with the effect.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gkeonprem_bare_metal_cluster#value GoogleGkeonpremBareMetalCluster#value}
    */
    readonly value?: string;
}
export declare function googleGkeonpremBareMetalClusterLoadBalancerBgpLbConfigLoadBalancerNodePoolConfigNodePoolConfigTaintsToTerraform(struct?: GoogleGkeonpremBareMetalClusterLoadBalancerBgpLbConfigLoadBalancerNodePoolConfigNodePoolConfigTaints | cdktf.IResolvable): any;
export declare function googleGkeonpremBareMetalClusterLoadBalancerBgpLbConfigLoadBalancerNodePoolConfigNodePoolConfigTaintsToHclTerraform(struct?: GoogleGkeonpremBareMetalClusterLoadBalancerBgpLbConfigLoadBalancerNodePoolConfigNodePoolConfigTaints | cdktf.IResolvable): any;
export declare class GoogleGkeonpremBareMetalClusterLoadBalancerBgpLbConfigLoadBalancerNodePoolConfigNodePoolConfigTaintsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleGkeonpremBareMetalClusterLoadBalancerBgpLbConfigLoadBalancerNodePoolConfigNodePoolConfigTaints | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleGkeonpremBareMetalClusterLoadBalancerBgpLbConfigLoadBalancerNodePoolConfigNodePoolConfigTaints | cdktf.IResolvable | undefined);
    private _effect?;
    get effect(): string;
    set effect(value: string);
    resetEffect(): void;
    get effectInput(): string | undefined;
    private _key?;
    get key(): string;
    set key(value: string);
    resetKey(): void;
    get keyInput(): string | undefined;
    private _value?;
    get value(): string;
    set value(value: string);
    resetValue(): void;
    get valueInput(): string | undefined;
}
export declare class GoogleGkeonpremBareMetalClusterLoadBalancerBgpLbConfigLoadBalancerNodePoolConfigNodePoolConfigTaintsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleGkeonpremBareMetalClusterLoadBalancerBgpLbConfigLoadBalancerNodePoolConfigNodePoolConfigTaints[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleGkeonpremBareMetalClusterLoadBalancerBgpLbConfigLoadBalancerNodePoolConfigNodePoolConfigTaintsOutputReference;
}
export interface GoogleGkeonpremBareMetalClusterLoadBalancerBgpLbConfigLoadBalancerNodePoolConfigNodePoolConfig {
    /**
    * The map of Kubernetes labels (key/value pairs) to be applied to
    * each node. These will added in addition to any default label(s)
    * that Kubernetes may apply to the node. In case of conflict in
    * label keys, the applied set may differ depending on the Kubernetes
    * version -- it's best to assume the behavior is undefined and
    * conflicts should be avoided. For more information, including usage
    * and the valid values, see:
    *   http://kubernetes.io/v1.1/docs/user-guide/labels.html
    * An object containing a list of "key": value pairs.
    * Example: { "name": "wrench", "mass": "1.3kg", "count": "3" }.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gkeonprem_bare_metal_cluster#labels GoogleGkeonpremBareMetalCluster#labels}
    */
    readonly labels?: {
        [key: string]: string;
    };
    /**
    * Specifies the nodes operating system (default: LINUX).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gkeonprem_bare_metal_cluster#operating_system GoogleGkeonpremBareMetalCluster#operating_system}
    */
    readonly operatingSystem?: string;
    /**
    * kubelet_config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gkeonprem_bare_metal_cluster#kubelet_config GoogleGkeonpremBareMetalCluster#kubelet_config}
    */
    readonly kubeletConfig?: GoogleGkeonpremBareMetalClusterLoadBalancerBgpLbConfigLoadBalancerNodePoolConfigNodePoolConfigKubeletConfig;
    /**
    * node_configs block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gkeonprem_bare_metal_cluster#node_configs GoogleGkeonpremBareMetalCluster#node_configs}
    */
    readonly nodeConfigs?: GoogleGkeonpremBareMetalClusterLoadBalancerBgpLbConfigLoadBalancerNodePoolConfigNodePoolConfigNodeConfigs[] | cdktf.IResolvable;
    /**
    * taints block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gkeonprem_bare_metal_cluster#taints GoogleGkeonpremBareMetalCluster#taints}
    */
    readonly taints?: GoogleGkeonpremBareMetalClusterLoadBalancerBgpLbConfigLoadBalancerNodePoolConfigNodePoolConfigTaints[] | cdktf.IResolvable;
}
export declare function googleGkeonpremBareMetalClusterLoadBalancerBgpLbConfigLoadBalancerNodePoolConfigNodePoolConfigToTerraform(struct?: GoogleGkeonpremBareMetalClusterLoadBalancerBgpLbConfigLoadBalancerNodePoolConfigNodePoolConfigOutputReference | GoogleGkeonpremBareMetalClusterLoadBalancerBgpLbConfigLoadBalancerNodePoolConfigNodePoolConfig): any;
export declare function googleGkeonpremBareMetalClusterLoadBalancerBgpLbConfigLoadBalancerNodePoolConfigNodePoolConfigToHclTerraform(struct?: GoogleGkeonpremBareMetalClusterLoadBalancerBgpLbConfigLoadBalancerNodePoolConfigNodePoolConfigOutputReference | GoogleGkeonpremBareMetalClusterLoadBalancerBgpLbConfigLoadBalancerNodePoolConfigNodePoolConfig): any;
export declare class GoogleGkeonpremBareMetalClusterLoadBalancerBgpLbConfigLoadBalancerNodePoolConfigNodePoolConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleGkeonpremBareMetalClusterLoadBalancerBgpLbConfigLoadBalancerNodePoolConfigNodePoolConfig | undefined;
    set internalValue(value: GoogleGkeonpremBareMetalClusterLoadBalancerBgpLbConfigLoadBalancerNodePoolConfigNodePoolConfig | undefined);
    private _labels?;
    get labels(): {
        [key: string]: string;
    };
    set labels(value: {
        [key: string]: string;
    });
    resetLabels(): void;
    get labelsInput(): {
        [key: string]: string;
    } | undefined;
    private _operatingSystem?;
    get operatingSystem(): string;
    set operatingSystem(value: string);
    resetOperatingSystem(): void;
    get operatingSystemInput(): string | undefined;
    private _kubeletConfig;
    get kubeletConfig(): GoogleGkeonpremBareMetalClusterLoadBalancerBgpLbConfigLoadBalancerNodePoolConfigNodePoolConfigKubeletConfigOutputReference;
    putKubeletConfig(value: GoogleGkeonpremBareMetalClusterLoadBalancerBgpLbConfigLoadBalancerNodePoolConfigNodePoolConfigKubeletConfig): void;
    resetKubeletConfig(): void;
    get kubeletConfigInput(): GoogleGkeonpremBareMetalClusterLoadBalancerBgpLbConfigLoadBalancerNodePoolConfigNodePoolConfigKubeletConfig | undefined;
    private _nodeConfigs;
    get nodeConfigs(): GoogleGkeonpremBareMetalClusterLoadBalancerBgpLbConfigLoadBalancerNodePoolConfigNodePoolConfigNodeConfigsList;
    putNodeConfigs(value: GoogleGkeonpremBareMetalClusterLoadBalancerBgpLbConfigLoadBalancerNodePoolConfigNodePoolConfigNodeConfigs[] | cdktf.IResolvable): void;
    resetNodeConfigs(): void;
    get nodeConfigsInput(): cdktf.IResolvable | GoogleGkeonpremBareMetalClusterLoadBalancerBgpLbConfigLoadBalancerNodePoolConfigNodePoolConfigNodeConfigs[] | undefined;
    private _taints;
    get taints(): GoogleGkeonpremBareMetalClusterLoadBalancerBgpLbConfigLoadBalancerNodePoolConfigNodePoolConfigTaintsList;
    putTaints(value: GoogleGkeonpremBareMetalClusterLoadBalancerBgpLbConfigLoadBalancerNodePoolConfigNodePoolConfigTaints[] | cdktf.IResolvable): void;
    resetTaints(): void;
    get taintsInput(): cdktf.IResolvable | GoogleGkeonpremBareMetalClusterLoadBalancerBgpLbConfigLoadBalancerNodePoolConfigNodePoolConfigTaints[] | undefined;
}
export interface GoogleGkeonpremBareMetalClusterLoadBalancerBgpLbConfigLoadBalancerNodePoolConfig {
    /**
    * node_pool_config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gkeonprem_bare_metal_cluster#node_pool_config GoogleGkeonpremBareMetalCluster#node_pool_config}
    */
    readonly nodePoolConfig?: GoogleGkeonpremBareMetalClusterLoadBalancerBgpLbConfigLoadBalancerNodePoolConfigNodePoolConfig;
}
export declare function googleGkeonpremBareMetalClusterLoadBalancerBgpLbConfigLoadBalancerNodePoolConfigToTerraform(struct?: GoogleGkeonpremBareMetalClusterLoadBalancerBgpLbConfigLoadBalancerNodePoolConfigOutputReference | GoogleGkeonpremBareMetalClusterLoadBalancerBgpLbConfigLoadBalancerNodePoolConfig): any;
export declare function googleGkeonpremBareMetalClusterLoadBalancerBgpLbConfigLoadBalancerNodePoolConfigToHclTerraform(struct?: GoogleGkeonpremBareMetalClusterLoadBalancerBgpLbConfigLoadBalancerNodePoolConfigOutputReference | GoogleGkeonpremBareMetalClusterLoadBalancerBgpLbConfigLoadBalancerNodePoolConfig): any;
export declare class GoogleGkeonpremBareMetalClusterLoadBalancerBgpLbConfigLoadBalancerNodePoolConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleGkeonpremBareMetalClusterLoadBalancerBgpLbConfigLoadBalancerNodePoolConfig | undefined;
    set internalValue(value: GoogleGkeonpremBareMetalClusterLoadBalancerBgpLbConfigLoadBalancerNodePoolConfig | undefined);
    private _nodePoolConfig;
    get nodePoolConfig(): GoogleGkeonpremBareMetalClusterLoadBalancerBgpLbConfigLoadBalancerNodePoolConfigNodePoolConfigOutputReference;
    putNodePoolConfig(value: GoogleGkeonpremBareMetalClusterLoadBalancerBgpLbConfigLoadBalancerNodePoolConfigNodePoolConfig): void;
    resetNodePoolConfig(): void;
    get nodePoolConfigInput(): GoogleGkeonpremBareMetalClusterLoadBalancerBgpLbConfigLoadBalancerNodePoolConfigNodePoolConfig | undefined;
}
export interface GoogleGkeonpremBareMetalClusterLoadBalancerBgpLbConfig {
    /**
    * BGP autonomous system number (ASN) of the cluster.
    * This field can be updated after cluster creation.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gkeonprem_bare_metal_cluster#asn GoogleGkeonpremBareMetalCluster#asn}
    */
    readonly asn: number;
    /**
    * address_pools block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gkeonprem_bare_metal_cluster#address_pools GoogleGkeonpremBareMetalCluster#address_pools}
    */
    readonly addressPools: GoogleGkeonpremBareMetalClusterLoadBalancerBgpLbConfigAddressPools[] | cdktf.IResolvable;
    /**
    * bgp_peer_configs block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gkeonprem_bare_metal_cluster#bgp_peer_configs GoogleGkeonpremBareMetalCluster#bgp_peer_configs}
    */
    readonly bgpPeerConfigs: GoogleGkeonpremBareMetalClusterLoadBalancerBgpLbConfigBgpPeerConfigs[] | cdktf.IResolvable;
    /**
    * load_balancer_node_pool_config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gkeonprem_bare_metal_cluster#load_balancer_node_pool_config GoogleGkeonpremBareMetalCluster#load_balancer_node_pool_config}
    */
    readonly loadBalancerNodePoolConfig?: GoogleGkeonpremBareMetalClusterLoadBalancerBgpLbConfigLoadBalancerNodePoolConfig;
}
export declare function googleGkeonpremBareMetalClusterLoadBalancerBgpLbConfigToTerraform(struct?: GoogleGkeonpremBareMetalClusterLoadBalancerBgpLbConfigOutputReference | GoogleGkeonpremBareMetalClusterLoadBalancerBgpLbConfig): any;
export declare function googleGkeonpremBareMetalClusterLoadBalancerBgpLbConfigToHclTerraform(struct?: GoogleGkeonpremBareMetalClusterLoadBalancerBgpLbConfigOutputReference | GoogleGkeonpremBareMetalClusterLoadBalancerBgpLbConfig): any;
export declare class GoogleGkeonpremBareMetalClusterLoadBalancerBgpLbConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleGkeonpremBareMetalClusterLoadBalancerBgpLbConfig | undefined;
    set internalValue(value: GoogleGkeonpremBareMetalClusterLoadBalancerBgpLbConfig | undefined);
    private _asn?;
    get asn(): number;
    set asn(value: number);
    get asnInput(): number | undefined;
    private _addressPools;
    get addressPools(): GoogleGkeonpremBareMetalClusterLoadBalancerBgpLbConfigAddressPoolsList;
    putAddressPools(value: GoogleGkeonpremBareMetalClusterLoadBalancerBgpLbConfigAddressPools[] | cdktf.IResolvable): void;
    get addressPoolsInput(): cdktf.IResolvable | GoogleGkeonpremBareMetalClusterLoadBalancerBgpLbConfigAddressPools[] | undefined;
    private _bgpPeerConfigs;
    get bgpPeerConfigs(): GoogleGkeonpremBareMetalClusterLoadBalancerBgpLbConfigBgpPeerConfigsList;
    putBgpPeerConfigs(value: GoogleGkeonpremBareMetalClusterLoadBalancerBgpLbConfigBgpPeerConfigs[] | cdktf.IResolvable): void;
    get bgpPeerConfigsInput(): cdktf.IResolvable | GoogleGkeonpremBareMetalClusterLoadBalancerBgpLbConfigBgpPeerConfigs[] | undefined;
    private _loadBalancerNodePoolConfig;
    get loadBalancerNodePoolConfig(): GoogleGkeonpremBareMetalClusterLoadBalancerBgpLbConfigLoadBalancerNodePoolConfigOutputReference;
    putLoadBalancerNodePoolConfig(value: GoogleGkeonpremBareMetalClusterLoadBalancerBgpLbConfigLoadBalancerNodePoolConfig): void;
    resetLoadBalancerNodePoolConfig(): void;
    get loadBalancerNodePoolConfigInput(): GoogleGkeonpremBareMetalClusterLoadBalancerBgpLbConfigLoadBalancerNodePoolConfig | undefined;
}
export interface GoogleGkeonpremBareMetalClusterLoadBalancerManualLbConfig {
    /**
    * Whether manual load balancing is enabled.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gkeonprem_bare_metal_cluster#enabled GoogleGkeonpremBareMetalCluster#enabled}
    */
    readonly enabled: boolean | cdktf.IResolvable;
}
export declare function googleGkeonpremBareMetalClusterLoadBalancerManualLbConfigToTerraform(struct?: GoogleGkeonpremBareMetalClusterLoadBalancerManualLbConfigOutputReference | GoogleGkeonpremBareMetalClusterLoadBalancerManualLbConfig): any;
export declare function googleGkeonpremBareMetalClusterLoadBalancerManualLbConfigToHclTerraform(struct?: GoogleGkeonpremBareMetalClusterLoadBalancerManualLbConfigOutputReference | GoogleGkeonpremBareMetalClusterLoadBalancerManualLbConfig): any;
export declare class GoogleGkeonpremBareMetalClusterLoadBalancerManualLbConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleGkeonpremBareMetalClusterLoadBalancerManualLbConfig | undefined;
    set internalValue(value: GoogleGkeonpremBareMetalClusterLoadBalancerManualLbConfig | undefined);
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
}
export interface GoogleGkeonpremBareMetalClusterLoadBalancerMetalLbConfigAddressPools {
    /**
    * The addresses that are part of this pool. Each address must be either in the CIDR form (1.2.3.0/24) or range form (1.2.3.1-1.2.3.5).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gkeonprem_bare_metal_cluster#addresses GoogleGkeonpremBareMetalCluster#addresses}
    */
    readonly addresses: string[];
    /**
    * If true, avoid using IPs ending in .0 or .255.
    * This avoids buggy consumer devices mistakenly dropping IPv4 traffic for those special IP addresses.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gkeonprem_bare_metal_cluster#avoid_buggy_ips GoogleGkeonpremBareMetalCluster#avoid_buggy_ips}
    */
    readonly avoidBuggyIps?: boolean | cdktf.IResolvable;
    /**
    * If true, prevent IP addresses from being automatically assigned.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gkeonprem_bare_metal_cluster#manual_assign GoogleGkeonpremBareMetalCluster#manual_assign}
    */
    readonly manualAssign?: boolean | cdktf.IResolvable;
    /**
    * The name of the address pool.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gkeonprem_bare_metal_cluster#pool GoogleGkeonpremBareMetalCluster#pool}
    */
    readonly pool: string;
}
export declare function googleGkeonpremBareMetalClusterLoadBalancerMetalLbConfigAddressPoolsToTerraform(struct?: GoogleGkeonpremBareMetalClusterLoadBalancerMetalLbConfigAddressPools | cdktf.IResolvable): any;
export declare function googleGkeonpremBareMetalClusterLoadBalancerMetalLbConfigAddressPoolsToHclTerraform(struct?: GoogleGkeonpremBareMetalClusterLoadBalancerMetalLbConfigAddressPools | cdktf.IResolvable): any;
export declare class GoogleGkeonpremBareMetalClusterLoadBalancerMetalLbConfigAddressPoolsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleGkeonpremBareMetalClusterLoadBalancerMetalLbConfigAddressPools | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleGkeonpremBareMetalClusterLoadBalancerMetalLbConfigAddressPools | cdktf.IResolvable | undefined);
    private _addresses?;
    get addresses(): string[];
    set addresses(value: string[]);
    get addressesInput(): string[] | undefined;
    private _avoidBuggyIps?;
    get avoidBuggyIps(): boolean | cdktf.IResolvable;
    set avoidBuggyIps(value: boolean | cdktf.IResolvable);
    resetAvoidBuggyIps(): void;
    get avoidBuggyIpsInput(): boolean | cdktf.IResolvable | undefined;
    private _manualAssign?;
    get manualAssign(): boolean | cdktf.IResolvable;
    set manualAssign(value: boolean | cdktf.IResolvable);
    resetManualAssign(): void;
    get manualAssignInput(): boolean | cdktf.IResolvable | undefined;
    private _pool?;
    get pool(): string;
    set pool(value: string);
    get poolInput(): string | undefined;
}
export declare class GoogleGkeonpremBareMetalClusterLoadBalancerMetalLbConfigAddressPoolsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleGkeonpremBareMetalClusterLoadBalancerMetalLbConfigAddressPools[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleGkeonpremBareMetalClusterLoadBalancerMetalLbConfigAddressPoolsOutputReference;
}
export interface GoogleGkeonpremBareMetalClusterLoadBalancerMetalLbConfigLoadBalancerNodePoolConfigNodePoolConfigNodeConfigs {
    /**
    * The map of Kubernetes labels (key/value pairs) to be applied to
    * each node. These will added in addition to any default label(s)
    * that Kubernetes may apply to the node. In case of conflict in
    * label keys, the applied set may differ depending on the Kubernetes
    * version -- it's best to assume the behavior is undefined and
    * conflicts should be avoided. For more information, including usage
    * and the valid values, see:
    *   http://kubernetes.io/v1.1/docs/user-guide/labels.html
    * An object containing a list of "key": value pairs.
    * Example: { "name": "wrench", "mass": "1.3kg", "count": "3" }.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gkeonprem_bare_metal_cluster#labels GoogleGkeonpremBareMetalCluster#labels}
    */
    readonly labels?: {
        [key: string]: string;
    };
    /**
    * The default IPv4 address for SSH access and Kubernetes node.
    * Example: 192.168.0.1
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gkeonprem_bare_metal_cluster#node_ip GoogleGkeonpremBareMetalCluster#node_ip}
    */
    readonly nodeIp?: string;
}
export declare function googleGkeonpremBareMetalClusterLoadBalancerMetalLbConfigLoadBalancerNodePoolConfigNodePoolConfigNodeConfigsToTerraform(struct?: GoogleGkeonpremBareMetalClusterLoadBalancerMetalLbConfigLoadBalancerNodePoolConfigNodePoolConfigNodeConfigs | cdktf.IResolvable): any;
export declare function googleGkeonpremBareMetalClusterLoadBalancerMetalLbConfigLoadBalancerNodePoolConfigNodePoolConfigNodeConfigsToHclTerraform(struct?: GoogleGkeonpremBareMetalClusterLoadBalancerMetalLbConfigLoadBalancerNodePoolConfigNodePoolConfigNodeConfigs | cdktf.IResolvable): any;
export declare class GoogleGkeonpremBareMetalClusterLoadBalancerMetalLbConfigLoadBalancerNodePoolConfigNodePoolConfigNodeConfigsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleGkeonpremBareMetalClusterLoadBalancerMetalLbConfigLoadBalancerNodePoolConfigNodePoolConfigNodeConfigs | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleGkeonpremBareMetalClusterLoadBalancerMetalLbConfigLoadBalancerNodePoolConfigNodePoolConfigNodeConfigs | cdktf.IResolvable | undefined);
    private _labels?;
    get labels(): {
        [key: string]: string;
    };
    set labels(value: {
        [key: string]: string;
    });
    resetLabels(): void;
    get labelsInput(): {
        [key: string]: string;
    } | undefined;
    private _nodeIp?;
    get nodeIp(): string;
    set nodeIp(value: string);
    resetNodeIp(): void;
    get nodeIpInput(): string | undefined;
}
export declare class GoogleGkeonpremBareMetalClusterLoadBalancerMetalLbConfigLoadBalancerNodePoolConfigNodePoolConfigNodeConfigsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleGkeonpremBareMetalClusterLoadBalancerMetalLbConfigLoadBalancerNodePoolConfigNodePoolConfigNodeConfigs[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleGkeonpremBareMetalClusterLoadBalancerMetalLbConfigLoadBalancerNodePoolConfigNodePoolConfigNodeConfigsOutputReference;
}
export interface GoogleGkeonpremBareMetalClusterLoadBalancerMetalLbConfigLoadBalancerNodePoolConfigNodePoolConfigTaints {
    /**
    * Specifies the nodes operating system (default: LINUX). Possible values: ["EFFECT_UNSPECIFIED", "PREFER_NO_SCHEDULE", "NO_EXECUTE"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gkeonprem_bare_metal_cluster#effect GoogleGkeonpremBareMetalCluster#effect}
    */
    readonly effect?: string;
    /**
    * Key associated with the effect.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gkeonprem_bare_metal_cluster#key GoogleGkeonpremBareMetalCluster#key}
    */
    readonly key?: string;
    /**
    * Value associated with the effect.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gkeonprem_bare_metal_cluster#value GoogleGkeonpremBareMetalCluster#value}
    */
    readonly value?: string;
}
export declare function googleGkeonpremBareMetalClusterLoadBalancerMetalLbConfigLoadBalancerNodePoolConfigNodePoolConfigTaintsToTerraform(struct?: GoogleGkeonpremBareMetalClusterLoadBalancerMetalLbConfigLoadBalancerNodePoolConfigNodePoolConfigTaints | cdktf.IResolvable): any;
export declare function googleGkeonpremBareMetalClusterLoadBalancerMetalLbConfigLoadBalancerNodePoolConfigNodePoolConfigTaintsToHclTerraform(struct?: GoogleGkeonpremBareMetalClusterLoadBalancerMetalLbConfigLoadBalancerNodePoolConfigNodePoolConfigTaints | cdktf.IResolvable): any;
export declare class GoogleGkeonpremBareMetalClusterLoadBalancerMetalLbConfigLoadBalancerNodePoolConfigNodePoolConfigTaintsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleGkeonpremBareMetalClusterLoadBalancerMetalLbConfigLoadBalancerNodePoolConfigNodePoolConfigTaints | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleGkeonpremBareMetalClusterLoadBalancerMetalLbConfigLoadBalancerNodePoolConfigNodePoolConfigTaints | cdktf.IResolvable | undefined);
    private _effect?;
    get effect(): string;
    set effect(value: string);
    resetEffect(): void;
    get effectInput(): string | undefined;
    private _key?;
    get key(): string;
    set key(value: string);
    resetKey(): void;
    get keyInput(): string | undefined;
    private _value?;
    get value(): string;
    set value(value: string);
    resetValue(): void;
    get valueInput(): string | undefined;
}
export declare class GoogleGkeonpremBareMetalClusterLoadBalancerMetalLbConfigLoadBalancerNodePoolConfigNodePoolConfigTaintsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleGkeonpremBareMetalClusterLoadBalancerMetalLbConfigLoadBalancerNodePoolConfigNodePoolConfigTaints[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleGkeonpremBareMetalClusterLoadBalancerMetalLbConfigLoadBalancerNodePoolConfigNodePoolConfigTaintsOutputReference;
}
export interface GoogleGkeonpremBareMetalClusterLoadBalancerMetalLbConfigLoadBalancerNodePoolConfigNodePoolConfig {
    /**
    * The map of Kubernetes labels (key/value pairs) to be applied to
    * each node. These will added in addition to any default label(s)
    * that Kubernetes may apply to the node. In case of conflict in
    * label keys, the applied set may differ depending on the Kubernetes
    * version -- it's best to assume the behavior is undefined and
    * conflicts should be avoided. For more information, including usage
    * and the valid values, see:
    *   http://kubernetes.io/v1.1/docs/user-guide/labels.html
    * An object containing a list of "key": value pairs.
    * Example: { "name": "wrench", "mass": "1.3kg", "count": "3" }.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gkeonprem_bare_metal_cluster#labels GoogleGkeonpremBareMetalCluster#labels}
    */
    readonly labels?: {
        [key: string]: string;
    };
    /**
    * Specifies the nodes operating system (default: LINUX).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gkeonprem_bare_metal_cluster#operating_system GoogleGkeonpremBareMetalCluster#operating_system}
    */
    readonly operatingSystem?: string;
    /**
    * node_configs block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gkeonprem_bare_metal_cluster#node_configs GoogleGkeonpremBareMetalCluster#node_configs}
    */
    readonly nodeConfigs?: GoogleGkeonpremBareMetalClusterLoadBalancerMetalLbConfigLoadBalancerNodePoolConfigNodePoolConfigNodeConfigs[] | cdktf.IResolvable;
    /**
    * taints block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gkeonprem_bare_metal_cluster#taints GoogleGkeonpremBareMetalCluster#taints}
    */
    readonly taints?: GoogleGkeonpremBareMetalClusterLoadBalancerMetalLbConfigLoadBalancerNodePoolConfigNodePoolConfigTaints[] | cdktf.IResolvable;
}
export declare function googleGkeonpremBareMetalClusterLoadBalancerMetalLbConfigLoadBalancerNodePoolConfigNodePoolConfigToTerraform(struct?: GoogleGkeonpremBareMetalClusterLoadBalancerMetalLbConfigLoadBalancerNodePoolConfigNodePoolConfigOutputReference | GoogleGkeonpremBareMetalClusterLoadBalancerMetalLbConfigLoadBalancerNodePoolConfigNodePoolConfig): any;
export declare function googleGkeonpremBareMetalClusterLoadBalancerMetalLbConfigLoadBalancerNodePoolConfigNodePoolConfigToHclTerraform(struct?: GoogleGkeonpremBareMetalClusterLoadBalancerMetalLbConfigLoadBalancerNodePoolConfigNodePoolConfigOutputReference | GoogleGkeonpremBareMetalClusterLoadBalancerMetalLbConfigLoadBalancerNodePoolConfigNodePoolConfig): any;
export declare class GoogleGkeonpremBareMetalClusterLoadBalancerMetalLbConfigLoadBalancerNodePoolConfigNodePoolConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleGkeonpremBareMetalClusterLoadBalancerMetalLbConfigLoadBalancerNodePoolConfigNodePoolConfig | undefined;
    set internalValue(value: GoogleGkeonpremBareMetalClusterLoadBalancerMetalLbConfigLoadBalancerNodePoolConfigNodePoolConfig | undefined);
    private _labels?;
    get labels(): {
        [key: string]: string;
    };
    set labels(value: {
        [key: string]: string;
    });
    resetLabels(): void;
    get labelsInput(): {
        [key: string]: string;
    } | undefined;
    private _operatingSystem?;
    get operatingSystem(): string;
    set operatingSystem(value: string);
    resetOperatingSystem(): void;
    get operatingSystemInput(): string | undefined;
    private _nodeConfigs;
    get nodeConfigs(): GoogleGkeonpremBareMetalClusterLoadBalancerMetalLbConfigLoadBalancerNodePoolConfigNodePoolConfigNodeConfigsList;
    putNodeConfigs(value: GoogleGkeonpremBareMetalClusterLoadBalancerMetalLbConfigLoadBalancerNodePoolConfigNodePoolConfigNodeConfigs[] | cdktf.IResolvable): void;
    resetNodeConfigs(): void;
    get nodeConfigsInput(): cdktf.IResolvable | GoogleGkeonpremBareMetalClusterLoadBalancerMetalLbConfigLoadBalancerNodePoolConfigNodePoolConfigNodeConfigs[] | undefined;
    private _taints;
    get taints(): GoogleGkeonpremBareMetalClusterLoadBalancerMetalLbConfigLoadBalancerNodePoolConfigNodePoolConfigTaintsList;
    putTaints(value: GoogleGkeonpremBareMetalClusterLoadBalancerMetalLbConfigLoadBalancerNodePoolConfigNodePoolConfigTaints[] | cdktf.IResolvable): void;
    resetTaints(): void;
    get taintsInput(): cdktf.IResolvable | GoogleGkeonpremBareMetalClusterLoadBalancerMetalLbConfigLoadBalancerNodePoolConfigNodePoolConfigTaints[] | undefined;
}
export interface GoogleGkeonpremBareMetalClusterLoadBalancerMetalLbConfigLoadBalancerNodePoolConfig {
    /**
    * node_pool_config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gkeonprem_bare_metal_cluster#node_pool_config GoogleGkeonpremBareMetalCluster#node_pool_config}
    */
    readonly nodePoolConfig?: GoogleGkeonpremBareMetalClusterLoadBalancerMetalLbConfigLoadBalancerNodePoolConfigNodePoolConfig;
}
export declare function googleGkeonpremBareMetalClusterLoadBalancerMetalLbConfigLoadBalancerNodePoolConfigToTerraform(struct?: GoogleGkeonpremBareMetalClusterLoadBalancerMetalLbConfigLoadBalancerNodePoolConfigOutputReference | GoogleGkeonpremBareMetalClusterLoadBalancerMetalLbConfigLoadBalancerNodePoolConfig): any;
export declare function googleGkeonpremBareMetalClusterLoadBalancerMetalLbConfigLoadBalancerNodePoolConfigToHclTerraform(struct?: GoogleGkeonpremBareMetalClusterLoadBalancerMetalLbConfigLoadBalancerNodePoolConfigOutputReference | GoogleGkeonpremBareMetalClusterLoadBalancerMetalLbConfigLoadBalancerNodePoolConfig): any;
export declare class GoogleGkeonpremBareMetalClusterLoadBalancerMetalLbConfigLoadBalancerNodePoolConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleGkeonpremBareMetalClusterLoadBalancerMetalLbConfigLoadBalancerNodePoolConfig | undefined;
    set internalValue(value: GoogleGkeonpremBareMetalClusterLoadBalancerMetalLbConfigLoadBalancerNodePoolConfig | undefined);
    private _nodePoolConfig;
    get nodePoolConfig(): GoogleGkeonpremBareMetalClusterLoadBalancerMetalLbConfigLoadBalancerNodePoolConfigNodePoolConfigOutputReference;
    putNodePoolConfig(value: GoogleGkeonpremBareMetalClusterLoadBalancerMetalLbConfigLoadBalancerNodePoolConfigNodePoolConfig): void;
    resetNodePoolConfig(): void;
    get nodePoolConfigInput(): GoogleGkeonpremBareMetalClusterLoadBalancerMetalLbConfigLoadBalancerNodePoolConfigNodePoolConfig | undefined;
}
export interface GoogleGkeonpremBareMetalClusterLoadBalancerMetalLbConfig {
    /**
    * address_pools block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gkeonprem_bare_metal_cluster#address_pools GoogleGkeonpremBareMetalCluster#address_pools}
    */
    readonly addressPools: GoogleGkeonpremBareMetalClusterLoadBalancerMetalLbConfigAddressPools[] | cdktf.IResolvable;
    /**
    * load_balancer_node_pool_config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gkeonprem_bare_metal_cluster#load_balancer_node_pool_config GoogleGkeonpremBareMetalCluster#load_balancer_node_pool_config}
    */
    readonly loadBalancerNodePoolConfig?: GoogleGkeonpremBareMetalClusterLoadBalancerMetalLbConfigLoadBalancerNodePoolConfig;
}
export declare function googleGkeonpremBareMetalClusterLoadBalancerMetalLbConfigToTerraform(struct?: GoogleGkeonpremBareMetalClusterLoadBalancerMetalLbConfigOutputReference | GoogleGkeonpremBareMetalClusterLoadBalancerMetalLbConfig): any;
export declare function googleGkeonpremBareMetalClusterLoadBalancerMetalLbConfigToHclTerraform(struct?: GoogleGkeonpremBareMetalClusterLoadBalancerMetalLbConfigOutputReference | GoogleGkeonpremBareMetalClusterLoadBalancerMetalLbConfig): any;
export declare class GoogleGkeonpremBareMetalClusterLoadBalancerMetalLbConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleGkeonpremBareMetalClusterLoadBalancerMetalLbConfig | undefined;
    set internalValue(value: GoogleGkeonpremBareMetalClusterLoadBalancerMetalLbConfig | undefined);
    private _addressPools;
    get addressPools(): GoogleGkeonpremBareMetalClusterLoadBalancerMetalLbConfigAddressPoolsList;
    putAddressPools(value: GoogleGkeonpremBareMetalClusterLoadBalancerMetalLbConfigAddressPools[] | cdktf.IResolvable): void;
    get addressPoolsInput(): cdktf.IResolvable | GoogleGkeonpremBareMetalClusterLoadBalancerMetalLbConfigAddressPools[] | undefined;
    private _loadBalancerNodePoolConfig;
    get loadBalancerNodePoolConfig(): GoogleGkeonpremBareMetalClusterLoadBalancerMetalLbConfigLoadBalancerNodePoolConfigOutputReference;
    putLoadBalancerNodePoolConfig(value: GoogleGkeonpremBareMetalClusterLoadBalancerMetalLbConfigLoadBalancerNodePoolConfig): void;
    resetLoadBalancerNodePoolConfig(): void;
    get loadBalancerNodePoolConfigInput(): GoogleGkeonpremBareMetalClusterLoadBalancerMetalLbConfigLoadBalancerNodePoolConfig | undefined;
}
export interface GoogleGkeonpremBareMetalClusterLoadBalancerPortConfig {
    /**
    * The port that control plane hosted load balancers will listen on.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gkeonprem_bare_metal_cluster#control_plane_load_balancer_port GoogleGkeonpremBareMetalCluster#control_plane_load_balancer_port}
    */
    readonly controlPlaneLoadBalancerPort: number;
}
export declare function googleGkeonpremBareMetalClusterLoadBalancerPortConfigToTerraform(struct?: GoogleGkeonpremBareMetalClusterLoadBalancerPortConfigOutputReference | GoogleGkeonpremBareMetalClusterLoadBalancerPortConfig): any;
export declare function googleGkeonpremBareMetalClusterLoadBalancerPortConfigToHclTerraform(struct?: GoogleGkeonpremBareMetalClusterLoadBalancerPortConfigOutputReference | GoogleGkeonpremBareMetalClusterLoadBalancerPortConfig): any;
export declare class GoogleGkeonpremBareMetalClusterLoadBalancerPortConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleGkeonpremBareMetalClusterLoadBalancerPortConfig | undefined;
    set internalValue(value: GoogleGkeonpremBareMetalClusterLoadBalancerPortConfig | undefined);
    private _controlPlaneLoadBalancerPort?;
    get controlPlaneLoadBalancerPort(): number;
    set controlPlaneLoadBalancerPort(value: number);
    get controlPlaneLoadBalancerPortInput(): number | undefined;
}
export interface GoogleGkeonpremBareMetalClusterLoadBalancerVipConfig {
    /**
    * The VIP which you previously set aside for the Kubernetes API of this Bare Metal User Cluster.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gkeonprem_bare_metal_cluster#control_plane_vip GoogleGkeonpremBareMetalCluster#control_plane_vip}
    */
    readonly controlPlaneVip: string;
    /**
    * The VIP which you previously set aside for ingress traffic into this Bare Metal User Cluster.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gkeonprem_bare_metal_cluster#ingress_vip GoogleGkeonpremBareMetalCluster#ingress_vip}
    */
    readonly ingressVip: string;
}
export declare function googleGkeonpremBareMetalClusterLoadBalancerVipConfigToTerraform(struct?: GoogleGkeonpremBareMetalClusterLoadBalancerVipConfigOutputReference | GoogleGkeonpremBareMetalClusterLoadBalancerVipConfig): any;
export declare function googleGkeonpremBareMetalClusterLoadBalancerVipConfigToHclTerraform(struct?: GoogleGkeonpremBareMetalClusterLoadBalancerVipConfigOutputReference | GoogleGkeonpremBareMetalClusterLoadBalancerVipConfig): any;
export declare class GoogleGkeonpremBareMetalClusterLoadBalancerVipConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleGkeonpremBareMetalClusterLoadBalancerVipConfig | undefined;
    set internalValue(value: GoogleGkeonpremBareMetalClusterLoadBalancerVipConfig | undefined);
    private _controlPlaneVip?;
    get controlPlaneVip(): string;
    set controlPlaneVip(value: string);
    get controlPlaneVipInput(): string | undefined;
    private _ingressVip?;
    get ingressVip(): string;
    set ingressVip(value: string);
    get ingressVipInput(): string | undefined;
}
export interface GoogleGkeonpremBareMetalClusterLoadBalancer {
    /**
    * bgp_lb_config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gkeonprem_bare_metal_cluster#bgp_lb_config GoogleGkeonpremBareMetalCluster#bgp_lb_config}
    */
    readonly bgpLbConfig?: GoogleGkeonpremBareMetalClusterLoadBalancerBgpLbConfig;
    /**
    * manual_lb_config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gkeonprem_bare_metal_cluster#manual_lb_config GoogleGkeonpremBareMetalCluster#manual_lb_config}
    */
    readonly manualLbConfig?: GoogleGkeonpremBareMetalClusterLoadBalancerManualLbConfig;
    /**
    * metal_lb_config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gkeonprem_bare_metal_cluster#metal_lb_config GoogleGkeonpremBareMetalCluster#metal_lb_config}
    */
    readonly metalLbConfig?: GoogleGkeonpremBareMetalClusterLoadBalancerMetalLbConfig;
    /**
    * port_config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gkeonprem_bare_metal_cluster#port_config GoogleGkeonpremBareMetalCluster#port_config}
    */
    readonly portConfig: GoogleGkeonpremBareMetalClusterLoadBalancerPortConfig;
    /**
    * vip_config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gkeonprem_bare_metal_cluster#vip_config GoogleGkeonpremBareMetalCluster#vip_config}
    */
    readonly vipConfig: GoogleGkeonpremBareMetalClusterLoadBalancerVipConfig;
}
export declare function googleGkeonpremBareMetalClusterLoadBalancerToTerraform(struct?: GoogleGkeonpremBareMetalClusterLoadBalancerOutputReference | GoogleGkeonpremBareMetalClusterLoadBalancer): any;
export declare function googleGkeonpremBareMetalClusterLoadBalancerToHclTerraform(struct?: GoogleGkeonpremBareMetalClusterLoadBalancerOutputReference | GoogleGkeonpremBareMetalClusterLoadBalancer): any;
export declare class GoogleGkeonpremBareMetalClusterLoadBalancerOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleGkeonpremBareMetalClusterLoadBalancer | undefined;
    set internalValue(value: GoogleGkeonpremBareMetalClusterLoadBalancer | undefined);
    private _bgpLbConfig;
    get bgpLbConfig(): GoogleGkeonpremBareMetalClusterLoadBalancerBgpLbConfigOutputReference;
    putBgpLbConfig(value: GoogleGkeonpremBareMetalClusterLoadBalancerBgpLbConfig): void;
    resetBgpLbConfig(): void;
    get bgpLbConfigInput(): GoogleGkeonpremBareMetalClusterLoadBalancerBgpLbConfig | undefined;
    private _manualLbConfig;
    get manualLbConfig(): GoogleGkeonpremBareMetalClusterLoadBalancerManualLbConfigOutputReference;
    putManualLbConfig(value: GoogleGkeonpremBareMetalClusterLoadBalancerManualLbConfig): void;
    resetManualLbConfig(): void;
    get manualLbConfigInput(): GoogleGkeonpremBareMetalClusterLoadBalancerManualLbConfig | undefined;
    private _metalLbConfig;
    get metalLbConfig(): GoogleGkeonpremBareMetalClusterLoadBalancerMetalLbConfigOutputReference;
    putMetalLbConfig(value: GoogleGkeonpremBareMetalClusterLoadBalancerMetalLbConfig): void;
    resetMetalLbConfig(): void;
    get metalLbConfigInput(): GoogleGkeonpremBareMetalClusterLoadBalancerMetalLbConfig | undefined;
    private _portConfig;
    get portConfig(): GoogleGkeonpremBareMetalClusterLoadBalancerPortConfigOutputReference;
    putPortConfig(value: GoogleGkeonpremBareMetalClusterLoadBalancerPortConfig): void;
    get portConfigInput(): GoogleGkeonpremBareMetalClusterLoadBalancerPortConfig | undefined;
    private _vipConfig;
    get vipConfig(): GoogleGkeonpremBareMetalClusterLoadBalancerVipConfigOutputReference;
    putVipConfig(value: GoogleGkeonpremBareMetalClusterLoadBalancerVipConfig): void;
    get vipConfigInput(): GoogleGkeonpremBareMetalClusterLoadBalancerVipConfig | undefined;
}
export interface GoogleGkeonpremBareMetalClusterMaintenanceConfig {
    /**
    * All IPv4 address from these ranges will be placed into maintenance mode.
    * Nodes in maintenance mode will be cordoned and drained. When both of these
    * are true, the "baremetal.cluster.gke.io/maintenance" annotation will be set
    * on the node resource.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gkeonprem_bare_metal_cluster#maintenance_address_cidr_blocks GoogleGkeonpremBareMetalCluster#maintenance_address_cidr_blocks}
    */
    readonly maintenanceAddressCidrBlocks: string[];
}
export declare function googleGkeonpremBareMetalClusterMaintenanceConfigToTerraform(struct?: GoogleGkeonpremBareMetalClusterMaintenanceConfigOutputReference | GoogleGkeonpremBareMetalClusterMaintenanceConfig): any;
export declare function googleGkeonpremBareMetalClusterMaintenanceConfigToHclTerraform(struct?: GoogleGkeonpremBareMetalClusterMaintenanceConfigOutputReference | GoogleGkeonpremBareMetalClusterMaintenanceConfig): any;
export declare class GoogleGkeonpremBareMetalClusterMaintenanceConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleGkeonpremBareMetalClusterMaintenanceConfig | undefined;
    set internalValue(value: GoogleGkeonpremBareMetalClusterMaintenanceConfig | undefined);
    private _maintenanceAddressCidrBlocks?;
    get maintenanceAddressCidrBlocks(): string[];
    set maintenanceAddressCidrBlocks(value: string[]);
    get maintenanceAddressCidrBlocksInput(): string[] | undefined;
}
export interface GoogleGkeonpremBareMetalClusterNetworkConfigIslandModeCidr {
    /**
    * All pods in the cluster are assigned an RFC1918 IPv4 address from these ranges. This field cannot be changed after creation.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gkeonprem_bare_metal_cluster#pod_address_cidr_blocks GoogleGkeonpremBareMetalCluster#pod_address_cidr_blocks}
    */
    readonly podAddressCidrBlocks: string[];
    /**
    * All services in the cluster are assigned an RFC1918 IPv4 address from these ranges. This field cannot be changed after creation.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gkeonprem_bare_metal_cluster#service_address_cidr_blocks GoogleGkeonpremBareMetalCluster#service_address_cidr_blocks}
    */
    readonly serviceAddressCidrBlocks: string[];
}
export declare function googleGkeonpremBareMetalClusterNetworkConfigIslandModeCidrToTerraform(struct?: GoogleGkeonpremBareMetalClusterNetworkConfigIslandModeCidrOutputReference | GoogleGkeonpremBareMetalClusterNetworkConfigIslandModeCidr): any;
export declare function googleGkeonpremBareMetalClusterNetworkConfigIslandModeCidrToHclTerraform(struct?: GoogleGkeonpremBareMetalClusterNetworkConfigIslandModeCidrOutputReference | GoogleGkeonpremBareMetalClusterNetworkConfigIslandModeCidr): any;
export declare class GoogleGkeonpremBareMetalClusterNetworkConfigIslandModeCidrOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleGkeonpremBareMetalClusterNetworkConfigIslandModeCidr | undefined;
    set internalValue(value: GoogleGkeonpremBareMetalClusterNetworkConfigIslandModeCidr | undefined);
    private _podAddressCidrBlocks?;
    get podAddressCidrBlocks(): string[];
    set podAddressCidrBlocks(value: string[]);
    get podAddressCidrBlocksInput(): string[] | undefined;
    private _serviceAddressCidrBlocks?;
    get serviceAddressCidrBlocks(): string[];
    set serviceAddressCidrBlocks(value: string[]);
    get serviceAddressCidrBlocksInput(): string[] | undefined;
}
export interface GoogleGkeonpremBareMetalClusterNetworkConfigMultipleNetworkInterfacesConfig {
    /**
    * Whether to enable multiple network interfaces for your pods.
    * When set network_config.advanced_networking is automatically
    * set to true.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gkeonprem_bare_metal_cluster#enabled GoogleGkeonpremBareMetalCluster#enabled}
    */
    readonly enabled?: boolean | cdktf.IResolvable;
}
export declare function googleGkeonpremBareMetalClusterNetworkConfigMultipleNetworkInterfacesConfigToTerraform(struct?: GoogleGkeonpremBareMetalClusterNetworkConfigMultipleNetworkInterfacesConfigOutputReference | GoogleGkeonpremBareMetalClusterNetworkConfigMultipleNetworkInterfacesConfig): any;
export declare function googleGkeonpremBareMetalClusterNetworkConfigMultipleNetworkInterfacesConfigToHclTerraform(struct?: GoogleGkeonpremBareMetalClusterNetworkConfigMultipleNetworkInterfacesConfigOutputReference | GoogleGkeonpremBareMetalClusterNetworkConfigMultipleNetworkInterfacesConfig): any;
export declare class GoogleGkeonpremBareMetalClusterNetworkConfigMultipleNetworkInterfacesConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleGkeonpremBareMetalClusterNetworkConfigMultipleNetworkInterfacesConfig | undefined;
    set internalValue(value: GoogleGkeonpremBareMetalClusterNetworkConfigMultipleNetworkInterfacesConfig | undefined);
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    resetEnabled(): void;
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
}
export interface GoogleGkeonpremBareMetalClusterNetworkConfigSrIovConfig {
    /**
    * Whether to install the SR-IOV operator.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gkeonprem_bare_metal_cluster#enabled GoogleGkeonpremBareMetalCluster#enabled}
    */
    readonly enabled?: boolean | cdktf.IResolvable;
}
export declare function googleGkeonpremBareMetalClusterNetworkConfigSrIovConfigToTerraform(struct?: GoogleGkeonpremBareMetalClusterNetworkConfigSrIovConfigOutputReference | GoogleGkeonpremBareMetalClusterNetworkConfigSrIovConfig): any;
export declare function googleGkeonpremBareMetalClusterNetworkConfigSrIovConfigToHclTerraform(struct?: GoogleGkeonpremBareMetalClusterNetworkConfigSrIovConfigOutputReference | GoogleGkeonpremBareMetalClusterNetworkConfigSrIovConfig): any;
export declare class GoogleGkeonpremBareMetalClusterNetworkConfigSrIovConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleGkeonpremBareMetalClusterNetworkConfigSrIovConfig | undefined;
    set internalValue(value: GoogleGkeonpremBareMetalClusterNetworkConfigSrIovConfig | undefined);
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    resetEnabled(): void;
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
}
export interface GoogleGkeonpremBareMetalClusterNetworkConfig {
    /**
    * Enables the use of advanced Anthos networking features, such as Bundled
    * Load Balancing with BGP or the egress NAT gateway.
    * Setting configuration for advanced networking features will automatically
    * set this flag.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gkeonprem_bare_metal_cluster#advanced_networking GoogleGkeonpremBareMetalCluster#advanced_networking}
    */
    readonly advancedNetworking?: boolean | cdktf.IResolvable;
    /**
    * island_mode_cidr block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gkeonprem_bare_metal_cluster#island_mode_cidr GoogleGkeonpremBareMetalCluster#island_mode_cidr}
    */
    readonly islandModeCidr?: GoogleGkeonpremBareMetalClusterNetworkConfigIslandModeCidr;
    /**
    * multiple_network_interfaces_config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gkeonprem_bare_metal_cluster#multiple_network_interfaces_config GoogleGkeonpremBareMetalCluster#multiple_network_interfaces_config}
    */
    readonly multipleNetworkInterfacesConfig?: GoogleGkeonpremBareMetalClusterNetworkConfigMultipleNetworkInterfacesConfig;
    /**
    * sr_iov_config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gkeonprem_bare_metal_cluster#sr_iov_config GoogleGkeonpremBareMetalCluster#sr_iov_config}
    */
    readonly srIovConfig?: GoogleGkeonpremBareMetalClusterNetworkConfigSrIovConfig;
}
export declare function googleGkeonpremBareMetalClusterNetworkConfigToTerraform(struct?: GoogleGkeonpremBareMetalClusterNetworkConfigOutputReference | GoogleGkeonpremBareMetalClusterNetworkConfig): any;
export declare function googleGkeonpremBareMetalClusterNetworkConfigToHclTerraform(struct?: GoogleGkeonpremBareMetalClusterNetworkConfigOutputReference | GoogleGkeonpremBareMetalClusterNetworkConfig): any;
export declare class GoogleGkeonpremBareMetalClusterNetworkConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleGkeonpremBareMetalClusterNetworkConfig | undefined;
    set internalValue(value: GoogleGkeonpremBareMetalClusterNetworkConfig | undefined);
    private _advancedNetworking?;
    get advancedNetworking(): boolean | cdktf.IResolvable;
    set advancedNetworking(value: boolean | cdktf.IResolvable);
    resetAdvancedNetworking(): void;
    get advancedNetworkingInput(): boolean | cdktf.IResolvable | undefined;
    private _islandModeCidr;
    get islandModeCidr(): GoogleGkeonpremBareMetalClusterNetworkConfigIslandModeCidrOutputReference;
    putIslandModeCidr(value: GoogleGkeonpremBareMetalClusterNetworkConfigIslandModeCidr): void;
    resetIslandModeCidr(): void;
    get islandModeCidrInput(): GoogleGkeonpremBareMetalClusterNetworkConfigIslandModeCidr | undefined;
    private _multipleNetworkInterfacesConfig;
    get multipleNetworkInterfacesConfig(): GoogleGkeonpremBareMetalClusterNetworkConfigMultipleNetworkInterfacesConfigOutputReference;
    putMultipleNetworkInterfacesConfig(value: GoogleGkeonpremBareMetalClusterNetworkConfigMultipleNetworkInterfacesConfig): void;
    resetMultipleNetworkInterfacesConfig(): void;
    get multipleNetworkInterfacesConfigInput(): GoogleGkeonpremBareMetalClusterNetworkConfigMultipleNetworkInterfacesConfig | undefined;
    private _srIovConfig;
    get srIovConfig(): GoogleGkeonpremBareMetalClusterNetworkConfigSrIovConfigOutputReference;
    putSrIovConfig(value: GoogleGkeonpremBareMetalClusterNetworkConfigSrIovConfig): void;
    resetSrIovConfig(): void;
    get srIovConfigInput(): GoogleGkeonpremBareMetalClusterNetworkConfigSrIovConfig | undefined;
}
export interface GoogleGkeonpremBareMetalClusterNodeAccessConfig {
    /**
    * LoginUser is the user name used to access node machines.
    * It defaults to "root" if not set.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gkeonprem_bare_metal_cluster#login_user GoogleGkeonpremBareMetalCluster#login_user}
    */
    readonly loginUser?: string;
}
export declare function googleGkeonpremBareMetalClusterNodeAccessConfigToTerraform(struct?: GoogleGkeonpremBareMetalClusterNodeAccessConfigOutputReference | GoogleGkeonpremBareMetalClusterNodeAccessConfig): any;
export declare function googleGkeonpremBareMetalClusterNodeAccessConfigToHclTerraform(struct?: GoogleGkeonpremBareMetalClusterNodeAccessConfigOutputReference | GoogleGkeonpremBareMetalClusterNodeAccessConfig): any;
export declare class GoogleGkeonpremBareMetalClusterNodeAccessConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleGkeonpremBareMetalClusterNodeAccessConfig | undefined;
    set internalValue(value: GoogleGkeonpremBareMetalClusterNodeAccessConfig | undefined);
    private _loginUser?;
    get loginUser(): string;
    set loginUser(value: string);
    resetLoginUser(): void;
    get loginUserInput(): string | undefined;
}
export interface GoogleGkeonpremBareMetalClusterNodeConfig {
    /**
    * The available runtimes that can be used to run containers in a Bare Metal User Cluster. Possible values: ["CONTAINER_RUNTIME_UNSPECIFIED", "DOCKER", "CONTAINERD"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gkeonprem_bare_metal_cluster#container_runtime GoogleGkeonpremBareMetalCluster#container_runtime}
    */
    readonly containerRuntime?: string;
    /**
    * The maximum number of pods a node can run. The size of the CIDR range
    * assigned to the node will be derived from this parameter.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gkeonprem_bare_metal_cluster#max_pods_per_node GoogleGkeonpremBareMetalCluster#max_pods_per_node}
    */
    readonly maxPodsPerNode?: number;
}
export declare function googleGkeonpremBareMetalClusterNodeConfigToTerraform(struct?: GoogleGkeonpremBareMetalClusterNodeConfigOutputReference | GoogleGkeonpremBareMetalClusterNodeConfig): any;
export declare function googleGkeonpremBareMetalClusterNodeConfigToHclTerraform(struct?: GoogleGkeonpremBareMetalClusterNodeConfigOutputReference | GoogleGkeonpremBareMetalClusterNodeConfig): any;
export declare class GoogleGkeonpremBareMetalClusterNodeConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleGkeonpremBareMetalClusterNodeConfig | undefined;
    set internalValue(value: GoogleGkeonpremBareMetalClusterNodeConfig | undefined);
    private _containerRuntime?;
    get containerRuntime(): string;
    set containerRuntime(value: string);
    resetContainerRuntime(): void;
    get containerRuntimeInput(): string | undefined;
    private _maxPodsPerNode?;
    get maxPodsPerNode(): number;
    set maxPodsPerNode(value: number);
    resetMaxPodsPerNode(): void;
    get maxPodsPerNodeInput(): number | undefined;
}
export interface GoogleGkeonpremBareMetalClusterOsEnvironmentConfig {
    /**
    * Whether the package repo should not be included when initializing
    * bare metal machines.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gkeonprem_bare_metal_cluster#package_repo_excluded GoogleGkeonpremBareMetalCluster#package_repo_excluded}
    */
    readonly packageRepoExcluded: boolean | cdktf.IResolvable;
}
export declare function googleGkeonpremBareMetalClusterOsEnvironmentConfigToTerraform(struct?: GoogleGkeonpremBareMetalClusterOsEnvironmentConfigOutputReference | GoogleGkeonpremBareMetalClusterOsEnvironmentConfig): any;
export declare function googleGkeonpremBareMetalClusterOsEnvironmentConfigToHclTerraform(struct?: GoogleGkeonpremBareMetalClusterOsEnvironmentConfigOutputReference | GoogleGkeonpremBareMetalClusterOsEnvironmentConfig): any;
export declare class GoogleGkeonpremBareMetalClusterOsEnvironmentConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleGkeonpremBareMetalClusterOsEnvironmentConfig | undefined;
    set internalValue(value: GoogleGkeonpremBareMetalClusterOsEnvironmentConfig | undefined);
    private _packageRepoExcluded?;
    get packageRepoExcluded(): boolean | cdktf.IResolvable;
    set packageRepoExcluded(value: boolean | cdktf.IResolvable);
    get packageRepoExcludedInput(): boolean | cdktf.IResolvable | undefined;
}
export interface GoogleGkeonpremBareMetalClusterProxy {
    /**
    * A list of IPs, hostnames, and domains that should skip the proxy.
    * Examples: ["127.0.0.1", "example.com", ".corp", "localhost"].
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gkeonprem_bare_metal_cluster#no_proxy GoogleGkeonpremBareMetalCluster#no_proxy}
    */
    readonly noProxy?: string[];
    /**
    * Specifies the address of your proxy server.
    * Examples: http://domain
    * WARNING: Do not provide credentials in the format
    * http://(username:password@)domain these will be rejected by the server.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gkeonprem_bare_metal_cluster#uri GoogleGkeonpremBareMetalCluster#uri}
    */
    readonly uri: string;
}
export declare function googleGkeonpremBareMetalClusterProxyToTerraform(struct?: GoogleGkeonpremBareMetalClusterProxyOutputReference | GoogleGkeonpremBareMetalClusterProxy): any;
export declare function googleGkeonpremBareMetalClusterProxyToHclTerraform(struct?: GoogleGkeonpremBareMetalClusterProxyOutputReference | GoogleGkeonpremBareMetalClusterProxy): any;
export declare class GoogleGkeonpremBareMetalClusterProxyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleGkeonpremBareMetalClusterProxy | undefined;
    set internalValue(value: GoogleGkeonpremBareMetalClusterProxy | undefined);
    private _noProxy?;
    get noProxy(): string[];
    set noProxy(value: string[]);
    resetNoProxy(): void;
    get noProxyInput(): string[] | undefined;
    private _uri?;
    get uri(): string;
    set uri(value: string);
    get uriInput(): string | undefined;
}
export interface GoogleGkeonpremBareMetalClusterSecurityConfigAuthorizationAdminUsers {
    /**
    * The name of the user, e.g. 'my-gcp-id@gmail.com'.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gkeonprem_bare_metal_cluster#username GoogleGkeonpremBareMetalCluster#username}
    */
    readonly username: string;
}
export declare function googleGkeonpremBareMetalClusterSecurityConfigAuthorizationAdminUsersToTerraform(struct?: GoogleGkeonpremBareMetalClusterSecurityConfigAuthorizationAdminUsers | cdktf.IResolvable): any;
export declare function googleGkeonpremBareMetalClusterSecurityConfigAuthorizationAdminUsersToHclTerraform(struct?: GoogleGkeonpremBareMetalClusterSecurityConfigAuthorizationAdminUsers | cdktf.IResolvable): any;
export declare class GoogleGkeonpremBareMetalClusterSecurityConfigAuthorizationAdminUsersOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleGkeonpremBareMetalClusterSecurityConfigAuthorizationAdminUsers | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleGkeonpremBareMetalClusterSecurityConfigAuthorizationAdminUsers | cdktf.IResolvable | undefined);
    private _username?;
    get username(): string;
    set username(value: string);
    get usernameInput(): string | undefined;
}
export declare class GoogleGkeonpremBareMetalClusterSecurityConfigAuthorizationAdminUsersList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleGkeonpremBareMetalClusterSecurityConfigAuthorizationAdminUsers[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleGkeonpremBareMetalClusterSecurityConfigAuthorizationAdminUsersOutputReference;
}
export interface GoogleGkeonpremBareMetalClusterSecurityConfigAuthorization {
    /**
    * admin_users block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gkeonprem_bare_metal_cluster#admin_users GoogleGkeonpremBareMetalCluster#admin_users}
    */
    readonly adminUsers: GoogleGkeonpremBareMetalClusterSecurityConfigAuthorizationAdminUsers[] | cdktf.IResolvable;
}
export declare function googleGkeonpremBareMetalClusterSecurityConfigAuthorizationToTerraform(struct?: GoogleGkeonpremBareMetalClusterSecurityConfigAuthorizationOutputReference | GoogleGkeonpremBareMetalClusterSecurityConfigAuthorization): any;
export declare function googleGkeonpremBareMetalClusterSecurityConfigAuthorizationToHclTerraform(struct?: GoogleGkeonpremBareMetalClusterSecurityConfigAuthorizationOutputReference | GoogleGkeonpremBareMetalClusterSecurityConfigAuthorization): any;
export declare class GoogleGkeonpremBareMetalClusterSecurityConfigAuthorizationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleGkeonpremBareMetalClusterSecurityConfigAuthorization | undefined;
    set internalValue(value: GoogleGkeonpremBareMetalClusterSecurityConfigAuthorization | undefined);
    private _adminUsers;
    get adminUsers(): GoogleGkeonpremBareMetalClusterSecurityConfigAuthorizationAdminUsersList;
    putAdminUsers(value: GoogleGkeonpremBareMetalClusterSecurityConfigAuthorizationAdminUsers[] | cdktf.IResolvable): void;
    get adminUsersInput(): cdktf.IResolvable | GoogleGkeonpremBareMetalClusterSecurityConfigAuthorizationAdminUsers[] | undefined;
}
export interface GoogleGkeonpremBareMetalClusterSecurityConfig {
    /**
    * authorization block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gkeonprem_bare_metal_cluster#authorization GoogleGkeonpremBareMetalCluster#authorization}
    */
    readonly authorization?: GoogleGkeonpremBareMetalClusterSecurityConfigAuthorization;
}
export declare function googleGkeonpremBareMetalClusterSecurityConfigToTerraform(struct?: GoogleGkeonpremBareMetalClusterSecurityConfigOutputReference | GoogleGkeonpremBareMetalClusterSecurityConfig): any;
export declare function googleGkeonpremBareMetalClusterSecurityConfigToHclTerraform(struct?: GoogleGkeonpremBareMetalClusterSecurityConfigOutputReference | GoogleGkeonpremBareMetalClusterSecurityConfig): any;
export declare class GoogleGkeonpremBareMetalClusterSecurityConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleGkeonpremBareMetalClusterSecurityConfig | undefined;
    set internalValue(value: GoogleGkeonpremBareMetalClusterSecurityConfig | undefined);
    private _authorization;
    get authorization(): GoogleGkeonpremBareMetalClusterSecurityConfigAuthorizationOutputReference;
    putAuthorization(value: GoogleGkeonpremBareMetalClusterSecurityConfigAuthorization): void;
    resetAuthorization(): void;
    get authorizationInput(): GoogleGkeonpremBareMetalClusterSecurityConfigAuthorization | undefined;
}
export interface GoogleGkeonpremBareMetalClusterStorageLvpNodeMountsConfig {
    /**
    * The host machine path.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gkeonprem_bare_metal_cluster#path GoogleGkeonpremBareMetalCluster#path}
    */
    readonly path: string;
    /**
    * The StorageClass name that PVs will be created with.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gkeonprem_bare_metal_cluster#storage_class GoogleGkeonpremBareMetalCluster#storage_class}
    */
    readonly storageClass: string;
}
export declare function googleGkeonpremBareMetalClusterStorageLvpNodeMountsConfigToTerraform(struct?: GoogleGkeonpremBareMetalClusterStorageLvpNodeMountsConfigOutputReference | GoogleGkeonpremBareMetalClusterStorageLvpNodeMountsConfig): any;
export declare function googleGkeonpremBareMetalClusterStorageLvpNodeMountsConfigToHclTerraform(struct?: GoogleGkeonpremBareMetalClusterStorageLvpNodeMountsConfigOutputReference | GoogleGkeonpremBareMetalClusterStorageLvpNodeMountsConfig): any;
export declare class GoogleGkeonpremBareMetalClusterStorageLvpNodeMountsConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleGkeonpremBareMetalClusterStorageLvpNodeMountsConfig | undefined;
    set internalValue(value: GoogleGkeonpremBareMetalClusterStorageLvpNodeMountsConfig | undefined);
    private _path?;
    get path(): string;
    set path(value: string);
    get pathInput(): string | undefined;
    private _storageClass?;
    get storageClass(): string;
    set storageClass(value: string);
    get storageClassInput(): string | undefined;
}
export interface GoogleGkeonpremBareMetalClusterStorageLvpShareConfigLvpConfig {
    /**
    * The host machine path.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gkeonprem_bare_metal_cluster#path GoogleGkeonpremBareMetalCluster#path}
    */
    readonly path: string;
    /**
    * The StorageClass name that PVs will be created with.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gkeonprem_bare_metal_cluster#storage_class GoogleGkeonpremBareMetalCluster#storage_class}
    */
    readonly storageClass: string;
}
export declare function googleGkeonpremBareMetalClusterStorageLvpShareConfigLvpConfigToTerraform(struct?: GoogleGkeonpremBareMetalClusterStorageLvpShareConfigLvpConfigOutputReference | GoogleGkeonpremBareMetalClusterStorageLvpShareConfigLvpConfig): any;
export declare function googleGkeonpremBareMetalClusterStorageLvpShareConfigLvpConfigToHclTerraform(struct?: GoogleGkeonpremBareMetalClusterStorageLvpShareConfigLvpConfigOutputReference | GoogleGkeonpremBareMetalClusterStorageLvpShareConfigLvpConfig): any;
export declare class GoogleGkeonpremBareMetalClusterStorageLvpShareConfigLvpConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleGkeonpremBareMetalClusterStorageLvpShareConfigLvpConfig | undefined;
    set internalValue(value: GoogleGkeonpremBareMetalClusterStorageLvpShareConfigLvpConfig | undefined);
    private _path?;
    get path(): string;
    set path(value: string);
    get pathInput(): string | undefined;
    private _storageClass?;
    get storageClass(): string;
    set storageClass(value: string);
    get storageClassInput(): string | undefined;
}
export interface GoogleGkeonpremBareMetalClusterStorageLvpShareConfig {
    /**
    * The number of subdirectories to create under path.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gkeonprem_bare_metal_cluster#shared_path_pv_count GoogleGkeonpremBareMetalCluster#shared_path_pv_count}
    */
    readonly sharedPathPvCount?: number;
    /**
    * lvp_config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gkeonprem_bare_metal_cluster#lvp_config GoogleGkeonpremBareMetalCluster#lvp_config}
    */
    readonly lvpConfig: GoogleGkeonpremBareMetalClusterStorageLvpShareConfigLvpConfig;
}
export declare function googleGkeonpremBareMetalClusterStorageLvpShareConfigToTerraform(struct?: GoogleGkeonpremBareMetalClusterStorageLvpShareConfigOutputReference | GoogleGkeonpremBareMetalClusterStorageLvpShareConfig): any;
export declare function googleGkeonpremBareMetalClusterStorageLvpShareConfigToHclTerraform(struct?: GoogleGkeonpremBareMetalClusterStorageLvpShareConfigOutputReference | GoogleGkeonpremBareMetalClusterStorageLvpShareConfig): any;
export declare class GoogleGkeonpremBareMetalClusterStorageLvpShareConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleGkeonpremBareMetalClusterStorageLvpShareConfig | undefined;
    set internalValue(value: GoogleGkeonpremBareMetalClusterStorageLvpShareConfig | undefined);
    private _sharedPathPvCount?;
    get sharedPathPvCount(): number;
    set sharedPathPvCount(value: number);
    resetSharedPathPvCount(): void;
    get sharedPathPvCountInput(): number | undefined;
    private _lvpConfig;
    get lvpConfig(): GoogleGkeonpremBareMetalClusterStorageLvpShareConfigLvpConfigOutputReference;
    putLvpConfig(value: GoogleGkeonpremBareMetalClusterStorageLvpShareConfigLvpConfig): void;
    get lvpConfigInput(): GoogleGkeonpremBareMetalClusterStorageLvpShareConfigLvpConfig | undefined;
}
export interface GoogleGkeonpremBareMetalClusterStorage {
    /**
    * lvp_node_mounts_config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gkeonprem_bare_metal_cluster#lvp_node_mounts_config GoogleGkeonpremBareMetalCluster#lvp_node_mounts_config}
    */
    readonly lvpNodeMountsConfig: GoogleGkeonpremBareMetalClusterStorageLvpNodeMountsConfig;
    /**
    * lvp_share_config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gkeonprem_bare_metal_cluster#lvp_share_config GoogleGkeonpremBareMetalCluster#lvp_share_config}
    */
    readonly lvpShareConfig: GoogleGkeonpremBareMetalClusterStorageLvpShareConfig;
}
export declare function googleGkeonpremBareMetalClusterStorageToTerraform(struct?: GoogleGkeonpremBareMetalClusterStorageOutputReference | GoogleGkeonpremBareMetalClusterStorage): any;
export declare function googleGkeonpremBareMetalClusterStorageToHclTerraform(struct?: GoogleGkeonpremBareMetalClusterStorageOutputReference | GoogleGkeonpremBareMetalClusterStorage): any;
export declare class GoogleGkeonpremBareMetalClusterStorageOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleGkeonpremBareMetalClusterStorage | undefined;
    set internalValue(value: GoogleGkeonpremBareMetalClusterStorage | undefined);
    private _lvpNodeMountsConfig;
    get lvpNodeMountsConfig(): GoogleGkeonpremBareMetalClusterStorageLvpNodeMountsConfigOutputReference;
    putLvpNodeMountsConfig(value: GoogleGkeonpremBareMetalClusterStorageLvpNodeMountsConfig): void;
    get lvpNodeMountsConfigInput(): GoogleGkeonpremBareMetalClusterStorageLvpNodeMountsConfig | undefined;
    private _lvpShareConfig;
    get lvpShareConfig(): GoogleGkeonpremBareMetalClusterStorageLvpShareConfigOutputReference;
    putLvpShareConfig(value: GoogleGkeonpremBareMetalClusterStorageLvpShareConfig): void;
    get lvpShareConfigInput(): GoogleGkeonpremBareMetalClusterStorageLvpShareConfig | undefined;
}
export interface GoogleGkeonpremBareMetalClusterTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gkeonprem_bare_metal_cluster#create GoogleGkeonpremBareMetalCluster#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gkeonprem_bare_metal_cluster#delete GoogleGkeonpremBareMetalCluster#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gkeonprem_bare_metal_cluster#update GoogleGkeonpremBareMetalCluster#update}
    */
    readonly update?: string;
}
export declare function googleGkeonpremBareMetalClusterTimeoutsToTerraform(struct?: GoogleGkeonpremBareMetalClusterTimeouts | cdktf.IResolvable): any;
export declare function googleGkeonpremBareMetalClusterTimeoutsToHclTerraform(struct?: GoogleGkeonpremBareMetalClusterTimeouts | cdktf.IResolvable): any;
export declare class GoogleGkeonpremBareMetalClusterTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleGkeonpremBareMetalClusterTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleGkeonpremBareMetalClusterTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
export interface GoogleGkeonpremBareMetalClusterUpgradePolicy {
    /**
    * Specifies which upgrade policy to use. Possible values: ["SERIAL", "CONCURRENT"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gkeonprem_bare_metal_cluster#policy GoogleGkeonpremBareMetalCluster#policy}
    */
    readonly policy?: string;
}
export declare function googleGkeonpremBareMetalClusterUpgradePolicyToTerraform(struct?: GoogleGkeonpremBareMetalClusterUpgradePolicyOutputReference | GoogleGkeonpremBareMetalClusterUpgradePolicy): any;
export declare function googleGkeonpremBareMetalClusterUpgradePolicyToHclTerraform(struct?: GoogleGkeonpremBareMetalClusterUpgradePolicyOutputReference | GoogleGkeonpremBareMetalClusterUpgradePolicy): any;
export declare class GoogleGkeonpremBareMetalClusterUpgradePolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleGkeonpremBareMetalClusterUpgradePolicy | undefined;
    set internalValue(value: GoogleGkeonpremBareMetalClusterUpgradePolicy | undefined);
    private _policy?;
    get policy(): string;
    set policy(value: string);
    resetPolicy(): void;
    get policyInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gkeonprem_bare_metal_cluster google_gkeonprem_bare_metal_cluster}
*/
export declare class GoogleGkeonpremBareMetalCluster extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_gkeonprem_bare_metal_cluster";
    /**
    * Generates CDKTF code for importing a GoogleGkeonpremBareMetalCluster resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the GoogleGkeonpremBareMetalCluster to import
    * @param importFromId The id of the existing GoogleGkeonpremBareMetalCluster that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gkeonprem_bare_metal_cluster#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the GoogleGkeonpremBareMetalCluster to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gkeonprem_bare_metal_cluster google_gkeonprem_bare_metal_cluster} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleGkeonpremBareMetalClusterConfig
    */
    constructor(scope: Construct, id: string, config: GoogleGkeonpremBareMetalClusterConfig);
    private _adminClusterMembership?;
    get adminClusterMembership(): string;
    set adminClusterMembership(value: string);
    get adminClusterMembershipInput(): string | undefined;
    private _annotations?;
    get annotations(): {
        [key: string]: string;
    };
    set annotations(value: {
        [key: string]: string;
    });
    resetAnnotations(): void;
    get annotationsInput(): {
        [key: string]: string;
    } | undefined;
    private _bareMetalVersion?;
    get bareMetalVersion(): string;
    set bareMetalVersion(value: string);
    get bareMetalVersionInput(): string | undefined;
    get createTime(): string;
    get deleteTime(): string;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _effectiveAnnotations;
    get effectiveAnnotations(): cdktf.StringMap;
    get endpoint(): string;
    get etag(): string;
    private _fleet;
    get fleet(): GoogleGkeonpremBareMetalClusterFleetList;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get localName(): string;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    get reconciling(): cdktf.IResolvable;
    get state(): string;
    private _status;
    get status(): GoogleGkeonpremBareMetalClusterStatusList;
    get uid(): string;
    get updateTime(): string;
    private _validationCheck;
    get validationCheck(): GoogleGkeonpremBareMetalClusterValidationCheckList;
    private _binaryAuthorization;
    get binaryAuthorization(): GoogleGkeonpremBareMetalClusterBinaryAuthorizationOutputReference;
    putBinaryAuthorization(value: GoogleGkeonpremBareMetalClusterBinaryAuthorization): void;
    resetBinaryAuthorization(): void;
    get binaryAuthorizationInput(): GoogleGkeonpremBareMetalClusterBinaryAuthorization | undefined;
    private _clusterOperations;
    get clusterOperations(): GoogleGkeonpremBareMetalClusterClusterOperationsOutputReference;
    putClusterOperations(value: GoogleGkeonpremBareMetalClusterClusterOperations): void;
    resetClusterOperations(): void;
    get clusterOperationsInput(): GoogleGkeonpremBareMetalClusterClusterOperations | undefined;
    private _controlPlane;
    get controlPlane(): GoogleGkeonpremBareMetalClusterControlPlaneOutputReference;
    putControlPlane(value: GoogleGkeonpremBareMetalClusterControlPlane): void;
    get controlPlaneInput(): GoogleGkeonpremBareMetalClusterControlPlane | undefined;
    private _loadBalancer;
    get loadBalancer(): GoogleGkeonpremBareMetalClusterLoadBalancerOutputReference;
    putLoadBalancer(value: GoogleGkeonpremBareMetalClusterLoadBalancer): void;
    get loadBalancerInput(): GoogleGkeonpremBareMetalClusterLoadBalancer | undefined;
    private _maintenanceConfig;
    get maintenanceConfig(): GoogleGkeonpremBareMetalClusterMaintenanceConfigOutputReference;
    putMaintenanceConfig(value: GoogleGkeonpremBareMetalClusterMaintenanceConfig): void;
    resetMaintenanceConfig(): void;
    get maintenanceConfigInput(): GoogleGkeonpremBareMetalClusterMaintenanceConfig | undefined;
    private _networkConfig;
    get networkConfig(): GoogleGkeonpremBareMetalClusterNetworkConfigOutputReference;
    putNetworkConfig(value: GoogleGkeonpremBareMetalClusterNetworkConfig): void;
    get networkConfigInput(): GoogleGkeonpremBareMetalClusterNetworkConfig | undefined;
    private _nodeAccessConfig;
    get nodeAccessConfig(): GoogleGkeonpremBareMetalClusterNodeAccessConfigOutputReference;
    putNodeAccessConfig(value: GoogleGkeonpremBareMetalClusterNodeAccessConfig): void;
    resetNodeAccessConfig(): void;
    get nodeAccessConfigInput(): GoogleGkeonpremBareMetalClusterNodeAccessConfig | undefined;
    private _nodeConfig;
    get nodeConfig(): GoogleGkeonpremBareMetalClusterNodeConfigOutputReference;
    putNodeConfig(value: GoogleGkeonpremBareMetalClusterNodeConfig): void;
    resetNodeConfig(): void;
    get nodeConfigInput(): GoogleGkeonpremBareMetalClusterNodeConfig | undefined;
    private _osEnvironmentConfig;
    get osEnvironmentConfig(): GoogleGkeonpremBareMetalClusterOsEnvironmentConfigOutputReference;
    putOsEnvironmentConfig(value: GoogleGkeonpremBareMetalClusterOsEnvironmentConfig): void;
    resetOsEnvironmentConfig(): void;
    get osEnvironmentConfigInput(): GoogleGkeonpremBareMetalClusterOsEnvironmentConfig | undefined;
    private _proxy;
    get proxy(): GoogleGkeonpremBareMetalClusterProxyOutputReference;
    putProxy(value: GoogleGkeonpremBareMetalClusterProxy): void;
    resetProxy(): void;
    get proxyInput(): GoogleGkeonpremBareMetalClusterProxy | undefined;
    private _securityConfig;
    get securityConfig(): GoogleGkeonpremBareMetalClusterSecurityConfigOutputReference;
    putSecurityConfig(value: GoogleGkeonpremBareMetalClusterSecurityConfig): void;
    resetSecurityConfig(): void;
    get securityConfigInput(): GoogleGkeonpremBareMetalClusterSecurityConfig | undefined;
    private _storage;
    get storage(): GoogleGkeonpremBareMetalClusterStorageOutputReference;
    putStorage(value: GoogleGkeonpremBareMetalClusterStorage): void;
    get storageInput(): GoogleGkeonpremBareMetalClusterStorage | undefined;
    private _timeouts;
    get timeouts(): GoogleGkeonpremBareMetalClusterTimeoutsOutputReference;
    putTimeouts(value: GoogleGkeonpremBareMetalClusterTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleGkeonpremBareMetalClusterTimeouts | undefined;
    private _upgradePolicy;
    get upgradePolicy(): GoogleGkeonpremBareMetalClusterUpgradePolicyOutputReference;
    putUpgradePolicy(value: GoogleGkeonpremBareMetalClusterUpgradePolicy): void;
    resetUpgradePolicy(): void;
    get upgradePolicyInput(): GoogleGkeonpremBareMetalClusterUpgradePolicy | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
