/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleGkeonpremBareMetalNodePoolConfig extends cdktf.TerraformMetaArguments {
    /**
    * Annotations on the Bare Metal Node Pool.
    * This field has the same restrictions as Kubernetes annotations.
    * The total size of all keys and values combined is limited to 256k.
    * Key can have 2 segments: prefix (optional) and name (required),
    * separated by a slash (/).
    * Prefix must be a DNS subdomain.
    * Name must be 63 characters or less, begin and end with alphanumerics,
    * with dashes (-), underscores (_), dots (.), and alphanumerics between.
    *
    *
    * **Note**: This field is non-authoritative, and will only manage the annotations present in your configuration.
    * Please refer to the field 'effective_annotations' for all of the annotations present on the resource.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gkeonprem_bare_metal_node_pool#annotations GoogleGkeonpremBareMetalNodePool#annotations}
    */
    readonly annotations?: {
        [key: string]: string;
    };
    /**
    * The cluster this node pool belongs to.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gkeonprem_bare_metal_node_pool#bare_metal_cluster GoogleGkeonpremBareMetalNodePool#bare_metal_cluster}
    */
    readonly bareMetalCluster: string;
    /**
    * The display name for the Bare Metal Node Pool.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gkeonprem_bare_metal_node_pool#display_name GoogleGkeonpremBareMetalNodePool#display_name}
    */
    readonly displayName?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gkeonprem_bare_metal_node_pool#id GoogleGkeonpremBareMetalNodePool#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The location of the resource.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gkeonprem_bare_metal_node_pool#location GoogleGkeonpremBareMetalNodePool#location}
    */
    readonly location: string;
    /**
    * The bare metal node pool name.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gkeonprem_bare_metal_node_pool#name GoogleGkeonpremBareMetalNodePool#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gkeonprem_bare_metal_node_pool#project GoogleGkeonpremBareMetalNodePool#project}
    */
    readonly project?: string;
    /**
    * node_pool_config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gkeonprem_bare_metal_node_pool#node_pool_config GoogleGkeonpremBareMetalNodePool#node_pool_config}
    */
    readonly nodePoolConfig: GoogleGkeonpremBareMetalNodePoolNodePoolConfig;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gkeonprem_bare_metal_node_pool#timeouts GoogleGkeonpremBareMetalNodePool#timeouts}
    */
    readonly timeouts?: GoogleGkeonpremBareMetalNodePoolTimeouts;
}
export interface GoogleGkeonpremBareMetalNodePoolStatusConditions {
}
export declare function googleGkeonpremBareMetalNodePoolStatusConditionsToTerraform(struct?: GoogleGkeonpremBareMetalNodePoolStatusConditions): any;
export declare function googleGkeonpremBareMetalNodePoolStatusConditionsToHclTerraform(struct?: GoogleGkeonpremBareMetalNodePoolStatusConditions): any;
export declare class GoogleGkeonpremBareMetalNodePoolStatusConditionsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleGkeonpremBareMetalNodePoolStatusConditions | undefined;
    set internalValue(value: GoogleGkeonpremBareMetalNodePoolStatusConditions | undefined);
    get lastTransitionTime(): string;
    get message(): string;
    get reason(): string;
    get state(): string;
    get type(): string;
}
export declare class GoogleGkeonpremBareMetalNodePoolStatusConditionsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleGkeonpremBareMetalNodePoolStatusConditionsOutputReference;
}
export interface GoogleGkeonpremBareMetalNodePoolStatus {
}
export declare function googleGkeonpremBareMetalNodePoolStatusToTerraform(struct?: GoogleGkeonpremBareMetalNodePoolStatus): any;
export declare function googleGkeonpremBareMetalNodePoolStatusToHclTerraform(struct?: GoogleGkeonpremBareMetalNodePoolStatus): any;
export declare class GoogleGkeonpremBareMetalNodePoolStatusOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleGkeonpremBareMetalNodePoolStatus | undefined;
    set internalValue(value: GoogleGkeonpremBareMetalNodePoolStatus | undefined);
    private _conditions;
    get conditions(): GoogleGkeonpremBareMetalNodePoolStatusConditionsList;
    get errorMessage(): string;
}
export declare class GoogleGkeonpremBareMetalNodePoolStatusList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleGkeonpremBareMetalNodePoolStatusOutputReference;
}
export interface GoogleGkeonpremBareMetalNodePoolNodePoolConfigNodeConfigs {
    /**
    * The map of Kubernetes labels (key/value pairs) to be applied to
    * each node. These will added in addition to any default label(s)
    * that Kubernetes may apply to the node. In case of conflict in
    * label keys, the applied set may differ depending on the Kubernetes
    * version -- it's best to assume the behavior is undefined and
    * conflicts should be avoided. For more information, including usage
    * and the valid values, see:
    *   http://kubernetes.io/v1.1/docs/user-guide/labels.html
    * An object containing a list of "key": value pairs.
    * Example: { "name": "wrench", "mass": "1.3kg", "count": "3" }.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gkeonprem_bare_metal_node_pool#labels GoogleGkeonpremBareMetalNodePool#labels}
    */
    readonly labels?: {
        [key: string]: string;
    };
    /**
    * The default IPv4 address for SSH access and Kubernetes node.
    * Example: 192.168.0.1
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gkeonprem_bare_metal_node_pool#node_ip GoogleGkeonpremBareMetalNodePool#node_ip}
    */
    readonly nodeIp?: string;
}
export declare function googleGkeonpremBareMetalNodePoolNodePoolConfigNodeConfigsToTerraform(struct?: GoogleGkeonpremBareMetalNodePoolNodePoolConfigNodeConfigs | cdktf.IResolvable): any;
export declare function googleGkeonpremBareMetalNodePoolNodePoolConfigNodeConfigsToHclTerraform(struct?: GoogleGkeonpremBareMetalNodePoolNodePoolConfigNodeConfigs | cdktf.IResolvable): any;
export declare class GoogleGkeonpremBareMetalNodePoolNodePoolConfigNodeConfigsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleGkeonpremBareMetalNodePoolNodePoolConfigNodeConfigs | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleGkeonpremBareMetalNodePoolNodePoolConfigNodeConfigs | cdktf.IResolvable | undefined);
    private _labels?;
    get labels(): {
        [key: string]: string;
    };
    set labels(value: {
        [key: string]: string;
    });
    resetLabels(): void;
    get labelsInput(): {
        [key: string]: string;
    } | undefined;
    private _nodeIp?;
    get nodeIp(): string;
    set nodeIp(value: string);
    resetNodeIp(): void;
    get nodeIpInput(): string | undefined;
}
export declare class GoogleGkeonpremBareMetalNodePoolNodePoolConfigNodeConfigsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleGkeonpremBareMetalNodePoolNodePoolConfigNodeConfigs[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleGkeonpremBareMetalNodePoolNodePoolConfigNodeConfigsOutputReference;
}
export interface GoogleGkeonpremBareMetalNodePoolNodePoolConfigTaints {
    /**
    * Specifies the nodes operating system (default: LINUX). Possible values: ["EFFECT_UNSPECIFIED", "PREFER_NO_SCHEDULE", "NO_EXECUTE"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gkeonprem_bare_metal_node_pool#effect GoogleGkeonpremBareMetalNodePool#effect}
    */
    readonly effect?: string;
    /**
    * Key associated with the effect.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gkeonprem_bare_metal_node_pool#key GoogleGkeonpremBareMetalNodePool#key}
    */
    readonly key?: string;
    /**
    * Value associated with the effect.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gkeonprem_bare_metal_node_pool#value GoogleGkeonpremBareMetalNodePool#value}
    */
    readonly value?: string;
}
export declare function googleGkeonpremBareMetalNodePoolNodePoolConfigTaintsToTerraform(struct?: GoogleGkeonpremBareMetalNodePoolNodePoolConfigTaints | cdktf.IResolvable): any;
export declare function googleGkeonpremBareMetalNodePoolNodePoolConfigTaintsToHclTerraform(struct?: GoogleGkeonpremBareMetalNodePoolNodePoolConfigTaints | cdktf.IResolvable): any;
export declare class GoogleGkeonpremBareMetalNodePoolNodePoolConfigTaintsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleGkeonpremBareMetalNodePoolNodePoolConfigTaints | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleGkeonpremBareMetalNodePoolNodePoolConfigTaints | cdktf.IResolvable | undefined);
    private _effect?;
    get effect(): string;
    set effect(value: string);
    resetEffect(): void;
    get effectInput(): string | undefined;
    private _key?;
    get key(): string;
    set key(value: string);
    resetKey(): void;
    get keyInput(): string | undefined;
    private _value?;
    get value(): string;
    set value(value: string);
    resetValue(): void;
    get valueInput(): string | undefined;
}
export declare class GoogleGkeonpremBareMetalNodePoolNodePoolConfigTaintsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleGkeonpremBareMetalNodePoolNodePoolConfigTaints[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleGkeonpremBareMetalNodePoolNodePoolConfigTaintsOutputReference;
}
export interface GoogleGkeonpremBareMetalNodePoolNodePoolConfig {
    /**
    * The map of Kubernetes labels (key/value pairs) to be applied to
    * each node. These will added in addition to any default label(s)
    * that Kubernetes may apply to the node. In case of conflict in
    * label keys, the applied set may differ depending on the Kubernetes
    * version -- it's best to assume the behavior is undefined and
    * conflicts should be avoided. For more information, including usage
    * and the valid values, see:
    *   http://kubernetes.io/v1.1/docs/user-guide/labels.html
    * An object containing a list of "key": value pairs.
    * Example: { "name": "wrench", "mass": "1.3kg", "count": "3" }.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gkeonprem_bare_metal_node_pool#labels GoogleGkeonpremBareMetalNodePool#labels}
    */
    readonly labels?: {
        [key: string]: string;
    };
    /**
    * Specifies the nodes operating system (default: LINUX).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gkeonprem_bare_metal_node_pool#operating_system GoogleGkeonpremBareMetalNodePool#operating_system}
    */
    readonly operatingSystem?: string;
    /**
    * node_configs block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gkeonprem_bare_metal_node_pool#node_configs GoogleGkeonpremBareMetalNodePool#node_configs}
    */
    readonly nodeConfigs: GoogleGkeonpremBareMetalNodePoolNodePoolConfigNodeConfigs[] | cdktf.IResolvable;
    /**
    * taints block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gkeonprem_bare_metal_node_pool#taints GoogleGkeonpremBareMetalNodePool#taints}
    */
    readonly taints?: GoogleGkeonpremBareMetalNodePoolNodePoolConfigTaints[] | cdktf.IResolvable;
}
export declare function googleGkeonpremBareMetalNodePoolNodePoolConfigToTerraform(struct?: GoogleGkeonpremBareMetalNodePoolNodePoolConfigOutputReference | GoogleGkeonpremBareMetalNodePoolNodePoolConfig): any;
export declare function googleGkeonpremBareMetalNodePoolNodePoolConfigToHclTerraform(struct?: GoogleGkeonpremBareMetalNodePoolNodePoolConfigOutputReference | GoogleGkeonpremBareMetalNodePoolNodePoolConfig): any;
export declare class GoogleGkeonpremBareMetalNodePoolNodePoolConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleGkeonpremBareMetalNodePoolNodePoolConfig | undefined;
    set internalValue(value: GoogleGkeonpremBareMetalNodePoolNodePoolConfig | undefined);
    private _labels?;
    get labels(): {
        [key: string]: string;
    };
    set labels(value: {
        [key: string]: string;
    });
    resetLabels(): void;
    get labelsInput(): {
        [key: string]: string;
    } | undefined;
    private _operatingSystem?;
    get operatingSystem(): string;
    set operatingSystem(value: string);
    resetOperatingSystem(): void;
    get operatingSystemInput(): string | undefined;
    private _nodeConfigs;
    get nodeConfigs(): GoogleGkeonpremBareMetalNodePoolNodePoolConfigNodeConfigsList;
    putNodeConfigs(value: GoogleGkeonpremBareMetalNodePoolNodePoolConfigNodeConfigs[] | cdktf.IResolvable): void;
    get nodeConfigsInput(): cdktf.IResolvable | GoogleGkeonpremBareMetalNodePoolNodePoolConfigNodeConfigs[] | undefined;
    private _taints;
    get taints(): GoogleGkeonpremBareMetalNodePoolNodePoolConfigTaintsList;
    putTaints(value: GoogleGkeonpremBareMetalNodePoolNodePoolConfigTaints[] | cdktf.IResolvable): void;
    resetTaints(): void;
    get taintsInput(): cdktf.IResolvable | GoogleGkeonpremBareMetalNodePoolNodePoolConfigTaints[] | undefined;
}
export interface GoogleGkeonpremBareMetalNodePoolTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gkeonprem_bare_metal_node_pool#create GoogleGkeonpremBareMetalNodePool#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gkeonprem_bare_metal_node_pool#delete GoogleGkeonpremBareMetalNodePool#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gkeonprem_bare_metal_node_pool#update GoogleGkeonpremBareMetalNodePool#update}
    */
    readonly update?: string;
}
export declare function googleGkeonpremBareMetalNodePoolTimeoutsToTerraform(struct?: GoogleGkeonpremBareMetalNodePoolTimeouts | cdktf.IResolvable): any;
export declare function googleGkeonpremBareMetalNodePoolTimeoutsToHclTerraform(struct?: GoogleGkeonpremBareMetalNodePoolTimeouts | cdktf.IResolvable): any;
export declare class GoogleGkeonpremBareMetalNodePoolTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleGkeonpremBareMetalNodePoolTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleGkeonpremBareMetalNodePoolTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gkeonprem_bare_metal_node_pool google_gkeonprem_bare_metal_node_pool}
*/
export declare class GoogleGkeonpremBareMetalNodePool extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_gkeonprem_bare_metal_node_pool";
    /**
    * Generates CDKTF code for importing a GoogleGkeonpremBareMetalNodePool resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the GoogleGkeonpremBareMetalNodePool to import
    * @param importFromId The id of the existing GoogleGkeonpremBareMetalNodePool that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gkeonprem_bare_metal_node_pool#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the GoogleGkeonpremBareMetalNodePool to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gkeonprem_bare_metal_node_pool google_gkeonprem_bare_metal_node_pool} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleGkeonpremBareMetalNodePoolConfig
    */
    constructor(scope: Construct, id: string, config: GoogleGkeonpremBareMetalNodePoolConfig);
    private _annotations?;
    get annotations(): {
        [key: string]: string;
    };
    set annotations(value: {
        [key: string]: string;
    });
    resetAnnotations(): void;
    get annotationsInput(): {
        [key: string]: string;
    } | undefined;
    private _bareMetalCluster?;
    get bareMetalCluster(): string;
    set bareMetalCluster(value: string);
    get bareMetalClusterInput(): string | undefined;
    get createTime(): string;
    get deleteTime(): string;
    private _displayName?;
    get displayName(): string;
    set displayName(value: string);
    resetDisplayName(): void;
    get displayNameInput(): string | undefined;
    private _effectiveAnnotations;
    get effectiveAnnotations(): cdktf.StringMap;
    get etag(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    get reconciling(): cdktf.IResolvable;
    get state(): string;
    private _status;
    get status(): GoogleGkeonpremBareMetalNodePoolStatusList;
    get uid(): string;
    get updateTime(): string;
    private _nodePoolConfig;
    get nodePoolConfig(): GoogleGkeonpremBareMetalNodePoolNodePoolConfigOutputReference;
    putNodePoolConfig(value: GoogleGkeonpremBareMetalNodePoolNodePoolConfig): void;
    get nodePoolConfigInput(): GoogleGkeonpremBareMetalNodePoolNodePoolConfig | undefined;
    private _timeouts;
    get timeouts(): GoogleGkeonpremBareMetalNodePoolTimeoutsOutputReference;
    putTimeouts(value: GoogleGkeonpremBareMetalNodePoolTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleGkeonpremBareMetalNodePoolTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
