/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleGkeonpremVmwareClusterConfig extends cdktf.TerraformMetaArguments {
    /**
    * The admin cluster this VMware User Cluster belongs to.
    * This is the full resource name of the admin cluster's hub membership.
    * In the future, references to other resource types might be allowed if
    * admin clusters are modeled as their own resources.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gkeonprem_vmware_cluster#admin_cluster_membership GoogleGkeonpremVmwareCluster#admin_cluster_membership}
    */
    readonly adminClusterMembership: string;
    /**
    * Annotations on the VMware User Cluster.
    * This field has the same restrictions as Kubernetes annotations.
    * The total size of all keys and values combined is limited to 256k.
    * Key can have 2 segments: prefix (optional) and name (required),
    * separated by a slash (/).
    * Prefix must be a DNS subdomain.
    * Name must be 63 characters or less, begin and end with alphanumerics,
    * with dashes (-), underscores (_), dots (.), and alphanumerics between.
    *
    *
    * **Note**: This field is non-authoritative, and will only manage the annotations present in your configuration.
    * Please refer to the field 'effective_annotations' for all of the annotations present on the resource.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gkeonprem_vmware_cluster#annotations GoogleGkeonpremVmwareCluster#annotations}
    */
    readonly annotations?: {
        [key: string]: string;
    };
    /**
    * A human readable description of this VMware User Cluster.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gkeonprem_vmware_cluster#description GoogleGkeonpremVmwareCluster#description}
    */
    readonly description?: string;
    /**
    * Enable control plane V2. Default to false.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gkeonprem_vmware_cluster#enable_control_plane_v2 GoogleGkeonpremVmwareCluster#enable_control_plane_v2}
    */
    readonly enableControlPlaneV2?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gkeonprem_vmware_cluster#id GoogleGkeonpremVmwareCluster#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The location of the resource.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gkeonprem_vmware_cluster#location GoogleGkeonpremVmwareCluster#location}
    */
    readonly location: string;
    /**
    * The VMware cluster name.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gkeonprem_vmware_cluster#name GoogleGkeonpremVmwareCluster#name}
    */
    readonly name: string;
    /**
    * The Anthos clusters on the VMware version for your user cluster.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gkeonprem_vmware_cluster#on_prem_version GoogleGkeonpremVmwareCluster#on_prem_version}
    */
    readonly onPremVersion: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gkeonprem_vmware_cluster#project GoogleGkeonpremVmwareCluster#project}
    */
    readonly project?: string;
    /**
    * Enable VM tracking.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gkeonprem_vmware_cluster#vm_tracking_enabled GoogleGkeonpremVmwareCluster#vm_tracking_enabled}
    */
    readonly vmTrackingEnabled?: boolean | cdktf.IResolvable;
    /**
    * anti_affinity_groups block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gkeonprem_vmware_cluster#anti_affinity_groups GoogleGkeonpremVmwareCluster#anti_affinity_groups}
    */
    readonly antiAffinityGroups?: GoogleGkeonpremVmwareClusterAntiAffinityGroups;
    /**
    * authorization block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gkeonprem_vmware_cluster#authorization GoogleGkeonpremVmwareCluster#authorization}
    */
    readonly authorization?: GoogleGkeonpremVmwareClusterAuthorization;
    /**
    * auto_repair_config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gkeonprem_vmware_cluster#auto_repair_config GoogleGkeonpremVmwareCluster#auto_repair_config}
    */
    readonly autoRepairConfig?: GoogleGkeonpremVmwareClusterAutoRepairConfig;
    /**
    * control_plane_node block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gkeonprem_vmware_cluster#control_plane_node GoogleGkeonpremVmwareCluster#control_plane_node}
    */
    readonly controlPlaneNode: GoogleGkeonpremVmwareClusterControlPlaneNode;
    /**
    * dataplane_v2 block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gkeonprem_vmware_cluster#dataplane_v2 GoogleGkeonpremVmwareCluster#dataplane_v2}
    */
    readonly dataplaneV2?: GoogleGkeonpremVmwareClusterDataplaneV2;
    /**
    * load_balancer block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gkeonprem_vmware_cluster#load_balancer GoogleGkeonpremVmwareCluster#load_balancer}
    */
    readonly loadBalancer?: GoogleGkeonpremVmwareClusterLoadBalancer;
    /**
    * network_config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gkeonprem_vmware_cluster#network_config GoogleGkeonpremVmwareCluster#network_config}
    */
    readonly networkConfig?: GoogleGkeonpremVmwareClusterNetworkConfig;
    /**
    * storage block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gkeonprem_vmware_cluster#storage GoogleGkeonpremVmwareCluster#storage}
    */
    readonly storage?: GoogleGkeonpremVmwareClusterStorage;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gkeonprem_vmware_cluster#timeouts GoogleGkeonpremVmwareCluster#timeouts}
    */
    readonly timeouts?: GoogleGkeonpremVmwareClusterTimeouts;
    /**
    * upgrade_policy block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gkeonprem_vmware_cluster#upgrade_policy GoogleGkeonpremVmwareCluster#upgrade_policy}
    */
    readonly upgradePolicy?: GoogleGkeonpremVmwareClusterUpgradePolicy;
    /**
    * vcenter block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gkeonprem_vmware_cluster#vcenter GoogleGkeonpremVmwareCluster#vcenter}
    */
    readonly vcenter?: GoogleGkeonpremVmwareClusterVcenter;
}
export interface GoogleGkeonpremVmwareClusterFleet {
}
export declare function googleGkeonpremVmwareClusterFleetToTerraform(struct?: GoogleGkeonpremVmwareClusterFleet): any;
export declare function googleGkeonpremVmwareClusterFleetToHclTerraform(struct?: GoogleGkeonpremVmwareClusterFleet): any;
export declare class GoogleGkeonpremVmwareClusterFleetOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleGkeonpremVmwareClusterFleet | undefined;
    set internalValue(value: GoogleGkeonpremVmwareClusterFleet | undefined);
    get membership(): string;
}
export declare class GoogleGkeonpremVmwareClusterFleetList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleGkeonpremVmwareClusterFleetOutputReference;
}
export interface GoogleGkeonpremVmwareClusterStatusConditions {
}
export declare function googleGkeonpremVmwareClusterStatusConditionsToTerraform(struct?: GoogleGkeonpremVmwareClusterStatusConditions): any;
export declare function googleGkeonpremVmwareClusterStatusConditionsToHclTerraform(struct?: GoogleGkeonpremVmwareClusterStatusConditions): any;
export declare class GoogleGkeonpremVmwareClusterStatusConditionsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleGkeonpremVmwareClusterStatusConditions | undefined;
    set internalValue(value: GoogleGkeonpremVmwareClusterStatusConditions | undefined);
    get lastTransitionTime(): string;
    get message(): string;
    get reason(): string;
    get state(): string;
    get type(): string;
}
export declare class GoogleGkeonpremVmwareClusterStatusConditionsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleGkeonpremVmwareClusterStatusConditionsOutputReference;
}
export interface GoogleGkeonpremVmwareClusterStatus {
}
export declare function googleGkeonpremVmwareClusterStatusToTerraform(struct?: GoogleGkeonpremVmwareClusterStatus): any;
export declare function googleGkeonpremVmwareClusterStatusToHclTerraform(struct?: GoogleGkeonpremVmwareClusterStatus): any;
export declare class GoogleGkeonpremVmwareClusterStatusOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleGkeonpremVmwareClusterStatus | undefined;
    set internalValue(value: GoogleGkeonpremVmwareClusterStatus | undefined);
    private _conditions;
    get conditions(): GoogleGkeonpremVmwareClusterStatusConditionsList;
    get errorMessage(): string;
}
export declare class GoogleGkeonpremVmwareClusterStatusList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleGkeonpremVmwareClusterStatusOutputReference;
}
export interface GoogleGkeonpremVmwareClusterValidationCheckStatusResult {
}
export declare function googleGkeonpremVmwareClusterValidationCheckStatusResultToTerraform(struct?: GoogleGkeonpremVmwareClusterValidationCheckStatusResult): any;
export declare function googleGkeonpremVmwareClusterValidationCheckStatusResultToHclTerraform(struct?: GoogleGkeonpremVmwareClusterValidationCheckStatusResult): any;
export declare class GoogleGkeonpremVmwareClusterValidationCheckStatusResultOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleGkeonpremVmwareClusterValidationCheckStatusResult | undefined;
    set internalValue(value: GoogleGkeonpremVmwareClusterValidationCheckStatusResult | undefined);
    get category(): string;
    get description(): string;
    get details(): string;
    get options(): string;
    get reason(): string;
}
export declare class GoogleGkeonpremVmwareClusterValidationCheckStatusResultList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleGkeonpremVmwareClusterValidationCheckStatusResultOutputReference;
}
export interface GoogleGkeonpremVmwareClusterValidationCheckStatus {
}
export declare function googleGkeonpremVmwareClusterValidationCheckStatusToTerraform(struct?: GoogleGkeonpremVmwareClusterValidationCheckStatus): any;
export declare function googleGkeonpremVmwareClusterValidationCheckStatusToHclTerraform(struct?: GoogleGkeonpremVmwareClusterValidationCheckStatus): any;
export declare class GoogleGkeonpremVmwareClusterValidationCheckStatusOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleGkeonpremVmwareClusterValidationCheckStatus | undefined;
    set internalValue(value: GoogleGkeonpremVmwareClusterValidationCheckStatus | undefined);
    private _result;
    get result(): GoogleGkeonpremVmwareClusterValidationCheckStatusResultList;
}
export declare class GoogleGkeonpremVmwareClusterValidationCheckStatusList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleGkeonpremVmwareClusterValidationCheckStatusOutputReference;
}
export interface GoogleGkeonpremVmwareClusterValidationCheck {
}
export declare function googleGkeonpremVmwareClusterValidationCheckToTerraform(struct?: GoogleGkeonpremVmwareClusterValidationCheck): any;
export declare function googleGkeonpremVmwareClusterValidationCheckToHclTerraform(struct?: GoogleGkeonpremVmwareClusterValidationCheck): any;
export declare class GoogleGkeonpremVmwareClusterValidationCheckOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleGkeonpremVmwareClusterValidationCheck | undefined;
    set internalValue(value: GoogleGkeonpremVmwareClusterValidationCheck | undefined);
    get options(): string;
    get scenario(): string;
    private _status;
    get status(): GoogleGkeonpremVmwareClusterValidationCheckStatusList;
}
export declare class GoogleGkeonpremVmwareClusterValidationCheckList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleGkeonpremVmwareClusterValidationCheckOutputReference;
}
export interface GoogleGkeonpremVmwareClusterAntiAffinityGroups {
    /**
    * Spread nodes across at least three physical hosts (requires at least three
    * hosts).
    * Enabled by default.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gkeonprem_vmware_cluster#aag_config_disabled GoogleGkeonpremVmwareCluster#aag_config_disabled}
    */
    readonly aagConfigDisabled: boolean | cdktf.IResolvable;
}
export declare function googleGkeonpremVmwareClusterAntiAffinityGroupsToTerraform(struct?: GoogleGkeonpremVmwareClusterAntiAffinityGroupsOutputReference | GoogleGkeonpremVmwareClusterAntiAffinityGroups): any;
export declare function googleGkeonpremVmwareClusterAntiAffinityGroupsToHclTerraform(struct?: GoogleGkeonpremVmwareClusterAntiAffinityGroupsOutputReference | GoogleGkeonpremVmwareClusterAntiAffinityGroups): any;
export declare class GoogleGkeonpremVmwareClusterAntiAffinityGroupsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleGkeonpremVmwareClusterAntiAffinityGroups | undefined;
    set internalValue(value: GoogleGkeonpremVmwareClusterAntiAffinityGroups | undefined);
    private _aagConfigDisabled?;
    get aagConfigDisabled(): boolean | cdktf.IResolvable;
    set aagConfigDisabled(value: boolean | cdktf.IResolvable);
    get aagConfigDisabledInput(): boolean | cdktf.IResolvable | undefined;
}
export interface GoogleGkeonpremVmwareClusterAuthorizationAdminUsers {
    /**
    * The name of the user, e.g. 'my-gcp-id@gmail.com'.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gkeonprem_vmware_cluster#username GoogleGkeonpremVmwareCluster#username}
    */
    readonly username: string;
}
export declare function googleGkeonpremVmwareClusterAuthorizationAdminUsersToTerraform(struct?: GoogleGkeonpremVmwareClusterAuthorizationAdminUsers | cdktf.IResolvable): any;
export declare function googleGkeonpremVmwareClusterAuthorizationAdminUsersToHclTerraform(struct?: GoogleGkeonpremVmwareClusterAuthorizationAdminUsers | cdktf.IResolvable): any;
export declare class GoogleGkeonpremVmwareClusterAuthorizationAdminUsersOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleGkeonpremVmwareClusterAuthorizationAdminUsers | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleGkeonpremVmwareClusterAuthorizationAdminUsers | cdktf.IResolvable | undefined);
    private _username?;
    get username(): string;
    set username(value: string);
    get usernameInput(): string | undefined;
}
export declare class GoogleGkeonpremVmwareClusterAuthorizationAdminUsersList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleGkeonpremVmwareClusterAuthorizationAdminUsers[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleGkeonpremVmwareClusterAuthorizationAdminUsersOutputReference;
}
export interface GoogleGkeonpremVmwareClusterAuthorization {
    /**
    * admin_users block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gkeonprem_vmware_cluster#admin_users GoogleGkeonpremVmwareCluster#admin_users}
    */
    readonly adminUsers?: GoogleGkeonpremVmwareClusterAuthorizationAdminUsers[] | cdktf.IResolvable;
}
export declare function googleGkeonpremVmwareClusterAuthorizationToTerraform(struct?: GoogleGkeonpremVmwareClusterAuthorizationOutputReference | GoogleGkeonpremVmwareClusterAuthorization): any;
export declare function googleGkeonpremVmwareClusterAuthorizationToHclTerraform(struct?: GoogleGkeonpremVmwareClusterAuthorizationOutputReference | GoogleGkeonpremVmwareClusterAuthorization): any;
export declare class GoogleGkeonpremVmwareClusterAuthorizationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleGkeonpremVmwareClusterAuthorization | undefined;
    set internalValue(value: GoogleGkeonpremVmwareClusterAuthorization | undefined);
    private _adminUsers;
    get adminUsers(): GoogleGkeonpremVmwareClusterAuthorizationAdminUsersList;
    putAdminUsers(value: GoogleGkeonpremVmwareClusterAuthorizationAdminUsers[] | cdktf.IResolvable): void;
    resetAdminUsers(): void;
    get adminUsersInput(): cdktf.IResolvable | GoogleGkeonpremVmwareClusterAuthorizationAdminUsers[] | undefined;
}
export interface GoogleGkeonpremVmwareClusterAutoRepairConfig {
    /**
    * Whether auto repair is enabled.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gkeonprem_vmware_cluster#enabled GoogleGkeonpremVmwareCluster#enabled}
    */
    readonly enabled: boolean | cdktf.IResolvable;
}
export declare function googleGkeonpremVmwareClusterAutoRepairConfigToTerraform(struct?: GoogleGkeonpremVmwareClusterAutoRepairConfigOutputReference | GoogleGkeonpremVmwareClusterAutoRepairConfig): any;
export declare function googleGkeonpremVmwareClusterAutoRepairConfigToHclTerraform(struct?: GoogleGkeonpremVmwareClusterAutoRepairConfigOutputReference | GoogleGkeonpremVmwareClusterAutoRepairConfig): any;
export declare class GoogleGkeonpremVmwareClusterAutoRepairConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleGkeonpremVmwareClusterAutoRepairConfig | undefined;
    set internalValue(value: GoogleGkeonpremVmwareClusterAutoRepairConfig | undefined);
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
}
export interface GoogleGkeonpremVmwareClusterControlPlaneNodeVsphereConfig {
}
export declare function googleGkeonpremVmwareClusterControlPlaneNodeVsphereConfigToTerraform(struct?: GoogleGkeonpremVmwareClusterControlPlaneNodeVsphereConfig): any;
export declare function googleGkeonpremVmwareClusterControlPlaneNodeVsphereConfigToHclTerraform(struct?: GoogleGkeonpremVmwareClusterControlPlaneNodeVsphereConfig): any;
export declare class GoogleGkeonpremVmwareClusterControlPlaneNodeVsphereConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleGkeonpremVmwareClusterControlPlaneNodeVsphereConfig | undefined;
    set internalValue(value: GoogleGkeonpremVmwareClusterControlPlaneNodeVsphereConfig | undefined);
    get datastore(): string;
    get storagePolicyName(): string;
}
export declare class GoogleGkeonpremVmwareClusterControlPlaneNodeVsphereConfigList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleGkeonpremVmwareClusterControlPlaneNodeVsphereConfigOutputReference;
}
export interface GoogleGkeonpremVmwareClusterControlPlaneNodeAutoResizeConfig {
    /**
    * Whether to enable control plane node auto resizing.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gkeonprem_vmware_cluster#enabled GoogleGkeonpremVmwareCluster#enabled}
    */
    readonly enabled: boolean | cdktf.IResolvable;
}
export declare function googleGkeonpremVmwareClusterControlPlaneNodeAutoResizeConfigToTerraform(struct?: GoogleGkeonpremVmwareClusterControlPlaneNodeAutoResizeConfigOutputReference | GoogleGkeonpremVmwareClusterControlPlaneNodeAutoResizeConfig): any;
export declare function googleGkeonpremVmwareClusterControlPlaneNodeAutoResizeConfigToHclTerraform(struct?: GoogleGkeonpremVmwareClusterControlPlaneNodeAutoResizeConfigOutputReference | GoogleGkeonpremVmwareClusterControlPlaneNodeAutoResizeConfig): any;
export declare class GoogleGkeonpremVmwareClusterControlPlaneNodeAutoResizeConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleGkeonpremVmwareClusterControlPlaneNodeAutoResizeConfig | undefined;
    set internalValue(value: GoogleGkeonpremVmwareClusterControlPlaneNodeAutoResizeConfig | undefined);
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
}
export interface GoogleGkeonpremVmwareClusterControlPlaneNode {
    /**
    * The number of CPUs for each admin cluster node that serve as control planes
    * for this VMware User Cluster. (default: 4 CPUs)
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gkeonprem_vmware_cluster#cpus GoogleGkeonpremVmwareCluster#cpus}
    */
    readonly cpus?: number;
    /**
    * The megabytes of memory for each admin cluster node that serves as a
    * control plane for this VMware User Cluster (default: 8192 MB memory).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gkeonprem_vmware_cluster#memory GoogleGkeonpremVmwareCluster#memory}
    */
    readonly memory?: number;
    /**
    * The number of control plane nodes for this VMware User Cluster.
    * (default: 1 replica).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gkeonprem_vmware_cluster#replicas GoogleGkeonpremVmwareCluster#replicas}
    */
    readonly replicas?: number;
    /**
    * auto_resize_config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gkeonprem_vmware_cluster#auto_resize_config GoogleGkeonpremVmwareCluster#auto_resize_config}
    */
    readonly autoResizeConfig?: GoogleGkeonpremVmwareClusterControlPlaneNodeAutoResizeConfig;
}
export declare function googleGkeonpremVmwareClusterControlPlaneNodeToTerraform(struct?: GoogleGkeonpremVmwareClusterControlPlaneNodeOutputReference | GoogleGkeonpremVmwareClusterControlPlaneNode): any;
export declare function googleGkeonpremVmwareClusterControlPlaneNodeToHclTerraform(struct?: GoogleGkeonpremVmwareClusterControlPlaneNodeOutputReference | GoogleGkeonpremVmwareClusterControlPlaneNode): any;
export declare class GoogleGkeonpremVmwareClusterControlPlaneNodeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleGkeonpremVmwareClusterControlPlaneNode | undefined;
    set internalValue(value: GoogleGkeonpremVmwareClusterControlPlaneNode | undefined);
    private _cpus?;
    get cpus(): number;
    set cpus(value: number);
    resetCpus(): void;
    get cpusInput(): number | undefined;
    private _memory?;
    get memory(): number;
    set memory(value: number);
    resetMemory(): void;
    get memoryInput(): number | undefined;
    private _replicas?;
    get replicas(): number;
    set replicas(value: number);
    resetReplicas(): void;
    get replicasInput(): number | undefined;
    private _vsphereConfig;
    get vsphereConfig(): GoogleGkeonpremVmwareClusterControlPlaneNodeVsphereConfigList;
    private _autoResizeConfig;
    get autoResizeConfig(): GoogleGkeonpremVmwareClusterControlPlaneNodeAutoResizeConfigOutputReference;
    putAutoResizeConfig(value: GoogleGkeonpremVmwareClusterControlPlaneNodeAutoResizeConfig): void;
    resetAutoResizeConfig(): void;
    get autoResizeConfigInput(): GoogleGkeonpremVmwareClusterControlPlaneNodeAutoResizeConfig | undefined;
}
export interface GoogleGkeonpremVmwareClusterDataplaneV2 {
    /**
    * Enable advanced networking which requires dataplane_v2_enabled to be set true.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gkeonprem_vmware_cluster#advanced_networking GoogleGkeonpremVmwareCluster#advanced_networking}
    */
    readonly advancedNetworking?: boolean | cdktf.IResolvable;
    /**
    * Enables Dataplane V2.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gkeonprem_vmware_cluster#dataplane_v2_enabled GoogleGkeonpremVmwareCluster#dataplane_v2_enabled}
    */
    readonly dataplaneV2Enabled?: boolean | cdktf.IResolvable;
    /**
    * Enable Dataplane V2 for clusters with Windows nodes.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gkeonprem_vmware_cluster#windows_dataplane_v2_enabled GoogleGkeonpremVmwareCluster#windows_dataplane_v2_enabled}
    */
    readonly windowsDataplaneV2Enabled?: boolean | cdktf.IResolvable;
}
export declare function googleGkeonpremVmwareClusterDataplaneV2ToTerraform(struct?: GoogleGkeonpremVmwareClusterDataplaneV2OutputReference | GoogleGkeonpremVmwareClusterDataplaneV2): any;
export declare function googleGkeonpremVmwareClusterDataplaneV2ToHclTerraform(struct?: GoogleGkeonpremVmwareClusterDataplaneV2OutputReference | GoogleGkeonpremVmwareClusterDataplaneV2): any;
export declare class GoogleGkeonpremVmwareClusterDataplaneV2OutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleGkeonpremVmwareClusterDataplaneV2 | undefined;
    set internalValue(value: GoogleGkeonpremVmwareClusterDataplaneV2 | undefined);
    private _advancedNetworking?;
    get advancedNetworking(): boolean | cdktf.IResolvable;
    set advancedNetworking(value: boolean | cdktf.IResolvable);
    resetAdvancedNetworking(): void;
    get advancedNetworkingInput(): boolean | cdktf.IResolvable | undefined;
    private _dataplaneV2Enabled?;
    get dataplaneV2Enabled(): boolean | cdktf.IResolvable;
    set dataplaneV2Enabled(value: boolean | cdktf.IResolvable);
    resetDataplaneV2Enabled(): void;
    get dataplaneV2EnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _windowsDataplaneV2Enabled?;
    get windowsDataplaneV2Enabled(): boolean | cdktf.IResolvable;
    set windowsDataplaneV2Enabled(value: boolean | cdktf.IResolvable);
    resetWindowsDataplaneV2Enabled(): void;
    get windowsDataplaneV2EnabledInput(): boolean | cdktf.IResolvable | undefined;
}
export interface GoogleGkeonpremVmwareClusterLoadBalancerF5Config {
    /**
    * The load balancer's IP address.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gkeonprem_vmware_cluster#address GoogleGkeonpremVmwareCluster#address}
    */
    readonly address?: string;
    /**
    * he preexisting partition to be used by the load balancer. T
    * his partition is usually created for the admin cluster for example:
    * 'my-f5-admin-partition'.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gkeonprem_vmware_cluster#partition GoogleGkeonpremVmwareCluster#partition}
    */
    readonly partition?: string;
    /**
    * The pool name. Only necessary, if using SNAT.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gkeonprem_vmware_cluster#snat_pool GoogleGkeonpremVmwareCluster#snat_pool}
    */
    readonly snatPool?: string;
}
export declare function googleGkeonpremVmwareClusterLoadBalancerF5ConfigToTerraform(struct?: GoogleGkeonpremVmwareClusterLoadBalancerF5ConfigOutputReference | GoogleGkeonpremVmwareClusterLoadBalancerF5Config): any;
export declare function googleGkeonpremVmwareClusterLoadBalancerF5ConfigToHclTerraform(struct?: GoogleGkeonpremVmwareClusterLoadBalancerF5ConfigOutputReference | GoogleGkeonpremVmwareClusterLoadBalancerF5Config): any;
export declare class GoogleGkeonpremVmwareClusterLoadBalancerF5ConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleGkeonpremVmwareClusterLoadBalancerF5Config | undefined;
    set internalValue(value: GoogleGkeonpremVmwareClusterLoadBalancerF5Config | undefined);
    private _address?;
    get address(): string;
    set address(value: string);
    resetAddress(): void;
    get addressInput(): string | undefined;
    private _partition?;
    get partition(): string;
    set partition(value: string);
    resetPartition(): void;
    get partitionInput(): string | undefined;
    private _snatPool?;
    get snatPool(): string;
    set snatPool(value: string);
    resetSnatPool(): void;
    get snatPoolInput(): string | undefined;
}
export interface GoogleGkeonpremVmwareClusterLoadBalancerManualLbConfig {
    /**
    * NodePort for control plane service. The Kubernetes API server in the admin
    * cluster is implemented as a Service of type NodePort (ex. 30968).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gkeonprem_vmware_cluster#control_plane_node_port GoogleGkeonpremVmwareCluster#control_plane_node_port}
    */
    readonly controlPlaneNodePort?: number;
    /**
    * NodePort for ingress service's http. The ingress service in the admin
    * cluster is implemented as a Service of type NodePort (ex. 32527).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gkeonprem_vmware_cluster#ingress_http_node_port GoogleGkeonpremVmwareCluster#ingress_http_node_port}
    */
    readonly ingressHttpNodePort?: number;
    /**
    * NodePort for ingress service's https. The ingress service in the admin
    * cluster is implemented as a Service of type NodePort (ex. 30139).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gkeonprem_vmware_cluster#ingress_https_node_port GoogleGkeonpremVmwareCluster#ingress_https_node_port}
    */
    readonly ingressHttpsNodePort?: number;
    /**
    * NodePort for konnectivity server service running as a sidecar in each
    * kube-apiserver pod (ex. 30564).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gkeonprem_vmware_cluster#konnectivity_server_node_port GoogleGkeonpremVmwareCluster#konnectivity_server_node_port}
    */
    readonly konnectivityServerNodePort?: number;
}
export declare function googleGkeonpremVmwareClusterLoadBalancerManualLbConfigToTerraform(struct?: GoogleGkeonpremVmwareClusterLoadBalancerManualLbConfigOutputReference | GoogleGkeonpremVmwareClusterLoadBalancerManualLbConfig): any;
export declare function googleGkeonpremVmwareClusterLoadBalancerManualLbConfigToHclTerraform(struct?: GoogleGkeonpremVmwareClusterLoadBalancerManualLbConfigOutputReference | GoogleGkeonpremVmwareClusterLoadBalancerManualLbConfig): any;
export declare class GoogleGkeonpremVmwareClusterLoadBalancerManualLbConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleGkeonpremVmwareClusterLoadBalancerManualLbConfig | undefined;
    set internalValue(value: GoogleGkeonpremVmwareClusterLoadBalancerManualLbConfig | undefined);
    private _controlPlaneNodePort?;
    get controlPlaneNodePort(): number;
    set controlPlaneNodePort(value: number);
    resetControlPlaneNodePort(): void;
    get controlPlaneNodePortInput(): number | undefined;
    private _ingressHttpNodePort?;
    get ingressHttpNodePort(): number;
    set ingressHttpNodePort(value: number);
    resetIngressHttpNodePort(): void;
    get ingressHttpNodePortInput(): number | undefined;
    private _ingressHttpsNodePort?;
    get ingressHttpsNodePort(): number;
    set ingressHttpsNodePort(value: number);
    resetIngressHttpsNodePort(): void;
    get ingressHttpsNodePortInput(): number | undefined;
    private _konnectivityServerNodePort?;
    get konnectivityServerNodePort(): number;
    set konnectivityServerNodePort(value: number);
    resetKonnectivityServerNodePort(): void;
    get konnectivityServerNodePortInput(): number | undefined;
}
export interface GoogleGkeonpremVmwareClusterLoadBalancerMetalLbConfigAddressPools {
    /**
    * The addresses that are part of this pool. Each address
    * must be either in the CIDR form (1.2.3.0/24) or range
    * form (1.2.3.1-1.2.3.5).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gkeonprem_vmware_cluster#addresses GoogleGkeonpremVmwareCluster#addresses}
    */
    readonly addresses: string[];
    /**
    * If true, avoid using IPs ending in .0 or .255.
    * This avoids buggy consumer devices mistakenly dropping IPv4 traffic for
    * those special IP addresses.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gkeonprem_vmware_cluster#avoid_buggy_ips GoogleGkeonpremVmwareCluster#avoid_buggy_ips}
    */
    readonly avoidBuggyIps?: boolean | cdktf.IResolvable;
    /**
    * If true, prevent IP addresses from being automatically assigned.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gkeonprem_vmware_cluster#manual_assign GoogleGkeonpremVmwareCluster#manual_assign}
    */
    readonly manualAssign?: boolean | cdktf.IResolvable;
    /**
    * The name of the address pool.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gkeonprem_vmware_cluster#pool GoogleGkeonpremVmwareCluster#pool}
    */
    readonly pool: string;
}
export declare function googleGkeonpremVmwareClusterLoadBalancerMetalLbConfigAddressPoolsToTerraform(struct?: GoogleGkeonpremVmwareClusterLoadBalancerMetalLbConfigAddressPools | cdktf.IResolvable): any;
export declare function googleGkeonpremVmwareClusterLoadBalancerMetalLbConfigAddressPoolsToHclTerraform(struct?: GoogleGkeonpremVmwareClusterLoadBalancerMetalLbConfigAddressPools | cdktf.IResolvable): any;
export declare class GoogleGkeonpremVmwareClusterLoadBalancerMetalLbConfigAddressPoolsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleGkeonpremVmwareClusterLoadBalancerMetalLbConfigAddressPools | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleGkeonpremVmwareClusterLoadBalancerMetalLbConfigAddressPools | cdktf.IResolvable | undefined);
    private _addresses?;
    get addresses(): string[];
    set addresses(value: string[]);
    get addressesInput(): string[] | undefined;
    private _avoidBuggyIps?;
    get avoidBuggyIps(): boolean | cdktf.IResolvable;
    set avoidBuggyIps(value: boolean | cdktf.IResolvable);
    resetAvoidBuggyIps(): void;
    get avoidBuggyIpsInput(): boolean | cdktf.IResolvable | undefined;
    private _manualAssign?;
    get manualAssign(): boolean | cdktf.IResolvable;
    set manualAssign(value: boolean | cdktf.IResolvable);
    resetManualAssign(): void;
    get manualAssignInput(): boolean | cdktf.IResolvable | undefined;
    private _pool?;
    get pool(): string;
    set pool(value: string);
    get poolInput(): string | undefined;
}
export declare class GoogleGkeonpremVmwareClusterLoadBalancerMetalLbConfigAddressPoolsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleGkeonpremVmwareClusterLoadBalancerMetalLbConfigAddressPools[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleGkeonpremVmwareClusterLoadBalancerMetalLbConfigAddressPoolsOutputReference;
}
export interface GoogleGkeonpremVmwareClusterLoadBalancerMetalLbConfig {
    /**
    * address_pools block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gkeonprem_vmware_cluster#address_pools GoogleGkeonpremVmwareCluster#address_pools}
    */
    readonly addressPools: GoogleGkeonpremVmwareClusterLoadBalancerMetalLbConfigAddressPools[] | cdktf.IResolvable;
}
export declare function googleGkeonpremVmwareClusterLoadBalancerMetalLbConfigToTerraform(struct?: GoogleGkeonpremVmwareClusterLoadBalancerMetalLbConfigOutputReference | GoogleGkeonpremVmwareClusterLoadBalancerMetalLbConfig): any;
export declare function googleGkeonpremVmwareClusterLoadBalancerMetalLbConfigToHclTerraform(struct?: GoogleGkeonpremVmwareClusterLoadBalancerMetalLbConfigOutputReference | GoogleGkeonpremVmwareClusterLoadBalancerMetalLbConfig): any;
export declare class GoogleGkeonpremVmwareClusterLoadBalancerMetalLbConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleGkeonpremVmwareClusterLoadBalancerMetalLbConfig | undefined;
    set internalValue(value: GoogleGkeonpremVmwareClusterLoadBalancerMetalLbConfig | undefined);
    private _addressPools;
    get addressPools(): GoogleGkeonpremVmwareClusterLoadBalancerMetalLbConfigAddressPoolsList;
    putAddressPools(value: GoogleGkeonpremVmwareClusterLoadBalancerMetalLbConfigAddressPools[] | cdktf.IResolvable): void;
    get addressPoolsInput(): cdktf.IResolvable | GoogleGkeonpremVmwareClusterLoadBalancerMetalLbConfigAddressPools[] | undefined;
}
export interface GoogleGkeonpremVmwareClusterLoadBalancerVipConfig {
    /**
    * The VIP which you previously set aside for the Kubernetes API of this cluster.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gkeonprem_vmware_cluster#control_plane_vip GoogleGkeonpremVmwareCluster#control_plane_vip}
    */
    readonly controlPlaneVip?: string;
    /**
    * The VIP which you previously set aside for ingress traffic into this cluster.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gkeonprem_vmware_cluster#ingress_vip GoogleGkeonpremVmwareCluster#ingress_vip}
    */
    readonly ingressVip?: string;
}
export declare function googleGkeonpremVmwareClusterLoadBalancerVipConfigToTerraform(struct?: GoogleGkeonpremVmwareClusterLoadBalancerVipConfigOutputReference | GoogleGkeonpremVmwareClusterLoadBalancerVipConfig): any;
export declare function googleGkeonpremVmwareClusterLoadBalancerVipConfigToHclTerraform(struct?: GoogleGkeonpremVmwareClusterLoadBalancerVipConfigOutputReference | GoogleGkeonpremVmwareClusterLoadBalancerVipConfig): any;
export declare class GoogleGkeonpremVmwareClusterLoadBalancerVipConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleGkeonpremVmwareClusterLoadBalancerVipConfig | undefined;
    set internalValue(value: GoogleGkeonpremVmwareClusterLoadBalancerVipConfig | undefined);
    private _controlPlaneVip?;
    get controlPlaneVip(): string;
    set controlPlaneVip(value: string);
    resetControlPlaneVip(): void;
    get controlPlaneVipInput(): string | undefined;
    private _ingressVip?;
    get ingressVip(): string;
    set ingressVip(value: string);
    resetIngressVip(): void;
    get ingressVipInput(): string | undefined;
}
export interface GoogleGkeonpremVmwareClusterLoadBalancer {
    /**
    * f5_config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gkeonprem_vmware_cluster#f5_config GoogleGkeonpremVmwareCluster#f5_config}
    */
    readonly f5Config?: GoogleGkeonpremVmwareClusterLoadBalancerF5Config;
    /**
    * manual_lb_config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gkeonprem_vmware_cluster#manual_lb_config GoogleGkeonpremVmwareCluster#manual_lb_config}
    */
    readonly manualLbConfig?: GoogleGkeonpremVmwareClusterLoadBalancerManualLbConfig;
    /**
    * metal_lb_config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gkeonprem_vmware_cluster#metal_lb_config GoogleGkeonpremVmwareCluster#metal_lb_config}
    */
    readonly metalLbConfig?: GoogleGkeonpremVmwareClusterLoadBalancerMetalLbConfig;
    /**
    * vip_config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gkeonprem_vmware_cluster#vip_config GoogleGkeonpremVmwareCluster#vip_config}
    */
    readonly vipConfig?: GoogleGkeonpremVmwareClusterLoadBalancerVipConfig;
}
export declare function googleGkeonpremVmwareClusterLoadBalancerToTerraform(struct?: GoogleGkeonpremVmwareClusterLoadBalancerOutputReference | GoogleGkeonpremVmwareClusterLoadBalancer): any;
export declare function googleGkeonpremVmwareClusterLoadBalancerToHclTerraform(struct?: GoogleGkeonpremVmwareClusterLoadBalancerOutputReference | GoogleGkeonpremVmwareClusterLoadBalancer): any;
export declare class GoogleGkeonpremVmwareClusterLoadBalancerOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleGkeonpremVmwareClusterLoadBalancer | undefined;
    set internalValue(value: GoogleGkeonpremVmwareClusterLoadBalancer | undefined);
    private _f5Config;
    get f5Config(): GoogleGkeonpremVmwareClusterLoadBalancerF5ConfigOutputReference;
    putF5Config(value: GoogleGkeonpremVmwareClusterLoadBalancerF5Config): void;
    resetF5Config(): void;
    get f5ConfigInput(): GoogleGkeonpremVmwareClusterLoadBalancerF5Config | undefined;
    private _manualLbConfig;
    get manualLbConfig(): GoogleGkeonpremVmwareClusterLoadBalancerManualLbConfigOutputReference;
    putManualLbConfig(value: GoogleGkeonpremVmwareClusterLoadBalancerManualLbConfig): void;
    resetManualLbConfig(): void;
    get manualLbConfigInput(): GoogleGkeonpremVmwareClusterLoadBalancerManualLbConfig | undefined;
    private _metalLbConfig;
    get metalLbConfig(): GoogleGkeonpremVmwareClusterLoadBalancerMetalLbConfigOutputReference;
    putMetalLbConfig(value: GoogleGkeonpremVmwareClusterLoadBalancerMetalLbConfig): void;
    resetMetalLbConfig(): void;
    get metalLbConfigInput(): GoogleGkeonpremVmwareClusterLoadBalancerMetalLbConfig | undefined;
    private _vipConfig;
    get vipConfig(): GoogleGkeonpremVmwareClusterLoadBalancerVipConfigOutputReference;
    putVipConfig(value: GoogleGkeonpremVmwareClusterLoadBalancerVipConfig): void;
    resetVipConfig(): void;
    get vipConfigInput(): GoogleGkeonpremVmwareClusterLoadBalancerVipConfig | undefined;
}
export interface GoogleGkeonpremVmwareClusterNetworkConfigControlPlaneV2ConfigControlPlaneIpBlockIps {
    /**
    * Hostname of the machine. VM's name will be used if this field is empty.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gkeonprem_vmware_cluster#hostname GoogleGkeonpremVmwareCluster#hostname}
    */
    readonly hostname?: string;
    /**
    * IP could be an IP address (like 1.2.3.4) or a CIDR (like 1.2.3.0/24).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gkeonprem_vmware_cluster#ip GoogleGkeonpremVmwareCluster#ip}
    */
    readonly ip?: string;
}
export declare function googleGkeonpremVmwareClusterNetworkConfigControlPlaneV2ConfigControlPlaneIpBlockIpsToTerraform(struct?: GoogleGkeonpremVmwareClusterNetworkConfigControlPlaneV2ConfigControlPlaneIpBlockIps | cdktf.IResolvable): any;
export declare function googleGkeonpremVmwareClusterNetworkConfigControlPlaneV2ConfigControlPlaneIpBlockIpsToHclTerraform(struct?: GoogleGkeonpremVmwareClusterNetworkConfigControlPlaneV2ConfigControlPlaneIpBlockIps | cdktf.IResolvable): any;
export declare class GoogleGkeonpremVmwareClusterNetworkConfigControlPlaneV2ConfigControlPlaneIpBlockIpsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleGkeonpremVmwareClusterNetworkConfigControlPlaneV2ConfigControlPlaneIpBlockIps | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleGkeonpremVmwareClusterNetworkConfigControlPlaneV2ConfigControlPlaneIpBlockIps | cdktf.IResolvable | undefined);
    private _hostname?;
    get hostname(): string;
    set hostname(value: string);
    resetHostname(): void;
    get hostnameInput(): string | undefined;
    private _ip?;
    get ip(): string;
    set ip(value: string);
    resetIp(): void;
    get ipInput(): string | undefined;
}
export declare class GoogleGkeonpremVmwareClusterNetworkConfigControlPlaneV2ConfigControlPlaneIpBlockIpsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleGkeonpremVmwareClusterNetworkConfigControlPlaneV2ConfigControlPlaneIpBlockIps[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleGkeonpremVmwareClusterNetworkConfigControlPlaneV2ConfigControlPlaneIpBlockIpsOutputReference;
}
export interface GoogleGkeonpremVmwareClusterNetworkConfigControlPlaneV2ConfigControlPlaneIpBlock {
    /**
    * The network gateway used by the VMware User Cluster.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gkeonprem_vmware_cluster#gateway GoogleGkeonpremVmwareCluster#gateway}
    */
    readonly gateway?: string;
    /**
    * The netmask used by the VMware User Cluster.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gkeonprem_vmware_cluster#netmask GoogleGkeonpremVmwareCluster#netmask}
    */
    readonly netmask?: string;
    /**
    * ips block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gkeonprem_vmware_cluster#ips GoogleGkeonpremVmwareCluster#ips}
    */
    readonly ips?: GoogleGkeonpremVmwareClusterNetworkConfigControlPlaneV2ConfigControlPlaneIpBlockIps[] | cdktf.IResolvable;
}
export declare function googleGkeonpremVmwareClusterNetworkConfigControlPlaneV2ConfigControlPlaneIpBlockToTerraform(struct?: GoogleGkeonpremVmwareClusterNetworkConfigControlPlaneV2ConfigControlPlaneIpBlockOutputReference | GoogleGkeonpremVmwareClusterNetworkConfigControlPlaneV2ConfigControlPlaneIpBlock): any;
export declare function googleGkeonpremVmwareClusterNetworkConfigControlPlaneV2ConfigControlPlaneIpBlockToHclTerraform(struct?: GoogleGkeonpremVmwareClusterNetworkConfigControlPlaneV2ConfigControlPlaneIpBlockOutputReference | GoogleGkeonpremVmwareClusterNetworkConfigControlPlaneV2ConfigControlPlaneIpBlock): any;
export declare class GoogleGkeonpremVmwareClusterNetworkConfigControlPlaneV2ConfigControlPlaneIpBlockOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleGkeonpremVmwareClusterNetworkConfigControlPlaneV2ConfigControlPlaneIpBlock | undefined;
    set internalValue(value: GoogleGkeonpremVmwareClusterNetworkConfigControlPlaneV2ConfigControlPlaneIpBlock | undefined);
    private _gateway?;
    get gateway(): string;
    set gateway(value: string);
    resetGateway(): void;
    get gatewayInput(): string | undefined;
    private _netmask?;
    get netmask(): string;
    set netmask(value: string);
    resetNetmask(): void;
    get netmaskInput(): string | undefined;
    private _ips;
    get ips(): GoogleGkeonpremVmwareClusterNetworkConfigControlPlaneV2ConfigControlPlaneIpBlockIpsList;
    putIps(value: GoogleGkeonpremVmwareClusterNetworkConfigControlPlaneV2ConfigControlPlaneIpBlockIps[] | cdktf.IResolvable): void;
    resetIps(): void;
    get ipsInput(): cdktf.IResolvable | GoogleGkeonpremVmwareClusterNetworkConfigControlPlaneV2ConfigControlPlaneIpBlockIps[] | undefined;
}
export interface GoogleGkeonpremVmwareClusterNetworkConfigControlPlaneV2Config {
    /**
    * control_plane_ip_block block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gkeonprem_vmware_cluster#control_plane_ip_block GoogleGkeonpremVmwareCluster#control_plane_ip_block}
    */
    readonly controlPlaneIpBlock?: GoogleGkeonpremVmwareClusterNetworkConfigControlPlaneV2ConfigControlPlaneIpBlock;
}
export declare function googleGkeonpremVmwareClusterNetworkConfigControlPlaneV2ConfigToTerraform(struct?: GoogleGkeonpremVmwareClusterNetworkConfigControlPlaneV2ConfigOutputReference | GoogleGkeonpremVmwareClusterNetworkConfigControlPlaneV2Config): any;
export declare function googleGkeonpremVmwareClusterNetworkConfigControlPlaneV2ConfigToHclTerraform(struct?: GoogleGkeonpremVmwareClusterNetworkConfigControlPlaneV2ConfigOutputReference | GoogleGkeonpremVmwareClusterNetworkConfigControlPlaneV2Config): any;
export declare class GoogleGkeonpremVmwareClusterNetworkConfigControlPlaneV2ConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleGkeonpremVmwareClusterNetworkConfigControlPlaneV2Config | undefined;
    set internalValue(value: GoogleGkeonpremVmwareClusterNetworkConfigControlPlaneV2Config | undefined);
    private _controlPlaneIpBlock;
    get controlPlaneIpBlock(): GoogleGkeonpremVmwareClusterNetworkConfigControlPlaneV2ConfigControlPlaneIpBlockOutputReference;
    putControlPlaneIpBlock(value: GoogleGkeonpremVmwareClusterNetworkConfigControlPlaneV2ConfigControlPlaneIpBlock): void;
    resetControlPlaneIpBlock(): void;
    get controlPlaneIpBlockInput(): GoogleGkeonpremVmwareClusterNetworkConfigControlPlaneV2ConfigControlPlaneIpBlock | undefined;
}
export interface GoogleGkeonpremVmwareClusterNetworkConfigDhcpIpConfig {
    /**
    * enabled is a flag to mark if DHCP IP allocation is
    * used for VMware user clusters.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gkeonprem_vmware_cluster#enabled GoogleGkeonpremVmwareCluster#enabled}
    */
    readonly enabled: boolean | cdktf.IResolvable;
}
export declare function googleGkeonpremVmwareClusterNetworkConfigDhcpIpConfigToTerraform(struct?: GoogleGkeonpremVmwareClusterNetworkConfigDhcpIpConfigOutputReference | GoogleGkeonpremVmwareClusterNetworkConfigDhcpIpConfig): any;
export declare function googleGkeonpremVmwareClusterNetworkConfigDhcpIpConfigToHclTerraform(struct?: GoogleGkeonpremVmwareClusterNetworkConfigDhcpIpConfigOutputReference | GoogleGkeonpremVmwareClusterNetworkConfigDhcpIpConfig): any;
export declare class GoogleGkeonpremVmwareClusterNetworkConfigDhcpIpConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleGkeonpremVmwareClusterNetworkConfigDhcpIpConfig | undefined;
    set internalValue(value: GoogleGkeonpremVmwareClusterNetworkConfigDhcpIpConfig | undefined);
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
}
export interface GoogleGkeonpremVmwareClusterNetworkConfigHostConfig {
    /**
    * DNS search domains.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gkeonprem_vmware_cluster#dns_search_domains GoogleGkeonpremVmwareCluster#dns_search_domains}
    */
    readonly dnsSearchDomains?: string[];
    /**
    * DNS servers.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gkeonprem_vmware_cluster#dns_servers GoogleGkeonpremVmwareCluster#dns_servers}
    */
    readonly dnsServers?: string[];
    /**
    * NTP servers.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gkeonprem_vmware_cluster#ntp_servers GoogleGkeonpremVmwareCluster#ntp_servers}
    */
    readonly ntpServers?: string[];
}
export declare function googleGkeonpremVmwareClusterNetworkConfigHostConfigToTerraform(struct?: GoogleGkeonpremVmwareClusterNetworkConfigHostConfigOutputReference | GoogleGkeonpremVmwareClusterNetworkConfigHostConfig): any;
export declare function googleGkeonpremVmwareClusterNetworkConfigHostConfigToHclTerraform(struct?: GoogleGkeonpremVmwareClusterNetworkConfigHostConfigOutputReference | GoogleGkeonpremVmwareClusterNetworkConfigHostConfig): any;
export declare class GoogleGkeonpremVmwareClusterNetworkConfigHostConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleGkeonpremVmwareClusterNetworkConfigHostConfig | undefined;
    set internalValue(value: GoogleGkeonpremVmwareClusterNetworkConfigHostConfig | undefined);
    private _dnsSearchDomains?;
    get dnsSearchDomains(): string[];
    set dnsSearchDomains(value: string[]);
    resetDnsSearchDomains(): void;
    get dnsSearchDomainsInput(): string[] | undefined;
    private _dnsServers?;
    get dnsServers(): string[];
    set dnsServers(value: string[]);
    resetDnsServers(): void;
    get dnsServersInput(): string[] | undefined;
    private _ntpServers?;
    get ntpServers(): string[];
    set ntpServers(value: string[]);
    resetNtpServers(): void;
    get ntpServersInput(): string[] | undefined;
}
export interface GoogleGkeonpremVmwareClusterNetworkConfigStaticIpConfigIpBlocksIps {
    /**
    * Hostname of the machine. VM's name will be used if this field is empty.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gkeonprem_vmware_cluster#hostname GoogleGkeonpremVmwareCluster#hostname}
    */
    readonly hostname?: string;
    /**
    * IP could be an IP address (like 1.2.3.4) or a CIDR (like 1.2.3.0/24).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gkeonprem_vmware_cluster#ip GoogleGkeonpremVmwareCluster#ip}
    */
    readonly ip: string;
}
export declare function googleGkeonpremVmwareClusterNetworkConfigStaticIpConfigIpBlocksIpsToTerraform(struct?: GoogleGkeonpremVmwareClusterNetworkConfigStaticIpConfigIpBlocksIps | cdktf.IResolvable): any;
export declare function googleGkeonpremVmwareClusterNetworkConfigStaticIpConfigIpBlocksIpsToHclTerraform(struct?: GoogleGkeonpremVmwareClusterNetworkConfigStaticIpConfigIpBlocksIps | cdktf.IResolvable): any;
export declare class GoogleGkeonpremVmwareClusterNetworkConfigStaticIpConfigIpBlocksIpsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleGkeonpremVmwareClusterNetworkConfigStaticIpConfigIpBlocksIps | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleGkeonpremVmwareClusterNetworkConfigStaticIpConfigIpBlocksIps | cdktf.IResolvable | undefined);
    private _hostname?;
    get hostname(): string;
    set hostname(value: string);
    resetHostname(): void;
    get hostnameInput(): string | undefined;
    private _ip?;
    get ip(): string;
    set ip(value: string);
    get ipInput(): string | undefined;
}
export declare class GoogleGkeonpremVmwareClusterNetworkConfigStaticIpConfigIpBlocksIpsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleGkeonpremVmwareClusterNetworkConfigStaticIpConfigIpBlocksIps[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleGkeonpremVmwareClusterNetworkConfigStaticIpConfigIpBlocksIpsOutputReference;
}
export interface GoogleGkeonpremVmwareClusterNetworkConfigStaticIpConfigIpBlocks {
    /**
    * The network gateway used by the VMware User Cluster.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gkeonprem_vmware_cluster#gateway GoogleGkeonpremVmwareCluster#gateway}
    */
    readonly gateway: string;
    /**
    * The netmask used by the VMware User Cluster.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gkeonprem_vmware_cluster#netmask GoogleGkeonpremVmwareCluster#netmask}
    */
    readonly netmask: string;
    /**
    * ips block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gkeonprem_vmware_cluster#ips GoogleGkeonpremVmwareCluster#ips}
    */
    readonly ips: GoogleGkeonpremVmwareClusterNetworkConfigStaticIpConfigIpBlocksIps[] | cdktf.IResolvable;
}
export declare function googleGkeonpremVmwareClusterNetworkConfigStaticIpConfigIpBlocksToTerraform(struct?: GoogleGkeonpremVmwareClusterNetworkConfigStaticIpConfigIpBlocks | cdktf.IResolvable): any;
export declare function googleGkeonpremVmwareClusterNetworkConfigStaticIpConfigIpBlocksToHclTerraform(struct?: GoogleGkeonpremVmwareClusterNetworkConfigStaticIpConfigIpBlocks | cdktf.IResolvable): any;
export declare class GoogleGkeonpremVmwareClusterNetworkConfigStaticIpConfigIpBlocksOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleGkeonpremVmwareClusterNetworkConfigStaticIpConfigIpBlocks | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleGkeonpremVmwareClusterNetworkConfigStaticIpConfigIpBlocks | cdktf.IResolvable | undefined);
    private _gateway?;
    get gateway(): string;
    set gateway(value: string);
    get gatewayInput(): string | undefined;
    private _netmask?;
    get netmask(): string;
    set netmask(value: string);
    get netmaskInput(): string | undefined;
    private _ips;
    get ips(): GoogleGkeonpremVmwareClusterNetworkConfigStaticIpConfigIpBlocksIpsList;
    putIps(value: GoogleGkeonpremVmwareClusterNetworkConfigStaticIpConfigIpBlocksIps[] | cdktf.IResolvable): void;
    get ipsInput(): cdktf.IResolvable | GoogleGkeonpremVmwareClusterNetworkConfigStaticIpConfigIpBlocksIps[] | undefined;
}
export declare class GoogleGkeonpremVmwareClusterNetworkConfigStaticIpConfigIpBlocksList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleGkeonpremVmwareClusterNetworkConfigStaticIpConfigIpBlocks[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleGkeonpremVmwareClusterNetworkConfigStaticIpConfigIpBlocksOutputReference;
}
export interface GoogleGkeonpremVmwareClusterNetworkConfigStaticIpConfig {
    /**
    * ip_blocks block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gkeonprem_vmware_cluster#ip_blocks GoogleGkeonpremVmwareCluster#ip_blocks}
    */
    readonly ipBlocks: GoogleGkeonpremVmwareClusterNetworkConfigStaticIpConfigIpBlocks[] | cdktf.IResolvable;
}
export declare function googleGkeonpremVmwareClusterNetworkConfigStaticIpConfigToTerraform(struct?: GoogleGkeonpremVmwareClusterNetworkConfigStaticIpConfigOutputReference | GoogleGkeonpremVmwareClusterNetworkConfigStaticIpConfig): any;
export declare function googleGkeonpremVmwareClusterNetworkConfigStaticIpConfigToHclTerraform(struct?: GoogleGkeonpremVmwareClusterNetworkConfigStaticIpConfigOutputReference | GoogleGkeonpremVmwareClusterNetworkConfigStaticIpConfig): any;
export declare class GoogleGkeonpremVmwareClusterNetworkConfigStaticIpConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleGkeonpremVmwareClusterNetworkConfigStaticIpConfig | undefined;
    set internalValue(value: GoogleGkeonpremVmwareClusterNetworkConfigStaticIpConfig | undefined);
    private _ipBlocks;
    get ipBlocks(): GoogleGkeonpremVmwareClusterNetworkConfigStaticIpConfigIpBlocksList;
    putIpBlocks(value: GoogleGkeonpremVmwareClusterNetworkConfigStaticIpConfigIpBlocks[] | cdktf.IResolvable): void;
    get ipBlocksInput(): cdktf.IResolvable | GoogleGkeonpremVmwareClusterNetworkConfigStaticIpConfigIpBlocks[] | undefined;
}
export interface GoogleGkeonpremVmwareClusterNetworkConfig {
    /**
    * All pods in the cluster are assigned an RFC1918 IPv4 address from these ranges.
    * Only a single range is supported. This field cannot be changed after creation.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gkeonprem_vmware_cluster#pod_address_cidr_blocks GoogleGkeonpremVmwareCluster#pod_address_cidr_blocks}
    */
    readonly podAddressCidrBlocks: string[];
    /**
    * All services in the cluster are assigned an RFC1918 IPv4 address
    * from these ranges. Only a single range is supported.. This field
    * cannot be changed after creation.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gkeonprem_vmware_cluster#service_address_cidr_blocks GoogleGkeonpremVmwareCluster#service_address_cidr_blocks}
    */
    readonly serviceAddressCidrBlocks: string[];
    /**
    * vcenter_network specifies vCenter network name. Inherited from the admin cluster.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gkeonprem_vmware_cluster#vcenter_network GoogleGkeonpremVmwareCluster#vcenter_network}
    */
    readonly vcenterNetwork?: string;
    /**
    * control_plane_v2_config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gkeonprem_vmware_cluster#control_plane_v2_config GoogleGkeonpremVmwareCluster#control_plane_v2_config}
    */
    readonly controlPlaneV2Config?: GoogleGkeonpremVmwareClusterNetworkConfigControlPlaneV2Config;
    /**
    * dhcp_ip_config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gkeonprem_vmware_cluster#dhcp_ip_config GoogleGkeonpremVmwareCluster#dhcp_ip_config}
    */
    readonly dhcpIpConfig?: GoogleGkeonpremVmwareClusterNetworkConfigDhcpIpConfig;
    /**
    * host_config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gkeonprem_vmware_cluster#host_config GoogleGkeonpremVmwareCluster#host_config}
    */
    readonly hostConfig?: GoogleGkeonpremVmwareClusterNetworkConfigHostConfig;
    /**
    * static_ip_config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gkeonprem_vmware_cluster#static_ip_config GoogleGkeonpremVmwareCluster#static_ip_config}
    */
    readonly staticIpConfig?: GoogleGkeonpremVmwareClusterNetworkConfigStaticIpConfig;
}
export declare function googleGkeonpremVmwareClusterNetworkConfigToTerraform(struct?: GoogleGkeonpremVmwareClusterNetworkConfigOutputReference | GoogleGkeonpremVmwareClusterNetworkConfig): any;
export declare function googleGkeonpremVmwareClusterNetworkConfigToHclTerraform(struct?: GoogleGkeonpremVmwareClusterNetworkConfigOutputReference | GoogleGkeonpremVmwareClusterNetworkConfig): any;
export declare class GoogleGkeonpremVmwareClusterNetworkConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleGkeonpremVmwareClusterNetworkConfig | undefined;
    set internalValue(value: GoogleGkeonpremVmwareClusterNetworkConfig | undefined);
    private _podAddressCidrBlocks?;
    get podAddressCidrBlocks(): string[];
    set podAddressCidrBlocks(value: string[]);
    get podAddressCidrBlocksInput(): string[] | undefined;
    private _serviceAddressCidrBlocks?;
    get serviceAddressCidrBlocks(): string[];
    set serviceAddressCidrBlocks(value: string[]);
    get serviceAddressCidrBlocksInput(): string[] | undefined;
    private _vcenterNetwork?;
    get vcenterNetwork(): string;
    set vcenterNetwork(value: string);
    resetVcenterNetwork(): void;
    get vcenterNetworkInput(): string | undefined;
    private _controlPlaneV2Config;
    get controlPlaneV2Config(): GoogleGkeonpremVmwareClusterNetworkConfigControlPlaneV2ConfigOutputReference;
    putControlPlaneV2Config(value: GoogleGkeonpremVmwareClusterNetworkConfigControlPlaneV2Config): void;
    resetControlPlaneV2Config(): void;
    get controlPlaneV2ConfigInput(): GoogleGkeonpremVmwareClusterNetworkConfigControlPlaneV2Config | undefined;
    private _dhcpIpConfig;
    get dhcpIpConfig(): GoogleGkeonpremVmwareClusterNetworkConfigDhcpIpConfigOutputReference;
    putDhcpIpConfig(value: GoogleGkeonpremVmwareClusterNetworkConfigDhcpIpConfig): void;
    resetDhcpIpConfig(): void;
    get dhcpIpConfigInput(): GoogleGkeonpremVmwareClusterNetworkConfigDhcpIpConfig | undefined;
    private _hostConfig;
    get hostConfig(): GoogleGkeonpremVmwareClusterNetworkConfigHostConfigOutputReference;
    putHostConfig(value: GoogleGkeonpremVmwareClusterNetworkConfigHostConfig): void;
    resetHostConfig(): void;
    get hostConfigInput(): GoogleGkeonpremVmwareClusterNetworkConfigHostConfig | undefined;
    private _staticIpConfig;
    get staticIpConfig(): GoogleGkeonpremVmwareClusterNetworkConfigStaticIpConfigOutputReference;
    putStaticIpConfig(value: GoogleGkeonpremVmwareClusterNetworkConfigStaticIpConfig): void;
    resetStaticIpConfig(): void;
    get staticIpConfigInput(): GoogleGkeonpremVmwareClusterNetworkConfigStaticIpConfig | undefined;
}
export interface GoogleGkeonpremVmwareClusterStorage {
    /**
    * Whether or not to deploy vSphere CSI components in the VMware User Cluster.
    * Enabled by default.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gkeonprem_vmware_cluster#vsphere_csi_disabled GoogleGkeonpremVmwareCluster#vsphere_csi_disabled}
    */
    readonly vsphereCsiDisabled: boolean | cdktf.IResolvable;
}
export declare function googleGkeonpremVmwareClusterStorageToTerraform(struct?: GoogleGkeonpremVmwareClusterStorageOutputReference | GoogleGkeonpremVmwareClusterStorage): any;
export declare function googleGkeonpremVmwareClusterStorageToHclTerraform(struct?: GoogleGkeonpremVmwareClusterStorageOutputReference | GoogleGkeonpremVmwareClusterStorage): any;
export declare class GoogleGkeonpremVmwareClusterStorageOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleGkeonpremVmwareClusterStorage | undefined;
    set internalValue(value: GoogleGkeonpremVmwareClusterStorage | undefined);
    private _vsphereCsiDisabled?;
    get vsphereCsiDisabled(): boolean | cdktf.IResolvable;
    set vsphereCsiDisabled(value: boolean | cdktf.IResolvable);
    get vsphereCsiDisabledInput(): boolean | cdktf.IResolvable | undefined;
}
export interface GoogleGkeonpremVmwareClusterTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gkeonprem_vmware_cluster#create GoogleGkeonpremVmwareCluster#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gkeonprem_vmware_cluster#delete GoogleGkeonpremVmwareCluster#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gkeonprem_vmware_cluster#update GoogleGkeonpremVmwareCluster#update}
    */
    readonly update?: string;
}
export declare function googleGkeonpremVmwareClusterTimeoutsToTerraform(struct?: GoogleGkeonpremVmwareClusterTimeouts | cdktf.IResolvable): any;
export declare function googleGkeonpremVmwareClusterTimeoutsToHclTerraform(struct?: GoogleGkeonpremVmwareClusterTimeouts | cdktf.IResolvable): any;
export declare class GoogleGkeonpremVmwareClusterTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleGkeonpremVmwareClusterTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleGkeonpremVmwareClusterTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
export interface GoogleGkeonpremVmwareClusterUpgradePolicy {
    /**
    * Controls whether the upgrade applies to the control plane only.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gkeonprem_vmware_cluster#control_plane_only GoogleGkeonpremVmwareCluster#control_plane_only}
    */
    readonly controlPlaneOnly?: boolean | cdktf.IResolvable;
}
export declare function googleGkeonpremVmwareClusterUpgradePolicyToTerraform(struct?: GoogleGkeonpremVmwareClusterUpgradePolicyOutputReference | GoogleGkeonpremVmwareClusterUpgradePolicy): any;
export declare function googleGkeonpremVmwareClusterUpgradePolicyToHclTerraform(struct?: GoogleGkeonpremVmwareClusterUpgradePolicyOutputReference | GoogleGkeonpremVmwareClusterUpgradePolicy): any;
export declare class GoogleGkeonpremVmwareClusterUpgradePolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleGkeonpremVmwareClusterUpgradePolicy | undefined;
    set internalValue(value: GoogleGkeonpremVmwareClusterUpgradePolicy | undefined);
    private _controlPlaneOnly?;
    get controlPlaneOnly(): boolean | cdktf.IResolvable;
    set controlPlaneOnly(value: boolean | cdktf.IResolvable);
    resetControlPlaneOnly(): void;
    get controlPlaneOnlyInput(): boolean | cdktf.IResolvable | undefined;
}
export interface GoogleGkeonpremVmwareClusterVcenter {
    /**
    * Contains the vCenter CA certificate public key for SSL verification.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gkeonprem_vmware_cluster#ca_cert_data GoogleGkeonpremVmwareCluster#ca_cert_data}
    */
    readonly caCertData?: string;
    /**
    * The name of the vCenter cluster for the user cluster.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gkeonprem_vmware_cluster#cluster GoogleGkeonpremVmwareCluster#cluster}
    */
    readonly cluster?: string;
    /**
    * The name of the vCenter datacenter for the user cluster.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gkeonprem_vmware_cluster#datacenter GoogleGkeonpremVmwareCluster#datacenter}
    */
    readonly datacenter?: string;
    /**
    * The name of the vCenter datastore for the user cluster.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gkeonprem_vmware_cluster#datastore GoogleGkeonpremVmwareCluster#datastore}
    */
    readonly datastore?: string;
    /**
    * The name of the vCenter folder for the user cluster.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gkeonprem_vmware_cluster#folder GoogleGkeonpremVmwareCluster#folder}
    */
    readonly folder?: string;
    /**
    * The name of the vCenter resource pool for the user cluster.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gkeonprem_vmware_cluster#resource_pool GoogleGkeonpremVmwareCluster#resource_pool}
    */
    readonly resourcePool?: string;
    /**
    * The name of the vCenter storage policy for the user cluster.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gkeonprem_vmware_cluster#storage_policy_name GoogleGkeonpremVmwareCluster#storage_policy_name}
    */
    readonly storagePolicyName?: string;
}
export declare function googleGkeonpremVmwareClusterVcenterToTerraform(struct?: GoogleGkeonpremVmwareClusterVcenterOutputReference | GoogleGkeonpremVmwareClusterVcenter): any;
export declare function googleGkeonpremVmwareClusterVcenterToHclTerraform(struct?: GoogleGkeonpremVmwareClusterVcenterOutputReference | GoogleGkeonpremVmwareClusterVcenter): any;
export declare class GoogleGkeonpremVmwareClusterVcenterOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleGkeonpremVmwareClusterVcenter | undefined;
    set internalValue(value: GoogleGkeonpremVmwareClusterVcenter | undefined);
    get address(): string;
    private _caCertData?;
    get caCertData(): string;
    set caCertData(value: string);
    resetCaCertData(): void;
    get caCertDataInput(): string | undefined;
    private _cluster?;
    get cluster(): string;
    set cluster(value: string);
    resetCluster(): void;
    get clusterInput(): string | undefined;
    private _datacenter?;
    get datacenter(): string;
    set datacenter(value: string);
    resetDatacenter(): void;
    get datacenterInput(): string | undefined;
    private _datastore?;
    get datastore(): string;
    set datastore(value: string);
    resetDatastore(): void;
    get datastoreInput(): string | undefined;
    private _folder?;
    get folder(): string;
    set folder(value: string);
    resetFolder(): void;
    get folderInput(): string | undefined;
    private _resourcePool?;
    get resourcePool(): string;
    set resourcePool(value: string);
    resetResourcePool(): void;
    get resourcePoolInput(): string | undefined;
    private _storagePolicyName?;
    get storagePolicyName(): string;
    set storagePolicyName(value: string);
    resetStoragePolicyName(): void;
    get storagePolicyNameInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gkeonprem_vmware_cluster google_gkeonprem_vmware_cluster}
*/
export declare class GoogleGkeonpremVmwareCluster extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_gkeonprem_vmware_cluster";
    /**
    * Generates CDKTF code for importing a GoogleGkeonpremVmwareCluster resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the GoogleGkeonpremVmwareCluster to import
    * @param importFromId The id of the existing GoogleGkeonpremVmwareCluster that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gkeonprem_vmware_cluster#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the GoogleGkeonpremVmwareCluster to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gkeonprem_vmware_cluster google_gkeonprem_vmware_cluster} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleGkeonpremVmwareClusterConfig
    */
    constructor(scope: Construct, id: string, config: GoogleGkeonpremVmwareClusterConfig);
    private _adminClusterMembership?;
    get adminClusterMembership(): string;
    set adminClusterMembership(value: string);
    get adminClusterMembershipInput(): string | undefined;
    private _annotations?;
    get annotations(): {
        [key: string]: string;
    };
    set annotations(value: {
        [key: string]: string;
    });
    resetAnnotations(): void;
    get annotationsInput(): {
        [key: string]: string;
    } | undefined;
    get createTime(): string;
    get deleteTime(): string;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _effectiveAnnotations;
    get effectiveAnnotations(): cdktf.StringMap;
    private _enableControlPlaneV2?;
    get enableControlPlaneV2(): boolean | cdktf.IResolvable;
    set enableControlPlaneV2(value: boolean | cdktf.IResolvable);
    resetEnableControlPlaneV2(): void;
    get enableControlPlaneV2Input(): boolean | cdktf.IResolvable | undefined;
    get endpoint(): string;
    get etag(): string;
    private _fleet;
    get fleet(): GoogleGkeonpremVmwareClusterFleetList;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get localName(): string;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _onPremVersion?;
    get onPremVersion(): string;
    set onPremVersion(value: string);
    get onPremVersionInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    get reconciling(): cdktf.IResolvable;
    get state(): string;
    private _status;
    get status(): GoogleGkeonpremVmwareClusterStatusList;
    get uid(): string;
    get updateTime(): string;
    private _validationCheck;
    get validationCheck(): GoogleGkeonpremVmwareClusterValidationCheckList;
    private _vmTrackingEnabled?;
    get vmTrackingEnabled(): boolean | cdktf.IResolvable;
    set vmTrackingEnabled(value: boolean | cdktf.IResolvable);
    resetVmTrackingEnabled(): void;
    get vmTrackingEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _antiAffinityGroups;
    get antiAffinityGroups(): GoogleGkeonpremVmwareClusterAntiAffinityGroupsOutputReference;
    putAntiAffinityGroups(value: GoogleGkeonpremVmwareClusterAntiAffinityGroups): void;
    resetAntiAffinityGroups(): void;
    get antiAffinityGroupsInput(): GoogleGkeonpremVmwareClusterAntiAffinityGroups | undefined;
    private _authorization;
    get authorization(): GoogleGkeonpremVmwareClusterAuthorizationOutputReference;
    putAuthorization(value: GoogleGkeonpremVmwareClusterAuthorization): void;
    resetAuthorization(): void;
    get authorizationInput(): GoogleGkeonpremVmwareClusterAuthorization | undefined;
    private _autoRepairConfig;
    get autoRepairConfig(): GoogleGkeonpremVmwareClusterAutoRepairConfigOutputReference;
    putAutoRepairConfig(value: GoogleGkeonpremVmwareClusterAutoRepairConfig): void;
    resetAutoRepairConfig(): void;
    get autoRepairConfigInput(): GoogleGkeonpremVmwareClusterAutoRepairConfig | undefined;
    private _controlPlaneNode;
    get controlPlaneNode(): GoogleGkeonpremVmwareClusterControlPlaneNodeOutputReference;
    putControlPlaneNode(value: GoogleGkeonpremVmwareClusterControlPlaneNode): void;
    get controlPlaneNodeInput(): GoogleGkeonpremVmwareClusterControlPlaneNode | undefined;
    private _dataplaneV2;
    get dataplaneV2(): GoogleGkeonpremVmwareClusterDataplaneV2OutputReference;
    putDataplaneV2(value: GoogleGkeonpremVmwareClusterDataplaneV2): void;
    resetDataplaneV2(): void;
    get dataplaneV2Input(): GoogleGkeonpremVmwareClusterDataplaneV2 | undefined;
    private _loadBalancer;
    get loadBalancer(): GoogleGkeonpremVmwareClusterLoadBalancerOutputReference;
    putLoadBalancer(value: GoogleGkeonpremVmwareClusterLoadBalancer): void;
    resetLoadBalancer(): void;
    get loadBalancerInput(): GoogleGkeonpremVmwareClusterLoadBalancer | undefined;
    private _networkConfig;
    get networkConfig(): GoogleGkeonpremVmwareClusterNetworkConfigOutputReference;
    putNetworkConfig(value: GoogleGkeonpremVmwareClusterNetworkConfig): void;
    resetNetworkConfig(): void;
    get networkConfigInput(): GoogleGkeonpremVmwareClusterNetworkConfig | undefined;
    private _storage;
    get storage(): GoogleGkeonpremVmwareClusterStorageOutputReference;
    putStorage(value: GoogleGkeonpremVmwareClusterStorage): void;
    resetStorage(): void;
    get storageInput(): GoogleGkeonpremVmwareClusterStorage | undefined;
    private _timeouts;
    get timeouts(): GoogleGkeonpremVmwareClusterTimeoutsOutputReference;
    putTimeouts(value: GoogleGkeonpremVmwareClusterTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleGkeonpremVmwareClusterTimeouts | undefined;
    private _upgradePolicy;
    get upgradePolicy(): GoogleGkeonpremVmwareClusterUpgradePolicyOutputReference;
    putUpgradePolicy(value: GoogleGkeonpremVmwareClusterUpgradePolicy): void;
    resetUpgradePolicy(): void;
    get upgradePolicyInput(): GoogleGkeonpremVmwareClusterUpgradePolicy | undefined;
    private _vcenter;
    get vcenter(): GoogleGkeonpremVmwareClusterVcenterOutputReference;
    putVcenter(value: GoogleGkeonpremVmwareClusterVcenter): void;
    resetVcenter(): void;
    get vcenterInput(): GoogleGkeonpremVmwareClusterVcenter | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
