/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleGkeonpremVmwareNodePoolConfig extends cdktf.TerraformMetaArguments {
    /**
    * Annotations on the node Pool.
    * This field has the same restrictions as Kubernetes annotations.
    * The total size of all keys and values combined is limited to 256k.
    * Key can have 2 segments: prefix (optional) and name (required),
    * separated by a slash (/).
    * Prefix must be a DNS subdomain.
    * Name must be 63 characters or less, begin and end with alphanumerics,
    * with dashes (-), underscores (_), dots (.), and alphanumerics between.
    *
    *
    * **Note**: This field is non-authoritative, and will only manage the annotations present in your configuration.
    * Please refer to the field 'effective_annotations' for all of the annotations present on the resource.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gkeonprem_vmware_node_pool#annotations GoogleGkeonpremVmwareNodePool#annotations}
    */
    readonly annotations?: {
        [key: string]: string;
    };
    /**
    * The display name for the node pool.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gkeonprem_vmware_node_pool#display_name GoogleGkeonpremVmwareNodePool#display_name}
    */
    readonly displayName?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gkeonprem_vmware_node_pool#id GoogleGkeonpremVmwareNodePool#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The location of the resource.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gkeonprem_vmware_node_pool#location GoogleGkeonpremVmwareNodePool#location}
    */
    readonly location: string;
    /**
    * The vmware node pool name.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gkeonprem_vmware_node_pool#name GoogleGkeonpremVmwareNodePool#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gkeonprem_vmware_node_pool#project GoogleGkeonpremVmwareNodePool#project}
    */
    readonly project?: string;
    /**
    * The cluster this node pool belongs to.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gkeonprem_vmware_node_pool#vmware_cluster GoogleGkeonpremVmwareNodePool#vmware_cluster}
    */
    readonly vmwareCluster: string;
    /**
    * config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gkeonprem_vmware_node_pool#config GoogleGkeonpremVmwareNodePool#config}
    */
    readonly config: GoogleGkeonpremVmwareNodePoolConfigA;
    /**
    * node_pool_autoscaling block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gkeonprem_vmware_node_pool#node_pool_autoscaling GoogleGkeonpremVmwareNodePool#node_pool_autoscaling}
    */
    readonly nodePoolAutoscaling?: GoogleGkeonpremVmwareNodePoolNodePoolAutoscaling;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gkeonprem_vmware_node_pool#timeouts GoogleGkeonpremVmwareNodePool#timeouts}
    */
    readonly timeouts?: GoogleGkeonpremVmwareNodePoolTimeouts;
}
export interface GoogleGkeonpremVmwareNodePoolStatusConditions {
}
export declare function googleGkeonpremVmwareNodePoolStatusConditionsToTerraform(struct?: GoogleGkeonpremVmwareNodePoolStatusConditions): any;
export declare function googleGkeonpremVmwareNodePoolStatusConditionsToHclTerraform(struct?: GoogleGkeonpremVmwareNodePoolStatusConditions): any;
export declare class GoogleGkeonpremVmwareNodePoolStatusConditionsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleGkeonpremVmwareNodePoolStatusConditions | undefined;
    set internalValue(value: GoogleGkeonpremVmwareNodePoolStatusConditions | undefined);
    get lastTransitionTime(): string;
    get message(): string;
    get reason(): string;
    get state(): string;
    get type(): string;
}
export declare class GoogleGkeonpremVmwareNodePoolStatusConditionsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleGkeonpremVmwareNodePoolStatusConditionsOutputReference;
}
export interface GoogleGkeonpremVmwareNodePoolStatus {
}
export declare function googleGkeonpremVmwareNodePoolStatusToTerraform(struct?: GoogleGkeonpremVmwareNodePoolStatus): any;
export declare function googleGkeonpremVmwareNodePoolStatusToHclTerraform(struct?: GoogleGkeonpremVmwareNodePoolStatus): any;
export declare class GoogleGkeonpremVmwareNodePoolStatusOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleGkeonpremVmwareNodePoolStatus | undefined;
    set internalValue(value: GoogleGkeonpremVmwareNodePoolStatus | undefined);
    private _conditions;
    get conditions(): GoogleGkeonpremVmwareNodePoolStatusConditionsList;
    get errorMessage(): string;
}
export declare class GoogleGkeonpremVmwareNodePoolStatusList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleGkeonpremVmwareNodePoolStatusOutputReference;
}
export interface GoogleGkeonpremVmwareNodePoolConfigTaints {
    /**
    * Available taint effects. Possible values: ["EFFECT_UNSPECIFIED", "NO_SCHEDULE", "PREFER_NO_SCHEDULE", "NO_EXECUTE"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gkeonprem_vmware_node_pool#effect GoogleGkeonpremVmwareNodePool#effect}
    */
    readonly effect?: string;
    /**
    * Key associated with the effect.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gkeonprem_vmware_node_pool#key GoogleGkeonpremVmwareNodePool#key}
    */
    readonly key: string;
    /**
    * Value associated with the effect.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gkeonprem_vmware_node_pool#value GoogleGkeonpremVmwareNodePool#value}
    */
    readonly value: string;
}
export declare function googleGkeonpremVmwareNodePoolConfigTaintsToTerraform(struct?: GoogleGkeonpremVmwareNodePoolConfigTaints | cdktf.IResolvable): any;
export declare function googleGkeonpremVmwareNodePoolConfigTaintsToHclTerraform(struct?: GoogleGkeonpremVmwareNodePoolConfigTaints | cdktf.IResolvable): any;
export declare class GoogleGkeonpremVmwareNodePoolConfigTaintsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleGkeonpremVmwareNodePoolConfigTaints | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleGkeonpremVmwareNodePoolConfigTaints | cdktf.IResolvable | undefined);
    private _effect?;
    get effect(): string;
    set effect(value: string);
    resetEffect(): void;
    get effectInput(): string | undefined;
    private _key?;
    get key(): string;
    set key(value: string);
    get keyInput(): string | undefined;
    private _value?;
    get value(): string;
    set value(value: string);
    get valueInput(): string | undefined;
}
export declare class GoogleGkeonpremVmwareNodePoolConfigTaintsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleGkeonpremVmwareNodePoolConfigTaints[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleGkeonpremVmwareNodePoolConfigTaintsOutputReference;
}
export interface GoogleGkeonpremVmwareNodePoolConfigVsphereConfigTags {
    /**
    * The Vsphere tag category.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gkeonprem_vmware_node_pool#category GoogleGkeonpremVmwareNodePool#category}
    */
    readonly category?: string;
    /**
    * The Vsphere tag name.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gkeonprem_vmware_node_pool#tag GoogleGkeonpremVmwareNodePool#tag}
    */
    readonly tag?: string;
}
export declare function googleGkeonpremVmwareNodePoolConfigVsphereConfigTagsToTerraform(struct?: GoogleGkeonpremVmwareNodePoolConfigVsphereConfigTags | cdktf.IResolvable): any;
export declare function googleGkeonpremVmwareNodePoolConfigVsphereConfigTagsToHclTerraform(struct?: GoogleGkeonpremVmwareNodePoolConfigVsphereConfigTags | cdktf.IResolvable): any;
export declare class GoogleGkeonpremVmwareNodePoolConfigVsphereConfigTagsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleGkeonpremVmwareNodePoolConfigVsphereConfigTags | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleGkeonpremVmwareNodePoolConfigVsphereConfigTags | cdktf.IResolvable | undefined);
    private _category?;
    get category(): string;
    set category(value: string);
    resetCategory(): void;
    get categoryInput(): string | undefined;
    private _tag?;
    get tag(): string;
    set tag(value: string);
    resetTag(): void;
    get tagInput(): string | undefined;
}
export declare class GoogleGkeonpremVmwareNodePoolConfigVsphereConfigTagsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleGkeonpremVmwareNodePoolConfigVsphereConfigTags[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleGkeonpremVmwareNodePoolConfigVsphereConfigTagsOutputReference;
}
export interface GoogleGkeonpremVmwareNodePoolConfigVsphereConfig {
    /**
    * The name of the vCenter datastore. Inherited from the user cluster.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gkeonprem_vmware_node_pool#datastore GoogleGkeonpremVmwareNodePool#datastore}
    */
    readonly datastore?: string;
    /**
    * Vsphere host groups to apply to all VMs in the node pool
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gkeonprem_vmware_node_pool#host_groups GoogleGkeonpremVmwareNodePool#host_groups}
    */
    readonly hostGroups?: string[];
    /**
    * tags block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gkeonprem_vmware_node_pool#tags GoogleGkeonpremVmwareNodePool#tags}
    */
    readonly tags?: GoogleGkeonpremVmwareNodePoolConfigVsphereConfigTags[] | cdktf.IResolvable;
}
export declare function googleGkeonpremVmwareNodePoolConfigVsphereConfigToTerraform(struct?: GoogleGkeonpremVmwareNodePoolConfigVsphereConfigOutputReference | GoogleGkeonpremVmwareNodePoolConfigVsphereConfig): any;
export declare function googleGkeonpremVmwareNodePoolConfigVsphereConfigToHclTerraform(struct?: GoogleGkeonpremVmwareNodePoolConfigVsphereConfigOutputReference | GoogleGkeonpremVmwareNodePoolConfigVsphereConfig): any;
export declare class GoogleGkeonpremVmwareNodePoolConfigVsphereConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleGkeonpremVmwareNodePoolConfigVsphereConfig | undefined;
    set internalValue(value: GoogleGkeonpremVmwareNodePoolConfigVsphereConfig | undefined);
    private _datastore?;
    get datastore(): string;
    set datastore(value: string);
    resetDatastore(): void;
    get datastoreInput(): string | undefined;
    private _hostGroups?;
    get hostGroups(): string[];
    set hostGroups(value: string[]);
    resetHostGroups(): void;
    get hostGroupsInput(): string[] | undefined;
    private _tags;
    get tags(): GoogleGkeonpremVmwareNodePoolConfigVsphereConfigTagsList;
    putTags(value: GoogleGkeonpremVmwareNodePoolConfigVsphereConfigTags[] | cdktf.IResolvable): void;
    resetTags(): void;
    get tagsInput(): cdktf.IResolvable | GoogleGkeonpremVmwareNodePoolConfigVsphereConfigTags[] | undefined;
}
export interface GoogleGkeonpremVmwareNodePoolConfigA {
    /**
    * VMware disk size to be used during creation.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gkeonprem_vmware_node_pool#boot_disk_size_gb GoogleGkeonpremVmwareNodePool#boot_disk_size_gb}
    */
    readonly bootDiskSizeGb?: number;
    /**
    * The number of CPUs for each node in the node pool.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gkeonprem_vmware_node_pool#cpus GoogleGkeonpremVmwareNodePool#cpus}
    */
    readonly cpus?: number;
    /**
    * Allow node pool traffic to be load balanced. Only works for clusters with
    * MetalLB load balancers.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gkeonprem_vmware_node_pool#enable_load_balancer GoogleGkeonpremVmwareNodePool#enable_load_balancer}
    */
    readonly enableLoadBalancer?: boolean | cdktf.IResolvable;
    /**
    * The OS image name in vCenter, only valid when using Windows.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gkeonprem_vmware_node_pool#image GoogleGkeonpremVmwareNodePool#image}
    */
    readonly image?: string;
    /**
    * The OS image to be used for each node in a node pool.
    * Currently 'cos', 'ubuntu', 'ubuntu_containerd' and 'windows' are supported.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gkeonprem_vmware_node_pool#image_type GoogleGkeonpremVmwareNodePool#image_type}
    */
    readonly imageType: string;
    /**
    * The map of Kubernetes labels (key/value pairs) to be applied to each node.
    * These will added in addition to any default label(s) that
    * Kubernetes may apply to the node.
    * In case of conflict in label keys, the applied set may differ depending on
    * the Kubernetes version -- it's best to assume the behavior is undefined
    * and conflicts should be avoided.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gkeonprem_vmware_node_pool#labels GoogleGkeonpremVmwareNodePool#labels}
    */
    readonly labels?: {
        [key: string]: string;
    };
    /**
    * The megabytes of memory for each node in the node pool.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gkeonprem_vmware_node_pool#memory_mb GoogleGkeonpremVmwareNodePool#memory_mb}
    */
    readonly memoryMb?: number;
    /**
    * The number of nodes in the node pool.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gkeonprem_vmware_node_pool#replicas GoogleGkeonpremVmwareNodePool#replicas}
    */
    readonly replicas?: number;
    /**
    * taints block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gkeonprem_vmware_node_pool#taints GoogleGkeonpremVmwareNodePool#taints}
    */
    readonly taints?: GoogleGkeonpremVmwareNodePoolConfigTaints[] | cdktf.IResolvable;
    /**
    * vsphere_config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gkeonprem_vmware_node_pool#vsphere_config GoogleGkeonpremVmwareNodePool#vsphere_config}
    */
    readonly vsphereConfig?: GoogleGkeonpremVmwareNodePoolConfigVsphereConfig;
}
export declare function googleGkeonpremVmwareNodePoolConfigAToTerraform(struct?: GoogleGkeonpremVmwareNodePoolConfigAOutputReference | GoogleGkeonpremVmwareNodePoolConfigA): any;
export declare function googleGkeonpremVmwareNodePoolConfigAToHclTerraform(struct?: GoogleGkeonpremVmwareNodePoolConfigAOutputReference | GoogleGkeonpremVmwareNodePoolConfigA): any;
export declare class GoogleGkeonpremVmwareNodePoolConfigAOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleGkeonpremVmwareNodePoolConfigA | undefined;
    set internalValue(value: GoogleGkeonpremVmwareNodePoolConfigA | undefined);
    private _bootDiskSizeGb?;
    get bootDiskSizeGb(): number;
    set bootDiskSizeGb(value: number);
    resetBootDiskSizeGb(): void;
    get bootDiskSizeGbInput(): number | undefined;
    private _cpus?;
    get cpus(): number;
    set cpus(value: number);
    resetCpus(): void;
    get cpusInput(): number | undefined;
    private _enableLoadBalancer?;
    get enableLoadBalancer(): boolean | cdktf.IResolvable;
    set enableLoadBalancer(value: boolean | cdktf.IResolvable);
    resetEnableLoadBalancer(): void;
    get enableLoadBalancerInput(): boolean | cdktf.IResolvable | undefined;
    private _image?;
    get image(): string;
    set image(value: string);
    resetImage(): void;
    get imageInput(): string | undefined;
    private _imageType?;
    get imageType(): string;
    set imageType(value: string);
    get imageTypeInput(): string | undefined;
    private _labels?;
    get labels(): {
        [key: string]: string;
    };
    set labels(value: {
        [key: string]: string;
    });
    resetLabels(): void;
    get labelsInput(): {
        [key: string]: string;
    } | undefined;
    private _memoryMb?;
    get memoryMb(): number;
    set memoryMb(value: number);
    resetMemoryMb(): void;
    get memoryMbInput(): number | undefined;
    private _replicas?;
    get replicas(): number;
    set replicas(value: number);
    resetReplicas(): void;
    get replicasInput(): number | undefined;
    private _taints;
    get taints(): GoogleGkeonpremVmwareNodePoolConfigTaintsList;
    putTaints(value: GoogleGkeonpremVmwareNodePoolConfigTaints[] | cdktf.IResolvable): void;
    resetTaints(): void;
    get taintsInput(): cdktf.IResolvable | GoogleGkeonpremVmwareNodePoolConfigTaints[] | undefined;
    private _vsphereConfig;
    get vsphereConfig(): GoogleGkeonpremVmwareNodePoolConfigVsphereConfigOutputReference;
    putVsphereConfig(value: GoogleGkeonpremVmwareNodePoolConfigVsphereConfig): void;
    resetVsphereConfig(): void;
    get vsphereConfigInput(): GoogleGkeonpremVmwareNodePoolConfigVsphereConfig | undefined;
}
export interface GoogleGkeonpremVmwareNodePoolNodePoolAutoscaling {
    /**
    * Maximum number of replicas in the NodePool.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gkeonprem_vmware_node_pool#max_replicas GoogleGkeonpremVmwareNodePool#max_replicas}
    */
    readonly maxReplicas: number;
    /**
    * Minimum number of replicas in the NodePool.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gkeonprem_vmware_node_pool#min_replicas GoogleGkeonpremVmwareNodePool#min_replicas}
    */
    readonly minReplicas: number;
}
export declare function googleGkeonpremVmwareNodePoolNodePoolAutoscalingToTerraform(struct?: GoogleGkeonpremVmwareNodePoolNodePoolAutoscalingOutputReference | GoogleGkeonpremVmwareNodePoolNodePoolAutoscaling): any;
export declare function googleGkeonpremVmwareNodePoolNodePoolAutoscalingToHclTerraform(struct?: GoogleGkeonpremVmwareNodePoolNodePoolAutoscalingOutputReference | GoogleGkeonpremVmwareNodePoolNodePoolAutoscaling): any;
export declare class GoogleGkeonpremVmwareNodePoolNodePoolAutoscalingOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleGkeonpremVmwareNodePoolNodePoolAutoscaling | undefined;
    set internalValue(value: GoogleGkeonpremVmwareNodePoolNodePoolAutoscaling | undefined);
    private _maxReplicas?;
    get maxReplicas(): number;
    set maxReplicas(value: number);
    get maxReplicasInput(): number | undefined;
    private _minReplicas?;
    get minReplicas(): number;
    set minReplicas(value: number);
    get minReplicasInput(): number | undefined;
}
export interface GoogleGkeonpremVmwareNodePoolTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gkeonprem_vmware_node_pool#create GoogleGkeonpremVmwareNodePool#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gkeonprem_vmware_node_pool#delete GoogleGkeonpremVmwareNodePool#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gkeonprem_vmware_node_pool#update GoogleGkeonpremVmwareNodePool#update}
    */
    readonly update?: string;
}
export declare function googleGkeonpremVmwareNodePoolTimeoutsToTerraform(struct?: GoogleGkeonpremVmwareNodePoolTimeouts | cdktf.IResolvable): any;
export declare function googleGkeonpremVmwareNodePoolTimeoutsToHclTerraform(struct?: GoogleGkeonpremVmwareNodePoolTimeouts | cdktf.IResolvable): any;
export declare class GoogleGkeonpremVmwareNodePoolTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleGkeonpremVmwareNodePoolTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleGkeonpremVmwareNodePoolTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gkeonprem_vmware_node_pool google_gkeonprem_vmware_node_pool}
*/
export declare class GoogleGkeonpremVmwareNodePool extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_gkeonprem_vmware_node_pool";
    /**
    * Generates CDKTF code for importing a GoogleGkeonpremVmwareNodePool resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the GoogleGkeonpremVmwareNodePool to import
    * @param importFromId The id of the existing GoogleGkeonpremVmwareNodePool that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gkeonprem_vmware_node_pool#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the GoogleGkeonpremVmwareNodePool to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_gkeonprem_vmware_node_pool google_gkeonprem_vmware_node_pool} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleGkeonpremVmwareNodePoolConfig
    */
    constructor(scope: Construct, id: string, config: GoogleGkeonpremVmwareNodePoolConfig);
    private _annotations?;
    get annotations(): {
        [key: string]: string;
    };
    set annotations(value: {
        [key: string]: string;
    });
    resetAnnotations(): void;
    get annotationsInput(): {
        [key: string]: string;
    } | undefined;
    get createTime(): string;
    get deleteTime(): string;
    private _displayName?;
    get displayName(): string;
    set displayName(value: string);
    resetDisplayName(): void;
    get displayNameInput(): string | undefined;
    private _effectiveAnnotations;
    get effectiveAnnotations(): cdktf.StringMap;
    get etag(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get onPremVersion(): string;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    get reconciling(): cdktf.IResolvable;
    get state(): string;
    private _status;
    get status(): GoogleGkeonpremVmwareNodePoolStatusList;
    get uid(): string;
    get updateTime(): string;
    private _vmwareCluster?;
    get vmwareCluster(): string;
    set vmwareCluster(value: string);
    get vmwareClusterInput(): string | undefined;
    private _config;
    get config(): GoogleGkeonpremVmwareNodePoolConfigAOutputReference;
    putConfig(value: GoogleGkeonpremVmwareNodePoolConfigA): void;
    get configInput(): GoogleGkeonpremVmwareNodePoolConfigA | undefined;
    private _nodePoolAutoscaling;
    get nodePoolAutoscaling(): GoogleGkeonpremVmwareNodePoolNodePoolAutoscalingOutputReference;
    putNodePoolAutoscaling(value: GoogleGkeonpremVmwareNodePoolNodePoolAutoscaling): void;
    resetNodePoolAutoscaling(): void;
    get nodePoolAutoscalingInput(): GoogleGkeonpremVmwareNodePoolNodePoolAutoscaling | undefined;
    private _timeouts;
    get timeouts(): GoogleGkeonpremVmwareNodePoolTimeoutsOutputReference;
    putTimeouts(value: GoogleGkeonpremVmwareNodePoolTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleGkeonpremVmwareNodePoolTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
