/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleHealthcareConsentStoreConfig extends cdktf.TerraformMetaArguments {
    /**
    * Identifies the dataset addressed by this request. Must be in the format
    * 'projects/{project}/locations/{location}/datasets/{dataset}'
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_healthcare_consent_store#dataset GoogleHealthcareConsentStore#dataset}
    */
    readonly dataset: string;
    /**
    * Default time to live for consents in this store. Must be at least 24 hours. Updating this field will not affect the expiration time of existing consents.
    *
    * A duration in seconds with up to nine fractional digits, terminated by 's'. Example: "3.5s".
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_healthcare_consent_store#default_consent_ttl GoogleHealthcareConsentStore#default_consent_ttl}
    */
    readonly defaultConsentTtl?: string;
    /**
    * If true, [consents.patch] [google.cloud.healthcare.v1.consent.UpdateConsent] creates the consent if it does not already exist.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_healthcare_consent_store#enable_consent_create_on_update GoogleHealthcareConsentStore#enable_consent_create_on_update}
    */
    readonly enableConsentCreateOnUpdate?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_healthcare_consent_store#id GoogleHealthcareConsentStore#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * User-supplied key-value pairs used to organize Consent stores.
    *
    * Label keys must be between 1 and 63 characters long, have a UTF-8 encoding of maximum 128 bytes, and must
    * conform to the following PCRE regular expression: '[\p{Ll}\p{Lo}][\p{Ll}\p{Lo}\p{N}_-]{0,62}'
    *
    * Label values are optional, must be between 1 and 63 characters long, have a UTF-8 encoding of maximum 128
    * bytes, and must conform to the following PCRE regular expression: '[\p{Ll}\p{Lo}\p{N}_-]{0,63}'
    *
    * No more than 64 labels can be associated with a given store.
    *
    * An object containing a list of "key": value pairs.
    * Example: { "name": "wrench", "mass": "1.3kg", "count": "3" }.
    *
    *
    * **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
    * Please refer to the field 'effective_labels' for all of the labels present on the resource.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_healthcare_consent_store#labels GoogleHealthcareConsentStore#labels}
    */
    readonly labels?: {
        [key: string]: string;
    };
    /**
    * The name of this ConsentStore, for example:
    * "consent1"
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_healthcare_consent_store#name GoogleHealthcareConsentStore#name}
    */
    readonly name: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_healthcare_consent_store#timeouts GoogleHealthcareConsentStore#timeouts}
    */
    readonly timeouts?: GoogleHealthcareConsentStoreTimeouts;
}
export interface GoogleHealthcareConsentStoreTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_healthcare_consent_store#create GoogleHealthcareConsentStore#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_healthcare_consent_store#delete GoogleHealthcareConsentStore#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_healthcare_consent_store#update GoogleHealthcareConsentStore#update}
    */
    readonly update?: string;
}
export declare function googleHealthcareConsentStoreTimeoutsToTerraform(struct?: GoogleHealthcareConsentStoreTimeouts | cdktf.IResolvable): any;
export declare function googleHealthcareConsentStoreTimeoutsToHclTerraform(struct?: GoogleHealthcareConsentStoreTimeouts | cdktf.IResolvable): any;
export declare class GoogleHealthcareConsentStoreTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleHealthcareConsentStoreTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleHealthcareConsentStoreTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_healthcare_consent_store google_healthcare_consent_store}
*/
export declare class GoogleHealthcareConsentStore extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_healthcare_consent_store";
    /**
    * Generates CDKTF code for importing a GoogleHealthcareConsentStore resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the GoogleHealthcareConsentStore to import
    * @param importFromId The id of the existing GoogleHealthcareConsentStore that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_healthcare_consent_store#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the GoogleHealthcareConsentStore to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_healthcare_consent_store google_healthcare_consent_store} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleHealthcareConsentStoreConfig
    */
    constructor(scope: Construct, id: string, config: GoogleHealthcareConsentStoreConfig);
    private _dataset?;
    get dataset(): string;
    set dataset(value: string);
    get datasetInput(): string | undefined;
    private _defaultConsentTtl?;
    get defaultConsentTtl(): string;
    set defaultConsentTtl(value: string);
    resetDefaultConsentTtl(): void;
    get defaultConsentTtlInput(): string | undefined;
    private _effectiveLabels;
    get effectiveLabels(): cdktf.StringMap;
    private _enableConsentCreateOnUpdate?;
    get enableConsentCreateOnUpdate(): boolean | cdktf.IResolvable;
    set enableConsentCreateOnUpdate(value: boolean | cdktf.IResolvable);
    resetEnableConsentCreateOnUpdate(): void;
    get enableConsentCreateOnUpdateInput(): boolean | cdktf.IResolvable | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _labels?;
    get labels(): {
        [key: string]: string;
    };
    set labels(value: {
        [key: string]: string;
    });
    resetLabels(): void;
    get labelsInput(): {
        [key: string]: string;
    } | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _terraformLabels;
    get terraformLabels(): cdktf.StringMap;
    private _timeouts;
    get timeouts(): GoogleHealthcareConsentStoreTimeoutsOutputReference;
    putTimeouts(value: GoogleHealthcareConsentStoreTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleHealthcareConsentStoreTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
