/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleHealthcareDatasetConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_healthcare_dataset#id GoogleHealthcareDataset#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The location for the Dataset.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_healthcare_dataset#location GoogleHealthcareDataset#location}
    */
    readonly location: string;
    /**
    * The resource name for the Dataset.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_healthcare_dataset#name GoogleHealthcareDataset#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_healthcare_dataset#project GoogleHealthcareDataset#project}
    */
    readonly project?: string;
    /**
    * The default timezone used by this dataset. Must be a either a valid IANA time zone name such as
    * "America/New_York" or empty, which defaults to UTC. This is used for parsing times in resources
    * (e.g., HL7 messages) where no explicit timezone is specified.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_healthcare_dataset#time_zone GoogleHealthcareDataset#time_zone}
    */
    readonly timeZone?: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_healthcare_dataset#timeouts GoogleHealthcareDataset#timeouts}
    */
    readonly timeouts?: GoogleHealthcareDatasetTimeouts;
}
export interface GoogleHealthcareDatasetTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_healthcare_dataset#create GoogleHealthcareDataset#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_healthcare_dataset#delete GoogleHealthcareDataset#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_healthcare_dataset#update GoogleHealthcareDataset#update}
    */
    readonly update?: string;
}
export declare function googleHealthcareDatasetTimeoutsToTerraform(struct?: GoogleHealthcareDatasetTimeouts | cdktf.IResolvable): any;
export declare function googleHealthcareDatasetTimeoutsToHclTerraform(struct?: GoogleHealthcareDatasetTimeouts | cdktf.IResolvable): any;
export declare class GoogleHealthcareDatasetTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleHealthcareDatasetTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleHealthcareDatasetTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_healthcare_dataset google_healthcare_dataset}
*/
export declare class GoogleHealthcareDataset extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_healthcare_dataset";
    /**
    * Generates CDKTF code for importing a GoogleHealthcareDataset resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the GoogleHealthcareDataset to import
    * @param importFromId The id of the existing GoogleHealthcareDataset that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_healthcare_dataset#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the GoogleHealthcareDataset to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_healthcare_dataset google_healthcare_dataset} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleHealthcareDatasetConfig
    */
    constructor(scope: Construct, id: string, config: GoogleHealthcareDatasetConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    get selfLink(): string;
    private _timeZone?;
    get timeZone(): string;
    set timeZone(value: string);
    resetTimeZone(): void;
    get timeZoneInput(): string | undefined;
    private _timeouts;
    get timeouts(): GoogleHealthcareDatasetTimeoutsOutputReference;
    putTimeouts(value: GoogleHealthcareDatasetTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleHealthcareDatasetTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
