/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleHealthcareDicomStoreConfig extends cdktf.TerraformMetaArguments {
    /**
    * Identifies the dataset addressed by this request. Must be in the format
    * 'projects/{project}/locations/{location}/datasets/{dataset}'
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_healthcare_dicom_store#dataset GoogleHealthcareDicomStore#dataset}
    */
    readonly dataset: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_healthcare_dicom_store#id GoogleHealthcareDicomStore#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * User-supplied key-value pairs used to organize DICOM stores.
    *
    * Label keys must be between 1 and 63 characters long, have a UTF-8 encoding of maximum 128 bytes, and must
    * conform to the following PCRE regular expression: [\p{Ll}\p{Lo}][\p{Ll}\p{Lo}\p{N}_-]{0,62}
    *
    * Label values are optional, must be between 1 and 63 characters long, have a UTF-8 encoding of maximum 128
    * bytes, and must conform to the following PCRE regular expression: [\p{Ll}\p{Lo}\p{N}_-]{0,63}
    *
    * No more than 64 labels can be associated with a given store.
    *
    * An object containing a list of "key": value pairs.
    * Example: { "name": "wrench", "mass": "1.3kg", "count": "3" }.
    *
    *
    * **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
    * Please refer to the field 'effective_labels' for all of the labels present on the resource.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_healthcare_dicom_store#labels GoogleHealthcareDicomStore#labels}
    */
    readonly labels?: {
        [key: string]: string;
    };
    /**
    * The resource name for the DicomStore.
    *
    * ** Changing this property may recreate the Dicom store (removing all data) **
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_healthcare_dicom_store#name GoogleHealthcareDicomStore#name}
    */
    readonly name: string;
    /**
    * notification_config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_healthcare_dicom_store#notification_config GoogleHealthcareDicomStore#notification_config}
    */
    readonly notificationConfig?: GoogleHealthcareDicomStoreNotificationConfig;
    /**
    * stream_configs block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_healthcare_dicom_store#stream_configs GoogleHealthcareDicomStore#stream_configs}
    */
    readonly streamConfigs?: GoogleHealthcareDicomStoreStreamConfigs[] | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_healthcare_dicom_store#timeouts GoogleHealthcareDicomStore#timeouts}
    */
    readonly timeouts?: GoogleHealthcareDicomStoreTimeouts;
}
export interface GoogleHealthcareDicomStoreNotificationConfig {
    /**
    * The Cloud Pub/Sub topic that notifications of changes are published on. Supplied by the client.
    * PubsubMessage.Data will contain the resource name. PubsubMessage.MessageId is the ID of this message.
    * It is guaranteed to be unique within the topic. PubsubMessage.PublishTime is the time at which the message
    * was published. Notifications are only sent if the topic is non-empty. Topic names must be scoped to a
    * project. service-PROJECT_NUMBER@gcp-sa-healthcare.iam.gserviceaccount.com must have publisher permissions on the given
    * Cloud Pub/Sub topic. Not having adequate permissions will cause the calls that send notifications to fail.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_healthcare_dicom_store#pubsub_topic GoogleHealthcareDicomStore#pubsub_topic}
    */
    readonly pubsubTopic: string;
}
export declare function googleHealthcareDicomStoreNotificationConfigToTerraform(struct?: GoogleHealthcareDicomStoreNotificationConfigOutputReference | GoogleHealthcareDicomStoreNotificationConfig): any;
export declare function googleHealthcareDicomStoreNotificationConfigToHclTerraform(struct?: GoogleHealthcareDicomStoreNotificationConfigOutputReference | GoogleHealthcareDicomStoreNotificationConfig): any;
export declare class GoogleHealthcareDicomStoreNotificationConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleHealthcareDicomStoreNotificationConfig | undefined;
    set internalValue(value: GoogleHealthcareDicomStoreNotificationConfig | undefined);
    private _pubsubTopic?;
    get pubsubTopic(): string;
    set pubsubTopic(value: string);
    get pubsubTopicInput(): string | undefined;
}
export interface GoogleHealthcareDicomStoreStreamConfigsBigqueryDestination {
    /**
    * a fully qualified BigQuery table URI where DICOM instance metadata will be streamed.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_healthcare_dicom_store#table_uri GoogleHealthcareDicomStore#table_uri}
    */
    readonly tableUri: string;
}
export declare function googleHealthcareDicomStoreStreamConfigsBigqueryDestinationToTerraform(struct?: GoogleHealthcareDicomStoreStreamConfigsBigqueryDestinationOutputReference | GoogleHealthcareDicomStoreStreamConfigsBigqueryDestination): any;
export declare function googleHealthcareDicomStoreStreamConfigsBigqueryDestinationToHclTerraform(struct?: GoogleHealthcareDicomStoreStreamConfigsBigqueryDestinationOutputReference | GoogleHealthcareDicomStoreStreamConfigsBigqueryDestination): any;
export declare class GoogleHealthcareDicomStoreStreamConfigsBigqueryDestinationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleHealthcareDicomStoreStreamConfigsBigqueryDestination | undefined;
    set internalValue(value: GoogleHealthcareDicomStoreStreamConfigsBigqueryDestination | undefined);
    private _tableUri?;
    get tableUri(): string;
    set tableUri(value: string);
    get tableUriInput(): string | undefined;
}
export interface GoogleHealthcareDicomStoreStreamConfigs {
    /**
    * bigquery_destination block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_healthcare_dicom_store#bigquery_destination GoogleHealthcareDicomStore#bigquery_destination}
    */
    readonly bigqueryDestination: GoogleHealthcareDicomStoreStreamConfigsBigqueryDestination;
}
export declare function googleHealthcareDicomStoreStreamConfigsToTerraform(struct?: GoogleHealthcareDicomStoreStreamConfigs | cdktf.IResolvable): any;
export declare function googleHealthcareDicomStoreStreamConfigsToHclTerraform(struct?: GoogleHealthcareDicomStoreStreamConfigs | cdktf.IResolvable): any;
export declare class GoogleHealthcareDicomStoreStreamConfigsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleHealthcareDicomStoreStreamConfigs | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleHealthcareDicomStoreStreamConfigs | cdktf.IResolvable | undefined);
    private _bigqueryDestination;
    get bigqueryDestination(): GoogleHealthcareDicomStoreStreamConfigsBigqueryDestinationOutputReference;
    putBigqueryDestination(value: GoogleHealthcareDicomStoreStreamConfigsBigqueryDestination): void;
    get bigqueryDestinationInput(): GoogleHealthcareDicomStoreStreamConfigsBigqueryDestination | undefined;
}
export declare class GoogleHealthcareDicomStoreStreamConfigsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleHealthcareDicomStoreStreamConfigs[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleHealthcareDicomStoreStreamConfigsOutputReference;
}
export interface GoogleHealthcareDicomStoreTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_healthcare_dicom_store#create GoogleHealthcareDicomStore#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_healthcare_dicom_store#delete GoogleHealthcareDicomStore#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_healthcare_dicom_store#update GoogleHealthcareDicomStore#update}
    */
    readonly update?: string;
}
export declare function googleHealthcareDicomStoreTimeoutsToTerraform(struct?: GoogleHealthcareDicomStoreTimeouts | cdktf.IResolvable): any;
export declare function googleHealthcareDicomStoreTimeoutsToHclTerraform(struct?: GoogleHealthcareDicomStoreTimeouts | cdktf.IResolvable): any;
export declare class GoogleHealthcareDicomStoreTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleHealthcareDicomStoreTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleHealthcareDicomStoreTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_healthcare_dicom_store google_healthcare_dicom_store}
*/
export declare class GoogleHealthcareDicomStore extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_healthcare_dicom_store";
    /**
    * Generates CDKTF code for importing a GoogleHealthcareDicomStore resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the GoogleHealthcareDicomStore to import
    * @param importFromId The id of the existing GoogleHealthcareDicomStore that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_healthcare_dicom_store#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the GoogleHealthcareDicomStore to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_healthcare_dicom_store google_healthcare_dicom_store} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleHealthcareDicomStoreConfig
    */
    constructor(scope: Construct, id: string, config: GoogleHealthcareDicomStoreConfig);
    private _dataset?;
    get dataset(): string;
    set dataset(value: string);
    get datasetInput(): string | undefined;
    private _effectiveLabels;
    get effectiveLabels(): cdktf.StringMap;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _labels?;
    get labels(): {
        [key: string]: string;
    };
    set labels(value: {
        [key: string]: string;
    });
    resetLabels(): void;
    get labelsInput(): {
        [key: string]: string;
    } | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get selfLink(): string;
    private _terraformLabels;
    get terraformLabels(): cdktf.StringMap;
    private _notificationConfig;
    get notificationConfig(): GoogleHealthcareDicomStoreNotificationConfigOutputReference;
    putNotificationConfig(value: GoogleHealthcareDicomStoreNotificationConfig): void;
    resetNotificationConfig(): void;
    get notificationConfigInput(): GoogleHealthcareDicomStoreNotificationConfig | undefined;
    private _streamConfigs;
    get streamConfigs(): GoogleHealthcareDicomStoreStreamConfigsList;
    putStreamConfigs(value: GoogleHealthcareDicomStoreStreamConfigs[] | cdktf.IResolvable): void;
    resetStreamConfigs(): void;
    get streamConfigsInput(): cdktf.IResolvable | GoogleHealthcareDicomStoreStreamConfigs[] | undefined;
    private _timeouts;
    get timeouts(): GoogleHealthcareDicomStoreTimeoutsOutputReference;
    putTimeouts(value: GoogleHealthcareDicomStoreTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleHealthcareDicomStoreTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
