/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleHealthcareFhirStoreConfig extends cdktf.TerraformMetaArguments {
    /**
    * Enable parsing of references within complex FHIR data types such as Extensions. If this value is set to ENABLED, then features like referential integrity and Bundle reference rewriting apply to all references. If this flag has not been specified the behavior of the FHIR store will not change, references in complex data types will not be parsed. New stores will have this value set to ENABLED by default after a notification period. Warning: turning on this flag causes processing existing resources to fail if they contain references to non-existent resources. Possible values: ["COMPLEX_DATA_TYPE_REFERENCE_PARSING_UNSPECIFIED", "DISABLED", "ENABLED"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_healthcare_fhir_store#complex_data_type_reference_parsing GoogleHealthcareFhirStore#complex_data_type_reference_parsing}
    */
    readonly complexDataTypeReferenceParsing?: string;
    /**
    * Identifies the dataset addressed by this request. Must be in the format
    * 'projects/{project}/locations/{location}/datasets/{dataset}'
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_healthcare_fhir_store#dataset GoogleHealthcareFhirStore#dataset}
    */
    readonly dataset: string;
    /**
    * If true, overrides the default search behavior for this FHIR store to handling=strict which returns an error for unrecognized search parameters.
    * If false, uses the FHIR specification default handling=lenient which ignores unrecognized search parameters.
    * The handling can always be changed from the default on an individual API call by setting the HTTP header Prefer: handling=strict or Prefer: handling=lenient.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_healthcare_fhir_store#default_search_handling_strict GoogleHealthcareFhirStore#default_search_handling_strict}
    */
    readonly defaultSearchHandlingStrict?: boolean | cdktf.IResolvable;
    /**
    * Whether to disable referential integrity in this FHIR store. This field is immutable after FHIR store
    * creation. The default value is false, meaning that the API will enforce referential integrity and fail the
    * requests that will result in inconsistent state in the FHIR store. When this field is set to true, the API
    * will skip referential integrity check. Consequently, operations that rely on references, such as
    * Patient.get$everything, will not return all the results if broken references exist.
    *
    * ** Changing this property may recreate the FHIR store (removing all data) **
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_healthcare_fhir_store#disable_referential_integrity GoogleHealthcareFhirStore#disable_referential_integrity}
    */
    readonly disableReferentialIntegrity?: boolean | cdktf.IResolvable;
    /**
    * Whether to disable resource versioning for this FHIR store. This field can not be changed after the creation
    * of FHIR store. If set to false, which is the default behavior, all write operations will cause historical
    * versions to be recorded automatically. The historical versions can be fetched through the history APIs, but
    * cannot be updated. If set to true, no historical versions will be kept. The server will send back errors for
    * attempts to read the historical versions.
    *
    * ** Changing this property may recreate the FHIR store (removing all data) **
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_healthcare_fhir_store#disable_resource_versioning GoogleHealthcareFhirStore#disable_resource_versioning}
    */
    readonly disableResourceVersioning?: boolean | cdktf.IResolvable;
    /**
    * Whether to allow the bulk import API to accept history bundles and directly insert historical resource
    * versions into the FHIR store. Importing resource histories creates resource interactions that appear to have
    * occurred in the past, which clients may not want to allow. If set to false, history bundles within an import
    * will fail with an error.
    *
    * ** Changing this property may recreate the FHIR store (removing all data) **
    *
    * ** This property can be changed manually in the Google Cloud Healthcare admin console without recreating the FHIR store **
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_healthcare_fhir_store#enable_history_import GoogleHealthcareFhirStore#enable_history_import}
    */
    readonly enableHistoryImport?: boolean | cdktf.IResolvable;
    /**
    * Whether to allow the ExecuteBundle API to accept history bundles, and directly insert and overwrite historical
    * resource versions into the FHIR store. If set to false, using history bundles fails with an error.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_healthcare_fhir_store#enable_history_modifications GoogleHealthcareFhirStore#enable_history_modifications}
    */
    readonly enableHistoryModifications?: boolean | cdktf.IResolvable;
    /**
    * Whether this FHIR store has the updateCreate capability. This determines if the client can use an Update
    * operation to create a new resource with a client-specified ID. If false, all IDs are server-assigned through
    * the Create operation and attempts to Update a non-existent resource will return errors. Please treat the audit
    * logs with appropriate levels of care if client-specified resource IDs contain sensitive data such as patient
    * identifiers, those IDs will be part of the FHIR resource path recorded in Cloud audit logs and Cloud Pub/Sub
    * notifications.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_healthcare_fhir_store#enable_update_create GoogleHealthcareFhirStore#enable_update_create}
    */
    readonly enableUpdateCreate?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_healthcare_fhir_store#id GoogleHealthcareFhirStore#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * User-supplied key-value pairs used to organize FHIR stores.
    *
    * Label keys must be between 1 and 63 characters long, have a UTF-8 encoding of maximum 128 bytes, and must
    * conform to the following PCRE regular expression: [\p{Ll}\p{Lo}][\p{Ll}\p{Lo}\p{N}_-]{0,62}
    *
    * Label values are optional, must be between 1 and 63 characters long, have a UTF-8 encoding of maximum 128
    * bytes, and must conform to the following PCRE regular expression: [\p{Ll}\p{Lo}\p{N}_-]{0,63}
    *
    * No more than 64 labels can be associated with a given store.
    *
    * An object containing a list of "key": value pairs.
    * Example: { "name": "wrench", "mass": "1.3kg", "count": "3" }.
    *
    *
    * **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
    * Please refer to the field 'effective_labels' for all of the labels present on the resource.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_healthcare_fhir_store#labels GoogleHealthcareFhirStore#labels}
    */
    readonly labels?: {
        [key: string]: string;
    };
    /**
    * The resource name for the FhirStore.
    *
    * ** Changing this property may recreate the FHIR store (removing all data) **
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_healthcare_fhir_store#name GoogleHealthcareFhirStore#name}
    */
    readonly name: string;
    /**
    * The FHIR specification version. Default value: "STU3" Possible values: ["DSTU2", "STU3", "R4"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_healthcare_fhir_store#version GoogleHealthcareFhirStore#version}
    */
    readonly version?: string;
    /**
    * notification_config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_healthcare_fhir_store#notification_config GoogleHealthcareFhirStore#notification_config}
    */
    readonly notificationConfig?: GoogleHealthcareFhirStoreNotificationConfig;
    /**
    * notification_configs block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_healthcare_fhir_store#notification_configs GoogleHealthcareFhirStore#notification_configs}
    */
    readonly notificationConfigs?: GoogleHealthcareFhirStoreNotificationConfigs[] | cdktf.IResolvable;
    /**
    * stream_configs block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_healthcare_fhir_store#stream_configs GoogleHealthcareFhirStore#stream_configs}
    */
    readonly streamConfigs?: GoogleHealthcareFhirStoreStreamConfigs[] | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_healthcare_fhir_store#timeouts GoogleHealthcareFhirStore#timeouts}
    */
    readonly timeouts?: GoogleHealthcareFhirStoreTimeouts;
}
export interface GoogleHealthcareFhirStoreNotificationConfig {
    /**
    * The Cloud Pub/Sub topic that notifications of changes are published on. Supplied by the client.
    * PubsubMessage.Data will contain the resource name. PubsubMessage.MessageId is the ID of this message.
    * It is guaranteed to be unique within the topic. PubsubMessage.PublishTime is the time at which the message
    * was published. Notifications are only sent if the topic is non-empty. Topic names must be scoped to a
    * project. service-PROJECT_NUMBER@gcp-sa-healthcare.iam.gserviceaccount.com must have publisher permissions on the given
    * Cloud Pub/Sub topic. Not having adequate permissions will cause the calls that send notifications to fail.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_healthcare_fhir_store#pubsub_topic GoogleHealthcareFhirStore#pubsub_topic}
    */
    readonly pubsubTopic: string;
}
export declare function googleHealthcareFhirStoreNotificationConfigToTerraform(struct?: GoogleHealthcareFhirStoreNotificationConfigOutputReference | GoogleHealthcareFhirStoreNotificationConfig): any;
export declare function googleHealthcareFhirStoreNotificationConfigToHclTerraform(struct?: GoogleHealthcareFhirStoreNotificationConfigOutputReference | GoogleHealthcareFhirStoreNotificationConfig): any;
export declare class GoogleHealthcareFhirStoreNotificationConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleHealthcareFhirStoreNotificationConfig | undefined;
    set internalValue(value: GoogleHealthcareFhirStoreNotificationConfig | undefined);
    private _pubsubTopic?;
    get pubsubTopic(): string;
    set pubsubTopic(value: string);
    get pubsubTopicInput(): string | undefined;
}
export interface GoogleHealthcareFhirStoreNotificationConfigs {
    /**
    * The Cloud Pub/Sub topic that notifications of changes are published on. Supplied by the client.
    * PubsubMessage.Data will contain the resource name. PubsubMessage.MessageId is the ID of this message.
    * It is guaranteed to be unique within the topic. PubsubMessage.PublishTime is the time at which the message
    * was published. Notifications are only sent if the topic is non-empty. Topic names must be scoped to a
    * project. service-PROJECT_NUMBER@gcp-sa-healthcare.iam.gserviceaccount.com must have publisher permissions on the given
    * Cloud Pub/Sub topic. Not having adequate permissions will cause the calls that send notifications to fail.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_healthcare_fhir_store#pubsub_topic GoogleHealthcareFhirStore#pubsub_topic}
    */
    readonly pubsubTopic: string;
    /**
    * Whether to send full FHIR resource to this Pub/Sub topic for Create and Update operation.
    * Note that setting this to true does not guarantee that all resources will be sent in the format of
    * full FHIR resource. When a resource change is too large or during heavy traffic, only the resource name will be
    * sent. Clients should always check the "payloadType" label from a Pub/Sub message to determine whether
    * it needs to fetch the full resource as a separate operation.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_healthcare_fhir_store#send_full_resource GoogleHealthcareFhirStore#send_full_resource}
    */
    readonly sendFullResource?: boolean | cdktf.IResolvable;
    /**
    * Whether to send full FHIR resource to this Pub/Sub topic for deleting FHIR resource. Note that setting this to
    * true does not guarantee that all previous resources will be sent in the format of full FHIR resource. When a
    * resource change is too large or during heavy traffic, only the resource name will be sent. Clients should always
    * check the "payloadType" label from a Pub/Sub message to determine whether it needs to fetch the full previous
    * resource as a separate operation.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_healthcare_fhir_store#send_previous_resource_on_delete GoogleHealthcareFhirStore#send_previous_resource_on_delete}
    */
    readonly sendPreviousResourceOnDelete?: boolean | cdktf.IResolvable;
}
export declare function googleHealthcareFhirStoreNotificationConfigsToTerraform(struct?: GoogleHealthcareFhirStoreNotificationConfigs | cdktf.IResolvable): any;
export declare function googleHealthcareFhirStoreNotificationConfigsToHclTerraform(struct?: GoogleHealthcareFhirStoreNotificationConfigs | cdktf.IResolvable): any;
export declare class GoogleHealthcareFhirStoreNotificationConfigsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleHealthcareFhirStoreNotificationConfigs | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleHealthcareFhirStoreNotificationConfigs | cdktf.IResolvable | undefined);
    private _pubsubTopic?;
    get pubsubTopic(): string;
    set pubsubTopic(value: string);
    get pubsubTopicInput(): string | undefined;
    private _sendFullResource?;
    get sendFullResource(): boolean | cdktf.IResolvable;
    set sendFullResource(value: boolean | cdktf.IResolvable);
    resetSendFullResource(): void;
    get sendFullResourceInput(): boolean | cdktf.IResolvable | undefined;
    private _sendPreviousResourceOnDelete?;
    get sendPreviousResourceOnDelete(): boolean | cdktf.IResolvable;
    set sendPreviousResourceOnDelete(value: boolean | cdktf.IResolvable);
    resetSendPreviousResourceOnDelete(): void;
    get sendPreviousResourceOnDeleteInput(): boolean | cdktf.IResolvable | undefined;
}
export declare class GoogleHealthcareFhirStoreNotificationConfigsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleHealthcareFhirStoreNotificationConfigs[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleHealthcareFhirStoreNotificationConfigsOutputReference;
}
export interface GoogleHealthcareFhirStoreStreamConfigsBigqueryDestinationSchemaConfigLastUpdatedPartitionConfig {
    /**
    * Number of milliseconds for which to keep the storage for a partition.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_healthcare_fhir_store#expiration_ms GoogleHealthcareFhirStore#expiration_ms}
    */
    readonly expirationMs?: string;
    /**
    * Type of partitioning. Possible values: ["PARTITION_TYPE_UNSPECIFIED", "HOUR", "DAY", "MONTH", "YEAR"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_healthcare_fhir_store#type GoogleHealthcareFhirStore#type}
    */
    readonly type: string;
}
export declare function googleHealthcareFhirStoreStreamConfigsBigqueryDestinationSchemaConfigLastUpdatedPartitionConfigToTerraform(struct?: GoogleHealthcareFhirStoreStreamConfigsBigqueryDestinationSchemaConfigLastUpdatedPartitionConfigOutputReference | GoogleHealthcareFhirStoreStreamConfigsBigqueryDestinationSchemaConfigLastUpdatedPartitionConfig): any;
export declare function googleHealthcareFhirStoreStreamConfigsBigqueryDestinationSchemaConfigLastUpdatedPartitionConfigToHclTerraform(struct?: GoogleHealthcareFhirStoreStreamConfigsBigqueryDestinationSchemaConfigLastUpdatedPartitionConfigOutputReference | GoogleHealthcareFhirStoreStreamConfigsBigqueryDestinationSchemaConfigLastUpdatedPartitionConfig): any;
export declare class GoogleHealthcareFhirStoreStreamConfigsBigqueryDestinationSchemaConfigLastUpdatedPartitionConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleHealthcareFhirStoreStreamConfigsBigqueryDestinationSchemaConfigLastUpdatedPartitionConfig | undefined;
    set internalValue(value: GoogleHealthcareFhirStoreStreamConfigsBigqueryDestinationSchemaConfigLastUpdatedPartitionConfig | undefined);
    private _expirationMs?;
    get expirationMs(): string;
    set expirationMs(value: string);
    resetExpirationMs(): void;
    get expirationMsInput(): string | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
}
export interface GoogleHealthcareFhirStoreStreamConfigsBigqueryDestinationSchemaConfig {
    /**
    * The depth for all recursive structures in the output analytics schema. For example, concept in the CodeSystem
    * resource is a recursive structure; when the depth is 2, the CodeSystem table will have a column called
    * concept.concept but not concept.concept.concept. If not specified or set to 0, the server will use the default
    * value 2. The maximum depth allowed is 5.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_healthcare_fhir_store#recursive_structure_depth GoogleHealthcareFhirStore#recursive_structure_depth}
    */
    readonly recursiveStructureDepth: number;
    /**
    * Specifies the output schema type.
    *  * ANALYTICS: Analytics schema defined by the FHIR community.
    *   See https://github.com/FHIR/sql-on-fhir/blob/master/sql-on-fhir.md.
    *  * ANALYTICS_V2: Analytics V2, similar to schema defined by the FHIR community, with added support for extensions with one or more occurrences and contained resources in stringified JSON.
    *  * LOSSLESS: A data-driven schema generated from the fields present in the FHIR data being exported, with no additional simplification. Default value: "ANALYTICS" Possible values: ["ANALYTICS", "ANALYTICS_V2", "LOSSLESS"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_healthcare_fhir_store#schema_type GoogleHealthcareFhirStore#schema_type}
    */
    readonly schemaType?: string;
    /**
    * last_updated_partition_config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_healthcare_fhir_store#last_updated_partition_config GoogleHealthcareFhirStore#last_updated_partition_config}
    */
    readonly lastUpdatedPartitionConfig?: GoogleHealthcareFhirStoreStreamConfigsBigqueryDestinationSchemaConfigLastUpdatedPartitionConfig;
}
export declare function googleHealthcareFhirStoreStreamConfigsBigqueryDestinationSchemaConfigToTerraform(struct?: GoogleHealthcareFhirStoreStreamConfigsBigqueryDestinationSchemaConfigOutputReference | GoogleHealthcareFhirStoreStreamConfigsBigqueryDestinationSchemaConfig): any;
export declare function googleHealthcareFhirStoreStreamConfigsBigqueryDestinationSchemaConfigToHclTerraform(struct?: GoogleHealthcareFhirStoreStreamConfigsBigqueryDestinationSchemaConfigOutputReference | GoogleHealthcareFhirStoreStreamConfigsBigqueryDestinationSchemaConfig): any;
export declare class GoogleHealthcareFhirStoreStreamConfigsBigqueryDestinationSchemaConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleHealthcareFhirStoreStreamConfigsBigqueryDestinationSchemaConfig | undefined;
    set internalValue(value: GoogleHealthcareFhirStoreStreamConfigsBigqueryDestinationSchemaConfig | undefined);
    private _recursiveStructureDepth?;
    get recursiveStructureDepth(): number;
    set recursiveStructureDepth(value: number);
    get recursiveStructureDepthInput(): number | undefined;
    private _schemaType?;
    get schemaType(): string;
    set schemaType(value: string);
    resetSchemaType(): void;
    get schemaTypeInput(): string | undefined;
    private _lastUpdatedPartitionConfig;
    get lastUpdatedPartitionConfig(): GoogleHealthcareFhirStoreStreamConfigsBigqueryDestinationSchemaConfigLastUpdatedPartitionConfigOutputReference;
    putLastUpdatedPartitionConfig(value: GoogleHealthcareFhirStoreStreamConfigsBigqueryDestinationSchemaConfigLastUpdatedPartitionConfig): void;
    resetLastUpdatedPartitionConfig(): void;
    get lastUpdatedPartitionConfigInput(): GoogleHealthcareFhirStoreStreamConfigsBigqueryDestinationSchemaConfigLastUpdatedPartitionConfig | undefined;
}
export interface GoogleHealthcareFhirStoreStreamConfigsBigqueryDestination {
    /**
    * BigQuery URI to a dataset, up to 2000 characters long, in the format bq://projectId.bqDatasetId
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_healthcare_fhir_store#dataset_uri GoogleHealthcareFhirStore#dataset_uri}
    */
    readonly datasetUri: string;
    /**
    * schema_config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_healthcare_fhir_store#schema_config GoogleHealthcareFhirStore#schema_config}
    */
    readonly schemaConfig: GoogleHealthcareFhirStoreStreamConfigsBigqueryDestinationSchemaConfig;
}
export declare function googleHealthcareFhirStoreStreamConfigsBigqueryDestinationToTerraform(struct?: GoogleHealthcareFhirStoreStreamConfigsBigqueryDestinationOutputReference | GoogleHealthcareFhirStoreStreamConfigsBigqueryDestination): any;
export declare function googleHealthcareFhirStoreStreamConfigsBigqueryDestinationToHclTerraform(struct?: GoogleHealthcareFhirStoreStreamConfigsBigqueryDestinationOutputReference | GoogleHealthcareFhirStoreStreamConfigsBigqueryDestination): any;
export declare class GoogleHealthcareFhirStoreStreamConfigsBigqueryDestinationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleHealthcareFhirStoreStreamConfigsBigqueryDestination | undefined;
    set internalValue(value: GoogleHealthcareFhirStoreStreamConfigsBigqueryDestination | undefined);
    private _datasetUri?;
    get datasetUri(): string;
    set datasetUri(value: string);
    get datasetUriInput(): string | undefined;
    private _schemaConfig;
    get schemaConfig(): GoogleHealthcareFhirStoreStreamConfigsBigqueryDestinationSchemaConfigOutputReference;
    putSchemaConfig(value: GoogleHealthcareFhirStoreStreamConfigsBigqueryDestinationSchemaConfig): void;
    get schemaConfigInput(): GoogleHealthcareFhirStoreStreamConfigsBigqueryDestinationSchemaConfig | undefined;
}
export interface GoogleHealthcareFhirStoreStreamConfigs {
    /**
    * Supply a FHIR resource type (such as "Patient" or "Observation"). See
    * https://www.hl7.org/fhir/valueset-resource-types.html for a list of all FHIR resource types. The server treats
    * an empty list as an intent to stream all the supported resource types in this FHIR store.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_healthcare_fhir_store#resource_types GoogleHealthcareFhirStore#resource_types}
    */
    readonly resourceTypes?: string[];
    /**
    * bigquery_destination block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_healthcare_fhir_store#bigquery_destination GoogleHealthcareFhirStore#bigquery_destination}
    */
    readonly bigqueryDestination: GoogleHealthcareFhirStoreStreamConfigsBigqueryDestination;
}
export declare function googleHealthcareFhirStoreStreamConfigsToTerraform(struct?: GoogleHealthcareFhirStoreStreamConfigs | cdktf.IResolvable): any;
export declare function googleHealthcareFhirStoreStreamConfigsToHclTerraform(struct?: GoogleHealthcareFhirStoreStreamConfigs | cdktf.IResolvable): any;
export declare class GoogleHealthcareFhirStoreStreamConfigsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleHealthcareFhirStoreStreamConfigs | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleHealthcareFhirStoreStreamConfigs | cdktf.IResolvable | undefined);
    private _resourceTypes?;
    get resourceTypes(): string[];
    set resourceTypes(value: string[]);
    resetResourceTypes(): void;
    get resourceTypesInput(): string[] | undefined;
    private _bigqueryDestination;
    get bigqueryDestination(): GoogleHealthcareFhirStoreStreamConfigsBigqueryDestinationOutputReference;
    putBigqueryDestination(value: GoogleHealthcareFhirStoreStreamConfigsBigqueryDestination): void;
    get bigqueryDestinationInput(): GoogleHealthcareFhirStoreStreamConfigsBigqueryDestination | undefined;
}
export declare class GoogleHealthcareFhirStoreStreamConfigsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleHealthcareFhirStoreStreamConfigs[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleHealthcareFhirStoreStreamConfigsOutputReference;
}
export interface GoogleHealthcareFhirStoreTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_healthcare_fhir_store#create GoogleHealthcareFhirStore#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_healthcare_fhir_store#delete GoogleHealthcareFhirStore#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_healthcare_fhir_store#update GoogleHealthcareFhirStore#update}
    */
    readonly update?: string;
}
export declare function googleHealthcareFhirStoreTimeoutsToTerraform(struct?: GoogleHealthcareFhirStoreTimeouts | cdktf.IResolvable): any;
export declare function googleHealthcareFhirStoreTimeoutsToHclTerraform(struct?: GoogleHealthcareFhirStoreTimeouts | cdktf.IResolvable): any;
export declare class GoogleHealthcareFhirStoreTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleHealthcareFhirStoreTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleHealthcareFhirStoreTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_healthcare_fhir_store google_healthcare_fhir_store}
*/
export declare class GoogleHealthcareFhirStore extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_healthcare_fhir_store";
    /**
    * Generates CDKTF code for importing a GoogleHealthcareFhirStore resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the GoogleHealthcareFhirStore to import
    * @param importFromId The id of the existing GoogleHealthcareFhirStore that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_healthcare_fhir_store#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the GoogleHealthcareFhirStore to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_healthcare_fhir_store google_healthcare_fhir_store} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleHealthcareFhirStoreConfig
    */
    constructor(scope: Construct, id: string, config: GoogleHealthcareFhirStoreConfig);
    private _complexDataTypeReferenceParsing?;
    get complexDataTypeReferenceParsing(): string;
    set complexDataTypeReferenceParsing(value: string);
    resetComplexDataTypeReferenceParsing(): void;
    get complexDataTypeReferenceParsingInput(): string | undefined;
    private _dataset?;
    get dataset(): string;
    set dataset(value: string);
    get datasetInput(): string | undefined;
    private _defaultSearchHandlingStrict?;
    get defaultSearchHandlingStrict(): boolean | cdktf.IResolvable;
    set defaultSearchHandlingStrict(value: boolean | cdktf.IResolvable);
    resetDefaultSearchHandlingStrict(): void;
    get defaultSearchHandlingStrictInput(): boolean | cdktf.IResolvable | undefined;
    private _disableReferentialIntegrity?;
    get disableReferentialIntegrity(): boolean | cdktf.IResolvable;
    set disableReferentialIntegrity(value: boolean | cdktf.IResolvable);
    resetDisableReferentialIntegrity(): void;
    get disableReferentialIntegrityInput(): boolean | cdktf.IResolvable | undefined;
    private _disableResourceVersioning?;
    get disableResourceVersioning(): boolean | cdktf.IResolvable;
    set disableResourceVersioning(value: boolean | cdktf.IResolvable);
    resetDisableResourceVersioning(): void;
    get disableResourceVersioningInput(): boolean | cdktf.IResolvable | undefined;
    private _effectiveLabels;
    get effectiveLabels(): cdktf.StringMap;
    private _enableHistoryImport?;
    get enableHistoryImport(): boolean | cdktf.IResolvable;
    set enableHistoryImport(value: boolean | cdktf.IResolvable);
    resetEnableHistoryImport(): void;
    get enableHistoryImportInput(): boolean | cdktf.IResolvable | undefined;
    private _enableHistoryModifications?;
    get enableHistoryModifications(): boolean | cdktf.IResolvable;
    set enableHistoryModifications(value: boolean | cdktf.IResolvable);
    resetEnableHistoryModifications(): void;
    get enableHistoryModificationsInput(): boolean | cdktf.IResolvable | undefined;
    private _enableUpdateCreate?;
    get enableUpdateCreate(): boolean | cdktf.IResolvable;
    set enableUpdateCreate(value: boolean | cdktf.IResolvable);
    resetEnableUpdateCreate(): void;
    get enableUpdateCreateInput(): boolean | cdktf.IResolvable | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _labels?;
    get labels(): {
        [key: string]: string;
    };
    set labels(value: {
        [key: string]: string;
    });
    resetLabels(): void;
    get labelsInput(): {
        [key: string]: string;
    } | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get selfLink(): string;
    private _terraformLabels;
    get terraformLabels(): cdktf.StringMap;
    private _version?;
    get version(): string;
    set version(value: string);
    resetVersion(): void;
    get versionInput(): string | undefined;
    private _notificationConfig;
    get notificationConfig(): GoogleHealthcareFhirStoreNotificationConfigOutputReference;
    putNotificationConfig(value: GoogleHealthcareFhirStoreNotificationConfig): void;
    resetNotificationConfig(): void;
    get notificationConfigInput(): GoogleHealthcareFhirStoreNotificationConfig | undefined;
    private _notificationConfigs;
    get notificationConfigs(): GoogleHealthcareFhirStoreNotificationConfigsList;
    putNotificationConfigs(value: GoogleHealthcareFhirStoreNotificationConfigs[] | cdktf.IResolvable): void;
    resetNotificationConfigs(): void;
    get notificationConfigsInput(): cdktf.IResolvable | GoogleHealthcareFhirStoreNotificationConfigs[] | undefined;
    private _streamConfigs;
    get streamConfigs(): GoogleHealthcareFhirStoreStreamConfigsList;
    putStreamConfigs(value: GoogleHealthcareFhirStoreStreamConfigs[] | cdktf.IResolvable): void;
    resetStreamConfigs(): void;
    get streamConfigsInput(): cdktf.IResolvable | GoogleHealthcareFhirStoreStreamConfigs[] | undefined;
    private _timeouts;
    get timeouts(): GoogleHealthcareFhirStoreTimeoutsOutputReference;
    putTimeouts(value: GoogleHealthcareFhirStoreTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleHealthcareFhirStoreTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
