/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleHealthcareHl7V2StoreIamMemberConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_healthcare_hl7_v2_store_iam_member#hl7_v2_store_id GoogleHealthcareHl7V2StoreIamMember#hl7_v2_store_id}
    */
    readonly hl7V2StoreId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_healthcare_hl7_v2_store_iam_member#id GoogleHealthcareHl7V2StoreIamMember#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_healthcare_hl7_v2_store_iam_member#member GoogleHealthcareHl7V2StoreIamMember#member}
    */
    readonly member: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_healthcare_hl7_v2_store_iam_member#role GoogleHealthcareHl7V2StoreIamMember#role}
    */
    readonly role: string;
    /**
    * condition block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_healthcare_hl7_v2_store_iam_member#condition GoogleHealthcareHl7V2StoreIamMember#condition}
    */
    readonly condition?: GoogleHealthcareHl7V2StoreIamMemberCondition;
}
export interface GoogleHealthcareHl7V2StoreIamMemberCondition {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_healthcare_hl7_v2_store_iam_member#description GoogleHealthcareHl7V2StoreIamMember#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_healthcare_hl7_v2_store_iam_member#expression GoogleHealthcareHl7V2StoreIamMember#expression}
    */
    readonly expression: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_healthcare_hl7_v2_store_iam_member#title GoogleHealthcareHl7V2StoreIamMember#title}
    */
    readonly title: string;
}
export declare function googleHealthcareHl7V2StoreIamMemberConditionToTerraform(struct?: GoogleHealthcareHl7V2StoreIamMemberConditionOutputReference | GoogleHealthcareHl7V2StoreIamMemberCondition): any;
export declare function googleHealthcareHl7V2StoreIamMemberConditionToHclTerraform(struct?: GoogleHealthcareHl7V2StoreIamMemberConditionOutputReference | GoogleHealthcareHl7V2StoreIamMemberCondition): any;
export declare class GoogleHealthcareHl7V2StoreIamMemberConditionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleHealthcareHl7V2StoreIamMemberCondition | undefined;
    set internalValue(value: GoogleHealthcareHl7V2StoreIamMemberCondition | undefined);
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _expression?;
    get expression(): string;
    set expression(value: string);
    get expressionInput(): string | undefined;
    private _title?;
    get title(): string;
    set title(value: string);
    get titleInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_healthcare_hl7_v2_store_iam_member google_healthcare_hl7_v2_store_iam_member}
*/
export declare class GoogleHealthcareHl7V2StoreIamMember extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_healthcare_hl7_v2_store_iam_member";
    /**
    * Generates CDKTF code for importing a GoogleHealthcareHl7V2StoreIamMember resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the GoogleHealthcareHl7V2StoreIamMember to import
    * @param importFromId The id of the existing GoogleHealthcareHl7V2StoreIamMember that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_healthcare_hl7_v2_store_iam_member#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the GoogleHealthcareHl7V2StoreIamMember to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_healthcare_hl7_v2_store_iam_member google_healthcare_hl7_v2_store_iam_member} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleHealthcareHl7V2StoreIamMemberConfig
    */
    constructor(scope: Construct, id: string, config: GoogleHealthcareHl7V2StoreIamMemberConfig);
    get etag(): string;
    private _hl7V2StoreId?;
    get hl7V2StoreId(): string;
    set hl7V2StoreId(value: string);
    get hl7V2StoreIdInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _member?;
    get member(): string;
    set member(value: string);
    get memberInput(): string | undefined;
    private _role?;
    get role(): string;
    set role(value: string);
    get roleInput(): string | undefined;
    private _condition;
    get condition(): GoogleHealthcareHl7V2StoreIamMemberConditionOutputReference;
    putCondition(value: GoogleHealthcareHl7V2StoreIamMemberCondition): void;
    resetCondition(): void;
    get conditionInput(): GoogleHealthcareHl7V2StoreIamMemberCondition | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
