/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleHealthcareHl7V2StoreIamPolicyConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_healthcare_hl7_v2_store_iam_policy#hl7_v2_store_id GoogleHealthcareHl7V2StoreIamPolicy#hl7_v2_store_id}
    */
    readonly hl7V2StoreId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_healthcare_hl7_v2_store_iam_policy#id GoogleHealthcareHl7V2StoreIamPolicy#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_healthcare_hl7_v2_store_iam_policy#policy_data GoogleHealthcareHl7V2StoreIamPolicy#policy_data}
    */
    readonly policyData: string;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_healthcare_hl7_v2_store_iam_policy google_healthcare_hl7_v2_store_iam_policy}
*/
export declare class GoogleHealthcareHl7V2StoreIamPolicy extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_healthcare_hl7_v2_store_iam_policy";
    /**
    * Generates CDKTF code for importing a GoogleHealthcareHl7V2StoreIamPolicy resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the GoogleHealthcareHl7V2StoreIamPolicy to import
    * @param importFromId The id of the existing GoogleHealthcareHl7V2StoreIamPolicy that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_healthcare_hl7_v2_store_iam_policy#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the GoogleHealthcareHl7V2StoreIamPolicy to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_healthcare_hl7_v2_store_iam_policy google_healthcare_hl7_v2_store_iam_policy} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleHealthcareHl7V2StoreIamPolicyConfig
    */
    constructor(scope: Construct, id: string, config: GoogleHealthcareHl7V2StoreIamPolicyConfig);
    get etag(): string;
    private _hl7V2StoreId?;
    get hl7V2StoreId(): string;
    set hl7V2StoreId(value: string);
    get hl7V2StoreIdInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _policyData?;
    get policyData(): string;
    set policyData(value: string);
    get policyDataInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
