/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleHealthcareHl7V2StoreConfig extends cdktf.TerraformMetaArguments {
    /**
    * Identifies the dataset addressed by this request. Must be in the format
    * 'projects/{project}/locations/{location}/datasets/{dataset}'
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_healthcare_hl7_v2_store#dataset GoogleHealthcareHl7V2Store#dataset}
    */
    readonly dataset: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_healthcare_hl7_v2_store#id GoogleHealthcareHl7V2Store#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * User-supplied key-value pairs used to organize HL7v2 stores.
    *
    * Label keys must be between 1 and 63 characters long, have a UTF-8 encoding of maximum 128 bytes, and must
    * conform to the following PCRE regular expression: [\p{Ll}\p{Lo}][\p{Ll}\p{Lo}\p{N}_-]{0,62}
    *
    * Label values are optional, must be between 1 and 63 characters long, have a UTF-8 encoding of maximum 128
    * bytes, and must conform to the following PCRE regular expression: [\p{Ll}\p{Lo}\p{N}_-]{0,63}
    *
    * No more than 64 labels can be associated with a given store.
    *
    * An object containing a list of "key": value pairs.
    * Example: { "name": "wrench", "mass": "1.3kg", "count": "3" }.
    *
    *
    * **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
    * Please refer to the field 'effective_labels' for all of the labels present on the resource.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_healthcare_hl7_v2_store#labels GoogleHealthcareHl7V2Store#labels}
    */
    readonly labels?: {
        [key: string]: string;
    };
    /**
    * The resource name for the Hl7V2Store.
    *
    * ** Changing this property may recreate the Hl7v2 store (removing all data) **
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_healthcare_hl7_v2_store#name GoogleHealthcareHl7V2Store#name}
    */
    readonly name: string;
    /**
    * Determines whether duplicate messages are allowed.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_healthcare_hl7_v2_store#reject_duplicate_message GoogleHealthcareHl7V2Store#reject_duplicate_message}
    */
    readonly rejectDuplicateMessage?: boolean | cdktf.IResolvable;
    /**
    * notification_config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_healthcare_hl7_v2_store#notification_config GoogleHealthcareHl7V2Store#notification_config}
    */
    readonly notificationConfig?: GoogleHealthcareHl7V2StoreNotificationConfig;
    /**
    * notification_configs block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_healthcare_hl7_v2_store#notification_configs GoogleHealthcareHl7V2Store#notification_configs}
    */
    readonly notificationConfigs?: GoogleHealthcareHl7V2StoreNotificationConfigs[] | cdktf.IResolvable;
    /**
    * parser_config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_healthcare_hl7_v2_store#parser_config GoogleHealthcareHl7V2Store#parser_config}
    */
    readonly parserConfig?: GoogleHealthcareHl7V2StoreParserConfig;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_healthcare_hl7_v2_store#timeouts GoogleHealthcareHl7V2Store#timeouts}
    */
    readonly timeouts?: GoogleHealthcareHl7V2StoreTimeouts;
}
export interface GoogleHealthcareHl7V2StoreNotificationConfig {
    /**
    * The Cloud Pub/Sub topic that notifications of changes are published on. Supplied by the client.
    * PubsubMessage.Data will contain the resource name. PubsubMessage.MessageId is the ID of this message.
    * It is guaranteed to be unique within the topic. PubsubMessage.PublishTime is the time at which the message
    * was published. Notifications are only sent if the topic is non-empty. Topic names must be scoped to a
    * project. service-PROJECT_NUMBER@gcp-sa-healthcare.iam.gserviceaccount.com must have publisher permissions on the given
    * Cloud Pub/Sub topic. Not having adequate permissions will cause the calls that send notifications to fail.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_healthcare_hl7_v2_store#pubsub_topic GoogleHealthcareHl7V2Store#pubsub_topic}
    */
    readonly pubsubTopic: string;
}
export declare function googleHealthcareHl7V2StoreNotificationConfigToTerraform(struct?: GoogleHealthcareHl7V2StoreNotificationConfigOutputReference | GoogleHealthcareHl7V2StoreNotificationConfig): any;
export declare function googleHealthcareHl7V2StoreNotificationConfigToHclTerraform(struct?: GoogleHealthcareHl7V2StoreNotificationConfigOutputReference | GoogleHealthcareHl7V2StoreNotificationConfig): any;
export declare class GoogleHealthcareHl7V2StoreNotificationConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleHealthcareHl7V2StoreNotificationConfig | undefined;
    set internalValue(value: GoogleHealthcareHl7V2StoreNotificationConfig | undefined);
    private _pubsubTopic?;
    get pubsubTopic(): string;
    set pubsubTopic(value: string);
    get pubsubTopicInput(): string | undefined;
}
export interface GoogleHealthcareHl7V2StoreNotificationConfigs {
    /**
    * Restricts notifications sent for messages matching a filter. If this is empty, all messages
    * are matched. Syntax: https://cloud.google.com/appengine/docs/standard/python/search/query_strings
    *
    * Fields/functions available for filtering are:
    *
    * * messageType, from the MSH-9.1 field. For example, NOT messageType = "ADT".
    * * send_date or sendDate, the YYYY-MM-DD date the message was sent in the dataset's timeZone, from the MSH-7 segment. For example, send_date < "2017-01-02".
    * * sendTime, the timestamp when the message was sent, using the RFC3339 time format for comparisons, from the MSH-7 segment. For example, sendTime < "2017-01-02T00:00:00-05:00".
    * * sendFacility, the care center that the message came from, from the MSH-4 segment. For example, sendFacility = "ABC".
    * * PatientId(value, type), which matches if the message lists a patient having an ID of the given value and type in the PID-2, PID-3, or PID-4 segments. For example, PatientId("123456", "MRN").
    * * labels.x, a string value of the label with key x as set using the Message.labels map. For example, labels."priority"="high". The operator :* can be used to assert the existence of a label. For example, labels."priority":*.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_healthcare_hl7_v2_store#filter GoogleHealthcareHl7V2Store#filter}
    */
    readonly filter?: string;
    /**
    * The Cloud Pub/Sub topic that notifications of changes are published on. Supplied by the client.
    * PubsubMessage.Data will contain the resource name. PubsubMessage.MessageId is the ID of this message.
    * It is guaranteed to be unique within the topic. PubsubMessage.PublishTime is the time at which the message
    * was published. Notifications are only sent if the topic is non-empty. Topic names must be scoped to a
    * project. service-PROJECT_NUMBER@gcp-sa-healthcare.iam.gserviceaccount.com must have publisher permissions on the given
    * Cloud Pub/Sub topic. Not having adequate permissions will cause the calls that send notifications to fail.
    *
    * If a notification cannot be published to Cloud Pub/Sub, errors will be logged to Stackdriver
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_healthcare_hl7_v2_store#pubsub_topic GoogleHealthcareHl7V2Store#pubsub_topic}
    */
    readonly pubsubTopic: string;
}
export declare function googleHealthcareHl7V2StoreNotificationConfigsToTerraform(struct?: GoogleHealthcareHl7V2StoreNotificationConfigs | cdktf.IResolvable): any;
export declare function googleHealthcareHl7V2StoreNotificationConfigsToHclTerraform(struct?: GoogleHealthcareHl7V2StoreNotificationConfigs | cdktf.IResolvable): any;
export declare class GoogleHealthcareHl7V2StoreNotificationConfigsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleHealthcareHl7V2StoreNotificationConfigs | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleHealthcareHl7V2StoreNotificationConfigs | cdktf.IResolvable | undefined);
    private _filter?;
    get filter(): string;
    set filter(value: string);
    resetFilter(): void;
    get filterInput(): string | undefined;
    private _pubsubTopic?;
    get pubsubTopic(): string;
    set pubsubTopic(value: string);
    get pubsubTopicInput(): string | undefined;
}
export declare class GoogleHealthcareHl7V2StoreNotificationConfigsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleHealthcareHl7V2StoreNotificationConfigs[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleHealthcareHl7V2StoreNotificationConfigsOutputReference;
}
export interface GoogleHealthcareHl7V2StoreParserConfig {
    /**
    * Determines whether messages with no header are allowed.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_healthcare_hl7_v2_store#allow_null_header GoogleHealthcareHl7V2Store#allow_null_header}
    */
    readonly allowNullHeader?: boolean | cdktf.IResolvable;
    /**
    * JSON encoded string for schemas used to parse messages in this
    * store if schematized parsing is desired.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_healthcare_hl7_v2_store#schema GoogleHealthcareHl7V2Store#schema}
    */
    readonly schema?: string;
    /**
    * Byte(s) to be used as the segment terminator. If this is unset, '\r' will be used as segment terminator.
    *
    * A base64-encoded string.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_healthcare_hl7_v2_store#segment_terminator GoogleHealthcareHl7V2Store#segment_terminator}
    */
    readonly segmentTerminator?: string;
    /**
    * The version of the unschematized parser to be used when a custom 'schema' is not set. Default value: "V1" Possible values: ["V1", "V2", "V3"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_healthcare_hl7_v2_store#version GoogleHealthcareHl7V2Store#version}
    */
    readonly version?: string;
}
export declare function googleHealthcareHl7V2StoreParserConfigToTerraform(struct?: GoogleHealthcareHl7V2StoreParserConfigOutputReference | GoogleHealthcareHl7V2StoreParserConfig): any;
export declare function googleHealthcareHl7V2StoreParserConfigToHclTerraform(struct?: GoogleHealthcareHl7V2StoreParserConfigOutputReference | GoogleHealthcareHl7V2StoreParserConfig): any;
export declare class GoogleHealthcareHl7V2StoreParserConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleHealthcareHl7V2StoreParserConfig | undefined;
    set internalValue(value: GoogleHealthcareHl7V2StoreParserConfig | undefined);
    private _allowNullHeader?;
    get allowNullHeader(): boolean | cdktf.IResolvable;
    set allowNullHeader(value: boolean | cdktf.IResolvable);
    resetAllowNullHeader(): void;
    get allowNullHeaderInput(): boolean | cdktf.IResolvable | undefined;
    private _schema?;
    get schema(): string;
    set schema(value: string);
    resetSchema(): void;
    get schemaInput(): string | undefined;
    private _segmentTerminator?;
    get segmentTerminator(): string;
    set segmentTerminator(value: string);
    resetSegmentTerminator(): void;
    get segmentTerminatorInput(): string | undefined;
    private _version?;
    get version(): string;
    set version(value: string);
    resetVersion(): void;
    get versionInput(): string | undefined;
}
export interface GoogleHealthcareHl7V2StoreTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_healthcare_hl7_v2_store#create GoogleHealthcareHl7V2Store#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_healthcare_hl7_v2_store#delete GoogleHealthcareHl7V2Store#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_healthcare_hl7_v2_store#update GoogleHealthcareHl7V2Store#update}
    */
    readonly update?: string;
}
export declare function googleHealthcareHl7V2StoreTimeoutsToTerraform(struct?: GoogleHealthcareHl7V2StoreTimeouts | cdktf.IResolvable): any;
export declare function googleHealthcareHl7V2StoreTimeoutsToHclTerraform(struct?: GoogleHealthcareHl7V2StoreTimeouts | cdktf.IResolvable): any;
export declare class GoogleHealthcareHl7V2StoreTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleHealthcareHl7V2StoreTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleHealthcareHl7V2StoreTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_healthcare_hl7_v2_store google_healthcare_hl7_v2_store}
*/
export declare class GoogleHealthcareHl7V2Store extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_healthcare_hl7_v2_store";
    /**
    * Generates CDKTF code for importing a GoogleHealthcareHl7V2Store resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the GoogleHealthcareHl7V2Store to import
    * @param importFromId The id of the existing GoogleHealthcareHl7V2Store that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_healthcare_hl7_v2_store#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the GoogleHealthcareHl7V2Store to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_healthcare_hl7_v2_store google_healthcare_hl7_v2_store} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleHealthcareHl7V2StoreConfig
    */
    constructor(scope: Construct, id: string, config: GoogleHealthcareHl7V2StoreConfig);
    private _dataset?;
    get dataset(): string;
    set dataset(value: string);
    get datasetInput(): string | undefined;
    private _effectiveLabels;
    get effectiveLabels(): cdktf.StringMap;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _labels?;
    get labels(): {
        [key: string]: string;
    };
    set labels(value: {
        [key: string]: string;
    });
    resetLabels(): void;
    get labelsInput(): {
        [key: string]: string;
    } | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _rejectDuplicateMessage?;
    get rejectDuplicateMessage(): boolean | cdktf.IResolvable;
    set rejectDuplicateMessage(value: boolean | cdktf.IResolvable);
    resetRejectDuplicateMessage(): void;
    get rejectDuplicateMessageInput(): boolean | cdktf.IResolvable | undefined;
    get selfLink(): string;
    private _terraformLabels;
    get terraformLabels(): cdktf.StringMap;
    private _notificationConfig;
    get notificationConfig(): GoogleHealthcareHl7V2StoreNotificationConfigOutputReference;
    putNotificationConfig(value: GoogleHealthcareHl7V2StoreNotificationConfig): void;
    resetNotificationConfig(): void;
    get notificationConfigInput(): GoogleHealthcareHl7V2StoreNotificationConfig | undefined;
    private _notificationConfigs;
    get notificationConfigs(): GoogleHealthcareHl7V2StoreNotificationConfigsList;
    putNotificationConfigs(value: GoogleHealthcareHl7V2StoreNotificationConfigs[] | cdktf.IResolvable): void;
    resetNotificationConfigs(): void;
    get notificationConfigsInput(): cdktf.IResolvable | GoogleHealthcareHl7V2StoreNotificationConfigs[] | undefined;
    private _parserConfig;
    get parserConfig(): GoogleHealthcareHl7V2StoreParserConfigOutputReference;
    putParserConfig(value: GoogleHealthcareHl7V2StoreParserConfig): void;
    resetParserConfig(): void;
    get parserConfigInput(): GoogleHealthcareHl7V2StoreParserConfig | undefined;
    private _timeouts;
    get timeouts(): GoogleHealthcareHl7V2StoreTimeoutsOutputReference;
    putTimeouts(value: GoogleHealthcareHl7V2StoreTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleHealthcareHl7V2StoreTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
