/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleIamWorkforcePoolProviderConfig extends cdktf.TerraformMetaArguments {
    /**
    * A [Common Expression Language](https://opensource.google/projects/cel) expression, in
    * plain text, to restrict what otherwise valid authentication credentials issued by the
    * provider should not be accepted.
    *
    * The expression must output a boolean representing whether to allow the federation.
    *
    * The following keywords may be referenced in the expressions:
    *   * 'assertion': JSON representing the authentication credential issued by the provider.
    *   * 'google': The Google attributes mapped from the assertion in the 'attribute_mappings'.
    *     'google.profile_photo' and 'google.display_name' are not supported.
    *   * 'attribute': The custom attributes mapped from the assertion in the 'attribute_mappings'.
    *
    * The maximum length of the attribute condition expression is 4096 characters.
    * If unspecified, all valid authentication credentials will be accepted.
    *
    * The following example shows how to only allow credentials with a mapped 'google.groups' value of 'admins':
    * ```
    * "'admins' in google.groups"
    * ```
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_iam_workforce_pool_provider#attribute_condition GoogleIamWorkforcePoolProvider#attribute_condition}
    */
    readonly attributeCondition?: string;
    /**
    * Maps attributes from the authentication credentials issued by an external identity provider
    * to Google Cloud attributes, such as 'subject' and 'segment'.
    *
    * Each key must be a string specifying the Google Cloud IAM attribute to map to.
    *
    * The following keys are supported:
    *   * 'google.subject': The principal IAM is authenticating. You can reference this value in IAM bindings.
    *     This is also the subject that appears in Cloud Logging logs. This is a required field and
    *     the mapped subject cannot exceed 127 bytes.
    *   * 'google.groups': Groups the authenticating user belongs to. You can grant groups access to
    *     resources using an IAM 'principalSet' binding; access applies to all members of the group.
    *   * 'google.display_name': The name of the authenticated user. This is an optional field and
    *     the mapped display name cannot exceed 100 bytes. If not set, 'google.subject' will be displayed instead.
    *     This attribute cannot be referenced in IAM bindings.
    *   * 'google.profile_photo': The URL that specifies the authenticated user's thumbnail photo.
    *     This is an optional field. When set, the image will be visible as the user's profile picture.
    *     If not set, a generic user icon will be displayed instead.
    *     This attribute cannot be referenced in IAM bindings.
    *
    * You can also provide custom attributes by specifying 'attribute.{custom_attribute}', where {custom_attribute}
    * is the name of the custom attribute to be mapped. You can define a maximum of 50 custom attributes.
    * The maximum length of a mapped attribute key is 100 characters, and the key may only contain the characters [a-z0-9_].
    *
    * You can reference these attributes in IAM policies to define fine-grained access for a workforce pool
    * to Google Cloud resources. For example:
    *   * 'google.subject':
    *     'principal://iam.googleapis.com/locations/{location}/workforcePools/{pool}/subject/{value}'
    *   * 'google.groups':
    *     'principalSet://iam.googleapis.com/locations/{location}/workforcePools/{pool}/group/{value}'
    *   * 'attribute.{custom_attribute}':
    *     'principalSet://iam.googleapis.com/locations/{location}/workforcePools/{pool}/attribute.{custom_attribute}/{value}'
    *
    * Each value must be a [Common Expression Language](https://opensource.google/projects/cel)
    * function that maps an identity provider credential to the normalized attribute specified
    * by the corresponding map key.
    *
    * You can use the 'assertion' keyword in the expression to access a JSON representation of
    * the authentication credential issued by the provider.
    *
    * The maximum length of an attribute mapping expression is 2048 characters. When evaluated,
    * the total size of all mapped attributes must not exceed 8KB.
    *
    * For OIDC providers, you must supply a custom mapping that includes the 'google.subject' attribute.
    * For example, the following maps the sub claim of the incoming credential to the 'subject' attribute
    * on a Google token:
    * ```
    * {"google.subject": "assertion.sub"}
    * ```
    *
    * An object containing a list of '"key": value' pairs.
    * Example: '{ "name": "wrench", "mass": "1.3kg", "count": "3" }'.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_iam_workforce_pool_provider#attribute_mapping GoogleIamWorkforcePoolProvider#attribute_mapping}
    */
    readonly attributeMapping?: {
        [key: string]: string;
    };
    /**
    * A user-specified description of the provider. Cannot exceed 256 characters.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_iam_workforce_pool_provider#description GoogleIamWorkforcePoolProvider#description}
    */
    readonly description?: string;
    /**
    * Whether the provider is disabled. You cannot use a disabled provider to exchange tokens.
    * However, existing tokens still grant access.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_iam_workforce_pool_provider#disabled GoogleIamWorkforcePoolProvider#disabled}
    */
    readonly disabled?: boolean | cdktf.IResolvable;
    /**
    * A user-specified display name for the provider. Cannot exceed 32 characters.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_iam_workforce_pool_provider#display_name GoogleIamWorkforcePoolProvider#display_name}
    */
    readonly displayName?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_iam_workforce_pool_provider#id GoogleIamWorkforcePoolProvider#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The location for the resource.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_iam_workforce_pool_provider#location GoogleIamWorkforcePoolProvider#location}
    */
    readonly location: string;
    /**
    * The ID for the provider, which becomes the final component of the resource name.
    * This value must be 4-32 characters, and may contain the characters [a-z0-9-].
    * The prefix 'gcp-' is reserved for use by Google, and may not be specified.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_iam_workforce_pool_provider#provider_id GoogleIamWorkforcePoolProvider#provider_id}
    */
    readonly providerId: string;
    /**
    * The ID to use for the pool, which becomes the final component of the resource name.
    * The IDs must be a globally unique string of 6 to 63 lowercase letters, digits, or hyphens.
    * It must start with a letter, and cannot have a trailing hyphen.
    * The prefix 'gcp-' is reserved for use by Google, and may not be specified.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_iam_workforce_pool_provider#workforce_pool_id GoogleIamWorkforcePoolProvider#workforce_pool_id}
    */
    readonly workforcePoolId: string;
    /**
    * oidc block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_iam_workforce_pool_provider#oidc GoogleIamWorkforcePoolProvider#oidc}
    */
    readonly oidc?: GoogleIamWorkforcePoolProviderOidc;
    /**
    * saml block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_iam_workforce_pool_provider#saml GoogleIamWorkforcePoolProvider#saml}
    */
    readonly saml?: GoogleIamWorkforcePoolProviderSaml;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_iam_workforce_pool_provider#timeouts GoogleIamWorkforcePoolProvider#timeouts}
    */
    readonly timeouts?: GoogleIamWorkforcePoolProviderTimeouts;
}
export interface GoogleIamWorkforcePoolProviderOidcClientSecretValue {
    /**
    * The plain text of the client secret value.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_iam_workforce_pool_provider#plain_text GoogleIamWorkforcePoolProvider#plain_text}
    */
    readonly plainText: string;
}
export declare function googleIamWorkforcePoolProviderOidcClientSecretValueToTerraform(struct?: GoogleIamWorkforcePoolProviderOidcClientSecretValueOutputReference | GoogleIamWorkforcePoolProviderOidcClientSecretValue): any;
export declare function googleIamWorkforcePoolProviderOidcClientSecretValueToHclTerraform(struct?: GoogleIamWorkforcePoolProviderOidcClientSecretValueOutputReference | GoogleIamWorkforcePoolProviderOidcClientSecretValue): any;
export declare class GoogleIamWorkforcePoolProviderOidcClientSecretValueOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleIamWorkforcePoolProviderOidcClientSecretValue | undefined;
    set internalValue(value: GoogleIamWorkforcePoolProviderOidcClientSecretValue | undefined);
    private _plainText?;
    get plainText(): string;
    set plainText(value: string);
    get plainTextInput(): string | undefined;
    get thumbprint(): string;
}
export interface GoogleIamWorkforcePoolProviderOidcClientSecret {
    /**
    * value block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_iam_workforce_pool_provider#value GoogleIamWorkforcePoolProvider#value}
    */
    readonly value?: GoogleIamWorkforcePoolProviderOidcClientSecretValue;
}
export declare function googleIamWorkforcePoolProviderOidcClientSecretToTerraform(struct?: GoogleIamWorkforcePoolProviderOidcClientSecretOutputReference | GoogleIamWorkforcePoolProviderOidcClientSecret): any;
export declare function googleIamWorkforcePoolProviderOidcClientSecretToHclTerraform(struct?: GoogleIamWorkforcePoolProviderOidcClientSecretOutputReference | GoogleIamWorkforcePoolProviderOidcClientSecret): any;
export declare class GoogleIamWorkforcePoolProviderOidcClientSecretOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleIamWorkforcePoolProviderOidcClientSecret | undefined;
    set internalValue(value: GoogleIamWorkforcePoolProviderOidcClientSecret | undefined);
    private _value;
    get value(): GoogleIamWorkforcePoolProviderOidcClientSecretValueOutputReference;
    putValue(value: GoogleIamWorkforcePoolProviderOidcClientSecretValue): void;
    resetValue(): void;
    get valueInput(): GoogleIamWorkforcePoolProviderOidcClientSecretValue | undefined;
}
export interface GoogleIamWorkforcePoolProviderOidcWebSsoConfig {
    /**
    * Additional scopes to request for in the OIDC authentication request on top of scopes requested by default. By default, the 'openid', 'profile' and 'email' scopes that are supported by the identity provider are requested.
    * Each additional scope may be at most 256 characters. A maximum of 10 additional scopes may be configured.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_iam_workforce_pool_provider#additional_scopes GoogleIamWorkforcePoolProvider#additional_scopes}
    */
    readonly additionalScopes?: string[];
    /**
    * The behavior for how OIDC Claims are included in the 'assertion' object used for attribute mapping and attribute condition.
    * * MERGE_USER_INFO_OVER_ID_TOKEN_CLAIMS: Merge the UserInfo Endpoint Claims with ID Token Claims, preferring UserInfo Claim Values for the same Claim Name. This option is available only for the Authorization Code Flow.
    * * ONLY_ID_TOKEN_CLAIMS: Only include ID Token Claims. Possible values: ["MERGE_USER_INFO_OVER_ID_TOKEN_CLAIMS", "ONLY_ID_TOKEN_CLAIMS"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_iam_workforce_pool_provider#assertion_claims_behavior GoogleIamWorkforcePoolProvider#assertion_claims_behavior}
    */
    readonly assertionClaimsBehavior: string;
    /**
    * The Response Type to request for in the OIDC Authorization Request for web sign-in.
    *
    * The 'CODE' Response Type is recommended to avoid the Implicit Flow, for security reasons.
    * * CODE: The 'response_type=code' selection uses the Authorization Code Flow for web sign-in. Requires a configured client secret.
    * * ID_TOKEN: The 'response_type=id_token' selection uses the Implicit Flow for web sign-in. Possible values: ["CODE", "ID_TOKEN"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_iam_workforce_pool_provider#response_type GoogleIamWorkforcePoolProvider#response_type}
    */
    readonly responseType: string;
}
export declare function googleIamWorkforcePoolProviderOidcWebSsoConfigToTerraform(struct?: GoogleIamWorkforcePoolProviderOidcWebSsoConfigOutputReference | GoogleIamWorkforcePoolProviderOidcWebSsoConfig): any;
export declare function googleIamWorkforcePoolProviderOidcWebSsoConfigToHclTerraform(struct?: GoogleIamWorkforcePoolProviderOidcWebSsoConfigOutputReference | GoogleIamWorkforcePoolProviderOidcWebSsoConfig): any;
export declare class GoogleIamWorkforcePoolProviderOidcWebSsoConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleIamWorkforcePoolProviderOidcWebSsoConfig | undefined;
    set internalValue(value: GoogleIamWorkforcePoolProviderOidcWebSsoConfig | undefined);
    private _additionalScopes?;
    get additionalScopes(): string[];
    set additionalScopes(value: string[]);
    resetAdditionalScopes(): void;
    get additionalScopesInput(): string[] | undefined;
    private _assertionClaimsBehavior?;
    get assertionClaimsBehavior(): string;
    set assertionClaimsBehavior(value: string);
    get assertionClaimsBehaviorInput(): string | undefined;
    private _responseType?;
    get responseType(): string;
    set responseType(value: string);
    get responseTypeInput(): string | undefined;
}
export interface GoogleIamWorkforcePoolProviderOidc {
    /**
    * The client ID. Must match the audience claim of the JWT issued by the identity provider.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_iam_workforce_pool_provider#client_id GoogleIamWorkforcePoolProvider#client_id}
    */
    readonly clientId: string;
    /**
    * The OIDC issuer URI. Must be a valid URI using the 'https' scheme.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_iam_workforce_pool_provider#issuer_uri GoogleIamWorkforcePoolProvider#issuer_uri}
    */
    readonly issuerUri: string;
    /**
    * OIDC JWKs in JSON String format. For details on definition of a
    * JWK, see https:tools.ietf.org/html/rfc7517. If not set, then we
    * use the 'jwks_uri' from the discovery document fetched from the
    * .well-known path for the 'issuer_uri'. Currently, RSA and EC asymmetric
    * keys are supported. The JWK must use following format and include only
    * the following fields:
    * ```
    * {
    *   "keys": [
    *     {
    *           "kty": "RSA/EC",
    *           "alg": "<algorithm>",
    *           "use": "sig",
    *           "kid": "<key-id>",
    *           "n": "",
    *           "e": "",
    *           "x": "",
    *           "y": "",
    *           "crv": ""
    *     }
    *   ]
    * }
    * ```
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_iam_workforce_pool_provider#jwks_json GoogleIamWorkforcePoolProvider#jwks_json}
    */
    readonly jwksJson?: string;
    /**
    * client_secret block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_iam_workforce_pool_provider#client_secret GoogleIamWorkforcePoolProvider#client_secret}
    */
    readonly clientSecret?: GoogleIamWorkforcePoolProviderOidcClientSecret;
    /**
    * web_sso_config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_iam_workforce_pool_provider#web_sso_config GoogleIamWorkforcePoolProvider#web_sso_config}
    */
    readonly webSsoConfig?: GoogleIamWorkforcePoolProviderOidcWebSsoConfig;
}
export declare function googleIamWorkforcePoolProviderOidcToTerraform(struct?: GoogleIamWorkforcePoolProviderOidcOutputReference | GoogleIamWorkforcePoolProviderOidc): any;
export declare function googleIamWorkforcePoolProviderOidcToHclTerraform(struct?: GoogleIamWorkforcePoolProviderOidcOutputReference | GoogleIamWorkforcePoolProviderOidc): any;
export declare class GoogleIamWorkforcePoolProviderOidcOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleIamWorkforcePoolProviderOidc | undefined;
    set internalValue(value: GoogleIamWorkforcePoolProviderOidc | undefined);
    private _clientId?;
    get clientId(): string;
    set clientId(value: string);
    get clientIdInput(): string | undefined;
    private _issuerUri?;
    get issuerUri(): string;
    set issuerUri(value: string);
    get issuerUriInput(): string | undefined;
    private _jwksJson?;
    get jwksJson(): string;
    set jwksJson(value: string);
    resetJwksJson(): void;
    get jwksJsonInput(): string | undefined;
    private _clientSecret;
    get clientSecret(): GoogleIamWorkforcePoolProviderOidcClientSecretOutputReference;
    putClientSecret(value: GoogleIamWorkforcePoolProviderOidcClientSecret): void;
    resetClientSecret(): void;
    get clientSecretInput(): GoogleIamWorkforcePoolProviderOidcClientSecret | undefined;
    private _webSsoConfig;
    get webSsoConfig(): GoogleIamWorkforcePoolProviderOidcWebSsoConfigOutputReference;
    putWebSsoConfig(value: GoogleIamWorkforcePoolProviderOidcWebSsoConfig): void;
    resetWebSsoConfig(): void;
    get webSsoConfigInput(): GoogleIamWorkforcePoolProviderOidcWebSsoConfig | undefined;
}
export interface GoogleIamWorkforcePoolProviderSaml {
    /**
    * SAML Identity provider configuration metadata xml doc.
    * The xml document should comply with [SAML 2.0 specification](https://docs.oasis-open.org/security/saml/v2.0/saml-metadata-2.0-os.pdf).
    * The max size of the acceptable xml document will be bounded to 128k characters.
    *
    * The metadata xml document should satisfy the following constraints:
    * 1) Must contain an Identity Provider Entity ID.
    * 2) Must contain at least one non-expired signing key certificate.
    * 3) For each signing key:
    *   a) Valid from should be no more than 7 days from now.
    *   b) Valid to should be no more than 10 years in the future.
    * 4) Up to 3 IdP signing keys are allowed in the metadata xml.
    *
    * When updating the provider's metadata xml, at least one non-expired signing key
    * must overlap with the existing metadata. This requirement is skipped if there are
    * no non-expired signing keys present in the existing metadata.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_iam_workforce_pool_provider#idp_metadata_xml GoogleIamWorkforcePoolProvider#idp_metadata_xml}
    */
    readonly idpMetadataXml: string;
}
export declare function googleIamWorkforcePoolProviderSamlToTerraform(struct?: GoogleIamWorkforcePoolProviderSamlOutputReference | GoogleIamWorkforcePoolProviderSaml): any;
export declare function googleIamWorkforcePoolProviderSamlToHclTerraform(struct?: GoogleIamWorkforcePoolProviderSamlOutputReference | GoogleIamWorkforcePoolProviderSaml): any;
export declare class GoogleIamWorkforcePoolProviderSamlOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleIamWorkforcePoolProviderSaml | undefined;
    set internalValue(value: GoogleIamWorkforcePoolProviderSaml | undefined);
    private _idpMetadataXml?;
    get idpMetadataXml(): string;
    set idpMetadataXml(value: string);
    get idpMetadataXmlInput(): string | undefined;
}
export interface GoogleIamWorkforcePoolProviderTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_iam_workforce_pool_provider#create GoogleIamWorkforcePoolProvider#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_iam_workforce_pool_provider#delete GoogleIamWorkforcePoolProvider#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_iam_workforce_pool_provider#update GoogleIamWorkforcePoolProvider#update}
    */
    readonly update?: string;
}
export declare function googleIamWorkforcePoolProviderTimeoutsToTerraform(struct?: GoogleIamWorkforcePoolProviderTimeouts | cdktf.IResolvable): any;
export declare function googleIamWorkforcePoolProviderTimeoutsToHclTerraform(struct?: GoogleIamWorkforcePoolProviderTimeouts | cdktf.IResolvable): any;
export declare class GoogleIamWorkforcePoolProviderTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleIamWorkforcePoolProviderTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleIamWorkforcePoolProviderTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_iam_workforce_pool_provider google_iam_workforce_pool_provider}
*/
export declare class GoogleIamWorkforcePoolProvider extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_iam_workforce_pool_provider";
    /**
    * Generates CDKTF code for importing a GoogleIamWorkforcePoolProvider resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the GoogleIamWorkforcePoolProvider to import
    * @param importFromId The id of the existing GoogleIamWorkforcePoolProvider that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_iam_workforce_pool_provider#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the GoogleIamWorkforcePoolProvider to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_iam_workforce_pool_provider google_iam_workforce_pool_provider} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleIamWorkforcePoolProviderConfig
    */
    constructor(scope: Construct, id: string, config: GoogleIamWorkforcePoolProviderConfig);
    private _attributeCondition?;
    get attributeCondition(): string;
    set attributeCondition(value: string);
    resetAttributeCondition(): void;
    get attributeConditionInput(): string | undefined;
    private _attributeMapping?;
    get attributeMapping(): {
        [key: string]: string;
    };
    set attributeMapping(value: {
        [key: string]: string;
    });
    resetAttributeMapping(): void;
    get attributeMappingInput(): {
        [key: string]: string;
    } | undefined;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _disabled?;
    get disabled(): boolean | cdktf.IResolvable;
    set disabled(value: boolean | cdktf.IResolvable);
    resetDisabled(): void;
    get disabledInput(): boolean | cdktf.IResolvable | undefined;
    private _displayName?;
    get displayName(): string;
    set displayName(value: string);
    resetDisplayName(): void;
    get displayNameInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    get name(): string;
    private _providerId?;
    get providerId(): string;
    set providerId(value: string);
    get providerIdInput(): string | undefined;
    get state(): string;
    private _workforcePoolId?;
    get workforcePoolId(): string;
    set workforcePoolId(value: string);
    get workforcePoolIdInput(): string | undefined;
    private _oidc;
    get oidc(): GoogleIamWorkforcePoolProviderOidcOutputReference;
    putOidc(value: GoogleIamWorkforcePoolProviderOidc): void;
    resetOidc(): void;
    get oidcInput(): GoogleIamWorkforcePoolProviderOidc | undefined;
    private _saml;
    get saml(): GoogleIamWorkforcePoolProviderSamlOutputReference;
    putSaml(value: GoogleIamWorkforcePoolProviderSaml): void;
    resetSaml(): void;
    get samlInput(): GoogleIamWorkforcePoolProviderSaml | undefined;
    private _timeouts;
    get timeouts(): GoogleIamWorkforcePoolProviderTimeoutsOutputReference;
    putTimeouts(value: GoogleIamWorkforcePoolProviderTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleIamWorkforcePoolProviderTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
