/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleIamWorkforcePoolConfig extends cdktf.TerraformMetaArguments {
    /**
    * A user-specified description of the pool. Cannot exceed 256 characters.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_iam_workforce_pool#description GoogleIamWorkforcePool#description}
    */
    readonly description?: string;
    /**
    * Whether the pool is disabled. You cannot use a disabled pool to exchange tokens,
    * or use existing tokens to access resources. If the pool is re-enabled, existing tokens grant access again.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_iam_workforce_pool#disabled GoogleIamWorkforcePool#disabled}
    */
    readonly disabled?: boolean | cdktf.IResolvable;
    /**
    * A user-specified display name of the pool in Google Cloud Console. Cannot exceed 32 characters.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_iam_workforce_pool#display_name GoogleIamWorkforcePool#display_name}
    */
    readonly displayName?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_iam_workforce_pool#id GoogleIamWorkforcePool#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The location for the resource.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_iam_workforce_pool#location GoogleIamWorkforcePool#location}
    */
    readonly location: string;
    /**
    * Immutable. The resource name of the parent. Format: 'organizations/{org-id}'.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_iam_workforce_pool#parent GoogleIamWorkforcePool#parent}
    */
    readonly parent: string;
    /**
    * Duration that the Google Cloud access tokens, console sign-in sessions,
    * and 'gcloud' sign-in sessions from this pool are valid.
    * Must be greater than 15 minutes (900s) and less than 12 hours (43200s).
    * If 'sessionDuration' is not configured, minted credentials have a default duration of one hour (3600s).
    * A duration in seconds with up to nine fractional digits, ending with ''s''. Example: "'3.5s'".
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_iam_workforce_pool#session_duration GoogleIamWorkforcePool#session_duration}
    */
    readonly sessionDuration?: string;
    /**
    * The name of the pool. The ID must be a globally unique string of 6 to 63 lowercase letters,
    * digits, or hyphens. It must start with a letter, and cannot have a trailing hyphen.
    * The prefix 'gcp-' is reserved for use by Google, and may not be specified.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_iam_workforce_pool#workforce_pool_id GoogleIamWorkforcePool#workforce_pool_id}
    */
    readonly workforcePoolId: string;
    /**
    * access_restrictions block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_iam_workforce_pool#access_restrictions GoogleIamWorkforcePool#access_restrictions}
    */
    readonly accessRestrictions?: GoogleIamWorkforcePoolAccessRestrictions;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_iam_workforce_pool#timeouts GoogleIamWorkforcePool#timeouts}
    */
    readonly timeouts?: GoogleIamWorkforcePoolTimeouts;
}
export interface GoogleIamWorkforcePoolAccessRestrictionsAllowedServices {
    /**
    * Domain name of the service.
    * Example: console.cloud.google
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_iam_workforce_pool#domain GoogleIamWorkforcePool#domain}
    */
    readonly domain?: string;
}
export declare function googleIamWorkforcePoolAccessRestrictionsAllowedServicesToTerraform(struct?: GoogleIamWorkforcePoolAccessRestrictionsAllowedServices | cdktf.IResolvable): any;
export declare function googleIamWorkforcePoolAccessRestrictionsAllowedServicesToHclTerraform(struct?: GoogleIamWorkforcePoolAccessRestrictionsAllowedServices | cdktf.IResolvable): any;
export declare class GoogleIamWorkforcePoolAccessRestrictionsAllowedServicesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleIamWorkforcePoolAccessRestrictionsAllowedServices | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleIamWorkforcePoolAccessRestrictionsAllowedServices | cdktf.IResolvable | undefined);
    private _domain?;
    get domain(): string;
    set domain(value: string);
    resetDomain(): void;
    get domainInput(): string | undefined;
}
export declare class GoogleIamWorkforcePoolAccessRestrictionsAllowedServicesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleIamWorkforcePoolAccessRestrictionsAllowedServices[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleIamWorkforcePoolAccessRestrictionsAllowedServicesOutputReference;
}
export interface GoogleIamWorkforcePoolAccessRestrictions {
    /**
    * Disable programmatic sign-in by disabling token issue via the Security Token API endpoint.
    * See [Security Token Service API](https://cloud.google.com/iam/docs/reference/sts/rest).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_iam_workforce_pool#disable_programmatic_signin GoogleIamWorkforcePool#disable_programmatic_signin}
    */
    readonly disableProgrammaticSignin?: boolean | cdktf.IResolvable;
    /**
    * allowed_services block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_iam_workforce_pool#allowed_services GoogleIamWorkforcePool#allowed_services}
    */
    readonly allowedServices?: GoogleIamWorkforcePoolAccessRestrictionsAllowedServices[] | cdktf.IResolvable;
}
export declare function googleIamWorkforcePoolAccessRestrictionsToTerraform(struct?: GoogleIamWorkforcePoolAccessRestrictionsOutputReference | GoogleIamWorkforcePoolAccessRestrictions): any;
export declare function googleIamWorkforcePoolAccessRestrictionsToHclTerraform(struct?: GoogleIamWorkforcePoolAccessRestrictionsOutputReference | GoogleIamWorkforcePoolAccessRestrictions): any;
export declare class GoogleIamWorkforcePoolAccessRestrictionsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleIamWorkforcePoolAccessRestrictions | undefined;
    set internalValue(value: GoogleIamWorkforcePoolAccessRestrictions | undefined);
    private _disableProgrammaticSignin?;
    get disableProgrammaticSignin(): boolean | cdktf.IResolvable;
    set disableProgrammaticSignin(value: boolean | cdktf.IResolvable);
    resetDisableProgrammaticSignin(): void;
    get disableProgrammaticSigninInput(): boolean | cdktf.IResolvable | undefined;
    private _allowedServices;
    get allowedServices(): GoogleIamWorkforcePoolAccessRestrictionsAllowedServicesList;
    putAllowedServices(value: GoogleIamWorkforcePoolAccessRestrictionsAllowedServices[] | cdktf.IResolvable): void;
    resetAllowedServices(): void;
    get allowedServicesInput(): cdktf.IResolvable | GoogleIamWorkforcePoolAccessRestrictionsAllowedServices[] | undefined;
}
export interface GoogleIamWorkforcePoolTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_iam_workforce_pool#create GoogleIamWorkforcePool#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_iam_workforce_pool#delete GoogleIamWorkforcePool#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_iam_workforce_pool#update GoogleIamWorkforcePool#update}
    */
    readonly update?: string;
}
export declare function googleIamWorkforcePoolTimeoutsToTerraform(struct?: GoogleIamWorkforcePoolTimeouts | cdktf.IResolvable): any;
export declare function googleIamWorkforcePoolTimeoutsToHclTerraform(struct?: GoogleIamWorkforcePoolTimeouts | cdktf.IResolvable): any;
export declare class GoogleIamWorkforcePoolTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleIamWorkforcePoolTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleIamWorkforcePoolTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_iam_workforce_pool google_iam_workforce_pool}
*/
export declare class GoogleIamWorkforcePool extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_iam_workforce_pool";
    /**
    * Generates CDKTF code for importing a GoogleIamWorkforcePool resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the GoogleIamWorkforcePool to import
    * @param importFromId The id of the existing GoogleIamWorkforcePool that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_iam_workforce_pool#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the GoogleIamWorkforcePool to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_iam_workforce_pool google_iam_workforce_pool} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleIamWorkforcePoolConfig
    */
    constructor(scope: Construct, id: string, config: GoogleIamWorkforcePoolConfig);
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _disabled?;
    get disabled(): boolean | cdktf.IResolvable;
    set disabled(value: boolean | cdktf.IResolvable);
    resetDisabled(): void;
    get disabledInput(): boolean | cdktf.IResolvable | undefined;
    private _displayName?;
    get displayName(): string;
    set displayName(value: string);
    resetDisplayName(): void;
    get displayNameInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    get name(): string;
    private _parent?;
    get parent(): string;
    set parent(value: string);
    get parentInput(): string | undefined;
    private _sessionDuration?;
    get sessionDuration(): string;
    set sessionDuration(value: string);
    resetSessionDuration(): void;
    get sessionDurationInput(): string | undefined;
    get state(): string;
    private _workforcePoolId?;
    get workforcePoolId(): string;
    set workforcePoolId(value: string);
    get workforcePoolIdInput(): string | undefined;
    private _accessRestrictions;
    get accessRestrictions(): GoogleIamWorkforcePoolAccessRestrictionsOutputReference;
    putAccessRestrictions(value: GoogleIamWorkforcePoolAccessRestrictions): void;
    resetAccessRestrictions(): void;
    get accessRestrictionsInput(): GoogleIamWorkforcePoolAccessRestrictions | undefined;
    private _timeouts;
    get timeouts(): GoogleIamWorkforcePoolTimeoutsOutputReference;
    putTimeouts(value: GoogleIamWorkforcePoolTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleIamWorkforcePoolTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
