/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleIapBrandConfig extends cdktf.TerraformMetaArguments {
    /**
    * Application name displayed on OAuth consent screen.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_iap_brand#application_title GoogleIapBrand#application_title}
    */
    readonly applicationTitle: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_iap_brand#id GoogleIapBrand#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_iap_brand#project GoogleIapBrand#project}
    */
    readonly project?: string;
    /**
    * Support email displayed on the OAuth consent screen. Can be either a
    * user or group email. When a user email is specified, the caller must
    * be the user with the associated email address. When a group email is
    * specified, the caller can be either a user or a service account which
    * is an owner of the specified group in Cloud Identity.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_iap_brand#support_email GoogleIapBrand#support_email}
    */
    readonly supportEmail: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_iap_brand#timeouts GoogleIapBrand#timeouts}
    */
    readonly timeouts?: GoogleIapBrandTimeouts;
}
export interface GoogleIapBrandTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_iap_brand#create GoogleIapBrand#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_iap_brand#delete GoogleIapBrand#delete}
    */
    readonly delete?: string;
}
export declare function googleIapBrandTimeoutsToTerraform(struct?: GoogleIapBrandTimeouts | cdktf.IResolvable): any;
export declare function googleIapBrandTimeoutsToHclTerraform(struct?: GoogleIapBrandTimeouts | cdktf.IResolvable): any;
export declare class GoogleIapBrandTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleIapBrandTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleIapBrandTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_iap_brand google_iap_brand}
*/
export declare class GoogleIapBrand extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_iap_brand";
    /**
    * Generates CDKTF code for importing a GoogleIapBrand resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the GoogleIapBrand to import
    * @param importFromId The id of the existing GoogleIapBrand that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_iap_brand#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the GoogleIapBrand to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_iap_brand google_iap_brand} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleIapBrandConfig
    */
    constructor(scope: Construct, id: string, config: GoogleIapBrandConfig);
    private _applicationTitle?;
    get applicationTitle(): string;
    set applicationTitle(value: string);
    get applicationTitleInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get name(): string;
    get orgInternalOnly(): cdktf.IResolvable;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _supportEmail?;
    get supportEmail(): string;
    set supportEmail(value: string);
    get supportEmailInput(): string | undefined;
    private _timeouts;
    get timeouts(): GoogleIapBrandTimeoutsOutputReference;
    putTimeouts(value: GoogleIapBrandTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleIapBrandTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
