/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleIapTunnelDestGroupConfig extends cdktf.TerraformMetaArguments {
    /**
    * List of CIDRs that this group applies to.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_iap_tunnel_dest_group#cidrs GoogleIapTunnelDestGroup#cidrs}
    */
    readonly cidrs?: string[];
    /**
    * List of FQDNs that this group applies to.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_iap_tunnel_dest_group#fqdns GoogleIapTunnelDestGroup#fqdns}
    */
    readonly fqdns?: string[];
    /**
    * Unique tunnel destination group name.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_iap_tunnel_dest_group#group_name GoogleIapTunnelDestGroup#group_name}
    */
    readonly groupName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_iap_tunnel_dest_group#id GoogleIapTunnelDestGroup#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_iap_tunnel_dest_group#project GoogleIapTunnelDestGroup#project}
    */
    readonly project?: string;
    /**
    * The region of the tunnel group. Must be the same as the network resources in the group.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_iap_tunnel_dest_group#region GoogleIapTunnelDestGroup#region}
    */
    readonly region?: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_iap_tunnel_dest_group#timeouts GoogleIapTunnelDestGroup#timeouts}
    */
    readonly timeouts?: GoogleIapTunnelDestGroupTimeouts;
}
export interface GoogleIapTunnelDestGroupTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_iap_tunnel_dest_group#create GoogleIapTunnelDestGroup#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_iap_tunnel_dest_group#delete GoogleIapTunnelDestGroup#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_iap_tunnel_dest_group#update GoogleIapTunnelDestGroup#update}
    */
    readonly update?: string;
}
export declare function googleIapTunnelDestGroupTimeoutsToTerraform(struct?: GoogleIapTunnelDestGroupTimeouts | cdktf.IResolvable): any;
export declare function googleIapTunnelDestGroupTimeoutsToHclTerraform(struct?: GoogleIapTunnelDestGroupTimeouts | cdktf.IResolvable): any;
export declare class GoogleIapTunnelDestGroupTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleIapTunnelDestGroupTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleIapTunnelDestGroupTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_iap_tunnel_dest_group google_iap_tunnel_dest_group}
*/
export declare class GoogleIapTunnelDestGroup extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_iap_tunnel_dest_group";
    /**
    * Generates CDKTF code for importing a GoogleIapTunnelDestGroup resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the GoogleIapTunnelDestGroup to import
    * @param importFromId The id of the existing GoogleIapTunnelDestGroup that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_iap_tunnel_dest_group#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the GoogleIapTunnelDestGroup to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_iap_tunnel_dest_group google_iap_tunnel_dest_group} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleIapTunnelDestGroupConfig
    */
    constructor(scope: Construct, id: string, config: GoogleIapTunnelDestGroupConfig);
    private _cidrs?;
    get cidrs(): string[];
    set cidrs(value: string[]);
    resetCidrs(): void;
    get cidrsInput(): string[] | undefined;
    private _fqdns?;
    get fqdns(): string[];
    set fqdns(value: string[]);
    resetFqdns(): void;
    get fqdnsInput(): string[] | undefined;
    private _groupName?;
    get groupName(): string;
    set groupName(value: string);
    get groupNameInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get name(): string;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _region?;
    get region(): string;
    set region(value: string);
    resetRegion(): void;
    get regionInput(): string | undefined;
    private _timeouts;
    get timeouts(): GoogleIapTunnelDestGroupTimeoutsOutputReference;
    putTimeouts(value: GoogleIapTunnelDestGroupTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleIapTunnelDestGroupTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
