/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleIdentityPlatformConfigConfig extends cdktf.TerraformMetaArguments {
    /**
    * List of domains authorized for OAuth redirects.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_identity_platform_config#authorized_domains GoogleIdentityPlatformConfig#authorized_domains}
    */
    readonly authorizedDomains?: string[];
    /**
    * Whether anonymous users will be auto-deleted after a period of 30 days
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_identity_platform_config#autodelete_anonymous_users GoogleIdentityPlatformConfig#autodelete_anonymous_users}
    */
    readonly autodeleteAnonymousUsers?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_identity_platform_config#id GoogleIdentityPlatformConfig#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_identity_platform_config#project GoogleIdentityPlatformConfig#project}
    */
    readonly project?: string;
    /**
    * blocking_functions block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_identity_platform_config#blocking_functions GoogleIdentityPlatformConfig#blocking_functions}
    */
    readonly blockingFunctions?: GoogleIdentityPlatformConfigBlockingFunctions;
    /**
    * client block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_identity_platform_config#client GoogleIdentityPlatformConfig#client}
    */
    readonly client?: GoogleIdentityPlatformConfigClient;
    /**
    * mfa block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_identity_platform_config#mfa GoogleIdentityPlatformConfig#mfa}
    */
    readonly mfa?: GoogleIdentityPlatformConfigMfa;
    /**
    * monitoring block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_identity_platform_config#monitoring GoogleIdentityPlatformConfig#monitoring}
    */
    readonly monitoring?: GoogleIdentityPlatformConfigMonitoring;
    /**
    * multi_tenant block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_identity_platform_config#multi_tenant GoogleIdentityPlatformConfig#multi_tenant}
    */
    readonly multiTenant?: GoogleIdentityPlatformConfigMultiTenant;
    /**
    * quota block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_identity_platform_config#quota GoogleIdentityPlatformConfig#quota}
    */
    readonly quota?: GoogleIdentityPlatformConfigQuota;
    /**
    * sign_in block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_identity_platform_config#sign_in GoogleIdentityPlatformConfig#sign_in}
    */
    readonly signIn?: GoogleIdentityPlatformConfigSignIn;
    /**
    * sms_region_config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_identity_platform_config#sms_region_config GoogleIdentityPlatformConfig#sms_region_config}
    */
    readonly smsRegionConfig?: GoogleIdentityPlatformConfigSmsRegionConfig;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_identity_platform_config#timeouts GoogleIdentityPlatformConfig#timeouts}
    */
    readonly timeouts?: GoogleIdentityPlatformConfigTimeouts;
}
export interface GoogleIdentityPlatformConfigBlockingFunctionsForwardInboundCredentials {
    /**
    * Whether to pass the user's OAuth identity provider's access token.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_identity_platform_config#access_token GoogleIdentityPlatformConfig#access_token}
    */
    readonly accessToken?: boolean | cdktf.IResolvable;
    /**
    * Whether to pass the user's OIDC identity provider's ID token.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_identity_platform_config#id_token GoogleIdentityPlatformConfig#id_token}
    */
    readonly idToken?: boolean | cdktf.IResolvable;
    /**
    * Whether to pass the user's OAuth identity provider's refresh token.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_identity_platform_config#refresh_token GoogleIdentityPlatformConfig#refresh_token}
    */
    readonly refreshToken?: boolean | cdktf.IResolvable;
}
export declare function googleIdentityPlatformConfigBlockingFunctionsForwardInboundCredentialsToTerraform(struct?: GoogleIdentityPlatformConfigBlockingFunctionsForwardInboundCredentialsOutputReference | GoogleIdentityPlatformConfigBlockingFunctionsForwardInboundCredentials): any;
export declare function googleIdentityPlatformConfigBlockingFunctionsForwardInboundCredentialsToHclTerraform(struct?: GoogleIdentityPlatformConfigBlockingFunctionsForwardInboundCredentialsOutputReference | GoogleIdentityPlatformConfigBlockingFunctionsForwardInboundCredentials): any;
export declare class GoogleIdentityPlatformConfigBlockingFunctionsForwardInboundCredentialsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleIdentityPlatformConfigBlockingFunctionsForwardInboundCredentials | undefined;
    set internalValue(value: GoogleIdentityPlatformConfigBlockingFunctionsForwardInboundCredentials | undefined);
    private _accessToken?;
    get accessToken(): boolean | cdktf.IResolvable;
    set accessToken(value: boolean | cdktf.IResolvable);
    resetAccessToken(): void;
    get accessTokenInput(): boolean | cdktf.IResolvable | undefined;
    private _idToken?;
    get idToken(): boolean | cdktf.IResolvable;
    set idToken(value: boolean | cdktf.IResolvable);
    resetIdToken(): void;
    get idTokenInput(): boolean | cdktf.IResolvable | undefined;
    private _refreshToken?;
    get refreshToken(): boolean | cdktf.IResolvable;
    set refreshToken(value: boolean | cdktf.IResolvable);
    resetRefreshToken(): void;
    get refreshTokenInput(): boolean | cdktf.IResolvable | undefined;
}
export interface GoogleIdentityPlatformConfigBlockingFunctionsTriggers {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_identity_platform_config#event_type GoogleIdentityPlatformConfig#event_type}
    */
    readonly eventType: string;
    /**
    * HTTP URI trigger for the Cloud Function.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_identity_platform_config#function_uri GoogleIdentityPlatformConfig#function_uri}
    */
    readonly functionUri: string;
}
export declare function googleIdentityPlatformConfigBlockingFunctionsTriggersToTerraform(struct?: GoogleIdentityPlatformConfigBlockingFunctionsTriggers | cdktf.IResolvable): any;
export declare function googleIdentityPlatformConfigBlockingFunctionsTriggersToHclTerraform(struct?: GoogleIdentityPlatformConfigBlockingFunctionsTriggers | cdktf.IResolvable): any;
export declare class GoogleIdentityPlatformConfigBlockingFunctionsTriggersOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleIdentityPlatformConfigBlockingFunctionsTriggers | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleIdentityPlatformConfigBlockingFunctionsTriggers | cdktf.IResolvable | undefined);
    private _eventType?;
    get eventType(): string;
    set eventType(value: string);
    get eventTypeInput(): string | undefined;
    private _functionUri?;
    get functionUri(): string;
    set functionUri(value: string);
    get functionUriInput(): string | undefined;
    get updateTime(): string;
}
export declare class GoogleIdentityPlatformConfigBlockingFunctionsTriggersList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleIdentityPlatformConfigBlockingFunctionsTriggers[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleIdentityPlatformConfigBlockingFunctionsTriggersOutputReference;
}
export interface GoogleIdentityPlatformConfigBlockingFunctions {
    /**
    * forward_inbound_credentials block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_identity_platform_config#forward_inbound_credentials GoogleIdentityPlatformConfig#forward_inbound_credentials}
    */
    readonly forwardInboundCredentials?: GoogleIdentityPlatformConfigBlockingFunctionsForwardInboundCredentials;
    /**
    * triggers block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_identity_platform_config#triggers GoogleIdentityPlatformConfig#triggers}
    */
    readonly triggers: GoogleIdentityPlatformConfigBlockingFunctionsTriggers[] | cdktf.IResolvable;
}
export declare function googleIdentityPlatformConfigBlockingFunctionsToTerraform(struct?: GoogleIdentityPlatformConfigBlockingFunctionsOutputReference | GoogleIdentityPlatformConfigBlockingFunctions): any;
export declare function googleIdentityPlatformConfigBlockingFunctionsToHclTerraform(struct?: GoogleIdentityPlatformConfigBlockingFunctionsOutputReference | GoogleIdentityPlatformConfigBlockingFunctions): any;
export declare class GoogleIdentityPlatformConfigBlockingFunctionsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleIdentityPlatformConfigBlockingFunctions | undefined;
    set internalValue(value: GoogleIdentityPlatformConfigBlockingFunctions | undefined);
    private _forwardInboundCredentials;
    get forwardInboundCredentials(): GoogleIdentityPlatformConfigBlockingFunctionsForwardInboundCredentialsOutputReference;
    putForwardInboundCredentials(value: GoogleIdentityPlatformConfigBlockingFunctionsForwardInboundCredentials): void;
    resetForwardInboundCredentials(): void;
    get forwardInboundCredentialsInput(): GoogleIdentityPlatformConfigBlockingFunctionsForwardInboundCredentials | undefined;
    private _triggers;
    get triggers(): GoogleIdentityPlatformConfigBlockingFunctionsTriggersList;
    putTriggers(value: GoogleIdentityPlatformConfigBlockingFunctionsTriggers[] | cdktf.IResolvable): void;
    get triggersInput(): cdktf.IResolvable | GoogleIdentityPlatformConfigBlockingFunctionsTriggers[] | undefined;
}
export interface GoogleIdentityPlatformConfigClientPermissions {
    /**
    * When true, end users cannot delete their account on the associated project through any of our API methods
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_identity_platform_config#disabled_user_deletion GoogleIdentityPlatformConfig#disabled_user_deletion}
    */
    readonly disabledUserDeletion?: boolean | cdktf.IResolvable;
    /**
    * When true, end users cannot sign up for a new account on the associated project through any of our API methods
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_identity_platform_config#disabled_user_signup GoogleIdentityPlatformConfig#disabled_user_signup}
    */
    readonly disabledUserSignup?: boolean | cdktf.IResolvable;
}
export declare function googleIdentityPlatformConfigClientPermissionsToTerraform(struct?: GoogleIdentityPlatformConfigClientPermissionsOutputReference | GoogleIdentityPlatformConfigClientPermissions): any;
export declare function googleIdentityPlatformConfigClientPermissionsToHclTerraform(struct?: GoogleIdentityPlatformConfigClientPermissionsOutputReference | GoogleIdentityPlatformConfigClientPermissions): any;
export declare class GoogleIdentityPlatformConfigClientPermissionsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleIdentityPlatformConfigClientPermissions | undefined;
    set internalValue(value: GoogleIdentityPlatformConfigClientPermissions | undefined);
    private _disabledUserDeletion?;
    get disabledUserDeletion(): boolean | cdktf.IResolvable;
    set disabledUserDeletion(value: boolean | cdktf.IResolvable);
    resetDisabledUserDeletion(): void;
    get disabledUserDeletionInput(): boolean | cdktf.IResolvable | undefined;
    private _disabledUserSignup?;
    get disabledUserSignup(): boolean | cdktf.IResolvable;
    set disabledUserSignup(value: boolean | cdktf.IResolvable);
    resetDisabledUserSignup(): void;
    get disabledUserSignupInput(): boolean | cdktf.IResolvable | undefined;
}
export interface GoogleIdentityPlatformConfigClient {
    /**
    * permissions block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_identity_platform_config#permissions GoogleIdentityPlatformConfig#permissions}
    */
    readonly permissions?: GoogleIdentityPlatformConfigClientPermissions;
}
export declare function googleIdentityPlatformConfigClientToTerraform(struct?: GoogleIdentityPlatformConfigClientOutputReference | GoogleIdentityPlatformConfigClient): any;
export declare function googleIdentityPlatformConfigClientToHclTerraform(struct?: GoogleIdentityPlatformConfigClientOutputReference | GoogleIdentityPlatformConfigClient): any;
export declare class GoogleIdentityPlatformConfigClientOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleIdentityPlatformConfigClient | undefined;
    set internalValue(value: GoogleIdentityPlatformConfigClient | undefined);
    get apiKey(): string;
    get firebaseSubdomain(): string;
    private _permissions;
    get permissions(): GoogleIdentityPlatformConfigClientPermissionsOutputReference;
    putPermissions(value: GoogleIdentityPlatformConfigClientPermissions): void;
    resetPermissions(): void;
    get permissionsInput(): GoogleIdentityPlatformConfigClientPermissions | undefined;
}
export interface GoogleIdentityPlatformConfigMfaProviderConfigsTotpProviderConfig {
    /**
    * The allowed number of adjacent intervals that will be used for verification to avoid clock skew.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_identity_platform_config#adjacent_intervals GoogleIdentityPlatformConfig#adjacent_intervals}
    */
    readonly adjacentIntervals?: number;
}
export declare function googleIdentityPlatformConfigMfaProviderConfigsTotpProviderConfigToTerraform(struct?: GoogleIdentityPlatformConfigMfaProviderConfigsTotpProviderConfigOutputReference | GoogleIdentityPlatformConfigMfaProviderConfigsTotpProviderConfig): any;
export declare function googleIdentityPlatformConfigMfaProviderConfigsTotpProviderConfigToHclTerraform(struct?: GoogleIdentityPlatformConfigMfaProviderConfigsTotpProviderConfigOutputReference | GoogleIdentityPlatformConfigMfaProviderConfigsTotpProviderConfig): any;
export declare class GoogleIdentityPlatformConfigMfaProviderConfigsTotpProviderConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleIdentityPlatformConfigMfaProviderConfigsTotpProviderConfig | undefined;
    set internalValue(value: GoogleIdentityPlatformConfigMfaProviderConfigsTotpProviderConfig | undefined);
    private _adjacentIntervals?;
    get adjacentIntervals(): number;
    set adjacentIntervals(value: number);
    resetAdjacentIntervals(): void;
    get adjacentIntervalsInput(): number | undefined;
}
export interface GoogleIdentityPlatformConfigMfaProviderConfigs {
    /**
    * Whether MultiFactor Authentication has been enabled for this project. Possible values: ["DISABLED", "ENABLED", "MANDATORY"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_identity_platform_config#state GoogleIdentityPlatformConfig#state}
    */
    readonly state?: string;
    /**
    * totp_provider_config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_identity_platform_config#totp_provider_config GoogleIdentityPlatformConfig#totp_provider_config}
    */
    readonly totpProviderConfig?: GoogleIdentityPlatformConfigMfaProviderConfigsTotpProviderConfig;
}
export declare function googleIdentityPlatformConfigMfaProviderConfigsToTerraform(struct?: GoogleIdentityPlatformConfigMfaProviderConfigs | cdktf.IResolvable): any;
export declare function googleIdentityPlatformConfigMfaProviderConfigsToHclTerraform(struct?: GoogleIdentityPlatformConfigMfaProviderConfigs | cdktf.IResolvable): any;
export declare class GoogleIdentityPlatformConfigMfaProviderConfigsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleIdentityPlatformConfigMfaProviderConfigs | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleIdentityPlatformConfigMfaProviderConfigs | cdktf.IResolvable | undefined);
    private _state?;
    get state(): string;
    set state(value: string);
    resetState(): void;
    get stateInput(): string | undefined;
    private _totpProviderConfig;
    get totpProviderConfig(): GoogleIdentityPlatformConfigMfaProviderConfigsTotpProviderConfigOutputReference;
    putTotpProviderConfig(value: GoogleIdentityPlatformConfigMfaProviderConfigsTotpProviderConfig): void;
    resetTotpProviderConfig(): void;
    get totpProviderConfigInput(): GoogleIdentityPlatformConfigMfaProviderConfigsTotpProviderConfig | undefined;
}
export declare class GoogleIdentityPlatformConfigMfaProviderConfigsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleIdentityPlatformConfigMfaProviderConfigs[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleIdentityPlatformConfigMfaProviderConfigsOutputReference;
}
export interface GoogleIdentityPlatformConfigMfa {
    /**
    * A list of usable second factors for this project. Possible values: ["PHONE_SMS"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_identity_platform_config#enabled_providers GoogleIdentityPlatformConfig#enabled_providers}
    */
    readonly enabledProviders?: string[];
    /**
    * Whether MultiFactor Authentication has been enabled for this project. Possible values: ["DISABLED", "ENABLED", "MANDATORY"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_identity_platform_config#state GoogleIdentityPlatformConfig#state}
    */
    readonly state?: string;
    /**
    * provider_configs block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_identity_platform_config#provider_configs GoogleIdentityPlatformConfig#provider_configs}
    */
    readonly providerConfigs?: GoogleIdentityPlatformConfigMfaProviderConfigs[] | cdktf.IResolvable;
}
export declare function googleIdentityPlatformConfigMfaToTerraform(struct?: GoogleIdentityPlatformConfigMfaOutputReference | GoogleIdentityPlatformConfigMfa): any;
export declare function googleIdentityPlatformConfigMfaToHclTerraform(struct?: GoogleIdentityPlatformConfigMfaOutputReference | GoogleIdentityPlatformConfigMfa): any;
export declare class GoogleIdentityPlatformConfigMfaOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleIdentityPlatformConfigMfa | undefined;
    set internalValue(value: GoogleIdentityPlatformConfigMfa | undefined);
    private _enabledProviders?;
    get enabledProviders(): string[];
    set enabledProviders(value: string[]);
    resetEnabledProviders(): void;
    get enabledProvidersInput(): string[] | undefined;
    private _state?;
    get state(): string;
    set state(value: string);
    resetState(): void;
    get stateInput(): string | undefined;
    private _providerConfigs;
    get providerConfigs(): GoogleIdentityPlatformConfigMfaProviderConfigsList;
    putProviderConfigs(value: GoogleIdentityPlatformConfigMfaProviderConfigs[] | cdktf.IResolvable): void;
    resetProviderConfigs(): void;
    get providerConfigsInput(): cdktf.IResolvable | GoogleIdentityPlatformConfigMfaProviderConfigs[] | undefined;
}
export interface GoogleIdentityPlatformConfigMonitoringRequestLogging {
    /**
    * Whether logging is enabled for this project or not.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_identity_platform_config#enabled GoogleIdentityPlatformConfig#enabled}
    */
    readonly enabled?: boolean | cdktf.IResolvable;
}
export declare function googleIdentityPlatformConfigMonitoringRequestLoggingToTerraform(struct?: GoogleIdentityPlatformConfigMonitoringRequestLoggingOutputReference | GoogleIdentityPlatformConfigMonitoringRequestLogging): any;
export declare function googleIdentityPlatformConfigMonitoringRequestLoggingToHclTerraform(struct?: GoogleIdentityPlatformConfigMonitoringRequestLoggingOutputReference | GoogleIdentityPlatformConfigMonitoringRequestLogging): any;
export declare class GoogleIdentityPlatformConfigMonitoringRequestLoggingOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleIdentityPlatformConfigMonitoringRequestLogging | undefined;
    set internalValue(value: GoogleIdentityPlatformConfigMonitoringRequestLogging | undefined);
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    resetEnabled(): void;
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
}
export interface GoogleIdentityPlatformConfigMonitoring {
    /**
    * request_logging block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_identity_platform_config#request_logging GoogleIdentityPlatformConfig#request_logging}
    */
    readonly requestLogging?: GoogleIdentityPlatformConfigMonitoringRequestLogging;
}
export declare function googleIdentityPlatformConfigMonitoringToTerraform(struct?: GoogleIdentityPlatformConfigMonitoringOutputReference | GoogleIdentityPlatformConfigMonitoring): any;
export declare function googleIdentityPlatformConfigMonitoringToHclTerraform(struct?: GoogleIdentityPlatformConfigMonitoringOutputReference | GoogleIdentityPlatformConfigMonitoring): any;
export declare class GoogleIdentityPlatformConfigMonitoringOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleIdentityPlatformConfigMonitoring | undefined;
    set internalValue(value: GoogleIdentityPlatformConfigMonitoring | undefined);
    private _requestLogging;
    get requestLogging(): GoogleIdentityPlatformConfigMonitoringRequestLoggingOutputReference;
    putRequestLogging(value: GoogleIdentityPlatformConfigMonitoringRequestLogging): void;
    resetRequestLogging(): void;
    get requestLoggingInput(): GoogleIdentityPlatformConfigMonitoringRequestLogging | undefined;
}
export interface GoogleIdentityPlatformConfigMultiTenant {
    /**
    * Whether this project can have tenants or not.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_identity_platform_config#allow_tenants GoogleIdentityPlatformConfig#allow_tenants}
    */
    readonly allowTenants?: boolean | cdktf.IResolvable;
    /**
    * The default cloud parent org or folder that the tenant project should be created under.
    * The parent resource name should be in the format of "/", such as "folders/123" or "organizations/456".
    * If the value is not set, the tenant will be created under the same organization or folder as the agent project.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_identity_platform_config#default_tenant_location GoogleIdentityPlatformConfig#default_tenant_location}
    */
    readonly defaultTenantLocation?: string;
}
export declare function googleIdentityPlatformConfigMultiTenantToTerraform(struct?: GoogleIdentityPlatformConfigMultiTenantOutputReference | GoogleIdentityPlatformConfigMultiTenant): any;
export declare function googleIdentityPlatformConfigMultiTenantToHclTerraform(struct?: GoogleIdentityPlatformConfigMultiTenantOutputReference | GoogleIdentityPlatformConfigMultiTenant): any;
export declare class GoogleIdentityPlatformConfigMultiTenantOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleIdentityPlatformConfigMultiTenant | undefined;
    set internalValue(value: GoogleIdentityPlatformConfigMultiTenant | undefined);
    private _allowTenants?;
    get allowTenants(): boolean | cdktf.IResolvable;
    set allowTenants(value: boolean | cdktf.IResolvable);
    resetAllowTenants(): void;
    get allowTenantsInput(): boolean | cdktf.IResolvable | undefined;
    private _defaultTenantLocation?;
    get defaultTenantLocation(): string;
    set defaultTenantLocation(value: string);
    resetDefaultTenantLocation(): void;
    get defaultTenantLocationInput(): string | undefined;
}
export interface GoogleIdentityPlatformConfigQuotaSignUpQuotaConfig {
    /**
    * A sign up APIs quota that customers can override temporarily.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_identity_platform_config#quota GoogleIdentityPlatformConfig#quota}
    */
    readonly quota?: number;
    /**
    * How long this quota will be active for. It is measurred in seconds, e.g., Example: "9.615s".
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_identity_platform_config#quota_duration GoogleIdentityPlatformConfig#quota_duration}
    */
    readonly quotaDuration?: string;
    /**
    * When this quota will take affect.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_identity_platform_config#start_time GoogleIdentityPlatformConfig#start_time}
    */
    readonly startTime?: string;
}
export declare function googleIdentityPlatformConfigQuotaSignUpQuotaConfigToTerraform(struct?: GoogleIdentityPlatformConfigQuotaSignUpQuotaConfigOutputReference | GoogleIdentityPlatformConfigQuotaSignUpQuotaConfig): any;
export declare function googleIdentityPlatformConfigQuotaSignUpQuotaConfigToHclTerraform(struct?: GoogleIdentityPlatformConfigQuotaSignUpQuotaConfigOutputReference | GoogleIdentityPlatformConfigQuotaSignUpQuotaConfig): any;
export declare class GoogleIdentityPlatformConfigQuotaSignUpQuotaConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleIdentityPlatformConfigQuotaSignUpQuotaConfig | undefined;
    set internalValue(value: GoogleIdentityPlatformConfigQuotaSignUpQuotaConfig | undefined);
    private _quota?;
    get quota(): number;
    set quota(value: number);
    resetQuota(): void;
    get quotaInput(): number | undefined;
    private _quotaDuration?;
    get quotaDuration(): string;
    set quotaDuration(value: string);
    resetQuotaDuration(): void;
    get quotaDurationInput(): string | undefined;
    private _startTime?;
    get startTime(): string;
    set startTime(value: string);
    resetStartTime(): void;
    get startTimeInput(): string | undefined;
}
export interface GoogleIdentityPlatformConfigQuota {
    /**
    * sign_up_quota_config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_identity_platform_config#sign_up_quota_config GoogleIdentityPlatformConfig#sign_up_quota_config}
    */
    readonly signUpQuotaConfig?: GoogleIdentityPlatformConfigQuotaSignUpQuotaConfig;
}
export declare function googleIdentityPlatformConfigQuotaToTerraform(struct?: GoogleIdentityPlatformConfigQuotaOutputReference | GoogleIdentityPlatformConfigQuota): any;
export declare function googleIdentityPlatformConfigQuotaToHclTerraform(struct?: GoogleIdentityPlatformConfigQuotaOutputReference | GoogleIdentityPlatformConfigQuota): any;
export declare class GoogleIdentityPlatformConfigQuotaOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleIdentityPlatformConfigQuota | undefined;
    set internalValue(value: GoogleIdentityPlatformConfigQuota | undefined);
    private _signUpQuotaConfig;
    get signUpQuotaConfig(): GoogleIdentityPlatformConfigQuotaSignUpQuotaConfigOutputReference;
    putSignUpQuotaConfig(value: GoogleIdentityPlatformConfigQuotaSignUpQuotaConfig): void;
    resetSignUpQuotaConfig(): void;
    get signUpQuotaConfigInput(): GoogleIdentityPlatformConfigQuotaSignUpQuotaConfig | undefined;
}
export interface GoogleIdentityPlatformConfigSignInHashConfig {
}
export declare function googleIdentityPlatformConfigSignInHashConfigToTerraform(struct?: GoogleIdentityPlatformConfigSignInHashConfig): any;
export declare function googleIdentityPlatformConfigSignInHashConfigToHclTerraform(struct?: GoogleIdentityPlatformConfigSignInHashConfig): any;
export declare class GoogleIdentityPlatformConfigSignInHashConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleIdentityPlatformConfigSignInHashConfig | undefined;
    set internalValue(value: GoogleIdentityPlatformConfigSignInHashConfig | undefined);
    get algorithm(): string;
    get memoryCost(): number;
    get rounds(): number;
    get saltSeparator(): string;
    get signerKey(): string;
}
export declare class GoogleIdentityPlatformConfigSignInHashConfigList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleIdentityPlatformConfigSignInHashConfigOutputReference;
}
export interface GoogleIdentityPlatformConfigSignInAnonymous {
    /**
    * Whether anonymous user auth is enabled for the project or not.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_identity_platform_config#enabled GoogleIdentityPlatformConfig#enabled}
    */
    readonly enabled: boolean | cdktf.IResolvable;
}
export declare function googleIdentityPlatformConfigSignInAnonymousToTerraform(struct?: GoogleIdentityPlatformConfigSignInAnonymousOutputReference | GoogleIdentityPlatformConfigSignInAnonymous): any;
export declare function googleIdentityPlatformConfigSignInAnonymousToHclTerraform(struct?: GoogleIdentityPlatformConfigSignInAnonymousOutputReference | GoogleIdentityPlatformConfigSignInAnonymous): any;
export declare class GoogleIdentityPlatformConfigSignInAnonymousOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleIdentityPlatformConfigSignInAnonymous | undefined;
    set internalValue(value: GoogleIdentityPlatformConfigSignInAnonymous | undefined);
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
}
export interface GoogleIdentityPlatformConfigSignInEmail {
    /**
    * Whether email auth is enabled for the project or not.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_identity_platform_config#enabled GoogleIdentityPlatformConfig#enabled}
    */
    readonly enabled: boolean | cdktf.IResolvable;
    /**
    * Whether a password is required for email auth or not. If true, both an email and
    * password must be provided to sign in. If false, a user may sign in via either
    * email/password or email link.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_identity_platform_config#password_required GoogleIdentityPlatformConfig#password_required}
    */
    readonly passwordRequired?: boolean | cdktf.IResolvable;
}
export declare function googleIdentityPlatformConfigSignInEmailToTerraform(struct?: GoogleIdentityPlatformConfigSignInEmailOutputReference | GoogleIdentityPlatformConfigSignInEmail): any;
export declare function googleIdentityPlatformConfigSignInEmailToHclTerraform(struct?: GoogleIdentityPlatformConfigSignInEmailOutputReference | GoogleIdentityPlatformConfigSignInEmail): any;
export declare class GoogleIdentityPlatformConfigSignInEmailOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleIdentityPlatformConfigSignInEmail | undefined;
    set internalValue(value: GoogleIdentityPlatformConfigSignInEmail | undefined);
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
    private _passwordRequired?;
    get passwordRequired(): boolean | cdktf.IResolvable;
    set passwordRequired(value: boolean | cdktf.IResolvable);
    resetPasswordRequired(): void;
    get passwordRequiredInput(): boolean | cdktf.IResolvable | undefined;
}
export interface GoogleIdentityPlatformConfigSignInPhoneNumber {
    /**
    * Whether phone number auth is enabled for the project or not.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_identity_platform_config#enabled GoogleIdentityPlatformConfig#enabled}
    */
    readonly enabled: boolean | cdktf.IResolvable;
    /**
    * A map of <test phone number, fake code> that can be used for phone auth testing.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_identity_platform_config#test_phone_numbers GoogleIdentityPlatformConfig#test_phone_numbers}
    */
    readonly testPhoneNumbers?: {
        [key: string]: string;
    };
}
export declare function googleIdentityPlatformConfigSignInPhoneNumberToTerraform(struct?: GoogleIdentityPlatformConfigSignInPhoneNumberOutputReference | GoogleIdentityPlatformConfigSignInPhoneNumber): any;
export declare function googleIdentityPlatformConfigSignInPhoneNumberToHclTerraform(struct?: GoogleIdentityPlatformConfigSignInPhoneNumberOutputReference | GoogleIdentityPlatformConfigSignInPhoneNumber): any;
export declare class GoogleIdentityPlatformConfigSignInPhoneNumberOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleIdentityPlatformConfigSignInPhoneNumber | undefined;
    set internalValue(value: GoogleIdentityPlatformConfigSignInPhoneNumber | undefined);
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
    private _testPhoneNumbers?;
    get testPhoneNumbers(): {
        [key: string]: string;
    };
    set testPhoneNumbers(value: {
        [key: string]: string;
    });
    resetTestPhoneNumbers(): void;
    get testPhoneNumbersInput(): {
        [key: string]: string;
    } | undefined;
}
export interface GoogleIdentityPlatformConfigSignIn {
    /**
    * Whether to allow more than one account to have the same email.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_identity_platform_config#allow_duplicate_emails GoogleIdentityPlatformConfig#allow_duplicate_emails}
    */
    readonly allowDuplicateEmails?: boolean | cdktf.IResolvable;
    /**
    * anonymous block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_identity_platform_config#anonymous GoogleIdentityPlatformConfig#anonymous}
    */
    readonly anonymous?: GoogleIdentityPlatformConfigSignInAnonymous;
    /**
    * email block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_identity_platform_config#email GoogleIdentityPlatformConfig#email}
    */
    readonly email?: GoogleIdentityPlatformConfigSignInEmail;
    /**
    * phone_number block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_identity_platform_config#phone_number GoogleIdentityPlatformConfig#phone_number}
    */
    readonly phoneNumber?: GoogleIdentityPlatformConfigSignInPhoneNumber;
}
export declare function googleIdentityPlatformConfigSignInToTerraform(struct?: GoogleIdentityPlatformConfigSignInOutputReference | GoogleIdentityPlatformConfigSignIn): any;
export declare function googleIdentityPlatformConfigSignInToHclTerraform(struct?: GoogleIdentityPlatformConfigSignInOutputReference | GoogleIdentityPlatformConfigSignIn): any;
export declare class GoogleIdentityPlatformConfigSignInOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleIdentityPlatformConfigSignIn | undefined;
    set internalValue(value: GoogleIdentityPlatformConfigSignIn | undefined);
    private _allowDuplicateEmails?;
    get allowDuplicateEmails(): boolean | cdktf.IResolvable;
    set allowDuplicateEmails(value: boolean | cdktf.IResolvable);
    resetAllowDuplicateEmails(): void;
    get allowDuplicateEmailsInput(): boolean | cdktf.IResolvable | undefined;
    private _hashConfig;
    get hashConfig(): GoogleIdentityPlatformConfigSignInHashConfigList;
    private _anonymous;
    get anonymous(): GoogleIdentityPlatformConfigSignInAnonymousOutputReference;
    putAnonymous(value: GoogleIdentityPlatformConfigSignInAnonymous): void;
    resetAnonymous(): void;
    get anonymousInput(): GoogleIdentityPlatformConfigSignInAnonymous | undefined;
    private _email;
    get email(): GoogleIdentityPlatformConfigSignInEmailOutputReference;
    putEmail(value: GoogleIdentityPlatformConfigSignInEmail): void;
    resetEmail(): void;
    get emailInput(): GoogleIdentityPlatformConfigSignInEmail | undefined;
    private _phoneNumber;
    get phoneNumber(): GoogleIdentityPlatformConfigSignInPhoneNumberOutputReference;
    putPhoneNumber(value: GoogleIdentityPlatformConfigSignInPhoneNumber): void;
    resetPhoneNumber(): void;
    get phoneNumberInput(): GoogleIdentityPlatformConfigSignInPhoneNumber | undefined;
}
export interface GoogleIdentityPlatformConfigSmsRegionConfigAllowByDefault {
    /**
    * Two letter unicode region codes to disallow as defined by https://cldr.unicode.org/ The full list of these region codes is here: https://github.com/unicode-cldr/cldr-localenames-full/blob/master/main/en/territories.json
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_identity_platform_config#disallowed_regions GoogleIdentityPlatformConfig#disallowed_regions}
    */
    readonly disallowedRegions?: string[];
}
export declare function googleIdentityPlatformConfigSmsRegionConfigAllowByDefaultToTerraform(struct?: GoogleIdentityPlatformConfigSmsRegionConfigAllowByDefaultOutputReference | GoogleIdentityPlatformConfigSmsRegionConfigAllowByDefault): any;
export declare function googleIdentityPlatformConfigSmsRegionConfigAllowByDefaultToHclTerraform(struct?: GoogleIdentityPlatformConfigSmsRegionConfigAllowByDefaultOutputReference | GoogleIdentityPlatformConfigSmsRegionConfigAllowByDefault): any;
export declare class GoogleIdentityPlatformConfigSmsRegionConfigAllowByDefaultOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleIdentityPlatformConfigSmsRegionConfigAllowByDefault | undefined;
    set internalValue(value: GoogleIdentityPlatformConfigSmsRegionConfigAllowByDefault | undefined);
    private _disallowedRegions?;
    get disallowedRegions(): string[];
    set disallowedRegions(value: string[]);
    resetDisallowedRegions(): void;
    get disallowedRegionsInput(): string[] | undefined;
}
export interface GoogleIdentityPlatformConfigSmsRegionConfigAllowlistOnly {
    /**
    * Two letter unicode region codes to allow as defined by https://cldr.unicode.org/ The full list of these region codes is here: https://github.com/unicode-cldr/cldr-localenames-full/blob/master/main/en/territories.json
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_identity_platform_config#allowed_regions GoogleIdentityPlatformConfig#allowed_regions}
    */
    readonly allowedRegions?: string[];
}
export declare function googleIdentityPlatformConfigSmsRegionConfigAllowlistOnlyToTerraform(struct?: GoogleIdentityPlatformConfigSmsRegionConfigAllowlistOnlyOutputReference | GoogleIdentityPlatformConfigSmsRegionConfigAllowlistOnly): any;
export declare function googleIdentityPlatformConfigSmsRegionConfigAllowlistOnlyToHclTerraform(struct?: GoogleIdentityPlatformConfigSmsRegionConfigAllowlistOnlyOutputReference | GoogleIdentityPlatformConfigSmsRegionConfigAllowlistOnly): any;
export declare class GoogleIdentityPlatformConfigSmsRegionConfigAllowlistOnlyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleIdentityPlatformConfigSmsRegionConfigAllowlistOnly | undefined;
    set internalValue(value: GoogleIdentityPlatformConfigSmsRegionConfigAllowlistOnly | undefined);
    private _allowedRegions?;
    get allowedRegions(): string[];
    set allowedRegions(value: string[]);
    resetAllowedRegions(): void;
    get allowedRegionsInput(): string[] | undefined;
}
export interface GoogleIdentityPlatformConfigSmsRegionConfig {
    /**
    * allow_by_default block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_identity_platform_config#allow_by_default GoogleIdentityPlatformConfig#allow_by_default}
    */
    readonly allowByDefault?: GoogleIdentityPlatformConfigSmsRegionConfigAllowByDefault;
    /**
    * allowlist_only block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_identity_platform_config#allowlist_only GoogleIdentityPlatformConfig#allowlist_only}
    */
    readonly allowlistOnly?: GoogleIdentityPlatformConfigSmsRegionConfigAllowlistOnly;
}
export declare function googleIdentityPlatformConfigSmsRegionConfigToTerraform(struct?: GoogleIdentityPlatformConfigSmsRegionConfigOutputReference | GoogleIdentityPlatformConfigSmsRegionConfig): any;
export declare function googleIdentityPlatformConfigSmsRegionConfigToHclTerraform(struct?: GoogleIdentityPlatformConfigSmsRegionConfigOutputReference | GoogleIdentityPlatformConfigSmsRegionConfig): any;
export declare class GoogleIdentityPlatformConfigSmsRegionConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleIdentityPlatformConfigSmsRegionConfig | undefined;
    set internalValue(value: GoogleIdentityPlatformConfigSmsRegionConfig | undefined);
    private _allowByDefault;
    get allowByDefault(): GoogleIdentityPlatformConfigSmsRegionConfigAllowByDefaultOutputReference;
    putAllowByDefault(value: GoogleIdentityPlatformConfigSmsRegionConfigAllowByDefault): void;
    resetAllowByDefault(): void;
    get allowByDefaultInput(): GoogleIdentityPlatformConfigSmsRegionConfigAllowByDefault | undefined;
    private _allowlistOnly;
    get allowlistOnly(): GoogleIdentityPlatformConfigSmsRegionConfigAllowlistOnlyOutputReference;
    putAllowlistOnly(value: GoogleIdentityPlatformConfigSmsRegionConfigAllowlistOnly): void;
    resetAllowlistOnly(): void;
    get allowlistOnlyInput(): GoogleIdentityPlatformConfigSmsRegionConfigAllowlistOnly | undefined;
}
export interface GoogleIdentityPlatformConfigTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_identity_platform_config#create GoogleIdentityPlatformConfig#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_identity_platform_config#delete GoogleIdentityPlatformConfig#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_identity_platform_config#update GoogleIdentityPlatformConfig#update}
    */
    readonly update?: string;
}
export declare function googleIdentityPlatformConfigTimeoutsToTerraform(struct?: GoogleIdentityPlatformConfigTimeouts | cdktf.IResolvable): any;
export declare function googleIdentityPlatformConfigTimeoutsToHclTerraform(struct?: GoogleIdentityPlatformConfigTimeouts | cdktf.IResolvable): any;
export declare class GoogleIdentityPlatformConfigTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleIdentityPlatformConfigTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleIdentityPlatformConfigTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_identity_platform_config google_identity_platform_config}
*/
export declare class GoogleIdentityPlatformConfig extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_identity_platform_config";
    /**
    * Generates CDKTF code for importing a GoogleIdentityPlatformConfig resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the GoogleIdentityPlatformConfig to import
    * @param importFromId The id of the existing GoogleIdentityPlatformConfig that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_identity_platform_config#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the GoogleIdentityPlatformConfig to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_identity_platform_config google_identity_platform_config} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleIdentityPlatformConfigConfig = {}
    */
    constructor(scope: Construct, id: string, config?: GoogleIdentityPlatformConfigConfig);
    private _authorizedDomains?;
    get authorizedDomains(): string[];
    set authorizedDomains(value: string[]);
    resetAuthorizedDomains(): void;
    get authorizedDomainsInput(): string[] | undefined;
    private _autodeleteAnonymousUsers?;
    get autodeleteAnonymousUsers(): boolean | cdktf.IResolvable;
    set autodeleteAnonymousUsers(value: boolean | cdktf.IResolvable);
    resetAutodeleteAnonymousUsers(): void;
    get autodeleteAnonymousUsersInput(): boolean | cdktf.IResolvable | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get name(): string;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _blockingFunctions;
    get blockingFunctions(): GoogleIdentityPlatformConfigBlockingFunctionsOutputReference;
    putBlockingFunctions(value: GoogleIdentityPlatformConfigBlockingFunctions): void;
    resetBlockingFunctions(): void;
    get blockingFunctionsInput(): GoogleIdentityPlatformConfigBlockingFunctions | undefined;
    private _client;
    get client(): GoogleIdentityPlatformConfigClientOutputReference;
    putClient(value: GoogleIdentityPlatformConfigClient): void;
    resetClient(): void;
    get clientInput(): GoogleIdentityPlatformConfigClient | undefined;
    private _mfa;
    get mfa(): GoogleIdentityPlatformConfigMfaOutputReference;
    putMfa(value: GoogleIdentityPlatformConfigMfa): void;
    resetMfa(): void;
    get mfaInput(): GoogleIdentityPlatformConfigMfa | undefined;
    private _monitoring;
    get monitoring(): GoogleIdentityPlatformConfigMonitoringOutputReference;
    putMonitoring(value: GoogleIdentityPlatformConfigMonitoring): void;
    resetMonitoring(): void;
    get monitoringInput(): GoogleIdentityPlatformConfigMonitoring | undefined;
    private _multiTenant;
    get multiTenant(): GoogleIdentityPlatformConfigMultiTenantOutputReference;
    putMultiTenant(value: GoogleIdentityPlatformConfigMultiTenant): void;
    resetMultiTenant(): void;
    get multiTenantInput(): GoogleIdentityPlatformConfigMultiTenant | undefined;
    private _quota;
    get quota(): GoogleIdentityPlatformConfigQuotaOutputReference;
    putQuota(value: GoogleIdentityPlatformConfigQuota): void;
    resetQuota(): void;
    get quotaInput(): GoogleIdentityPlatformConfigQuota | undefined;
    private _signIn;
    get signIn(): GoogleIdentityPlatformConfigSignInOutputReference;
    putSignIn(value: GoogleIdentityPlatformConfigSignIn): void;
    resetSignIn(): void;
    get signInInput(): GoogleIdentityPlatformConfigSignIn | undefined;
    private _smsRegionConfig;
    get smsRegionConfig(): GoogleIdentityPlatformConfigSmsRegionConfigOutputReference;
    putSmsRegionConfig(value: GoogleIdentityPlatformConfigSmsRegionConfig): void;
    resetSmsRegionConfig(): void;
    get smsRegionConfigInput(): GoogleIdentityPlatformConfigSmsRegionConfig | undefined;
    private _timeouts;
    get timeouts(): GoogleIdentityPlatformConfigTimeoutsOutputReference;
    putTimeouts(value: GoogleIdentityPlatformConfigTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleIdentityPlatformConfigTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
