/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleIdentityPlatformProjectDefaultConfigConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_identity_platform_project_default_config#id GoogleIdentityPlatformProjectDefaultConfig#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_identity_platform_project_default_config#project GoogleIdentityPlatformProjectDefaultConfig#project}
    */
    readonly project?: string;
    /**
    * sign_in block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_identity_platform_project_default_config#sign_in GoogleIdentityPlatformProjectDefaultConfig#sign_in}
    */
    readonly signIn?: GoogleIdentityPlatformProjectDefaultConfigSignIn;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_identity_platform_project_default_config#timeouts GoogleIdentityPlatformProjectDefaultConfig#timeouts}
    */
    readonly timeouts?: GoogleIdentityPlatformProjectDefaultConfigTimeouts;
}
export interface GoogleIdentityPlatformProjectDefaultConfigSignInHashConfig {
}
export declare function googleIdentityPlatformProjectDefaultConfigSignInHashConfigToTerraform(struct?: GoogleIdentityPlatformProjectDefaultConfigSignInHashConfig): any;
export declare function googleIdentityPlatformProjectDefaultConfigSignInHashConfigToHclTerraform(struct?: GoogleIdentityPlatformProjectDefaultConfigSignInHashConfig): any;
export declare class GoogleIdentityPlatformProjectDefaultConfigSignInHashConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleIdentityPlatformProjectDefaultConfigSignInHashConfig | undefined;
    set internalValue(value: GoogleIdentityPlatformProjectDefaultConfigSignInHashConfig | undefined);
    get algorithm(): string;
    get memoryCost(): number;
    get rounds(): number;
    get saltSeparator(): string;
    get signerKey(): string;
}
export declare class GoogleIdentityPlatformProjectDefaultConfigSignInHashConfigList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleIdentityPlatformProjectDefaultConfigSignInHashConfigOutputReference;
}
export interface GoogleIdentityPlatformProjectDefaultConfigSignInAnonymous {
    /**
    * Whether anonymous user auth is enabled for the project or not.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_identity_platform_project_default_config#enabled GoogleIdentityPlatformProjectDefaultConfig#enabled}
    */
    readonly enabled: boolean | cdktf.IResolvable;
}
export declare function googleIdentityPlatformProjectDefaultConfigSignInAnonymousToTerraform(struct?: GoogleIdentityPlatformProjectDefaultConfigSignInAnonymousOutputReference | GoogleIdentityPlatformProjectDefaultConfigSignInAnonymous): any;
export declare function googleIdentityPlatformProjectDefaultConfigSignInAnonymousToHclTerraform(struct?: GoogleIdentityPlatformProjectDefaultConfigSignInAnonymousOutputReference | GoogleIdentityPlatformProjectDefaultConfigSignInAnonymous): any;
export declare class GoogleIdentityPlatformProjectDefaultConfigSignInAnonymousOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleIdentityPlatformProjectDefaultConfigSignInAnonymous | undefined;
    set internalValue(value: GoogleIdentityPlatformProjectDefaultConfigSignInAnonymous | undefined);
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
}
export interface GoogleIdentityPlatformProjectDefaultConfigSignInEmail {
    /**
    * Whether email auth is enabled for the project or not.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_identity_platform_project_default_config#enabled GoogleIdentityPlatformProjectDefaultConfig#enabled}
    */
    readonly enabled?: boolean | cdktf.IResolvable;
    /**
    * Whether a password is required for email auth or not. If true, both an email and
    * password must be provided to sign in. If false, a user may sign in via either
    * email/password or email link.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_identity_platform_project_default_config#password_required GoogleIdentityPlatformProjectDefaultConfig#password_required}
    */
    readonly passwordRequired?: boolean | cdktf.IResolvable;
}
export declare function googleIdentityPlatformProjectDefaultConfigSignInEmailToTerraform(struct?: GoogleIdentityPlatformProjectDefaultConfigSignInEmailOutputReference | GoogleIdentityPlatformProjectDefaultConfigSignInEmail): any;
export declare function googleIdentityPlatformProjectDefaultConfigSignInEmailToHclTerraform(struct?: GoogleIdentityPlatformProjectDefaultConfigSignInEmailOutputReference | GoogleIdentityPlatformProjectDefaultConfigSignInEmail): any;
export declare class GoogleIdentityPlatformProjectDefaultConfigSignInEmailOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleIdentityPlatformProjectDefaultConfigSignInEmail | undefined;
    set internalValue(value: GoogleIdentityPlatformProjectDefaultConfigSignInEmail | undefined);
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    resetEnabled(): void;
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
    private _passwordRequired?;
    get passwordRequired(): boolean | cdktf.IResolvable;
    set passwordRequired(value: boolean | cdktf.IResolvable);
    resetPasswordRequired(): void;
    get passwordRequiredInput(): boolean | cdktf.IResolvable | undefined;
}
export interface GoogleIdentityPlatformProjectDefaultConfigSignInPhoneNumber {
    /**
    * Whether phone number auth is enabled for the project or not.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_identity_platform_project_default_config#enabled GoogleIdentityPlatformProjectDefaultConfig#enabled}
    */
    readonly enabled?: boolean | cdktf.IResolvable;
    /**
    * A map of <test phone number, fake code> that can be used for phone auth testing.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_identity_platform_project_default_config#test_phone_numbers GoogleIdentityPlatformProjectDefaultConfig#test_phone_numbers}
    */
    readonly testPhoneNumbers?: {
        [key: string]: string;
    };
}
export declare function googleIdentityPlatformProjectDefaultConfigSignInPhoneNumberToTerraform(struct?: GoogleIdentityPlatformProjectDefaultConfigSignInPhoneNumberOutputReference | GoogleIdentityPlatformProjectDefaultConfigSignInPhoneNumber): any;
export declare function googleIdentityPlatformProjectDefaultConfigSignInPhoneNumberToHclTerraform(struct?: GoogleIdentityPlatformProjectDefaultConfigSignInPhoneNumberOutputReference | GoogleIdentityPlatformProjectDefaultConfigSignInPhoneNumber): any;
export declare class GoogleIdentityPlatformProjectDefaultConfigSignInPhoneNumberOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleIdentityPlatformProjectDefaultConfigSignInPhoneNumber | undefined;
    set internalValue(value: GoogleIdentityPlatformProjectDefaultConfigSignInPhoneNumber | undefined);
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    resetEnabled(): void;
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
    private _testPhoneNumbers?;
    get testPhoneNumbers(): {
        [key: string]: string;
    };
    set testPhoneNumbers(value: {
        [key: string]: string;
    });
    resetTestPhoneNumbers(): void;
    get testPhoneNumbersInput(): {
        [key: string]: string;
    } | undefined;
}
export interface GoogleIdentityPlatformProjectDefaultConfigSignIn {
    /**
    * Whether to allow more than one account to have the same email.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_identity_platform_project_default_config#allow_duplicate_emails GoogleIdentityPlatformProjectDefaultConfig#allow_duplicate_emails}
    */
    readonly allowDuplicateEmails?: boolean | cdktf.IResolvable;
    /**
    * anonymous block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_identity_platform_project_default_config#anonymous GoogleIdentityPlatformProjectDefaultConfig#anonymous}
    */
    readonly anonymous?: GoogleIdentityPlatformProjectDefaultConfigSignInAnonymous;
    /**
    * email block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_identity_platform_project_default_config#email GoogleIdentityPlatformProjectDefaultConfig#email}
    */
    readonly email?: GoogleIdentityPlatformProjectDefaultConfigSignInEmail;
    /**
    * phone_number block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_identity_platform_project_default_config#phone_number GoogleIdentityPlatformProjectDefaultConfig#phone_number}
    */
    readonly phoneNumber?: GoogleIdentityPlatformProjectDefaultConfigSignInPhoneNumber;
}
export declare function googleIdentityPlatformProjectDefaultConfigSignInToTerraform(struct?: GoogleIdentityPlatformProjectDefaultConfigSignInOutputReference | GoogleIdentityPlatformProjectDefaultConfigSignIn): any;
export declare function googleIdentityPlatformProjectDefaultConfigSignInToHclTerraform(struct?: GoogleIdentityPlatformProjectDefaultConfigSignInOutputReference | GoogleIdentityPlatformProjectDefaultConfigSignIn): any;
export declare class GoogleIdentityPlatformProjectDefaultConfigSignInOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleIdentityPlatformProjectDefaultConfigSignIn | undefined;
    set internalValue(value: GoogleIdentityPlatformProjectDefaultConfigSignIn | undefined);
    private _allowDuplicateEmails?;
    get allowDuplicateEmails(): boolean | cdktf.IResolvable;
    set allowDuplicateEmails(value: boolean | cdktf.IResolvable);
    resetAllowDuplicateEmails(): void;
    get allowDuplicateEmailsInput(): boolean | cdktf.IResolvable | undefined;
    private _hashConfig;
    get hashConfig(): GoogleIdentityPlatformProjectDefaultConfigSignInHashConfigList;
    private _anonymous;
    get anonymous(): GoogleIdentityPlatformProjectDefaultConfigSignInAnonymousOutputReference;
    putAnonymous(value: GoogleIdentityPlatformProjectDefaultConfigSignInAnonymous): void;
    resetAnonymous(): void;
    get anonymousInput(): GoogleIdentityPlatformProjectDefaultConfigSignInAnonymous | undefined;
    private _email;
    get email(): GoogleIdentityPlatformProjectDefaultConfigSignInEmailOutputReference;
    putEmail(value: GoogleIdentityPlatformProjectDefaultConfigSignInEmail): void;
    resetEmail(): void;
    get emailInput(): GoogleIdentityPlatformProjectDefaultConfigSignInEmail | undefined;
    private _phoneNumber;
    get phoneNumber(): GoogleIdentityPlatformProjectDefaultConfigSignInPhoneNumberOutputReference;
    putPhoneNumber(value: GoogleIdentityPlatformProjectDefaultConfigSignInPhoneNumber): void;
    resetPhoneNumber(): void;
    get phoneNumberInput(): GoogleIdentityPlatformProjectDefaultConfigSignInPhoneNumber | undefined;
}
export interface GoogleIdentityPlatformProjectDefaultConfigTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_identity_platform_project_default_config#create GoogleIdentityPlatformProjectDefaultConfig#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_identity_platform_project_default_config#delete GoogleIdentityPlatformProjectDefaultConfig#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_identity_platform_project_default_config#update GoogleIdentityPlatformProjectDefaultConfig#update}
    */
    readonly update?: string;
}
export declare function googleIdentityPlatformProjectDefaultConfigTimeoutsToTerraform(struct?: GoogleIdentityPlatformProjectDefaultConfigTimeouts | cdktf.IResolvable): any;
export declare function googleIdentityPlatformProjectDefaultConfigTimeoutsToHclTerraform(struct?: GoogleIdentityPlatformProjectDefaultConfigTimeouts | cdktf.IResolvable): any;
export declare class GoogleIdentityPlatformProjectDefaultConfigTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleIdentityPlatformProjectDefaultConfigTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleIdentityPlatformProjectDefaultConfigTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_identity_platform_project_default_config google_identity_platform_project_default_config}
*/
export declare class GoogleIdentityPlatformProjectDefaultConfig extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_identity_platform_project_default_config";
    /**
    * Generates CDKTF code for importing a GoogleIdentityPlatformProjectDefaultConfig resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the GoogleIdentityPlatformProjectDefaultConfig to import
    * @param importFromId The id of the existing GoogleIdentityPlatformProjectDefaultConfig that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_identity_platform_project_default_config#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the GoogleIdentityPlatformProjectDefaultConfig to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_identity_platform_project_default_config google_identity_platform_project_default_config} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleIdentityPlatformProjectDefaultConfigConfig = {}
    */
    constructor(scope: Construct, id: string, config?: GoogleIdentityPlatformProjectDefaultConfigConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get name(): string;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _signIn;
    get signIn(): GoogleIdentityPlatformProjectDefaultConfigSignInOutputReference;
    putSignIn(value: GoogleIdentityPlatformProjectDefaultConfigSignIn): void;
    resetSignIn(): void;
    get signInInput(): GoogleIdentityPlatformProjectDefaultConfigSignIn | undefined;
    private _timeouts;
    get timeouts(): GoogleIdentityPlatformProjectDefaultConfigTimeoutsOutputReference;
    putTimeouts(value: GoogleIdentityPlatformProjectDefaultConfigTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleIdentityPlatformProjectDefaultConfigTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
