/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleIdentityPlatformTenantInboundSamlConfigConfig extends cdktf.TerraformMetaArguments {
    /**
    * Human friendly display name.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_identity_platform_tenant_inbound_saml_config#display_name GoogleIdentityPlatformTenantInboundSamlConfig#display_name}
    */
    readonly displayName: string;
    /**
    * If this config allows users to sign in with the provider.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_identity_platform_tenant_inbound_saml_config#enabled GoogleIdentityPlatformTenantInboundSamlConfig#enabled}
    */
    readonly enabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_identity_platform_tenant_inbound_saml_config#id GoogleIdentityPlatformTenantInboundSamlConfig#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The name of the InboundSamlConfig resource. Must start with 'saml.' and can only have alphanumeric characters,
    * hyphens, underscores or periods. The part after 'saml.' must also start with a lowercase letter, end with an
    * alphanumeric character, and have at least 2 characters.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_identity_platform_tenant_inbound_saml_config#name GoogleIdentityPlatformTenantInboundSamlConfig#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_identity_platform_tenant_inbound_saml_config#project GoogleIdentityPlatformTenantInboundSamlConfig#project}
    */
    readonly project?: string;
    /**
    * The name of the tenant where this inbound SAML config resource exists
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_identity_platform_tenant_inbound_saml_config#tenant GoogleIdentityPlatformTenantInboundSamlConfig#tenant}
    */
    readonly tenant: string;
    /**
    * idp_config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_identity_platform_tenant_inbound_saml_config#idp_config GoogleIdentityPlatformTenantInboundSamlConfig#idp_config}
    */
    readonly idpConfig: GoogleIdentityPlatformTenantInboundSamlConfigIdpConfig;
    /**
    * sp_config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_identity_platform_tenant_inbound_saml_config#sp_config GoogleIdentityPlatformTenantInboundSamlConfig#sp_config}
    */
    readonly spConfig: GoogleIdentityPlatformTenantInboundSamlConfigSpConfig;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_identity_platform_tenant_inbound_saml_config#timeouts GoogleIdentityPlatformTenantInboundSamlConfig#timeouts}
    */
    readonly timeouts?: GoogleIdentityPlatformTenantInboundSamlConfigTimeouts;
}
export interface GoogleIdentityPlatformTenantInboundSamlConfigIdpConfigIdpCertificates {
    /**
    * The x509 certificate
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_identity_platform_tenant_inbound_saml_config#x509_certificate GoogleIdentityPlatformTenantInboundSamlConfig#x509_certificate}
    */
    readonly x509Certificate?: string;
}
export declare function googleIdentityPlatformTenantInboundSamlConfigIdpConfigIdpCertificatesToTerraform(struct?: GoogleIdentityPlatformTenantInboundSamlConfigIdpConfigIdpCertificates | cdktf.IResolvable): any;
export declare function googleIdentityPlatformTenantInboundSamlConfigIdpConfigIdpCertificatesToHclTerraform(struct?: GoogleIdentityPlatformTenantInboundSamlConfigIdpConfigIdpCertificates | cdktf.IResolvable): any;
export declare class GoogleIdentityPlatformTenantInboundSamlConfigIdpConfigIdpCertificatesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleIdentityPlatformTenantInboundSamlConfigIdpConfigIdpCertificates | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleIdentityPlatformTenantInboundSamlConfigIdpConfigIdpCertificates | cdktf.IResolvable | undefined);
    private _x509Certificate?;
    get x509Certificate(): string;
    set x509Certificate(value: string);
    resetX509Certificate(): void;
    get x509CertificateInput(): string | undefined;
}
export declare class GoogleIdentityPlatformTenantInboundSamlConfigIdpConfigIdpCertificatesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleIdentityPlatformTenantInboundSamlConfigIdpConfigIdpCertificates[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleIdentityPlatformTenantInboundSamlConfigIdpConfigIdpCertificatesOutputReference;
}
export interface GoogleIdentityPlatformTenantInboundSamlConfigIdpConfig {
    /**
    * Unique identifier for all SAML entities
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_identity_platform_tenant_inbound_saml_config#idp_entity_id GoogleIdentityPlatformTenantInboundSamlConfig#idp_entity_id}
    */
    readonly idpEntityId: string;
    /**
    * Indicates if outbounding SAMLRequest should be signed.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_identity_platform_tenant_inbound_saml_config#sign_request GoogleIdentityPlatformTenantInboundSamlConfig#sign_request}
    */
    readonly signRequest?: boolean | cdktf.IResolvable;
    /**
    * URL to send Authentication request to.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_identity_platform_tenant_inbound_saml_config#sso_url GoogleIdentityPlatformTenantInboundSamlConfig#sso_url}
    */
    readonly ssoUrl: string;
    /**
    * idp_certificates block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_identity_platform_tenant_inbound_saml_config#idp_certificates GoogleIdentityPlatformTenantInboundSamlConfig#idp_certificates}
    */
    readonly idpCertificates: GoogleIdentityPlatformTenantInboundSamlConfigIdpConfigIdpCertificates[] | cdktf.IResolvable;
}
export declare function googleIdentityPlatformTenantInboundSamlConfigIdpConfigToTerraform(struct?: GoogleIdentityPlatformTenantInboundSamlConfigIdpConfigOutputReference | GoogleIdentityPlatformTenantInboundSamlConfigIdpConfig): any;
export declare function googleIdentityPlatformTenantInboundSamlConfigIdpConfigToHclTerraform(struct?: GoogleIdentityPlatformTenantInboundSamlConfigIdpConfigOutputReference | GoogleIdentityPlatformTenantInboundSamlConfigIdpConfig): any;
export declare class GoogleIdentityPlatformTenantInboundSamlConfigIdpConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleIdentityPlatformTenantInboundSamlConfigIdpConfig | undefined;
    set internalValue(value: GoogleIdentityPlatformTenantInboundSamlConfigIdpConfig | undefined);
    private _idpEntityId?;
    get idpEntityId(): string;
    set idpEntityId(value: string);
    get idpEntityIdInput(): string | undefined;
    private _signRequest?;
    get signRequest(): boolean | cdktf.IResolvable;
    set signRequest(value: boolean | cdktf.IResolvable);
    resetSignRequest(): void;
    get signRequestInput(): boolean | cdktf.IResolvable | undefined;
    private _ssoUrl?;
    get ssoUrl(): string;
    set ssoUrl(value: string);
    get ssoUrlInput(): string | undefined;
    private _idpCertificates;
    get idpCertificates(): GoogleIdentityPlatformTenantInboundSamlConfigIdpConfigIdpCertificatesList;
    putIdpCertificates(value: GoogleIdentityPlatformTenantInboundSamlConfigIdpConfigIdpCertificates[] | cdktf.IResolvable): void;
    get idpCertificatesInput(): cdktf.IResolvable | GoogleIdentityPlatformTenantInboundSamlConfigIdpConfigIdpCertificates[] | undefined;
}
export interface GoogleIdentityPlatformTenantInboundSamlConfigSpConfigSpCertificates {
}
export declare function googleIdentityPlatformTenantInboundSamlConfigSpConfigSpCertificatesToTerraform(struct?: GoogleIdentityPlatformTenantInboundSamlConfigSpConfigSpCertificates): any;
export declare function googleIdentityPlatformTenantInboundSamlConfigSpConfigSpCertificatesToHclTerraform(struct?: GoogleIdentityPlatformTenantInboundSamlConfigSpConfigSpCertificates): any;
export declare class GoogleIdentityPlatformTenantInboundSamlConfigSpConfigSpCertificatesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleIdentityPlatformTenantInboundSamlConfigSpConfigSpCertificates | undefined;
    set internalValue(value: GoogleIdentityPlatformTenantInboundSamlConfigSpConfigSpCertificates | undefined);
    get x509Certificate(): string;
}
export declare class GoogleIdentityPlatformTenantInboundSamlConfigSpConfigSpCertificatesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleIdentityPlatformTenantInboundSamlConfigSpConfigSpCertificatesOutputReference;
}
export interface GoogleIdentityPlatformTenantInboundSamlConfigSpConfig {
    /**
    * Callback URI where responses from IDP are handled. Must start with 'https://'.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_identity_platform_tenant_inbound_saml_config#callback_uri GoogleIdentityPlatformTenantInboundSamlConfig#callback_uri}
    */
    readonly callbackUri: string;
    /**
    * Unique identifier for all SAML entities.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_identity_platform_tenant_inbound_saml_config#sp_entity_id GoogleIdentityPlatformTenantInboundSamlConfig#sp_entity_id}
    */
    readonly spEntityId: string;
}
export declare function googleIdentityPlatformTenantInboundSamlConfigSpConfigToTerraform(struct?: GoogleIdentityPlatformTenantInboundSamlConfigSpConfigOutputReference | GoogleIdentityPlatformTenantInboundSamlConfigSpConfig): any;
export declare function googleIdentityPlatformTenantInboundSamlConfigSpConfigToHclTerraform(struct?: GoogleIdentityPlatformTenantInboundSamlConfigSpConfigOutputReference | GoogleIdentityPlatformTenantInboundSamlConfigSpConfig): any;
export declare class GoogleIdentityPlatformTenantInboundSamlConfigSpConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleIdentityPlatformTenantInboundSamlConfigSpConfig | undefined;
    set internalValue(value: GoogleIdentityPlatformTenantInboundSamlConfigSpConfig | undefined);
    private _callbackUri?;
    get callbackUri(): string;
    set callbackUri(value: string);
    get callbackUriInput(): string | undefined;
    private _spCertificates;
    get spCertificates(): GoogleIdentityPlatformTenantInboundSamlConfigSpConfigSpCertificatesList;
    private _spEntityId?;
    get spEntityId(): string;
    set spEntityId(value: string);
    get spEntityIdInput(): string | undefined;
}
export interface GoogleIdentityPlatformTenantInboundSamlConfigTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_identity_platform_tenant_inbound_saml_config#create GoogleIdentityPlatformTenantInboundSamlConfig#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_identity_platform_tenant_inbound_saml_config#delete GoogleIdentityPlatformTenantInboundSamlConfig#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_identity_platform_tenant_inbound_saml_config#update GoogleIdentityPlatformTenantInboundSamlConfig#update}
    */
    readonly update?: string;
}
export declare function googleIdentityPlatformTenantInboundSamlConfigTimeoutsToTerraform(struct?: GoogleIdentityPlatformTenantInboundSamlConfigTimeouts | cdktf.IResolvable): any;
export declare function googleIdentityPlatformTenantInboundSamlConfigTimeoutsToHclTerraform(struct?: GoogleIdentityPlatformTenantInboundSamlConfigTimeouts | cdktf.IResolvable): any;
export declare class GoogleIdentityPlatformTenantInboundSamlConfigTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleIdentityPlatformTenantInboundSamlConfigTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleIdentityPlatformTenantInboundSamlConfigTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_identity_platform_tenant_inbound_saml_config google_identity_platform_tenant_inbound_saml_config}
*/
export declare class GoogleIdentityPlatformTenantInboundSamlConfig extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_identity_platform_tenant_inbound_saml_config";
    /**
    * Generates CDKTF code for importing a GoogleIdentityPlatformTenantInboundSamlConfig resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the GoogleIdentityPlatformTenantInboundSamlConfig to import
    * @param importFromId The id of the existing GoogleIdentityPlatformTenantInboundSamlConfig that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_identity_platform_tenant_inbound_saml_config#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the GoogleIdentityPlatformTenantInboundSamlConfig to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_identity_platform_tenant_inbound_saml_config google_identity_platform_tenant_inbound_saml_config} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleIdentityPlatformTenantInboundSamlConfigConfig
    */
    constructor(scope: Construct, id: string, config: GoogleIdentityPlatformTenantInboundSamlConfigConfig);
    private _displayName?;
    get displayName(): string;
    set displayName(value: string);
    get displayNameInput(): string | undefined;
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    resetEnabled(): void;
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _tenant?;
    get tenant(): string;
    set tenant(value: string);
    get tenantInput(): string | undefined;
    private _idpConfig;
    get idpConfig(): GoogleIdentityPlatformTenantInboundSamlConfigIdpConfigOutputReference;
    putIdpConfig(value: GoogleIdentityPlatformTenantInboundSamlConfigIdpConfig): void;
    get idpConfigInput(): GoogleIdentityPlatformTenantInboundSamlConfigIdpConfig | undefined;
    private _spConfig;
    get spConfig(): GoogleIdentityPlatformTenantInboundSamlConfigSpConfigOutputReference;
    putSpConfig(value: GoogleIdentityPlatformTenantInboundSamlConfigSpConfig): void;
    get spConfigInput(): GoogleIdentityPlatformTenantInboundSamlConfigSpConfig | undefined;
    private _timeouts;
    get timeouts(): GoogleIdentityPlatformTenantInboundSamlConfigTimeoutsOutputReference;
    putTimeouts(value: GoogleIdentityPlatformTenantInboundSamlConfigTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleIdentityPlatformTenantInboundSamlConfigTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
