/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleIntegrationConnectorsConnectionConfig extends cdktf.TerraformMetaArguments {
    /**
    * connectorVersion of the Connector.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_integration_connectors_connection#connector_version GoogleIntegrationConnectorsConnection#connector_version}
    */
    readonly connectorVersion: string;
    /**
    * An arbitrary description for the Conection.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_integration_connectors_connection#description GoogleIntegrationConnectorsConnection#description}
    */
    readonly description?: string;
    /**
    * Eventing enablement type. Will be nil if eventing is not enabled. Possible values: ["EVENTING_AND_CONNECTION", "ONLY_EVENTING"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_integration_connectors_connection#eventing_enablement_type GoogleIntegrationConnectorsConnection#eventing_enablement_type}
    */
    readonly eventingEnablementType?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_integration_connectors_connection#id GoogleIntegrationConnectorsConnection#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Resource labels to represent user provided metadata.
    *
    *
    * **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
    * Please refer to the field 'effective_labels' for all of the labels present on the resource.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_integration_connectors_connection#labels GoogleIntegrationConnectorsConnection#labels}
    */
    readonly labels?: {
        [key: string]: string;
    };
    /**
    * Location in which Connection needs to be created.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_integration_connectors_connection#location GoogleIntegrationConnectorsConnection#location}
    */
    readonly location: string;
    /**
    * Name of Connection needs to be created.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_integration_connectors_connection#name GoogleIntegrationConnectorsConnection#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_integration_connectors_connection#project GoogleIntegrationConnectorsConnection#project}
    */
    readonly project?: string;
    /**
    * Service account needed for runtime plane to access Google Cloud resources.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_integration_connectors_connection#service_account GoogleIntegrationConnectorsConnection#service_account}
    */
    readonly serviceAccount?: string;
    /**
    * Suspended indicates if a user has suspended a connection or not.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_integration_connectors_connection#suspended GoogleIntegrationConnectorsConnection#suspended}
    */
    readonly suspended?: boolean | cdktf.IResolvable;
    /**
    * auth_config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_integration_connectors_connection#auth_config GoogleIntegrationConnectorsConnection#auth_config}
    */
    readonly authConfig?: GoogleIntegrationConnectorsConnectionAuthConfig;
    /**
    * config_variable block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_integration_connectors_connection#config_variable GoogleIntegrationConnectorsConnection#config_variable}
    */
    readonly configVariable?: GoogleIntegrationConnectorsConnectionConfigVariable[] | cdktf.IResolvable;
    /**
    * destination_config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_integration_connectors_connection#destination_config GoogleIntegrationConnectorsConnection#destination_config}
    */
    readonly destinationConfig?: GoogleIntegrationConnectorsConnectionDestinationConfig[] | cdktf.IResolvable;
    /**
    * eventing_config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_integration_connectors_connection#eventing_config GoogleIntegrationConnectorsConnection#eventing_config}
    */
    readonly eventingConfig?: GoogleIntegrationConnectorsConnectionEventingConfig;
    /**
    * lock_config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_integration_connectors_connection#lock_config GoogleIntegrationConnectorsConnection#lock_config}
    */
    readonly lockConfig?: GoogleIntegrationConnectorsConnectionLockConfig;
    /**
    * log_config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_integration_connectors_connection#log_config GoogleIntegrationConnectorsConnection#log_config}
    */
    readonly logConfig?: GoogleIntegrationConnectorsConnectionLogConfig;
    /**
    * node_config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_integration_connectors_connection#node_config GoogleIntegrationConnectorsConnection#node_config}
    */
    readonly nodeConfig?: GoogleIntegrationConnectorsConnectionNodeConfig;
    /**
    * ssl_config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_integration_connectors_connection#ssl_config GoogleIntegrationConnectorsConnection#ssl_config}
    */
    readonly sslConfig?: GoogleIntegrationConnectorsConnectionSslConfig;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_integration_connectors_connection#timeouts GoogleIntegrationConnectorsConnection#timeouts}
    */
    readonly timeouts?: GoogleIntegrationConnectorsConnectionTimeouts;
}
export interface GoogleIntegrationConnectorsConnectionConnectorVersionInfraConfig {
}
export declare function googleIntegrationConnectorsConnectionConnectorVersionInfraConfigToTerraform(struct?: GoogleIntegrationConnectorsConnectionConnectorVersionInfraConfig): any;
export declare function googleIntegrationConnectorsConnectionConnectorVersionInfraConfigToHclTerraform(struct?: GoogleIntegrationConnectorsConnectionConnectorVersionInfraConfig): any;
export declare class GoogleIntegrationConnectorsConnectionConnectorVersionInfraConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleIntegrationConnectorsConnectionConnectorVersionInfraConfig | undefined;
    set internalValue(value: GoogleIntegrationConnectorsConnectionConnectorVersionInfraConfig | undefined);
    get ratelimitThreshold(): string;
}
export declare class GoogleIntegrationConnectorsConnectionConnectorVersionInfraConfigList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleIntegrationConnectorsConnectionConnectorVersionInfraConfigOutputReference;
}
export interface GoogleIntegrationConnectorsConnectionEventingRuntimeDataStatus {
}
export declare function googleIntegrationConnectorsConnectionEventingRuntimeDataStatusToTerraform(struct?: GoogleIntegrationConnectorsConnectionEventingRuntimeDataStatus): any;
export declare function googleIntegrationConnectorsConnectionEventingRuntimeDataStatusToHclTerraform(struct?: GoogleIntegrationConnectorsConnectionEventingRuntimeDataStatus): any;
export declare class GoogleIntegrationConnectorsConnectionEventingRuntimeDataStatusOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleIntegrationConnectorsConnectionEventingRuntimeDataStatus | undefined;
    set internalValue(value: GoogleIntegrationConnectorsConnectionEventingRuntimeDataStatus | undefined);
    get description(): string;
    get state(): string;
}
export declare class GoogleIntegrationConnectorsConnectionEventingRuntimeDataStatusList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleIntegrationConnectorsConnectionEventingRuntimeDataStatusOutputReference;
}
export interface GoogleIntegrationConnectorsConnectionEventingRuntimeData {
}
export declare function googleIntegrationConnectorsConnectionEventingRuntimeDataToTerraform(struct?: GoogleIntegrationConnectorsConnectionEventingRuntimeData): any;
export declare function googleIntegrationConnectorsConnectionEventingRuntimeDataToHclTerraform(struct?: GoogleIntegrationConnectorsConnectionEventingRuntimeData): any;
export declare class GoogleIntegrationConnectorsConnectionEventingRuntimeDataOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleIntegrationConnectorsConnectionEventingRuntimeData | undefined;
    set internalValue(value: GoogleIntegrationConnectorsConnectionEventingRuntimeData | undefined);
    get eventsListenerEndpoint(): string;
    private _status;
    get status(): GoogleIntegrationConnectorsConnectionEventingRuntimeDataStatusList;
}
export declare class GoogleIntegrationConnectorsConnectionEventingRuntimeDataList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleIntegrationConnectorsConnectionEventingRuntimeDataOutputReference;
}
export interface GoogleIntegrationConnectorsConnectionStatus {
}
export declare function googleIntegrationConnectorsConnectionStatusToTerraform(struct?: GoogleIntegrationConnectorsConnectionStatus): any;
export declare function googleIntegrationConnectorsConnectionStatusToHclTerraform(struct?: GoogleIntegrationConnectorsConnectionStatus): any;
export declare class GoogleIntegrationConnectorsConnectionStatusOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleIntegrationConnectorsConnectionStatus | undefined;
    set internalValue(value: GoogleIntegrationConnectorsConnectionStatus | undefined);
    get description(): string;
    get state(): string;
    get status(): string;
}
export declare class GoogleIntegrationConnectorsConnectionStatusList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleIntegrationConnectorsConnectionStatusOutputReference;
}
export interface GoogleIntegrationConnectorsConnectionAuthConfigAdditionalVariableEncryptionKeyValue {
    /**
    * The [KMS key name] with which the content of the Operation is encrypted. The expected
    * format: projects/* /locations/* /keyRings/* /cryptoKeys/*.
    * Will be empty string if google managed.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_integration_connectors_connection#kms_key_name GoogleIntegrationConnectorsConnection#kms_key_name}
     *
    * Note: The above comment contained a comment block ending sequence (* followed by /). We have introduced a space between to prevent syntax errors. Please ignore the space.
    */
    readonly kmsKeyName?: string;
    /**
    * Type of Encription Key Possible values: ["GOOGLE_MANAGED", "CUSTOMER_MANAGED"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_integration_connectors_connection#type GoogleIntegrationConnectorsConnection#type}
    */
    readonly type: string;
}
export declare function googleIntegrationConnectorsConnectionAuthConfigAdditionalVariableEncryptionKeyValueToTerraform(struct?: GoogleIntegrationConnectorsConnectionAuthConfigAdditionalVariableEncryptionKeyValueOutputReference | GoogleIntegrationConnectorsConnectionAuthConfigAdditionalVariableEncryptionKeyValue): any;
export declare function googleIntegrationConnectorsConnectionAuthConfigAdditionalVariableEncryptionKeyValueToHclTerraform(struct?: GoogleIntegrationConnectorsConnectionAuthConfigAdditionalVariableEncryptionKeyValueOutputReference | GoogleIntegrationConnectorsConnectionAuthConfigAdditionalVariableEncryptionKeyValue): any;
export declare class GoogleIntegrationConnectorsConnectionAuthConfigAdditionalVariableEncryptionKeyValueOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleIntegrationConnectorsConnectionAuthConfigAdditionalVariableEncryptionKeyValue | undefined;
    set internalValue(value: GoogleIntegrationConnectorsConnectionAuthConfigAdditionalVariableEncryptionKeyValue | undefined);
    private _kmsKeyName?;
    get kmsKeyName(): string;
    set kmsKeyName(value: string);
    resetKmsKeyName(): void;
    get kmsKeyNameInput(): string | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
}
export interface GoogleIntegrationConnectorsConnectionAuthConfigAdditionalVariableSecretValue {
    /**
    * Secret version of Secret Value for Config variable.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_integration_connectors_connection#secret_version GoogleIntegrationConnectorsConnection#secret_version}
    */
    readonly secretVersion: string;
}
export declare function googleIntegrationConnectorsConnectionAuthConfigAdditionalVariableSecretValueToTerraform(struct?: GoogleIntegrationConnectorsConnectionAuthConfigAdditionalVariableSecretValueOutputReference | GoogleIntegrationConnectorsConnectionAuthConfigAdditionalVariableSecretValue): any;
export declare function googleIntegrationConnectorsConnectionAuthConfigAdditionalVariableSecretValueToHclTerraform(struct?: GoogleIntegrationConnectorsConnectionAuthConfigAdditionalVariableSecretValueOutputReference | GoogleIntegrationConnectorsConnectionAuthConfigAdditionalVariableSecretValue): any;
export declare class GoogleIntegrationConnectorsConnectionAuthConfigAdditionalVariableSecretValueOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleIntegrationConnectorsConnectionAuthConfigAdditionalVariableSecretValue | undefined;
    set internalValue(value: GoogleIntegrationConnectorsConnectionAuthConfigAdditionalVariableSecretValue | undefined);
    private _secretVersion?;
    get secretVersion(): string;
    set secretVersion(value: string);
    get secretVersionInput(): string | undefined;
}
export interface GoogleIntegrationConnectorsConnectionAuthConfigAdditionalVariable {
    /**
    * Boolean Value of configVariable.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_integration_connectors_connection#boolean_value GoogleIntegrationConnectorsConnection#boolean_value}
    */
    readonly booleanValue?: boolean | cdktf.IResolvable;
    /**
    * Integer Value of configVariable.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_integration_connectors_connection#integer_value GoogleIntegrationConnectorsConnection#integer_value}
    */
    readonly integerValue?: number;
    /**
    * Key for the configVariable
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_integration_connectors_connection#key GoogleIntegrationConnectorsConnection#key}
    */
    readonly key: string;
    /**
    * String Value of configVariabley.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_integration_connectors_connection#string_value GoogleIntegrationConnectorsConnection#string_value}
    */
    readonly stringValue?: string;
    /**
    * encryption_key_value block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_integration_connectors_connection#encryption_key_value GoogleIntegrationConnectorsConnection#encryption_key_value}
    */
    readonly encryptionKeyValue?: GoogleIntegrationConnectorsConnectionAuthConfigAdditionalVariableEncryptionKeyValue;
    /**
    * secret_value block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_integration_connectors_connection#secret_value GoogleIntegrationConnectorsConnection#secret_value}
    */
    readonly secretValue?: GoogleIntegrationConnectorsConnectionAuthConfigAdditionalVariableSecretValue;
}
export declare function googleIntegrationConnectorsConnectionAuthConfigAdditionalVariableToTerraform(struct?: GoogleIntegrationConnectorsConnectionAuthConfigAdditionalVariable | cdktf.IResolvable): any;
export declare function googleIntegrationConnectorsConnectionAuthConfigAdditionalVariableToHclTerraform(struct?: GoogleIntegrationConnectorsConnectionAuthConfigAdditionalVariable | cdktf.IResolvable): any;
export declare class GoogleIntegrationConnectorsConnectionAuthConfigAdditionalVariableOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleIntegrationConnectorsConnectionAuthConfigAdditionalVariable | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleIntegrationConnectorsConnectionAuthConfigAdditionalVariable | cdktf.IResolvable | undefined);
    private _booleanValue?;
    get booleanValue(): boolean | cdktf.IResolvable;
    set booleanValue(value: boolean | cdktf.IResolvable);
    resetBooleanValue(): void;
    get booleanValueInput(): boolean | cdktf.IResolvable | undefined;
    private _integerValue?;
    get integerValue(): number;
    set integerValue(value: number);
    resetIntegerValue(): void;
    get integerValueInput(): number | undefined;
    private _key?;
    get key(): string;
    set key(value: string);
    get keyInput(): string | undefined;
    private _stringValue?;
    get stringValue(): string;
    set stringValue(value: string);
    resetStringValue(): void;
    get stringValueInput(): string | undefined;
    private _encryptionKeyValue;
    get encryptionKeyValue(): GoogleIntegrationConnectorsConnectionAuthConfigAdditionalVariableEncryptionKeyValueOutputReference;
    putEncryptionKeyValue(value: GoogleIntegrationConnectorsConnectionAuthConfigAdditionalVariableEncryptionKeyValue): void;
    resetEncryptionKeyValue(): void;
    get encryptionKeyValueInput(): GoogleIntegrationConnectorsConnectionAuthConfigAdditionalVariableEncryptionKeyValue | undefined;
    private _secretValue;
    get secretValue(): GoogleIntegrationConnectorsConnectionAuthConfigAdditionalVariableSecretValueOutputReference;
    putSecretValue(value: GoogleIntegrationConnectorsConnectionAuthConfigAdditionalVariableSecretValue): void;
    resetSecretValue(): void;
    get secretValueInput(): GoogleIntegrationConnectorsConnectionAuthConfigAdditionalVariableSecretValue | undefined;
}
export declare class GoogleIntegrationConnectorsConnectionAuthConfigAdditionalVariableList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleIntegrationConnectorsConnectionAuthConfigAdditionalVariable[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleIntegrationConnectorsConnectionAuthConfigAdditionalVariableOutputReference;
}
export interface GoogleIntegrationConnectorsConnectionAuthConfigOauth2AuthCodeFlowClientSecret {
    /**
    * The resource name of the secret version in the format,
    * format as: projects/* /secrets/* /versions/*.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_integration_connectors_connection#secret_version GoogleIntegrationConnectorsConnection#secret_version}
     *
    * Note: The above comment contained a comment block ending sequence (* followed by /). We have introduced a space between to prevent syntax errors. Please ignore the space.
    */
    readonly secretVersion: string;
}
export declare function googleIntegrationConnectorsConnectionAuthConfigOauth2AuthCodeFlowClientSecretToTerraform(struct?: GoogleIntegrationConnectorsConnectionAuthConfigOauth2AuthCodeFlowClientSecretOutputReference | GoogleIntegrationConnectorsConnectionAuthConfigOauth2AuthCodeFlowClientSecret): any;
export declare function googleIntegrationConnectorsConnectionAuthConfigOauth2AuthCodeFlowClientSecretToHclTerraform(struct?: GoogleIntegrationConnectorsConnectionAuthConfigOauth2AuthCodeFlowClientSecretOutputReference | GoogleIntegrationConnectorsConnectionAuthConfigOauth2AuthCodeFlowClientSecret): any;
export declare class GoogleIntegrationConnectorsConnectionAuthConfigOauth2AuthCodeFlowClientSecretOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleIntegrationConnectorsConnectionAuthConfigOauth2AuthCodeFlowClientSecret | undefined;
    set internalValue(value: GoogleIntegrationConnectorsConnectionAuthConfigOauth2AuthCodeFlowClientSecret | undefined);
    private _secretVersion?;
    get secretVersion(): string;
    set secretVersion(value: string);
    get secretVersionInput(): string | undefined;
}
export interface GoogleIntegrationConnectorsConnectionAuthConfigOauth2AuthCodeFlow {
    /**
    * Auth URL for Authorization Code Flow.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_integration_connectors_connection#auth_uri GoogleIntegrationConnectorsConnection#auth_uri}
    */
    readonly authUri?: string;
    /**
    * Client ID for user-provided OAuth app.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_integration_connectors_connection#client_id GoogleIntegrationConnectorsConnection#client_id}
    */
    readonly clientId?: string;
    /**
    * Whether to enable PKCE when the user performs the auth code flow.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_integration_connectors_connection#enable_pkce GoogleIntegrationConnectorsConnection#enable_pkce}
    */
    readonly enablePkce?: boolean | cdktf.IResolvable;
    /**
    * Scopes the connection will request when the user performs the auth code flow.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_integration_connectors_connection#scopes GoogleIntegrationConnectorsConnection#scopes}
    */
    readonly scopes?: string[];
    /**
    * client_secret block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_integration_connectors_connection#client_secret GoogleIntegrationConnectorsConnection#client_secret}
    */
    readonly clientSecret?: GoogleIntegrationConnectorsConnectionAuthConfigOauth2AuthCodeFlowClientSecret;
}
export declare function googleIntegrationConnectorsConnectionAuthConfigOauth2AuthCodeFlowToTerraform(struct?: GoogleIntegrationConnectorsConnectionAuthConfigOauth2AuthCodeFlowOutputReference | GoogleIntegrationConnectorsConnectionAuthConfigOauth2AuthCodeFlow): any;
export declare function googleIntegrationConnectorsConnectionAuthConfigOauth2AuthCodeFlowToHclTerraform(struct?: GoogleIntegrationConnectorsConnectionAuthConfigOauth2AuthCodeFlowOutputReference | GoogleIntegrationConnectorsConnectionAuthConfigOauth2AuthCodeFlow): any;
export declare class GoogleIntegrationConnectorsConnectionAuthConfigOauth2AuthCodeFlowOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleIntegrationConnectorsConnectionAuthConfigOauth2AuthCodeFlow | undefined;
    set internalValue(value: GoogleIntegrationConnectorsConnectionAuthConfigOauth2AuthCodeFlow | undefined);
    private _authUri?;
    get authUri(): string;
    set authUri(value: string);
    resetAuthUri(): void;
    get authUriInput(): string | undefined;
    private _clientId?;
    get clientId(): string;
    set clientId(value: string);
    resetClientId(): void;
    get clientIdInput(): string | undefined;
    private _enablePkce?;
    get enablePkce(): boolean | cdktf.IResolvable;
    set enablePkce(value: boolean | cdktf.IResolvable);
    resetEnablePkce(): void;
    get enablePkceInput(): boolean | cdktf.IResolvable | undefined;
    private _scopes?;
    get scopes(): string[];
    set scopes(value: string[]);
    resetScopes(): void;
    get scopesInput(): string[] | undefined;
    private _clientSecret;
    get clientSecret(): GoogleIntegrationConnectorsConnectionAuthConfigOauth2AuthCodeFlowClientSecretOutputReference;
    putClientSecret(value: GoogleIntegrationConnectorsConnectionAuthConfigOauth2AuthCodeFlowClientSecret): void;
    resetClientSecret(): void;
    get clientSecretInput(): GoogleIntegrationConnectorsConnectionAuthConfigOauth2AuthCodeFlowClientSecret | undefined;
}
export interface GoogleIntegrationConnectorsConnectionAuthConfigOauth2ClientCredentialsClientSecret {
    /**
    * The resource name of the secret version in the format,
    * format as: projects/* /secrets/* /versions/*.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_integration_connectors_connection#secret_version GoogleIntegrationConnectorsConnection#secret_version}
     *
    * Note: The above comment contained a comment block ending sequence (* followed by /). We have introduced a space between to prevent syntax errors. Please ignore the space.
    */
    readonly secretVersion: string;
}
export declare function googleIntegrationConnectorsConnectionAuthConfigOauth2ClientCredentialsClientSecretToTerraform(struct?: GoogleIntegrationConnectorsConnectionAuthConfigOauth2ClientCredentialsClientSecretOutputReference | GoogleIntegrationConnectorsConnectionAuthConfigOauth2ClientCredentialsClientSecret): any;
export declare function googleIntegrationConnectorsConnectionAuthConfigOauth2ClientCredentialsClientSecretToHclTerraform(struct?: GoogleIntegrationConnectorsConnectionAuthConfigOauth2ClientCredentialsClientSecretOutputReference | GoogleIntegrationConnectorsConnectionAuthConfigOauth2ClientCredentialsClientSecret): any;
export declare class GoogleIntegrationConnectorsConnectionAuthConfigOauth2ClientCredentialsClientSecretOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleIntegrationConnectorsConnectionAuthConfigOauth2ClientCredentialsClientSecret | undefined;
    set internalValue(value: GoogleIntegrationConnectorsConnectionAuthConfigOauth2ClientCredentialsClientSecret | undefined);
    private _secretVersion?;
    get secretVersion(): string;
    set secretVersion(value: string);
    get secretVersionInput(): string | undefined;
}
export interface GoogleIntegrationConnectorsConnectionAuthConfigOauth2ClientCredentials {
    /**
    * Secret version of Password for Authentication.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_integration_connectors_connection#client_id GoogleIntegrationConnectorsConnection#client_id}
    */
    readonly clientId: string;
    /**
    * client_secret block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_integration_connectors_connection#client_secret GoogleIntegrationConnectorsConnection#client_secret}
    */
    readonly clientSecret?: GoogleIntegrationConnectorsConnectionAuthConfigOauth2ClientCredentialsClientSecret;
}
export declare function googleIntegrationConnectorsConnectionAuthConfigOauth2ClientCredentialsToTerraform(struct?: GoogleIntegrationConnectorsConnectionAuthConfigOauth2ClientCredentialsOutputReference | GoogleIntegrationConnectorsConnectionAuthConfigOauth2ClientCredentials): any;
export declare function googleIntegrationConnectorsConnectionAuthConfigOauth2ClientCredentialsToHclTerraform(struct?: GoogleIntegrationConnectorsConnectionAuthConfigOauth2ClientCredentialsOutputReference | GoogleIntegrationConnectorsConnectionAuthConfigOauth2ClientCredentials): any;
export declare class GoogleIntegrationConnectorsConnectionAuthConfigOauth2ClientCredentialsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleIntegrationConnectorsConnectionAuthConfigOauth2ClientCredentials | undefined;
    set internalValue(value: GoogleIntegrationConnectorsConnectionAuthConfigOauth2ClientCredentials | undefined);
    private _clientId?;
    get clientId(): string;
    set clientId(value: string);
    get clientIdInput(): string | undefined;
    private _clientSecret;
    get clientSecret(): GoogleIntegrationConnectorsConnectionAuthConfigOauth2ClientCredentialsClientSecretOutputReference;
    putClientSecret(value: GoogleIntegrationConnectorsConnectionAuthConfigOauth2ClientCredentialsClientSecret): void;
    resetClientSecret(): void;
    get clientSecretInput(): GoogleIntegrationConnectorsConnectionAuthConfigOauth2ClientCredentialsClientSecret | undefined;
}
export interface GoogleIntegrationConnectorsConnectionAuthConfigOauth2JwtBearerClientKey {
    /**
    * The resource name of the secret version in the format,
    * format as: projects/* /secrets/* /versions/*.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_integration_connectors_connection#secret_version GoogleIntegrationConnectorsConnection#secret_version}
     *
    * Note: The above comment contained a comment block ending sequence (* followed by /). We have introduced a space between to prevent syntax errors. Please ignore the space.
    */
    readonly secretVersion: string;
}
export declare function googleIntegrationConnectorsConnectionAuthConfigOauth2JwtBearerClientKeyToTerraform(struct?: GoogleIntegrationConnectorsConnectionAuthConfigOauth2JwtBearerClientKeyOutputReference | GoogleIntegrationConnectorsConnectionAuthConfigOauth2JwtBearerClientKey): any;
export declare function googleIntegrationConnectorsConnectionAuthConfigOauth2JwtBearerClientKeyToHclTerraform(struct?: GoogleIntegrationConnectorsConnectionAuthConfigOauth2JwtBearerClientKeyOutputReference | GoogleIntegrationConnectorsConnectionAuthConfigOauth2JwtBearerClientKey): any;
export declare class GoogleIntegrationConnectorsConnectionAuthConfigOauth2JwtBearerClientKeyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleIntegrationConnectorsConnectionAuthConfigOauth2JwtBearerClientKey | undefined;
    set internalValue(value: GoogleIntegrationConnectorsConnectionAuthConfigOauth2JwtBearerClientKey | undefined);
    private _secretVersion?;
    get secretVersion(): string;
    set secretVersion(value: string);
    get secretVersionInput(): string | undefined;
}
export interface GoogleIntegrationConnectorsConnectionAuthConfigOauth2JwtBearerJwtClaims {
    /**
    * Value for the "aud" claim.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_integration_connectors_connection#audience GoogleIntegrationConnectorsConnection#audience}
    */
    readonly audience?: string;
    /**
    * Value for the "iss" claim.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_integration_connectors_connection#issuer GoogleIntegrationConnectorsConnection#issuer}
    */
    readonly issuer?: string;
    /**
    * Value for the "sub" claim.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_integration_connectors_connection#subject GoogleIntegrationConnectorsConnection#subject}
    */
    readonly subject?: string;
}
export declare function googleIntegrationConnectorsConnectionAuthConfigOauth2JwtBearerJwtClaimsToTerraform(struct?: GoogleIntegrationConnectorsConnectionAuthConfigOauth2JwtBearerJwtClaimsOutputReference | GoogleIntegrationConnectorsConnectionAuthConfigOauth2JwtBearerJwtClaims): any;
export declare function googleIntegrationConnectorsConnectionAuthConfigOauth2JwtBearerJwtClaimsToHclTerraform(struct?: GoogleIntegrationConnectorsConnectionAuthConfigOauth2JwtBearerJwtClaimsOutputReference | GoogleIntegrationConnectorsConnectionAuthConfigOauth2JwtBearerJwtClaims): any;
export declare class GoogleIntegrationConnectorsConnectionAuthConfigOauth2JwtBearerJwtClaimsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleIntegrationConnectorsConnectionAuthConfigOauth2JwtBearerJwtClaims | undefined;
    set internalValue(value: GoogleIntegrationConnectorsConnectionAuthConfigOauth2JwtBearerJwtClaims | undefined);
    private _audience?;
    get audience(): string;
    set audience(value: string);
    resetAudience(): void;
    get audienceInput(): string | undefined;
    private _issuer?;
    get issuer(): string;
    set issuer(value: string);
    resetIssuer(): void;
    get issuerInput(): string | undefined;
    private _subject?;
    get subject(): string;
    set subject(value: string);
    resetSubject(): void;
    get subjectInput(): string | undefined;
}
export interface GoogleIntegrationConnectorsConnectionAuthConfigOauth2JwtBearer {
    /**
    * client_key block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_integration_connectors_connection#client_key GoogleIntegrationConnectorsConnection#client_key}
    */
    readonly clientKey?: GoogleIntegrationConnectorsConnectionAuthConfigOauth2JwtBearerClientKey;
    /**
    * jwt_claims block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_integration_connectors_connection#jwt_claims GoogleIntegrationConnectorsConnection#jwt_claims}
    */
    readonly jwtClaims?: GoogleIntegrationConnectorsConnectionAuthConfigOauth2JwtBearerJwtClaims;
}
export declare function googleIntegrationConnectorsConnectionAuthConfigOauth2JwtBearerToTerraform(struct?: GoogleIntegrationConnectorsConnectionAuthConfigOauth2JwtBearerOutputReference | GoogleIntegrationConnectorsConnectionAuthConfigOauth2JwtBearer): any;
export declare function googleIntegrationConnectorsConnectionAuthConfigOauth2JwtBearerToHclTerraform(struct?: GoogleIntegrationConnectorsConnectionAuthConfigOauth2JwtBearerOutputReference | GoogleIntegrationConnectorsConnectionAuthConfigOauth2JwtBearer): any;
export declare class GoogleIntegrationConnectorsConnectionAuthConfigOauth2JwtBearerOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleIntegrationConnectorsConnectionAuthConfigOauth2JwtBearer | undefined;
    set internalValue(value: GoogleIntegrationConnectorsConnectionAuthConfigOauth2JwtBearer | undefined);
    private _clientKey;
    get clientKey(): GoogleIntegrationConnectorsConnectionAuthConfigOauth2JwtBearerClientKeyOutputReference;
    putClientKey(value: GoogleIntegrationConnectorsConnectionAuthConfigOauth2JwtBearerClientKey): void;
    resetClientKey(): void;
    get clientKeyInput(): GoogleIntegrationConnectorsConnectionAuthConfigOauth2JwtBearerClientKey | undefined;
    private _jwtClaims;
    get jwtClaims(): GoogleIntegrationConnectorsConnectionAuthConfigOauth2JwtBearerJwtClaimsOutputReference;
    putJwtClaims(value: GoogleIntegrationConnectorsConnectionAuthConfigOauth2JwtBearerJwtClaims): void;
    resetJwtClaims(): void;
    get jwtClaimsInput(): GoogleIntegrationConnectorsConnectionAuthConfigOauth2JwtBearerJwtClaims | undefined;
}
export interface GoogleIntegrationConnectorsConnectionAuthConfigSshPublicKeySshClientCert {
    /**
    * The resource name of the secret version in the format,
    * format as: projects/* /secrets/* /versions/*.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_integration_connectors_connection#secret_version GoogleIntegrationConnectorsConnection#secret_version}
     *
    * Note: The above comment contained a comment block ending sequence (* followed by /). We have introduced a space between to prevent syntax errors. Please ignore the space.
    */
    readonly secretVersion: string;
}
export declare function googleIntegrationConnectorsConnectionAuthConfigSshPublicKeySshClientCertToTerraform(struct?: GoogleIntegrationConnectorsConnectionAuthConfigSshPublicKeySshClientCertOutputReference | GoogleIntegrationConnectorsConnectionAuthConfigSshPublicKeySshClientCert): any;
export declare function googleIntegrationConnectorsConnectionAuthConfigSshPublicKeySshClientCertToHclTerraform(struct?: GoogleIntegrationConnectorsConnectionAuthConfigSshPublicKeySshClientCertOutputReference | GoogleIntegrationConnectorsConnectionAuthConfigSshPublicKeySshClientCert): any;
export declare class GoogleIntegrationConnectorsConnectionAuthConfigSshPublicKeySshClientCertOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleIntegrationConnectorsConnectionAuthConfigSshPublicKeySshClientCert | undefined;
    set internalValue(value: GoogleIntegrationConnectorsConnectionAuthConfigSshPublicKeySshClientCert | undefined);
    private _secretVersion?;
    get secretVersion(): string;
    set secretVersion(value: string);
    get secretVersionInput(): string | undefined;
}
export interface GoogleIntegrationConnectorsConnectionAuthConfigSshPublicKeySshClientCertPass {
    /**
    * The resource name of the secret version in the format,
    * format as: projects/* /secrets/* /versions/*.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_integration_connectors_connection#secret_version GoogleIntegrationConnectorsConnection#secret_version}
     *
    * Note: The above comment contained a comment block ending sequence (* followed by /). We have introduced a space between to prevent syntax errors. Please ignore the space.
    */
    readonly secretVersion: string;
}
export declare function googleIntegrationConnectorsConnectionAuthConfigSshPublicKeySshClientCertPassToTerraform(struct?: GoogleIntegrationConnectorsConnectionAuthConfigSshPublicKeySshClientCertPassOutputReference | GoogleIntegrationConnectorsConnectionAuthConfigSshPublicKeySshClientCertPass): any;
export declare function googleIntegrationConnectorsConnectionAuthConfigSshPublicKeySshClientCertPassToHclTerraform(struct?: GoogleIntegrationConnectorsConnectionAuthConfigSshPublicKeySshClientCertPassOutputReference | GoogleIntegrationConnectorsConnectionAuthConfigSshPublicKeySshClientCertPass): any;
export declare class GoogleIntegrationConnectorsConnectionAuthConfigSshPublicKeySshClientCertPassOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleIntegrationConnectorsConnectionAuthConfigSshPublicKeySshClientCertPass | undefined;
    set internalValue(value: GoogleIntegrationConnectorsConnectionAuthConfigSshPublicKeySshClientCertPass | undefined);
    private _secretVersion?;
    get secretVersion(): string;
    set secretVersion(value: string);
    get secretVersionInput(): string | undefined;
}
export interface GoogleIntegrationConnectorsConnectionAuthConfigSshPublicKey {
    /**
    * Format of SSH Client cert.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_integration_connectors_connection#cert_type GoogleIntegrationConnectorsConnection#cert_type}
    */
    readonly certType?: string;
    /**
    * The user account used to authenticate.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_integration_connectors_connection#username GoogleIntegrationConnectorsConnection#username}
    */
    readonly username: string;
    /**
    * ssh_client_cert block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_integration_connectors_connection#ssh_client_cert GoogleIntegrationConnectorsConnection#ssh_client_cert}
    */
    readonly sshClientCert?: GoogleIntegrationConnectorsConnectionAuthConfigSshPublicKeySshClientCert;
    /**
    * ssh_client_cert_pass block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_integration_connectors_connection#ssh_client_cert_pass GoogleIntegrationConnectorsConnection#ssh_client_cert_pass}
    */
    readonly sshClientCertPass?: GoogleIntegrationConnectorsConnectionAuthConfigSshPublicKeySshClientCertPass;
}
export declare function googleIntegrationConnectorsConnectionAuthConfigSshPublicKeyToTerraform(struct?: GoogleIntegrationConnectorsConnectionAuthConfigSshPublicKeyOutputReference | GoogleIntegrationConnectorsConnectionAuthConfigSshPublicKey): any;
export declare function googleIntegrationConnectorsConnectionAuthConfigSshPublicKeyToHclTerraform(struct?: GoogleIntegrationConnectorsConnectionAuthConfigSshPublicKeyOutputReference | GoogleIntegrationConnectorsConnectionAuthConfigSshPublicKey): any;
export declare class GoogleIntegrationConnectorsConnectionAuthConfigSshPublicKeyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleIntegrationConnectorsConnectionAuthConfigSshPublicKey | undefined;
    set internalValue(value: GoogleIntegrationConnectorsConnectionAuthConfigSshPublicKey | undefined);
    private _certType?;
    get certType(): string;
    set certType(value: string);
    resetCertType(): void;
    get certTypeInput(): string | undefined;
    private _username?;
    get username(): string;
    set username(value: string);
    get usernameInput(): string | undefined;
    private _sshClientCert;
    get sshClientCert(): GoogleIntegrationConnectorsConnectionAuthConfigSshPublicKeySshClientCertOutputReference;
    putSshClientCert(value: GoogleIntegrationConnectorsConnectionAuthConfigSshPublicKeySshClientCert): void;
    resetSshClientCert(): void;
    get sshClientCertInput(): GoogleIntegrationConnectorsConnectionAuthConfigSshPublicKeySshClientCert | undefined;
    private _sshClientCertPass;
    get sshClientCertPass(): GoogleIntegrationConnectorsConnectionAuthConfigSshPublicKeySshClientCertPassOutputReference;
    putSshClientCertPass(value: GoogleIntegrationConnectorsConnectionAuthConfigSshPublicKeySshClientCertPass): void;
    resetSshClientCertPass(): void;
    get sshClientCertPassInput(): GoogleIntegrationConnectorsConnectionAuthConfigSshPublicKeySshClientCertPass | undefined;
}
export interface GoogleIntegrationConnectorsConnectionAuthConfigUserPasswordPassword {
    /**
    * The resource name of the secret version in the format,
    * format as: projects/* /secrets/* /versions/*.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_integration_connectors_connection#secret_version GoogleIntegrationConnectorsConnection#secret_version}
     *
    * Note: The above comment contained a comment block ending sequence (* followed by /). We have introduced a space between to prevent syntax errors. Please ignore the space.
    */
    readonly secretVersion: string;
}
export declare function googleIntegrationConnectorsConnectionAuthConfigUserPasswordPasswordToTerraform(struct?: GoogleIntegrationConnectorsConnectionAuthConfigUserPasswordPasswordOutputReference | GoogleIntegrationConnectorsConnectionAuthConfigUserPasswordPassword): any;
export declare function googleIntegrationConnectorsConnectionAuthConfigUserPasswordPasswordToHclTerraform(struct?: GoogleIntegrationConnectorsConnectionAuthConfigUserPasswordPasswordOutputReference | GoogleIntegrationConnectorsConnectionAuthConfigUserPasswordPassword): any;
export declare class GoogleIntegrationConnectorsConnectionAuthConfigUserPasswordPasswordOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleIntegrationConnectorsConnectionAuthConfigUserPasswordPassword | undefined;
    set internalValue(value: GoogleIntegrationConnectorsConnectionAuthConfigUserPasswordPassword | undefined);
    private _secretVersion?;
    get secretVersion(): string;
    set secretVersion(value: string);
    get secretVersionInput(): string | undefined;
}
export interface GoogleIntegrationConnectorsConnectionAuthConfigUserPassword {
    /**
    * Username for Authentication.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_integration_connectors_connection#username GoogleIntegrationConnectorsConnection#username}
    */
    readonly username: string;
    /**
    * password block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_integration_connectors_connection#password GoogleIntegrationConnectorsConnection#password}
    */
    readonly password?: GoogleIntegrationConnectorsConnectionAuthConfigUserPasswordPassword;
}
export declare function googleIntegrationConnectorsConnectionAuthConfigUserPasswordToTerraform(struct?: GoogleIntegrationConnectorsConnectionAuthConfigUserPasswordOutputReference | GoogleIntegrationConnectorsConnectionAuthConfigUserPassword): any;
export declare function googleIntegrationConnectorsConnectionAuthConfigUserPasswordToHclTerraform(struct?: GoogleIntegrationConnectorsConnectionAuthConfigUserPasswordOutputReference | GoogleIntegrationConnectorsConnectionAuthConfigUserPassword): any;
export declare class GoogleIntegrationConnectorsConnectionAuthConfigUserPasswordOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleIntegrationConnectorsConnectionAuthConfigUserPassword | undefined;
    set internalValue(value: GoogleIntegrationConnectorsConnectionAuthConfigUserPassword | undefined);
    private _username?;
    get username(): string;
    set username(value: string);
    get usernameInput(): string | undefined;
    private _password;
    get password(): GoogleIntegrationConnectorsConnectionAuthConfigUserPasswordPasswordOutputReference;
    putPassword(value: GoogleIntegrationConnectorsConnectionAuthConfigUserPasswordPassword): void;
    resetPassword(): void;
    get passwordInput(): GoogleIntegrationConnectorsConnectionAuthConfigUserPasswordPassword | undefined;
}
export interface GoogleIntegrationConnectorsConnectionAuthConfig {
    /**
    * The type of authentication configured.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_integration_connectors_connection#auth_key GoogleIntegrationConnectorsConnection#auth_key}
    */
    readonly authKey?: string;
    /**
    * authType of the Connection Possible values: ["USER_PASSWORD", "OAUTH2_JWT_BEARER", "OAUTH2_CLIENT_CREDENTIALS", "SSH_PUBLIC_KEY", "OAUTH2_AUTH_CODE_FLOW"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_integration_connectors_connection#auth_type GoogleIntegrationConnectorsConnection#auth_type}
    */
    readonly authType: string;
    /**
    * additional_variable block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_integration_connectors_connection#additional_variable GoogleIntegrationConnectorsConnection#additional_variable}
    */
    readonly additionalVariable?: GoogleIntegrationConnectorsConnectionAuthConfigAdditionalVariable[] | cdktf.IResolvable;
    /**
    * oauth2_auth_code_flow block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_integration_connectors_connection#oauth2_auth_code_flow GoogleIntegrationConnectorsConnection#oauth2_auth_code_flow}
    */
    readonly oauth2AuthCodeFlow?: GoogleIntegrationConnectorsConnectionAuthConfigOauth2AuthCodeFlow;
    /**
    * oauth2_client_credentials block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_integration_connectors_connection#oauth2_client_credentials GoogleIntegrationConnectorsConnection#oauth2_client_credentials}
    */
    readonly oauth2ClientCredentials?: GoogleIntegrationConnectorsConnectionAuthConfigOauth2ClientCredentials;
    /**
    * oauth2_jwt_bearer block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_integration_connectors_connection#oauth2_jwt_bearer GoogleIntegrationConnectorsConnection#oauth2_jwt_bearer}
    */
    readonly oauth2JwtBearer?: GoogleIntegrationConnectorsConnectionAuthConfigOauth2JwtBearer;
    /**
    * ssh_public_key block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_integration_connectors_connection#ssh_public_key GoogleIntegrationConnectorsConnection#ssh_public_key}
    */
    readonly sshPublicKey?: GoogleIntegrationConnectorsConnectionAuthConfigSshPublicKey;
    /**
    * user_password block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_integration_connectors_connection#user_password GoogleIntegrationConnectorsConnection#user_password}
    */
    readonly userPassword?: GoogleIntegrationConnectorsConnectionAuthConfigUserPassword;
}
export declare function googleIntegrationConnectorsConnectionAuthConfigToTerraform(struct?: GoogleIntegrationConnectorsConnectionAuthConfigOutputReference | GoogleIntegrationConnectorsConnectionAuthConfig): any;
export declare function googleIntegrationConnectorsConnectionAuthConfigToHclTerraform(struct?: GoogleIntegrationConnectorsConnectionAuthConfigOutputReference | GoogleIntegrationConnectorsConnectionAuthConfig): any;
export declare class GoogleIntegrationConnectorsConnectionAuthConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleIntegrationConnectorsConnectionAuthConfig | undefined;
    set internalValue(value: GoogleIntegrationConnectorsConnectionAuthConfig | undefined);
    private _authKey?;
    get authKey(): string;
    set authKey(value: string);
    resetAuthKey(): void;
    get authKeyInput(): string | undefined;
    private _authType?;
    get authType(): string;
    set authType(value: string);
    get authTypeInput(): string | undefined;
    private _additionalVariable;
    get additionalVariable(): GoogleIntegrationConnectorsConnectionAuthConfigAdditionalVariableList;
    putAdditionalVariable(value: GoogleIntegrationConnectorsConnectionAuthConfigAdditionalVariable[] | cdktf.IResolvable): void;
    resetAdditionalVariable(): void;
    get additionalVariableInput(): cdktf.IResolvable | GoogleIntegrationConnectorsConnectionAuthConfigAdditionalVariable[] | undefined;
    private _oauth2AuthCodeFlow;
    get oauth2AuthCodeFlow(): GoogleIntegrationConnectorsConnectionAuthConfigOauth2AuthCodeFlowOutputReference;
    putOauth2AuthCodeFlow(value: GoogleIntegrationConnectorsConnectionAuthConfigOauth2AuthCodeFlow): void;
    resetOauth2AuthCodeFlow(): void;
    get oauth2AuthCodeFlowInput(): GoogleIntegrationConnectorsConnectionAuthConfigOauth2AuthCodeFlow | undefined;
    private _oauth2ClientCredentials;
    get oauth2ClientCredentials(): GoogleIntegrationConnectorsConnectionAuthConfigOauth2ClientCredentialsOutputReference;
    putOauth2ClientCredentials(value: GoogleIntegrationConnectorsConnectionAuthConfigOauth2ClientCredentials): void;
    resetOauth2ClientCredentials(): void;
    get oauth2ClientCredentialsInput(): GoogleIntegrationConnectorsConnectionAuthConfigOauth2ClientCredentials | undefined;
    private _oauth2JwtBearer;
    get oauth2JwtBearer(): GoogleIntegrationConnectorsConnectionAuthConfigOauth2JwtBearerOutputReference;
    putOauth2JwtBearer(value: GoogleIntegrationConnectorsConnectionAuthConfigOauth2JwtBearer): void;
    resetOauth2JwtBearer(): void;
    get oauth2JwtBearerInput(): GoogleIntegrationConnectorsConnectionAuthConfigOauth2JwtBearer | undefined;
    private _sshPublicKey;
    get sshPublicKey(): GoogleIntegrationConnectorsConnectionAuthConfigSshPublicKeyOutputReference;
    putSshPublicKey(value: GoogleIntegrationConnectorsConnectionAuthConfigSshPublicKey): void;
    resetSshPublicKey(): void;
    get sshPublicKeyInput(): GoogleIntegrationConnectorsConnectionAuthConfigSshPublicKey | undefined;
    private _userPassword;
    get userPassword(): GoogleIntegrationConnectorsConnectionAuthConfigUserPasswordOutputReference;
    putUserPassword(value: GoogleIntegrationConnectorsConnectionAuthConfigUserPassword): void;
    resetUserPassword(): void;
    get userPasswordInput(): GoogleIntegrationConnectorsConnectionAuthConfigUserPassword | undefined;
}
export interface GoogleIntegrationConnectorsConnectionConfigVariableEncryptionKeyValue {
    /**
    * The [KMS key name] with which the content of the Operation is encrypted. The expected
    * format: projects/* /locations/* /keyRings/* /cryptoKeys/*.
    * Will be empty string if google managed.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_integration_connectors_connection#kms_key_name GoogleIntegrationConnectorsConnection#kms_key_name}
     *
    * Note: The above comment contained a comment block ending sequence (* followed by /). We have introduced a space between to prevent syntax errors. Please ignore the space.
    */
    readonly kmsKeyName?: string;
    /**
    * Type of Encription Key Possible values: ["GOOGLE_MANAGED", "CUSTOMER_MANAGED"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_integration_connectors_connection#type GoogleIntegrationConnectorsConnection#type}
    */
    readonly type: string;
}
export declare function googleIntegrationConnectorsConnectionConfigVariableEncryptionKeyValueToTerraform(struct?: GoogleIntegrationConnectorsConnectionConfigVariableEncryptionKeyValueOutputReference | GoogleIntegrationConnectorsConnectionConfigVariableEncryptionKeyValue): any;
export declare function googleIntegrationConnectorsConnectionConfigVariableEncryptionKeyValueToHclTerraform(struct?: GoogleIntegrationConnectorsConnectionConfigVariableEncryptionKeyValueOutputReference | GoogleIntegrationConnectorsConnectionConfigVariableEncryptionKeyValue): any;
export declare class GoogleIntegrationConnectorsConnectionConfigVariableEncryptionKeyValueOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleIntegrationConnectorsConnectionConfigVariableEncryptionKeyValue | undefined;
    set internalValue(value: GoogleIntegrationConnectorsConnectionConfigVariableEncryptionKeyValue | undefined);
    private _kmsKeyName?;
    get kmsKeyName(): string;
    set kmsKeyName(value: string);
    resetKmsKeyName(): void;
    get kmsKeyNameInput(): string | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
}
export interface GoogleIntegrationConnectorsConnectionConfigVariableSecretValue {
    /**
    * Secret version of Secret Value for Config variable.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_integration_connectors_connection#secret_version GoogleIntegrationConnectorsConnection#secret_version}
    */
    readonly secretVersion: string;
}
export declare function googleIntegrationConnectorsConnectionConfigVariableSecretValueToTerraform(struct?: GoogleIntegrationConnectorsConnectionConfigVariableSecretValueOutputReference | GoogleIntegrationConnectorsConnectionConfigVariableSecretValue): any;
export declare function googleIntegrationConnectorsConnectionConfigVariableSecretValueToHclTerraform(struct?: GoogleIntegrationConnectorsConnectionConfigVariableSecretValueOutputReference | GoogleIntegrationConnectorsConnectionConfigVariableSecretValue): any;
export declare class GoogleIntegrationConnectorsConnectionConfigVariableSecretValueOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleIntegrationConnectorsConnectionConfigVariableSecretValue | undefined;
    set internalValue(value: GoogleIntegrationConnectorsConnectionConfigVariableSecretValue | undefined);
    private _secretVersion?;
    get secretVersion(): string;
    set secretVersion(value: string);
    get secretVersionInput(): string | undefined;
}
export interface GoogleIntegrationConnectorsConnectionConfigVariable {
    /**
    * Boolean Value of configVariable
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_integration_connectors_connection#boolean_value GoogleIntegrationConnectorsConnection#boolean_value}
    */
    readonly booleanValue?: boolean | cdktf.IResolvable;
    /**
    * Integer Value of configVariable
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_integration_connectors_connection#integer_value GoogleIntegrationConnectorsConnection#integer_value}
    */
    readonly integerValue?: number;
    /**
    * Key for the configVariable
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_integration_connectors_connection#key GoogleIntegrationConnectorsConnection#key}
    */
    readonly key: string;
    /**
    * String Value of configVariabley
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_integration_connectors_connection#string_value GoogleIntegrationConnectorsConnection#string_value}
    */
    readonly stringValue?: string;
    /**
    * encryption_key_value block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_integration_connectors_connection#encryption_key_value GoogleIntegrationConnectorsConnection#encryption_key_value}
    */
    readonly encryptionKeyValue?: GoogleIntegrationConnectorsConnectionConfigVariableEncryptionKeyValue;
    /**
    * secret_value block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_integration_connectors_connection#secret_value GoogleIntegrationConnectorsConnection#secret_value}
    */
    readonly secretValue?: GoogleIntegrationConnectorsConnectionConfigVariableSecretValue;
}
export declare function googleIntegrationConnectorsConnectionConfigVariableToTerraform(struct?: GoogleIntegrationConnectorsConnectionConfigVariable | cdktf.IResolvable): any;
export declare function googleIntegrationConnectorsConnectionConfigVariableToHclTerraform(struct?: GoogleIntegrationConnectorsConnectionConfigVariable | cdktf.IResolvable): any;
export declare class GoogleIntegrationConnectorsConnectionConfigVariableOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleIntegrationConnectorsConnectionConfigVariable | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleIntegrationConnectorsConnectionConfigVariable | cdktf.IResolvable | undefined);
    private _booleanValue?;
    get booleanValue(): boolean | cdktf.IResolvable;
    set booleanValue(value: boolean | cdktf.IResolvable);
    resetBooleanValue(): void;
    get booleanValueInput(): boolean | cdktf.IResolvable | undefined;
    private _integerValue?;
    get integerValue(): number;
    set integerValue(value: number);
    resetIntegerValue(): void;
    get integerValueInput(): number | undefined;
    private _key?;
    get key(): string;
    set key(value: string);
    get keyInput(): string | undefined;
    private _stringValue?;
    get stringValue(): string;
    set stringValue(value: string);
    resetStringValue(): void;
    get stringValueInput(): string | undefined;
    private _encryptionKeyValue;
    get encryptionKeyValue(): GoogleIntegrationConnectorsConnectionConfigVariableEncryptionKeyValueOutputReference;
    putEncryptionKeyValue(value: GoogleIntegrationConnectorsConnectionConfigVariableEncryptionKeyValue): void;
    resetEncryptionKeyValue(): void;
    get encryptionKeyValueInput(): GoogleIntegrationConnectorsConnectionConfigVariableEncryptionKeyValue | undefined;
    private _secretValue;
    get secretValue(): GoogleIntegrationConnectorsConnectionConfigVariableSecretValueOutputReference;
    putSecretValue(value: GoogleIntegrationConnectorsConnectionConfigVariableSecretValue): void;
    resetSecretValue(): void;
    get secretValueInput(): GoogleIntegrationConnectorsConnectionConfigVariableSecretValue | undefined;
}
export declare class GoogleIntegrationConnectorsConnectionConfigVariableList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleIntegrationConnectorsConnectionConfigVariable[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleIntegrationConnectorsConnectionConfigVariableOutputReference;
}
export interface GoogleIntegrationConnectorsConnectionDestinationConfigDestination {
    /**
    * For publicly routable host.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_integration_connectors_connection#host GoogleIntegrationConnectorsConnection#host}
    */
    readonly host?: string;
    /**
    * The port is the target port number that is accepted by the destination.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_integration_connectors_connection#port GoogleIntegrationConnectorsConnection#port}
    */
    readonly port?: number;
    /**
    * PSC service attachments. Format: projects/* /regions/* /serviceAttachments/*
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_integration_connectors_connection#service_attachment GoogleIntegrationConnectorsConnection#service_attachment}
     *
    * Note: The above comment contained a comment block ending sequence (* followed by /). We have introduced a space between to prevent syntax errors. Please ignore the space.
    */
    readonly serviceAttachment?: string;
}
export declare function googleIntegrationConnectorsConnectionDestinationConfigDestinationToTerraform(struct?: GoogleIntegrationConnectorsConnectionDestinationConfigDestination | cdktf.IResolvable): any;
export declare function googleIntegrationConnectorsConnectionDestinationConfigDestinationToHclTerraform(struct?: GoogleIntegrationConnectorsConnectionDestinationConfigDestination | cdktf.IResolvable): any;
export declare class GoogleIntegrationConnectorsConnectionDestinationConfigDestinationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleIntegrationConnectorsConnectionDestinationConfigDestination | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleIntegrationConnectorsConnectionDestinationConfigDestination | cdktf.IResolvable | undefined);
    private _host?;
    get host(): string;
    set host(value: string);
    resetHost(): void;
    get hostInput(): string | undefined;
    private _port?;
    get port(): number;
    set port(value: number);
    resetPort(): void;
    get portInput(): number | undefined;
    private _serviceAttachment?;
    get serviceAttachment(): string;
    set serviceAttachment(value: string);
    resetServiceAttachment(): void;
    get serviceAttachmentInput(): string | undefined;
}
export declare class GoogleIntegrationConnectorsConnectionDestinationConfigDestinationList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleIntegrationConnectorsConnectionDestinationConfigDestination[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleIntegrationConnectorsConnectionDestinationConfigDestinationOutputReference;
}
export interface GoogleIntegrationConnectorsConnectionDestinationConfig {
    /**
    * The key is the destination identifier that is supported by the Connector.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_integration_connectors_connection#key GoogleIntegrationConnectorsConnection#key}
    */
    readonly key: string;
    /**
    * destination block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_integration_connectors_connection#destination GoogleIntegrationConnectorsConnection#destination}
    */
    readonly destination?: GoogleIntegrationConnectorsConnectionDestinationConfigDestination[] | cdktf.IResolvable;
}
export declare function googleIntegrationConnectorsConnectionDestinationConfigToTerraform(struct?: GoogleIntegrationConnectorsConnectionDestinationConfig | cdktf.IResolvable): any;
export declare function googleIntegrationConnectorsConnectionDestinationConfigToHclTerraform(struct?: GoogleIntegrationConnectorsConnectionDestinationConfig | cdktf.IResolvable): any;
export declare class GoogleIntegrationConnectorsConnectionDestinationConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleIntegrationConnectorsConnectionDestinationConfig | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleIntegrationConnectorsConnectionDestinationConfig | cdktf.IResolvable | undefined);
    private _key?;
    get key(): string;
    set key(value: string);
    get keyInput(): string | undefined;
    private _destination;
    get destination(): GoogleIntegrationConnectorsConnectionDestinationConfigDestinationList;
    putDestination(value: GoogleIntegrationConnectorsConnectionDestinationConfigDestination[] | cdktf.IResolvable): void;
    resetDestination(): void;
    get destinationInput(): cdktf.IResolvable | GoogleIntegrationConnectorsConnectionDestinationConfigDestination[] | undefined;
}
export declare class GoogleIntegrationConnectorsConnectionDestinationConfigList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleIntegrationConnectorsConnectionDestinationConfig[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleIntegrationConnectorsConnectionDestinationConfigOutputReference;
}
export interface GoogleIntegrationConnectorsConnectionEventingConfigAdditionalVariableEncryptionKeyValue {
    /**
    * The [KMS key name] with which the content of the Operation is encrypted. The expected
    * format: projects/* /locations/* /keyRings/* /cryptoKeys/*.
    * Will be empty string if google managed.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_integration_connectors_connection#kms_key_name GoogleIntegrationConnectorsConnection#kms_key_name}
     *
    * Note: The above comment contained a comment block ending sequence (* followed by /). We have introduced a space between to prevent syntax errors. Please ignore the space.
    */
    readonly kmsKeyName?: string;
    /**
    * Type of Encryption Key Possible values: ["GOOGLE_MANAGED", "CUSTOMER_MANAGED"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_integration_connectors_connection#type GoogleIntegrationConnectorsConnection#type}
    */
    readonly type?: string;
}
export declare function googleIntegrationConnectorsConnectionEventingConfigAdditionalVariableEncryptionKeyValueToTerraform(struct?: GoogleIntegrationConnectorsConnectionEventingConfigAdditionalVariableEncryptionKeyValueOutputReference | GoogleIntegrationConnectorsConnectionEventingConfigAdditionalVariableEncryptionKeyValue): any;
export declare function googleIntegrationConnectorsConnectionEventingConfigAdditionalVariableEncryptionKeyValueToHclTerraform(struct?: GoogleIntegrationConnectorsConnectionEventingConfigAdditionalVariableEncryptionKeyValueOutputReference | GoogleIntegrationConnectorsConnectionEventingConfigAdditionalVariableEncryptionKeyValue): any;
export declare class GoogleIntegrationConnectorsConnectionEventingConfigAdditionalVariableEncryptionKeyValueOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleIntegrationConnectorsConnectionEventingConfigAdditionalVariableEncryptionKeyValue | undefined;
    set internalValue(value: GoogleIntegrationConnectorsConnectionEventingConfigAdditionalVariableEncryptionKeyValue | undefined);
    private _kmsKeyName?;
    get kmsKeyName(): string;
    set kmsKeyName(value: string);
    resetKmsKeyName(): void;
    get kmsKeyNameInput(): string | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    resetType(): void;
    get typeInput(): string | undefined;
}
export interface GoogleIntegrationConnectorsConnectionEventingConfigAdditionalVariableSecretValue {
    /**
    * Secret version of Secret Value for Config variable.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_integration_connectors_connection#secret_version GoogleIntegrationConnectorsConnection#secret_version}
    */
    readonly secretVersion: string;
}
export declare function googleIntegrationConnectorsConnectionEventingConfigAdditionalVariableSecretValueToTerraform(struct?: GoogleIntegrationConnectorsConnectionEventingConfigAdditionalVariableSecretValueOutputReference | GoogleIntegrationConnectorsConnectionEventingConfigAdditionalVariableSecretValue): any;
export declare function googleIntegrationConnectorsConnectionEventingConfigAdditionalVariableSecretValueToHclTerraform(struct?: GoogleIntegrationConnectorsConnectionEventingConfigAdditionalVariableSecretValueOutputReference | GoogleIntegrationConnectorsConnectionEventingConfigAdditionalVariableSecretValue): any;
export declare class GoogleIntegrationConnectorsConnectionEventingConfigAdditionalVariableSecretValueOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleIntegrationConnectorsConnectionEventingConfigAdditionalVariableSecretValue | undefined;
    set internalValue(value: GoogleIntegrationConnectorsConnectionEventingConfigAdditionalVariableSecretValue | undefined);
    private _secretVersion?;
    get secretVersion(): string;
    set secretVersion(value: string);
    get secretVersionInput(): string | undefined;
}
export interface GoogleIntegrationConnectorsConnectionEventingConfigAdditionalVariable {
    /**
    * Boolean Value of configVariable.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_integration_connectors_connection#boolean_value GoogleIntegrationConnectorsConnection#boolean_value}
    */
    readonly booleanValue?: boolean | cdktf.IResolvable;
    /**
    * Integer Value of configVariable.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_integration_connectors_connection#integer_value GoogleIntegrationConnectorsConnection#integer_value}
    */
    readonly integerValue?: number;
    /**
    * Key for the configVariable
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_integration_connectors_connection#key GoogleIntegrationConnectorsConnection#key}
    */
    readonly key: string;
    /**
    * String Value of configVariabley.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_integration_connectors_connection#string_value GoogleIntegrationConnectorsConnection#string_value}
    */
    readonly stringValue?: string;
    /**
    * encryption_key_value block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_integration_connectors_connection#encryption_key_value GoogleIntegrationConnectorsConnection#encryption_key_value}
    */
    readonly encryptionKeyValue?: GoogleIntegrationConnectorsConnectionEventingConfigAdditionalVariableEncryptionKeyValue;
    /**
    * secret_value block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_integration_connectors_connection#secret_value GoogleIntegrationConnectorsConnection#secret_value}
    */
    readonly secretValue?: GoogleIntegrationConnectorsConnectionEventingConfigAdditionalVariableSecretValue;
}
export declare function googleIntegrationConnectorsConnectionEventingConfigAdditionalVariableToTerraform(struct?: GoogleIntegrationConnectorsConnectionEventingConfigAdditionalVariable | cdktf.IResolvable): any;
export declare function googleIntegrationConnectorsConnectionEventingConfigAdditionalVariableToHclTerraform(struct?: GoogleIntegrationConnectorsConnectionEventingConfigAdditionalVariable | cdktf.IResolvable): any;
export declare class GoogleIntegrationConnectorsConnectionEventingConfigAdditionalVariableOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleIntegrationConnectorsConnectionEventingConfigAdditionalVariable | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleIntegrationConnectorsConnectionEventingConfigAdditionalVariable | cdktf.IResolvable | undefined);
    private _booleanValue?;
    get booleanValue(): boolean | cdktf.IResolvable;
    set booleanValue(value: boolean | cdktf.IResolvable);
    resetBooleanValue(): void;
    get booleanValueInput(): boolean | cdktf.IResolvable | undefined;
    private _integerValue?;
    get integerValue(): number;
    set integerValue(value: number);
    resetIntegerValue(): void;
    get integerValueInput(): number | undefined;
    private _key?;
    get key(): string;
    set key(value: string);
    get keyInput(): string | undefined;
    private _stringValue?;
    get stringValue(): string;
    set stringValue(value: string);
    resetStringValue(): void;
    get stringValueInput(): string | undefined;
    private _encryptionKeyValue;
    get encryptionKeyValue(): GoogleIntegrationConnectorsConnectionEventingConfigAdditionalVariableEncryptionKeyValueOutputReference;
    putEncryptionKeyValue(value: GoogleIntegrationConnectorsConnectionEventingConfigAdditionalVariableEncryptionKeyValue): void;
    resetEncryptionKeyValue(): void;
    get encryptionKeyValueInput(): GoogleIntegrationConnectorsConnectionEventingConfigAdditionalVariableEncryptionKeyValue | undefined;
    private _secretValue;
    get secretValue(): GoogleIntegrationConnectorsConnectionEventingConfigAdditionalVariableSecretValueOutputReference;
    putSecretValue(value: GoogleIntegrationConnectorsConnectionEventingConfigAdditionalVariableSecretValue): void;
    resetSecretValue(): void;
    get secretValueInput(): GoogleIntegrationConnectorsConnectionEventingConfigAdditionalVariableSecretValue | undefined;
}
export declare class GoogleIntegrationConnectorsConnectionEventingConfigAdditionalVariableList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleIntegrationConnectorsConnectionEventingConfigAdditionalVariable[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleIntegrationConnectorsConnectionEventingConfigAdditionalVariableOutputReference;
}
export interface GoogleIntegrationConnectorsConnectionEventingConfigAuthConfigAdditionalVariableEncryptionKeyValue {
    /**
    * The [KMS key name] with which the content of the Operation is encrypted. The expected
    * format: projects/* /locations/* /keyRings/* /cryptoKeys/*.
    * Will be empty string if google managed.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_integration_connectors_connection#kms_key_name GoogleIntegrationConnectorsConnection#kms_key_name}
     *
    * Note: The above comment contained a comment block ending sequence (* followed by /). We have introduced a space between to prevent syntax errors. Please ignore the space.
    */
    readonly kmsKeyName?: string;
    /**
    * Type of Encription Key Possible values: ["GOOGLE_MANAGED", "CUSTOMER_MANAGED"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_integration_connectors_connection#type GoogleIntegrationConnectorsConnection#type}
    */
    readonly type?: string;
}
export declare function googleIntegrationConnectorsConnectionEventingConfigAuthConfigAdditionalVariableEncryptionKeyValueToTerraform(struct?: GoogleIntegrationConnectorsConnectionEventingConfigAuthConfigAdditionalVariableEncryptionKeyValueOutputReference | GoogleIntegrationConnectorsConnectionEventingConfigAuthConfigAdditionalVariableEncryptionKeyValue): any;
export declare function googleIntegrationConnectorsConnectionEventingConfigAuthConfigAdditionalVariableEncryptionKeyValueToHclTerraform(struct?: GoogleIntegrationConnectorsConnectionEventingConfigAuthConfigAdditionalVariableEncryptionKeyValueOutputReference | GoogleIntegrationConnectorsConnectionEventingConfigAuthConfigAdditionalVariableEncryptionKeyValue): any;
export declare class GoogleIntegrationConnectorsConnectionEventingConfigAuthConfigAdditionalVariableEncryptionKeyValueOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleIntegrationConnectorsConnectionEventingConfigAuthConfigAdditionalVariableEncryptionKeyValue | undefined;
    set internalValue(value: GoogleIntegrationConnectorsConnectionEventingConfigAuthConfigAdditionalVariableEncryptionKeyValue | undefined);
    private _kmsKeyName?;
    get kmsKeyName(): string;
    set kmsKeyName(value: string);
    resetKmsKeyName(): void;
    get kmsKeyNameInput(): string | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    resetType(): void;
    get typeInput(): string | undefined;
}
export interface GoogleIntegrationConnectorsConnectionEventingConfigAuthConfigAdditionalVariableSecretValue {
    /**
    * Secret version of Secret Value for Config variable.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_integration_connectors_connection#secret_version GoogleIntegrationConnectorsConnection#secret_version}
    */
    readonly secretVersion: string;
}
export declare function googleIntegrationConnectorsConnectionEventingConfigAuthConfigAdditionalVariableSecretValueToTerraform(struct?: GoogleIntegrationConnectorsConnectionEventingConfigAuthConfigAdditionalVariableSecretValueOutputReference | GoogleIntegrationConnectorsConnectionEventingConfigAuthConfigAdditionalVariableSecretValue): any;
export declare function googleIntegrationConnectorsConnectionEventingConfigAuthConfigAdditionalVariableSecretValueToHclTerraform(struct?: GoogleIntegrationConnectorsConnectionEventingConfigAuthConfigAdditionalVariableSecretValueOutputReference | GoogleIntegrationConnectorsConnectionEventingConfigAuthConfigAdditionalVariableSecretValue): any;
export declare class GoogleIntegrationConnectorsConnectionEventingConfigAuthConfigAdditionalVariableSecretValueOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleIntegrationConnectorsConnectionEventingConfigAuthConfigAdditionalVariableSecretValue | undefined;
    set internalValue(value: GoogleIntegrationConnectorsConnectionEventingConfigAuthConfigAdditionalVariableSecretValue | undefined);
    private _secretVersion?;
    get secretVersion(): string;
    set secretVersion(value: string);
    get secretVersionInput(): string | undefined;
}
export interface GoogleIntegrationConnectorsConnectionEventingConfigAuthConfigAdditionalVariable {
    /**
    * Boolean Value of configVariable.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_integration_connectors_connection#boolean_value GoogleIntegrationConnectorsConnection#boolean_value}
    */
    readonly booleanValue?: boolean | cdktf.IResolvable;
    /**
    * Integer Value of configVariable.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_integration_connectors_connection#integer_value GoogleIntegrationConnectorsConnection#integer_value}
    */
    readonly integerValue?: number;
    /**
    * Key for the configVariable
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_integration_connectors_connection#key GoogleIntegrationConnectorsConnection#key}
    */
    readonly key: string;
    /**
    * String Value of configVariabley.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_integration_connectors_connection#string_value GoogleIntegrationConnectorsConnection#string_value}
    */
    readonly stringValue?: string;
    /**
    * encryption_key_value block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_integration_connectors_connection#encryption_key_value GoogleIntegrationConnectorsConnection#encryption_key_value}
    */
    readonly encryptionKeyValue?: GoogleIntegrationConnectorsConnectionEventingConfigAuthConfigAdditionalVariableEncryptionKeyValue;
    /**
    * secret_value block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_integration_connectors_connection#secret_value GoogleIntegrationConnectorsConnection#secret_value}
    */
    readonly secretValue?: GoogleIntegrationConnectorsConnectionEventingConfigAuthConfigAdditionalVariableSecretValue;
}
export declare function googleIntegrationConnectorsConnectionEventingConfigAuthConfigAdditionalVariableToTerraform(struct?: GoogleIntegrationConnectorsConnectionEventingConfigAuthConfigAdditionalVariable | cdktf.IResolvable): any;
export declare function googleIntegrationConnectorsConnectionEventingConfigAuthConfigAdditionalVariableToHclTerraform(struct?: GoogleIntegrationConnectorsConnectionEventingConfigAuthConfigAdditionalVariable | cdktf.IResolvable): any;
export declare class GoogleIntegrationConnectorsConnectionEventingConfigAuthConfigAdditionalVariableOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleIntegrationConnectorsConnectionEventingConfigAuthConfigAdditionalVariable | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleIntegrationConnectorsConnectionEventingConfigAuthConfigAdditionalVariable | cdktf.IResolvable | undefined);
    private _booleanValue?;
    get booleanValue(): boolean | cdktf.IResolvable;
    set booleanValue(value: boolean | cdktf.IResolvable);
    resetBooleanValue(): void;
    get booleanValueInput(): boolean | cdktf.IResolvable | undefined;
    private _integerValue?;
    get integerValue(): number;
    set integerValue(value: number);
    resetIntegerValue(): void;
    get integerValueInput(): number | undefined;
    private _key?;
    get key(): string;
    set key(value: string);
    get keyInput(): string | undefined;
    private _stringValue?;
    get stringValue(): string;
    set stringValue(value: string);
    resetStringValue(): void;
    get stringValueInput(): string | undefined;
    private _encryptionKeyValue;
    get encryptionKeyValue(): GoogleIntegrationConnectorsConnectionEventingConfigAuthConfigAdditionalVariableEncryptionKeyValueOutputReference;
    putEncryptionKeyValue(value: GoogleIntegrationConnectorsConnectionEventingConfigAuthConfigAdditionalVariableEncryptionKeyValue): void;
    resetEncryptionKeyValue(): void;
    get encryptionKeyValueInput(): GoogleIntegrationConnectorsConnectionEventingConfigAuthConfigAdditionalVariableEncryptionKeyValue | undefined;
    private _secretValue;
    get secretValue(): GoogleIntegrationConnectorsConnectionEventingConfigAuthConfigAdditionalVariableSecretValueOutputReference;
    putSecretValue(value: GoogleIntegrationConnectorsConnectionEventingConfigAuthConfigAdditionalVariableSecretValue): void;
    resetSecretValue(): void;
    get secretValueInput(): GoogleIntegrationConnectorsConnectionEventingConfigAuthConfigAdditionalVariableSecretValue | undefined;
}
export declare class GoogleIntegrationConnectorsConnectionEventingConfigAuthConfigAdditionalVariableList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleIntegrationConnectorsConnectionEventingConfigAuthConfigAdditionalVariable[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleIntegrationConnectorsConnectionEventingConfigAuthConfigAdditionalVariableOutputReference;
}
export interface GoogleIntegrationConnectorsConnectionEventingConfigAuthConfigUserPasswordPassword {
    /**
    * The resource name of the secret version in the format,
    * format as: projects/* /secrets/* /versions/*.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_integration_connectors_connection#secret_version GoogleIntegrationConnectorsConnection#secret_version}
     *
    * Note: The above comment contained a comment block ending sequence (* followed by /). We have introduced a space between to prevent syntax errors. Please ignore the space.
    */
    readonly secretVersion: string;
}
export declare function googleIntegrationConnectorsConnectionEventingConfigAuthConfigUserPasswordPasswordToTerraform(struct?: GoogleIntegrationConnectorsConnectionEventingConfigAuthConfigUserPasswordPasswordOutputReference | GoogleIntegrationConnectorsConnectionEventingConfigAuthConfigUserPasswordPassword): any;
export declare function googleIntegrationConnectorsConnectionEventingConfigAuthConfigUserPasswordPasswordToHclTerraform(struct?: GoogleIntegrationConnectorsConnectionEventingConfigAuthConfigUserPasswordPasswordOutputReference | GoogleIntegrationConnectorsConnectionEventingConfigAuthConfigUserPasswordPassword): any;
export declare class GoogleIntegrationConnectorsConnectionEventingConfigAuthConfigUserPasswordPasswordOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleIntegrationConnectorsConnectionEventingConfigAuthConfigUserPasswordPassword | undefined;
    set internalValue(value: GoogleIntegrationConnectorsConnectionEventingConfigAuthConfigUserPasswordPassword | undefined);
    private _secretVersion?;
    get secretVersion(): string;
    set secretVersion(value: string);
    get secretVersionInput(): string | undefined;
}
export interface GoogleIntegrationConnectorsConnectionEventingConfigAuthConfigUserPassword {
    /**
    * Username for Authentication.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_integration_connectors_connection#username GoogleIntegrationConnectorsConnection#username}
    */
    readonly username?: string;
    /**
    * password block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_integration_connectors_connection#password GoogleIntegrationConnectorsConnection#password}
    */
    readonly password?: GoogleIntegrationConnectorsConnectionEventingConfigAuthConfigUserPasswordPassword;
}
export declare function googleIntegrationConnectorsConnectionEventingConfigAuthConfigUserPasswordToTerraform(struct?: GoogleIntegrationConnectorsConnectionEventingConfigAuthConfigUserPasswordOutputReference | GoogleIntegrationConnectorsConnectionEventingConfigAuthConfigUserPassword): any;
export declare function googleIntegrationConnectorsConnectionEventingConfigAuthConfigUserPasswordToHclTerraform(struct?: GoogleIntegrationConnectorsConnectionEventingConfigAuthConfigUserPasswordOutputReference | GoogleIntegrationConnectorsConnectionEventingConfigAuthConfigUserPassword): any;
export declare class GoogleIntegrationConnectorsConnectionEventingConfigAuthConfigUserPasswordOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleIntegrationConnectorsConnectionEventingConfigAuthConfigUserPassword | undefined;
    set internalValue(value: GoogleIntegrationConnectorsConnectionEventingConfigAuthConfigUserPassword | undefined);
    private _username?;
    get username(): string;
    set username(value: string);
    resetUsername(): void;
    get usernameInput(): string | undefined;
    private _password;
    get password(): GoogleIntegrationConnectorsConnectionEventingConfigAuthConfigUserPasswordPasswordOutputReference;
    putPassword(value: GoogleIntegrationConnectorsConnectionEventingConfigAuthConfigUserPasswordPassword): void;
    resetPassword(): void;
    get passwordInput(): GoogleIntegrationConnectorsConnectionEventingConfigAuthConfigUserPasswordPassword | undefined;
}
export interface GoogleIntegrationConnectorsConnectionEventingConfigAuthConfig {
    /**
    * The type of authentication configured.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_integration_connectors_connection#auth_key GoogleIntegrationConnectorsConnection#auth_key}
    */
    readonly authKey?: string;
    /**
    * authType of the Connection Possible values: ["USER_PASSWORD"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_integration_connectors_connection#auth_type GoogleIntegrationConnectorsConnection#auth_type}
    */
    readonly authType: string;
    /**
    * additional_variable block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_integration_connectors_connection#additional_variable GoogleIntegrationConnectorsConnection#additional_variable}
    */
    readonly additionalVariable?: GoogleIntegrationConnectorsConnectionEventingConfigAuthConfigAdditionalVariable[] | cdktf.IResolvable;
    /**
    * user_password block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_integration_connectors_connection#user_password GoogleIntegrationConnectorsConnection#user_password}
    */
    readonly userPassword: GoogleIntegrationConnectorsConnectionEventingConfigAuthConfigUserPassword;
}
export declare function googleIntegrationConnectorsConnectionEventingConfigAuthConfigToTerraform(struct?: GoogleIntegrationConnectorsConnectionEventingConfigAuthConfigOutputReference | GoogleIntegrationConnectorsConnectionEventingConfigAuthConfig): any;
export declare function googleIntegrationConnectorsConnectionEventingConfigAuthConfigToHclTerraform(struct?: GoogleIntegrationConnectorsConnectionEventingConfigAuthConfigOutputReference | GoogleIntegrationConnectorsConnectionEventingConfigAuthConfig): any;
export declare class GoogleIntegrationConnectorsConnectionEventingConfigAuthConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleIntegrationConnectorsConnectionEventingConfigAuthConfig | undefined;
    set internalValue(value: GoogleIntegrationConnectorsConnectionEventingConfigAuthConfig | undefined);
    private _authKey?;
    get authKey(): string;
    set authKey(value: string);
    resetAuthKey(): void;
    get authKeyInput(): string | undefined;
    private _authType?;
    get authType(): string;
    set authType(value: string);
    get authTypeInput(): string | undefined;
    private _additionalVariable;
    get additionalVariable(): GoogleIntegrationConnectorsConnectionEventingConfigAuthConfigAdditionalVariableList;
    putAdditionalVariable(value: GoogleIntegrationConnectorsConnectionEventingConfigAuthConfigAdditionalVariable[] | cdktf.IResolvable): void;
    resetAdditionalVariable(): void;
    get additionalVariableInput(): cdktf.IResolvable | GoogleIntegrationConnectorsConnectionEventingConfigAuthConfigAdditionalVariable[] | undefined;
    private _userPassword;
    get userPassword(): GoogleIntegrationConnectorsConnectionEventingConfigAuthConfigUserPasswordOutputReference;
    putUserPassword(value: GoogleIntegrationConnectorsConnectionEventingConfigAuthConfigUserPassword): void;
    get userPasswordInput(): GoogleIntegrationConnectorsConnectionEventingConfigAuthConfigUserPassword | undefined;
}
export interface GoogleIntegrationConnectorsConnectionEventingConfigRegistrationDestinationConfigDestination {
    /**
    * Host
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_integration_connectors_connection#host GoogleIntegrationConnectorsConnection#host}
    */
    readonly host?: string;
    /**
    * port number
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_integration_connectors_connection#port GoogleIntegrationConnectorsConnection#port}
    */
    readonly port?: number;
    /**
    * Service Attachment
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_integration_connectors_connection#service_attachment GoogleIntegrationConnectorsConnection#service_attachment}
    */
    readonly serviceAttachment?: string;
}
export declare function googleIntegrationConnectorsConnectionEventingConfigRegistrationDestinationConfigDestinationToTerraform(struct?: GoogleIntegrationConnectorsConnectionEventingConfigRegistrationDestinationConfigDestination | cdktf.IResolvable): any;
export declare function googleIntegrationConnectorsConnectionEventingConfigRegistrationDestinationConfigDestinationToHclTerraform(struct?: GoogleIntegrationConnectorsConnectionEventingConfigRegistrationDestinationConfigDestination | cdktf.IResolvable): any;
export declare class GoogleIntegrationConnectorsConnectionEventingConfigRegistrationDestinationConfigDestinationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleIntegrationConnectorsConnectionEventingConfigRegistrationDestinationConfigDestination | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleIntegrationConnectorsConnectionEventingConfigRegistrationDestinationConfigDestination | cdktf.IResolvable | undefined);
    private _host?;
    get host(): string;
    set host(value: string);
    resetHost(): void;
    get hostInput(): string | undefined;
    private _port?;
    get port(): number;
    set port(value: number);
    resetPort(): void;
    get portInput(): number | undefined;
    private _serviceAttachment?;
    get serviceAttachment(): string;
    set serviceAttachment(value: string);
    resetServiceAttachment(): void;
    get serviceAttachmentInput(): string | undefined;
}
export declare class GoogleIntegrationConnectorsConnectionEventingConfigRegistrationDestinationConfigDestinationList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleIntegrationConnectorsConnectionEventingConfigRegistrationDestinationConfigDestination[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleIntegrationConnectorsConnectionEventingConfigRegistrationDestinationConfigDestinationOutputReference;
}
export interface GoogleIntegrationConnectorsConnectionEventingConfigRegistrationDestinationConfig {
    /**
    * Key for the connection
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_integration_connectors_connection#key GoogleIntegrationConnectorsConnection#key}
    */
    readonly key?: string;
    /**
    * destination block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_integration_connectors_connection#destination GoogleIntegrationConnectorsConnection#destination}
    */
    readonly destination?: GoogleIntegrationConnectorsConnectionEventingConfigRegistrationDestinationConfigDestination[] | cdktf.IResolvable;
}
export declare function googleIntegrationConnectorsConnectionEventingConfigRegistrationDestinationConfigToTerraform(struct?: GoogleIntegrationConnectorsConnectionEventingConfigRegistrationDestinationConfigOutputReference | GoogleIntegrationConnectorsConnectionEventingConfigRegistrationDestinationConfig): any;
export declare function googleIntegrationConnectorsConnectionEventingConfigRegistrationDestinationConfigToHclTerraform(struct?: GoogleIntegrationConnectorsConnectionEventingConfigRegistrationDestinationConfigOutputReference | GoogleIntegrationConnectorsConnectionEventingConfigRegistrationDestinationConfig): any;
export declare class GoogleIntegrationConnectorsConnectionEventingConfigRegistrationDestinationConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleIntegrationConnectorsConnectionEventingConfigRegistrationDestinationConfig | undefined;
    set internalValue(value: GoogleIntegrationConnectorsConnectionEventingConfigRegistrationDestinationConfig | undefined);
    private _key?;
    get key(): string;
    set key(value: string);
    resetKey(): void;
    get keyInput(): string | undefined;
    private _destination;
    get destination(): GoogleIntegrationConnectorsConnectionEventingConfigRegistrationDestinationConfigDestinationList;
    putDestination(value: GoogleIntegrationConnectorsConnectionEventingConfigRegistrationDestinationConfigDestination[] | cdktf.IResolvable): void;
    resetDestination(): void;
    get destinationInput(): cdktf.IResolvable | GoogleIntegrationConnectorsConnectionEventingConfigRegistrationDestinationConfigDestination[] | undefined;
}
export interface GoogleIntegrationConnectorsConnectionEventingConfig {
    /**
    * Enrichment Enabled.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_integration_connectors_connection#enrichment_enabled GoogleIntegrationConnectorsConnection#enrichment_enabled}
    */
    readonly enrichmentEnabled?: boolean | cdktf.IResolvable;
    /**
    * additional_variable block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_integration_connectors_connection#additional_variable GoogleIntegrationConnectorsConnection#additional_variable}
    */
    readonly additionalVariable?: GoogleIntegrationConnectorsConnectionEventingConfigAdditionalVariable[] | cdktf.IResolvable;
    /**
    * auth_config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_integration_connectors_connection#auth_config GoogleIntegrationConnectorsConnection#auth_config}
    */
    readonly authConfig?: GoogleIntegrationConnectorsConnectionEventingConfigAuthConfig;
    /**
    * registration_destination_config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_integration_connectors_connection#registration_destination_config GoogleIntegrationConnectorsConnection#registration_destination_config}
    */
    readonly registrationDestinationConfig: GoogleIntegrationConnectorsConnectionEventingConfigRegistrationDestinationConfig;
}
export declare function googleIntegrationConnectorsConnectionEventingConfigToTerraform(struct?: GoogleIntegrationConnectorsConnectionEventingConfigOutputReference | GoogleIntegrationConnectorsConnectionEventingConfig): any;
export declare function googleIntegrationConnectorsConnectionEventingConfigToHclTerraform(struct?: GoogleIntegrationConnectorsConnectionEventingConfigOutputReference | GoogleIntegrationConnectorsConnectionEventingConfig): any;
export declare class GoogleIntegrationConnectorsConnectionEventingConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleIntegrationConnectorsConnectionEventingConfig | undefined;
    set internalValue(value: GoogleIntegrationConnectorsConnectionEventingConfig | undefined);
    private _enrichmentEnabled?;
    get enrichmentEnabled(): boolean | cdktf.IResolvable;
    set enrichmentEnabled(value: boolean | cdktf.IResolvable);
    resetEnrichmentEnabled(): void;
    get enrichmentEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _additionalVariable;
    get additionalVariable(): GoogleIntegrationConnectorsConnectionEventingConfigAdditionalVariableList;
    putAdditionalVariable(value: GoogleIntegrationConnectorsConnectionEventingConfigAdditionalVariable[] | cdktf.IResolvable): void;
    resetAdditionalVariable(): void;
    get additionalVariableInput(): cdktf.IResolvable | GoogleIntegrationConnectorsConnectionEventingConfigAdditionalVariable[] | undefined;
    private _authConfig;
    get authConfig(): GoogleIntegrationConnectorsConnectionEventingConfigAuthConfigOutputReference;
    putAuthConfig(value: GoogleIntegrationConnectorsConnectionEventingConfigAuthConfig): void;
    resetAuthConfig(): void;
    get authConfigInput(): GoogleIntegrationConnectorsConnectionEventingConfigAuthConfig | undefined;
    private _registrationDestinationConfig;
    get registrationDestinationConfig(): GoogleIntegrationConnectorsConnectionEventingConfigRegistrationDestinationConfigOutputReference;
    putRegistrationDestinationConfig(value: GoogleIntegrationConnectorsConnectionEventingConfigRegistrationDestinationConfig): void;
    get registrationDestinationConfigInput(): GoogleIntegrationConnectorsConnectionEventingConfigRegistrationDestinationConfig | undefined;
}
export interface GoogleIntegrationConnectorsConnectionLockConfig {
    /**
    * Indicates whether or not the connection is locked.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_integration_connectors_connection#locked GoogleIntegrationConnectorsConnection#locked}
    */
    readonly locked: boolean | cdktf.IResolvable;
    /**
    * Describes why a connection is locked.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_integration_connectors_connection#reason GoogleIntegrationConnectorsConnection#reason}
    */
    readonly reason?: string;
}
export declare function googleIntegrationConnectorsConnectionLockConfigToTerraform(struct?: GoogleIntegrationConnectorsConnectionLockConfigOutputReference | GoogleIntegrationConnectorsConnectionLockConfig): any;
export declare function googleIntegrationConnectorsConnectionLockConfigToHclTerraform(struct?: GoogleIntegrationConnectorsConnectionLockConfigOutputReference | GoogleIntegrationConnectorsConnectionLockConfig): any;
export declare class GoogleIntegrationConnectorsConnectionLockConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleIntegrationConnectorsConnectionLockConfig | undefined;
    set internalValue(value: GoogleIntegrationConnectorsConnectionLockConfig | undefined);
    private _locked?;
    get locked(): boolean | cdktf.IResolvable;
    set locked(value: boolean | cdktf.IResolvable);
    get lockedInput(): boolean | cdktf.IResolvable | undefined;
    private _reason?;
    get reason(): string;
    set reason(value: string);
    resetReason(): void;
    get reasonInput(): string | undefined;
}
export interface GoogleIntegrationConnectorsConnectionLogConfig {
    /**
    * Enabled represents whether logging is enabled or not for a connection.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_integration_connectors_connection#enabled GoogleIntegrationConnectorsConnection#enabled}
    */
    readonly enabled: boolean | cdktf.IResolvable;
}
export declare function googleIntegrationConnectorsConnectionLogConfigToTerraform(struct?: GoogleIntegrationConnectorsConnectionLogConfigOutputReference | GoogleIntegrationConnectorsConnectionLogConfig): any;
export declare function googleIntegrationConnectorsConnectionLogConfigToHclTerraform(struct?: GoogleIntegrationConnectorsConnectionLogConfigOutputReference | GoogleIntegrationConnectorsConnectionLogConfig): any;
export declare class GoogleIntegrationConnectorsConnectionLogConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleIntegrationConnectorsConnectionLogConfig | undefined;
    set internalValue(value: GoogleIntegrationConnectorsConnectionLogConfig | undefined);
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
}
export interface GoogleIntegrationConnectorsConnectionNodeConfig {
    /**
    * Minimum number of nodes in the runtime nodes.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_integration_connectors_connection#max_node_count GoogleIntegrationConnectorsConnection#max_node_count}
    */
    readonly maxNodeCount?: number;
    /**
    * Minimum number of nodes in the runtime nodes.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_integration_connectors_connection#min_node_count GoogleIntegrationConnectorsConnection#min_node_count}
    */
    readonly minNodeCount?: number;
}
export declare function googleIntegrationConnectorsConnectionNodeConfigToTerraform(struct?: GoogleIntegrationConnectorsConnectionNodeConfigOutputReference | GoogleIntegrationConnectorsConnectionNodeConfig): any;
export declare function googleIntegrationConnectorsConnectionNodeConfigToHclTerraform(struct?: GoogleIntegrationConnectorsConnectionNodeConfigOutputReference | GoogleIntegrationConnectorsConnectionNodeConfig): any;
export declare class GoogleIntegrationConnectorsConnectionNodeConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleIntegrationConnectorsConnectionNodeConfig | undefined;
    set internalValue(value: GoogleIntegrationConnectorsConnectionNodeConfig | undefined);
    private _maxNodeCount?;
    get maxNodeCount(): number;
    set maxNodeCount(value: number);
    resetMaxNodeCount(): void;
    get maxNodeCountInput(): number | undefined;
    private _minNodeCount?;
    get minNodeCount(): number;
    set minNodeCount(value: number);
    resetMinNodeCount(): void;
    get minNodeCountInput(): number | undefined;
}
export interface GoogleIntegrationConnectorsConnectionSslConfigAdditionalVariableEncryptionKeyValue {
    /**
    * The [KMS key name] with which the content of the Operation is encrypted. The expected
    * format: projects/* /locations/* /keyRings/* /cryptoKeys/*.
    * Will be empty string if google managed.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_integration_connectors_connection#kms_key_name GoogleIntegrationConnectorsConnection#kms_key_name}
     *
    * Note: The above comment contained a comment block ending sequence (* followed by /). We have introduced a space between to prevent syntax errors. Please ignore the space.
    */
    readonly kmsKeyName?: string;
    /**
    * Type of Encription Key Possible values: ["GOOGLE_MANAGED", "CUSTOMER_MANAGED"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_integration_connectors_connection#type GoogleIntegrationConnectorsConnection#type}
    */
    readonly type?: string;
}
export declare function googleIntegrationConnectorsConnectionSslConfigAdditionalVariableEncryptionKeyValueToTerraform(struct?: GoogleIntegrationConnectorsConnectionSslConfigAdditionalVariableEncryptionKeyValueOutputReference | GoogleIntegrationConnectorsConnectionSslConfigAdditionalVariableEncryptionKeyValue): any;
export declare function googleIntegrationConnectorsConnectionSslConfigAdditionalVariableEncryptionKeyValueToHclTerraform(struct?: GoogleIntegrationConnectorsConnectionSslConfigAdditionalVariableEncryptionKeyValueOutputReference | GoogleIntegrationConnectorsConnectionSslConfigAdditionalVariableEncryptionKeyValue): any;
export declare class GoogleIntegrationConnectorsConnectionSslConfigAdditionalVariableEncryptionKeyValueOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleIntegrationConnectorsConnectionSslConfigAdditionalVariableEncryptionKeyValue | undefined;
    set internalValue(value: GoogleIntegrationConnectorsConnectionSslConfigAdditionalVariableEncryptionKeyValue | undefined);
    private _kmsKeyName?;
    get kmsKeyName(): string;
    set kmsKeyName(value: string);
    resetKmsKeyName(): void;
    get kmsKeyNameInput(): string | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    resetType(): void;
    get typeInput(): string | undefined;
}
export interface GoogleIntegrationConnectorsConnectionSslConfigAdditionalVariableSecretValue {
    /**
    * Secret version of Secret Value for Config variable.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_integration_connectors_connection#secret_version GoogleIntegrationConnectorsConnection#secret_version}
    */
    readonly secretVersion: string;
}
export declare function googleIntegrationConnectorsConnectionSslConfigAdditionalVariableSecretValueToTerraform(struct?: GoogleIntegrationConnectorsConnectionSslConfigAdditionalVariableSecretValueOutputReference | GoogleIntegrationConnectorsConnectionSslConfigAdditionalVariableSecretValue): any;
export declare function googleIntegrationConnectorsConnectionSslConfigAdditionalVariableSecretValueToHclTerraform(struct?: GoogleIntegrationConnectorsConnectionSslConfigAdditionalVariableSecretValueOutputReference | GoogleIntegrationConnectorsConnectionSslConfigAdditionalVariableSecretValue): any;
export declare class GoogleIntegrationConnectorsConnectionSslConfigAdditionalVariableSecretValueOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleIntegrationConnectorsConnectionSslConfigAdditionalVariableSecretValue | undefined;
    set internalValue(value: GoogleIntegrationConnectorsConnectionSslConfigAdditionalVariableSecretValue | undefined);
    private _secretVersion?;
    get secretVersion(): string;
    set secretVersion(value: string);
    get secretVersionInput(): string | undefined;
}
export interface GoogleIntegrationConnectorsConnectionSslConfigAdditionalVariable {
    /**
    * Boolean Value of configVariable.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_integration_connectors_connection#boolean_value GoogleIntegrationConnectorsConnection#boolean_value}
    */
    readonly booleanValue?: boolean | cdktf.IResolvable;
    /**
    * Integer Value of configVariable.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_integration_connectors_connection#integer_value GoogleIntegrationConnectorsConnection#integer_value}
    */
    readonly integerValue?: number;
    /**
    * Key for the configVariable
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_integration_connectors_connection#key GoogleIntegrationConnectorsConnection#key}
    */
    readonly key: string;
    /**
    * String Value of configVariabley.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_integration_connectors_connection#string_value GoogleIntegrationConnectorsConnection#string_value}
    */
    readonly stringValue?: string;
    /**
    * encryption_key_value block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_integration_connectors_connection#encryption_key_value GoogleIntegrationConnectorsConnection#encryption_key_value}
    */
    readonly encryptionKeyValue?: GoogleIntegrationConnectorsConnectionSslConfigAdditionalVariableEncryptionKeyValue;
    /**
    * secret_value block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_integration_connectors_connection#secret_value GoogleIntegrationConnectorsConnection#secret_value}
    */
    readonly secretValue?: GoogleIntegrationConnectorsConnectionSslConfigAdditionalVariableSecretValue;
}
export declare function googleIntegrationConnectorsConnectionSslConfigAdditionalVariableToTerraform(struct?: GoogleIntegrationConnectorsConnectionSslConfigAdditionalVariable | cdktf.IResolvable): any;
export declare function googleIntegrationConnectorsConnectionSslConfigAdditionalVariableToHclTerraform(struct?: GoogleIntegrationConnectorsConnectionSslConfigAdditionalVariable | cdktf.IResolvable): any;
export declare class GoogleIntegrationConnectorsConnectionSslConfigAdditionalVariableOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleIntegrationConnectorsConnectionSslConfigAdditionalVariable | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleIntegrationConnectorsConnectionSslConfigAdditionalVariable | cdktf.IResolvable | undefined);
    private _booleanValue?;
    get booleanValue(): boolean | cdktf.IResolvable;
    set booleanValue(value: boolean | cdktf.IResolvable);
    resetBooleanValue(): void;
    get booleanValueInput(): boolean | cdktf.IResolvable | undefined;
    private _integerValue?;
    get integerValue(): number;
    set integerValue(value: number);
    resetIntegerValue(): void;
    get integerValueInput(): number | undefined;
    private _key?;
    get key(): string;
    set key(value: string);
    get keyInput(): string | undefined;
    private _stringValue?;
    get stringValue(): string;
    set stringValue(value: string);
    resetStringValue(): void;
    get stringValueInput(): string | undefined;
    private _encryptionKeyValue;
    get encryptionKeyValue(): GoogleIntegrationConnectorsConnectionSslConfigAdditionalVariableEncryptionKeyValueOutputReference;
    putEncryptionKeyValue(value: GoogleIntegrationConnectorsConnectionSslConfigAdditionalVariableEncryptionKeyValue): void;
    resetEncryptionKeyValue(): void;
    get encryptionKeyValueInput(): GoogleIntegrationConnectorsConnectionSslConfigAdditionalVariableEncryptionKeyValue | undefined;
    private _secretValue;
    get secretValue(): GoogleIntegrationConnectorsConnectionSslConfigAdditionalVariableSecretValueOutputReference;
    putSecretValue(value: GoogleIntegrationConnectorsConnectionSslConfigAdditionalVariableSecretValue): void;
    resetSecretValue(): void;
    get secretValueInput(): GoogleIntegrationConnectorsConnectionSslConfigAdditionalVariableSecretValue | undefined;
}
export declare class GoogleIntegrationConnectorsConnectionSslConfigAdditionalVariableList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleIntegrationConnectorsConnectionSslConfigAdditionalVariable[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleIntegrationConnectorsConnectionSslConfigAdditionalVariableOutputReference;
}
export interface GoogleIntegrationConnectorsConnectionSslConfigClientCertificate {
    /**
    * Secret version of Secret Value for Config variable.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_integration_connectors_connection#secret_version GoogleIntegrationConnectorsConnection#secret_version}
    */
    readonly secretVersion: string;
}
export declare function googleIntegrationConnectorsConnectionSslConfigClientCertificateToTerraform(struct?: GoogleIntegrationConnectorsConnectionSslConfigClientCertificateOutputReference | GoogleIntegrationConnectorsConnectionSslConfigClientCertificate): any;
export declare function googleIntegrationConnectorsConnectionSslConfigClientCertificateToHclTerraform(struct?: GoogleIntegrationConnectorsConnectionSslConfigClientCertificateOutputReference | GoogleIntegrationConnectorsConnectionSslConfigClientCertificate): any;
export declare class GoogleIntegrationConnectorsConnectionSslConfigClientCertificateOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleIntegrationConnectorsConnectionSslConfigClientCertificate | undefined;
    set internalValue(value: GoogleIntegrationConnectorsConnectionSslConfigClientCertificate | undefined);
    private _secretVersion?;
    get secretVersion(): string;
    set secretVersion(value: string);
    get secretVersionInput(): string | undefined;
}
export interface GoogleIntegrationConnectorsConnectionSslConfigClientPrivateKey {
    /**
    * Secret version of Secret Value for Config variable.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_integration_connectors_connection#secret_version GoogleIntegrationConnectorsConnection#secret_version}
    */
    readonly secretVersion: string;
}
export declare function googleIntegrationConnectorsConnectionSslConfigClientPrivateKeyToTerraform(struct?: GoogleIntegrationConnectorsConnectionSslConfigClientPrivateKeyOutputReference | GoogleIntegrationConnectorsConnectionSslConfigClientPrivateKey): any;
export declare function googleIntegrationConnectorsConnectionSslConfigClientPrivateKeyToHclTerraform(struct?: GoogleIntegrationConnectorsConnectionSslConfigClientPrivateKeyOutputReference | GoogleIntegrationConnectorsConnectionSslConfigClientPrivateKey): any;
export declare class GoogleIntegrationConnectorsConnectionSslConfigClientPrivateKeyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleIntegrationConnectorsConnectionSslConfigClientPrivateKey | undefined;
    set internalValue(value: GoogleIntegrationConnectorsConnectionSslConfigClientPrivateKey | undefined);
    private _secretVersion?;
    get secretVersion(): string;
    set secretVersion(value: string);
    get secretVersionInput(): string | undefined;
}
export interface GoogleIntegrationConnectorsConnectionSslConfigClientPrivateKeyPass {
    /**
    * Secret version of Secret Value for Config variable.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_integration_connectors_connection#secret_version GoogleIntegrationConnectorsConnection#secret_version}
    */
    readonly secretVersion: string;
}
export declare function googleIntegrationConnectorsConnectionSslConfigClientPrivateKeyPassToTerraform(struct?: GoogleIntegrationConnectorsConnectionSslConfigClientPrivateKeyPassOutputReference | GoogleIntegrationConnectorsConnectionSslConfigClientPrivateKeyPass): any;
export declare function googleIntegrationConnectorsConnectionSslConfigClientPrivateKeyPassToHclTerraform(struct?: GoogleIntegrationConnectorsConnectionSslConfigClientPrivateKeyPassOutputReference | GoogleIntegrationConnectorsConnectionSslConfigClientPrivateKeyPass): any;
export declare class GoogleIntegrationConnectorsConnectionSslConfigClientPrivateKeyPassOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleIntegrationConnectorsConnectionSslConfigClientPrivateKeyPass | undefined;
    set internalValue(value: GoogleIntegrationConnectorsConnectionSslConfigClientPrivateKeyPass | undefined);
    private _secretVersion?;
    get secretVersion(): string;
    set secretVersion(value: string);
    get secretVersionInput(): string | undefined;
}
export interface GoogleIntegrationConnectorsConnectionSslConfigPrivateServerCertificate {
    /**
    * Secret version of Secret Value for Config variable.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_integration_connectors_connection#secret_version GoogleIntegrationConnectorsConnection#secret_version}
    */
    readonly secretVersion: string;
}
export declare function googleIntegrationConnectorsConnectionSslConfigPrivateServerCertificateToTerraform(struct?: GoogleIntegrationConnectorsConnectionSslConfigPrivateServerCertificateOutputReference | GoogleIntegrationConnectorsConnectionSslConfigPrivateServerCertificate): any;
export declare function googleIntegrationConnectorsConnectionSslConfigPrivateServerCertificateToHclTerraform(struct?: GoogleIntegrationConnectorsConnectionSslConfigPrivateServerCertificateOutputReference | GoogleIntegrationConnectorsConnectionSslConfigPrivateServerCertificate): any;
export declare class GoogleIntegrationConnectorsConnectionSslConfigPrivateServerCertificateOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleIntegrationConnectorsConnectionSslConfigPrivateServerCertificate | undefined;
    set internalValue(value: GoogleIntegrationConnectorsConnectionSslConfigPrivateServerCertificate | undefined);
    private _secretVersion?;
    get secretVersion(): string;
    set secretVersion(value: string);
    get secretVersionInput(): string | undefined;
}
export interface GoogleIntegrationConnectorsConnectionSslConfig {
    /**
    * Type of Client Cert (PEM/JKS/.. etc.) Possible values: ["PEM"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_integration_connectors_connection#client_cert_type GoogleIntegrationConnectorsConnection#client_cert_type}
    */
    readonly clientCertType?: string;
    /**
    * Type of Server Cert (PEM/JKS/.. etc.) Possible values: ["PEM"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_integration_connectors_connection#server_cert_type GoogleIntegrationConnectorsConnection#server_cert_type}
    */
    readonly serverCertType?: string;
    /**
    * Enum for Trust Model Possible values: ["PUBLIC", "PRIVATE", "INSECURE"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_integration_connectors_connection#trust_model GoogleIntegrationConnectorsConnection#trust_model}
    */
    readonly trustModel?: string;
    /**
    * Enum for controlling the SSL Type (TLS/MTLS) Possible values: ["TLS", "MTLS"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_integration_connectors_connection#type GoogleIntegrationConnectorsConnection#type}
    */
    readonly type: string;
    /**
    * Bool for enabling SSL
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_integration_connectors_connection#use_ssl GoogleIntegrationConnectorsConnection#use_ssl}
    */
    readonly useSsl?: boolean | cdktf.IResolvable;
    /**
    * additional_variable block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_integration_connectors_connection#additional_variable GoogleIntegrationConnectorsConnection#additional_variable}
    */
    readonly additionalVariable?: GoogleIntegrationConnectorsConnectionSslConfigAdditionalVariable[] | cdktf.IResolvable;
    /**
    * client_certificate block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_integration_connectors_connection#client_certificate GoogleIntegrationConnectorsConnection#client_certificate}
    */
    readonly clientCertificate?: GoogleIntegrationConnectorsConnectionSslConfigClientCertificate;
    /**
    * client_private_key block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_integration_connectors_connection#client_private_key GoogleIntegrationConnectorsConnection#client_private_key}
    */
    readonly clientPrivateKey?: GoogleIntegrationConnectorsConnectionSslConfigClientPrivateKey;
    /**
    * client_private_key_pass block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_integration_connectors_connection#client_private_key_pass GoogleIntegrationConnectorsConnection#client_private_key_pass}
    */
    readonly clientPrivateKeyPass?: GoogleIntegrationConnectorsConnectionSslConfigClientPrivateKeyPass;
    /**
    * private_server_certificate block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_integration_connectors_connection#private_server_certificate GoogleIntegrationConnectorsConnection#private_server_certificate}
    */
    readonly privateServerCertificate?: GoogleIntegrationConnectorsConnectionSslConfigPrivateServerCertificate;
}
export declare function googleIntegrationConnectorsConnectionSslConfigToTerraform(struct?: GoogleIntegrationConnectorsConnectionSslConfigOutputReference | GoogleIntegrationConnectorsConnectionSslConfig): any;
export declare function googleIntegrationConnectorsConnectionSslConfigToHclTerraform(struct?: GoogleIntegrationConnectorsConnectionSslConfigOutputReference | GoogleIntegrationConnectorsConnectionSslConfig): any;
export declare class GoogleIntegrationConnectorsConnectionSslConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleIntegrationConnectorsConnectionSslConfig | undefined;
    set internalValue(value: GoogleIntegrationConnectorsConnectionSslConfig | undefined);
    private _clientCertType?;
    get clientCertType(): string;
    set clientCertType(value: string);
    resetClientCertType(): void;
    get clientCertTypeInput(): string | undefined;
    private _serverCertType?;
    get serverCertType(): string;
    set serverCertType(value: string);
    resetServerCertType(): void;
    get serverCertTypeInput(): string | undefined;
    private _trustModel?;
    get trustModel(): string;
    set trustModel(value: string);
    resetTrustModel(): void;
    get trustModelInput(): string | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
    private _useSsl?;
    get useSsl(): boolean | cdktf.IResolvable;
    set useSsl(value: boolean | cdktf.IResolvable);
    resetUseSsl(): void;
    get useSslInput(): boolean | cdktf.IResolvable | undefined;
    private _additionalVariable;
    get additionalVariable(): GoogleIntegrationConnectorsConnectionSslConfigAdditionalVariableList;
    putAdditionalVariable(value: GoogleIntegrationConnectorsConnectionSslConfigAdditionalVariable[] | cdktf.IResolvable): void;
    resetAdditionalVariable(): void;
    get additionalVariableInput(): cdktf.IResolvable | GoogleIntegrationConnectorsConnectionSslConfigAdditionalVariable[] | undefined;
    private _clientCertificate;
    get clientCertificate(): GoogleIntegrationConnectorsConnectionSslConfigClientCertificateOutputReference;
    putClientCertificate(value: GoogleIntegrationConnectorsConnectionSslConfigClientCertificate): void;
    resetClientCertificate(): void;
    get clientCertificateInput(): GoogleIntegrationConnectorsConnectionSslConfigClientCertificate | undefined;
    private _clientPrivateKey;
    get clientPrivateKey(): GoogleIntegrationConnectorsConnectionSslConfigClientPrivateKeyOutputReference;
    putClientPrivateKey(value: GoogleIntegrationConnectorsConnectionSslConfigClientPrivateKey): void;
    resetClientPrivateKey(): void;
    get clientPrivateKeyInput(): GoogleIntegrationConnectorsConnectionSslConfigClientPrivateKey | undefined;
    private _clientPrivateKeyPass;
    get clientPrivateKeyPass(): GoogleIntegrationConnectorsConnectionSslConfigClientPrivateKeyPassOutputReference;
    putClientPrivateKeyPass(value: GoogleIntegrationConnectorsConnectionSslConfigClientPrivateKeyPass): void;
    resetClientPrivateKeyPass(): void;
    get clientPrivateKeyPassInput(): GoogleIntegrationConnectorsConnectionSslConfigClientPrivateKeyPass | undefined;
    private _privateServerCertificate;
    get privateServerCertificate(): GoogleIntegrationConnectorsConnectionSslConfigPrivateServerCertificateOutputReference;
    putPrivateServerCertificate(value: GoogleIntegrationConnectorsConnectionSslConfigPrivateServerCertificate): void;
    resetPrivateServerCertificate(): void;
    get privateServerCertificateInput(): GoogleIntegrationConnectorsConnectionSslConfigPrivateServerCertificate | undefined;
}
export interface GoogleIntegrationConnectorsConnectionTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_integration_connectors_connection#create GoogleIntegrationConnectorsConnection#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_integration_connectors_connection#delete GoogleIntegrationConnectorsConnection#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_integration_connectors_connection#update GoogleIntegrationConnectorsConnection#update}
    */
    readonly update?: string;
}
export declare function googleIntegrationConnectorsConnectionTimeoutsToTerraform(struct?: GoogleIntegrationConnectorsConnectionTimeouts | cdktf.IResolvable): any;
export declare function googleIntegrationConnectorsConnectionTimeoutsToHclTerraform(struct?: GoogleIntegrationConnectorsConnectionTimeouts | cdktf.IResolvable): any;
export declare class GoogleIntegrationConnectorsConnectionTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleIntegrationConnectorsConnectionTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleIntegrationConnectorsConnectionTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_integration_connectors_connection google_integration_connectors_connection}
*/
export declare class GoogleIntegrationConnectorsConnection extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_integration_connectors_connection";
    /**
    * Generates CDKTF code for importing a GoogleIntegrationConnectorsConnection resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the GoogleIntegrationConnectorsConnection to import
    * @param importFromId The id of the existing GoogleIntegrationConnectorsConnection that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_integration_connectors_connection#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the GoogleIntegrationConnectorsConnection to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_integration_connectors_connection google_integration_connectors_connection} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleIntegrationConnectorsConnectionConfig
    */
    constructor(scope: Construct, id: string, config: GoogleIntegrationConnectorsConnectionConfig);
    get connectionRevision(): string;
    private _connectorVersion?;
    get connectorVersion(): string;
    set connectorVersion(value: string);
    get connectorVersionInput(): string | undefined;
    private _connectorVersionInfraConfig;
    get connectorVersionInfraConfig(): GoogleIntegrationConnectorsConnectionConnectorVersionInfraConfigList;
    get connectorVersionLaunchStage(): string;
    get createTime(): string;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _effectiveLabels;
    get effectiveLabels(): cdktf.StringMap;
    private _eventingEnablementType?;
    get eventingEnablementType(): string;
    set eventingEnablementType(value: string);
    resetEventingEnablementType(): void;
    get eventingEnablementTypeInput(): string | undefined;
    private _eventingRuntimeData;
    get eventingRuntimeData(): GoogleIntegrationConnectorsConnectionEventingRuntimeDataList;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _labels?;
    get labels(): {
        [key: string]: string;
    };
    set labels(value: {
        [key: string]: string;
    });
    resetLabels(): void;
    get labelsInput(): {
        [key: string]: string;
    } | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _serviceAccount?;
    get serviceAccount(): string;
    set serviceAccount(value: string);
    resetServiceAccount(): void;
    get serviceAccountInput(): string | undefined;
    get serviceDirectory(): string;
    private _status;
    get status(): GoogleIntegrationConnectorsConnectionStatusList;
    get subscriptionType(): string;
    private _suspended?;
    get suspended(): boolean | cdktf.IResolvable;
    set suspended(value: boolean | cdktf.IResolvable);
    resetSuspended(): void;
    get suspendedInput(): boolean | cdktf.IResolvable | undefined;
    private _terraformLabels;
    get terraformLabels(): cdktf.StringMap;
    get updateTime(): string;
    private _authConfig;
    get authConfig(): GoogleIntegrationConnectorsConnectionAuthConfigOutputReference;
    putAuthConfig(value: GoogleIntegrationConnectorsConnectionAuthConfig): void;
    resetAuthConfig(): void;
    get authConfigInput(): GoogleIntegrationConnectorsConnectionAuthConfig | undefined;
    private _configVariable;
    get configVariable(): GoogleIntegrationConnectorsConnectionConfigVariableList;
    putConfigVariable(value: GoogleIntegrationConnectorsConnectionConfigVariable[] | cdktf.IResolvable): void;
    resetConfigVariable(): void;
    get configVariableInput(): cdktf.IResolvable | GoogleIntegrationConnectorsConnectionConfigVariable[] | undefined;
    private _destinationConfig;
    get destinationConfig(): GoogleIntegrationConnectorsConnectionDestinationConfigList;
    putDestinationConfig(value: GoogleIntegrationConnectorsConnectionDestinationConfig[] | cdktf.IResolvable): void;
    resetDestinationConfig(): void;
    get destinationConfigInput(): cdktf.IResolvable | GoogleIntegrationConnectorsConnectionDestinationConfig[] | undefined;
    private _eventingConfig;
    get eventingConfig(): GoogleIntegrationConnectorsConnectionEventingConfigOutputReference;
    putEventingConfig(value: GoogleIntegrationConnectorsConnectionEventingConfig): void;
    resetEventingConfig(): void;
    get eventingConfigInput(): GoogleIntegrationConnectorsConnectionEventingConfig | undefined;
    private _lockConfig;
    get lockConfig(): GoogleIntegrationConnectorsConnectionLockConfigOutputReference;
    putLockConfig(value: GoogleIntegrationConnectorsConnectionLockConfig): void;
    resetLockConfig(): void;
    get lockConfigInput(): GoogleIntegrationConnectorsConnectionLockConfig | undefined;
    private _logConfig;
    get logConfig(): GoogleIntegrationConnectorsConnectionLogConfigOutputReference;
    putLogConfig(value: GoogleIntegrationConnectorsConnectionLogConfig): void;
    resetLogConfig(): void;
    get logConfigInput(): GoogleIntegrationConnectorsConnectionLogConfig | undefined;
    private _nodeConfig;
    get nodeConfig(): GoogleIntegrationConnectorsConnectionNodeConfigOutputReference;
    putNodeConfig(value: GoogleIntegrationConnectorsConnectionNodeConfig): void;
    resetNodeConfig(): void;
    get nodeConfigInput(): GoogleIntegrationConnectorsConnectionNodeConfig | undefined;
    private _sslConfig;
    get sslConfig(): GoogleIntegrationConnectorsConnectionSslConfigOutputReference;
    putSslConfig(value: GoogleIntegrationConnectorsConnectionSslConfig): void;
    resetSslConfig(): void;
    get sslConfigInput(): GoogleIntegrationConnectorsConnectionSslConfig | undefined;
    private _timeouts;
    get timeouts(): GoogleIntegrationConnectorsConnectionTimeoutsOutputReference;
    putTimeouts(value: GoogleIntegrationConnectorsConnectionTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleIntegrationConnectorsConnectionTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
