/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleKmsEkmConnectionConfig extends cdktf.TerraformMetaArguments {
    /**
    * Optional. Identifies the EKM Crypto Space that this EkmConnection maps to. Note: This field is required if KeyManagementMode is CLOUD_KMS.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_kms_ekm_connection#crypto_space_path GoogleKmsEkmConnection#crypto_space_path}
    */
    readonly cryptoSpacePath?: string;
    /**
    * Optional. Etag of the currently stored EkmConnection.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_kms_ekm_connection#etag GoogleKmsEkmConnection#etag}
    */
    readonly etag?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_kms_ekm_connection#id GoogleKmsEkmConnection#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Optional. Describes who can perform control plane operations on the EKM. If unset, this defaults to MANUAL Default value: "MANUAL" Possible values: ["MANUAL", "CLOUD_KMS"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_kms_ekm_connection#key_management_mode GoogleKmsEkmConnection#key_management_mode}
    */
    readonly keyManagementMode?: string;
    /**
    * The location for the EkmConnection.
    * A full list of valid locations can be found by running 'gcloud kms locations list'.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_kms_ekm_connection#location GoogleKmsEkmConnection#location}
    */
    readonly location: string;
    /**
    * The resource name for the EkmConnection.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_kms_ekm_connection#name GoogleKmsEkmConnection#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_kms_ekm_connection#project GoogleKmsEkmConnection#project}
    */
    readonly project?: string;
    /**
    * service_resolvers block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_kms_ekm_connection#service_resolvers GoogleKmsEkmConnection#service_resolvers}
    */
    readonly serviceResolvers: GoogleKmsEkmConnectionServiceResolvers[] | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_kms_ekm_connection#timeouts GoogleKmsEkmConnection#timeouts}
    */
    readonly timeouts?: GoogleKmsEkmConnectionTimeouts;
}
export interface GoogleKmsEkmConnectionServiceResolversServerCertificates {
    /**
    * Required. The raw certificate bytes in DER format. A base64-encoded string.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_kms_ekm_connection#raw_der GoogleKmsEkmConnection#raw_der}
    */
    readonly rawDer: string;
    /**
    * Output only. The subject Alternative DNS names. Only present if parsed is true.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_kms_ekm_connection#subject_alternative_dns_names GoogleKmsEkmConnection#subject_alternative_dns_names}
    */
    readonly subjectAlternativeDnsNames?: string[];
}
export declare function googleKmsEkmConnectionServiceResolversServerCertificatesToTerraform(struct?: GoogleKmsEkmConnectionServiceResolversServerCertificates | cdktf.IResolvable): any;
export declare function googleKmsEkmConnectionServiceResolversServerCertificatesToHclTerraform(struct?: GoogleKmsEkmConnectionServiceResolversServerCertificates | cdktf.IResolvable): any;
export declare class GoogleKmsEkmConnectionServiceResolversServerCertificatesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleKmsEkmConnectionServiceResolversServerCertificates | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleKmsEkmConnectionServiceResolversServerCertificates | cdktf.IResolvable | undefined);
    get issuer(): string;
    get notAfterTime(): string;
    get notBeforeTime(): string;
    get parsed(): cdktf.IResolvable;
    private _rawDer?;
    get rawDer(): string;
    set rawDer(value: string);
    get rawDerInput(): string | undefined;
    get serialNumber(): string;
    get sha256Fingerprint(): string;
    get subject(): string;
    private _subjectAlternativeDnsNames?;
    get subjectAlternativeDnsNames(): string[];
    set subjectAlternativeDnsNames(value: string[]);
    resetSubjectAlternativeDnsNames(): void;
    get subjectAlternativeDnsNamesInput(): string[] | undefined;
}
export declare class GoogleKmsEkmConnectionServiceResolversServerCertificatesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleKmsEkmConnectionServiceResolversServerCertificates[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleKmsEkmConnectionServiceResolversServerCertificatesOutputReference;
}
export interface GoogleKmsEkmConnectionServiceResolvers {
    /**
    * Optional. The filter applied to the endpoints of the resolved service. If no filter is specified, all endpoints will be considered. An endpoint will be chosen arbitrarily from the filtered list for each request. For endpoint filter syntax and examples, see https://cloud.google.com/service-directory/docs/reference/rpc/google.cloud.servicedirectory.v1#resolveservicerequest.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_kms_ekm_connection#endpoint_filter GoogleKmsEkmConnection#endpoint_filter}
    */
    readonly endpointFilter?: string;
    /**
    * Required. The hostname of the EKM replica used at TLS and HTTP layers.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_kms_ekm_connection#hostname GoogleKmsEkmConnection#hostname}
    */
    readonly hostname: string;
    /**
    * Required. The resource name of the Service Directory service pointing to an EKM replica, in the format projects/* /locations/* /namespaces/* /services/*
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_kms_ekm_connection#service_directory_service GoogleKmsEkmConnection#service_directory_service}
     *
    * Note: The above comment contained a comment block ending sequence (* followed by /). We have introduced a space between to prevent syntax errors. Please ignore the space.
    */
    readonly serviceDirectoryService: string;
    /**
    * server_certificates block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_kms_ekm_connection#server_certificates GoogleKmsEkmConnection#server_certificates}
    */
    readonly serverCertificates: GoogleKmsEkmConnectionServiceResolversServerCertificates[] | cdktf.IResolvable;
}
export declare function googleKmsEkmConnectionServiceResolversToTerraform(struct?: GoogleKmsEkmConnectionServiceResolvers | cdktf.IResolvable): any;
export declare function googleKmsEkmConnectionServiceResolversToHclTerraform(struct?: GoogleKmsEkmConnectionServiceResolvers | cdktf.IResolvable): any;
export declare class GoogleKmsEkmConnectionServiceResolversOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleKmsEkmConnectionServiceResolvers | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleKmsEkmConnectionServiceResolvers | cdktf.IResolvable | undefined);
    private _endpointFilter?;
    get endpointFilter(): string;
    set endpointFilter(value: string);
    resetEndpointFilter(): void;
    get endpointFilterInput(): string | undefined;
    private _hostname?;
    get hostname(): string;
    set hostname(value: string);
    get hostnameInput(): string | undefined;
    private _serviceDirectoryService?;
    get serviceDirectoryService(): string;
    set serviceDirectoryService(value: string);
    get serviceDirectoryServiceInput(): string | undefined;
    private _serverCertificates;
    get serverCertificates(): GoogleKmsEkmConnectionServiceResolversServerCertificatesList;
    putServerCertificates(value: GoogleKmsEkmConnectionServiceResolversServerCertificates[] | cdktf.IResolvable): void;
    get serverCertificatesInput(): cdktf.IResolvable | GoogleKmsEkmConnectionServiceResolversServerCertificates[] | undefined;
}
export declare class GoogleKmsEkmConnectionServiceResolversList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleKmsEkmConnectionServiceResolvers[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleKmsEkmConnectionServiceResolversOutputReference;
}
export interface GoogleKmsEkmConnectionTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_kms_ekm_connection#create GoogleKmsEkmConnection#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_kms_ekm_connection#delete GoogleKmsEkmConnection#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_kms_ekm_connection#update GoogleKmsEkmConnection#update}
    */
    readonly update?: string;
}
export declare function googleKmsEkmConnectionTimeoutsToTerraform(struct?: GoogleKmsEkmConnectionTimeouts | cdktf.IResolvable): any;
export declare function googleKmsEkmConnectionTimeoutsToHclTerraform(struct?: GoogleKmsEkmConnectionTimeouts | cdktf.IResolvable): any;
export declare class GoogleKmsEkmConnectionTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleKmsEkmConnectionTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleKmsEkmConnectionTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_kms_ekm_connection google_kms_ekm_connection}
*/
export declare class GoogleKmsEkmConnection extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_kms_ekm_connection";
    /**
    * Generates CDKTF code for importing a GoogleKmsEkmConnection resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the GoogleKmsEkmConnection to import
    * @param importFromId The id of the existing GoogleKmsEkmConnection that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_kms_ekm_connection#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the GoogleKmsEkmConnection to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_kms_ekm_connection google_kms_ekm_connection} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleKmsEkmConnectionConfig
    */
    constructor(scope: Construct, id: string, config: GoogleKmsEkmConnectionConfig);
    get createTime(): string;
    private _cryptoSpacePath?;
    get cryptoSpacePath(): string;
    set cryptoSpacePath(value: string);
    resetCryptoSpacePath(): void;
    get cryptoSpacePathInput(): string | undefined;
    private _etag?;
    get etag(): string;
    set etag(value: string);
    resetEtag(): void;
    get etagInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _keyManagementMode?;
    get keyManagementMode(): string;
    set keyManagementMode(value: string);
    resetKeyManagementMode(): void;
    get keyManagementModeInput(): string | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _serviceResolvers;
    get serviceResolvers(): GoogleKmsEkmConnectionServiceResolversList;
    putServiceResolvers(value: GoogleKmsEkmConnectionServiceResolvers[] | cdktf.IResolvable): void;
    get serviceResolversInput(): cdktf.IResolvable | GoogleKmsEkmConnectionServiceResolvers[] | undefined;
    private _timeouts;
    get timeouts(): GoogleKmsEkmConnectionTimeoutsOutputReference;
    putTimeouts(value: GoogleKmsEkmConnectionTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleKmsEkmConnectionTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
