/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleLoggingFolderSettingsConfig extends cdktf.TerraformMetaArguments {
    /**
    * If set to true, the _Default sink in newly created projects and folders will created in a disabled state. This can be used to automatically disable log storage if there is already an aggregated sink configured in the hierarchy. The _Default sink can be re-enabled manually if needed.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_logging_folder_settings#disable_default_sink GoogleLoggingFolderSettings#disable_default_sink}
    */
    readonly disableDefaultSink?: boolean | cdktf.IResolvable;
    /**
    * The folder for which to retrieve settings.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_logging_folder_settings#folder GoogleLoggingFolderSettings#folder}
    */
    readonly folder: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_logging_folder_settings#id GoogleLoggingFolderSettings#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The resource name for the configured Cloud KMS key.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_logging_folder_settings#kms_key_name GoogleLoggingFolderSettings#kms_key_name}
    */
    readonly kmsKeyName?: string;
    /**
    * The storage location that Cloud Logging will use to create new resources when a location is needed but not explicitly provided.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_logging_folder_settings#storage_location GoogleLoggingFolderSettings#storage_location}
    */
    readonly storageLocation?: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_logging_folder_settings#timeouts GoogleLoggingFolderSettings#timeouts}
    */
    readonly timeouts?: GoogleLoggingFolderSettingsTimeouts;
}
export interface GoogleLoggingFolderSettingsTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_logging_folder_settings#create GoogleLoggingFolderSettings#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_logging_folder_settings#delete GoogleLoggingFolderSettings#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_logging_folder_settings#update GoogleLoggingFolderSettings#update}
    */
    readonly update?: string;
}
export declare function googleLoggingFolderSettingsTimeoutsToTerraform(struct?: GoogleLoggingFolderSettingsTimeouts | cdktf.IResolvable): any;
export declare function googleLoggingFolderSettingsTimeoutsToHclTerraform(struct?: GoogleLoggingFolderSettingsTimeouts | cdktf.IResolvable): any;
export declare class GoogleLoggingFolderSettingsTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleLoggingFolderSettingsTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleLoggingFolderSettingsTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_logging_folder_settings google_logging_folder_settings}
*/
export declare class GoogleLoggingFolderSettings extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_logging_folder_settings";
    /**
    * Generates CDKTF code for importing a GoogleLoggingFolderSettings resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the GoogleLoggingFolderSettings to import
    * @param importFromId The id of the existing GoogleLoggingFolderSettings that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_logging_folder_settings#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the GoogleLoggingFolderSettings to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_logging_folder_settings google_logging_folder_settings} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleLoggingFolderSettingsConfig
    */
    constructor(scope: Construct, id: string, config: GoogleLoggingFolderSettingsConfig);
    private _disableDefaultSink?;
    get disableDefaultSink(): boolean | cdktf.IResolvable;
    set disableDefaultSink(value: boolean | cdktf.IResolvable);
    resetDisableDefaultSink(): void;
    get disableDefaultSinkInput(): boolean | cdktf.IResolvable | undefined;
    private _folder?;
    get folder(): string;
    set folder(value: string);
    get folderInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _kmsKeyName?;
    get kmsKeyName(): string;
    set kmsKeyName(value: string);
    resetKmsKeyName(): void;
    get kmsKeyNameInput(): string | undefined;
    get kmsServiceAccountId(): string;
    get loggingServiceAccountId(): string;
    get name(): string;
    private _storageLocation?;
    get storageLocation(): string;
    set storageLocation(value: string);
    resetStorageLocation(): void;
    get storageLocationInput(): string | undefined;
    private _timeouts;
    get timeouts(): GoogleLoggingFolderSettingsTimeoutsOutputReference;
    putTimeouts(value: GoogleLoggingFolderSettingsTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleLoggingFolderSettingsTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
