/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleLoggingOrganizationBucketConfigConfig extends cdktf.TerraformMetaArguments {
    /**
    * The name of the logging bucket. Logging automatically creates two log buckets: _Required and _Default.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_logging_organization_bucket_config#bucket_id GoogleLoggingOrganizationBucketConfig#bucket_id}
    */
    readonly bucketId: string;
    /**
    * An optional description for this bucket.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_logging_organization_bucket_config#description GoogleLoggingOrganizationBucketConfig#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_logging_organization_bucket_config#id GoogleLoggingOrganizationBucketConfig#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The location of the bucket.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_logging_organization_bucket_config#location GoogleLoggingOrganizationBucketConfig#location}
    */
    readonly location: string;
    /**
    * The parent resource that contains the logging bucket.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_logging_organization_bucket_config#organization GoogleLoggingOrganizationBucketConfig#organization}
    */
    readonly organization: string;
    /**
    * Logs will be retained by default for this amount of time, after which they will automatically be deleted. The minimum retention period is 1 day. If this value is set to zero at bucket creation time, the default time of 30 days will be used.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_logging_organization_bucket_config#retention_days GoogleLoggingOrganizationBucketConfig#retention_days}
    */
    readonly retentionDays?: number;
    /**
    * cmek_settings block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_logging_organization_bucket_config#cmek_settings GoogleLoggingOrganizationBucketConfig#cmek_settings}
    */
    readonly cmekSettings?: GoogleLoggingOrganizationBucketConfigCmekSettings;
    /**
    * index_configs block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_logging_organization_bucket_config#index_configs GoogleLoggingOrganizationBucketConfig#index_configs}
    */
    readonly indexConfigs?: GoogleLoggingOrganizationBucketConfigIndexConfigs[] | cdktf.IResolvable;
}
export interface GoogleLoggingOrganizationBucketConfigCmekSettings {
    /**
    * The resource name for the configured Cloud KMS key.
    * KMS key name format:
    * "projects/[PROJECT_ID]/locations/[LOCATION]/keyRings/[KEYRING]/cryptoKeys/[KEY]"
    * To enable CMEK for the bucket, set this field to a valid kmsKeyName for which the associated service account has the required cloudkms.cryptoKeyEncrypterDecrypter roles assigned for the key.
    * The Cloud KMS key used by the bucket can be updated by changing the kmsKeyName to a new valid key name. Encryption operations that are in progress will be completed with the key that was in use when they started. Decryption operations will be completed using the key that was used at the time of encryption unless access to that key has been revoked.
    * See [Enabling CMEK for Logging Buckets](https://cloud.google.com/logging/docs/routing/managed-encryption-storage) for more information.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_logging_organization_bucket_config#kms_key_name GoogleLoggingOrganizationBucketConfig#kms_key_name}
    */
    readonly kmsKeyName: string;
}
export declare function googleLoggingOrganizationBucketConfigCmekSettingsToTerraform(struct?: GoogleLoggingOrganizationBucketConfigCmekSettingsOutputReference | GoogleLoggingOrganizationBucketConfigCmekSettings): any;
export declare function googleLoggingOrganizationBucketConfigCmekSettingsToHclTerraform(struct?: GoogleLoggingOrganizationBucketConfigCmekSettingsOutputReference | GoogleLoggingOrganizationBucketConfigCmekSettings): any;
export declare class GoogleLoggingOrganizationBucketConfigCmekSettingsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleLoggingOrganizationBucketConfigCmekSettings | undefined;
    set internalValue(value: GoogleLoggingOrganizationBucketConfigCmekSettings | undefined);
    private _kmsKeyName?;
    get kmsKeyName(): string;
    set kmsKeyName(value: string);
    get kmsKeyNameInput(): string | undefined;
    get kmsKeyVersionName(): string;
    get name(): string;
    get serviceAccountId(): string;
}
export interface GoogleLoggingOrganizationBucketConfigIndexConfigs {
    /**
    * The LogEntry field path to index.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_logging_organization_bucket_config#field_path GoogleLoggingOrganizationBucketConfig#field_path}
    */
    readonly fieldPath: string;
    /**
    * The type of data in this index
    * Note that some paths are automatically indexed, and other paths are not eligible for indexing. See [indexing documentation]( https://cloud.google.com/logging/docs/view/advanced-queries#indexed-fields) for details.
    * For example: jsonPayload.request.status
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_logging_organization_bucket_config#type GoogleLoggingOrganizationBucketConfig#type}
    */
    readonly type: string;
}
export declare function googleLoggingOrganizationBucketConfigIndexConfigsToTerraform(struct?: GoogleLoggingOrganizationBucketConfigIndexConfigs | cdktf.IResolvable): any;
export declare function googleLoggingOrganizationBucketConfigIndexConfigsToHclTerraform(struct?: GoogleLoggingOrganizationBucketConfigIndexConfigs | cdktf.IResolvable): any;
export declare class GoogleLoggingOrganizationBucketConfigIndexConfigsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleLoggingOrganizationBucketConfigIndexConfigs | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleLoggingOrganizationBucketConfigIndexConfigs | cdktf.IResolvable | undefined);
    private _fieldPath?;
    get fieldPath(): string;
    set fieldPath(value: string);
    get fieldPathInput(): string | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
}
export declare class GoogleLoggingOrganizationBucketConfigIndexConfigsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleLoggingOrganizationBucketConfigIndexConfigs[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleLoggingOrganizationBucketConfigIndexConfigsOutputReference;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_logging_organization_bucket_config google_logging_organization_bucket_config}
*/
export declare class GoogleLoggingOrganizationBucketConfig extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_logging_organization_bucket_config";
    /**
    * Generates CDKTF code for importing a GoogleLoggingOrganizationBucketConfig resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the GoogleLoggingOrganizationBucketConfig to import
    * @param importFromId The id of the existing GoogleLoggingOrganizationBucketConfig that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_logging_organization_bucket_config#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the GoogleLoggingOrganizationBucketConfig to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/5.21.0/docs/resources/google_logging_organization_bucket_config google_logging_organization_bucket_config} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleLoggingOrganizationBucketConfigConfig
    */
    constructor(scope: Construct, id: string, config: GoogleLoggingOrganizationBucketConfigConfig);
    private _bucketId?;
    get bucketId(): string;
    set bucketId(value: string);
    get bucketIdInput(): string | undefined;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get lifecycleState(): string;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    get name(): string;
    private _organization?;
    get organization(): string;
    set organization(value: string);
    get organizationInput(): string | undefined;
    private _retentionDays?;
    get retentionDays(): number;
    set retentionDays(value: number);
    resetRetentionDays(): void;
    get retentionDaysInput(): number | undefined;
    private _cmekSettings;
    get cmekSettings(): GoogleLoggingOrganizationBucketConfigCmekSettingsOutputReference;
    putCmekSettings(value: GoogleLoggingOrganizationBucketConfigCmekSettings): void;
    resetCmekSettings(): void;
    get cmekSettingsInput(): GoogleLoggingOrganizationBucketConfigCmekSettings | undefined;
    private _indexConfigs;
    get indexConfigs(): GoogleLoggingOrganizationBucketConfigIndexConfigsList;
    putIndexConfigs(value: GoogleLoggingOrganizationBucketConfigIndexConfigs[] | cdktf.IResolvable): void;
    resetIndexConfigs(): void;
    get indexConfigsInput(): cdktf.IResolvable | GoogleLoggingOrganizationBucketConfigIndexConfigs[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
